/**
 * @brief           DMAC Primitive Header
 * @author          AXELL CORPORATION
 * @description     DMAC Primitive񋟃wb_B<p>DMAC PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_12_27  [SDK3.0] AG903dlAX51903_DS06.pdf̏C𔽉f (#2633)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef _DMACPRM_H_
#define _DMACPRM_H_
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

/** DMAC`l */
#define AG903_DMAC_UNIT_NUM 		(8)

/** DMACnhVF[N|[g dma_req[n]/dma_ack[n] */
#define AG903_DMAC_PORT_NUM 		(16)

/** DMACCxg */
#define AG903_DMAC_EVENT_NUM 		(8)

/** 1D]̍ő]TCY */
#define AG903_DMAC_1DTRANS_MAX		(0x3FFFFF)

/* DMAC COMMON INTERFACE */

/** DMACHW_FEATURE WX^̒lێp\ */
typedef struct _DMACPrmParamFEATURE {
	uint32_t ChNum;			/** [2:0] DMA`l̐ */
	uint32_t UnalignMode;	/** [3] AC][h̍\ */
	uint32_t DWidth;		/** [5:4] oXi}X^j̃f[^oX */
	uint32_t SLVDWidth;		/** [7:6] oXiX[uj̃f[^oX */
	uint32_t DFDepth;		/** [10:8] f[^FIFO̒i */
	uint32_t PriOn;			/** [12] DMANGXgC^[tF[X */
	uint32_t PriNum;		/** [19:16] DMANGXg̃yȂg */
	uint32_t LdmOn;			/** [20] fBXNv^̍\ */
	uint32_t LdmDepth;		/** [25:24] fBXNv^̒i */
	uint32_t CmdDepth;		/** [29:28] ǂݏo^݃R}hL[̒i */
}DMACPrmParamFEATURE;

void AG903_DMACPrmGetINT(uint32_t *stat);
void AG903_DMACPrmGetTIMECOUNT_INT(uint32_t *stat);
void AG903_DMACPrmSetTIMECOUNT_INT_CLEAR(uint32_t clear);
void AG903_DMACPrmGetERR_ABORT_INT(uint32_t *err, uint32_t *wdt, uint32_t *abt);
void AG903_DMACPrmSetERR_ABORT_INT_CLEAR(uint32_t err, uint32_t wdt, uint32_t abt);
void AG903_DMACPrmGetTIMECOUNT_STATUS(uint32_t *stat);
void AG903_DMACPrmGetERR_ABORT_STATUS(uint32_t *err, uint32_t *wdt, uint32_t *abt);
void AG903_DMACPrmGetCHANNEL_ENABLE(uint32_t *enable);
void AG903_DMACPrmSetCHANNEL_ENABLE(uint32_t enable);
void AG903_DMACPrmGetSYNC_PERI_IF(uint32_t *enable);
void AG903_DMACPrmSetSYNC_PERI_IF(uint32_t enable);
void AG903_DMACPrmGetLOCAL_DESC_MEM_BASE(uint32_t *base);
void AG903_DMACPrmSetLOCAL_DESC_MEM_BASE(uint32_t base);
void AG903_DMACPrmGetWATCHDOG_TIMER(uint32_t *wdt);
void AG903_DMACPrmSetWATCHDOG_TIMER(uint32_t wdt);
void AG903_DMACPrmGetGLOBAL_EVENT(uint32_t *event);
void AG903_DMACPrmSetGLOBAL_EVENT(uint32_t set, uint32_t clear);
void AG903_DMACPrmGetPSLVERR_ENABLE(uint32_t *enable);
void AG903_DMACPrmSetPSLVERR_ENABLE(uint32_t enable);
void AG903_DMACPrmGetREVISION_NUMBER(uint32_t *rev);
void AG903_DMACPrmGetHW_FEATURE(DMACPrmParamFEATURE *feature);
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_0(uint32_t *flag);
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_0(uint32_t flag);
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_1(uint32_t *flag);
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_1(uint32_t flag);
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_2(uint32_t *flag);
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_2(uint32_t flag);
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_3(uint32_t *flag);
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_3(uint32_t flag);
void AG903_DMACPrmGetENDIAN_CONVERSION(uint32_t *ec, uint32_t *lmec);
void AG903_DMACPrmSetENDIAN_CONVERSION(uint32_t ec, uint32_t lmec);
void AG903_DMACPrmGetCONSTANT_VALUE_WRITE_ONLY(uint32_t *value);
void AG903_DMACPrmSetCONSTANT_VALUE_WRITE_ONLY(uint32_t value);

/* DMACn INTERFACE */

/** DMACnCTRL_REG WX^̒lێp\ */
typedef struct _DMACPrmParamCTRL {
	uint32_t ChWEvent;		/** [7:0] `l̃Cxgҋ@ */
	uint32_t WSync;			/** [8] Ō̏݊̑ҋ@ */
	uint32_t ChSEvent;		/** [11:9] `l̃Cxg */
	uint32_t SEventEn;		/** [12] Cxgݒ */
	uint32_t WEventEn;		/** [13] Cxgҋ@ */
	uint32_t DEn;			/** [14] 2D] */
	uint32_t ExpEn;			/** [15] g */
	uint32_t ChEn;			/** [16] `l */
	uint32_t WDTEn;			/** [17] EHb`hbO^C} */
	uint32_t DstCtrl;		/** [19:18] ]o[Xg^Cv̐@ */
	uint32_t SrcCtrl;		/** [21:20] ]o[Xg^Cv̐@ */
	uint32_t DstWidth;		/** [24:22] ]̃f[^ */
	uint32_t SrcWidth;		/** [27:25] ]̃f[^ */
	uint32_t TCMsk;			/** [28] ^[~iJEg̃}XN */
	uint32_t SrcTcnt;		/** [31:29] 1DMAnhVFCN̓]]JEgP */
}DMACPrmParamCTRL;

/** DMACnCFG_REG WX^̒lێp\ */
typedef struct _DMACPrmParamCFG {
	uint32_t TCIntMsk;		/** [0] ^[~iJEg荞݃}XN */
	uint32_t ErrIntMsk;		/** [1] `lG[荞݃}XN */
	uint32_t AbtIntMsk;		/** [2] `lA{[g荞݃}XN */
	uint32_t SrcRS;			/** [6:3] ]nhVFCNṽ\[X */
	uint32_t SrcHEn;		/** [7] ]nhVFCN */
	uint32_t DstRS;			/** [12:9] ]nhVFCNṽ\[X */
	uint32_t DstHEn;		/** [13] ]nhVFCN */
	uint32_t LLPCnt;		/** [19:16] NXg|C^JE^ */
	uint32_t ChGntWin;		/** [27:20] `lA[rg[VEBhẼR}h */
	uint32_t ChPri;			/** [28] `lA[rg[VD揇 */
	uint32_t WOMode;		/** [30] ݐp[h */
	uint32_t UnalignMode;	/** [31] AC][h */
}DMACPrmParamCFG;

void AG903_DMACPrmGetCTRL_REG(uint8_t unit, DMACPrmParamCTRL *ctrl);
void AG903_DMACPrmSetCTRL_REG(uint8_t unit, DMACPrmParamCTRL *ctrl);
void AG903_DMACPrmGetCFG_REG(uint8_t unit, DMACPrmParamCFG *cfg);
void AG903_DMACPrmSetCFG_REG(uint8_t unit, DMACPrmParamCFG *cfg);
void AG903_DMACPrmGetSRC_ADDR(uint8_t unit, uint32_t *addr);
void AG903_DMACPrmSetSRC_ADDR(uint8_t unit, uint32_t addr);
void AG903_DMACPrmGetDST_ADDR(uint8_t unit, uint32_t *addr);
void AG903_DMACPrmSetDST_ADDR(uint8_t unit, uint32_t addr);
void AG903_DMACPrmGetLINK_LIST_POINTER(uint8_t unit, uint32_t *addr);
void AG903_DMACPrmSetLINK_LIST_POINTER(uint8_t unit, uint32_t addr);
void AG903_DMACPrmGetTRNS_SIZE_1D(uint8_t unit, uint32_t *cnt);
void AG903_DMACPrmSetTRNS_SIZE_1D(uint8_t unit, uint32_t cnt);
void AG903_DMACPrmGetTRNS_SIZE_2D(uint8_t unit, uint32_t *x_cnt, uint32_t *y_cnt);
void AG903_DMACPrmSetTRNS_SIZE_2D(uint8_t unit, uint32_t x_cnt, uint32_t y_cnt);
void AG903_DMACPrmGetSTRIDE_SRC_DST_ADDR(uint8_t unit, uint32_t *src, uint32_t *dst);
void AG903_DMACPrmSetSTRIDE_SRC_DST_ADDR(uint8_t unit, uint32_t src, uint32_t dst);

/* AX51903_DS06.pdfɂ郌WX^̕ύXւ̑Ή */
#define AG903_DMACPrmGetTERMCOUNT_INT		AG903_DMACPrmGetTIMECOUNT_INT
#define AG903_DMACPrmSetTERMCOUNT_INT_CLEAR	AG903_DMACPrmSetTIMECOUNT_INT_CLEAR
#define AG903_DMACPrmGetTERMCOUNT_STATUS	AG903_DMACPrmGetTIMECOUNT_STATUS

#ifdef __cplusplus
}
#endif
#endif
