/**
 * @brief           GVD API Header
 * @author          AXELL CORPORATION
 * @description     GVD API`
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2020_07_22  [SDK3.1] GVD̋~APIǉ (#2964)
 * @history         2020_07_22  [SDK3.1] GVDL郁̈w肷APIǉ (#2965)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2020 AXELL CORPORATION, all rights reserved.
 */

#ifndef GVD_H
#define GVD_H
/* DOM-IGNORE-END */

#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>

#include "gvd_error.h"
#include "gvd_api_params.h"

#ifndef GVD_MAX_ENUM
#define GVD_MAX_ENUM 0x7FFFFFFF
#endif

/** o͐I [GVD_SelectOutputModule] */
typedef enum {
    GVD_OUTMOD_NONE,	/** o͐Ȃ */
    GVD_OUTMOD_BMU,		/** o͐=BMU */
    GVD_OUTMOD_VRAM,	/** o͐=VRAM */
    GVD_OUTMOD_FORCE_SIZE            = GVD_MAX_ENUM /** sentinel */
} gvdOutMod;

/** R[obN֐̈ [GVD_SetCallbackParams] */
typedef struct {
    void *commit_output_buffer;		/** t[o͒ʒm */
    void *discard_input_buffer;		/** ̓obt@jʒm */
    void *discard_output_buffer;	/** o̓obt@jʒm */
    void *notify_frame_size;		/** t[TCYXVʒm */
    void *notify_decode_error;		/** fR[hG[ʒm */
    void *notify_stream_pos;		/** Xg[ʒu擾ʒm */
    void *decode_stream_end;		/** Đʒm */
    void *rewind_done;				/** ߂ʒm */
    void *seqparam_decode_done;		/** V[PXfR[hʒm */
} gvdCbParams;


/**
 * @brief           R[obN֐ [GVD_SetCallbackFunctions]
 * @description     GVDCůeʒm GVD_SetCallbackFunctions œo^邱Ƃł܂.<p>
 *                  ܂, gpȂʒm NULL o^邱ƂŖɂ邱Ƃł܂.<p>
 *                  eR[obN֐̏ڍׂ GVDR[obN֐ꗗ QƂĂ.
 */
typedef struct {
    gvdCbFunc connect_done;					/** ڑʒm */
    gvdCbFunc disconnect_done;				/** ؒfʒm */
    gvdCbFunc put_input_buffer_done;		/** ̓obt@tʒm */
    gvdCbFunc put_output_buffer_done;		/** o̓obt@tʒm */
    gvdCbFunc discard_output_buffers_done;	/** o̓obt@jtʒm */
    gvdCbFunc commit_output_buffer;			/** t[o͒ʒm */
    gvdCbFunc discard_input_buffer;			/** ̓obt@jʒm */
    gvdCbFunc discard_output_buffer;		/** o̓obt@jʒm */
    gvdCbFunc notify_frame_size;			/** t[TCYXVʒm */
    gvdCbFunc notify_decode_error;			/** fR[hG[ʒm */
    gvdCbFunc notify_stream_pos;			/** Xg[ʒu擾ʒm */
    gvdCbFunc decode_stream_end;			/** Đʒm */
    gvdCbFunc seek_done;					/** V[Nʒm */
    gvdCbFunc rewind_done;					/** ߂ʒm */
    gvdCbFunc pause_done;					/** ꎞ~ʒm */
    gvdCbFunc play_accepted;				/** Đtʒm */
    gvdCbFunc get_timestamp_done;			/** ^CX^v擾ʒm */
    gvdCbFunc rewind_accepted;				/** ߂tʒm */
    gvdCbFunc forward_accepted;				/** tʒm */
    gvdCbFunc seqparam_decode_done;			/** V[PXfR[hʒm */
} gvdCbFuncs;

/** ReLXg [GVD_GetStatus] */
typedef enum {
    GVD_APIFUNC_STATUS_CLOSE,	/** N[Y */
    GVD_APIFUNC_STATUS_PAUSE,	/** ~ */
    GVD_APIFUNC_STATUS_PLAY,	/** Đ */
    GVD_APIFUNC_STATUS_REWIND,	/** ߂ */
    GVD_APIFUNC_STATUS_FORWARD,	/** 蒆 */
    GVD_APIFUNC_STATUS_UNKNOWN,	/** s */
    GVD_APIFUNC_STATUS_FORCE_SIZE       = GVD_MAX_ENUM /** sentinel */
} gvdApiFuncStatus;

typedef struct gvdContext_s gvdContext;	/** GVDReLXg^ */

/**
 * @brief           GVDCup[^
 * @param           initparam [in] Cup[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     Cup[^܂.<p>
 *                  K{APIŃp[^̏sĂ.<p>
 *                  {APIŃp[^GVD_GetRequiredMemorySize,
 *                  GVD_SetWorkMemory, GVD_InitializesĂ.
 * @note            {API͓܂.
 * @seealso         gvdInitializeParam
 */
gvdError GVD_InitInitializeParam(gvdInitializeParam *initparam);
/**
 * @brief           [NTCYZo
 * @param           void
 * @return          [NTCY [Byte]
 * @description     GVDv郏[NTCYԂ܂.<p>
 *                  GVD_InitInitializeParamœ\ɃR[Ă.
 * @note            {API͓܂.
 * @seealso         GVD_SetWorkMemory
 */
uint32_t GVD_GetRequiredMemorySize(void);
/**
 * @brief           [Nݒ
 * @param           address [in] [N̈擪̃AhX
 * @param           size [in] [NTCY [Byte]
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     GVD[NƂĎgp郁̈ݒ肵܂.<p>
 *                  GVD_GetRequiredMemorySizeŎ擾TCYȏ̃mۂĂ.<p>
 *                  [N̐擪AhX32kBEɂKv܂.<p>
 *                  [N̈̑, LbVELƂĂ.
 * @note            {API͓܂.
 */
gvdError GVD_SetWorkMemory(void *address, size_t size);
/**
 * @brief           GVDCu
 * @param           void
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_FATALERR_MSVD_INIT_FAILURE hCos
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH s
 * @description     fR[_܂.
 * @seealso         GVD_InitInitializeParam, GVD_SetWorkMemory
 * @note            {API͓܂.
 * @note            {APĨR[, GVDCuTIM7L܂.
 */
gvdError GVD_Initialize(void);
/**
 * @brief           GVDCuI
 * @param           void
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_INVALID_STATE ԃG[i, cReLXgj
 * @description     fR[_̏Is܂.<p>
 *                  SẴReLXg̔jĂ{APIR[Ă.<p>
 *                  {APĨR[ȍ~͔񓯊͂ł܂. GVD_ExecuteR[Ȃł.
 * @note            {API͓܂.
 */
gvdError GVD_Finalize(void);
/**
 * @brief           񓯊̎s
 * @param           void
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_INVALID_STATE ԃG[ij
 * @description     񓯊s܂.<p>
 *                  GVDCuȍ~͖{APIIɎsĂ.<p>
 *                  {APȈGVDCuƃn[hEFAԂ̏܂݂܂.<p>
 *                  R[pxቺꍇ, fR[h\ɉe邱Ƃ܂.
 * @note            {API͓܂.
 */
gvdError GVD_Execute(void);
/**
 * @brief           ReLXg
 * @param           gvdctx [out] ReLXg̃|C^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH s
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     GVD̃ReLXg𐶐܂.<p>
 *                  gvdContext1̃Xg[̓Ԃێ܂.
 * @note            {API͓܂.
 * @seealso         gvdContext
 */
gvdError GVD_CreateContext(gvdContext **gvdctx);
/**
 * @brief           ReLXgp
 * @param           gvdctx [in] ReLXg
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     GVD̃ReLXgj܂.
 * @note            ReLXg̏Ԃ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_DestroyContext(gvdContext *gvdctx);
/**
 * @brief           ReLXgڑ
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgfR[_ɐڑ܂.<p>
 *                  Ot@CXg[}gpꍇ, {APIŃReLXgڑ܂.<p>
 *                  {APȈɂ, ReLXg̏Ԃ PAUSE ɑJڂ܂.
 * @note            t@CXg[}gpꍇ, GVD_OpenFilegpĂ.
 * @note            ReLXg̏Ԃ CLOSE łKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  connect_done QƂĂ.
 */
gvdError GVD_Connect(gvdContext *gvdctx, void *param_user);
/**
 * @brief           ReLXgؒf
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgfR[_ؒf܂.<p>
 *                  GVD_ConnectŐڑReLXgw肵Ă.<p>
 *                  {APȈɂ, ReLXg̏Ԃ CLOSE ɑJڂ܂.
 * @note            GVD_OpenFileŐڑReLXg{APIŐؒf邱Ƃ͂ł܂.
 * @note            ReLXgԂ PAUSE łKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  disconnect_done QƂĂ.
 */
gvdError GVD_Disconnect(gvdContext *gvdctx, void *param_user);
/**
 * @brief           Xg[I[vƃReLXgڑ
 * @param           gvdctx [in] ReLXg
 * @param           filename [in] t@C
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgfR[_ɐڑ܂.<p>
 *                  , filenameɎw肳ꂽXg[Xg[}Ɋ蓖Ă܂.<p>
 *                  {APȈɂ, ReLXg̏Ԃ PAUSE ɑJڂ܂.
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  connect_done QƂĂ.
 */
gvdError GVD_OpenFile(gvdContext *gvdctx, const char *filename, void *param_user);
/**
 * @brief           Xg[N[YƃReLXgؒf
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @retval          GVD_ERR_INVALID_CALL sȌĂяoit@CXg[}gpj
 * @description     gvdctxɓnꂽReLXgɊ蓖ĂꂽXg[}~, Xg[N[Y܂.<p>
 *                  , ReLXgfR[_ؒf܂.<p>
 *                  {APȈɂ, ReLXg̏Ԃ CLOSE ɑJڂ܂.
 * @note            ReLXgԂ PAUSE łKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  disconnect_done QƂĂ.
 */
gvdError GVD_CloseFile(gvdContext *gvdctx, void *param_user);
/**
 * @brief           Xg[obt@̋
 * @param           gvdctx [in] ReLXg
 * @param           ibufinf [in] ̓f[^
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @retval          GVD_ERR_INVALID_CALL sAPI ֐̌Ăяo
 * @description     Xg[͗p̃obt@GVDCu֋܂.<p>
 *                  OXg[}gpꍇ, Xg[{APIŃfR[_֋܂.<p>
 *                  ibufinfɂ̓Xg[f[^ȊOɂep[^Zbgł܂.<p>
 *                  ڍׂgvdInBufInfoQƂĂ.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ԋpʒm gvdCbFuncs  discard_input_buffer QƂĂ.
 */
gvdError GVD_PutInputBuffer(gvdContext *gvdctx, gvdInBufInfo *bufinf, void *param_user);
/**
 * @brief           o̓obt@
 * @param           gvdctx [in] ReLXg
 * @param           obufinf [in] o̓obt@
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @retval          GVD_ERR_INVALID_CALL sAPI ֐̌Ăяo
 * @description     fR[h摜o͗p̃obt@GVDCu֋܂.<p>
 *                  o͐VRAMgpꍇ, o̓obt@{APIŃfR[_֋܂.<p>
 *                  obufinfɂ̓t[f[^ȊOɂep[^ZbgĂ܂.<p>
 *                  ڍׂgvdOutBufInfoQƂĂ.
 * @note            ReLXg̏o͐悪 VRAM łKv܂.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ԋpʒm gvdCbFuncs  discard_output_buffer QƂĂ.
 */
gvdError GVD_PutOutputBuffer(gvdContext *gvdctx, gvdOutBufInfo *obufinf, void *param_user);
/**
 * @brief           o̓obt@j
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXgɋĂo̓obt@̕ԋpv܂.<p>
 *                  GVD_PutOutputBufferŋĂ, discard_output_buffer̃R[obNŕԋpĂȂobt@̕ԋpv𔭍s܂.<p>
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ԋpʒm gvdCbFuncs  discard_output_buffer QƂĂ.
 */
gvdError GVD_DiscardOutputBuffers(gvdContext *gvdctx, void *param_user);
/**
 * @brief           R[obNݒp[^
 * @param           cbfuncs [in] GVD_SetCallbackFunctionsɗ^\
 * @param           cbparams [in] GVD_SetCallbackParamsɗ^\
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @description     GVD_SetCallbackParamsGVD_SetCallbackFunctionsɓn\̂̏s܂.<p>
 *                  ǂ炩݂̂ꍇ͂NULLw肵Ă.
 * @note            {API͓܂.
 */
gvdError GVD_InitCallbackInfo(gvdCbFuncs *cbfuncs, gvdCbParams *cbparams);
/**
 * @brief           R[obN֐̈ݒ
 * @param           gvdctx [in] ReLXg
 * @param           cbparams [in] R[obN֐
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     ꕔ̃R[obN֐̈ݒ肵܂.<p>
 *                  ݒlɂĂ, gvdCbParams QƂĂ.
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SetCallbackParams(gvdContext *gvdctx, gvdCbParams *cbparams);
/**
 * @brief           R[obN֐ݒ
 * @param           gvdctx [in] ReLXg
 * @param           cbfuncs [in] R[obN֐
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE API ֐̌Ăяo֎~ĂXe[g
 * @description     R[obN֐ݒ肵܂.<p>
 *                  ݒlɂĂ, gvdCbFuncs QƂĂ.
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SetCallbackFunctions(gvdContext *gvdctx, gvdCbFuncs *cbfuncs);
/**
 * @brief           o͐I
 * @param           gvdctx [in] ReLXg
 * @param           omod [in] o͐
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_RESOURCE_NOT_ENOUGH BMUo͐
 * @retval          GVD_ERR_INVALID_STATE ڑԂł̌Ăяo
 * @description     ReLXg̏o͐ݒ肵܂.<p>
 * @note            o͐悪BMŨReLXg, ő4`ł܂.
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SelectOutputModule(gvdContext *gvdctx, gvdOutMod omod);
/**
 * @brief           BMU ID擾
 * @param           gvdctx [in] ReLXg
 * @param           bmuid [out] BMUIDi[
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     蓖ĂꂽBMUID擾܂.
 * @note            ReLXg̏o͐悪BMUłKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_GetBMUId(gvdContext *gvdctx, int32_t *bmuid);
/**
 * @brief           BMUo͐AhXݒ
 * @param           gvdctx [in] ReLXg
 * @param           addr [in] o͐AhX
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     BMUo͐AhXݒ肵܂.<p>
 *                  mۂBMŨeNX`ɑ΂AhX̎擾@͊֘ANQƂĂ.
 * @seealso         AG903_BMUMgrGetBMUSrcAddress
 * @note            ReLXg̏o͐悪BMUłKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SetBMUAddr(gvdContext *gvdctx, void *addr);
/**
 * @brief           T[`Wݒ
 * @param           gvdctx [in] ReLXg
 * @param           range [in] T[`Wݒl [Byte]
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_SUCCESS I
 * @description     fR[_ɐݒ肷T[`Ww肵܂.<p>
 *                  Xg[͎, fR[hJnn_̌osTCY(Byte)ł.<p>
 *                  T[`W "0" ݒ肵ꍇ, ȂƂȂ܂.
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SetSearchRange(gvdContext *gvdctx, uint32_t range);
/**
 * @brief           T[`Wݒl擾
 * @param           gvdctx [in] ReLXg
 * @param           range [out] T[`Wݒl [Byte]
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     ݒ肳ĂT[`W̒l擾܂.
 * @note            {API͓܂.
 */
gvdError GVD_GetSearchRange(gvdContext *gvdctx, uint32_t *range);
/**
 * @brief           fR[hpq[v̈ݒ
 * @param           gvdctx [in] ReLXg
 * @param           heap [in] q[v̈̃AhX
 * @param           size [in] q[v̈̃TCY [Byte]
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_SUCCESS I
 * @description     fR[_gpq[v̈ݒ肵܂.<p>
 *                  q[v̈̕KvTCY̓Xg[Ɉˑ܂, ȉ̎ŊTZl߂邱Ƃł܂.<p>
 *                  HEAP(approx.)[Byte] = 2.5 * Width[px] * Height[px] * (Refs + 1)<p>
 *                  Width:t[, Height:t[, Refs:Qƃt[
 * @note            ݒ肷AhX 2048oCgE ɂKv܂.
 *                  q[v̈̑, LbVELƂĂ.
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SetOutputHeap(gvdContext *gvdctx, void *heap, size_t size);
/**
 * @brief           ʒuobt@ݒ
 * @param           gvdctx [in] ReLXg
 * @param           buffer [in] ʒuobt@̃AhX
 * @param           size [in] ʒuobt@̃TCYio^j
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @note            ReLXgԂ CLOSE łKv܂.
 * @note            {API͓܂.
 */
gvdError GVD_SetPositionBuffer(gvdContext *gvdctx, void *buffer, size_t size);
/**
 * @brief           ReLXgԎ擾
 * @param           gvdctx [in] ReLXg
 * @param           status [out] ReLXg
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXg̏Ԃ擾܂.<p>
 *                  eԂ̐ gvdApiFuncStatus ^QƂĂ.
 * @note            {API͓܂.
 * @seealso         gvdApiFuncStatus
 */
gvdError GVD_GetStatus(gvdContext *gvd, gvdApiFuncStatus *status);
/**
 * @brief           ^CX^v擾
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     ŐṼ^CX^v̒ʒmv܂.<p>
 *                  ʒmɂĂ, gvdTimeStamp QƂĂ.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  get_timestamp_done QƂĂ.
 */
gvdError GVD_GetTimeStamp(gvdContext *gvd, void *param_user);
/**
 * @brief           ĐJnv
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgɍĐv𔭍s܂.<p>
 *                  Đv, ReLXgԂ PLAY ɑJڂ܂.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  play_accepted QƂĂ.
 */
gvdError GVD_Play(gvdContext *gvdctx, void *param_user);
/**
 * @brief           ꎞ~v
 * @param           gvdctx [in] ReLXg
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgɈꎞ~v𔭍s܂.<p>
 *                  ꎞ~v, ReLXgԂ PAUSE ɑJڂ܂.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  pause_done QƂĂ.
 */
gvdError GVD_Pause(gvdContext *gvd, void *param_user);
/**
 * @brief           v
 * @param           gvdctx [in] ReLXg
 * @param           n_speed [in] 葬x(1ȏ)
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgɑv𔭍s܂.<p>
 *                  v, ReLXgԂ FORWARD ɑJڂ܂.
 * @note            ̑x(n_speed)1ȏłKv܂.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  forward_accepted QƂĂ.
 */
gvdError GVD_Forward(gvdContext *gvd, uint32_t n_speed, void *param_user);
/**
 * @brief           ߂v
 * @param           gvdctx [in] ReLXg
 * @param           n_speed [in] ߂x(1ȏ)
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgɑ߂v𔭍s܂.<p>
 *                  ߂v, ReLXgԂ REWIND ɑJڂ܂.
 * @note            ߂̑x(n_speed)1ȏłKv܂.
 * @note            ʒuobt@o^ĂKv܂.
 * @note            ReLXgԂ CLOSE ȊOłKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  rewind_accepted QƂĂ.
 */
gvdError GVD_Rewind(gvdContext *gvd, uint32_t n_speed, void *param_user);
/**
 * @brief           V[N
 * @param           gvdctx [in] ReLXg
 * @param           seekparam [in] V[Np[^
 * @param           param_user [in] [U[p[^
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     seekparam̓eɏ]čĐʒuύX܂.<p>
 *                  ʒuobt@̐/Έʒu, Xg[̃oCgʒu3ʂ肩wł܂.
 * @note            ʒuobt@̈ʒuw肷ꍇ, ʒuobt@o^ĂKv܂.
 * @note            ReLXgԂ PAUSE łKv܂.
 * @note            {API͔񓯊܂. ʒm gvdCbFuncs  seek_done QƂĂ.
 */
gvdError GVD_Seek(gvdContext *gvd, gvdSeekParam *seekparam, void *param_user);
/**
 * @brief           FatalErrorv擾
 * @param           fatalerror [out] FatalErrorv
 * @return          GVD̃G[R[h
 * @description     FatalError̔ReLXgƂ̗v擾܂.
 * @note            {API͓܂.
 * @seealso         gvdFatalErrorInfo
 */
void GVD_GetFatalError(gvdFatalErrorInfo *fatalerror);
/**
 * @brief           ̓obt@ݒ
 * @param           gvdctx [in] ReLXg
 * @param           max_num_inputbuffers [in] ͉\ȃobt@̍ő吔
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXgɋł̓obt@̏ݒ肵܂.<p>
 *                  {APIŐݒ肵ȏ̓̓obt@͋łȂȂ܂(֘AAPI̓G[Ԃ܂).<p>
 *                  }`Xg[Đ, ̓obt@gp鐔ReLXgԂŒ߂邱Ƃł܂.
 * @note            SẴReLXg̓̓obt@̑a, GVDɐݒ肵̓obt@̐𒴂邱Ƃ͂ł܂.
 */
gvdError GVD_SetMaxNumInputBuffers(gvdContext *gvdctx, size_t max_num_inputbuffers);
/**
 * @brief           ̓obt@擾
 * @param           gvdctx [in] ReLXg
 * @param           max_num_inputbuffers [out] ͉\ȃobt@̍ő吔
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXgɋł̓obt@̏擾܂.
 */
gvdError GVD_GetMaxNumInputBuffers(gvdContext *gvdctx, size_t *max_num_inputbuffers);
/**
 * @brief           o̓obt@ݒ
 * @param           gvdctx [in] ReLXg
 * @param           max_num_outputbuffers [in] o͗pobt@̍ő吔
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXgɋło̓obt@̏ݒ肵܂.
 */
gvdError GVD_SetMaxNumOutputBuffers(gvdContext *gvdctx, size_t max_num_outputbuffers);
/**
 * @brief           o̓obt@擾
 * @param           gvdctx [in] ReLXg
 * @param           max_num_outputbuffers [out] o͗pobt@̍ő吔
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXgɋło̓obt@̏擾܂.
 */
gvdError GVD_GetMaxNumOutputBuffers(gvdContext *gvdctx, size_t *max_num_outputbuffers);
/**
 * @brief           I/Pϊݒ
 * @param           gvdctx [in] ReLXg
 * @param           enable [in] IPϊݒ(L:true,:false)
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @description     gvdctxɓnꂽReLXgI/PϊH̓ݒ܂.
 */
gvdError GVD_SetIPConv(gvdContext *gvdctx, _Bool enable);
/**
 * @brief           I/Pϊݒ擾
 * @param           gvdctx [in] ReLXg
 * @param           enable [out] IPϊݒ
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     gvdctxɓnꂽReLXgI/PϊH̓ݒ擾܂.
 */
gvdError GVD_GetIPConv(gvdContext *gvdctx, _Bool *enable);
/**
 * @brief           vIG[ǗAhXݒ
 * @param           address [in] 擪AhX
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     addressɎw肳ꂽAhXŒvIG[Ԃ̊Ǘs܂.<p>
 *                  vIG[Ǘ̈̃TCY 4[Byte] ł.<p>
 *                  {APIGVD_InitializȇOɃR[Ă.
 */
gvdError GVD_SetFatalErrorAddress(void *address);
/**
 * @brief           GVDL擪AhXݒ
 * @param           address [in] 擪AhX
 * @return          GVD̃G[R[h
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_BAD_PARAMETER ɕsȃp[^^ꂽ
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     GVDCuL郁̈̐擪AhXݒ肵܂.<p>
 *                  L郁TCY 16[KiB] ł.<p>
 *                  addressɐݒ肷AhX 4[KB] EłKv܂.<p>
 *                  w肷郁̈̓LbVłKv܂.<p>
 *                  {APIGVD_InitializȇOɃR[Ă.
 */
gvdError GVD_SetOccupyMemoryAddress(void *address);
/**
 * @brief           GVD̋~
 * @return          GVD̃G[R[h
 * @param           gvdctx [in] ReLXg
 * @retval          GVD_ERR_SUCCESS I
 * @retval          GVD_ERR_INVALID_STATE Ăяo֎~ĂXe[g
 * @description     GVDIɒ~܂B<p>
 *                  {APIɂ鋭~̊, vIG[̃R[obNŒʒm܂.<p>
 *                  ~̕AɂĂ, Zbg܂͒vIG[̕A菇KvƂȂ܂.<p>
 *                  NULLnƁAID=0Ƃďs܂.
 */
gvdError GVD_ForcedShutdown(gvdContext *gvdctx);

#endif /* GVD_H */
