/**
 * @brief           GVD Error Header
 * @author          AXELL CORPORATION
 * @description     GVD G[`
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2020_07_22  [SDK3.1] GVD̋~APIǉ (#2964)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2020 AXELL CORPORATION, all rights reserved.
 */

#ifndef GVD_ERROR_H
#define GVD_ERROR_H
/* DOM-IGNORE-END */

#include <stdint.h>

#ifndef GVD_MAX_ENUM
/** eunmsentinell (INT_MAX) */
#define GVD_MAX_ENUM 0x7FFFFFFF
#endif


/** @brief GVD API ֐Qʂ̖߂l̒` */
typedef enum {
    GVD_ERR_SUCCESS                             =  0,  /** I */
    GVD_ERR_RESOURCE_NOT_ENOUGH                 = -1,  /** \[Xs<p>mێsȂǂŔ */
    GVD_ERR_BAD_PARAMETER                       = -2,  /** s */
    GVD_ERR_INVALID_STREAM                      = -3,  /** sȃXg[ */
    GVD_ERR_INVALID_STREAM_SE                   = -4,  /** sȃXg[ [V[PXf[^͒] */
    GVD_ERR_FILE_OPERATION_FAILURE              = -5,  /** t@CG[ */
    GVD_ERR_INVALID_STATE                       = -6,  /** Xe[gG[[YAPI֐̌Ăяo֎~] */
    GVD_ERR_STREAMDATA_NOT_ENOUGH               = -7,  /** Xg[s\ */
    GVD_ERR_STREAMDATA_NOT_ENOUGH_SE            = -8,  /** Xg[I[B[V[PXf[^͒] */
    GVD_ERR_INVALID_CALL                        = -9,  /** API֐sK؎gp<p>Xg[}gp GVD_PutInputBuffer ȂǂŔ */
    GVD_ERR_FATAL                               = -10, /** vIG[ */
    GVD_ERR_NOT_SUPPORTED                       = -11, /** T|[gOXg[ */
    GVD_ERR_NOT_SUPPORTED_SE                    = -12, /** T|[gOXg[[V[PXf[^̓͒] */
    GVD_ERR_OUTPUT_CONCEALED                    = -13, /** o̓t[sS */
    GVD_ERR_DECODER_INIT_ERROR                  = -14, /** fR[_W[G[ */
    GVD_ERR_DECODER_ERROR_STATE                 = -15, /** fR[_W[G[Ԍo */
    GVD_ERR_FILE_OPERATION_TIMEDOUT             = -20, /** t@C^CAEg<p>gvdFileRead ŕԂƃgC邱Ƃł܂ */
    GVD_ERR_UNKNOWN                             = -99, /** m̃G[ */
    GVD_ERR_FORCE_SIZE                          = GVD_MAX_ENUM /** sentinel */
} gvdError;


/**
 * @brief           vIG[ʒmp\
 * @description     vIG[<p>
 *                  v̒lƃG[e͈ȉ̒ʂ<p>
 *                  <table>
 *                  <tr><th>v</th><th>e</th></tr>
 *                  <tr><td>-0</td><td>vIG[</td></tr>
 *                  <tr><td>-1,-2</td><td>q[v̌͊</td></tr>
 *                  <tr><td>-4</td><td>Mutex̎s</td></tr>
 *                  <tr><td>-5</td><td>t@C̎s</td></tr>
 *                  <tr><td>-6,-7,-8,-9,-10,-15</td><td>[Ň͊</td></tr>
 *                  <tr><td>-11,-12</td><td>̓obt@̌͊</td></tr>
 *                  <tr><td>-13,-14</td><td>o̓obt@̌͊</td></tr>
 *                  <tr><td>-18</td><td>ʒuobt@s</td></tr>
 *                  <tr><td>-80</td><td>[Uɂ鋭~</td></tr>
 *                  <tr><td>̑</td><td>G[</td></tr>
 *                  </table>
 */
typedef struct {
    int32_t cause;			/** vIG[v */
    uint8_t context_id;		/** ReLXgID */
} gvdFatalErrorInfo;

#endif /* GVD_ERROR_H */
