/**
 * @brief           GPIO Register Definition
 * @author          AXELL CORPORATION
 * @description     GPIO Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_GPIO_REGMAP_H_
#define _AG903_GPIO_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** GPIOn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  DTOUT;
    };

    union {
        __I  uint32_t  DTIN;
    };

    union {
        __IO uint32_t  DIR;
    };

    union {
        __IO uint32_t  IOTYPE;
    };

    union {
        __IO uint32_t  POSEDGE;
    };

    union {
        __IO uint32_t  NEGEDGE;
    };

    union {
        __I  uint32_t  EDGESTAT;
    };

    union {
        __O  uint32_t  EDGECLR;
    };

    union {
        __IO uint32_t  INTMASK;
    };

/* DOM-IGNORE-END */
}AG903_GPIOn_Type;

#define AG903_GPIOn(ch)                          ((volatile AG903_GPIOn_Type *)(AG903_GPIO0_BASE + 0x100000 * ch))       /** GPIOn Base Address (n=0..3) */
#define AG903_GPIOn_DTOUT(ch)                    AG903_GPIOn(ch)->DTOUT                                                  /** GPIOnDTOUT Address (n=0..3) */
#define AG903_GPIOn_DTIN(ch)                     AG903_GPIOn(ch)->DTIN                                                   /** GPIOnDTIN Address (n=0..3) */
#define AG903_GPIOn_DIR(ch)                      AG903_GPIOn(ch)->DIR                                                    /** GPIOnDIR Address (n=0..3) */
#define AG903_GPIOn_IOTYPE(ch)                   AG903_GPIOn(ch)->IOTYPE                                                 /** GPIOnIOTYPE Address (n=0..3) */
#define AG903_GPIOn_POSEDGE(ch)                  AG903_GPIOn(ch)->POSEDGE                                                /** GPIOnPOSEDGE Address (n=0..3) */
#define AG903_GPIOn_NEGEDGE(ch)                  AG903_GPIOn(ch)->NEGEDGE                                                /** GPIOnNEGEDGE Address (n=0..3) */
#define AG903_GPIOn_EDGESTAT(ch)                 AG903_GPIOn(ch)->EDGESTAT                                               /** GPIOnEDGESTAT Address (n=0..3) */
#define AG903_GPIOn_EDGECLR(ch)                  AG903_GPIOn(ch)->EDGECLR                                                /** GPIOnEDGECLR Address (n=0..3) */
#define AG903_GPIOn_INTMASK(ch)                  AG903_GPIOn(ch)->INTMASK                                                /** GPIOnINTMASK Address (n=0..3) */

#define AG903_GPIO0                              ((volatile AG903_GPIOn_Type *) AG903_GPIO0_BASE)                        /** GPIOn Base Address */
#define AG903_GPIO1                              ((volatile AG903_GPIOn_Type *) AG903_GPIO1_BASE)                        /** GPIOn Base Address */
#define AG903_GPIO2                              ((volatile AG903_GPIOn_Type *) AG903_GPIO2_BASE)                        /** GPIOn Base Address */
#define AG903_GPIO3                              ((volatile AG903_GPIOn_Type *) AG903_GPIO3_BASE)                        /** GPIOn Base Address */


#define AG903_GPIOn_DTOUT_BIT_POS                          0                                                             /** GPIOnDTOUT BIT-bit position */
#define AG903_GPIOn_DTOUT_BIT_MSK                          (0xffffffffUL << AG903_GPIOn_DTOUT_BIT_POS)                   /** GPIOnDTOUT BIT-bit mask */

#define AG903_GPIOn_DTIN_BIT_POS                           0                                                             /** GPIOnDTIN BIT-bit position */
#define AG903_GPIOn_DTIN_BIT_MSK                           (0xffffffffUL << AG903_GPIOn_DTIN_BIT_POS)                    /** GPIOnDTIN BIT-bit mask */

#define AG903_GPIOn_DIR_BIT_POS                            0                                                             /** GPIOnDIR BIT-bit position */
#define AG903_GPIOn_DIR_BIT_MSK                            (0xffffffffUL << AG903_GPIOn_DIR_BIT_POS)                     /** GPIOnDIR BIT-bit mask */

#define AG903_GPIOn_IOTYPE_BIT_POS                         0                                                             /** GPIOnIOTYPE BIT-bit position */
#define AG903_GPIOn_IOTYPE_BIT_MSK                         (0xffffffffUL << AG903_GPIOn_IOTYPE_BIT_POS)                  /** GPIOnIOTYPE BIT-bit mask */

#define AG903_GPIOn_POSEDGE_BIT_POS                        0                                                             /** GPIOnPOSEDGE BIT-bit position */
#define AG903_GPIOn_POSEDGE_BIT_MSK                        (0xffffffffUL << AG903_GPIOn_POSEDGE_BIT_POS)                 /** GPIOnPOSEDGE BIT-bit mask */

#define AG903_GPIOn_NEGEDGE_BIT_POS                        0                                                             /** GPIOnNEGEDGE BIT-bit position */
#define AG903_GPIOn_NEGEDGE_BIT_MSK                        (0xffffffffUL << AG903_GPIOn_NEGEDGE_BIT_POS)                 /** GPIOnNEGEDGE BIT-bit mask */

#define AG903_GPIOn_EDGESTAT_BIT_POS                       0                                                             /** GPIOnEDGESTAT BIT-bit position */
#define AG903_GPIOn_EDGESTAT_BIT_MSK                       (0xffffffffUL << AG903_GPIOn_EDGESTAT_BIT_POS)                /** GPIOnEDGESTAT BIT-bit mask */

#define AG903_GPIOn_EDGECLR_BIT_POS                        0                                                             /** GPIOnEDGECLR BIT-bit position */
#define AG903_GPIOn_EDGECLR_BIT_MSK                        (0xffffffffUL << AG903_GPIOn_EDGECLR_BIT_POS)                 /** GPIOnEDGECLR BIT-bit mask */

#define AG903_GPIOn_INTMASK_BIT_POS                        0                                                             /** GPIOnINTMASK BIT-bit position */
#define AG903_GPIOn_INTMASK_BIT_MSK                        (0xffffffffUL << AG903_GPIOn_INTMASK_BIT_POS)                 /** GPIOnINTMASK BIT-bit mask */

#endif /* _AG903_GPIO_REGMAP_H_ */

