/**
 * @brief           SMC Register Definition
 * @author          AXELL CORPORATION
 * @description     SMC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SMC_REGMAP_H_
#define _AG903_SMC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SMC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  CONFIG_0;

        struct {
            __IO uint32_t  BNK_MBW                        :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  BNK_SIZE                       :  4;
            __IO uint32_t  BNK_TYP3                       :  1;
            __IO uint32_t  BNK_TYP2                       :  1;
            __IO uint32_t  BNK_TYP1                       :  1;
            __IO uint32_t  BNK_WPROT                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  BNK_BASE                       : 13;
            __IO uint32_t  BNK_EN                         :  1;
        } CONFIG_0_bits;
    };

    union {
        __IO uint32_t  TIMING_0;

        struct {
            __IO uint32_t  TRNA                           :  4;
            __IO uint32_t  AHT                            :  2;
            __IO uint32_t  WTC                            :  2;
            __IO uint32_t  AT2                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  AT1                            :  4;
            __IO uint32_t  CTW                            :  2;
            __IO uint32_t  AST                            :  2;
            __IO uint32_t  RBE                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  EAT1                           :  4;
            __IO uint32_t  ETRNA                          :  4;
        } TIMING_0_bits;
    };

    union {
        __IO uint32_t  CONFIG_1;

        struct {
            __IO uint32_t  BNK_MBW                        :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  BNK_SIZE                       :  4;
            __IO uint32_t  BNK_TYP3                       :  1;
            __IO uint32_t  BNK_TYP2                       :  1;
            __IO uint32_t  BNK_TYP1                       :  1;
            __IO uint32_t  BNK_WPROT                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  BNK_BASE                       : 13;
            __IO uint32_t  BNK_EN                         :  1;
        } CONFIG_1_bits;
    };

    union {
        __IO uint32_t  TIMING_1;

        struct {
            __IO uint32_t  TRNA                           :  4;
            __IO uint32_t  AHT                            :  2;
            __IO uint32_t  WTC                            :  2;
            __IO uint32_t  AT2                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  AT1                            :  4;
            __IO uint32_t  CTW                            :  2;
            __IO uint32_t  AST                            :  2;
            __IO uint32_t  RBE                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  EAT1                           :  4;
            __IO uint32_t  ETRNA                          :  4;
        } TIMING_1_bits;
    };

    union {
        __IO uint32_t  CONFIG_2;

        struct {
            __IO uint32_t  BNK_MBW                        :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  BNK_SIZE                       :  4;
            __IO uint32_t  BNK_TYP3                       :  1;
            __IO uint32_t  BNK_TYP2                       :  1;
            __IO uint32_t  BNK_TYP1                       :  1;
            __IO uint32_t  BNK_WPROT                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  BNK_BASE                       : 13;
            __IO uint32_t  BNK_EN                         :  1;
        } CONFIG_2_bits;
    };

    union {
        __IO uint32_t  TIMING_2;

        struct {
            __IO uint32_t  TRNA                           :  4;
            __IO uint32_t  AHT                            :  2;
            __IO uint32_t  WTC                            :  2;
            __IO uint32_t  AT2                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  AT1                            :  4;
            __IO uint32_t  CTW                            :  2;
            __IO uint32_t  AST                            :  2;
            __IO uint32_t  RBE                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  EAT1                           :  4;
            __IO uint32_t  ETRNA                          :  4;
        } TIMING_2_bits;
    };

    union {
        __IO uint32_t  CONFIG_3;

        struct {
            __IO uint32_t  BNK_MBW                        :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  BNK_SIZE                       :  4;
            __IO uint32_t  BNK_TYP3                       :  1;
            __IO uint32_t  BNK_TYP2                       :  1;
            __IO uint32_t  BNK_TYP1                       :  1;
            __IO uint32_t  BNK_WPROT                      :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  BNK_BASE                       : 13;
            __IO uint32_t  BNK_EN                         :  1;
        } CONFIG_3_bits;
    };

    union {
        __IO uint32_t  TIMING_3;

        struct {
            __IO uint32_t  TRNA                           :  4;
            __IO uint32_t  AHT                            :  2;
            __IO uint32_t  WTC                            :  2;
            __IO uint32_t  AT2                            :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  AT1                            :  4;
            __IO uint32_t  CTW                            :  2;
            __IO uint32_t  AST                            :  2;
            __IO uint32_t  RBE                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  EAT1                           :  4;
            __IO uint32_t  ETRNA                          :  4;
        } TIMING_3_bits;
    };

    __I  uint32_t  RESERVED1[8];

    union {
        __IO uint32_t  SHADOW_STATUS;

        struct {
            __IO uint32_t  SSR_BNKNUM                     :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  SSR_REQM                       :  1;
            __IO uint32_t  SSR_REQ                        :  1;
                 uint32_t                                 :  2;
            __I  uint32_t  SSR_STS                        :  1;
        } SHADOW_STATUS_bits;
    };

    union {
        __IO uint32_t  EBI_CONTROL;

        struct {
            __IO uint32_t  EBI_Burst_Control              :  1;
        } EBI_CONTROL_bits;
    };

    __I  uint32_t  RESERVED2[14];

    union {
        __I  uint32_t  REVISION;

        struct {
            __I  uint32_t  REV_VER                        :  8;
            __I  uint32_t  MINOR_VER                      :  8;
            __I  uint32_t  MAJOR_VER                      :  8;
        } REVISION_bits;
    };

    union {
        __I  uint32_t  FEATURE;

        struct {
            __I  uint32_t  EBNK_CNT                       :  8;
            __I  uint32_t  FIFO_DEPTH                     :  8;
            __I  uint32_t  ADC_SKM                        :  1;
        } FEATURE_bits;
    };

/* DOM-IGNORE-END */
}AG903_SMC_Type;

#define AG903_SMC                                ((volatile AG903_SMC_Type *) AG903_SMC_BASE)                            /** SMC Base Address */


#define AG903_SMC_CONFIG_0_BNK_MBW_POS                     0                                                             /** SMCCONFIG_0 BNK_MBW-bit position */
#define AG903_SMC_CONFIG_0_BNK_MBW_MSK                     (0x3UL << AG903_SMC_CONFIG_0_BNK_MBW_POS)                     /** SMCCONFIG_0 BNK_MBW-bit mask */
#define AG903_SMC_CONFIG_0_BNK_SIZE_POS                    4                                                             /** SMCCONFIG_0 BNK_SIZE-bit position */
#define AG903_SMC_CONFIG_0_BNK_SIZE_MSK                    (0xfUL << AG903_SMC_CONFIG_0_BNK_SIZE_POS)                    /** SMCCONFIG_0 BNK_SIZE-bit mask */
#define AG903_SMC_CONFIG_0_BNK_TYP3_POS                    8                                                             /** SMCCONFIG_0 BNK_TYP3-bit position */
#define AG903_SMC_CONFIG_0_BNK_TYP3_MSK                    (0x1UL << AG903_SMC_CONFIG_0_BNK_TYP3_POS)                    /** SMCCONFIG_0 BNK_TYP3-bit mask */
#define AG903_SMC_CONFIG_0_BNK_TYP2_POS                    9                                                             /** SMCCONFIG_0 BNK_TYP2-bit position */
#define AG903_SMC_CONFIG_0_BNK_TYP2_MSK                    (0x1UL << AG903_SMC_CONFIG_0_BNK_TYP2_POS)                    /** SMCCONFIG_0 BNK_TYP2-bit mask */
#define AG903_SMC_CONFIG_0_BNK_TYP1_POS                    10                                                            /** SMCCONFIG_0 BNK_TYP1-bit position */
#define AG903_SMC_CONFIG_0_BNK_TYP1_MSK                    (0x1UL << AG903_SMC_CONFIG_0_BNK_TYP1_POS)                    /** SMCCONFIG_0 BNK_TYP1-bit mask */
#define AG903_SMC_CONFIG_0_BNK_WPROT_POS                   11                                                            /** SMCCONFIG_0 BNK_WPROT-bit position */
#define AG903_SMC_CONFIG_0_BNK_WPROT_MSK                   (0x1UL << AG903_SMC_CONFIG_0_BNK_WPROT_POS)                   /** SMCCONFIG_0 BNK_WPROT-bit mask */
#define AG903_SMC_CONFIG_0_BNK_BASE_POS                    15                                                            /** SMCCONFIG_0 BNK_BASE-bit position */
#define AG903_SMC_CONFIG_0_BNK_BASE_MSK                    (0x1fffUL << AG903_SMC_CONFIG_0_BNK_BASE_POS)                 /** SMCCONFIG_0 BNK_BASE-bit mask */
#define AG903_SMC_CONFIG_0_BNK_EN_POS                      28                                                            /** SMCCONFIG_0 BNK_EN-bit position */
#define AG903_SMC_CONFIG_0_BNK_EN_MSK                      (0x1UL << AG903_SMC_CONFIG_0_BNK_EN_POS)                      /** SMCCONFIG_0 BNK_EN-bit mask */

#define AG903_SMC_TIMING_0_TRNA_POS                        0                                                             /** SMCTIMING_0 TRNA-bit position */
#define AG903_SMC_TIMING_0_TRNA_MSK                        (0xfUL << AG903_SMC_TIMING_0_TRNA_POS)                        /** SMCTIMING_0 TRNA-bit mask */
#define AG903_SMC_TIMING_0_AHT_POS                         4                                                             /** SMCTIMING_0 AHT-bit position */
#define AG903_SMC_TIMING_0_AHT_MSK                         (0x3UL << AG903_SMC_TIMING_0_AHT_POS)                         /** SMCTIMING_0 AHT-bit mask */
#define AG903_SMC_TIMING_0_WTC_POS                         6                                                             /** SMCTIMING_0 WTC-bit position */
#define AG903_SMC_TIMING_0_WTC_MSK                         (0x3UL << AG903_SMC_TIMING_0_WTC_POS)                         /** SMCTIMING_0 WTC-bit mask */
#define AG903_SMC_TIMING_0_AT2_POS                         8                                                             /** SMCTIMING_0 AT2-bit position */
#define AG903_SMC_TIMING_0_AT2_MSK                         (0x3UL << AG903_SMC_TIMING_0_AT2_POS)                         /** SMCTIMING_0 AT2-bit mask */
#define AG903_SMC_TIMING_0_AT1_POS                         12                                                            /** SMCTIMING_0 AT1-bit position */
#define AG903_SMC_TIMING_0_AT1_MSK                         (0xfUL << AG903_SMC_TIMING_0_AT1_POS)                         /** SMCTIMING_0 AT1-bit mask */
#define AG903_SMC_TIMING_0_CTW_POS                         16                                                            /** SMCTIMING_0 CTW-bit position */
#define AG903_SMC_TIMING_0_CTW_MSK                         (0x3UL << AG903_SMC_TIMING_0_CTW_POS)                         /** SMCTIMING_0 CTW-bit mask */
#define AG903_SMC_TIMING_0_AST_POS                         18                                                            /** SMCTIMING_0 AST-bit position */
#define AG903_SMC_TIMING_0_AST_MSK                         (0x3UL << AG903_SMC_TIMING_0_AST_POS)                         /** SMCTIMING_0 AST-bit mask */
#define AG903_SMC_TIMING_0_RBE_POS                         20                                                            /** SMCTIMING_0 RBE-bit position */
#define AG903_SMC_TIMING_0_RBE_MSK                         (0x1UL << AG903_SMC_TIMING_0_RBE_POS)                         /** SMCTIMING_0 RBE-bit mask */
#define AG903_SMC_TIMING_0_EAT1_POS                        24                                                            /** SMCTIMING_0 EAT1-bit position */
#define AG903_SMC_TIMING_0_EAT1_MSK                        (0xfUL << AG903_SMC_TIMING_0_EAT1_POS)                        /** SMCTIMING_0 EAT1-bit mask */
#define AG903_SMC_TIMING_0_ETRNA_POS                       28                                                            /** SMCTIMING_0 ETRNA-bit position */
#define AG903_SMC_TIMING_0_ETRNA_MSK                       (0xfUL << AG903_SMC_TIMING_0_ETRNA_POS)                       /** SMCTIMING_0 ETRNA-bit mask */

#define AG903_SMC_CONFIG_1_BNK_MBW_POS                     0                                                             /** SMCCONFIG_1 BNK_MBW-bit position */
#define AG903_SMC_CONFIG_1_BNK_MBW_MSK                     (0x3UL << AG903_SMC_CONFIG_1_BNK_MBW_POS)                     /** SMCCONFIG_1 BNK_MBW-bit mask */
#define AG903_SMC_CONFIG_1_BNK_SIZE_POS                    4                                                             /** SMCCONFIG_1 BNK_SIZE-bit position */
#define AG903_SMC_CONFIG_1_BNK_SIZE_MSK                    (0xfUL << AG903_SMC_CONFIG_1_BNK_SIZE_POS)                    /** SMCCONFIG_1 BNK_SIZE-bit mask */
#define AG903_SMC_CONFIG_1_BNK_TYP3_POS                    8                                                             /** SMCCONFIG_1 BNK_TYP3-bit position */
#define AG903_SMC_CONFIG_1_BNK_TYP3_MSK                    (0x1UL << AG903_SMC_CONFIG_1_BNK_TYP3_POS)                    /** SMCCONFIG_1 BNK_TYP3-bit mask */
#define AG903_SMC_CONFIG_1_BNK_TYP2_POS                    9                                                             /** SMCCONFIG_1 BNK_TYP2-bit position */
#define AG903_SMC_CONFIG_1_BNK_TYP2_MSK                    (0x1UL << AG903_SMC_CONFIG_1_BNK_TYP2_POS)                    /** SMCCONFIG_1 BNK_TYP2-bit mask */
#define AG903_SMC_CONFIG_1_BNK_TYP1_POS                    10                                                            /** SMCCONFIG_1 BNK_TYP1-bit position */
#define AG903_SMC_CONFIG_1_BNK_TYP1_MSK                    (0x1UL << AG903_SMC_CONFIG_1_BNK_TYP1_POS)                    /** SMCCONFIG_1 BNK_TYP1-bit mask */
#define AG903_SMC_CONFIG_1_BNK_WPROT_POS                   11                                                            /** SMCCONFIG_1 BNK_WPROT-bit position */
#define AG903_SMC_CONFIG_1_BNK_WPROT_MSK                   (0x1UL << AG903_SMC_CONFIG_1_BNK_WPROT_POS)                   /** SMCCONFIG_1 BNK_WPROT-bit mask */
#define AG903_SMC_CONFIG_1_BNK_BASE_POS                    15                                                            /** SMCCONFIG_1 BNK_BASE-bit position */
#define AG903_SMC_CONFIG_1_BNK_BASE_MSK                    (0x1fffUL << AG903_SMC_CONFIG_1_BNK_BASE_POS)                 /** SMCCONFIG_1 BNK_BASE-bit mask */
#define AG903_SMC_CONFIG_1_BNK_EN_POS                      28                                                            /** SMCCONFIG_1 BNK_EN-bit position */
#define AG903_SMC_CONFIG_1_BNK_EN_MSK                      (0x1UL << AG903_SMC_CONFIG_1_BNK_EN_POS)                      /** SMCCONFIG_1 BNK_EN-bit mask */

#define AG903_SMC_TIMING_1_TRNA_POS                        0                                                             /** SMCTIMING_1 TRNA-bit position */
#define AG903_SMC_TIMING_1_TRNA_MSK                        (0xfUL << AG903_SMC_TIMING_1_TRNA_POS)                        /** SMCTIMING_1 TRNA-bit mask */
#define AG903_SMC_TIMING_1_AHT_POS                         4                                                             /** SMCTIMING_1 AHT-bit position */
#define AG903_SMC_TIMING_1_AHT_MSK                         (0x3UL << AG903_SMC_TIMING_1_AHT_POS)                         /** SMCTIMING_1 AHT-bit mask */
#define AG903_SMC_TIMING_1_WTC_POS                         6                                                             /** SMCTIMING_1 WTC-bit position */
#define AG903_SMC_TIMING_1_WTC_MSK                         (0x3UL << AG903_SMC_TIMING_1_WTC_POS)                         /** SMCTIMING_1 WTC-bit mask */
#define AG903_SMC_TIMING_1_AT2_POS                         8                                                             /** SMCTIMING_1 AT2-bit position */
#define AG903_SMC_TIMING_1_AT2_MSK                         (0x3UL << AG903_SMC_TIMING_1_AT2_POS)                         /** SMCTIMING_1 AT2-bit mask */
#define AG903_SMC_TIMING_1_AT1_POS                         12                                                            /** SMCTIMING_1 AT1-bit position */
#define AG903_SMC_TIMING_1_AT1_MSK                         (0xfUL << AG903_SMC_TIMING_1_AT1_POS)                         /** SMCTIMING_1 AT1-bit mask */
#define AG903_SMC_TIMING_1_CTW_POS                         16                                                            /** SMCTIMING_1 CTW-bit position */
#define AG903_SMC_TIMING_1_CTW_MSK                         (0x3UL << AG903_SMC_TIMING_1_CTW_POS)                         /** SMCTIMING_1 CTW-bit mask */
#define AG903_SMC_TIMING_1_AST_POS                         18                                                            /** SMCTIMING_1 AST-bit position */
#define AG903_SMC_TIMING_1_AST_MSK                         (0x3UL << AG903_SMC_TIMING_1_AST_POS)                         /** SMCTIMING_1 AST-bit mask */
#define AG903_SMC_TIMING_1_RBE_POS                         20                                                            /** SMCTIMING_1 RBE-bit position */
#define AG903_SMC_TIMING_1_RBE_MSK                         (0x1UL << AG903_SMC_TIMING_1_RBE_POS)                         /** SMCTIMING_1 RBE-bit mask */
#define AG903_SMC_TIMING_1_EAT1_POS                        24                                                            /** SMCTIMING_1 EAT1-bit position */
#define AG903_SMC_TIMING_1_EAT1_MSK                        (0xfUL << AG903_SMC_TIMING_1_EAT1_POS)                        /** SMCTIMING_1 EAT1-bit mask */
#define AG903_SMC_TIMING_1_ETRNA_POS                       28                                                            /** SMCTIMING_1 ETRNA-bit position */
#define AG903_SMC_TIMING_1_ETRNA_MSK                       (0xfUL << AG903_SMC_TIMING_1_ETRNA_POS)                       /** SMCTIMING_1 ETRNA-bit mask */

#define AG903_SMC_CONFIG_2_BNK_MBW_POS                     0                                                             /** SMCCONFIG_2 BNK_MBW-bit position */
#define AG903_SMC_CONFIG_2_BNK_MBW_MSK                     (0x3UL << AG903_SMC_CONFIG_2_BNK_MBW_POS)                     /** SMCCONFIG_2 BNK_MBW-bit mask */
#define AG903_SMC_CONFIG_2_BNK_SIZE_POS                    4                                                             /** SMCCONFIG_2 BNK_SIZE-bit position */
#define AG903_SMC_CONFIG_2_BNK_SIZE_MSK                    (0xfUL << AG903_SMC_CONFIG_2_BNK_SIZE_POS)                    /** SMCCONFIG_2 BNK_SIZE-bit mask */
#define AG903_SMC_CONFIG_2_BNK_TYP3_POS                    8                                                             /** SMCCONFIG_2 BNK_TYP3-bit position */
#define AG903_SMC_CONFIG_2_BNK_TYP3_MSK                    (0x1UL << AG903_SMC_CONFIG_2_BNK_TYP3_POS)                    /** SMCCONFIG_2 BNK_TYP3-bit mask */
#define AG903_SMC_CONFIG_2_BNK_TYP2_POS                    9                                                             /** SMCCONFIG_2 BNK_TYP2-bit position */
#define AG903_SMC_CONFIG_2_BNK_TYP2_MSK                    (0x1UL << AG903_SMC_CONFIG_2_BNK_TYP2_POS)                    /** SMCCONFIG_2 BNK_TYP2-bit mask */
#define AG903_SMC_CONFIG_2_BNK_TYP1_POS                    10                                                            /** SMCCONFIG_2 BNK_TYP1-bit position */
#define AG903_SMC_CONFIG_2_BNK_TYP1_MSK                    (0x1UL << AG903_SMC_CONFIG_2_BNK_TYP1_POS)                    /** SMCCONFIG_2 BNK_TYP1-bit mask */
#define AG903_SMC_CONFIG_2_BNK_WPROT_POS                   11                                                            /** SMCCONFIG_2 BNK_WPROT-bit position */
#define AG903_SMC_CONFIG_2_BNK_WPROT_MSK                   (0x1UL << AG903_SMC_CONFIG_2_BNK_WPROT_POS)                   /** SMCCONFIG_2 BNK_WPROT-bit mask */
#define AG903_SMC_CONFIG_2_BNK_BASE_POS                    15                                                            /** SMCCONFIG_2 BNK_BASE-bit position */
#define AG903_SMC_CONFIG_2_BNK_BASE_MSK                    (0x1fffUL << AG903_SMC_CONFIG_2_BNK_BASE_POS)                 /** SMCCONFIG_2 BNK_BASE-bit mask */
#define AG903_SMC_CONFIG_2_BNK_EN_POS                      28                                                            /** SMCCONFIG_2 BNK_EN-bit position */
#define AG903_SMC_CONFIG_2_BNK_EN_MSK                      (0x1UL << AG903_SMC_CONFIG_2_BNK_EN_POS)                      /** SMCCONFIG_2 BNK_EN-bit mask */

#define AG903_SMC_TIMING_2_TRNA_POS                        0                                                             /** SMCTIMING_2 TRNA-bit position */
#define AG903_SMC_TIMING_2_TRNA_MSK                        (0xfUL << AG903_SMC_TIMING_2_TRNA_POS)                        /** SMCTIMING_2 TRNA-bit mask */
#define AG903_SMC_TIMING_2_AHT_POS                         4                                                             /** SMCTIMING_2 AHT-bit position */
#define AG903_SMC_TIMING_2_AHT_MSK                         (0x3UL << AG903_SMC_TIMING_2_AHT_POS)                         /** SMCTIMING_2 AHT-bit mask */
#define AG903_SMC_TIMING_2_WTC_POS                         6                                                             /** SMCTIMING_2 WTC-bit position */
#define AG903_SMC_TIMING_2_WTC_MSK                         (0x3UL << AG903_SMC_TIMING_2_WTC_POS)                         /** SMCTIMING_2 WTC-bit mask */
#define AG903_SMC_TIMING_2_AT2_POS                         8                                                             /** SMCTIMING_2 AT2-bit position */
#define AG903_SMC_TIMING_2_AT2_MSK                         (0x3UL << AG903_SMC_TIMING_2_AT2_POS)                         /** SMCTIMING_2 AT2-bit mask */
#define AG903_SMC_TIMING_2_AT1_POS                         12                                                            /** SMCTIMING_2 AT1-bit position */
#define AG903_SMC_TIMING_2_AT1_MSK                         (0xfUL << AG903_SMC_TIMING_2_AT1_POS)                         /** SMCTIMING_2 AT1-bit mask */
#define AG903_SMC_TIMING_2_CTW_POS                         16                                                            /** SMCTIMING_2 CTW-bit position */
#define AG903_SMC_TIMING_2_CTW_MSK                         (0x3UL << AG903_SMC_TIMING_2_CTW_POS)                         /** SMCTIMING_2 CTW-bit mask */
#define AG903_SMC_TIMING_2_AST_POS                         18                                                            /** SMCTIMING_2 AST-bit position */
#define AG903_SMC_TIMING_2_AST_MSK                         (0x3UL << AG903_SMC_TIMING_2_AST_POS)                         /** SMCTIMING_2 AST-bit mask */
#define AG903_SMC_TIMING_2_RBE_POS                         20                                                            /** SMCTIMING_2 RBE-bit position */
#define AG903_SMC_TIMING_2_RBE_MSK                         (0x1UL << AG903_SMC_TIMING_2_RBE_POS)                         /** SMCTIMING_2 RBE-bit mask */
#define AG903_SMC_TIMING_2_EAT1_POS                        24                                                            /** SMCTIMING_2 EAT1-bit position */
#define AG903_SMC_TIMING_2_EAT1_MSK                        (0xfUL << AG903_SMC_TIMING_2_EAT1_POS)                        /** SMCTIMING_2 EAT1-bit mask */
#define AG903_SMC_TIMING_2_ETRNA_POS                       28                                                            /** SMCTIMING_2 ETRNA-bit position */
#define AG903_SMC_TIMING_2_ETRNA_MSK                       (0xfUL << AG903_SMC_TIMING_2_ETRNA_POS)                       /** SMCTIMING_2 ETRNA-bit mask */

#define AG903_SMC_CONFIG_3_BNK_MBW_POS                     0                                                             /** SMCCONFIG_3 BNK_MBW-bit position */
#define AG903_SMC_CONFIG_3_BNK_MBW_MSK                     (0x3UL << AG903_SMC_CONFIG_3_BNK_MBW_POS)                     /** SMCCONFIG_3 BNK_MBW-bit mask */
#define AG903_SMC_CONFIG_3_BNK_SIZE_POS                    4                                                             /** SMCCONFIG_3 BNK_SIZE-bit position */
#define AG903_SMC_CONFIG_3_BNK_SIZE_MSK                    (0xfUL << AG903_SMC_CONFIG_3_BNK_SIZE_POS)                    /** SMCCONFIG_3 BNK_SIZE-bit mask */
#define AG903_SMC_CONFIG_3_BNK_TYP3_POS                    8                                                             /** SMCCONFIG_3 BNK_TYP3-bit position */
#define AG903_SMC_CONFIG_3_BNK_TYP3_MSK                    (0x1UL << AG903_SMC_CONFIG_3_BNK_TYP3_POS)                    /** SMCCONFIG_3 BNK_TYP3-bit mask */
#define AG903_SMC_CONFIG_3_BNK_TYP2_POS                    9                                                             /** SMCCONFIG_3 BNK_TYP2-bit position */
#define AG903_SMC_CONFIG_3_BNK_TYP2_MSK                    (0x1UL << AG903_SMC_CONFIG_3_BNK_TYP2_POS)                    /** SMCCONFIG_3 BNK_TYP2-bit mask */
#define AG903_SMC_CONFIG_3_BNK_TYP1_POS                    10                                                            /** SMCCONFIG_3 BNK_TYP1-bit position */
#define AG903_SMC_CONFIG_3_BNK_TYP1_MSK                    (0x1UL << AG903_SMC_CONFIG_3_BNK_TYP1_POS)                    /** SMCCONFIG_3 BNK_TYP1-bit mask */
#define AG903_SMC_CONFIG_3_BNK_WPROT_POS                   11                                                            /** SMCCONFIG_3 BNK_WPROT-bit position */
#define AG903_SMC_CONFIG_3_BNK_WPROT_MSK                   (0x1UL << AG903_SMC_CONFIG_3_BNK_WPROT_POS)                   /** SMCCONFIG_3 BNK_WPROT-bit mask */
#define AG903_SMC_CONFIG_3_BNK_BASE_POS                    15                                                            /** SMCCONFIG_3 BNK_BASE-bit position */
#define AG903_SMC_CONFIG_3_BNK_BASE_MSK                    (0x1fffUL << AG903_SMC_CONFIG_3_BNK_BASE_POS)                 /** SMCCONFIG_3 BNK_BASE-bit mask */
#define AG903_SMC_CONFIG_3_BNK_EN_POS                      28                                                            /** SMCCONFIG_3 BNK_EN-bit position */
#define AG903_SMC_CONFIG_3_BNK_EN_MSK                      (0x1UL << AG903_SMC_CONFIG_3_BNK_EN_POS)                      /** SMCCONFIG_3 BNK_EN-bit mask */

#define AG903_SMC_TIMING_3_TRNA_POS                        0                                                             /** SMCTIMING_3 TRNA-bit position */
#define AG903_SMC_TIMING_3_TRNA_MSK                        (0xfUL << AG903_SMC_TIMING_3_TRNA_POS)                        /** SMCTIMING_3 TRNA-bit mask */
#define AG903_SMC_TIMING_3_AHT_POS                         4                                                             /** SMCTIMING_3 AHT-bit position */
#define AG903_SMC_TIMING_3_AHT_MSK                         (0x3UL << AG903_SMC_TIMING_3_AHT_POS)                         /** SMCTIMING_3 AHT-bit mask */
#define AG903_SMC_TIMING_3_WTC_POS                         6                                                             /** SMCTIMING_3 WTC-bit position */
#define AG903_SMC_TIMING_3_WTC_MSK                         (0x3UL << AG903_SMC_TIMING_3_WTC_POS)                         /** SMCTIMING_3 WTC-bit mask */
#define AG903_SMC_TIMING_3_AT2_POS                         8                                                             /** SMCTIMING_3 AT2-bit position */
#define AG903_SMC_TIMING_3_AT2_MSK                         (0x3UL << AG903_SMC_TIMING_3_AT2_POS)                         /** SMCTIMING_3 AT2-bit mask */
#define AG903_SMC_TIMING_3_AT1_POS                         12                                                            /** SMCTIMING_3 AT1-bit position */
#define AG903_SMC_TIMING_3_AT1_MSK                         (0xfUL << AG903_SMC_TIMING_3_AT1_POS)                         /** SMCTIMING_3 AT1-bit mask */
#define AG903_SMC_TIMING_3_CTW_POS                         16                                                            /** SMCTIMING_3 CTW-bit position */
#define AG903_SMC_TIMING_3_CTW_MSK                         (0x3UL << AG903_SMC_TIMING_3_CTW_POS)                         /** SMCTIMING_3 CTW-bit mask */
#define AG903_SMC_TIMING_3_AST_POS                         18                                                            /** SMCTIMING_3 AST-bit position */
#define AG903_SMC_TIMING_3_AST_MSK                         (0x3UL << AG903_SMC_TIMING_3_AST_POS)                         /** SMCTIMING_3 AST-bit mask */
#define AG903_SMC_TIMING_3_RBE_POS                         20                                                            /** SMCTIMING_3 RBE-bit position */
#define AG903_SMC_TIMING_3_RBE_MSK                         (0x1UL << AG903_SMC_TIMING_3_RBE_POS)                         /** SMCTIMING_3 RBE-bit mask */
#define AG903_SMC_TIMING_3_EAT1_POS                        24                                                            /** SMCTIMING_3 EAT1-bit position */
#define AG903_SMC_TIMING_3_EAT1_MSK                        (0xfUL << AG903_SMC_TIMING_3_EAT1_POS)                        /** SMCTIMING_3 EAT1-bit mask */
#define AG903_SMC_TIMING_3_ETRNA_POS                       28                                                            /** SMCTIMING_3 ETRNA-bit position */
#define AG903_SMC_TIMING_3_ETRNA_MSK                       (0xfUL << AG903_SMC_TIMING_3_ETRNA_POS)                       /** SMCTIMING_3 ETRNA-bit mask */

#define AG903_SMC_SHADOW_STATUS_SSR_BNKNUM_POS             0                                                             /** SMCSHADOW_STATUS SSR_BNKNUM-bit position */
#define AG903_SMC_SHADOW_STATUS_SSR_BNKNUM_MSK             (0x7UL << AG903_SMC_SHADOW_STATUS_SSR_BNKNUM_POS)             /** SMCSHADOW_STATUS SSR_BNKNUM-bit mask */
#define AG903_SMC_SHADOW_STATUS_SSR_REQM_POS               4                                                             /** SMCSHADOW_STATUS SSR_REQM-bit position */
#define AG903_SMC_SHADOW_STATUS_SSR_REQM_MSK               (0x1UL << AG903_SMC_SHADOW_STATUS_SSR_REQM_POS)               /** SMCSHADOW_STATUS SSR_REQM-bit mask */
#define AG903_SMC_SHADOW_STATUS_SSR_REQ_POS                5                                                             /** SMCSHADOW_STATUS SSR_REQ-bit position */
#define AG903_SMC_SHADOW_STATUS_SSR_REQ_MSK                (0x1UL << AG903_SMC_SHADOW_STATUS_SSR_REQ_POS)                /** SMCSHADOW_STATUS SSR_REQ-bit mask */
#define AG903_SMC_SHADOW_STATUS_SSR_STS_POS                8                                                             /** SMCSHADOW_STATUS SSR_STS-bit position */
#define AG903_SMC_SHADOW_STATUS_SSR_STS_MSK                (0x1UL << AG903_SMC_SHADOW_STATUS_SSR_STS_POS)                /** SMCSHADOW_STATUS SSR_STS-bit mask */

#define AG903_SMC_EBI_CONTROL_EBI_Burst_Control_POS        0                                                             /** SMCEBI_CONTROL EBI_Burst_Control-bit position */
#define AG903_SMC_EBI_CONTROL_EBI_Burst_Control_MSK        (0x1UL << AG903_SMC_EBI_CONTROL_EBI_Burst_Control_POS)        /** SMCEBI_CONTROL EBI_Burst_Control-bit mask */

#define AG903_SMC_REVISION_REV_VER_POS                     0                                                             /** SMCREVISION REV_VER-bit position */
#define AG903_SMC_REVISION_REV_VER_MSK                     (0xffUL << AG903_SMC_REVISION_REV_VER_POS)                    /** SMCREVISION REV_VER-bit mask */
#define AG903_SMC_REVISION_MINOR_VER_POS                   8                                                             /** SMCREVISION MINOR_VER-bit position */
#define AG903_SMC_REVISION_MINOR_VER_MSK                   (0xffUL << AG903_SMC_REVISION_MINOR_VER_POS)                  /** SMCREVISION MINOR_VER-bit mask */
#define AG903_SMC_REVISION_MAJOR_VER_POS                   16                                                            /** SMCREVISION MAJOR_VER-bit position */
#define AG903_SMC_REVISION_MAJOR_VER_MSK                   (0xffUL << AG903_SMC_REVISION_MAJOR_VER_POS)                  /** SMCREVISION MAJOR_VER-bit mask */

#define AG903_SMC_FEATURE_EBNK_CNT_POS                     0                                                             /** SMCFEATURE EBNK_CNT-bit position */
#define AG903_SMC_FEATURE_EBNK_CNT_MSK                     (0xffUL << AG903_SMC_FEATURE_EBNK_CNT_POS)                    /** SMCFEATURE EBNK_CNT-bit mask */
#define AG903_SMC_FEATURE_FIFO_DEPTH_POS                   8                                                             /** SMCFEATURE FIFO_DEPTH-bit position */
#define AG903_SMC_FEATURE_FIFO_DEPTH_MSK                   (0xffUL << AG903_SMC_FEATURE_FIFO_DEPTH_POS)                  /** SMCFEATURE FIFO_DEPTH-bit mask */
#define AG903_SMC_FEATURE_ADC_SKM_POS                      16                                                            /** SMCFEATURE ADC_SKM-bit position */
#define AG903_SMC_FEATURE_ADC_SKM_MSK                      (0x1UL << AG903_SMC_FEATURE_ADC_SKM_POS)                      /** SMCFEATURE ADC_SKM-bit mask */

#endif /* _AG903_SMC_REGMAP_H_ */

