/**
 * @brief           UART Register Definition
 * @author          AXELL CORPORATION
 * @description     UART Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 * @history         2019_12_27  [SDK3.0] AG903dlAX51903_DS06.pdf̏C𔽉f (#2633)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_UART_REGMAP_H_
#define _AG903_UART_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** UARTn Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint8_t   RBR;
        __O  uint8_t   THR;
        __IO uint8_t   DLL;
    };

    __I  uint8_t   RESERVED1[3];

    union {
        __IO uint8_t   IER;

        struct {
            __IO uint8_t   Receiver_Data_Available        :  1;
            __IO uint8_t   THR_Empty                      :  1;
            __IO uint8_t   Receiver_Line_Status           :  1;
            __IO uint8_t   MODEM_Status                   :  1;
            __IO uint8_t   RTSEn                          :  1;
            __IO uint8_t   CTSEn                          :  1;
            __IO uint8_t   DTREn                          :  1;
            __IO uint8_t   DSREn                          :  1;
        } IER_bits;

        __IO uint8_t   DLM;
    };

    __I  uint8_t   RESERVED2[3];

    union {
        __I  uint8_t   IIR;

        struct {
            __I  uint8_t   Interrupt_Pending              :  1;
            __I  uint8_t   Interrupt_Identification_Code  :  2;
            __I  uint8_t   FIFO_mode_only                 :  1;
            __I  uint8_t   Tx_FIFO_full                   :  1;
                 uint8_t                                  :  1;
            __I  uint8_t   FIFO_mode_enable               :  2;
        } IIR_bits;

        __O  uint8_t   FCR;

        struct {
            __O  uint8_t   FIFO_Enable                    :  1;
            __O  uint8_t   RX_FIFO_Reset                  :  1;
            __O  uint8_t   TX_FIFO_Reset                  :  1;
            __O  uint8_t   DMA_Mode                       :  1;
                 uint8_t                                  :  2;
            __O  uint8_t   RXFIFO_TRGL                    :  2;
        } FCR_bits;

        __IO uint8_t   PSR;

        struct {
            __IO uint8_t   PSR                            :  5;
        } PSR_bits;
    };

    __I  uint8_t   RESERVED3[3];

    union {
        __IO uint8_t   LCR;

        struct {
            __IO uint8_t   WL0                            :  1;
            __IO uint8_t   WL1                            :  1;
            __IO uint8_t   Stop_Bits                      :  1;
            __IO uint8_t   Parity_Enable                  :  1;
            __IO uint8_t   Even_Parity                    :  1;
            __IO uint8_t   Stick_Parity                   :  1;
            __IO uint8_t   Set_Break                      :  1;
            __IO uint8_t   DLAB                           :  1;
        } LCR_bits;
    };

    __I  uint8_t   RESERVED4[3];

    union {
        __IO uint8_t   MCR;

        struct {
            __IO uint8_t   DTR                            :  1;
            __IO uint8_t   RTS                            :  1;
            __IO uint8_t   Out1                           :  1;
            __IO uint8_t   Out2                           :  1;
            __IO uint8_t   Loop                           :  1;
            __IO uint8_t   DMAmode2                       :  1;
            __IO uint8_t   Out3                           :  1;
        } MCR_bits;
    };

    __I  uint8_t   RESERVED5[3];

    union {
        __I  uint8_t   LSR;

        struct {
            __I  uint8_t   Data_Ready                     :  1;
            __I  uint8_t   Overrun_Error                  :  1;
            __I  uint8_t   Parity_Error                   :  1;
            __I  uint8_t   Framing_Error                  :  1;
            __I  uint8_t   Break_Interrupt                :  1;
            __I  uint8_t   THR_Empty                      :  1;
            __I  uint8_t   Transmitter_Empty              :  1;
            __I  uint8_t   FIFO_Data_Error                :  1;
        } LSR_bits;

        __O  uint8_t   TST;

        struct {
            __O  uint8_t   TEST_PAR_ERR                   :  1;
            __O  uint8_t   TEST_FRM_ERR                   :  1;
            __O  uint8_t   TEST_BAUDGEN                   :  1;
            __O  uint8_t   TEST_PHY_ERR                   :  1;
            __O  uint8_t   TEST_CRC_ERR                   :  1;
        } TST_bits;
    };

    __I  uint8_t   RESERVED6[3];

    union {
        __I  uint8_t   MSR;

        struct {
            __I  uint8_t   Delta_CTS                      :  1;
            __I  uint8_t   Delta_DSR                      :  1;
            __I  uint8_t   Trailing_edge_R1               :  1;
            __I  uint8_t   Delta_DCD                      :  1;
            __I  uint8_t   CTS                            :  1;
            __I  uint8_t   DSR                            :  1;
            __I  uint8_t   RI                             :  1;
            __I  uint8_t   DCD                            :  1;
        } MSR_bits;
    };

    __I  uint8_t   RESERVED7[3];

    union {
        __IO uint8_t   SPR;
    };

    __I  uint8_t   RESERVED8[3];
    __I  uint32_t  RESERVED9[18];

    union {
        __I  uint8_t   FEATURE;

        struct {
            __I  uint8_t   FIFO_DEPTH                     :  4;
            __I  uint8_t   IrDA_INSIDE                    :  1;
        } FEATURE_bits;
    };

    __I  uint8_t   RESERVED10[3];

    union {
        __I  uint8_t   REVD1;
    };

    __I  uint8_t   RESERVED11[3];

    union {
        __I  uint8_t   REVD2;
    };

    __I  uint8_t   RESERVED12[3];

    union {
        __I  uint8_t   REVD3;
    };

    __I  uint8_t   RESERVED13[3];
    __I  uint32_t  RESERVED14[2];

    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  FC                             :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  SM                             :  1;
            __IO uint32_t  HM                             :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  TD                             :  1;
        } MOD_bits;
    };

    union {
        __IO uint32_t  CMD;

        struct {
            __IO uint32_t  ST                             :  2;
        } CMD_bits;
    };

    union {
        __IO uint32_t  SETUPTIME;
    };

    union {
        __IO uint32_t  HOLDTIME;
    };

    union {
        __I  uint32_t  STAT;

        struct {
            __I  uint32_t  RTO                            :  1;
                 uint32_t                                 : 15;
            __I  uint32_t  CTO                            :  1;
        } STAT_bits;
    };

    union {
        __O  uint32_t  CLR;

        struct {
            __O  uint32_t  RTO                            :  1;
                 uint32_t                                 : 15;
            __O  uint32_t  CTO                            :  1;
        } CLR_bits;
    };

    union {
        __IO uint32_t  INTMASK;

        struct {
            __IO uint32_t  RTO                            :  1;
                 uint32_t                                 : 15;
            __IO uint32_t  CTO                            :  1;
        } INTMASK_bits;
    };

    __I  uint32_t  RESERVED15[1];

    union {
        __IO uint32_t  RECEIVETIME;
    };

    union {
        __IO uint32_t  CHARINTERVAL;
    };

    union {
        __IO uint32_t  TIMEOUT;
    };

/* DOM-IGNORE-END */
}AG903_UARTn_Type;

#define AG903_UARTn(ch)                          ((volatile AG903_UARTn_Type *)(AG903_UART0_BASE + 0x100000 * ch))       /** UARTn Base Address (n=0..3) */
#define AG903_UARTn_RBR(ch)                      AG903_UARTn(ch)->RBR                                                    /** UARTnRBR Address (n=0..3) */
#define AG903_UARTn_THR(ch)                      AG903_UARTn(ch)->THR                                                    /** UARTnTHR Address (n=0..3) */
#define AG903_UARTn_DLL(ch)                      AG903_UARTn(ch)->DLL                                                    /** UARTnDLL Address (n=0..3) */
#define AG903_UARTn_IER(ch)                      AG903_UARTn(ch)->IER                                                    /** UARTnIER Address (n=0..3) */
#define AG903_UARTn_DLM(ch)                      AG903_UARTn(ch)->DLM                                                    /** UARTnDLM Address (n=0..3) */
#define AG903_UARTn_IIR(ch)                      AG903_UARTn(ch)->IIR                                                    /** UARTnIIR Address (n=0..3) */
#define AG903_UARTn_FCR(ch)                      AG903_UARTn(ch)->FCR                                                    /** UARTnFCR Address (n=0..3) */
#define AG903_UARTn_PSR(ch)                      AG903_UARTn(ch)->PSR                                                    /** UARTnPSR Address (n=0..3) */
#define AG903_UARTn_LCR(ch)                      AG903_UARTn(ch)->LCR                                                    /** UARTnLCR Address (n=0..3) */
#define AG903_UARTn_MCR(ch)                      AG903_UARTn(ch)->MCR                                                    /** UARTnMCR Address (n=0..3) */
#define AG903_UARTn_LSR(ch)                      AG903_UARTn(ch)->LSR                                                    /** UARTnLSR Address (n=0..3) */
#define AG903_UARTn_TST(ch)                      AG903_UARTn(ch)->TST                                                    /** UARTnTST Address (n=0..3) */
#define AG903_UARTn_MSR(ch)                      AG903_UARTn(ch)->MSR                                                    /** UARTnMSR Address (n=0..3) */
#define AG903_UARTn_SPR(ch)                      AG903_UARTn(ch)->SPR                                                    /** UARTnSPR Address (n=0..3) */
#define AG903_UARTn_FEATURE(ch)                  AG903_UARTn(ch)->FEATURE                                                /** UARTnFEATURE Address (n=0..3) */
#define AG903_UARTn_REVD1(ch)                    AG903_UARTn(ch)->REVD1                                                  /** UARTnREVD1 Address (n=0..3) */
#define AG903_UARTn_REVD2(ch)                    AG903_UARTn(ch)->REVD2                                                  /** UARTnREVD2 Address (n=0..3) */
#define AG903_UARTn_REVD3(ch)                    AG903_UARTn(ch)->REVD3                                                  /** UARTnREVD3 Address (n=0..3) */
#define AG903_UARTn_MOD(ch)                      AG903_UARTn(ch)->MOD                                                    /** UARTnMOD Address (n=0..3) */
#define AG903_UARTn_CMD(ch)                      AG903_UARTn(ch)->CMD                                                    /** UARTnCMD Address (n=0..3) */
#define AG903_UARTn_SETUPTIME(ch)                AG903_UARTn(ch)->SETUPTIME                                              /** UARTnSETUPTIME Address (n=0..3) */
#define AG903_UARTn_HOLDTIME(ch)                 AG903_UARTn(ch)->HOLDTIME                                               /** UARTnHOLDTIME Address (n=0..3) */
#define AG903_UARTn_STAT(ch)                     AG903_UARTn(ch)->STAT                                                   /** UARTnSTAT Address (n=0..3) */
#define AG903_UARTn_CLR(ch)                      AG903_UARTn(ch)->CLR                                                    /** UARTnCLR Address (n=0..3) */
#define AG903_UARTn_INTMASK(ch)                  AG903_UARTn(ch)->INTMASK                                                /** UARTnINTMASK Address (n=0..3) */
#define AG903_UARTn_RECEIVETIME(ch)              AG903_UARTn(ch)->RECEIVETIME                                            /** UARTnRECEIVETIME Address (n=0..3) */
#define AG903_UARTn_CHARINTERVAL(ch)             AG903_UARTn(ch)->CHARINTERVAL                                           /** UARTnCHARINTERVAL Address (n=0..3) */
#define AG903_UARTn_TIMEOUT(ch)                  AG903_UARTn(ch)->TIMEOUT                                                /** UARTnTIMEOUT Address (n=0..3) */

#define AG903_UART0                              ((volatile AG903_UARTn_Type *) AG903_UART0_BASE)                        /** UARTn Base Address */
#define AG903_UART1                              ((volatile AG903_UARTn_Type *) AG903_UART1_BASE)                        /** UARTn Base Address */
#define AG903_UART2                              ((volatile AG903_UARTn_Type *) AG903_UART2_BASE)                        /** UARTn Base Address */
#define AG903_UART3                              ((volatile AG903_UARTn_Type *) AG903_UART3_BASE)                        /** UARTn Base Address */


#define AG903_UARTn_RBR_RBR_POS                            0                                                             /** UARTnRBR RBR-bit position */
#define AG903_UARTn_RBR_RBR_MSK                            (0xffU << AG903_UARTn_RBR_RBR_POS)                            /** UARTnRBR RBR-bit mask */

#define AG903_UARTn_THR_THR_POS                            0                                                             /** UARTnTHR THR-bit position */
#define AG903_UARTn_THR_THR_MSK                            (0xffU << AG903_UARTn_THR_THR_POS)                            /** UARTnTHR THR-bit mask */

#define AG903_UARTn_DLL_DLL_POS                            0                                                             /** UARTnDLL DLL-bit position */
#define AG903_UARTn_DLL_DLL_MSK                            (0xffU << AG903_UARTn_DLL_DLL_POS)                            /** UARTnDLL DLL-bit mask */

#define AG903_UARTn_IER_Receiver_Data_Available_POS        0                                                             /** UARTnIER Receiver_Data_Available-bit position */
#define AG903_UARTn_IER_Receiver_Data_Available_MSK        (0x1U << AG903_UARTn_IER_Receiver_Data_Available_POS)         /** UARTnIER Receiver_Data_Available-bit mask */
#define AG903_UARTn_IER_THR_Empty_POS                      1                                                             /** UARTnIER THR_Empty-bit position */
#define AG903_UARTn_IER_THR_Empty_MSK                      (0x1U << AG903_UARTn_IER_THR_Empty_POS)                       /** UARTnIER THR_Empty-bit mask */
#define AG903_UARTn_IER_Receiver_Line_Status_POS           2                                                             /** UARTnIER Receiver_Line_Status-bit position */
#define AG903_UARTn_IER_Receiver_Line_Status_MSK           (0x1U << AG903_UARTn_IER_Receiver_Line_Status_POS)            /** UARTnIER Receiver_Line_Status-bit mask */
#define AG903_UARTn_IER_MODEM_Status_POS                   3                                                             /** UARTnIER MODEM_Status-bit position */
#define AG903_UARTn_IER_MODEM_Status_MSK                   (0x1U << AG903_UARTn_IER_MODEM_Status_POS)                    /** UARTnIER MODEM_Status-bit mask */
#define AG903_UARTn_IER_RTSEn_POS                          4                                                             /** UARTnIER RTSEn-bit position */
#define AG903_UARTn_IER_RTSEn_MSK                          (0x1U << AG903_UARTn_IER_RTSEn_POS)                           /** UARTnIER RTSEn-bit mask */
#define AG903_UARTn_IER_CTSEn_POS                          5                                                             /** UARTnIER CTSEn-bit position */
#define AG903_UARTn_IER_CTSEn_MSK                          (0x1U << AG903_UARTn_IER_CTSEn_POS)                           /** UARTnIER CTSEn-bit mask */
#define AG903_UARTn_IER_DTREn_POS                          6                                                             /** UARTnIER DTREn-bit position */
#define AG903_UARTn_IER_DTREn_MSK                          (0x1U << AG903_UARTn_IER_DTREn_POS)                           /** UARTnIER DTREn-bit mask */
#define AG903_UARTn_IER_DSREn_POS                          7                                                             /** UARTnIER DSREn-bit position */
#define AG903_UARTn_IER_DSREn_MSK                          (0x1U << AG903_UARTn_IER_DSREn_POS)                           /** UARTnIER DSREn-bit mask */

#define AG903_UARTn_DLM_DLM_POS                            0                                                             /** UARTnDLM DLM-bit position */
#define AG903_UARTn_DLM_DLM_MSK                            (0xffU << AG903_UARTn_DLM_DLM_POS)                            /** UARTnDLM DLM-bit mask */

#define AG903_UARTn_IIR_Interrupt_Pending_POS              0                                                             /** UARTnIIR Interrupt_Pending-bit position */
#define AG903_UARTn_IIR_Interrupt_Pending_MSK              (0x1U << AG903_UARTn_IIR_Interrupt_Pending_POS)               /** UARTnIIR Interrupt_Pending-bit mask */
#define AG903_UARTn_IIR_Interrupt_Identification_Code_POS  1                                                             /** UARTnIIR Interrupt_Identification_Code-bit position */
#define AG903_UARTn_IIR_Interrupt_Identification_Code_MSK  (0x3U << AG903_UARTn_IIR_Interrupt_Identification_Code_POS)   /** UARTnIIR Interrupt_Identification_Code-bit mask */
#define AG903_UARTn_IIR_FIFO_mode_only_POS                 3                                                             /** UARTnIIR FIFO_mode_only-bit position */
#define AG903_UARTn_IIR_FIFO_mode_only_MSK                 (0x1U << AG903_UARTn_IIR_FIFO_mode_only_POS)                  /** UARTnIIR FIFO_mode_only-bit mask */
#define AG903_UARTn_IIR_Tx_FIFO_full_POS                   4                                                             /** UARTnIIR Tx_FIFO_full-bit position */
#define AG903_UARTn_IIR_Tx_FIFO_full_MSK                   (0x1U << AG903_UARTn_IIR_Tx_FIFO_full_POS)                    /** UARTnIIR Tx_FIFO_full-bit mask */
#define AG903_UARTn_IIR_FIFO_mode_enable_POS               6                                                             /** UARTnIIR FIFO_mode_enable-bit position */
#define AG903_UARTn_IIR_FIFO_mode_enable_MSK               (0x3U << AG903_UARTn_IIR_FIFO_mode_enable_POS)                /** UARTnIIR FIFO_mode_enable-bit mask */

#define AG903_UARTn_FCR_FIFO_Enable_POS                    0                                                             /** UARTnFCR FIFO_Enable-bit position */
#define AG903_UARTn_FCR_FIFO_Enable_MSK                    (0x1U << AG903_UARTn_FCR_FIFO_Enable_POS)                     /** UARTnFCR FIFO_Enable-bit mask */
#define AG903_UARTn_FCR_RX_FIFO_Reset_POS                  1                                                             /** UARTnFCR RX_FIFO_Reset-bit position */
#define AG903_UARTn_FCR_RX_FIFO_Reset_MSK                  (0x1U << AG903_UARTn_FCR_RX_FIFO_Reset_POS)                   /** UARTnFCR RX_FIFO_Reset-bit mask */
#define AG903_UARTn_FCR_TX_FIFO_Reset_POS                  2                                                             /** UARTnFCR TX_FIFO_Reset-bit position */
#define AG903_UARTn_FCR_TX_FIFO_Reset_MSK                  (0x1U << AG903_UARTn_FCR_TX_FIFO_Reset_POS)                   /** UARTnFCR TX_FIFO_Reset-bit mask */
#define AG903_UARTn_FCR_DMA_Mode_POS                       3                                                             /** UARTnFCR DMA_Mode-bit position */
#define AG903_UARTn_FCR_DMA_Mode_MSK                       (0x1U << AG903_UARTn_FCR_DMA_Mode_POS)                        /** UARTnFCR DMA_Mode-bit mask */
#define AG903_UARTn_FCR_RXFIFO_TRGL_POS                    6                                                             /** UARTnFCR RXFIFO_TRGL-bit position */
#define AG903_UARTn_FCR_RXFIFO_TRGL_MSK                    (0x3U << AG903_UARTn_FCR_RXFIFO_TRGL_POS)                     /** UARTnFCR RXFIFO_TRGL-bit mask */

#define AG903_UARTn_PSR_PSR_POS                            0                                                             /** UARTnPSR PSR-bit position */
#define AG903_UARTn_PSR_PSR_MSK                            (0x1fU << AG903_UARTn_PSR_PSR_POS)                            /** UARTnPSR PSR-bit mask */

#define AG903_UARTn_LCR_WL0_POS                            0                                                             /** UARTnLCR WL0-bit position */
#define AG903_UARTn_LCR_WL0_MSK                            (0x1U << AG903_UARTn_LCR_WL0_POS)                             /** UARTnLCR WL0-bit mask */
#define AG903_UARTn_LCR_WL1_POS                            1                                                             /** UARTnLCR WL1-bit position */
#define AG903_UARTn_LCR_WL1_MSK                            (0x1U << AG903_UARTn_LCR_WL1_POS)                             /** UARTnLCR WL1-bit mask */
#define AG903_UARTn_LCR_Stop_Bits_POS                      2                                                             /** UARTnLCR Stop_Bits-bit position */
#define AG903_UARTn_LCR_Stop_Bits_MSK                      (0x1U << AG903_UARTn_LCR_Stop_Bits_POS)                       /** UARTnLCR Stop_Bits-bit mask */
#define AG903_UARTn_LCR_Parity_Enable_POS                  3                                                             /** UARTnLCR Parity_Enable-bit position */
#define AG903_UARTn_LCR_Parity_Enable_MSK                  (0x1U << AG903_UARTn_LCR_Parity_Enable_POS)                   /** UARTnLCR Parity_Enable-bit mask */
#define AG903_UARTn_LCR_Even_Parity_POS                    4                                                             /** UARTnLCR Even_Parity-bit position */
#define AG903_UARTn_LCR_Even_Parity_MSK                    (0x1U << AG903_UARTn_LCR_Even_Parity_POS)                     /** UARTnLCR Even_Parity-bit mask */
#define AG903_UARTn_LCR_Stick_Parity_POS                   5                                                             /** UARTnLCR Stick_Parity-bit position */
#define AG903_UARTn_LCR_Stick_Parity_MSK                   (0x1U << AG903_UARTn_LCR_Stick_Parity_POS)                    /** UARTnLCR Stick_Parity-bit mask */
#define AG903_UARTn_LCR_Set_Break_POS                      6                                                             /** UARTnLCR Set_Break-bit position */
#define AG903_UARTn_LCR_Set_Break_MSK                      (0x1U << AG903_UARTn_LCR_Set_Break_POS)                       /** UARTnLCR Set_Break-bit mask */
#define AG903_UARTn_LCR_DLAB_POS                           7                                                             /** UARTnLCR DLAB-bit position */
#define AG903_UARTn_LCR_DLAB_MSK                           (0x1U << AG903_UARTn_LCR_DLAB_POS)                            /** UARTnLCR DLAB-bit mask */

#define AG903_UARTn_MCR_DTR_POS                            0                                                             /** UARTnMCR DTR-bit position */
#define AG903_UARTn_MCR_DTR_MSK                            (0x1U << AG903_UARTn_MCR_DTR_POS)                             /** UARTnMCR DTR-bit mask */
#define AG903_UARTn_MCR_RTS_POS                            1                                                             /** UARTnMCR RTS-bit position */
#define AG903_UARTn_MCR_RTS_MSK                            (0x1U << AG903_UARTn_MCR_RTS_POS)                             /** UARTnMCR RTS-bit mask */
#define AG903_UARTn_MCR_Out1_POS                           2                                                             /** UARTnMCR Out1-bit position */
#define AG903_UARTn_MCR_Out1_MSK                           (0x1U << AG903_UARTn_MCR_Out1_POS)                            /** UARTnMCR Out1-bit mask */
#define AG903_UARTn_MCR_Out2_POS                           3                                                             /** UARTnMCR Out2-bit position */
#define AG903_UARTn_MCR_Out2_MSK                           (0x1U << AG903_UARTn_MCR_Out2_POS)                            /** UARTnMCR Out2-bit mask */
#define AG903_UARTn_MCR_Loop_POS                           4                                                             /** UARTnMCR Loop-bit position */
#define AG903_UARTn_MCR_Loop_MSK                           (0x1U << AG903_UARTn_MCR_Loop_POS)                            /** UARTnMCR Loop-bit mask */
#define AG903_UARTn_MCR_DMAmode2_POS                       5                                                             /** UARTnMCR DMAmode2-bit position */
#define AG903_UARTn_MCR_DMAmode2_MSK                       (0x1U << AG903_UARTn_MCR_DMAmode2_POS)                        /** UARTnMCR DMAmode2-bit mask */
#define AG903_UARTn_MCR_Out3_POS                           6                                                             /** UARTnMCR Out3-bit position */
#define AG903_UARTn_MCR_Out3_MSK                           (0x1U << AG903_UARTn_MCR_Out3_POS)                            /** UARTnMCR Out3-bit mask */

#define AG903_UARTn_LSR_Data_Ready_POS                     0                                                             /** UARTnLSR Data_Ready-bit position */
#define AG903_UARTn_LSR_Data_Ready_MSK                     (0x1U << AG903_UARTn_LSR_Data_Ready_POS)                      /** UARTnLSR Data_Ready-bit mask */
#define AG903_UARTn_LSR_Overrun_Error_POS                  1                                                             /** UARTnLSR Overrun_Error-bit position */
#define AG903_UARTn_LSR_Overrun_Error_MSK                  (0x1U << AG903_UARTn_LSR_Overrun_Error_POS)                   /** UARTnLSR Overrun_Error-bit mask */
#define AG903_UARTn_LSR_Parity_Error_POS                   2                                                             /** UARTnLSR Parity_Error-bit position */
#define AG903_UARTn_LSR_Parity_Error_MSK                   (0x1U << AG903_UARTn_LSR_Parity_Error_POS)                    /** UARTnLSR Parity_Error-bit mask */
#define AG903_UARTn_LSR_Framing_Error_POS                  3                                                             /** UARTnLSR Framing_Error-bit position */
#define AG903_UARTn_LSR_Framing_Error_MSK                  (0x1U << AG903_UARTn_LSR_Framing_Error_POS)                   /** UARTnLSR Framing_Error-bit mask */
#define AG903_UARTn_LSR_Break_Interrupt_POS                4                                                             /** UARTnLSR Break_Interrupt-bit position */
#define AG903_UARTn_LSR_Break_Interrupt_MSK                (0x1U << AG903_UARTn_LSR_Break_Interrupt_POS)                 /** UARTnLSR Break_Interrupt-bit mask */
#define AG903_UARTn_LSR_THR_Empty_POS                      5                                                             /** UARTnLSR THR_Empty-bit position */
#define AG903_UARTn_LSR_THR_Empty_MSK                      (0x1U << AG903_UARTn_LSR_THR_Empty_POS)                       /** UARTnLSR THR_Empty-bit mask */
#define AG903_UARTn_LSR_Transmitter_Empty_POS              6                                                             /** UARTnLSR Transmitter_Empty-bit position */
#define AG903_UARTn_LSR_Transmitter_Empty_MSK              (0x1U << AG903_UARTn_LSR_Transmitter_Empty_POS)               /** UARTnLSR Transmitter_Empty-bit mask */
#define AG903_UARTn_LSR_FIFO_Data_Error_POS                7                                                             /** UARTnLSR FIFO_Data_Error-bit position */
#define AG903_UARTn_LSR_FIFO_Data_Error_MSK                (0x1U << AG903_UARTn_LSR_FIFO_Data_Error_POS)                 /** UARTnLSR FIFO_Data_Error-bit mask */

#define AG903_UARTn_TST_TEST_PAR_ERR_POS                   0                                                             /** UARTnTST TEST_PAR_ERR-bit position */
#define AG903_UARTn_TST_TEST_PAR_ERR_MSK                   (0x1U << AG903_UARTn_TST_TEST_PAR_ERR_POS)                    /** UARTnTST TEST_PAR_ERR-bit mask */
#define AG903_UARTn_TST_TEST_FRM_ERR_POS                   1                                                             /** UARTnTST TEST_FRM_ERR-bit position */
#define AG903_UARTn_TST_TEST_FRM_ERR_MSK                   (0x1U << AG903_UARTn_TST_TEST_FRM_ERR_POS)                    /** UARTnTST TEST_FRM_ERR-bit mask */
#define AG903_UARTn_TST_TEST_BAUDGEN_POS                   2                                                             /** UARTnTST TEST_BAUDGEN-bit position */
#define AG903_UARTn_TST_TEST_BAUDGEN_MSK                   (0x1U << AG903_UARTn_TST_TEST_BAUDGEN_POS)                    /** UARTnTST TEST_BAUDGEN-bit mask */
#define AG903_UARTn_TST_TEST_PHY_ERR_POS                   3                                                             /** UARTnTST TEST_PHY_ERR-bit position */
#define AG903_UARTn_TST_TEST_PHY_ERR_MSK                   (0x1U << AG903_UARTn_TST_TEST_PHY_ERR_POS)                    /** UARTnTST TEST_PHY_ERR-bit mask */
#define AG903_UARTn_TST_TEST_CRC_ERR_POS                   4                                                             /** UARTnTST TEST_CRC_ERR-bit position */
#define AG903_UARTn_TST_TEST_CRC_ERR_MSK                   (0x1U << AG903_UARTn_TST_TEST_CRC_ERR_POS)                    /** UARTnTST TEST_CRC_ERR-bit mask */

#define AG903_UARTn_MSR_Delta_CTS_POS                      0                                                             /** UARTnMSR Delta_CTS-bit position */
#define AG903_UARTn_MSR_Delta_CTS_MSK                      (0x1U << AG903_UARTn_MSR_Delta_CTS_POS)                       /** UARTnMSR Delta_CTS-bit mask */
#define AG903_UARTn_MSR_Delta_DSR_POS                      1                                                             /** UARTnMSR Delta_DSR-bit position */
#define AG903_UARTn_MSR_Delta_DSR_MSK                      (0x1U << AG903_UARTn_MSR_Delta_DSR_POS)                       /** UARTnMSR Delta_DSR-bit mask */
#define AG903_UARTn_MSR_Trailing_edge_R1_POS               2                                                             /** UARTnMSR Trailing_edge_R1-bit position */
#define AG903_UARTn_MSR_Trailing_edge_R1_MSK               (0x1U << AG903_UARTn_MSR_Trailing_edge_R1_POS)                /** UARTnMSR Trailing_edge_R1-bit mask */
#define AG903_UARTn_MSR_Delta_DCD_POS                      3                                                             /** UARTnMSR Delta_DCD-bit position */
#define AG903_UARTn_MSR_Delta_DCD_MSK                      (0x1U << AG903_UARTn_MSR_Delta_DCD_POS)                       /** UARTnMSR Delta_DCD-bit mask */
#define AG903_UARTn_MSR_CTS_POS                            4                                                             /** UARTnMSR CTS-bit position */
#define AG903_UARTn_MSR_CTS_MSK                            (0x1U << AG903_UARTn_MSR_CTS_POS)                             /** UARTnMSR CTS-bit mask */
#define AG903_UARTn_MSR_DSR_POS                            5                                                             /** UARTnMSR DSR-bit position */
#define AG903_UARTn_MSR_DSR_MSK                            (0x1U << AG903_UARTn_MSR_DSR_POS)                             /** UARTnMSR DSR-bit mask */
#define AG903_UARTn_MSR_RI_POS                             6                                                             /** UARTnMSR RI-bit position */
#define AG903_UARTn_MSR_RI_MSK                             (0x1U << AG903_UARTn_MSR_RI_POS)                              /** UARTnMSR RI-bit mask */
#define AG903_UARTn_MSR_DCD_POS                            7                                                             /** UARTnMSR DCD-bit position */
#define AG903_UARTn_MSR_DCD_MSK                            (0x1U << AG903_UARTn_MSR_DCD_POS)                             /** UARTnMSR DCD-bit mask */

#define AG903_UARTn_SPR_User_Data_POS                      0                                                             /** UARTnSPR User_Data-bit position */
#define AG903_UARTn_SPR_User_Data_MSK                      (0xffU << AG903_UARTn_SPR_User_Data_POS)                      /** UARTnSPR User_Data-bit mask */

#define AG903_UARTn_FEATURE_FIFO_DEPTH_POS                 0                                                             /** UARTnFEATURE FIFO_DEPTH-bit position */
#define AG903_UARTn_FEATURE_FIFO_DEPTH_MSK                 (0xfU << AG903_UARTn_FEATURE_FIFO_DEPTH_POS)                  /** UARTnFEATURE FIFO_DEPTH-bit mask */
#define AG903_UARTn_FEATURE_IrDA_INSIDE_POS                4                                                             /** UARTnFEATURE IrDA_INSIDE-bit position */
#define AG903_UARTn_FEATURE_IrDA_INSIDE_MSK                (0x1U << AG903_UARTn_FEATURE_IrDA_INSIDE_POS)                 /** UARTnFEATURE IrDA_INSIDE-bit mask */

#define AG903_UARTn_REVD1_REVD1_POS                        0                                                             /** UARTnREVD1 REVD1-bit position */
#define AG903_UARTn_REVD1_REVD1_MSK                        (0xffU << AG903_UARTn_REVD1_REVD1_POS)                        /** UARTnREVD1 REVD1-bit mask */

#define AG903_UARTn_REVD2_REVD2_POS                        0                                                             /** UARTnREVD2 REVD2-bit position */
#define AG903_UARTn_REVD2_REVD2_MSK                        (0xffU << AG903_UARTn_REVD2_REVD2_POS)                        /** UARTnREVD2 REVD2-bit mask */

#define AG903_UARTn_REVD3_REVD3_POS                        0                                                             /** UARTnREVD3 REVD3-bit position */
#define AG903_UARTn_REVD3_REVD3_MSK                        (0xffU << AG903_UARTn_REVD3_REVD3_POS)                        /** UARTnREVD3 REVD3-bit mask */

#define AG903_UARTn_MOD_FC_POS                             0                                                             /** UARTnMOD FC-bit position */
#define AG903_UARTn_MOD_FC_MSK                             (0x1UL << AG903_UARTn_MOD_FC_POS)                             /** UARTnMOD FC-bit mask */
#define AG903_UARTn_MOD_SM_POS                             8                                                             /** UARTnMOD SM-bit position */
#define AG903_UARTn_MOD_SM_MSK                             (0x1UL << AG903_UARTn_MOD_SM_POS)                             /** UARTnMOD SM-bit mask */
#define AG903_UARTn_MOD_HM_POS                             9                                                             /** UARTnMOD HM-bit position */
#define AG903_UARTn_MOD_HM_MSK                             (0x1UL << AG903_UARTn_MOD_HM_POS)                             /** UARTnMOD HM-bit mask */
#define AG903_UARTn_MOD_TD_POS                             16                                                            /** UARTnMOD TD-bit position */
#define AG903_UARTn_MOD_TD_MSK                             (0x1UL << AG903_UARTn_MOD_TD_POS)                             /** UARTnMOD TD-bit mask */

#define AG903_UARTn_CMD_ST_POS                             0                                                             /** UARTnCMD ST-bit position */
#define AG903_UARTn_CMD_ST_MSK                             (0x3UL << AG903_UARTn_CMD_ST_POS)                             /** UARTnCMD ST-bit mask */

#define AG903_UARTn_SETUPTIME_TIME_POS                     0                                                             /** UARTnSETUPTIME TIME-bit position */
#define AG903_UARTn_SETUPTIME_TIME_MSK                     (0xffffffffUL << AG903_UARTn_SETUPTIME_TIME_POS)              /** UARTnSETUPTIME TIME-bit mask */

#define AG903_UARTn_HOLDTIME_TIME_POS                      0                                                             /** UARTnHOLDTIME TIME-bit position */
#define AG903_UARTn_HOLDTIME_TIME_MSK                      (0xffffffffUL << AG903_UARTn_HOLDTIME_TIME_POS)               /** UARTnHOLDTIME TIME-bit mask */

#define AG903_UARTn_STAT_RTO_POS                           0                                                             /** UARTnSTAT RTO-bit position */
#define AG903_UARTn_STAT_RTO_MSK                           (0x1UL << AG903_UARTn_STAT_RTO_POS)                           /** UARTnSTAT RTO-bit mask */
#define AG903_UARTn_STAT_CTO_POS                           16                                                            /** UARTnSTAT CTO-bit position */
#define AG903_UARTn_STAT_CTO_MSK                           (0x1UL << AG903_UARTn_STAT_CTO_POS)                           /** UARTnSTAT CTO-bit mask */

#define AG903_UARTn_CLR_RTO_POS                            0                                                             /** UARTnCLR RTO-bit position */
#define AG903_UARTn_CLR_RTO_MSK                            (0x1UL << AG903_UARTn_CLR_RTO_POS)                            /** UARTnCLR RTO-bit mask */
#define AG903_UARTn_CLR_CTO_POS                            16                                                            /** UARTnCLR CTO-bit position */
#define AG903_UARTn_CLR_CTO_MSK                            (0x1UL << AG903_UARTn_CLR_CTO_POS)                            /** UARTnCLR CTO-bit mask */

#define AG903_UARTn_INTMASK_RTO_POS                        0                                                             /** UARTnINTMASK RTO-bit position */
#define AG903_UARTn_INTMASK_RTO_MSK                        (0x1UL << AG903_UARTn_INTMASK_RTO_POS)                        /** UARTnINTMASK RTO-bit mask */
#define AG903_UARTn_INTMASK_CTO_POS                        16                                                            /** UARTnINTMASK CTO-bit position */
#define AG903_UARTn_INTMASK_CTO_MSK                        (0x1UL << AG903_UARTn_INTMASK_CTO_POS)                        /** UARTnINTMASK CTO-bit mask */

#define AG903_UARTn_RECEIVETIME_TIME_POS                   0                                                             /** UARTnRECEIVETIME TIME-bit position */
#define AG903_UARTn_RECEIVETIME_TIME_MSK                   (0xffffffffUL << AG903_UARTn_RECEIVETIME_TIME_POS)            /** UARTnRECEIVETIME TIME-bit mask */

#define AG903_UARTn_CHARINTERVAL_TIME_POS                  0                                                             /** UARTnCHARINTERVAL TIME-bit position */
#define AG903_UARTn_CHARINTERVAL_TIME_MSK                  (0xffffffffUL << AG903_UARTn_CHARINTERVAL_TIME_POS)           /** UARTnCHARINTERVAL TIME-bit mask */

#define AG903_UARTn_TIMEOUT_TIME_POS                       0                                                             /** UARTnTIMEOUT TIME-bit position */
#define AG903_UARTn_TIMEOUT_TIME_MSK                       (0xffffffffUL << AG903_UARTn_TIMEOUT_TIME_POS)                /** UARTnTIMEOUT TIME-bit mask */

#endif /* _AG903_UART_REGMAP_H_ */

