/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2023 AXELL CORPORATION, all rights reserved.
 *************************************************************************************
 * @brief		JPG encode code
 * @file		encode.c
 * @auther		AXELL
 * @date
 * @description
 * @note
 * @history		2019_12_27  [SDK3.0] TṽbZ[Wo͂ASCIIR[ĥ݂ɕύX (#2728)
 * @history		2023_03_31  [SDK3.5] JPGœTCỶ摜GR[hƏIȂȂsC (#4515)
 */
#include "jpg_sample.h"
#include "via/viamgr.h"
#include "pgp/pgpmgr.h"
#include "jpg/jpg.h"

/* f[^ */
static AG903_JPGHooks	gHook[AG903_JPG_HOOK_MAX];
static AG903_PgpMgrPipelineHandle	*gPipelineHdl;
static AG903_ViaMgrInputHandle		*gViaHdl;
static uint32_t		gJpgFlag=0;

/* Macro */
#define	GETSEQ()			(gJpgFlag)
#define	SETSEQ(SEQ)			(GETSEQ() |= (SEQ))
#define	CLRSEQ(SEQ)			(GETSEQ() &= ~(SEQ))
#define	WAITSEQ(SEQ, T)		do { sys_dlytsk(T); } while (0 == (gJpgFlag & (SEQ)))

/* vg^Cv */
static int32_t jpg_encode_file(uint32_t filetype);
static int32_t jpg_encode_capture(void);
static int32_t jpg_encode_repeat(uint32_t num);
static void	jpg_select_format(uint8_t *format);
static void	jpg_set_qscale(uint8_t *scale);
static int32_t jpg_read_yuv(char* name, uint8_t* buf, uint32_t bufsize, uint32_t* width, uint32_t* height);
static int32_t jpg_read_bmp(char* name, uint8_t* buf, uint32_t bufsize, uint32_t* dsize, uint32_t* width, uint32_t* height);
static int32_t jpg_write_jpg(char* name, uint8_t* buf, uint32_t size);
static int32_t jpg_bmp_to_yuv(uint8_t *bmp, uint8_t *yuv, uint32_t bmpsz, uint32_t bufsiz, uint32_t *yuvsz);
static int32_t jpg_setup_capture(void);
static int32_t jpg_start_capture(void);
static int32_t jpg_term_capture(void);
static void jpg_set_callback(AG903_JPGHandle* handle);
static void jpg_del_callback(AG903_JPGHandle* handle);
static void jpg_init_clbk(AG903_JPGHandle *handle, uint32_t param);
static void jpg_end_clbk(AG903_JPGHandle *handle, uint32_t param);
static void jpg_err_clbk(AG903_JPGHandle *handle, uint32_t param);

/**
 * @brief	GR[hC
 * @param	mode  [in] [h
 * @param	param [in] ʃp[^
 * @return	none
 * @note	none
 */
void encode_main(uint8_t mode, uint32_t param)
{
	((void)param);

	CLRSEQ(JPG_FLAG_ALL);

	switch (mode) {
		case 0:	/* Encode(YUV to JPEG) */
			jpg_encode_file(JPG_ENCFILE_YUV);
			break;
		case 1:	/* Encode(RGB to JPEG) */
			jpg_encode_file(JPG_ENCFILE_RGB);
			break;
		case 2:	/* Encode(CAPTURE to JPEG) */
			jpg_encode_capture();
			break;
		case 3:	/* Encode(YUV to JPEG Repeat) */
			jpg_encode_repeat(JPG_ENC_REPEAT_NUM);
			break;
			
		default:
			break;
	}

	return;
}

/**
 * @brief	GR[h (File)
 * @param	filetype[in] t@C
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_encode_file(uint32_t filetype)
{
	AG903_JPGHandle* 	handle;
	AG903_JPGCtrlParam	ini_param;
	AG903_JPGCodecParam	set_param;
	int32_t		ret = AG903_ENONE;
	uint32_t	width, height, size;
	uint8_t*	inbuf  = NULL;
	uint8_t*	outbuf = NULL;
	uint8_t*	rgbbuf = NULL;
	uint8_t		format = AG903_JPG_CCOMP_YUV422;

	/* il & H */
	uint8_t scale;
	jpg_set_qscale(&scale);
	AG903_JPGSetQScale(scale);
	AG903_JPGInit();

	ret = AG903_JPGGetHandle(&handle);
	if(AG903_ENONE != ret) {
		JPG_ErrPrintf("ERROR: Handle get");
		return ret;
	}
	jpg_set_callback(handle);
	jpg_select_format(&format);

	/* m */
	inbuf  = (uint8_t *)sys_memalign(JPG_YUVBUF_SIZE, 4);
	outbuf = (uint8_t *)sys_memalign(JPG_JPGBUF_SIZE, 4);
	if((NULL == inbuf) || (NULL == outbuf)) {
		JPG_ErrPrintf("ERROR: Memory alloc");
		return -AG903_EFAULT;
	}
	if(JPG_ENCFILE_RGB == filetype) {
		rgbbuf = (uint8_t *)sys_memalign(JPG_RGBBUF_SIZE, 4);
		if(NULL == rgbbuf) {
			JPG_ErrPrintf("ERROR: Memory alloc");
			return -AG903_EFAULT;
		}
	}

	do {
		/* t@CRead */
		if(JPG_ENCFILE_YUV == filetype) {
			ret = jpg_read_yuv((char*)JPG_INPUT_YUV_PATH, inbuf, JPG_YUVBUF_SIZE, &width, &height);
		}
		else {
			ret = jpg_read_bmp((char*)JPG_INPUT_RGB_PATH, rgbbuf, JPG_RGBBUF_SIZE, &size, &width, &height);
			if(AG903_ENONE == ret) {
				ret = jpg_bmp_to_yuv(rgbbuf, inbuf, size, JPG_YUVBUF_SIZE, &size);
			}
		}
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: File read");
			break;
		}

		/* R[fbN */
		ini_param.operation	  = AG903_JPG_ENDEC_ENCODE;
		ini_param.color_cmpnt = format;
		ini_param.EOImarker   = true;
		ini_param.RSTmarker   = true;
		ini_param.SOImarker   = true;
		ini_param.marker  	  = true;
		ini_param.SOSstop 	  = false;
		ini_param.interval    = 8;
		ret =  AG903_JPGInitCodec(handle, &ini_param);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec init");
			break;
		}
		WAITSEQ(JPG_FLAG_INIT_CODEC|JPG_FLAG_ERR_CODEC, 0);
		if(JPG_FLAG_ERR_CODEC & GETSEQ()) {
			JPG_ErrPrintf("ERROR: Codec init wait");
			break;
		}

		/* R[fbNJn */
		set_param.capture    = false;
		set_param.buf_flow   = false;
		set_param.flame_skip = false;
		set_param.h_size     = width;
		set_param.v_size     = height;
		set_param.in_buf     = (void*)(inbuf);
		set_param.out_buf    = (void*)(outbuf);
		set_param.stride     = width;
		if (set_param.stride < set_param.h_size) {
			JPG_ErrPrintf("ERROR: Stride size");
			break;
		}
		if (set_param.stride % 8) {
			JPG_ErrPrintf("ERROR: Stride size");
			break;
		}
		ret = AG903_JPGStartCodec(handle, &set_param);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec start");
			break;
		}
		WAITSEQ(JPG_FLAG_END_CODEC|JPG_FLAG_ERR_CODEC, 0);
		if(JPG_FLAG_ERR_CODEC & GETSEQ()) {
			JPG_ErrPrintf("ERROR: Codec end wait");
			break;
		}

		/* R[fbNI */
		ret = AG903_JPGEndCodec(handle);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec end");
			break;
		}

		/* t@CWrite */
		ret = AG903_JPGGetStreamSize(handle, &size);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Stream size get");
			break;
		}
		ret = jpg_write_jpg((char*)JPG_OUTPUT_ENC_PATH, outbuf, size);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: File write");
			break;
		}
	}while(0);

	jpg_del_callback(handle);

	/* nh */
	AG903_JPGReleaseHandle(handle);

	/*  */
	sys_free(inbuf);
	sys_free(outbuf);
	if(JPG_ENCFILE_RGB == filetype) {
		sys_free(rgbbuf);
	}

	return ret;
}

/**
 * @brief	GR[h (Capture)
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_encode_capture(void)
{
	AG903_JPGHandle* 	handle;
	AG903_JPGCtrlParam	ini_param;
	AG903_JPGCodecParam	set_param;
	int32_t		ret;
	uint32_t	size;
	uint8_t*	outbuf = NULL;
	uint8_t		format = AG903_JPG_CCOMP_YUV422;

	/* il & H */
	uint8_t scale;
	jpg_set_qscale(&scale);
	AG903_JPGSetQScale(scale);
	AG903_JPGInit();

	ret = AG903_JPGGetHandle(&handle);
	if(AG903_ENONE != ret) {
		JPG_ErrPrintf("ERROR: Handle get");
		return ret;
	}
	jpg_set_callback(handle);
	jpg_select_format(&format);

	ret = Board_SetupCvbs(TEST_CVBS_MODE);
	if(AG903_ENONE != ret) {
		JPG_ErrPrintf("ERROR: Video input setup");
		return ret;
	}

	/* m */
	outbuf = (uint8_t *)sys_memalign(JPG_JPGBUF_SIZE, 4);
	if(NULL == outbuf) {
		JPG_ErrPrintf("ERROR: Memory alloc");
		return -AG903_EFAULT;
	}

	do {
		/* pCvC */
		ret = jpg_setup_capture();
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Capture setup");
			break;
		}

		/* VIÃp[^ݒ肷܂Ŗ1b҂ărfI͂𔻒肷 */
		sys_dlytsk(1000);
		if (!AG903_ViaMgrIsInputValid(gViaHdl)) {
			JPG_ErrPrintf("ERROR: No video signal");
			break;
		}

		/* R[fbN */
		ini_param.operation	  = AG903_JPG_ENDEC_ENCODE;
		ini_param.color_cmpnt = format;
		ini_param.EOImarker   = true;
		ini_param.RSTmarker   = true;
		ini_param.SOImarker   = true;
		ini_param.marker  	  = true;
		ini_param.SOSstop 	  = false;
		ini_param.interval    = 8;
		ret =  AG903_JPGInitCodec(handle, &ini_param);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec init");
			break;
		}
		WAITSEQ(JPG_FLAG_INIT_CODEC|JPG_FLAG_ERR_CODEC, 0);
		if(JPG_FLAG_ERR_CODEC & GETSEQ()) {
			JPG_ErrPrintf("ERROR: Codec init wait");
			break;
		}

		/* R[fbNJn */
		set_param.capture    = true;
		set_param.buf_flow   = false;
		set_param.flame_skip = false;
		set_param.h_size     = TEST_CVBS_WIDTH;
		set_param.v_size     = TEST_CVBS_HEIGHT;
/*		set_param.in_buf     = Lv`H荞 */
		set_param.out_buf    = (void*)outbuf;
/*		set_param.stride     = Lv`H荞 */
		ret = AG903_JPGStartCodec(handle, &set_param);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec start");
			break;;
		}

		JPG_Printf(" Press enter key to start capture: ");
	    JPG_wait();	/* CRLF͑҂	*/
		/* pCvCJn */
		ret = jpg_start_capture();
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Capture start");
			break;
		}

		WAITSEQ(JPG_FLAG_END_CODEC|JPG_FLAG_ERR_CODEC, 0);
		if(JPG_FLAG_ERR_CODEC & GETSEQ()) {
			JPG_ErrPrintf("ERROR: Codec end wait");
			break;
		}

		/* R[fbNI */
		ret = AG903_JPGEndCodec(handle);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec end");
			break;
		}

		/* pCvC~ */
		ret = jpg_term_capture();
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Capture term");
			break;
		}

		/* t@CWrite */
		ret = AG903_JPGGetStreamSize(handle, &size);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Stream size get");
			break;
		}
		ret = jpg_write_jpg((char*)JPG_OUTPUT_CAP_PATH, outbuf, size);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: File write");
			break;
		}
	}while(0);

	jpg_del_callback(handle);

	/* nh */
	AG903_JPGReleaseHandle(handle);

	/*  */
	sys_free(outbuf);

	return ret;
}

/**
 * @brief	GR[h (JԂ)
 * @param	num [in] s
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_encode_repeat(uint32_t num)
{
	AG903_JPGHandle* 	handle;
	AG903_JPGCtrlParam	ini_param;
	AG903_JPGCodecParam	set_param;
	int32_t		ret = AG903_ENONE;
	uint32_t	loop;
	uint32_t	width, height;
	uint8_t*	inbuf  = NULL;
	uint8_t*	outbuf = NULL;
	uint8_t		format = AG903_JPG_CCOMP_YUV422;

	/* il & H */
	uint8_t scale;
	jpg_set_qscale(&scale);
	AG903_JPGSetQScale(scale);
	AG903_JPGInit();

	ret = AG903_JPGGetHandle(&handle);
	if(AG903_ENONE != ret) {
		JPG_ErrPrintf("ERROR: Handle get");
		return ret;
	}
	jpg_set_callback(handle);
	jpg_select_format(&format);

	/* m */
	inbuf  = (uint8_t *)sys_memalign(JPG_YUVBUF_SIZE, 4);
	outbuf = (uint8_t *)sys_memalign(JPG_JPGBUF_SIZE, 4);
	if((NULL == inbuf) || (NULL == outbuf)) {
		JPG_ErrPrintf("ERROR: Memory alloc");
		return -AG903_EFAULT;
	}

	do {
		/* t@CRead */
		ret = jpg_read_yuv((char*)JPG_INPUT_YUV_PATH, inbuf, JPG_YUVBUF_SIZE, &width, &height);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: File read");
			break;
		}

		/* R[fbN */
		ini_param.operation	  = AG903_JPG_ENDEC_ENCODE;
		ini_param.color_cmpnt = format;
		ini_param.EOImarker   = true;
		ini_param.RSTmarker   = true;
		ini_param.SOImarker   = true;
		ini_param.marker  	  = true;
		ini_param.SOSstop 	  = false;
		ini_param.interval    = 8;
		ret =  AG903_JPGInitCodec(handle, &ini_param);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec init");
			break;
		}
		WAITSEQ(JPG_FLAG_INIT_CODEC|JPG_FLAG_ERR_CODEC, 0);
		if(JPG_FLAG_ERR_CODEC & GETSEQ()) {
			JPG_ErrPrintf("ERROR: Codec init wait");
			break;
		}

		/* R[fbNJn */
		set_param.capture    = false;
		set_param.buf_flow   = false;
		set_param.flame_skip = false;
		set_param.h_size     = width;
		set_param.v_size     = height;
		set_param.in_buf     = (void*)(inbuf);
		set_param.out_buf    = (void*)(outbuf);
		set_param.stride     = width;
		for (loop=0; loop<num; loop++) {
			JPG_Printf(" # Encode %d\r\n", loop);
			CLRSEQ(JPG_FLAG_END_CODEC);
			ret = AG903_JPGStartCodec(handle, &set_param);
			if(AG903_ENONE != ret) {
				break;
			}
			WAITSEQ(JPG_FLAG_END_CODEC|JPG_FLAG_ERR_CODEC, 0);
			if(JPG_FLAG_ERR_CODEC & GETSEQ()) {
				break;
			}
		}
		if(AG903_ENONE != ret) {
			break;
		}

		/* R[fbNI */
		ret = AG903_JPGEndCodec(handle);
		if(AG903_ENONE != ret) {
			JPG_ErrPrintf("ERROR: Codec end");
			break;
		}
	}while(0);

	jpg_del_callback(handle);

	/* nh */
	AG903_JPGReleaseHandle(handle);

	/*  */
	sys_free(inbuf);
	sys_free(outbuf);
	
	return ret;
}

/**
 * @brief	tH[}bgI
 * @param	format [out] ItH[}bg
 * @return	none
 * @note	none
 */
static void	jpg_select_format(uint8_t *format)
{
	char  chara[4];
	int8_t	num;

	while(1){
		JPG_Printf(" select encode format\r\n");
		JPG_Printf(" 1:YUV420  2:YUV422\r\n");
		JPG_Printf(" ");
		COM_GetNum_Wait(chara, 3);  /* 3 = 1(format No.)+CRLF */
		num = ASCtoBIN(chara[0]);
		if(1==num) {
			(*format) = AG903_JPG_CCOMP_YUV420;
			break;
		}
		else if(2==num) {
			(*format) = AG903_JPG_CCOMP_YUV422;
			break;
		}
		else {
			JPG_Printf(" Invalid\r\n");
		}
	}

	return;
}

/**
 * @brief	il
 * @param	qscale [out] il
 * @return	none
 * @note	none
 */
static void	jpg_set_qscale(uint8_t *scale)
{
	char  chara[5];
	int8_t	num;

	while(1){
		JPG_Printf(" Input QScale [000-100]\r\n");
		JPG_Printf(" ");
		COM_GetNum_Wait(chara, 5);  /* 5 = 3(qscale)+CRLF */
		num = 0;
		if((chara[0]>='0') && (chara[0]<='1')){
			num += (ASCtoBIN(chara[0]) * 100);
			if((chara[1]>='0') && (chara[1]<='9')){
				num += (ASCtoBIN(chara[1]) * 10);
				if((chara[2]>='0') && (chara[2]<='9')){
					num += ASCtoBIN(chara[2]);
				}else{
					num = -1;
				}
			}else{
				num = -1;
			}
		}else{
			num = -1;
		}
		if((num == -1) || (num > 100)){
			JPG_Printf(" Invalid\r\n");
		}else{
			*scale = (uint8_t)num;
			break;
		}
	}

	return;
}

/**
 * @brief	YUVt@C[h
 * @param	name	[in]  t@C
 * @param	buf		[out] [hf[^
 * @param	bufsize	[in]  obt@TCY
 * @param	width	[out] 
 * @param	height	[out] 
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_read_yuv(char* name, uint8_t* buf, uint32_t bufsize, uint32_t* width, uint32_t* height)
{
	int32_t		ret;
	uint32_t	fsize;
	
	/* t@CTCY擾 */
	ret = jpg_GetFileSize(name, &fsize);
	if(AG903_ENONE != ret) {
		return -AG903_EFAULT;
	}
	if(fsize > bufsize) {
		return -AG903_EFAULT;
	}

	/* t@C[h */
	ret = jpg_ReadYUV(name, buf, fsize, width, height);
	if(AG903_ENONE != ret) {
		return -AG903_EFAULT;
	}

	JPG_Printf(" Read YUV data.\r\n pixel width :%8d\r\n", (unsigned int)(*width));
	JPG_Printf(" pixel height:%8d\r\n data  length:%8d\r\n",(unsigned int)(*height), (unsigned int)fsize);

	return AG903_ENONE;
}

/**
 * @brief	BMPt@C[h
 * @param	name	[in]  t@C
 * @param	buf		[out] [hf[^
 * @param	bufsize	[in]  obt@TCY
 * @param	dsize	[out] f[^TCY
 * @param	width	[out] 
 * @param	height	[out] 
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_read_bmp(char* name, uint8_t* buf, uint32_t bufsize, uint32_t* dsize, uint32_t* width, uint32_t* height)
{
	int32_t		ret;

	ret = jpg_ReadBitmap(name, buf, bufsize, dsize, width, height);
	if(AG903_ENONE != ret) {
		return -AG903_EFAULT;
	}
	
	JPG_Printf(" Read RGB data.\r\n pixel width :%8d\r\n", (unsigned int)(*width));
	JPG_Printf(" pixel height:%8d\r\n data  length:%8d\r\n",(unsigned int)(*height), (unsigned int)(*dsize));

	return AG903_ENONE;
}

/**
 * @brief	JPGt@CCg
 * @param	name	[in] t@C
 * @param	buf		[in] Cgf[^
 * @param	size	[in] CgTCY
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_write_jpg(char* name, uint8_t* buf, uint32_t size)
{
	int32_t		ret;
	uint32_t	strsz;

	strsz = (*(uint32_t*)buf) << 2;	/* 擪1[h̓Xg[TCY([hP) */
	if(strsz != size) {
		return -AG903_EFAULT;
	}

	buf += sizeof(int32_t);
	ret = jpg_OpenWrite(name, buf, size);
	if(AG903_ENONE != ret) {
		return -AG903_EFAULT;
	}

	JPG_Printf(" Write JPEG file.\r\n");
	
	return AG903_ENONE;
}

typedef struct {
	unsigned char r;
	unsigned char g;
	unsigned char b;
}	RGB;
/**
 * @brief	rbg}bvYUVϊ
 * @param	bmp    [in]  rbg}bvf[^
 * @param	yuv    [out] YUVf[^
 * @param	bmpsz  [in]  rbg}bvf[^TCY
 * @param	bufsiz [in]  obt@TCY
 * @param	yuvsz  [out] YUVf[^TCY
 * @return	AG903_ENONE   I
 * @return	-AG903_EFAULT obt@s
 * @note
*/
static int32_t jpg_bmp_to_yuv(uint8_t *bmp, uint8_t *yuv, uint32_t bmpsz, uint32_t bufsiz, uint32_t *yuvsz)
{
	int32_t		rc = AG903_ENONE;
	RGB			rgb[2];
	int16_t		y0, y1, cb, cr;
	uint32_t	ptr;
	uint32_t	ii;

	ptr  = 0;

	/*--- 2sNZ ---*/

	for (ii = 0;ii < bmpsz;) {
		/*--- F擾 & Xbv(BGR to RGB) ---*/

		rgb[0].b = bmp[ii++];													/* 1sNZBGR				*/
		rgb[0].g = bmp[ii++];													/*								*/
		rgb[0].r = bmp[ii++];													/*								*/
		rgb[1].b = bmp[ii++];													/* 2sNZBGR				*/
		rgb[1].g = bmp[ii++];													/*								*/
		rgb[1].r = bmp[ii++];													/*								*/

		/***********************************************************************************************************
		 * ITU-R BT.601/ITU-R BT.709ɊÂvZ
		 * - RGB to YUV ------------------------------------------------------------------------------------------
		 * Y  =  0.299R + 0.587G + 0.114B
		 * Cr = -0.169R - 0.331G + 0.500B + 128
		 * Cb =  0.500R - 0.419G - 0.081B + 128
		 * -------------------------------------------------------------------------------------------------------
		 * R = 1.000Y                   + 1.402(Cr - 128)
		 * G = 1.000Y - 0.344(Cb - 128) - 0.714(Cr - 128)
		 * B = 1.000Y + 1.772(Cb - 128)
		 * -------------------------------------------------------------------------------------------------------
		 * CbCr(PbPr)̃f[^͈͂0`255itWjƂ+128Ă̂ŗӂ邱
		 * 8bitE256K̃f[^̏ꍇARGBf[^ł0`255܂ł̑SKitWjp̂ʓIA
		 *   YUVf[^łY16`235AUAV16`240̌肳ꂽKi~ebhWjʓIɗp
		 *   ׁ̈Af[^ϊ̍ۂ̓tWE~ebhWlȂƉf̍ȂǂNĂ܂
		 ***********************************************************************************************************/

		/*--- Px̌vZ ---*/

		y0 = (299 * rgb[0].r + 587 * rgb[0].g + 114 * rgb[0].b) / 1000;
		y1 = (299 * rgb[1].r + 587 * rgb[1].g + 114 * rgb[1].b) / 1000;

		/*--- F̌vZ ---*/

		cb = (((500 * rgb[0].b) - (169 * rgb[0].r) - (331 * rgb[0].g))
			+ ((500 * rgb[1].b) - (169 * rgb[1].r) - (331 * rgb[1].g))) / 2 / 1000 + 128;
		cr = (((500 * rgb[0].r) - (419 * rgb[0].g) - ( 81 * rgb[0].b))
			+ ((500 * rgb[1].r) - (419 * rgb[1].g) - ( 81 * rgb[1].b))) / 2 / 1000 + 128;

		/*--- vZʂ Cb Y0 Cr Y1 ̏ԂɊi[([J[ɃtH[}bgقȂ镔) ---*/

		if (y0 > 255) { y0 = 255; }
		if (y1 > 255) { y1 = 255; }
		if (cb > 255) { cb = 255; }
		if (cr > 255) { cr = 255; }

		if (y0 < 0) { y0 = 0; }
		if (y1 < 0) { y1 = 0; }
		if (cb < 0) { cb = 0; }
		if (cr < 0) { cr = 0; }

		if(bufsiz < (ptr+4)) {
			rc = -AG903_EFAULT;
			break;
		}
		yuv[ptr++] = (uint8_t)cb;
		yuv[ptr++] = (uint8_t)y0;
		yuv[ptr++] = (uint8_t)cr;
		yuv[ptr++] = (uint8_t)y1;
	}

	(*yuvsz) = ptr;

	return rc;
}










/**
 * @brief	pCvC
 * @param	none
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_setup_capture(void)
{
	int32_t	rc = AG903_ENONE;
	int32_t	pipe;
	int32_t	via_port[1] = { 0, };

	gPipelineHdl = NULL;
	gViaHdl      = NULL;

	/* pCvCnhAAiOrfI̓nh̎擾 */
	if (rc == AG903_ENONE) { rc = AG903_PgpMgrGetPipelineHandle(1, &gPipelineHdl);                                                   }
	if (rc == AG903_ENONE) { rc = AG903_ViaMgrGetInputHandle(via_port, 1, &gViaHdl);                                                 }
	/* AiOrfI͂̐ݒ */
	if (rc == AG903_ENONE) { rc = AG903_ViaMgrSetInputParameter(gViaHdl, AG903_VIA_MGR_FORMAT_NTSC_BT, AG903_VIA_MGR_MODE_COLOR);    }
	{/* pCvC̃p[^ݒ(pCvC蓖đOɐݒ肷邱 */
		if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetParamInputMode(gPipelineHdl, AG903_PGP_MGR_INPUT_MD_VSYNC);                     }/* Lv`͓샂[h			*/
		if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetParamOutputFormat(gPipelineHdl, AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR422); }/* o̓tH[}bg					*/
		if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetParamInputFormat(gPipelineHdl, AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP);          }/* ̓tH[}bg					*/
		if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetParamInputSize(gPipelineHdl, TEST_CVBS_HEIGHT/2, TEST_CVBS_WIDTH);              }/* Lv`TCY					*/
		if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetParamInputPosition(gPipelineHdl, AG903_CAPTURE_VPOS_NTSC_BT, AG903_CAPTURE_HPOS_NTSC_BT); }/* Lv`JnW		*/
		if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetInputPort(gPipelineHdl, gViaHdl);                                               }/* pCvC̓̓|[g֐ڑ	*/
	}

	if (rc == AG903_ENONE) {
		pipe = AG903_PgpMgrAssignPipeline(gPipelineHdl);																			/* pCvC蓖				*/
		if (pipe >= 0) {
			if (rc == AG903_ENONE) { rc = AG903_PgpMgrSetJPEG(gPipelineHdl);  }
			if (rc == AG903_ENONE) { rc = AG903_PgpMgrEnableJPEG(true);       }
			gPipelineHdl->frame_out_enable = false;
		}
	}

	return rc;
}

/**
 * @brief	pCvCJn
 * @param	none
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_start_capture(void)
{
	int32_t	rc;

	rc = AG903_PgpMgrExecPipeline(gPipelineHdl, AG903_PGP_MGR_CMD_EXEC);

	return rc;
}

/**
 * @brief	pCvCI
 * @param	none
 * @return	AG903_ENONE		I
 * @return	AG903_ENONEȊO	G[R[h
 * @note	none
 */
static int32_t jpg_term_capture(void)
{
	int32_t		rc;
	uint32_t	status;

	rc = AG903_PgpMgrExecPipeline(gPipelineHdl, AG903_PGP_MGR_CMD_IDLE);
	if(AG903_ENONE == rc) {
		/* pCvCIDLEɂȂ܂ő҂킹 */
		do {
			rc = AG903_PgpMgrGetPipelineStatus(gPipelineHdl, NULL, NULL, NULL, NULL, &status);
			if(AG903_ENONE != rc) {
				break;
			}
		}while(status != AG903_PGP_MGR_STATE_IDLE);
	}
	if (rc == AG903_ENONE) { rc = AG903_PgpMgrEnableJPEG(false);  }
	if (rc == AG903_ENONE) { rc = AG903_PgpMgrReleasePipelineHandle(gPipelineHdl);  }
	if (rc == AG903_ENONE) { rc = AG903_ViaMgrReleaseInputHandle(gViaHdl);  }

	return rc;
}

/**
 * @brief	R[obNݒ
 * @param	handle [in] JPGnh
 * @return	none
 * @note	none
 */
static void jpg_set_callback(AG903_JPGHandle* handle)
{
	int32_t	loop;
	
	for (loop = AG903_JPG_HOOK_CMP;loop < AG903_JPG_HOOK_MAX;loop++) {
		gHook[loop].param = 0;
		gHook[loop].clbk  = (AG903_JPGClbk)NULL;
	}

	gHook[AG903_JPG_HOOK_INITF].clbk  = jpg_init_clbk;
	gHook[AG903_JPG_HOOK_INITF].param = 0;
	gHook[AG903_JPG_HOOK_CMP  ].clbk  = jpg_end_clbk;
	gHook[AG903_JPG_HOOK_CMP  ].param = 0;
	gHook[AG903_JPG_HOOK_NG   ].clbk  = jpg_err_clbk;
	gHook[AG903_JPG_HOOK_NG   ].param = 0;
	gHook[AG903_JPG_HOOK_ESTE ].clbk  = jpg_err_clbk;
	gHook[AG903_JPG_HOOK_ESTE ].param = 0;
	gHook[AG903_JPG_HOOK_CAPE ].clbk  = jpg_err_clbk;
	gHook[AG903_JPG_HOOK_CAPE ].param = 0;
	gHook[AG903_JPG_HOOK_IMGE ].clbk  = jpg_err_clbk;
	gHook[AG903_JPG_HOOK_IMGE ].param = 0;
	gHook[AG903_JPG_HOOK_STRE ].clbk  = jpg_err_clbk;
	gHook[AG903_JPG_HOOK_STRE ].param = 0;
	AG903_JPGSetHooks(handle, &gHook[0]);

	return;
}

/**
 * @brief	R[obN폜
 * @param	handle [in] JPGnh
 * @return	none
 * @note	none
 */
static void jpg_del_callback(AG903_JPGHandle* handle)
{
	int32_t	loop;
	
	for (loop = AG903_JPG_HOOK_CMP;loop < AG903_JPG_HOOK_MAX;loop++) {
		gHook[loop].param = 0;
		gHook[loop].clbk  = (AG903_JPGClbk)NULL;
	}
	AG903_JPGSetHooks(handle, &gHook[0]);

	return;
}

/** R[fbNR[obN */
static void jpg_init_clbk(AG903_JPGHandle *handle, uint32_t param)
{
	((void)handle);
	((void)param);

	SETSEQ(JPG_FLAG_INIT_CODEC);
}

/** R[fbNf[^]R[obN */
static void jpg_end_clbk(AG903_JPGHandle *handle, uint32_t param)
{
	((void)handle);
	((void)param);

	SETSEQ(JPG_FLAG_END_CODEC);
}

/** R[fbNG[R[obN */
static void jpg_err_clbk(AG903_JPGHandle *handle, uint32_t param)
{
	((void)handle);
	((void)param);

	SETSEQ(JPG_FLAG_ERR_CODEC);
}
