/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#ifndef __JPG_SAMPLE_H__
#define __JPG_SAMPLE_H__

#include "sample_common.h"
#include "com.h"

/* Param */
#define	JPG_INPUT_DEC_PATH		"A:\\jpg_sample.jpg"
#define	JPG_INPUT_YUV_PATH		"A:\\jpg_sample.yuv"
#define	JPG_INPUT_RGB_PATH		"A:\\jpg_sample.bmp"
#define	JPG_INPUT_MOV_PATH		"A:\\jpg_sample.mov"

#define	JPG_OUTPUT_ENC_PATH		JPG_INPUT_DEC_PATH
#define	JPG_OUTPUT_YUV_PATH		JPG_INPUT_YUV_PATH
#define	JPG_OUTPUT_CAP_PATH		"A:\\jpg_capture.jpg"

#define	JPG_YUVBUF_SIZE			(16 << 20)
#define	JPG_RGBBUF_SIZE			(16 << 20)
#define	JPG_BMUBUF_SIZE			(16 << 20)
#define	JPG_JPGBUF_SIZE			( 8 << 20)
#define	JPG_WORKBUF_SIZE		(24 << 20)
#define	JPG_WINATTR_SIZE		(512)
#define	JPG_BMUFIFO_NUM			(4)
#define JPG_ENC_REPEAT_NUM		(10)

#define JPG_FLAG_INIT_CODEC		(1<<0)
#define JPG_FLAG_START_CODEC	(1<<1)
#define JPG_FLAG_END_CODEC		(1<<2)
#define JPG_FLAG_ERR_CODEC		(1<<3)
#define JPG_FLAG_ALL			(JPG_FLAG_INIT_CODEC|JPG_FLAG_START_CODEC|JPG_FLAG_END_CODEC|JPG_FLAG_ERR_CODEC)

enum {	/* ENCODEt@C */
	JPG_ENCFILE_YUV=0,
	JPG_ENCFILE_RGB,
};

/* Macro */
#define JPG_Printf(FMT, ...)	sys_print(0, FMT,##__VA_ARGS__)
#define JPG_ErrPrintf(FMT, ...)	sys_print(1, FMT,##__VA_ARGS__)

/* vg^Cv */
void JPG_wait(void);
int32_t jpg_GetFileSize(char* fname, uint32_t* fsize);
int32_t jpg_OpenRead(char* fname, uint8_t* buf, uint32_t fsize);
int32_t jpg_OpenWrite(char* fname, uint8_t* buf, uint32_t fsize);
int32_t	jpg_ReadYUV(char* fname, uint8_t* buf, uint32_t fsize, uint32_t* width, uint32_t* height);
int32_t	jpg_WriteYUV(char* fname, uint8_t* buf, uint32_t fsize, uint32_t width, uint32_t height);
int32_t	jpg_ReadBitmap(char* fname, uint8_t* buf, uint32_t bufsz, uint32_t* dsize, uint32_t* width, uint32_t* height);

#endif/* __JPG_SAMPLE_H__ */
