/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* VGImageIuWFNg */
static VGImage image1, image2;

static void *image_data1, *image_data2;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {0.5F, 0.5F, 0.5F, 0.5F};

    /* 摜Ǎ */
    image_data1 = GfxGetFreeArea(BLEND_WIDTH, BLEND_HEIGHT, BLEND_BPP<<3);
    GfxFsRead((int8_t*)BLEND_NAME1, BLEND_STRIDE * BLEND_HEIGHT, (void*)image_data1);
    image_data2 = GfxGetFreeArea(BLEND_WIDTH, BLEND_HEIGHT, BLEND_BPP<<3);
    GfxFsRead((int8_t*)BLEND_NAME2, BLEND_STRIDE * BLEND_HEIGHT, (void*)image_data2);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGImageIuWFNg̐ (Dst) */
    image1 = vgCreateImage(VG_sRGBA_8888, BLEND_WIDTH, BLEND_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image1, image_data1, BLEND_STRIDE, VG_sRGBA_8888, 0, 0, BLEND_WIDTH, BLEND_HEIGHT);

    /* VGImageIuWFNg̐ (Src) */
    image2 = vgCreateImage(VG_sRGBA_8888, BLEND_WIDTH, BLEND_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(image2, image_data2, BLEND_STRIDE, VG_sRGBA_8888, 0, 0, BLEND_WIDTH, BLEND_HEIGHT);

    /* |CgTv */
    vgSeti(VG_IMAGE_QUALITY, VG_IMAGE_QUALITY_NONANTIALIASED);

    /* IMAGE_USER_TO_SURFACEPʍsɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
    vgLoadIdentity();
}

static void DrawWithBlend(void)
{
    /* SRCiuhj */
    vgTranslate(15, 30);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image2);

    /* SRC_OVER */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC_OVER);
    vgDrawImage(image2);

    /* DST_OVER */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_DST_OVER);
    vgDrawImage(image2);

    /* SRC_IN */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC_IN);
    vgDrawImage(image2);

    /* DST_IN */
    vgTranslate(-480, 150);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_DST_IN);
    vgDrawImage(image2);

    /* MULTIPLY */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_MULTIPLY);
    vgDrawImage(image2);

    /* SCREEN */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SCREEN);
    vgDrawImage(image2);

    /* DARKEN */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_DARKEN);
    vgDrawImage(image2);

    /* LIGHTEN */
    vgTranslate(-480, 150);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_LIGHTEN);
    vgDrawImage(image2);

    /* ADDITIVE */
    vgTranslate(160, 0);
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC);
    vgDrawImage(image1);
    vgSeti(VG_BLEND_MODE, VG_BLEND_ADDITIVE);
    vgDrawImage(image2);

    /* VG_BLEND_MODEftHgɐݒ */
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC_OVER);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data1);
    GfxReleaseFreeArea(image_data2);

    /* IuWFNg̔j */
    vgDestroyImage(image1);
    vgDestroyImage(image2);
}

void BlendMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* uh */
    DrawWithBlend();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}

