/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2021 AXELL CORPORATION, all rights reserved.
 */
/*
 * @history 2021_06_30  [SDK3.3] OpenVGTvBMUGFX̘AgɊւAPÏƉRgC (#3528)
 */
#include <stdint.h>
#include <stdbool.h>
#include <math.h>

#include "EGL/eglext_AG903.h"
#include "EGL/egl.h"
#include "VG/openvg.h"
#include "VG/vgext_AG903.h"
#include "vxlib.h"
#include "gmalloc.h"

#include "dsp/dspmgr.h"
#include "bmu/bmumgr.h"
#include "pgp/pgpmgr.h"
#include "pgp/pgpprm.h"
#include "pgp/pgpmgr.h"
#include "via/viamgr.h"

#include "sample_common.h"
#include "gfx_sample.h"
#include "openvg_port_uc3.h"

#include "bmugfx.h"


#define PRINTLN(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)

/* vgExtOutLevelControlEXT܂vgExtInWaitControlEXT̈̃rbg` */
#define SNK0_BIT	(1<<(0+0))	/* BMUGFX0VNfoCX */
#define SNK1_BIT	(1<<(1+0))	/* BMUGFX1VNfoCX */
#define SNK2_BIT	(1<<(2+0))	/* BMUGFX2VNfoCX */
#define SNK3_BIT	(1<<(3+0))	/* BMUGFX3VNfoCX */
#define SRC0_BIT	(1<<(0+8))	/* BMUGFX0\[XfoCX */
#define SRC1_BIT	(1<<(1+8))	/* BMUGFX1\[XfoCX */
#define SRC2_BIT	(1<<(2+8))	/* BMUGFX2\[XfoCX */
#define SRC3_BIT	(1<<(3+8))	/* BMUGFX3\[XfoCX */

#define CYCLE	600	// fPTCN
#define DEG2RAD(D)	(2.0*3.14159265*(D)/360.0)

/**
  Lv`摜`ŕό`Hĕ\܂B
  Lv`-`Ԃƕ`-\Ԃɂꂼobt@Ǘ
  n[hEFAŃOobt@̂悤ȃf[^̑҂킹s܂B
  \tgEFAIɂ̓f[^t[Cɂ`ɂW邱Ƃł悤ɂȂ܂B
  ȒPA^CȐ䂪\ɂȂ܂B

  \[XBMUdl
  R}܂B

  f[^t[}
  PGP-BMU(src)-GFX-BMU(sink)-DSP

  obt@Ǘ̃y[W̖ڈ:
  obt@Ǘ̃y[W͋Ə̃[gقړł3ŏ\łB
  ȉł̓R}т\oĂ܂A҂̈ʑĂ邩ʑ͈̔͂ŋꍇ2ł肠܂B
  ̃X[vbgꍇ̓y[W𑝂₷ƂŃR}т}ʂ҂ł܂B

  obt@Ǘő҂邱ƂłȂytF܂B
  \ALv`͑҂邱Ƃł܂B̂悤ȃytFɑ΂ăobt@Ǘ̓샂[h0-1gpĂ҂ǂɓ삳邱Ƃ͂ł܂B

*/




static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {0.5F, 0.5F, 0.5F, 1.0F};

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);
}

static void TestTerm()
{

}

//---------------- Capture ----------------
#define PIPELINE_NUM			1
#define CVBS_NUM				1

static AG903_PgpMgrPipelineHandle	*pipeline_handle[PIPELINE_NUM] = {NULL};
static AG903_ViaMgrInputHandle		*via_handle[CVBS_NUM] = {NULL};
static int32_t						via_port[CVBS_NUM] = {0}; //={0,1,2,3};
// static AG903_PgpMgrDGCLookupTable	*dgc_tables[DGC_TBL_NUM] = {0};

static void pgp_intr_vram(int32_t id, void* handle)
{
	// VRAMo͖荞݂̂ƂɃpCvCZbgĕ܂
	// ̊荞݂vɂ͎̂悤Ȃ̂܂B
	// EDRAM̑шs
	// ErfIM̗⒆f
	// EԂBMUւ̏o
	
	AG903_PgpMgrPipelineHandle	*pgp_handle;
	int32_t						pipeline_no;
	(void)id;

	pgp_handle = (AG903_PgpMgrPipelineHandle*)handle;
	pipeline_no = pgp_handle->pipeline_no;

	AG903_PgpMgrExecPipeline(pgp_handle, AG903_PGP_MGR_CMD_FORCE_QUIT);
	AG903_PgpMgrReleaseAssignment(pgp_handle);

	AG903_PgpMgrSetInputPort(pgp_handle, via_handle[pipeline_no]);
	AG903_PgpMgrForceAssignPipeline(pgp_handle, pipeline_no);
	AG903_PgpMgrExecPipeline(pgp_handle, AG903_PGP_MGR_CMD_EXEC_CONTINUE);
}

int32_t CaptureInit(void)
{
    /* AiO͂̏ */
	Board_SetupCvbs(TEST_CVBS_NTSC_BT);
	AG903_ViaMgrInit();

    /* pCvCnhAAiOrfI̓nh̎擾 */
    AG903_PgpMgrGetPipelineHandle(PIPELINE_NUM, pipeline_handle);
    AG903_ViaMgrGetInputHandle(via_port, CVBS_NUM, via_handle);

    /* AiOrfI͂̐ݒ */
	AG903_ViaMgrInputHandle *via0 = via_handle[0];
    AG903_ViaMgrSetInputParameter(via0, AG903_VIA_MGR_FORMAT_NTSC_BT, AG903_VIA_MGR_MODE_COLOR);
	//AG903_ViaMgrSetColorCorrection(via0, 0);

    /* pCvC̐ݒ */
	AG903_PgpMgrPipelineHandle	*pgp0 = pipeline_handle[0];
    AG903_PgpMgrSetParamOutputFormat(pgp0,AG903_PGP_MGR_OUTPUT_FMT_YCBCR444_TO_YCBCR422);
	AG903_PgpMgrSetParamInputFormat(pgp0, AG903_PGP_MGR_INPUT_FMT_YCBCR422_W_IP);
	AG903_PgpMgrSetConfigOutputBaseAddr(pgp0, (void *)gfx_bg_srcadr);
    AG903_PgpMgrSetParamOutputAddrDim(pgp0, AG903_PGP_MGR_ADDR_DIMENTION_2);
    AG903_PgpMgrSetParamOutputStride(pgp0, BG_WIDTH*BG_BPP/8);
	AG903_PgpMgrSetParamInputPosition(pgp0, 12, 120); // JˑɂKv
    AG903_PgpMgrSetParamInputSize(pgp0, BG_HEIGHT/2, BG_WIDTH);

	/* CxggKL (VLineI, VSyncI, VLineO, VSyncO) */
	// AG903_PgpMgrSetParamInputMode(pgp0, AG903_PGP_MGR_INPUT_MD_VSYNC);
	AG903_PgpMgrSetParamOutputBMU(pgp0, AG903_PGP_MGR_OUTPUT_BMU_ENABLE);
	// AG903_PgpMgrEnableParamTrigCtrl(pgp0, false, false, false, true);
	// AG903_PgpMgrEnableParamTrigCtrl(pgp0, true, true, true, true);	

	// 荞
	AG903_PgpMgrSetIntrCallbackFunc(pgp0, AG903_PGP_MGR_INTR_VRAM_ERROR, pgp_intr_vram);

    /* pCvC̓̓|[g֐ڑ */
    AG903_PgpMgrSetInputPort(pgp0, via0);
    /* pCvC蓖 */
	AG903_PgpMgrForceAssignPipeline(pgp0, 0);

	// Start!
	AG903_PgpMgrExecPipeline(pgp0, AG903_PGP_MGR_CMD_EXEC_CONTINUE);

    return 0;
}

static int32_t CaptureTerm(void)
{
    uint32_t status;
	AG903_ViaMgrInputHandle *via0 = via_handle[0];
	AG903_PgpMgrPipelineHandle	*pgp0 = pipeline_handle[0];

    /* ALv`̒~ */
    AG903_PgpMgrExecPipeline(pgp0, AG903_PGP_MGR_CMD_IDLE);

    /* pCvCIDLEɂȂ܂ő҂킹 */
    while (1) {
        AG903_PgpMgrGetPipelineStatus(pgp0, NULL, NULL, NULL, NULL, &status);
        if (status == 0) {
            break;
        }
    }

    /* nh */
    AG903_PgpMgrReleasePipelineHandle(pgp0);
    AG903_ViaMgrReleaseInputHandle(via0);

    return 0;
}

void BmuGfxMain(void)
{
    /*  */
	CaptureInit();
    TestInit(GFX_WIDTH, GFX_HEIGHT);

	// Lv`摜VGImagẽf[^\͊i[郉C̏㉺tłB
	VGImage directImage =
		vgCreateDirectImageEXT(VG_EXT_YUV422,
							   BG_WIDTH,
							   BG_HEIGHT,
							   VG_IMAGE_QUALITY_FASTER,
							   (const void *)gfx_bg_snkadr,
							   BG_WIDTH*BG_BPP/8);

	// YUV-RGBϊ̌W
	static VGint yuv_rgb_coef[9] = {
		0x12A, 0x000, 0x199,
		0x12A, 0x79C, 0x730,
		0x12A, 0x204, 0x000
	}; /* BT.601 Limit */
	vgSetivEXT(VG_EXT_YUV_RGB_COEFFICIENT, 9, yuv_rgb_coef);
	
	// RGB-YUVϊ̌W
	// static VGint rgb_yuv_coef[9] = {
	// 	0x107, 0x204, 0x064,
	// 	0x768, 0x6D6, 0x1C1,
	// 	0x1C1, 0x687, 0x7B6
	// }; /* BT.601 Limit */
	// vgSetivEXT(VG_EXT_RGB_YUV_COEFFICIENT, 9, rgb_yuv_coef);

	vgSetiEXT(VG_EXT_YUV_RGB_CONVERSION, (VG_EXT_RGB2YUV_B3_Y1|VG_EXT_RGB2YUV_B2_V|VG_EXT_RGB2YUV_B1_Y0|VG_EXT_RGB2YUV_B0_U|VG_EXT_YUV2RGB_Y0_B1|VG_EXT_YUV2RGB_Y1_B3|VG_EXT_YUV2RGB_V_B2|VG_EXT_YUV2RGB_U_B0));
	
	int fr = 0;
	while (fr <= CYCLE) {
		VGfloat ClearColor[3][4]  = {
			[0] ={0.1F, 0.1F, 0.1F, 1.0F},
			[1] ={0.5F, 0.5F, 0.5F, 1.0F},
			[2] ={0.9F, 0.9F, 0.9F, 1.0F},
		};

		uint16_t bmureq;
		bmureq = 0x0000;

		// DS-1. 쉺BMUSrcReqo͂܂
		bmureq |= SRC0_BIT;
		vgExtOutLevelControlEXT(bmureq, VG_TRUE);
		// DS-2. 쉺BMUSrcAck҂܂
		vgExtInWaitControlEXT(SRC0_BIT);

		// DS-3. 쉺BMUŃAhXϊ̏ł̂œDRAM֕`\ł

		// US-1. BMUSnkReqo͂܂(쉺ւSrcReqp)
		bmureq |= SNK0_BIT;
		vgExtOutLevelControlEXT(bmureq, VG_TRUE);
		// US-2. BMUSnkAck҂܂
		vgExtInWaitControlEXT(SNK0_BIT);

		// US-3. BMUŃAhXϊ̏ł̂œDRAMQƉ\ł

		// DirectImagȅ㉺𐳂ď]
		vgSetfv(VG_CLEAR_COLOR, 4, ClearColor[0]);
		vgClear(0, 0, GB_WIDTH, GB_HEIGHT);

		vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
		vgLoadIdentity();

		vgScale(1.0, -1.0); // Xŉ]ď㉺𐳂
		vgTranslate(0.0, (VGfloat)-BG_HEIGHT); // ̌ʁAʂ̊O֏o摜グ

		VGfloat deg = 45.0f * sinf(DEG2RAD(360.0f) * (VGfloat)fr/(VGfloat)CYCLE);
		vgRotate(deg);

		vgDrawImage(directImage);
		vgFinish();
		
		// DS-4. DRAMւ̕`悪ׂďI쉺̂ւSrcReq܂
		bmureq &= ~SRC0_BIT;
		vgExtOutLevelControlEXT(bmureq, VG_TRUE);

		// US-4. DRAMւ̕`悪ׂďIւSnkReq܂
		bmureq &= ~SNK0_BIT;
		vgExtOutLevelControlEXT(bmureq, VG_TRUE);


		/* rfIM̗͂LmF(Lv`肷܂500msxKv) */
		if (fr == 60/2) {
			if (!AG903_ViaMgrIsInputValid(via_handle[0])) {
				PRINTLN("No video input signal");
			}
		}

		fr++;
	}

	vgDestroyImage(directImage);

    // /* I */
	CaptureTerm();
	TestTerm();
}
