/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

/* VGImageIuWFNg */
static VGImage srcImage;

/* J[}gNXniR->G, G->B, B->R, A->ϊj */
static VGfloat matrix[20] = {
    0, 1, 0, 0,
    0, 0, 1, 0,
    1, 0, 0, 0,
    0, 0, 0, 1,
    0, 0, 0, 0
};

/* R{[VtB^n */
#define SCALE   1
#define BIAS    0
static VGshort kernel[9] = {
    0, 1, 0,
    1,-4, 1,
    0, 1, 0
};

/* bNAbve[uiRϊj */
static VGubyte rLUT[256] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
    64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
    80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
    96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
    112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
    144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
    160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
    176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
    192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
    208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
    224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
    240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* bNAbve[uiGvf4Kj */
static VGubyte gLUT[256] = {
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
    80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
    80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
    80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
    160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
    160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
    160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
    160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
    240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
    240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
    240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
    240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
};

/* bNAbve[uiBvf]j */
static VGubyte bLUT[256] = {
    255, 254, 253, 252, 251, 250, 249, 248, 247, 246, 245, 244, 243, 242, 241, 240,
    239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226, 225, 224,
    223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 209, 208,
    207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192,
    191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176,
    175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160,
    159, 158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144,
    143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128,
    127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112,
    111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96,
    95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80,
    79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64,
    63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48,
    47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32,
    31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16,
    15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0
};

/* bNAbve[uiAvfS0.5j */
static VGubyte aLUT[256] = {
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
    128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
};

static void *image_data;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* 摜Ǎ */
    image_data = GfxGetFreeArea(FILTER_WIDTH, FILTER_HEIGHT, FILTER_BPP<<3);
    GfxFsRead((int8_t*)FILTER_NAME, FILTER_STRIDE * FILTER_HEIGHT, (void*)image_data);

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGImageIuWFNg̐ */
    srcImage = vgCreateImage(VG_sRGBA_8888, FILTER_WIDTH, FILTER_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED | VG_IMAGE_QUALITY_FASTER | VG_IMAGE_QUALITY_BETTER);

    /* VGImageIuWFNgɃC[Wf[^o^ */
    vgImageSubData(srcImage, image_data, FILTER_STRIDE, VG_sRGBA_8888, 0, 0, FILTER_WIDTH, FILTER_HEIGHT);

    /* ݂̃}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);

    /* s񏉊 */
    vgLoadIdentity();
}

static void ImageFilter(void)
{
    VGImage dstImage;

    /* C[WtB^ʂ̃C[W */
    dstImage = vgCreateImage(VG_sRGBA_8888, FILTER_WIDTH, FILTER_HEIGHT, VG_IMAGE_QUALITY_NONANTIALIASED);

    /* C[WʒɃRs[ */
    vgSetPixels(220, 165, srcImage, 0, 0, FILTER_WIDTH, FILTER_HEIGHT);

    /* J[}gNX iR->GAG->BAB->Rj*/
    vgColorMatrix(dstImage, srcImage, matrix);
    /* ʂʍɃRs[ */
    vgSetPixels(10, 10, dstImage, 0, 0, FILTER_WIDTH, FILTER_HEIGHT);

    /* bNAbve[uiRϊAGvf4KABvf]AAvfS0.5j */
    vgLookup(dstImage, srcImage, rLUT, gLUT, bLUT, aLUT, VG_FALSE, VG_FALSE);
    /* ʂʉEɃRs[ */
    vgSetPixels(430, 10, dstImage, 0, 0, FILTER_WIDTH, FILTER_HEIGHT);

    /* R{[VtB^iGbWoj */
    vgConvolve(dstImage, srcImage, 3, 3, 1, 1, kernel, SCALE, BIAS, VG_TILE_PAD);
    /* ʂʍɃRs[ */
    vgSetPixels(10, 320, dstImage, 0, 0, FILTER_WIDTH, FILTER_HEIGHT);

    /* KEVAu[ */
    vgGaussianBlur(dstImage, srcImage, 10.0F, 10.0F, VG_TILE_PAD);
    /* ʂʉEɃRs[ */
    vgSetPixels(430, 320, dstImage, 0, 0, FILTER_WIDTH, FILTER_HEIGHT);
    /* IuWFNgj */
    vgDestroyImage(dstImage);
}

static void TestTerm(void)
{
    GfxReleaseFreeArea(image_data);

    /* IuWFNg̔j */
    vgDestroyImage(srcImage);
}

void ImageFilterMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* C[WtB^ */
    ImageFilter();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
