/*
 * @history     2025_03_06  [SDK3.7] SSPTvSSPCuDMAM֐gpǉ (#5782)
 * @history     2025_03_06  [SDK3.7] DMAv񓯊̂Ƃ̑΍􂪂ĂȂsC (#5786)
 */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */
#include "kernel.h" /* uC3-Fs */
#include "ffsys.h"
#include "sample_common.h"
#include "com.h"
#include "ssp_sample.h"
#include "ssp/sspmgr.h"
#include "register/AG903_sspreg.h"
#include "dmac/dmacmgr.h"
#include "i2c/i2cmgr.h"


/* vg^Cv */
static void Ssp_InitHw(uint8_t ch, uint8_t type);
static int32_t Ssp_SelectDevice(int8_t* dev);
static void Ssp_GetRecTime(uint16_t* rectime);
static int32_t Ssp_SetDmac(AG903_DMACMgrHandle* handle, uint8_t mode, uint8_t sspch, uint8_t sspwidth,
														uint32_t addr1, uint32_t addr2, uint32_t size);
static int32_t Ssp_GetMem(uint8_t** buf1, uint8_t** buf2, uint32_t size);
static int32_t Ssp_RelMem(uint8_t* buf1, uint8_t* buf2);
static int32_t Ssp_MountDevice(int8_t dev);
static FILE* Ssp_OpenFile(int8_t dev, uint8_t type);
static int32_t Ssp_WriteFile(FILE* fp, uint32_t size, uint8_t* buf);
static uint32_t Ssp_ReadFile(FILE* fp, uint32_t size, uint8_t* buf);
static int32_t Ssp_CloseFile(int8_t devnum, FILE* fp);
static int32_t Ssp_CreateHeaer(FILE* fp, uint8_t type);
static int32_t Ssp_CheckHeader(FILE* fp, uint32_t* size, uint16_t* bitnum);
static void Ssp_SetCodec(uint8_t type);
static int32_t Ssp_WaitSend(uint32_t timout);
static int32_t Ssp_WaitReceive(uint32_t timout);
static int32_t Ssp_WaitDmaTerm(uint32_t timout);
static int32_t Ssp_FlushTxFifo(AG903_SSPMgrHandle* handle, uint32_t timout);
static void Ssp_Callback(AG903_SSPMgrHandle* handle, uint32_t event);
static void Ssp_CallbackDmaTerm(AG903_DMACMgrHandle* handle, AG903_DMACMgrDesc** desc, uint8_t* end);
static void Ssp_CallbackDmaAbort(AG903_DMACMgrHandle* handle);
static void Ssp_CallbackDmaErr(AG903_DMACMgrHandle* handle);
static void Ssp_CallbackSigSemTx(AG903_SSPMgrHandle* handle, uint32_t event);
static void Ssp_CallbackSigSemRx(AG903_SSPMgrHandle* handle, uint32_t event);
static void Ssp_WaiSemTx(void);
static void Ssp_WaiSemRx(void);

/* Param */
#define SSP_SMP_TRNS_WORD		(44100*2)				/* f[^][word] (XeI1b) */
#define SSP_SMP_DMACH			(3)						/* DMAC CH */
#define SSP_SMP_DMACSEL			(4)						/* DMAC Handshake Select */
#define SSP_SMP_DMASEL_BASE		(0x18)					/* dma_reqIl(SSP0) */
#define SSP_SMP_REG_INTERVAL	(0x00100000) 			/* SSP Register Interval */
#define SSP_SMP_REC_OFFSET		(0xF000)				/* Sampling Start Offset [@] */
#define SSP_SMP_UNIT_TIME		(1)						/* ݂͏1 */
#define	SSP_SMP_REC_FILEPATH	"A:\\ssp_sample.wav"	/* ^t@CpX */
#define SSP_SMP_PLAY_FILEPATH	"A:\\ssp_sample.wav"	/* Đt@CpX */
#define SSP_SMP_HEADER_SIZE		(0x2C)					/* t@Cwb_TCY */
#define SSP_SMP_ALIGN_SIZE		(32)					/* obt@ACTCY */

enum {	/* t@C */
	SSP_SMP_FILE_REC=0,
	SSP_SMP_FILE_PLAY,
};

enum {	/* wb_ */
	SSP_SMP_HEADER_INIT=0,
	SSP_SMP_HEADER_WRITE,
};

enum {	/* Codecݒ */
	SSP_SMP_CODEC_STOP=0,
	SSP_SMP_CODEC_START_REC,
	SSP_SMP_CODEC_START_PLAY,
};

enum {	/* DMA Direction */
	SSP_SMP_DMA_SEND=0,
	SSP_SMP_DMA_RECEIVE,
};

/* Macro */
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define SSP_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)

/* f[^ */
static volatile _Bool	SspTxEnd=false;		/* MtO */
static volatile _Bool	SspRxEnd=false;		/* MtO */
static volatile _Bool	SspDmaTerm=false;	/* DMAtO */
static volatile uint32_t	SspTxSem=0;
static volatile uint32_t	SspRxSem=0;

static const uint8_t SspDevType[3] = {FSIF_DEV_SD, FSIF_DEV_CF, FSIF_DEV_USB0};	/* foCX */

/**
 * @brief		I[fBI^ [PIO]
 * @param[in]	ch		SSP`l
 * @param[in]	format	ʐMtH[}bg
 * @return		Ȃ
 * @note		LINE-IN1͂f[^SDɕۑ܂
 */
void Ssp_AudioRecPio(uint8_t ch, uint8_t format)
{
	AG903_SSPMgrHandle*		handle;
	AG903_SSPMgrI2sParam	i2s;
	FILE*		fp;
	uint8_t* 	buf[2];
	int32_t		result;
	uint32_t	loop;
	uint32_t	buf_size;
	uint16_t	rectime;
	int8_t		dev;

	((void)format);

	Ssp_InitHw(ch, AG903_I2S_MASTER_READ); 					/* n[hEFAݒ */

	while(1) {	/* Mount`File Open */
		result = Ssp_SelectDevice(&dev);
		if(AG903_ENONE != result) {
			PRINT(" Invalid");
			continue;
		}
		result = Ssp_MountDevice(dev);
		if(AG903_ENONE != result) {
			PRINT(" Device Error");
			continue;
		}
		fp = Ssp_OpenFile(dev, SSP_SMP_FILE_REC);
		if (NULL == fp) {
			PRINT(" File Error");
			continue;
		}
		break;
	}
	result = Ssp_CreateHeaer(fp, SSP_SMP_HEADER_INIT);		/* wb_ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Create Header");
	}

	result = AG903_SSPMgrGetHandle(ch, &handle);			/* SSPnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP GetHandle");
	}
	result = AG903_SSPMgrReset(handle);						/* SSPZbg */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Reset");
	}
	i2s.wordlen	  = 32;	/* 32bit */
	i2s.mono	  = false;
	i2s.polarity  = AG903_SSP_POL_NEGATIVE;
	i2s.firstbit  = AG903_SSP_FIRSTBIT_MSB;
	i2s.padlen	  = 0;
	i2s.justified = AG903_SSP_LEFT_JUSTIFIED;
	i2s.clkdiv    = 4;	/* 11.2896/4 = 2.8224[MHz] */
	i2s.slave     = false;
	result = AG903_SSPMgrSetI2sMode(handle, &i2s);	/* I2Sw */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetMode");
	}
	result = AG903_SSPMgrSetCallback(handle, (AG903_SSPMgrClbk)Ssp_Callback);
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetCallback");
	}

	buf_size = ((i2s.wordlen/8)*SSP_SMP_TRNS_WORD);
	result = Ssp_GetMem(&buf[0], &buf[1], buf_size);		/* obt@m */
	if(AG903_ENONE != result) {
		SSP_ERROR("SetMem");
	}

	Ssp_GetRecTime(&rectime);			/* ^Ԏ擾 */

	Ssp_SetCodec(SSP_SMP_CODEC_START_REC);	/* Codecݒ */

	result = AG903_SSPMgrSetReceiveBuf(handle, buf[0], SSP_SMP_TRNS_WORD);		/* Mobt@ݒ buf0 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetSendBuf");
	}
	if((SSP_SMP_UNIT_TIME*2) <= rectime) {
		result = AG903_SSPMgrSetReceiveBuf(handle, buf[1], SSP_SMP_TRNS_WORD);	/* Mobt@ݒ buf1 */
		if(AG903_ENONE != result) {
			SSP_ERROR("SSP SetSendBuf");
		}
	}
	result = AG903_SSPMgrEnableTransfer(handle);			/* I2S Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Enable");
	}

	for(loop=0; loop<rectime; loop+=SSP_SMP_UNIT_TIME) {	/* ^ */
		result = Ssp_WaitReceive(SSP_SMP_UNIT_TIME*2*1000);
		if(AG903_ENONE != result) {
			SSP_ERROR("SSP Receive");
		}
		if(0==loop) {
			sys_memset(buf[0], 0, SSP_SMP_REC_OFFSET);
			result = Ssp_WriteFile(fp, buf_size, buf[0]);
		}
		else {
			result = Ssp_WriteFile(fp, buf_size, buf[loop%2]);
		}
		if(AG903_ENONE != result) {
			SSP_ERROR("File Write Error");
			break;
		}
		if((loop+(SSP_SMP_UNIT_TIME*2)) < rectime) {
			result = AG903_SSPMgrSetReceiveBuf(handle, buf[loop%2], SSP_SMP_TRNS_WORD);
			if(AG903_ENONE != result) {
				SSP_ERROR("SSP SetSendBuf");
			}
		}
	}

	result = AG903_SSPMgrDisableTransfer(handle);			/* I2S ~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Disable");
	}
	result = AG903_SSPMgrClearRxFifo(handle);				/* FIFONA */
	if(AG903_ENONE != result) {
		SSP_ERROR("Clear FIFO");
	}
	result = AG903_SSPMgrReleaseHandle(handle);				/* nh */
	if(AG903_ENONE != result) {
		SSP_ERROR("Release Handle");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_STOP);						/* Codec~ */

	result = Ssp_CreateHeaer(fp, SSP_SMP_HEADER_WRITE);		/* wb_ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Create Header");
	}
	result = Ssp_CloseFile(dev, fp);						/* t@CClose */
	if(AG903_ENONE != result) {
		SSP_ERROR("File Close Error");
	}

	result = Ssp_RelMem(buf[0], buf[1]);					/* obt@ */
	if(AG903_ENONE != result) {
		SSP_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		I[fBIĐ [PIO]
 * @param[in]	ch		SSP`l
 * @param[in]	format	ʐMtH[}bg
 * @return		Ȃ
 * @note		SDt@CǍLINE-OUT1֏o͂܂
 */
void Ssp_AudioPlayPio(uint8_t ch, uint8_t format)
{
	AG903_SSPMgrHandle*		handle;
	AG903_SSPMgrI2sParam	i2s;
	FILE*		fp;
	uint8_t* 	buf[2];
	int32_t		result;
	uint32_t	loop;
	uint32_t	size, r_size, rd_size, dat_size, buf_size;
	uint16_t	bitnum;
	int8_t		dev;

	((void)format);

	Ssp_InitHw(ch, AG903_I2S_MASTER_WRITE); 				/* n[hEFAݒ */

	while(1) {	/* Mount`File Open */
		result = Ssp_SelectDevice(&dev);
		if(AG903_ENONE != result) {
			PRINT(" Invalid");
			continue;
		}
		result = Ssp_MountDevice(dev);
		if(AG903_ENONE != result) {
			PRINT(" Device Error");
			continue;
		}
		fp = Ssp_OpenFile(dev, SSP_SMP_FILE_PLAY);
		if (NULL == fp) {
			PRINT(" File Error");
			continue;
		}
		break;
	}
	result = Ssp_CheckHeader(fp, &dat_size, &bitnum);		/* wb_mF */
	if(AG903_ENONE != result) {
		SSP_ERROR("Get Data Info");
	}

	result = AG903_SSPMgrGetHandle(ch, &handle);			/* SSPnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP GetHandle");
	}
	result = AG903_SSPMgrReset(handle);						/* SSPZbg */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Reset");
	}
	i2s.wordlen	  = bitnum;
	i2s.mono	  = false;
	i2s.polarity  = AG903_SSP_POL_NEGATIVE;
	i2s.firstbit  = AG903_SSP_FIRSTBIT_MSB;
	if(16 == bitnum) {
		i2s.padlen = 16;
	}
	else {
		i2s.padlen = 0;
	}
	i2s.justified = AG903_SSP_LEFT_JUSTIFIED;
	i2s.clkdiv    = 4;	/* 11.2896/4 = 2.8224[MHz] */
	i2s.slave     = false;
	result = AG903_SSPMgrSetI2sMode(handle, &i2s);	/* I2Sw */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetMode");
	}
	result = AG903_SSPMgrSetCallback(handle, (AG903_SSPMgrClbk)Ssp_Callback);
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetCallback");
	}

	buf_size = ((i2s.wordlen/8)*SSP_SMP_TRNS_WORD);
	result = Ssp_GetMem(&buf[0], &buf[1], buf_size);		/* obt@m */
	if(AG903_ENONE != result) {
		SSP_ERROR("SetMem");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_START_PLAY);					/* Codecݒ */

	if(buf_size >= dat_size) {
		size = dat_size;
	}
	else {
		size = buf_size;
	}
	rd_size = Ssp_ReadFile(fp, size, buf[0]);				/* f[^Ǎ buf0 */
	if(rd_size != size) {
		SSP_ERROR("Read File");
	}
	result = AG903_SSPMgrSetSendBuf(handle, buf[0], (rd_size/(i2s.wordlen/8)));	/* Mobt@ݒ buf0 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetSendBuf");
	}
	result = AG903_SSPMgrEnableTransfer(handle);			/* I2S Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Enable");
	}

	for(loop=1; ;loop++) {	/* Đ */
		if(dat_size<=rd_size) {
			break;	/* f[^Ǎ݊ */
		}
		if(buf_size >= (dat_size-rd_size)) {
			size = (dat_size-rd_size);
		}
		else {
			size = buf_size;
		}
		r_size = Ssp_ReadFile(fp, size, buf[loop%2]);		/* f[^Ǎ[buf] */
		if(r_size != size) {
			SSP_ERROR("Read File");
		}
		result = AG903_SSPMgrSetSendBuf(handle, buf[loop%2], (r_size/(i2s.wordlen/8)));	/* Mobt@ݒ[buf] */
		if(AG903_ENONE != result) {
			SSP_ERROR("SSP SetSendBuf");
		}
		rd_size += r_size;
		result = Ssp_WaitSend(20000);						/* M҂[\buf] */
		if(AG903_ENONE != result) {
			SSP_ERROR("WaitReceive");
		}
	}
	result = Ssp_WaitSend(20000);							/* M҂[Last data] */
	if(AG903_ENONE != result) {
		SSP_ERROR("WaitReceive");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_STOP);						/* Codec~ */

	result = AG903_SSPMgrDisableTransfer(handle);			/* I2S ~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Disable");
	}
	result = AG903_SSPMgrClearRxFifo(handle);				/* FIFONA */
	if(AG903_ENONE != result) {
		SSP_ERROR("Clear FIFO");
	}
	result = AG903_SSPMgrReleaseHandle(handle);				/* nh */
	if(AG903_ENONE != result) {
		SSP_ERROR("Release Handle");
	}

	result = Ssp_CloseFile(dev, fp);						/* t@CClose */
	if(AG903_ENONE != result) {
		SSP_ERROR("File Close Error");
	}

	result = Ssp_RelMem(buf[0], buf[1]);					/* obt@ */
	if(AG903_ENONE != result) {
		SSP_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		I[fBI^ [[U[DMA]
 * @param[in]	ch		SSP`l
 * @param[in]	format	ʐMtH[}bg
 * @return		Ȃ
 * @note		LINE-IN1͂f[^SDɕۑ܂
 */
void Ssp_AudioRecDmaExternal(uint8_t ch, uint8_t format)
{
	AG903_SSPMgrHandle*		i2shdl;
	AG903_DMACMgrHandle*  	dmahdl;
	AG903_SSPMgrI2sParam	i2s;
	FILE*		fp;
	uint8_t* 	buf[2];
	uint32_t	loop;
	uint32_t	buf_size;
	int32_t		result;
	uint16_t	rectime;
	int8_t		dev;

	((void)format);

	Ssp_InitHw(ch, AG903_I2S_MASTER_READ); 					/* n[hEFAݒ */

	while(1) {	/* Mount`File Open */
		result = Ssp_SelectDevice(&dev);
		if(AG903_ENONE != result) {
			PRINT(" Invalid");
			continue;
		}
		result = Ssp_MountDevice(dev);
		if(AG903_ENONE != result) {
			PRINT(" Device Error");
			continue;
		}
		fp = Ssp_OpenFile(dev, SSP_SMP_FILE_REC);
		if (NULL == fp) {
			PRINT(" File Error");
			continue;
		}
		break;
	}
	result = Ssp_CreateHeaer(fp, SSP_SMP_HEADER_INIT);		/* wb_ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Create Header");
	}

	Ssp_GetRecTime(&rectime);

	result = AG903_SSPMgrGetHandle(ch, &i2shdl);			/* SSPnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP GetHandle");
	}
	result = AG903_SSPMgrReset(i2shdl);						/* SSPZbg */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Reset");
	}
	result = AG903_SSPMgrEnableDmaMode(i2shdl, (1<<1));		/* DMALݒ */
	if(AG903_ENONE != result) {
		SSP_ERROR("EnableDmaMode");
	}
	i2s.wordlen	  = 32;	/* 32bit */
	i2s.mono	  = false;
	i2s.polarity  = AG903_SSP_POL_NEGATIVE;
	i2s.firstbit  = AG903_SSP_FIRSTBIT_MSB;
	i2s.padlen	  = 0;
	i2s.justified = AG903_SSP_LEFT_JUSTIFIED;
	i2s.clkdiv    = 4;	/* 11.2896/4 = 2.8224[MHz] */
	i2s.slave     = false;
	result = AG903_SSPMgrSetI2sMode(i2shdl, &i2s);	/* I2Sw */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetMode");
	}

	buf_size = ((i2s.wordlen/8)*SSP_SMP_TRNS_WORD);
	result = Ssp_GetMem(&buf[0], &buf[1], buf_size);		/* obt@m */
	if(AG903_ENONE != result) {
		SSP_ERROR("SetMem");
	}

	result = AG903_DMACMgrGetHandle(SSP_SMP_DMACH, &dmahdl);/* DMACnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(dmahdl, Ssp_CallbackDmaTerm,
											Ssp_CallbackDmaAbort, Ssp_CallbackDmaErr);
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac SetCallback");
	}
	result = Ssp_SetDmac(dmahdl, SSP_SMP_DMA_RECEIVE, ch, i2s.wordlen,	/* DMACݒ */
								(uint32_t)buf[0], (uint32_t)buf[1], buf_size);
	if(AG903_ENONE != result) {
		SSP_ERROR("Set Dmac");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_START_REC);					/* Codecݒ */

	result = AG903_DMACMgrEnable(dmahdl);					/* DMA Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR(" DMAC Enable");
	}
	result = AG903_SSPMgrEnableTransfer(i2shdl);			/* I2S Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR("Master Enable");
	}

	for(loop=0; loop<rectime; loop+=SSP_SMP_UNIT_TIME) {	/* ^ */
		result = Ssp_WaitDmaTerm(SSP_SMP_UNIT_TIME*2*1000);
		if(AG903_ENONE != result) {
			SSP_ERROR("SSP Receive");
		}
		if(0==loop) {
			sys_memset(buf[0], 0, SSP_SMP_REC_OFFSET);
			result = Ssp_WriteFile(fp, buf_size, buf[0]);
		}
		else {
			result = Ssp_WriteFile(fp, buf_size, buf[loop%2]);
		}
		if(AG903_ENONE != result) {
			SSP_ERROR("File Write Error");
			break;
		}
	}

	result = AG903_SSPMgrDisableTransfer(i2shdl);			/* I2S ~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Disable");
	}
	result = AG903_SSPMgrClearRxFifo(i2shdl);				/* FIFONA */
	if(AG903_ENONE != result) {
		SSP_ERROR("Clear FIFO");
	}
	result = AG903_SSPMgrReleaseHandle(i2shdl);				/* nh */
	if(AG903_ENONE != result) {
		SSP_ERROR("Release Handle");
	}

	result = AG903_DMACMgrAbort(dmahdl);					/* DMA~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac Abort");
	}
	result = AG903_DMACMgrReleaseHandle(dmahdl);
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac ReleaseHandle");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_STOP);						/* Codec~ */

	result = Ssp_CreateHeaer(fp, SSP_SMP_HEADER_WRITE);		/* wb_ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Create Header");
	}
	result = Ssp_CloseFile(dev, fp);						/* t@CClose */
	if(AG903_ENONE != result) {
		SSP_ERROR("File Close Error");
	}

	result = Ssp_RelMem(buf[0], buf[1]);					/* obt@ */
	if(AG903_ENONE != result) {
		SSP_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		I[fBIĐ [[U[DMA]
 * @param[in]	ch		SSP`l
 * @param[in]	format	ʐMtH[}bg
 * @return		Ȃ
 * @note		SDt@CǍLINE-OUT1֏o͂܂
 */
void Ssp_AudioPlayDmaExternal(uint8_t ch, uint8_t format)
{
	AG903_SSPMgrHandle*		i2shdl;
	AG903_DMACMgrHandle*  	dmahdl;
	AG903_SSPMgrI2sParam	i2s;
	FILE*		fp;
	uint8_t* 	buf[2];
	uint32_t	loop;
	uint32_t	size, r_size, rd_size, dat_size, buf_size;
	int32_t		result;
	uint16_t	bitnum;
	int8_t		dev;

	((void)format);

	Ssp_InitHw(ch, AG903_I2S_MASTER_WRITE); 				/* n[hEFAݒ */

	while(1) {	/* Mount`File Open */
		result = Ssp_SelectDevice(&dev);
		if(AG903_ENONE != result) {
			PRINT(" Invalid");
			continue;
		}
		result = Ssp_MountDevice(dev);
		if(AG903_ENONE != result) {
			PRINT(" Device Error");
			continue;
		}
		fp = Ssp_OpenFile(dev, SSP_SMP_FILE_PLAY);
		if (NULL == fp) {
			PRINT(" File Error");
			continue;
		}
		break;
	}
	result = Ssp_CheckHeader(fp, &dat_size, &bitnum);		/* wb_mF */
	if(AG903_ENONE != result) {
		SSP_ERROR("Get Data Info");
	}

	result = AG903_SSPMgrGetHandle(ch, &i2shdl);			/* SSPnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP GetHandle");
	}
	result = AG903_SSPMgrReset(i2shdl);						/* SSPZbg */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Reset");
	}
	result = AG903_SSPMgrEnableDmaMode(i2shdl, (1<<0));		/* DMALݒ */
	if(AG903_ENONE != result) {
		SSP_ERROR("EnableDmaMode");
	}
	i2s.wordlen	  = bitnum;
	i2s.mono	  = false;
	i2s.polarity  = AG903_SSP_POL_NEGATIVE;
	i2s.firstbit  = AG903_SSP_FIRSTBIT_MSB;
	if(16 == bitnum) {
		i2s.padlen = 16;
	}
	else {
		i2s.padlen = 0;
	}
	i2s.justified = AG903_SSP_LEFT_JUSTIFIED;
	i2s.clkdiv    = 4;	/* 11.2896/4 = 2.8224[MHz] */
	i2s.slave     = false;
	result = AG903_SSPMgrSetI2sMode(i2shdl, &i2s);	/* I2Sw */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetMode");
	}

	buf_size = ((i2s.wordlen/8)*SSP_SMP_TRNS_WORD);
	result = Ssp_GetMem(&buf[0], &buf[1], buf_size);		/* obt@m */
	if(AG903_ENONE != result) {
		SSP_ERROR("SetMem");
	}

	result = AG903_DMACMgrGetHandle(SSP_SMP_DMACH, &dmahdl);/* DMACnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac GetHandle");
	}
	result = AG903_DMACMgrSetIntCallback(dmahdl, Ssp_CallbackDmaTerm,
											Ssp_CallbackDmaAbort, Ssp_CallbackDmaErr);
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac SetCallback");
	}
	result = Ssp_SetDmac(dmahdl, SSP_SMP_DMA_SEND, ch, i2s.wordlen,	/* DMACݒ */
								(uint32_t)buf[0], (uint32_t)buf[1], buf_size);
	if(AG903_ENONE != result) {
		SSP_ERROR("Set Dmac");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_START_PLAY);					/* Codecݒ */

	if(buf_size >= dat_size) {
		size = dat_size;
	}
	else {
		size = buf_size;
	}
	rd_size = Ssp_ReadFile(fp, size, buf[0]);				/* f[^Ǎ buf0 */
	if(rd_size != size) {
		SSP_ERROR("Read File");
	}

	result = AG903_DMACMgrEnable(dmahdl);					/* DMA Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR(" DMAC Enable");
	}
	result = AG903_SSPMgrEnableTransfer(i2shdl);			/* I2S Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Enable");
	}

	for(loop=1; ;loop++) {	/* Đ */
		if(dat_size<=rd_size) {
			break;	/* f[^Ǎ݊ */
		}
		if(buf_size >= (dat_size-rd_size)) {
			size = (dat_size-rd_size);
		}
		else {
			size = buf_size;
		}
		r_size = Ssp_ReadFile(fp, size, buf[loop%2]);		/* f[^Ǎ[buf] */
		if(r_size != size) {
			SSP_ERROR("Read File");
		}
		rd_size += r_size;
		if( (dat_size<=rd_size) && (buf_size>r_size) ) {
			sys_memset((buf[loop%2]+r_size), 0, (buf_size-r_size));	/* Last 0 */
		}
		result = Ssp_WaitDmaTerm(20000);					/* M҂[\buf] */
		if(AG903_ENONE != result) {
			SSP_ERROR("WaitReceive");
		}
	}
	result = Ssp_WaitDmaTerm(20000);						/* M҂[Last data] */
	if(AG903_ENONE != result) {
		SSP_ERROR("WaitReceive");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_STOP);						/* Codec~ */

	result = AG903_DMACMgrAbort(dmahdl);					/* DMA~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac Abort");
	}
	result = AG903_DMACMgrReleaseHandle(dmahdl);
	if(AG903_ENONE != result) {
		SSP_ERROR("Dmac ReleaseHandle");
	}

	result = AG903_SSPMgrDisableTransfer(i2shdl);			/* I2S ~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Disable");
	}
	result = AG903_SSPMgrClearRxFifo(i2shdl);				/* FIFONA */
	if(AG903_ENONE != result) {
		SSP_ERROR("Clear FIFO");
	}
	result = AG903_SSPMgrReleaseHandle(i2shdl);				/* nh */
	if(AG903_ENONE != result) {
		SSP_ERROR("Release Handle");
	}

	result = Ssp_CloseFile(dev, fp);						/* t@CClose */
	if(AG903_ENONE != result) {
		SSP_ERROR("File Close Error");
	}

	result = Ssp_RelMem(buf[0], buf[1]);					/* obt@ */
	if(AG903_ENONE != result) {
		SSP_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		I[fBI^ [CuDMA]
 * @param[in]	ch		SSP`l
 * @param[in]	format	ʐMtH[}bg
 * @return		Ȃ
 * @note		LINE-IN1͂f[^SDɕۑ܂
 */
void Ssp_AudioRecDmaInternal(uint8_t ch, uint8_t format)
{
	AG903_SSPMgrHandle*		handle;
	AG903_SSPMgrI2sParam	i2s;
	FILE*		fp;
	uint8_t* 	buf[2];
	uint32_t	loop;
	uint32_t	buf_size;
	int32_t		result;
	uint16_t	rectime;
	int8_t		dev;
	uint8_t		beat;

	((void)format);

	Ssp_InitHw(ch, AG903_I2S_MASTER_READ); 					/* n[hEFAݒ */

	while(1) {	/* Mount`File Open */
		result = Ssp_SelectDevice(&dev);
		if(AG903_ENONE != result) {
			PRINT(" Invalid");
			continue;
		}
		result = Ssp_MountDevice(dev);
		if(AG903_ENONE != result) {
			PRINT(" Device Error");
			continue;
		}
		fp = Ssp_OpenFile(dev, SSP_SMP_FILE_REC);
		if (NULL == fp) {
			PRINT(" File Error");
			continue;
		}
		break;
	}
	result = Ssp_CreateHeaer(fp, SSP_SMP_HEADER_INIT);		/* wb_ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Create Header");
	}

	Ssp_GetRecTime(&rectime);

	result = AG903_SSPMgrGetHandle(ch, &handle);			/* SSPnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP GetHandle");
	}
	result = AG903_SSPMgrReset(handle);						/* SSPZbg */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Reset");
	}
	beat = 2; /* XeÎL/R2[hPʂ̓]ۏł */
	result = AG903_SSPMgrSetRxFifoThreshold(handle, beat);	/* MFIFOlݒ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SetRxFifoThreshold");
	}
	result = AG903_SSPMgrEnableDmaMode(handle, (1<<1));		/* DMALݒ */
	if(AG903_ENONE != result) {
		SSP_ERROR("EnableDmaMode");
	}
	result = AG903_SSPMgrAttachRxDma(handle, SSP_SMP_DMACH, SSP_SMP_DMACSEL);	/* DMAt */
	if(AG903_ENONE != result) {
		SSP_ERROR("AttachDma");
	}
	result = AG903_SSPMgrSetRxDmaBeat(handle, beat);
	if(AG903_ENONE != result) {
		SSP_ERROR("SetDmaBeat");
	}
	i2s.wordlen	  = 32;	/* 32bit */
	i2s.mono	  = (2<=beat) ? false : true;
	i2s.polarity  = AG903_SSP_POL_NEGATIVE;
	i2s.firstbit  = AG903_SSP_FIRSTBIT_MSB;
	i2s.padlen	  = 0;
	i2s.justified = AG903_SSP_LEFT_JUSTIFIED;
	i2s.clkdiv    = 4;	/* 11.2896/4 = 2.8224[MHz] */
	i2s.slave     = false;
	result = AG903_SSPMgrSetI2sMode(handle, &i2s);	/* I2Sw */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetMode");
	}
	SspRxSem = 0;
	result = AG903_SSPMgrSetCallback(handle, (AG903_SSPMgrClbk)Ssp_CallbackSigSemRx);
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetCallback");
	}

	buf_size = ((i2s.wordlen/8)*SSP_SMP_TRNS_WORD);
	result = Ssp_GetMem(&buf[0], &buf[1], buf_size);		/* obt@m */
	if(AG903_ENONE != result) {
		SSP_ERROR("GetMem");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_START_REC);					/* Codecݒ */

	result = AG903_SSPMgrReceiveDma(handle, buf[0], buf_size/(i2s.wordlen/8));	/* MJn[buf0] */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Receive");
	}
	result = AG903_SSPMgrEnableTransfer(handle);			/* I2S Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR("Master Enable");
	}

	for(loop=0; loop<rectime; loop+=1) {	/* ^ */
		Ssp_WaiSemRx();										/* M҂[\buf] */
		if(loop+1<rectime) {
			result = AG903_SSPMgrReceiveDma(handle, buf[(loop+1)%2], buf_size/(i2s.wordlen/8));	/* MJn[buf] */
			if(AG903_ENONE != result) {
				SSP_ERROR("SSP Receive");
			}
		}
		if(0==loop) {
			sys_memset(buf[0], 0, SSP_SMP_REC_OFFSET);
			result = Ssp_WriteFile(fp, buf_size, buf[0]);
		}
		else {
			result = Ssp_WriteFile(fp, buf_size, buf[loop%2]);	/* f[^o[\buf] */
		}
		if(AG903_ENONE != result) {
			SSP_ERROR("File Write Error");
			break;
		}
	}
	result = AG903_SSPMgrDisableTransfer(handle);			/* I2S ~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Disable");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_STOP);						/* Codec~ */

	result = AG903_SSPMgrClearRxFifo(handle);				/* FIFONA */
	if(AG903_ENONE != result) {
		SSP_ERROR("Clear FIFO");
	}
	result = AG903_SSPMgrDetachRxDma(handle);				/* DMAO */
	if(AG903_ENONE != result) {
		SSP_ERROR("DetachDma");
	}
	result = AG903_SSPMgrReleaseHandle(handle);				/* nh */
	if(AG903_ENONE != result) {
		SSP_ERROR("Release Handle");
	}

	result = Ssp_CreateHeaer(fp, SSP_SMP_HEADER_WRITE);		/* wb_ */
	if(AG903_ENONE != result) {
		SSP_ERROR("Create Header");
	}
	result = Ssp_CloseFile(dev, fp);						/* t@CClose */
	if(AG903_ENONE != result) {
		SSP_ERROR("File Close Error");
	}

	result = Ssp_RelMem(buf[0], buf[1]);					/* obt@ */
	if(AG903_ENONE != result) {
		SSP_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		I[fBIĐ [CuDMA]
 * @param[in]	ch		SSP`l
 * @param[in]	format	ʐMtH[}bg
 * @return		Ȃ
 * @note		SDt@CǍLINE-OUT1֏o͂܂
 */
void Ssp_AudioPlayDmaInternal(uint8_t ch, uint8_t format)
{
	AG903_SSPMgrHandle*		handle;
	AG903_SSPMgrI2sParam	i2s;
	FILE*		fp;
	uint8_t* 	buf[2];
	int32_t		result;
	uint32_t	loop;
	uint32_t	size, r_size, rd_size, dat_size, buf_size;
	uint16_t	bitnum;
	int8_t		dev;
	uint8_t		beat;

	((void)format);

	Ssp_InitHw(ch, AG903_I2S_MASTER_WRITE); 				/* n[hEFAݒ */

	while(1) {	/* Mount`File Open */
		result = Ssp_SelectDevice(&dev);
		if(AG903_ENONE != result) {
			PRINT(" Invalid");
			continue;
		}
		result = Ssp_MountDevice(dev);
		if(AG903_ENONE != result) {
			PRINT(" Device Error");
			continue;
		}

		fp = Ssp_OpenFile(dev, SSP_SMP_FILE_PLAY);
		if (NULL == fp) {
			PRINT(" File Error");
			continue;
		}
		break;
	}
	result = Ssp_CheckHeader(fp, &dat_size, &bitnum);		/* wb_mF */
	if(AG903_ENONE != result) {
		SSP_ERROR("Get Data Info");
	}

	result = AG903_SSPMgrGetHandle(ch, &handle);			/* SSPnh擾 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP GetHandle");
	}
	result = AG903_SSPMgrReset(handle);						/* SSPZbg */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Reset");
	}
	beat = 2; /* XeÎL/R2[hPʂ̓]ۏł */
	result = AG903_SSPMgrSetTxFifoThreshold(handle, 16-beat);	/* MFIFOlݒ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SetTxFifoThreshold");
	}
	result = AG903_SSPMgrEnableDmaMode(handle, (1<<0));		/* DMALݒ */
	if(AG903_ENONE != result) {
		SSP_ERROR("EnableDmaMode");
	}
	result = AG903_SSPMgrAttachTxDma(handle, SSP_SMP_DMACH, SSP_SMP_DMACSEL);	/* DMAt */
	if(AG903_ENONE != result) {
		SSP_ERROR("AttachDma");
	}
	result = AG903_SSPMgrSetTxDmaBeat(handle, beat);
	if(AG903_ENONE != result) {
		SSP_ERROR("SetDmaBeat");
	}
	
	i2s.wordlen	  = bitnum;
	i2s.mono	  = (2<=beat) ? false : true;
	i2s.polarity  = AG903_SSP_POL_NEGATIVE;
	i2s.firstbit  = AG903_SSP_FIRSTBIT_MSB;
	if(16 == bitnum) {
		i2s.padlen = 16;
	}
	else {
		i2s.padlen = 0;
	}
	i2s.justified = AG903_SSP_LEFT_JUSTIFIED;
	i2s.clkdiv    = 4;	/* 11.2896/4 = 2.8224[MHz] */
	i2s.slave     = false;
	result = AG903_SSPMgrSetI2sMode(handle, &i2s);	/* I2Sw */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetMode");
	}
	SspTxSem = 0;
	result = AG903_SSPMgrSetCallback(handle, (AG903_SSPMgrClbk)Ssp_CallbackSigSemTx);
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP SetCallback");
	}
	
	buf_size = ((i2s.wordlen/8)*SSP_SMP_TRNS_WORD);
	result = Ssp_GetMem(&buf[0], &buf[1], buf_size);		/* obt@m */
	if(AG903_ENONE != result) {
		SSP_ERROR("GetMem");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_START_PLAY);					/* Codecݒ */

	if(buf_size >= dat_size) {
		size = dat_size;
	}
	else {
		size = buf_size;
	}
	rd_size = Ssp_ReadFile(fp, size, buf[0]);				/* f[^Ǎ buf0 */
	if(rd_size != size) {
		SSP_ERROR("Read File");
	}

	result = AG903_SSPMgrSendDma(handle, buf[0], (rd_size/(i2s.wordlen/8))); /* MJn buf0 */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Send");
	}
	result = AG903_SSPMgrEnableTransfer(handle);			/* I2S Enable */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Enable");
	}

	for(loop=1; ;loop++) {	/* Đ */
		//PRINT("[%d]%d/%d",loop,rd_size,dat_size);
		if(dat_size<=rd_size) {
			break;	/* f[^Ǎ݊ */
		}
		if(buf_size >= (dat_size-rd_size)) {
			size = (dat_size-rd_size);
		}
		else {
			size = buf_size;
		}
		r_size = Ssp_ReadFile(fp, size, buf[loop%2]);		/* f[^Ǎ[buf] */
		if(r_size != size) {
			SSP_ERROR("Read File");
		}
		Ssp_WaiSemTx();										/* M҂[\buf] */
		result = AG903_SSPMgrSendDma(handle, buf[loop%2], (r_size/(i2s.wordlen/8)));	/* MJn[buf] */
		if(AG903_ENONE != result) {
			SSP_ERROR("SSP Send");
		}
		rd_size += r_size;
	}
	Ssp_WaiSemTx();											/* M҂[Last data] */
	result = Ssp_FlushTxFifo(handle, 1000);				/* MFIFȌo͑҂ */
	if(AG903_ENONE != result) {
		SSP_ERROR("FlushTxFifo");
	}
	result = AG903_SSPMgrDisableTransfer(handle);			/* I2S ~ */
	if(AG903_ENONE != result) {
		SSP_ERROR("SSP Disable");
	}

	Ssp_SetCodec(SSP_SMP_CODEC_STOP);						/* Codec~ */

	result = AG903_SSPMgrClearTxFifo(handle);				/* FIFONA */
	if(AG903_ENONE != result) {
		SSP_ERROR("Clear FIFO");
	}
	result = AG903_SSPMgrDetachTxDma(handle);				/* DMAO */
	if(AG903_ENONE != result) {
		SSP_ERROR("DetachDma");
	}
	result = AG903_SSPMgrReleaseHandle(handle);				/* nh */
	if(AG903_ENONE != result) {
		SSP_ERROR("Release Handle");
	}

	result = Ssp_CloseFile(dev, fp);						/* t@CClose */
	if(AG903_ENONE != result) {
		SSP_ERROR("File Close Error");
	}

	result = Ssp_RelMem(buf[0], buf[1]);					/* obt@ */
	if(AG903_ENONE != result) {
		SSP_ERROR("RelMem");
	}

	return;
}

/**
 * @brief		HWݒ
 * @param[in]	ch			SSP`l
 * @param[in]	type		ݒ
 * @return		Ȃ
 * @note		gpHW(,FPGA ver.,,,)ɂĈقȂ\܂
 */
static void Ssp_InitHw(uint8_t ch, uint8_t type)
{
	/* [qݒhw_init()SSP2,SSP3ɑ΂Ď{ς */

	if(2 == ch) {
		Board_SelectEthernetType(AG903_ETHER_NONE);	/* SSP-CH2gpꍇEther𖢐ڑɂ */
	}
	Board_ActivateAudioCodec();	/* Activate Codec */

	Board_SetSspCommuType(ch, type);
}

/**
 * @brief		foCXI
 * @param[out]	dev		foCXԍ
 * @return		AG903_ENONE	I
 * @return		-AG903_EINVAL	͒lُ
 * @note		Ȃ
 */
static int32_t Ssp_SelectDevice(int8_t* dev)
{
	int32_t retval = AG903_ENONE;
	char  chara[4];
	int8_t	num;

	PRINT(" input Device Number");
#ifdef AG903_SAMPLE_USE_FS_ONLY_SD
	PRINT(" 1:SD");
	EPRINT(" ");
	COM_GetNum_Wait(chara, 3);  /* 3 = 1(Device No.)+CRLF */
	num = ASCtoBIN(chara[0]);
	if( (1>num)||(1<num) ) {
		retval = -AG903_EINVAL;
	}
#else
	PRINT(" 1:SD  2:CF  3:USB");
	EPRINT(" ");
	COM_GetNum_Wait(chara, 3);  /* 3 = 1(Device No.)+CRLF */
	num = ASCtoBIN(chara[0]);
	if( (1>num)||(3<num) ) {
		retval = -AG903_EINVAL;
	}
#endif
	(*dev) = num;

	return retval;
}

/**
 * @brief		^Ԏ擾
 * @param[out]	rectime		^
 * @return		Ȃ
 * @note		Ȃ
 */
static void Ssp_GetRecTime(uint16_t* rectime)
{
	uint16_t	time;
	char		chara[6];
	
	PRINT(" input Rec Time [sec]  ex.030 = 30[sec]");
	EPRINT(" ");
	COM_GetNum_Wait(chara, 5);  /* 5 = 3(time[sec])+CRLF */
	time  = (ASCtoBIN(chara[0])*100);
	time += (ASCtoBIN(chara[1])*10);
	time += (ASCtoBIN(chara[2]));
	(*rectime) = time;

	return;
}

/**
 * @brief		DMACݒ
 * @param[in]	handle		DMAnh
 * @param[in]	mode		][h
 * @param[in]	sspch		SSP`l
 * @param[in]	sspwidth	SSPf[^
 * @param[in]	addr		]AhX1
 * @param[in]	addr		]AhX2
 * @param[in]	size		]TCY
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Ssp_SetDmac(AG903_DMACMgrHandle* handle, uint8_t mode, uint8_t sspch, uint8_t sspwidth,
														uint32_t addr1, uint32_t addr2, uint32_t size)
{
	AG903_DMACMgrConfig   config;
	AG903_DMACMgrDesc     desc[2];
	int32_t 	result;

	if(SSP_SMP_DMA_SEND == mode) {
		/* DMACݒ [MemorySSP] */
		Sys_SetDmaInterface(SSP_SMP_DMACSEL, (SSP_SMP_DMASEL_BASE+(0x02*sspch)+1)); /* dma_req I(Mbuf) */
		AG903_DMACMgrSetSyncPeripheral(SSP_SMP_DMACH, 1);
		config.val = 0;
		config.st.DstHEn = 1;
		config.st.DstRS  = SSP_SMP_DMACSEL;

		desc[0].Ctrl.val = 0;
		desc[0].Ctrl.st.SrcWidth = 2; /* 32bit */
		if(16==sspwidth) {
			desc[0].Ctrl.st.DstWidth = 1; /* 16bit */
		}
		else {
			desc[0].Ctrl.st.DstWidth = 2; /* 32bit */
		}
		desc[0].Ctrl.st.DstCtrl = 2;  /* Fixed */
		desc[0].SrcAddr  = (uint32_t)addr1;
		desc[0].DstAddr  = (uint32_t)(&AG903_SSPn(sspch)->TxRxDR);
		desc[0].Trns.val = (size/4);
		desc[0].Stride.val = 0;
		desc[0].next = (void*)&desc[1]; /* desc[1] */

		desc[1].Ctrl.val = 0;
		desc[1].Ctrl.st.SrcWidth = 2; /* 32bit */
		if(16==sspwidth) {
			desc[1].Ctrl.st.DstWidth = 1; /* 16bit */
		}
		else {
			desc[1].Ctrl.st.DstWidth = 2; /* 32bit */
		}
		desc[1].Ctrl.st.DstCtrl = 2;  /* Fixed */
		desc[1].SrcAddr  = (uint32_t)addr2;
		desc[1].DstAddr  = (uint32_t)(&AG903_SSPn(sspch)->TxRxDR);
		desc[1].Trns.val = (size/4);
		desc[1].Stride.val = 0;
		desc[1].next = (void*)&desc[0]; /* desc[0] */
	}
	else {
		/* DMACݒ [SSPMemory] */
		Sys_SetDmaInterface(SSP_SMP_DMACSEL, (SSP_SMP_DMASEL_BASE+(0x02*sspch))); /* dma_req I(Mbuf) */
		AG903_DMACMgrSetSyncPeripheral(SSP_SMP_DMACH, 1);
		config.val = 0;
		config.st.SrcHEn = 1;
		config.st.SrcRS  = SSP_SMP_DMACSEL;

		desc[0].Ctrl.val = 0;
		desc[0].Ctrl.st.SrcWidth = 2; /* 32bit */
		desc[0].Ctrl.st.DstWidth = 2; /* 32bit */
		desc[0].Ctrl.st.SrcCtrl = 2;  /* Fixed */
		desc[0].SrcAddr  = (uint32_t)(&AG903_SSPn(sspch)->TxRxDR);
		desc[0].DstAddr  = (uint32_t)addr1;
		desc[0].Trns.val = (size/4);
		desc[0].Stride.val = 0;
		desc[0].next = (void*)&desc[1]; /* desc[1] */

		desc[1].Ctrl.val = 0;
		desc[1].Ctrl.st.SrcWidth = 2; /* 32bit */
		desc[1].Ctrl.st.DstWidth = 2; /* 32bit */
		desc[1].Ctrl.st.SrcCtrl = 2;  /* Fixed */
		desc[1].SrcAddr  = (uint32_t)(&AG903_SSPn(sspch)->TxRxDR);
		desc[1].DstAddr  = (uint32_t)addr2;
		desc[1].Trns.val = (size/4);
		desc[1].Stride.val = 0;
		desc[1].next = (void*)&desc[0]; /* desc[0] */
	}
	result = AG903_DMACMgrSetDescList(handle, &config, desc, 2); 					/* fBXNv^ݒ */

	return result;
}

/**
 * @brief		]pm
 * @param[out]	buf1	obt@1
 * @param[out]	buf2	obt@2
 * @param[in]	size	obt@TCY
 * @return		Ȃ
 * @note		mیɓe܂
 */
static int32_t Ssp_GetMem(uint8_t** buf1, uint8_t** buf2, uint32_t size)
{
	/* sys_meminitSsp_init_moduleŎs */
	(*buf1) = (uint8_t*)sys_memalign(size, SSP_SMP_ALIGN_SIZE);	/* obt@m */
	(*buf2) = (uint8_t*)sys_memalign(size, SSP_SMP_ALIGN_SIZE);	/* obt@m */
	if((NULL==(*buf1)) || (NULL==(*buf2))) {
		return -AG903_EFAULT;
	}

	return AG903_ENONE;
}

/**
 * @brief		]p
 * @param[in]	Mobt@
 * @param[in]	Mobt@
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Ssp_RelMem(uint8_t* buf1, uint8_t* buf2)
{
	sys_free(buf1);
	sys_free(buf2);
	/* sys_memfinalSsp_term_moduleŎs */

	return AG903_ENONE;
}

/**
 * @brief		foCX}Eg
 * @param[in]	dev		foCXԍ
 * @return	AG903_ENONE	 	I.
 * @return	-AG903_EINVAL  	ُ.
 * @return	-AG903_EFAULT		ُI.
 * @note		Ȃ
 */
static int32_t Ssp_MountDevice(int8_t dev)
{
	ER		ret;

	if( (0>=dev)||((int8_t)(sizeof(SspDevType))<dev) ) {
		return -AG903_EINVAL;
	}

	ret = mountp('A', 0, (ID)Fsif_GetDevid(SspDevType[dev-1]));
	if (E_OK != ret) {
		return -AG903_EFAULT;
	}

	return AG903_ENONE;
}

/**
 * @brief		t@CI[v
 * @param[in]	dev		foCXԍ
 * @param[in]	type	t@C
 * @return		t@C|C^ (NULL = ُI)
 * @note		Ȃ
 */
static FILE* Ssp_OpenFile(int8_t dev, uint8_t type)
{
	FILE*	fp;

	((void)dev);

	if(SSP_SMP_FILE_REC == type) {	/* Rec File Open */
		fp = fopen((const char*)SSP_SMP_REC_FILEPATH, (const char*)"wb");	/* Write Open */
	}
	else if(SSP_SMP_FILE_PLAY == type) { /* Play File Open */
		fp = fopen((const char*)SSP_SMP_PLAY_FILEPATH, (const char*)"rb");	/* Read Open */
	}
	else {
		fp = NULL;
	}

	return fp;
}

/**
 * @brief		t@C
 * @param[in]	fp		t@C|C^
 * @param[in]	size    TCY
 * @param[in]	buf		obt@AhX
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Ssp_WriteFile(FILE* fp, uint32_t size, uint8_t* buf)
{
	size_t	w_size;

	w_size = fwrite((const void*)buf, (size_t)1, (size_t)size, fp);
	if(w_size != (size_t)size) {
		return -AG903_EFAULT;
	}

	return AG903_ENONE;
}

/**
 * @brief		t@CǍ
 * @param[in]	fp		t@C|C^
 * @param[in]	size    TCY
 * @param[in]	buf		obt@AhX
 * @return		Ȃ
 * @note		Ȃ
 */
static uint32_t Ssp_ReadFile(FILE* fp, uint32_t size, uint8_t* buf)
{
	size_t	r_size;

	r_size = fread((void*)buf, (size_t)1, (size_t)size, fp);

	return (uint32_t)r_size;
}

/**
 * @brief		t@CN[Y
 * @param[in]	dev		foCXԍ
 * @param[in]	fp		t@C|C^
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Ssp_CloseFile(int8_t dev, FILE* fp)
{
	int32_t	ret;

	if( (0>=dev)||((int8_t)(sizeof(SspDevType))<dev) ) {
		return -AG903_EFAULT;
	}

	ret = fclose(fp);
	if(0 != ret) {
		return -AG903_EFAULT;
	}

	umountp(0, (ID)Fsif_GetDevid(SspDevType[dev-1]));

	return AG903_ENONE;
}

/**
 * @brief		wb_iRIFF/WAVEj
 * @param[in]	fp		t@C|C^
 * @param[in]	type	
 * @return		Ȃ
 * @note		Ȃ
 */
static int32_t Ssp_CreateHeaer(FILE* fp, uint8_t type)
{
	int32_t		retval = -AG903_EFAULT;
	int32_t		result;
	int32_t		size;
	int32_t		w_size;
	uint32_t	pnt=0;
	uint8_t		buf[SSP_SMP_HEADER_SIZE] = {0};

	if(SSP_SMP_HEADER_INIT == type) {
		w_size = fwrite((const void*)buf, (size_t)1, (size_t)SSP_SMP_HEADER_SIZE, fp);	/* Header Write [0] */
		if(w_size == SSP_SMP_HEADER_SIZE) {
			retval = AG903_ENONE;
		}
	}
	else if(SSP_SMP_HEADER_WRITE == type) {
		do {
			size = ftell(fp); /* TCY擾 */
			if(0 > size) {
				break;
			}
			result = fseek(fp, 0, SEEK_SET); /* 擪seek */
			if(0 > result) {
				break;
			}
			buf[pnt++]='R'; buf[pnt++]='I'; buf[pnt++]='F'; buf[pnt++]='F';	/* RIFFwb_ */
			size -= 8; /* 8 = RIFF  +size field */
			buf[pnt++]=(uint8_t)size;
			buf[pnt++]=(uint8_t)(size>>8);
			buf[pnt++]=(uint8_t)(size>>16);
			buf[pnt++]=(uint8_t)(size>>24);
			buf[pnt++]='W'; buf[pnt++]='A'; buf[pnt++]='V'; buf[pnt++]='E'; /* WAVEwb_ */
			buf[pnt++]='f'; buf[pnt++]='m'; buf[pnt++]='t'; buf[pnt++]=' '; /* fmt field */
			buf[pnt++]=0x10; buf[pnt++]=0x00; buf[pnt++]=0x00; buf[pnt++]=0x00; /* field size */
			buf[pnt++]=0x01; buf[pnt++]=0x00; /* format ID = PCM */
			buf[pnt++]=0x02; buf[pnt++]=0x00; /* stereo */
			buf[pnt++]=0x44; buf[pnt++]=0xAC; buf[pnt++]=0x00; buf[pnt++]=0x00; /* sampling = 44.1kH */
			buf[pnt++]=0x20; buf[pnt++]=0x62; buf[pnt++]=0x05; buf[pnt++]=0x00; /* Byte/sec */
			buf[pnt++]=0x08; buf[pnt++]=0x00; /* block size */
			buf[pnt++]=0x20; buf[pnt++]=0x00; /* bit/sample */
			buf[pnt++]='d'; buf[pnt++]='a'; buf[pnt++]='t'; buf[pnt++]='a'; /* data field */
			size -= (SSP_SMP_HEADER_SIZE-8);
			buf[pnt++]=(uint8_t)size;
			buf[pnt++]=(uint8_t)(size>>8);
			buf[pnt++]=(uint8_t)(size>>16);
			buf[pnt++]=(uint8_t)(size>>24);
			w_size = fwrite((const void*)buf, (size_t)1, (size_t)SSP_SMP_HEADER_SIZE, fp);	/* Header Write */
			if(SSP_SMP_HEADER_SIZE == w_size) {
				retval = AG903_ENONE;
			}
		}while(0);
	}
	else {
		/* Ȃ */
	}

	return retval;
}

/**
 * @brief		wb_mFiRIFF/WAVEj
 * @param[in]	fp		t@C|C^
 * @param[out]	size	f[^TCY
 * @param[out]	bitnum	1Tvbit
 * @return		Ȃ
 * @note		ΉtH[}bg͈ȉɌ
 * @note		tH[}bgIDF0x0001ijAPCMj
 * @note		`lF0x0002istereoj
 * @note		TvO[gF0x0000AC44i44.1kHzj
 * @note		1TvbitF16 or 32
 */
static int32_t Ssp_CheckHeader(FILE* fp, uint32_t* size, uint16_t* bitnum)
{
	int32_t	 retval=AG903_ENONE;
	uint32_t loop;
	uint32_t blksz;
	uint32_t buf[4];
	size_t	 r_size;

	r_size = fread((void*)buf, (size_t)1, (size_t)12, fp);
	if( (12 != r_size) 		 	||
		(0x46464952 != buf[0])	||	/* RIFF */
		(0x45564157 != buf[2]) ) { 	/* WAVE */
		return -AG903_EFAULT;
	}

	for(loop=0; loop<1000; loop++) {
		r_size = fread((void*)buf, (size_t)1, (size_t)8, fp);
		if(8 != r_size) {
			retval = -AG903_EFAULT;
			break;
		}

		if(0x20746D66==buf[0]) {	/* fmt  */
			blksz = buf[1];
			r_size = fread((void*)buf, (size_t)1, (size_t)16, fp);
			if( (16 != r_size) 		 	||
				(0x00020001 != buf[0])	||	/* PCMStereoȊO͔Ή */
				(0x0000AC44 != buf[1]) ) { 	/* rate 44.1kHzȊO͔Ή */
				retval = -AG903_EFAULT;
				break;
			}
			(*bitnum) = (uint16_t)(buf[3]>>16);
			if( (16!=(*bitnum)) && (32!=(*bitnum)) ) { /* 16bit,32bitȊO͔Ή */
				retval = -AG903_EFAULT;
				break;
			}
			if(16 < blksz) {
				fseek(fp, (blksz-16), SEEK_CUR);
			}
		}
		else if(0x61746164==buf[0]) {	/* data */
			(*size) = buf[1];
			break;
		}
		else {	/* ̑ */
			blksz = buf[1];
			fseek(fp, blksz, SEEK_CUR);
		}
	}
	if(1000<=loop) {
		retval = -AG903_EFAULT;	/* dataȂ */
	}

	return retval;
}

/**
 * @brief		R[fbNݒ
 * @param[in]	type	ݒ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Ssp_SetCodec(uint8_t type)
{
	switch(type) {
		case SSP_SMP_CODEC_STOP:
			Board_WriteAudioCodec(0x02, (0x07<<5)|(0x0F<<1)|(0x00<<0));				/* ALL PDN */
			break;

		case SSP_SMP_CODEC_START_REC:
			Board_WriteAudioCodec(0x02, (0x06<<5)|(0x0F<<1)|(0x00<<0));				/* ADC1 ON */
			Board_WriteAudioCodec(0x03, (0x03<<6)|(0x03<<4)|(0x00<<1)|(0x00<<0));	/* Slava Mode, MCLK [11.2896MHz] */
			Board_WriteAudioCodec(0x04, (0x00<<7)|(0x00<<6)|(0x01<<3)|(0x01<<0));	/* I2S Format */
			Board_WriteAudioCodec(0x05, (0x00<<6)|(0x00<<5)|(0x07<<2)|(0x00<<0));	/* Single-Ended */
			Board_WriteAudioCodec(0x06, (0x00<<7)|(0x00<<5)|(0x01<<4)|(0x00<<3)|(0x00<<2)|(0x00<<0));
			Board_WriteAudioCodec(0x07, (0x03<<6)|(0x03<<4)|(0x03<<2)|(0x03<<0));	/* Mute Enable */
			Board_WriteAudioCodec(0x11, (0x00));	/* Volume Control */
			Board_WriteAudioCodec(0x12, (0x00));	/* Volume Control */
			sys_dlytsk(400);
			break;

		case SSP_SMP_CODEC_START_PLAY:
			Board_WriteAudioCodec(0x02, (0x07<<5)|(0x0E<<1)|(0x00<<0));				/* DAC1 ON */
			Board_WriteAudioCodec(0x03, (0x03<<6)|(0x03<<4)|(0x00<<1)|(0x00<<0));	/* Slava Mode, MCLK [11.2896MHz] */
			Board_WriteAudioCodec(0x04, (0x00<<7)|(0x00<<6)|(0x01<<3)|(0x01<<0));	/* I2S Format */
			Board_WriteAudioCodec(0x06, (0x00<<7)|(0x00<<5)|(0x00<<4)|(0x00<<3)|(0x00<<2)|(0x00<<0));
			Board_WriteAudioCodec(0x07, (0x00<<6)|(0x00<<4)|(0x00<<2)|(0x00<<0));	/* Mute Disable */
			Board_WriteAudioCodec(0x08, (0x00));	/* Volume Control */
			Board_WriteAudioCodec(0x09, (0x00));	/* Volume Control */
			Board_WriteAudioCodec(0x1B, (0x01<<1)|(0x00<<0));						/* Mute Disable */
			sys_dlytsk(400);
			break;

		default:
			/* Ȃ */
			break;
	}

	return;
}

/**
 * @brief		M҂
 * @param[in]	timout	^CAEg[ms]
 * @retval		AG903_ENONE	I
 * @retval		-AG903_ETIMEDOUT ^CAEg
 * @note		Ȃ
 */
static int32_t Ssp_WaitSend(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == SspTxEnd) {
			SspTxEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		M҂
 * @param[in]	timout	^CAEg[ms]
 * @retval		AG903_ENONE	I
 * @retval		-AG903_ETIMEDOUT ^CAEg
 * @note		Ȃ
 */
static int32_t Ssp_WaitReceive(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == SspRxEnd) {
			SspRxEnd = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		MFIFȌo͑҂
 * @param[in]	handle	SSPnh
 * @param[in]	timout	^CAEg[ms]
 * @retval		AG903_ENONE	I
 * @retval		-AG903_ETIMEDOUT ^CAEg
 * @retval		-AG903_EINVAL ُ
 * @note		Ȃ
 */
static int32_t Ssp_FlushTxFifo(AG903_SSPMgrHandle* handle, uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;
	AG903_SSPMgrStatus	status;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		retval = AG903_SSPMgrGetStatus(handle, &status);
		if(AG903_ENONE != retval) {
			SSP_ERROR("GetStatus");
			break;
		}
		if(0 == status.txfifo_num) {
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief		DMA]҂
 * @param[in]	timout	^CAEg[ms]
 * @retval		AG903_ENONE	I
 * @retval		-AG903_ETIMEDOUT ^CAEg
 * @note		Ȃ
 */
static int32_t Ssp_WaitDmaTerm(uint32_t timout)
{
	int32_t		retval = AG903_ENONE;
	uint32_t	cnt;
	uint32_t	loop;

	cnt = timout/10;
	if(timout%10) {
		cnt++;
	}
	for(loop=0; loop<cnt; loop++) {
		if(true == SspDmaTerm) {
			SspDmaTerm = false;
			break;
		}
		sys_dlytsk(10);
	}
	if(cnt<=loop) {
		retval = -AG903_ETIMEDOUT;
	}

	return retval;
}

/**
 * @brief	R[obN (SSP[RxCh]).
 * @param[in]	handle  SSPnh.
 * @param[in]	event	R[obNCxg.
 * @return	Ȃ.
 * @note	Ȃ.
 */
static void Ssp_Callback(AG903_SSPMgrHandle* handle, uint32_t event)
{
	((void)handle);

	if(AG903_SSP_EVENT_SNDEND & event) {
		SspTxEnd = true;
	}

	if(AG903_SSP_EVENT_RCVEND & event) {
		SspRxEnd = true;
	}

	if((AG903_SSP_EVENT_OVERRUN|AG903_SSP_EVENT_UNDERRUN) & event) {
		/* Ȃ */
	}

	return;
}

/**
 * @brief		DMAC ]IR[obN
 * @param[in]	handle	nh
 * @param[out]	desc	fBXNv^i[
 * @param[out]	end		zItO
 * @return		Ȃ
 * @note		Ȃ
 */
static void Ssp_CallbackDmaTerm(AG903_DMACMgrHandle* handle, AG903_DMACMgrDesc** desc, uint8_t* end)
{
	((void)handle);
	((void)end);

	SspDmaTerm = true;
	(*desc) = NULL;

	return;
}

/**
 * @brief		DMAC A{[gR[obN
 * @param[in]	handle	nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Ssp_CallbackDmaAbort(AG903_DMACMgrHandle* handle)
{
	((void)handle);
	return;
}

/**
 * @brief		DMAC G[R[obN
 * @param[in]	handle	nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Ssp_CallbackDmaErr(AG903_DMACMgrHandle* handle)
{
	((void)handle);
	return;
}

static void Ssp_CallbackSigSemTx(AG903_SSPMgrHandle* handle, uint32_t event)
{
	((void)handle);

	if(AG903_SSP_EVENT_SNDEND & event) {
		if(1 > SspTxSem) {
			SspTxSem += 1;
		}
	}

	return;
}

static void Ssp_WaiSemTx(void)
{
	while (0 == SspTxSem);
	SspTxSem -= 1;

	return;
}

static void Ssp_CallbackSigSemRx(AG903_SSPMgrHandle* handle, uint32_t event)
{
	((void)handle);

	if(AG903_SSP_EVENT_RCVEND & event) {
		if(1 > SspRxSem) {
			SspRxSem += 1;
		}
	}

	return;
}

static void Ssp_WaiSemRx(void)
{
	while (0 == SspRxSem);
	SspRxSem -= 1;

	return;
}
