/*
 * @history     2025_03_06  [SDK3.7] SSPTvSPI[h̎gpǉ (#5781)
 * @history     2025_03_06  [SDK3.7] SSPTvSSPCuDMAM֐gpǉ (#5782)
 */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */
#ifndef _SSP_SAMPLE_H_
#define _SSP_SAMPLE_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Param */
enum {	/* SSP Format */
	SSP_SMP_FMT_SPI=0,
	SSP_SMP_FMT_I2S,
	SSP_SMP_FMT_SSP,
	SSP_SMP_FMT_SPDIF,
};

/* vg^Cv */
void Ssp_MasterSend(uint8_t master_ch, uint8_t slave_ch, _Bool dma);
void Ssp_MasterReceive(uint8_t master_ch, uint8_t slave_ch, _Bool dma);
void Ssp_AudioRecPio(uint8_t ch, uint8_t format);
void Ssp_AudioPlayPio(uint8_t ch, uint8_t format);
void Ssp_AudioRecDmaInternal(uint8_t ch, uint8_t format);
void Ssp_AudioPlayDmaInternal(uint8_t ch, uint8_t format);
void Ssp_AudioRecDmaExternal(uint8_t ch, uint8_t format);
void Ssp_AudioPlayDmaExternal(uint8_t ch, uint8_t format);
void Ssp_SpiFlashCommand(_Bool dma);

#ifdef __cplusplus
}
#endif
#endif /* _SSP_SAMPLE_H_ */





