/*
* This program was created by AXELL CORPORATION.
* Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "sample_common.h"
#include "com.h"
#include "timr/timrmgr.h"

/* vg^Cv */
static int32_t Timr_init_module(void);
static int32_t Timr_term_module(void);
static void Timr_SampleHelp(void);
static void Timr_TickCountMode(void);
static void Timr_EventCountMode(void);
static void Timr_PulseCountMode(void);
static void Timr_LevelCountMode(void);
static void Timr_ResetStart(void);
static void Timr_MultiStart(void);
static void Timr_CtrlLed(uint8_t ctrl, uint8_t ledbit);
static void Timr_Tickhdr0(void* param);
static void Timr_Tickhdr1(void* param);
static void Timr_Tickhdr2(void* param);
static void Timr_Tickhdr3(void* param);
static void Timr_Evcnthdr(void* param);
static void Timr_Plscnthdr(void* param);
static void Timr_Lvcnthdr(void* param);

enum {
	TIMR_LED_CTRL_INIT=0,
	TIMR_LED_CTRL_OFF,
	TIMR_LED_CTRL_ON,
	TIMR_LED_CTRL_TOGGLE,
	TIMR_LED_CTRL_SLIDE,
};


/* Param */
#define TIMR_SMP_LED_BLINKTIM	(10)	/* LED_ŉ[] */
#define TIMR_SMP_LED_NUM		(4)		/* LED[] */
#define TIMR_SMP_EVENT_CNTMAX	(5)		/* CxgJEg[] */
#define TIMR_SMP_PULSE_CNTMAX	(5)		/* pXJEg[] */
#define TIMR_SMP_LEVEL_CNTMAX	(5)		/* xJEg[] */
#define TIMR_SMP_MULTI_TIMERNUM (4)		/* ^C}N[] */


/* Macro */
#define	EPRINT(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define	PRINT(FMT, ...)			sys_print(0, FMT"\r\n",##__VA_ARGS__)
#define TIMR_ERROR(str)			sys_print(1, " ERROR:%s[%d] *%s*\r\n",__FUNCTION__, __LINE__, str)

static void (*func[])() = {
	Timr_SampleHelp,
	Timr_TickCountMode,
	Timr_EventCountMode,
	Timr_PulseCountMode,
	Timr_LevelCountMode,
	Timr_ResetStart,
	Timr_MultiStart,
};

const void* TimrTickhdrTbl[TIMR_SMP_MULTI_TIMERNUM] =
{(void*)Timr_Tickhdr0, (void*)Timr_Tickhdr1, (void*)Timr_Tickhdr2, (void*)Timr_Tickhdr3};

static volatile uint32_t TimrTickCounter[TIMR_SMP_MULTI_TIMERNUM]={0};
static uint32_t	TimrEventCounter=0;
static uint32_t	TimrPulseCounter=0;
static uint32_t	TimrLevelCounter=0;


/**
 * @brief		C
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void TIMR_main(uint8_t param)
{
	uint8_t		mode = 0;
	char		input[2+2];

	((void)param);

	Timr_SampleHelp();	/* Help\ */

	Timr_init_module();

	while (mode != 0xFF) {
		EPRINT(" -- Choose sample number (00h<HELP> to FFh): ");
		COM_GetNum_Wait(input, sizeof(input));
		mode = (ASCtoBIN(input[0]) << 4)
			 | (ASCtoBIN(input[1]) << 0);
		if(0xFF == mode) {
			break;
		}
		if(mode >= (sizeof(func)/sizeof(void*))) {
			func[0](); /* Help */
		}
		else {
			func[mode]();	/* Sample funcs */
		}
	}

	Timr_term_module();

	return;
}

/**
 * @brief		Tu
 * @param[in]	param	p[^
 * @return		Ȃ
 * @note		Ȃ
 */
void TIMR_sub(uint32_t param)
{
	((void)param);
	/* Ȃ */
	return;
}

/**
 * @brief		W[
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Timr_init_module(void)
{
	static _Bool	TimrInit=false;
	int32_t 		result;

	if(false == TimrInit) {
		result = AG903_TIMRMgrInit(); /* Managaer  */
		if(AG903_ENONE != result) {
			TIMR_ERROR("Init");
		}
		else {
			TimrInit = true;
		}
	}

	return AG903_ENONE;
}

/**
 * @brief		W[I
 * @param[in]	Ȃ
 * @retval		AG903_ENONE		I
 * @note		Ȃ
 */
static int32_t Timr_term_module(void)
{
	/* Ȃ */
	return AG903_ENONE;
}

/**
 * @brief		wv\
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_SampleHelp(void)
{
	PRINT("\t# 00 ... Help");
	PRINT("\t# 01 ... Tick Count [LED Blinking]");
	PRINT("\t# 02 ... Event Count");
	PRINT("\t# 03 ... Pulse Count");
	PRINT("\t# 04 ... Level Count");
	PRINT("\t# 05 ... Reset Start [LED Blinking]");
	PRINT("\t# 06 ... Multi Start [Lap count]");
	PRINT("\t# FF ... Exit Sample");

	return;
}

/**
 * @brief		Tick Count iLED_Łj
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_TickCountMode(void)
{
	AG903_TIMRMgrHandle*		handle;
	AG903_TIMRMgrTickCntParam 	tick;
	int32_t 	result;
	uint32_t 	timcnt= 0;

	PRINT(" Tick Count [LED Blinking]");

	Timr_CtrlLed(TIMR_LED_CTRL_INIT, 0xFF);
	Timr_CtrlLed(TIMR_LED_CTRL_OFF,  0xFF);
	TimrTickCounter[0] = 0;

	/* ^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&handle); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(handle, (void*)Timr_Tickhdr0, (void*)handle);	/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	tick.period  = 100000000;	/* 500[ms] (clk 200M[Hz]) */
	tick.match   = 0;
	tick.resolution = AG903_TIMR_CNT_SYSCLK;
	tick.oneshot = false;
	tick.output  = NULL;
	result = AG903_TIMRMgrSetTickCountMode(handle, &tick); 								/* TickECount[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetTickCountMode");
	}
	result = AG903_TIMRMgrDisableIntMask(handle, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* ^C}X^[g (LED_) */
	PRINT(" LED Blinking...");
	TimrTickCounter[0] = 0;
	result = AG903_TIMRMgrStart(handle); 												/* ^C}X^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
	while(1) {
		if(timcnt != TimrTickCounter[0]) {
			timcnt = TimrTickCounter[0];
			Timr_CtrlLed(TIMR_LED_CTRL_TOGGLE, 0xFF);	/* LEDXV */
		}
		if((TIMR_SMP_LED_BLINKTIM<<1) <= TimrTickCounter[0]) {
			break;
		}
	}

	/* ^C} */
	result = AG903_TIMRMgrStop(handle); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(handle, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(handle, (void*)Timr_Tickhdr0); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(handle, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(handle); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	Timr_CtrlLed(TIMR_LED_CTRL_ON,  0xFF);

	return;
}

/**
 * @brief		Event Count
 * @param		Ȃ
 * @return		Ȃ
 * @note		^C}Cxg𐶐ʃ^C}ŃJEg܂
 */
static void Timr_EventCountMode(void)
{
	AG903_TIMRMgrHandle*		cnt_hdl;
	AG903_TIMRMgrHandle*		ev_hdl;
	AG903_TIMRMgrTickCntParam 	tick;
	AG903_TIMRMgrEventCntParam	event;
	int32_t 	result;
	uint32_t 	timcnt= 0;
	uint32_t 	evcnt = 0;
	uint8_t		ch;

	PRINT(" Event Count");

	Timr_CtrlLed(TIMR_LED_CTRL_INIT, 0xFF);
	Timr_CtrlLed(TIMR_LED_CTRL_OFF,  0xFF);
	TimrTickCounter[0] = 0;
	TimrEventCounter   = 0;

	/* Eventp^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&ev_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(ev_hdl, (void*)Timr_Tickhdr0, (void*)ev_hdl); 	/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	tick.period  = 50000000;	/* 250[ms] (clk 200M[Hz]) */
	tick.match   = 0;
	tick.resolution = AG903_TIMR_CNT_SYSCLK;
	tick.oneshot = false;
	tick.output  = NULL;
	result = AG903_TIMRMgrSetTickCountMode(ev_hdl, &tick); 								/* TickECount[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetTickCountMode");
	}
	result = AG903_TIMRMgrEnableEventTrigger(ev_hdl, AG903_TIMR_OVERFLOW_BIT);			/* Eventݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableEventTrigger");
	}
	result = AG903_TIMRMgrDisableIntMask(ev_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* EventJEgp^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&cnt_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(cnt_hdl, (void*)Timr_Evcnthdr, (void*)cnt_hdl);	/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	result = AG903_TIMRMgrGetChannel(ev_hdl, &ch);
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetChannel");
	}
	event.period  = 5; /* 51JEg */
	event.match	  = 0;
	event.event   = AG903_EVENT32_TIM0+ch;
	event.oneshot = false;
	event.output  = NULL;
	result = AG903_TIMRMgrSetEventCountMode(cnt_hdl, &event);							/* Event Count[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetEventCountMode");
	}
	result = AG903_TIMRMgrDisableIntMask(cnt_hdl, AG903_TIMR_OVERFLOW_BIT); 			/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* ^C}X^[g (EventJEg) */
	result = AG903_TIMRMgrStart(cnt_hdl); 												/* Event CountX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
	result = AG903_TIMRMgrStart(ev_hdl); 												/* EventX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
    while(1) {
		if(timcnt != TimrTickCounter[0]) {
			timcnt = TimrTickCounter[0];
			Timr_CtrlLed(TIMR_LED_CTRL_SLIDE,  0xFF); 	/* LEDXV */
		}
		if(evcnt != TimrEventCounter) {
			evcnt = TimrEventCounter;
			PRINT(" Count : %02d", evcnt);				/* \XV */
			if(TIMR_SMP_EVENT_CNTMAX <= evcnt) {
				break;
			}
		}
   }

	/* EventJEgp^C}~ */
	result = AG903_TIMRMgrStop(cnt_hdl); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(cnt_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(cnt_hdl, (void*)Timr_Evcnthdr); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(cnt_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(cnt_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	/* Eventp^C}~ */
	result = AG903_TIMRMgrStop(ev_hdl); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(ev_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDisableEventTrigger(ev_hdl, AG903_TIMR_OVERFLOW_BIT); 		/* Event */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableEventTrigger");
	}
	result = AG903_TIMRMgrDeleteIntHandler(ev_hdl, (void*)Timr_Tickhdr0); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(ev_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(ev_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	Timr_CtrlLed(TIMR_LED_CTRL_ON,  0xFF);

	return;
}

/**
 * @brief		Pulse Count
 * @param		Ȃ
 * @return		Ȃ
 * @note		^C}Pulse𐶐ʃ^C}ŃJEg܂
 */
static void Timr_PulseCountMode(void)
{
	AG903_TIMRMgrHandle*		cnt_hdl;
	AG903_TIMRMgrHandle*		pls_hdl;
	AG903_TIMRMgrTickCntOutput	out;
	AG903_TIMRMgrTickCntParam 	tick;
	AG903_TIMRMgrPulseCntParam	pulse;
	int32_t 	result;
	uint32_t 	timcnt = 0;
	uint32_t 	plscnt = 0;

	PRINT(" Pulse Count");

	Timr_CtrlLed(TIMR_LED_CTRL_INIT, 0xFF);
	Timr_CtrlLed(TIMR_LED_CTRL_OFF,  0xFF);
	TimrTickCounter[0] = 0;
	TimrPulseCounter   = 0;

	/* Pulsep^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&pls_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(pls_hdl, (void*)Timr_Tickhdr0, (void*)pls_hdl);	/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	tick.period  = 50000000;  /* 250[ms] (clk 200M[Hz]) */
	tick.match   = 0;
	tick.resolution = AG903_TIMR_CNT_SYSCLK;
	tick.oneshot = false;
	tick.output  = &out;
	out.plusewidth = 1000000; /* 5[ms] (clk 200M[Hz]) */
	out.mode     = AG903_TIMR_OUT_PLUSE;
	out.portch   = 0;
	out.polarity = AG903_TIMR_POL_POSITIVE;
	out.mask     = AG903_TIMR_COMPARE_BIT;
	result = AG903_TIMRMgrSetTickCountMode(pls_hdl, &tick); 							/* TickECount[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetTickCountMode");
	}
	result = AG903_TIMRMgrDisableIntMask(pls_hdl, AG903_TIMR_OVERFLOW_BIT); 			/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* PulseJEgp^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&cnt_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(cnt_hdl, (void*)Timr_Plscnthdr, (void*)cnt_hdl);/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	pulse.period   = 5; /* 51JEg */
	pulse.match    = 0;
	pulse.intype   = AG903_TIMR_INPUT_EXTOUT0;
	pulse.polarity = AG903_TIMR_POL_POSITIVE;
	pulse.sampling = AG903_TIMR_CNT_SYSCLK;
	pulse.oneshot  = false;
	pulse.output   = NULL;
	result = AG903_TIMRMgrSetPulseCountMode(cnt_hdl, &pulse);							/* PulseJEg[h */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetPulseCountMode");
	}
	result = AG903_TIMRMgrDisableIntMask(cnt_hdl, AG903_TIMR_OVERFLOW_BIT); 			/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* ^C}X^[g (PulseJEg) */
	result = AG903_TIMRMgrStart(cnt_hdl); 												/* PulseJEgX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
	result = AG903_TIMRMgrStart(pls_hdl); 												/* PulseX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
    while(1) {
		if(timcnt != TimrTickCounter[0]) {
			timcnt = TimrTickCounter[0];
			Timr_CtrlLed(TIMR_LED_CTRL_SLIDE,  0xFF); 	/* LEDXV */
		}
		if(plscnt != TimrPulseCounter) {
			plscnt = TimrPulseCounter;
			PRINT(" Count : %02d", plscnt);				/* \XV */
			if(TIMR_SMP_PULSE_CNTMAX <= plscnt) {
				break;
			}
		}
    }

	/* PulseJEgp^C} */
	result = AG903_TIMRMgrStop(cnt_hdl); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(cnt_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(cnt_hdl, (void*)Timr_Plscnthdr); 			/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(cnt_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(cnt_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	/* Pulsep^C}~ */
	result = AG903_TIMRMgrStop(pls_hdl); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(pls_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(pls_hdl, (void*)Timr_Tickhdr0); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(pls_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(pls_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	Timr_CtrlLed(TIMR_LED_CTRL_ON,  0xFF);

	return;
}

/**
 * @brief		Level Count
 * @param		Ȃ
 * @return		Ȃ
 * @note		^C}Pulse𐶐ʃ^C}ŃxJEg܂
 */
static void Timr_LevelCountMode(void)
{
	AG903_TIMRMgrHandle*		cnt_hdl;
	AG903_TIMRMgrHandle*		pls_hdl;
	AG903_TIMRMgrTickCntOutput	out;
	AG903_TIMRMgrTickCntParam 	tick;
	AG903_TIMRMgrLevelCntParam	level;
	int32_t 	result;

	PRINT(" Level Count");

	TimrTickCounter[0] = 0;
	TimrLevelCounter   = 0;

	/* Pulsep^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&pls_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(pls_hdl, (void*)Timr_Tickhdr0, (void*)pls_hdl);	/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	tick.period  = 20000000;  /* 100[ms] (clk 200M[Hz]) */
	tick.match   = 0;
	tick.resolution = AG903_TIMR_CNT_SYSCLK;
	tick.oneshot = false;
	tick.output  = &out;
	out.plusewidth = 1000000; /* 5[ms] (clk 200M[Hz]) */
	out.mode     = AG903_TIMR_OUT_PLUSE;
	out.portch   = 0;
	out.polarity = AG903_TIMR_POL_POSITIVE;
	out.mask     = AG903_TIMR_COMPARE_BIT;
	result = AG903_TIMRMgrSetTickCountMode(pls_hdl, &tick); 							/* TickECount[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetTickCountMode");
	}
	result = AG903_TIMRMgrDisableIntMask(pls_hdl, AG903_TIMR_OVERFLOW_BIT); 			/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* LevelJEgp^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&cnt_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(cnt_hdl, (void*)Timr_Lvcnthdr, (void*)cnt_hdl); /* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	level.period   = 200000; /* 1[ms] (clk 200M[Hz]) */
	level.match    = 0;
	level.intype   = AG903_TIMR_INPUT_EXTOUT0;
	level.polarity = AG903_TIMR_POL_POSITIVE;
	level.sampling = AG903_TIMR_CNT_SYSCLK;
	level.oneshot  = false;
	level.output   = NULL;
	result = AG903_TIMRMgrSetLevelCountMode(cnt_hdl, &level);							/* LevelJEg[h */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetLevelCountMode");
	}
	result = AG903_TIMRMgrDisableIntMask(cnt_hdl, AG903_TIMR_OVERFLOW_BIT);  			/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* ^C}X^[g (LevelJEg) */
	result = AG903_TIMRMgrStart(cnt_hdl); 												/* LevelJEgX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
	result = AG903_TIMRMgrStart(pls_hdl); 												/* PulseX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
    while(1) {
		if(TIMR_SMP_LEVEL_CNTMAX < TimrTickCounter[0]) {
			PRINT(" ActiveLevel : %d/%d", TimrLevelCounter, (TIMR_SMP_LEVEL_CNTMAX*100));
			break;
		}
	}

	/* LevelJEgp^C} */
	result = AG903_TIMRMgrStop(cnt_hdl); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(cnt_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(cnt_hdl, (void*)Timr_Lvcnthdr);  			/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(cnt_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(cnt_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	/* Pulsep^C} */
	result = AG903_TIMRMgrStop(pls_hdl); 												/* TickECount~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(pls_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(pls_hdl, (void*)Timr_Tickhdr0); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(pls_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(pls_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	return;
}

/**
 * @brief		Reset StartiLED_Łj
 * @param		Ȃ
 * @return		Ȃ
 * @note		^C}ŃCxg𐶐ʃ^C}CxggKŋN܂
 */
static void Timr_ResetStart(void)
{
	AG903_TIMRMgrHandle*		wup_hdl;
	AG903_TIMRMgrHandle*		ev_hdl;
	AG903_TIMRMgrTickCntParam 	tick0;
	AG903_TIMRMgrTickCntParam	tick1;
	AG903_TIMRMgrResetParam		wuptrg;
	int32_t 	result;
	uint32_t 	timcnt= 0;
	uint8_t		ch;

	PRINT(" Reset Start [LED Blinking]");

	Timr_CtrlLed(TIMR_LED_CTRL_INIT, 0xFF);
	Timr_CtrlLed(TIMR_LED_CTRL_OFF,  0xFF);
	TimrTickCounter[0] = 0;
	TimrTickCounter[1] = 0;

	/* Eventp^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&ev_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(ev_hdl, (void*)Timr_Tickhdr0, (void*)ev_hdl); 	/* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	tick0.period  = 200000000;	/* 1000[ms] (clk 200M[Hz]) */
	tick0.match   = 0;
	tick0.resolution = AG903_TIMR_CNT_SYSCLK;
	tick0.oneshot = true; /* Oneshot */
	tick0.output  = NULL;
	result = AG903_TIMRMgrSetTickCountMode(ev_hdl, &tick0); 							/* TickECount[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetTickCountMode");
	}
	result = AG903_TIMRMgrEnableEventTrigger(ev_hdl, AG903_TIMR_OVERFLOW_BIT);			/* Eventݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableEventTrigger");
	}
	result = AG903_TIMRMgrDisableIntMask(ev_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* ResetN^C}ݒ */
	result = AG903_TIMRMgrGetHandle(&wup_hdl); 											/* nh擾 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetHandle");
	}
	result = AG903_TIMRMgrSetIntHandler(wup_hdl, (void*)Timr_Tickhdr1, (void*)wup_hdl); /* ݃nho^ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetHandler");
	}
	result = AG903_TIMRMgrGetChannel(ev_hdl, &ch);
	if(AG903_ENONE != result) {
		TIMR_ERROR("GetChannel");
	}
	tick1.period  = 100000000;	/* 500[ms] (clk 200M[Hz]) */
	tick1.match   = 0;
	tick1.resolution = AG903_TIMR_CNT_SYSCLK;
	tick1.oneshot = false;
	tick1.output  = NULL;
	result = AG903_TIMRMgrSetTickCountMode(wup_hdl, &tick1); 							/* TickECount[hݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetTickCountMode");
	}
	wuptrg.trigger  = AG903_TIMR_RSTTRG_EVENT;
	wuptrg.event    = AG903_EVENT32_TIM0+ch;
	wuptrg.polarity = AG903_TIMR_POL_POSITIVE;
	wuptrg.sampling = AG903_TIMR_CNT_SYSCLK;
	result = AG903_TIMRMgrEnableResetTrigger(wup_hdl, &wuptrg);							/* ZbggKݒ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableResetTrigger");
	}
	result = AG903_TIMRMgrDisableIntMask(wup_hdl, AG903_TIMR_OVERFLOW_BIT); 			/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableIntMask");
	}

	/* ^C}X^[g */
	PRINT(" * Wait Trigger");
	result = AG903_TIMRMgrStart(ev_hdl); 												/* EventX^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}
	while(1) {
		if(timcnt != TimrTickCounter[1]) {
			if(0 == timcnt) {
				PRINT(" * Detect Trigger");
				PRINT(" * LED Blinking...");
			}
			timcnt = TimrTickCounter[1];
			Timr_CtrlLed(TIMR_LED_CTRL_TOGGLE, 0xFF);	/* LEDXV */
		}
		if((TIMR_SMP_LED_BLINKTIM<<1) <= TimrTickCounter[1]) {
			break;
		}
	}

	/* ResetN^C} */
	result = AG903_TIMRMgrStop(wup_hdl); 												/* ^C}~ */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Stop");
	}
	result = AG903_TIMRMgrEnableIntMask(wup_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDeleteIntHandler(wup_hdl, (void*)Timr_Tickhdr1); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(wup_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(wup_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	/* Eventp^C} */
	result = AG903_TIMRMgrEnableIntMask(ev_hdl, AG903_TIMR_OVERFLOW_BIT); 				/* ݃}XN */
	if(AG903_ENONE != result) {
		TIMR_ERROR("EnableIntMask");
	}
	result = AG903_TIMRMgrDisableEventTrigger(ev_hdl, AG903_TIMR_OVERFLOW_BIT); 		/* Event */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DisableEventTrigger");
	}
	result = AG903_TIMRMgrDeleteIntHandler(ev_hdl, (void*)Timr_Tickhdr0); 				/* ݃nh폜 */
	if(AG903_ENONE != result) {
		TIMR_ERROR("DeleteHandler");
	}
	result = AG903_TIMRMgrSetCount(ev_hdl, 0);											/* JE^NA */
	if(AG903_ENONE != result) {
		TIMR_ERROR("SetCount");
	}
	result = AG903_TIMRMgrReleaseHandle(ev_hdl); 										/* nh */
	if(AG903_ENONE != result) {
		TIMR_ERROR("ReleaseHandle");
	}

	Timr_CtrlLed(TIMR_LED_CTRL_ON,  0xFF);

	return;
}

/**
 * @brief		^C}N (bvv)
 * @param		Ȃ
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_MultiStart(void)
{
	AG903_TIMRMgrHandle*		handle[TIMR_SMP_MULTI_TIMERNUM];
	AG903_TIMRMgrTickCntParam	tick;
	uint32_t 	cnt;
	int32_t 	result;
	int32_t 	loop;
	int32_t 	wakeup=0;
	char		string[32];
	uint8_t		ch[TIMR_SMP_MULTI_TIMERNUM];

	PRINT(" Multi Start [Lap count]");

	/* Lapvp^C}ݒ */
	tick.period  = 2000000;	/* 10[ms] (clk 200M[Hz]) */
	tick.match   = 0;
	tick.resolution = AG903_TIMR_CNT_SYSCLK;
	tick.oneshot = false;
	tick.output  = NULL;
	for(loop=0; loop<TIMR_SMP_MULTI_TIMERNUM; loop++) {
		TimrTickCounter[loop] = 0;
		result = AG903_TIMRMgrGetHandle(&handle[loop]); 								/* nh擾 */
		if(AG903_ENONE != result) {
			TIMR_ERROR("GetHandle");
		}
		result = AG903_TIMRMgrSetIntHandler(handle[loop], (void*)TimrTickhdrTbl[loop],
															(void*)handle[loop]); 		/* ݃nho^ */
		if(AG903_ENONE != result) {
			TIMR_ERROR("SetHandler");
		}
		result = AG903_TIMRMgrSetTickCountMode(handle[loop], &tick); 					/* TickECount[hݒ */
		if(AG903_ENONE != result) {
			TIMR_ERROR("SetTickCountMode");
		}
		result = AG903_TIMRMgrDisableIntMask(handle[loop], AG903_TIMR_OVERFLOW_BIT);	/* ݃}XN */
		if(AG903_ENONE != result) {
			TIMR_ERROR("DisableIntMask");
		}
		result = AG903_TIMRMgrGetChannel(handle[loop], &ch[loop]);						/* CH擾 */
		if(AG903_ENONE != result) {
			TIMR_ERROR("GetChannel");
		}
		wakeup |= (1<<ch[loop]);
	}

	/* ^C}X^[g`\ */
	result = AG903_TIMRMgrStartMulti(wakeup);											/* ^C}X^[g */
	if(AG903_ENONE != result) {
		TIMR_ERROR("Start");
	}

	for(loop=0; loop<TIMR_SMP_MULTI_TIMERNUM; loop++) {
		EPRINT(" Push Enter");
		COM_GetNum_Wait(string, 2); /* 2 = CRLF */
		result = AG903_TIMRMgrStop(handle[loop]); 										/* JEg~ */
		if(AG903_ENONE != result) {
			TIMR_ERROR("Stop");
		}
	}
	for(loop=0; loop<TIMR_SMP_MULTI_TIMERNUM; loop++) {		/* Lap\ */
        cnt = TimrTickCounter[loop];
		PRINT(" Lap%1d : %02d.%02d", loop, (cnt/100), (cnt%100));
	}

	/* Lapvp^C} */
	for(loop=0; loop<TIMR_SMP_MULTI_TIMERNUM; loop++) {
		result = AG903_TIMRMgrEnableIntMask(handle[loop], AG903_TIMR_OVERFLOW_BIT); 	/* ݃}XN */
		if(AG903_ENONE != result) {
			TIMR_ERROR("EnableIntMask");
		}
		result = AG903_TIMRMgrDeleteIntHandler(handle[loop], (void*)TimrTickhdrTbl[loop]); 	/* ݃nh폜 */
		if(AG903_ENONE != result) {
			TIMR_ERROR("DeleteHandler");
		}
		result = AG903_TIMRMgrSetCount(handle[loop], 0);								/* JE^NA */
		if(AG903_ENONE != result) {
			TIMR_ERROR("SetCount");
		}
		result = AG903_TIMRMgrReleaseHandle(handle[loop]); 								/* nh */
		if(AG903_ENONE != result) {
			TIMR_ERROR("ReleaseHandle");
		}
	}

	return;
}

/**
 * @brief		LED
 * @param[in]	ctrl	e
 * @param[in]	ledbit	LEDI (bitw)
 * @return		Ȃ
 * @note		gpHW(,FPGA ver.,,,)ɂĈقȂ\܂
 */
static void Timr_CtrlLed(uint8_t ctrl, uint8_t ledbit)
{
	uint8_t led;

	switch(ctrl) {
		case TIMR_LED_CTRL_INIT:
			Board_SelectBlpConnection(0, AG903_BLP_CONNECT_NONE);
			Board_SelectBlpConnection(1, AG903_BLP_CONNECT_NONE);
			break;
		case TIMR_LED_CTRL_OFF:
			Board_SetLedStatus(ledbit);
			break;
		case TIMR_LED_CTRL_ON:
			Board_SetLedStatus(~ledbit);
			break;
		case TIMR_LED_CTRL_TOGGLE:
			Board_GetLedStatus(&led);
			led ^= ledbit;
			Board_SetLedStatus(led);
			break;
		case TIMR_LED_CTRL_SLIDE:
			Board_GetLedStatus(&led);
			led = (~led);
			if(0x00 == (led&0x0F)) {
				led = 0x01;
				Board_SetLedStatus(~led);
			}
			else if(0x08 < led) {
				led = 0x00;
				Board_SetLedStatus(~led);
			}
			else {
				led <<= 1;
				Board_SetLedStatus(~led);
			}
			break;
	}

	return;
}

/**
 * @brief		Tick Count0
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Tickhdr0(void* param)
{
	AG903_TIMRMgrHandle* handle;

	TimrTickCounter[0] ++;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	return;
}

/**
 * @brief		Tick Count1
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Tickhdr1(void* param)
{
	AG903_TIMRMgrHandle* handle;

	TimrTickCounter[1] ++;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	return;
}

/**
 * @brief		Tick Count2
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Tickhdr2(void* param)
{
	AG903_TIMRMgrHandle* handle;

	TimrTickCounter[2] ++;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	return;
}

/**
 * @brief		Tick Count3
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Tickhdr3(void* param)
{
	AG903_TIMRMgrHandle* handle;

	TimrTickCounter[3] ++;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	return;
}
/**
 * @brief		Event Count
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Evcnthdr(void* param)
{
	AG903_TIMRMgrHandle* handle;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	TimrEventCounter ++;

	return;
}

/**
 * @brief		Pulse Count
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Plscnthdr(void* param)
{
	AG903_TIMRMgrHandle* handle;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	TimrPulseCounter ++;

	return;
}

/**
 * @brief		Level Count
 * @param[in]	param	^C}nh
 * @return		Ȃ
 * @note		Ȃ
 */
static void Timr_Lvcnthdr(void* param)
{
	AG903_TIMRMgrHandle* handle;

	handle = (AG903_TIMRMgrHandle*)(param);
	AG903_TIMRMgrClearStatus(handle, AG903_TIMR_OVERFLOW_BIT);

	TimrLevelCounter ++;

	return;
}

