/**
 * @brief           BMU Manager
 * @author          AXELL CORPORATION
 * @description     BMU Manager Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_03_08  [SDK2.2] BMUݒ̈`FbNǉ (#2208)
 * @history         2019_03_08  [SDK2.2] BMUobt@08Ƃ݂Ȃdlǉ (#2209)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"

#include "bmu/bmumgr.h"
#include "bmu/bmuprm.h"

/** BMU1̍őobt@ */
#define AG903_BMU_BUF_NUM_MAX (8)

static AG903_BMUMgrHandle handle_list[AG903_BMU_UNIT_NUM];
static _Bool handle_used_flag[AG903_BMU_UNIT_NUM] = {false};

/**
 * @brief       BMȔ
 * @param       unit [in] BMŨ`l
 * @return      void
 */
static void AG903_BMUMgrInit(uint8_t unit) {
	AG903_BMUPrmSetCTRL(unit, 0);
	AG903_BMUPrmSetMOD(unit, 0, 0, 0);
	AG903_BMUPrmSetSINKMODULE(unit, 0);
	AG903_BMUPrmSetBASEADR(unit, 0);
	AG903_BMUPrmSetSTRIDE(unit, 0);
	AG903_BMUPrmSetBUFNUM(unit, 0);
}

/**
 * @brief           BMUManager̃nh擾
 * @param           handles [out] 擾BMUManager̃nhi[z
 * @return          G[R[h
 * @retval          AG903_ENONE   nh̊mۂɐ
 * @retval          -AG903_EBUSY  gpłnhs
 * @description     nh擾܂.
 */
int32_t AG903_BMUMgrGetHandle(AG903_BMUMgrHandle **handle)
{
	int32_t alloc_unit = -1;
	int32_t i;

	/* 󂫂unit */
	for(i = 0 ; i < AG903_BMU_UNIT_NUM ; i++)
	{
		if(handle_used_flag[i] != true)
		{
			alloc_unit = i;
			break;
		}
	}

	if(alloc_unit == -1)
	{
		return -AG903_EBUSY;
	}

	/* ݂̐ݒ */
	AG903_BMUMgrInit(alloc_unit);

	(*handle) = &handle_list[alloc_unit];
	handle_used_flag[i] = true;

	(*handle)->unit_id = alloc_unit;
	(*handle)->is_exec = false;

	return AG903_ENONE;
}

/**
 * @brief           BMUManager̃nh
 * @param           handle [in] BMUManager̃nh
 * @return          G[R[h
 * @retval          AG903_ENONE  
 * @retval          -AG903_EINVAL ȃnhnꂽ
 * @retval          -AG903_EBUSY  BMUL
 * @description     nh܂.
 */
int32_t AG903_BMUMgrReleaseHandle(AG903_BMUMgrHandle *handle)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* s̏ꍇ */
	if(handle->is_exec)
	{
		return -AG903_EBUSY;
	}
	handle_used_flag[unit] = false;

	return AG903_ENONE;
}

/**
 * @brief           BMULɂ
 * @param           handle[in] BMUManager̃nh
 * @return          AG903_ENONE  
 * @return          -AG903_EINVAL ȃnhnꂽ
 * @description     nhɊ蓖Ăꂽ`lLɂ܂.
 */
int32_t AG903_BMUMgrEnable(AG903_BMUMgrHandle *handle)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	handle->is_exec = true;
	AG903_BMUPrmSetCTRL(unit, 1);

	return AG903_ENONE;
}

/**
 * @brief           BMU𖳌ɂ
 * @param           handle [in] BMUManager̃nh
 * @return          G[R[h
 * @retval          AG903_ENONE  
 * @retval          -AG903_EINVAL ȃnhnꂽ
 * @description     nhɊ蓖Ăꂽ`l𖳌ɂ܂.
 */
int32_t AG903_BMUMgrDisable(AG903_BMUMgrHandle *handle)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	handle->is_exec = false;
	AG903_BMUPrmSetCTRL(unit, 0);

	return AG903_ENONE;
}

/**
 * @brief           BMU̓샂[hݒ肷
 * @param           handle [in]  BMUManager̃nh
 * @param           ini [in] VNW[̃EFCg
 * @param           mgr [in] obt@Ǘ̕
 * @return          G[R[h
 * @retval          AG903_ENONE		
 * @retval          -AG903_EINVAL	ȃnhAp[^nꂽ
 * @retval          -AG903_EBUSY	BMULɐݒύXꍇ
 * @description     nhɊ蓖Ăꂽ`l̓샂[hݒ肵܂.
 */
int32_t AG903_BMUMgrSetMode(AG903_BMUMgrHandle *handle, uint8_t ini, uint8_t mgr)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* s */
	if(handle->is_exec)
	{
		return -AG903_EBUSY;
	}

	/* p[^`FbN */
	if(ini > AG903_BMU_SINK_WAIT_DISABLE)
	{
		return -AG903_EINVAL;
	}

	if(mgr > AG903_BMU_BUF_MGR_MODE3)
	{
		return -AG903_EINVAL;
	}

	uint8_t cini, cmgr, csrc;
	AG903_BMUPrmGetMOD(unit, &cini, &cmgr, &csrc);
	AG903_BMUPrmSetMOD(unit, ini, mgr, csrc);

	return AG903_ENONE;
}

/**
 * @brief           BMŨ\[XW[ݒ肷
 * @param           handle [in] BMUManager̃nh
 * @param           src [in] BMŨ\[XW[ID
 * @return          G[R[h
 * @retval          AG903_ENONE   
 * @retval          -AG903_EINVAL  ȃnhAp[^nꂽ
 * @retval          -AG903_EBUSY   BMULɐݒύXꍇ
 * @description     nhɊ蓖Ăꂽ`l̃\[XW[ݒ肵܂.
 */
int32_t AG903_BMUMgrSetSrcModule(AG903_BMUMgrHandle *handle, uint8_t src)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* s */
	if(handle->is_exec)
	{
		return -AG903_EBUSY;
	}

	/* p[^`FbN */
	if(src > AG903_BMU_SRC_JPG0)
	{
		return -AG903_EINVAL;
	}

	uint8_t ini, mgr, csrc;
	AG903_BMUPrmGetMOD(unit, &ini, &mgr, &csrc);
	AG903_BMUPrmSetMOD(unit, ini, mgr, src);
	handle->src_id = src;

	return AG903_ENONE;
}

/**
 * @brief           BMŨVNW[ǉ
 * @param           handle [in]  BMUManager̃nh
 * @param           sink [in]  BMŨVNW[ID
 * @return          G[R[h
 * @retval          AG903_ENONE   
 * @retval          -AG903_EINVAL  ȃnhAp[^nꂽ
 * @retval          -AG903_EBUSY   BMULɐݒύXꍇ
 * @description     nhɊ蓖Ăꂽ`l̃VNW[ǉ܂.<p>
 *                  ̃VNW[ݒ肷邱Ƃ\ł.<p>
 *                  Iꍇ́Aobt@̐؂ւ̃^C~OɒӂKvł.
 */
int32_t AG903_BMUMgrAddSinkModule(AG903_BMUMgrHandle *handle, uint8_t sink)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* s */
	if(handle->is_exec)
	{
		return -AG903_EBUSY;
	}

	/* p[^`FbN */
	if(sink > AG903_BMU_SINK_JPG0)
	{
		return -AG903_EINVAL;
	}

	uint32_t reg;
	AG903_BMUPrmGetSINKMODULE(unit, &reg);
	reg |= 1 << sink;
	AG903_BMUPrmSetSINKMODULE(unit, reg);

	return AG903_ENONE;
}

/**
 * @brief           BMŨVNW[폜
 * @param           handle [in] BMUManager̃nh
 * @param           sink   [in] BMŨVNW[ID
 * @return          G[R[h
 * @retval          AG903_ENONE   
 * @retval          -AG903_EINVAL  ȃnhAp[^nꂽ
 * @retval          -AG903_EBUSY   BMULɐݒύXꍇ
 * @description     nhɊ蓖Ăꂽ`l̃VNW[폜܂.
 */
int32_t AG903_BMUMgrRemoveSinkModule(AG903_BMUMgrHandle *handle, uint8_t sink)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* s */
	if(handle->is_exec)
	{
		return -AG903_EBUSY;
	}

	/* p[^`FbN */
	if(sink > AG903_BMU_SINK_JPG0)
	{
		return -AG903_EINVAL;
	}

	uint32_t reg;
	AG903_BMUPrmGetSINKMODULE(unit, &reg);
	reg &= ~(1 << sink);
	AG903_BMUPrmSetSINKMODULE(unit, reg);

	return AG903_ENONE;
}

/**
 * @brief           BMŨVNW[Xe[^X擾
 * @param           handle [in] BMUManager̃nh
 * @param           sink   [in] BMŨVNW[ID
 * @param           status [out] Xe[^X̕ۑ
 * @return          G[R[h
 * @retval          AG903_ENONE   
 * @retval          -AG903_EINVAL  ȃnhAp[^nꂽ
 * @description     nhɊ蓖Ăꂽ`l̃VNW[Xe[^X擾܂.
 */
int32_t AG903_BMUMgrGetSinkStatus(AG903_BMUMgrHandle *handle, uint8_t sink, uint8_t *status)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* p[^`FbN */
	if(sink > AG903_BMU_SINK_JPG0)
	{
		return -AG903_EINVAL;
	}

	uint32_t reg;
	AG903_BMUPrmGetSINKSTAT(unit, &reg);
	*status = (reg >> sink) & 1;

	return AG903_ENONE;
}

/**
 * @brief           BMŨobt@֘A̐ݒs
 * @param           handle  [in] BMUManager̃nh
 * @param           buffer  [in] obt@̃|C^
 * @param           stride  [in] 1̃obt@̃TCYioCgPʁj
 * @param           buf_num [in] obt@̐i0`8 08Ƃ݂Ȃ)
 * @return          G[R[h
 * @retval          AG903_ENONE    
 * @retval          -AG903_EINVAL  ȃnhAp[^nꂽ
 * @retval          -AG903_EBUSY   BMULɐݒύXꍇ
 * @description     nhɊ蓖Ăꂽ`l̃obt@֘A̐ݒύX܂.
 * @note            bufferAhXstrideTCY4096̔{𐄏܂.
 * @note            stride128oCg̔{̂ݎw\ł.
 * @note            obt@̃̓LbVsƂĉ.
 */
int32_t AG903_BMUMgrSetBufferConfig(AG903_BMUMgrHandle *handle, void *buffer, uint32_t stride, uint32_t buf_num)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* s */
	if(handle->is_exec)
	{
		return -AG903_EBUSY;
	}

	/* AhX̓G[`FbNsȂ
	   iBMUnBASEADR[31:28]0ŌŒ肳邽߁j */

	if(stride >= (1<<(24+1)) || (stride & 0x7f))
	{
		return -AG903_EINVAL;
	}

	if(buf_num > AG903_BMU_BUF_NUM_MAX)
	{
		return -AG903_EINVAL;
	}

	if (8 < buf_num)
	{
		return -AG903_EINVAL;
	}
	/* num8̂ƂAWX^l0ɂȂ */
	if(buf_num == 8)
	{
		buf_num = 0;
	}

	AG903_BMUPrmSetBASEADR(unit, ((uint32_t)buffer) & AG903_BMUn_BASEADR_ADR_MSK);
	AG903_BMUPrmSetSTRIDE (unit, stride & AG903_BMUn_STRIDE_STRIDE_MSK);
	AG903_BMUPrmSetBUFNUM (unit, buf_num);

	return AG903_ENONE;
}

/**
 * @brief           BMŨXe[^X擾
 * @param           handle [in] BMUManager̃nh
 * @param           status [out] Xe[^X̊i[
 * @return          G[R[h
 * @return          AG903_ENONE 
 * @return          -AG903_EINVAL ȃnhnꂽ
 * @description     nhɊ蓖Ăꂽ`l̃obt@֘A̐ݒύX܂.
 */
int32_t AG903_BMUMgrGetStatus(AG903_BMUMgrHandle *handle, AG903_BMUMgrStatus *status)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	BMUPrmParamSTAT regstat;
	AG903_BMUPrmGetSTAT(unit, &regstat);
	status->is_valid               = (uint8_t)regstat.val;
	status->is_empty               = (uint8_t)regstat.empty;
	status->is_read_wait_appeared  = (uint8_t)regstat.rwa;
	status->is_read_busy           = (uint8_t)regstat.rbsy;
	status->read_module_num        = (uint8_t)regstat.rnum;
	status->is_full                = (uint8_t)regstat.full;
	status->is_write_wait_appeared = (uint8_t)regstat.wwa;
	status->is_write_busy          = (uint8_t)regstat.wbsy;
	status->write_module_num       = (uint8_t)regstat.wnum;

	return AG903_ENONE;
}

/**
 * @brief           BMÜiSinkj̃AhX擾
 * @param           handle [in] BMUManager̃nh
 * @param           addr [out] AhX̊i[
 * @return          G[R[h
 * @retval          AG903_ENONE 
 * @retval          -AG903_EINVAL ȃnhnꂽ
 * @description     nhɊ蓖Ăꂽ`l̃VNAhX擾܂.
 * @note            AhXA0000000h`BFFFFFFFh͈̔͂Ŏ擾܂.
 *                  ̗̈͂炩߃LbVsƂĉ.
 */
int32_t AG903_BMUMgrGetBMUSinkAddress(AG903_BMUMgrHandle *handle, uint32_t *addr)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/*        jbgID  | BMÜ̃ItZbg */
	(*addr) = (unit<<24) | ((uint32_t)5<<29);

	return AG903_ENONE;
}

/**
 * @brief           BMÜiSrcj̃AhX擾
 * @param           handle [in] BMUManager̃nh
 * @param           addr [out] AhX̊i[
 * @return          G[R[h
 * @retval          AG903_ENONE 
 * @retval          -AG903_EINVAL ȃnhnꂽ
 * @description     nhɊ蓖Ăꂽ`l̃\[XAhX擾܂.
 * @note            AhXA0000000h`BFFFFFFFh͈̔͂Ŏ擾܂.
 *                  ̗̈͂炩߃LbVsƂĉ.
 */
int32_t AG903_BMUMgrGetBMUSrcAddress(AG903_BMUMgrHandle *handle, uint32_t *addr)
{
	uint8_t  src  = handle->src_id;
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	/* `̏ꍇA28rbgڂLɂ */
	if(AG903_BMU_SRC_GFX0 <= src && src <= AG903_BMU_SRC_GFX3)
	{
		/*        jbgID  | BMÜ̃ItZbg | `̈tO */
		(*addr) = (unit<<24) | ((uint32_t)5<<29) | ((uint32_t)1<<28);
	}else
	{
		/*        jbgID  | BMÜ̃ItZbg */
		(*addr) = (unit<<24) | ((uint32_t)5<<29);
	}

	return AG903_ENONE;
}

/**
 * @brief           BMŨW[ԍ擾
 * @param           handle [in] BMUManager̃nh
 * @param           id [out]    W[ԍ
 * @return          G[R[h
 * @return          AG903_ENONE 
 * @return          -AG903_EINVAL ȃnhnꂽ
 * @description     nhɊ蓖ĂꂽW[ԍ擾܂.
 */
int32_t AG903_BMUMgrGetBMUId(AG903_BMUMgrHandle *handle, uint8_t *id)
{
	uint32_t unit = (handle - handle_list);

	/* ȃnh */
	if(unit >= AG903_BMU_UNIT_NUM || &handle_list[unit] != handle)
	{
		return -AG903_EINVAL;
	}

	(*id) = unit;

	return AG903_ENONE;
}

