/**
 * @brief           BMU Primitive
 * @author          AXELL CORPORATION
 * @description     BMU Primitive Layer.
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 * @history         2019_03_08  [SDK2.2] BMUݒ̈`FbNǉ (#2208)
 * @history         2019_03_08  [SDK2.2] BMUobt@08Ƃ݂Ȃdlǉ (#2209)
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"

#include "bmu/bmuprm.h"

/**
 * @brief           CTRLWX^ւ̏.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           en [in] obt@Ǘ̗LE
 * @return          void
 * @description     AG903_BMU->CTRL ɃCg܂.
 * @note            none
 */
void AG903_BMUPrmSetCTRL(uint8_t unit, uint8_t en)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(en <= 1);

	AG903_BMUn(unit)->CTRL = (en << AG903_BMUn_CTRL_EN_POS) & AG903_BMUn_CTRL_EN_MSK;
}

/**
 * @brief           CTRLWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           en [out] obt@Ǘ̗LE
 * @return          void
 * @description     AG903_BMU->CTRL 烊[h܂.
 * @note            none
 */
void AG903_BMUPrmGetCTRL(uint8_t unit, uint8_t *en)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(en != NULL);

	*en = (AG903_BMUn(unit)->CTRL & AG903_BMUn_CTRL_EN_MSK) >> AG903_BMUn_CTRL_EN_POS;
}

/**
 * @brief           MODWX^ւ̏.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           ini [in] VNW[̃EFCg
 * @param           mgr [in] obt@Ǘ̕
 * @param           src [in] \[XW[ID
 * @return          void
 * @description     AG903_BMU->MOD ɃCg܂.
 * @note            none
 */
void AG903_BMUPrmSetMOD(uint8_t unit, uint8_t ini, uint8_t mgr, uint8_t src)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(ini <= 1);
	ASSERT(mgr <= 3);

	uint32_t reg = 0;
	reg |= (ini << AG903_BMUn_MOD_INI_POS) & AG903_BMUn_MOD_INI_MSK;
	reg |= (mgr << AG903_BMUn_MOD_MGR_POS) & AG903_BMUn_MOD_MGR_MSK;
	reg |= (src << AG903_BMUn_MOD_SRC_POS) & AG903_BMUn_MOD_SRC_MSK;
	AG903_BMUn(unit)->MOD = reg;
}

/**
 * @brief           MODWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param			ini [out] VNW[̃EFCg
 * @param			mgr [out] obt@Ǘ̕
 * @param			src [out] \[XW[ID
 * @return          void
 * @description     AG903_BMU->MOD 烊[h܂.
 * @note            none
 */
void AG903_BMUPrmGetMOD(uint8_t unit, uint8_t *ini, uint8_t *mgr, uint8_t *src)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(ini != NULL);
	ASSERT(mgr != NULL);

	uint32_t reg = AG903_BMUn(unit)->MOD;
	*ini = (reg & AG903_BMUn_MOD_INI_MSK) >> AG903_BMUn_MOD_INI_POS;
	*mgr = (reg & AG903_BMUn_MOD_MGR_MSK) >> AG903_BMUn_MOD_MGR_POS;
	*src = (reg & AG903_BMUn_MOD_SRC_MSK) >> AG903_BMUn_MOD_SRC_POS;
}

/**
 * @brief           SINKMODULEWX^ւ̏.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           valid [in] VNW[̗LE
 * @return          void
 * @description     AG903_BMU->SINKMODULE ɃCg܂.
 * @note            SINKIꍇ́Aobt@̐؂ւ^C~OɒӂKvłB
 */
void AG903_BMUPrmSetSINKMODULE(uint8_t unit, uint32_t valid)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT((valid & 0xFFFF0000) == 0);

	AG903_BMUn(unit)->SINKMODULE = valid;
}

/**
 * @brief           SINKMODULEWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           valid [in] VNW[̗LE̊i[
 * @return          void
 * @description     AG903_BMU->SINKMODULE 烊[h܂.
 * @note            none
 */
void AG903_BMUPrmGetSINKMODULE(uint8_t unit, uint32_t* valid)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(valid != NULL);

	*valid = AG903_BMUn(unit)->SINKMODULE;
}

/**
 * @brief           SINKSTATWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           stat [in] VNW[̃Xe[^Xi[
 * @return          void
 * @description     AG903_BMU->SINKSTAT 烊[h܂.
 * @note            l̓WX^ɕۑȂ߁AlQƂ^C~O͒ӂKvłB
 */
void AG903_BMUPrmGetSINKSTAT(uint8_t unit, uint32_t* stat)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(stat != NULL);

	*stat = AG903_BMUn(unit)->SINKSTAT;
}

/**
 * @brief           BASEADRWX^ւ̏.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           adr [in] x[XAhXi128BytePʁj
 * @return          void
 * @description     AG903_BMU->BASEADR ɃCg܂.
 * @note            7bit"0b"ɌŒ肳܂.
 */
void AG903_BMUPrmSetBASEADR(uint8_t unit, uint32_t adr)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);

	AG903_BMUn(unit)->BASEADR = (adr & AG903_BMUn_BASEADR_ADR_MSK);
}

/**
 * @brief           BASEADRWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           adr [out] x[XAhXi128BytePʁj
 * @return          void
 * @description     AG903_BMU->BASEADR 烊[h܂.
 * @note            none
 */
void AG903_BMUPrmGetBASEADR(uint8_t unit, uint32_t *adr)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(adr != NULL);

	*adr = AG903_BMUn(unit)->BASEADR;
}

/**
 * @brief           STRIDEWX^ւ̏.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           stride [in] obt@̃TCY
 * @return          void
 * @description     AG903_BMU->STRIDE ɃCg܂.
 * @note            7bit"0b"ɌŒ肳܂.
 */
void AG903_BMUPrmSetSTRIDE(uint8_t unit, uint32_t stride)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);

	AG903_BMUn(unit)->STRIDE = (stride & AG903_BMUn_STRIDE_STRIDE_MSK);
}

/**
 * @brief           STRIDEWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           stride [out] obt@̃TCY
 * @return          void
 * @description     AG903_BMU->STRIDE 烊[h܂.
 * @note            none
 */
void AG903_BMUPrmGetSTRIDE(uint8_t unit, uint32_t *stride)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(stride != NULL);

	*stride = AG903_BMUn(unit)->STRIDE;
}

/**
 * @brief           BUFNUMWX^ւ̏.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           num [in] obt@̐
 * @return          void
 * @description     AG903_BMU->BUFNUM ɃCg܂.
 * @note            none
 */
void AG903_BMUPrmSetBUFNUM(uint8_t unit, uint32_t num)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(num <= 8);

	AG903_BMUn(unit)->BUFNUM = (num << AG903_BMUn_BUFNUM_NUM_POS) & AG903_BMUn_BUFNUM_NUM_MSK;
}

/**
 * @brief           BUFNUMWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           num [out] obt@̐
 * @return          void
 * @description     AG903_BMU->BUFNUM 烊[h܂.
 * @note            none
 */
void AG903_BMUPrmGetBUFNUM(uint8_t unit, uint32_t *num)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(num  != NULL);

	*num = (AG903_BMUn(unit)->BUFNUM & AG903_BMUn_BUFNUM_NUM_MSK) >> AG903_BMUn_BUFNUM_NUM_POS;
}

/**
 * @brief           STATWX^̓ǂݍ.
 * @param           unit [in] obt@Ǘ̃jbgԍ
 * @param           stat [out] obt@Ǘ̃Xe[^X
 * @return          void
 * @description     AG903_BMU->STAT 烊[h܂.<p>
 *                  BMUPrmParamSTAT̊eoƈӖ͈ȉ̒ʂł.
 *                  <table>
 *                  <tr><th>o</th><th>Ӗ</th></tr>
 *                  <tr><td>val</td><td>obt@̏ݏ</td></tr>
 *                  <tr><td>empty</td><td>obt@󂩂ǂ</td></tr>
 *                  <tr><td>rwa</td><td>[hŃVNɃEFCgǂ</td></tr>
 *                  <tr><td>rbsy</td><td>VÑobt@gp</td></tr>
 *                  <tr><td>rnum</td><td>VN̎gpĂobt@̔ԍ</td></tr>
 *                  <tr><td>full</td><td>obt@FULLtO</td></tr>
 *                  <tr><td>wwa</td><td>[hŃ\[XɃEFCgǂ</td></tr>
 *                  <tr><td>wbsy</td><td>\[X̃obt@gp</td></tr>
 *                  <tr><td>wnum</td><td>\[X̎gpĂobt@̔ԍ</td></tr>
 *                  </table>
 */
void AG903_BMUPrmGetSTAT(uint8_t unit, BMUPrmParamSTAT *stat)
{
	ASSERT(unit < AG903_BMU_UNIT_NUM);
	ASSERT(stat != NULL);

	uint32_t reg = AG903_BMUn(unit)->STAT;
	stat->val   = (reg & AG903_BMUn_STAT_VAL_MSK  ) >> AG903_BMUn_STAT_VAL_POS;
	stat->empty = (reg & AG903_BMUn_STAT_EMPTY_MSK) >> AG903_BMUn_STAT_EMPTY_POS;
	stat->rwa   = (reg & AG903_BMUn_STAT_RWA_MSK  ) >> AG903_BMUn_STAT_RWA_POS;
	stat->rbsy  = (reg & AG903_BMUn_STAT_RBSY_MSK ) >> AG903_BMUn_STAT_RBSY_POS;
	stat->rnum  = (reg & AG903_BMUn_STAT_RNUM_MSK ) >> AG903_BMUn_STAT_RNUM_POS;
	stat->full  = (reg & AG903_BMUn_STAT_FULL_MSK ) >> AG903_BMUn_STAT_FULL_POS;
	stat->wwa   = (reg & AG903_BMUn_STAT_WWA_MSK  ) >> AG903_BMUn_STAT_WWA_POS;
	stat->wbsy  = (reg & AG903_BMUn_STAT_WBSY_MSK ) >> AG903_BMUn_STAT_WBSY_POS;
	stat->wnum  = (reg & AG903_BMUn_STAT_WNUM_MSK ) >> AG903_BMUn_STAT_WNUM_POS;
}
