/**
 * @brief       INT Manager
 * @author      AXELL CORPORATION
 * @description INT Manager Layer
 * @note        none 
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "osw/oswrapper.h"
#include "int/intmgr.h"

/**
 * @brief           ݃W[
 * @param           none
 * @return          
 * @retval          AG903_ENONE    I
 * @description     Ԃ̏s܂B
 *                  iAG903_OSWprIniInt Ăяo܂Bj
*/
int32_t AG903_INTMgrInit (void)
{
	int32_t retval;
	retval = AG903_OSWprIniInt();
	return retval;
}

/**
 * @brief           ݂̋֎~
 * @param           intno [in] ݔԍ
 * @return          ݋֎~
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     ݂̋֎~ݒ܂B
 *                  iAG903_OSWprDisInt Ăяo܂Bj
*/
int32_t AG903_INTMgrDisableInt (uint32_t intno)
{
	int32_t retval;
	retval = AG903_OSWprDisInt(intno);
	return retval;
}

/**
 * @brief           ݂̋
 * @param           intno [in] ݔԍ
 * @return          ݂̋
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     ݂̋ݒ܂B
 *                  iAG903_OSWprEnaInt Ăяo܂Bj
*/
int32_t AG903_INTMgrEnableInt (uint32_t intno)
{
	int32_t retval;
	retval = AG903_OSWprEnaInt(intno);
	return retval;
}

/**
 * @brief           ݃}XNݒ
 * @param           intmsk [in] }XNl (1ȏFmask, 0Funmask)
 * @return          ݃}XNݒ茋
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     ݂̃}XNݒ܂B
 *                  iAG903_OSWprChgIms Ăяo܂Bj
*/
int32_t AG903_INTMgrSetMask (uint32_t intmsk)
{
	int32_t retval;
	retval = AG903_OSWprChgIms(intmsk);
	return retval;
}

/**
 * @brief           ݂̃}XNԎ擾
 * @param           intmsk [out] }XN (1ȏFmask, 0Funmask)
 * @return          ݂̃}XNԎ擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     ݂̃}XNԂ擾܂B
 *                  iAG903_OSWprGetIms Ăяo܂Bj
*/
int32_t AG903_INTMgrGetMask (uint32_t* intmsk)
{
	int32_t retval;
	retval = AG903_OSWprGetIms(intmsk);
	return retval;
}

/**
 * @brief           ݗDx̐ݒ
 * @param           intno [in] ݔԍ
 * @param           intpri [in] ݗDxi0`31j
 * @return          ݗDx̐ݒ茋
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     ݗDxݒ肵܂B
 *                  iAG903_OSWprSetIpri Ăяo܂Bj
 * @note            nho^OɎsĉB
*/
int32_t AG903_INTMgrSetPriority (uint32_t intno, uint8_t intpri)
{
	int32_t retval;
	retval = AG903_OSWprSetIpri(intno, intpri);
	return retval;
}

/**
 * @brief           ݃nh̓o^
 * @param           hdrprm [in] nh
 * @return          荞݃nho^
 * @retval          nhIDԍi̒lj
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @retval          -AG903_EFAULT  s(s)
 * @retval          -AG903_ENOID   ID
 * @retval          -AG903_ESYS    VXeG[(zOG[)
 * @description     ݃nh̓o^܂B
 *                  iAG903_OSWprCreIsrAuto Ăяo܂Bj
*/
int32_t AG903_INTMgrSetHandler (AG903_INTMgrHdrPrm * hdrprm)
{
	int32_t retval;
	retval = AG903_OSWprCreIsrAuto((AG903_OSWCIsr*)hdrprm);
	return retval;
}

/**
 * @brief           ݃nh̍폜
 * @param           hdrid [in] nhIDԍ
 * @return          ݃nh̍폜
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     ݃nh̍폜܂B
 *                  iAG903_OSWprDelIsr Ăяo܂Bj
*/
int32_t AG903_INTMgrDeleteHandler (uint32_t hdrid)
{
	int32_t retval;
	retval = AG903_OSWprDelIsr(hdrid);
	return retval;
}

/**
 * @brief           ݃nh̏ԎQ
 * @param           hdrid [in] nhIDԍ
 * @param           status [out] ԏԋpAhX
 * @return          ݃nh̏ԎQƌ
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     ݃nh̏ԂQƂ܂B
 *                  iAG903_OSWprRefIsr Ăяo܂Bj
*/
int32_t AG903_INTMgrReferHandler (uint32_t hdrid, AG903_INTMgrHdrStat* status)
{
	int32_t retval;
	retval = AG903_OSWprRefIsr(hdrid, (AG903_OSWRIsr*)status);
	return retval;
}


