/**
 * @brief Movie Player Sample GVDC^tF[X
 * @file mps_gvdinterface.c
 * @author AXELL
 * @history 17_02_22  
 * @history 2017_10_26  Ver2.0
 * @note G[R[hAG903_error.hQƂ̂.
 */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#include "mps/mps_gvdinterface.h"

/**
 * MP4Rei瓾mpsMovieInfo\̂ŕԂ<p>
 * GVDĂяoA̐ȂǂɎgp
 * @brief Rei擾
 * @param id [in]Xg[ID
 * @param info [out]Rei̕ۑ
 * @return G[R[h
 */
int32_t MPS_GetMovieInfo(uint32_t id, mpsMovieInfo *info)
{
	mpsContext *ctx = MPS_getContext(id);
	gvdInitializeParam *GVDParam = MPS_getGVDInitParam();

	if(id > GVDParam->stream_num)
	    return -AG903_EINVAL;
	if(info == NULL)
	    return -AG903_EINVAL;

	info->profile		 = ctx->info.profile;
	info->level			 = ctx->info.level;
	info->total_frame	 = ctx->info.total_frame;
	info->height		 = ctx->info.height;
	info->width			 = ctx->info.width;
	info->stream_size	 = ctx->info.stream_size;
	info->time_scale	 = ctx->info.time_scale;
	info->duration		 = ctx->info.duration;
	info->frame_length	 = ctx->info.frame_length;
	info->max_ref_frames = ctx->info.max_ref_frames;
	info->keyframe_count = ctx->info.keyframe_count;
	info->keyframe		 = ctx->info.keyframe;

	return AG903_ENONE;
}

/**
 * MP4ReȉɁAwt[̃ItZbgԂ<p>
 * 肪ꍇ0ԂƂŃG[Ƃ<p>
 * iMP4t@C̉fItZbg'0'ɂȂ邱Ƃ͖j
 * @brief t[ԍt@C̃ItZbg擾
 * @param id [in]Xg[ID
 * @param frame_id [in]t[ԍ
 * @param idr_frame_id [out] IDRt[ԍ
 * @return t@C擪̃ItZbg
 * @return 0:G[it[ԍt[葽ꍇj
 * @note frame_id, idr_frame_id0NZł
 */
uint32_t MPS_GetSeekPositionFromFrameID(uint32_t id, uint32_t frame_id, uint32_t *idr_frame_id)
{
	uint32_t idr, pos;
	mpsContext *ctx = MPS_getContext(id);
	if(ctx->info.profile == 0)
		return 0;
	/* MPS̓t[1NZ */
	MPS_GetNearIDRPos(id, frame_id+1, &idr, &pos);
	if(idr_frame_id != NULL)
		*idr_frame_id = idr-1;
	return pos;
}


/**
 * MP4ReȉɁAw莞ԂɊYt[̃ItZbgԂ<p>
 * 肪ꍇ0ԂƂŃG[Ƃ<p>
 * iMP4t@C̉fItZbg'0'ɂȂ邱Ƃ͖j
 * @brief Ԃt@C̃ItZbg擾
 * @param id [in]Xg[ID
 * @param time_ms [in]ԁi~bPʁj
 * @param idr_frame_id [out] IDRt[ԍ
 * @return t@C擪̃ItZbg
 * @return 0:G[iw莞ԂĐԂ蒷ꍇj
 * @note idr_frame_id0NZł
 */
uint32_t MPS_GetSeekPositionFromTime(uint32_t id, uint32_t time_ms, uint32_t *idr_frame_id)
{
	mpsContext *ctx = MPS_getContext(id);
	uint32_t frame;
	mpsMovieInfo *info = &ctx->info;
	frame = (time_ms*1000) / (info->frame_length*1000000/info->time_scale);
	/* t[IDZo */
	return MPS_GetSeekPositionFromFrameID(id, frame, idr_frame_id);
}
