/**
 * @brief       SSP Primitive
 * @author      AXELL CORPORATION
 * @description SSP Primitive Layer
 * @note        none 
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
 * @history     2023_03_31  [SDK3.5] SSPCuI2S̃}X^[[hǉ (#4205)
 * @history     2025_03_06  [SDK3.7] SSP1[h̑MłȂsC (#5633)
 * @history     2025_03_06  [SDK3.7] SSPCuSPI[hł̑MANZX@\ǉ (#5662)
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by Axell Corporation.
 * Copyright (C) 2017-2025 Axell Corporation, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_common.h"
#include "ssp/sspprm.h"
#include "register/AG903_sspreg.h"

#define	AG903_SSP_READ_REG(CH,REG)			(AG903_SSPn(CH)->REG)
#define	AG903_SSP_READ_FLD(CH,REG,POS,MSK)	(((AG903_SSPn(CH)->REG)&MSK) >> POS)
#define	AG903_SSP_WRITE_REG(CH,REG,VAL)		(AG903_SSPn(CH)->REG  = (uint32_t)(VAL))
#define	AG903_SSP_CLR_REG(CH,REG,VAL)		(AG903_SSPn(CH)->REG &= (uint32_t)(~VAL))
#define	AG903_SSP_SET_REG(CH,REG,VAL)		(AG903_SSPn(CH)->REG |= (uint32_t)(VAL))
#define AG903_SSP_UNPACK_FLD(V,REG,FLD)     (((V) & AG903_SSPn_##REG##_##FLD##_MSK) >> AG903_SSPn_##REG##_##FLD##_POS)
#define AG903_SSP_PACK_FLD(V,REG,FLD)       (((V) << AG903_SSPn_##REG##_##FLD##_POS) & AG903_SSPn_##REG##_##FLD##_MSK)

/**
 * @brief           SSPnSSPCR0,SSPnSSPCR1̃WX^Write
 * @param           ch [in] SSP`l
 * @param           param [in] p[^
 * @return          void
 * @description     SSPnSSPCR0,SSPnSSPCR1̃WX^Write
*/
void AG903_SSPPrmSetControl(uint8_t ch, AG903_SSPPrmCtrl* param)
{
	uint32_t	ctrl_0=0;
	uint32_t	ctrl_1=0;

	ASSERT(AG903_SSP_CH_NUM > ch);

	if (AG903_SSP_OPM_MASTER == param->opm ||
		AG903_SSP_OPM_MASTER_STEREO == param->opm) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_FSFDBK_POS);
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_SCLKFDBK_POS);
	}

	if(0 != param->spi_fspo) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_SPIFSPO_POS);
	}

	ctrl_0 |= (uint32_t)((param->format << AG903_SSPn_SSPCR0_FFMT_POS) & AG903_SSPn_SSPCR0_FFMT_MSK);

	if(0 != param->spi_flash) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_FLASH_POS);
	}
	if(0 != param->validity) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_Validity_POS);
	}

	ctrl_0 |= (uint32_t)((param->fsdist << AG903_SSPn_SSPCR0_FSDIST_POS) & AG903_SSPn_SSPCR0_FSDIST_MSK);

	if(0 != param->lsb) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_LSB_POS);
	}
	if(0 != param->fspo) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_FSPO_POS);
	}
	if(0 != param->fsjstfy) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_FSJSTFY_POS);
	}
	
	ctrl_0 |= (uint32_t)((param->opm << AG903_SSPn_SSPCR0_OPM_POS) & AG903_SSPn_SSPCR0_OPM_MSK);
	
	if(0 != param->sclkpo) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_SCLKPO_POS);
	}
	if(0 != param->sclkph) {
		ctrl_0 |= (uint32_t)(1 << AG903_SSPn_SSPCR0_SCLKPH_POS);
	}
	
	ctrl_1 |= (uint32_t)((param->pdl << AG903_SSPn_SSPCR1_PDL_POS) & AG903_SSPn_SSPCR1_PDL_MSK);
	ctrl_1 |= (uint32_t)((param->sdl << AG903_SSPn_SSPCR1_SDL_POS) & AG903_SSPn_SSPCR1_SDL_MSK);
	ctrl_1 |= (uint32_t)((param->sclk_div << AG903_SSPn_SSPCR1_SCLKDIV_POS) & AG903_SSPn_SSPCR1_SCLKDIV_MSK);

	AG903_SSP_WRITE_REG(ch,SSPCR0,ctrl_0);
	AG903_SSP_WRITE_REG(ch,SSPCR1,ctrl_1);
	return;
}

/**
 * @brief           SSPnSSPCR2̃WX^Read
 * @param           ch [in] SSP`l
 * @param           param [out] p[^
 * @return          void
 * @description     SSPnSSPCR2̃WX^Write
*/
void AG903_SSPPrmGetControl2(uint8_t ch, AG903_SSPPrmCtrl2* param)
{
	uint32_t ctrl_2;

	ASSERT(AG903_SSP_CH_NUM > ch);

	ctrl_2 = AG903_SSP_READ_REG(ch,SSPCR2);
	param->fsos   = AG903_SSP_UNPACK_FLD(ctrl_2, SSPCR2, FSOS);
	param->fs     = AG903_SSP_UNPACK_FLD(ctrl_2, SSPCR2, FS);	
	param->txen   = AG903_SSP_UNPACK_FLD(ctrl_2, SSPCR2, TXEN);
	param->rxen   = AG903_SSP_UNPACK_FLD(ctrl_2, SSPCR2, RXEN);
	param->ssprst = 0;
	param->txfclr = 0;
	param->rxfclr = 0;
	param->txdoe  = AG903_SSP_UNPACK_FLD(ctrl_2, SSPCR2, TXDOE);
	param->sspen  = AG903_SSP_UNPACK_FLD(ctrl_2, SSPCR2, SSPEN);
	return;
}

/**
 * @brief           SSPnSSPCR2̃WX^Write
 * @param           ch [in] SSP`l
 * @param           param [in] p[^
 * @return          void
 * @description     SSPnSSPCR2̃WX^Write
*/
void AG903_SSPPrmSetControl2(uint8_t ch, AG903_SSPPrmCtrl2* param)
{
	uint32_t ctrl_2;

	ASSERT(AG903_SSP_CH_NUM > ch);
	param->fsos = 0;

	ctrl_2 = 0;
	ctrl_2 |= AG903_SSP_PACK_FLD(param->fsos,   SSPCR2, FSOS);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->fs,     SSPCR2, FS);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->txen,   SSPCR2, TXEN);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->rxen,   SSPCR2, RXEN);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->ssprst, SSPCR2, SSPRST);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->txfclr, SSPCR2, TXFCLR);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->rxfclr, SSPCR2, RXFCLR);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->txdoe,  SSPCR2, TXDOE);
	ctrl_2 |= AG903_SSP_PACK_FLD(param->sspen,  SSPCR2, SSPEN);
	AG903_SSP_WRITE_REG(ch,SSPCR2,ctrl_2);
	return;
}

/**
 * @brief           SSPnSSPCR2WX^TXDOErbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^TXDOErbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableOutput(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_TXDOE_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^TXDOErbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^TXDOErbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisableOutput(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_CLR_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_TXDOE_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^SSPENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^SSPENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableTransfer(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_SSPEN_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^SSPENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^SSPENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisableTransfer(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_CLR_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_SSPEN_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^SSPENrbgRead
 * @param           ch [in] SSP`l
 * @param           enable [out] Enable
 * @return          void
 * @description     SSPnSSPCR2WX^SSPENrbgRead
*/
void AG903_SSPPrmCheckEnable(uint8_t ch, uint8_t* enable)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	(*enable) = AG903_SSP_READ_FLD(ch,SSPCR2,AG903_SSPn_SSPCR2_SSPEN_POS,AG903_SSPn_SSPCR2_SSPEN_MSK);
	return;
}

/**
 * @brief           SSPnSSPCR2WX^TXENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^TXENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableTxFunc(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_TXEN_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^TXENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^TXENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisbleTxFunc(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_CLR_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_TXEN_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^RXENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^RXENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableRxFunc(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_RXEN_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^RXENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^RXENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisbleRxFunc(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_CLR_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_RXEN_POS));
	return;
}

/**
 * @brief           SSPnSSPStatusWX^TFVEtB[hRead
 * @param           ch [in] SSP`l
 * @param           entry [out] Gg
 * @return          void
 * @description     SSPnSSPStatusWX^TFVEtB[hRead
*/
void AG903_SSPPrmGetTxFifoEntry(uint8_t ch, uint8_t* entry)
{
	(*entry) = AG903_SSP_READ_FLD(ch,SSPStatus,AG903_SSPn_SSPStatus_TFVE_POS,AG903_SSPn_SSPStatus_TFVE_MSK);
	return;
}

/**
 * @brief           SSPnSSPStatusWX^RFVEtB[hRead
 * @param           ch [in] SSP`l
 * @param           entry [out] Gg
 * @return          void
 * @description     SSPnSSPStatusWX^RFVEtB[hRead
*/
void AG903_SSPPrmGetRxFifoEntry(uint8_t ch, uint8_t* entry)
{
	(*entry) = AG903_SSP_READ_FLD(ch,SSPStatus,AG903_SSPn_SSPStatus_RFVE_POS,AG903_SSPn_SSPStatus_RFVE_MSK);
	return;
}

/**
 * @brief           SSPnIntrCRWX^TFTHODtB[hWrite
 * @param           ch [in] SSP`l
 * @param           val [in] ݒl
 * @return          void
 * @description     SSPnIntrCRWX^TFTHODtB[hWrite
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmSetTxFifoThreshold(uint8_t ch, uint8_t val)
{
	AG903_SSP_CLR_REG(ch,IntrCR,AG903_SSPn_IntrCR_TFTHOD_MSK);
	AG903_SSP_SET_REG(ch,IntrCR,(val<<AG903_SSPn_IntrCR_TFTHOD_POS));
	return;
}

/**
 * @brief           SSPnIntrCRWX^RFTHODtB[hWrite
 * @param           ch [in] SSP`l
 * @param           val [in] ݒl
 * @return          void
 * @description     SSPnIntrCRWX^RFTHODtB[hWrite
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmSetRxFifoThreshold(uint8_t ch, uint8_t val)
{
	AG903_SSP_CLR_REG(ch,IntrCR,AG903_SSPn_IntrCR_RFTHOD_MSK);
	AG903_SSP_SET_REG(ch,IntrCR,(val<<AG903_SSPn_IntrCR_RFTHOD_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^TXFCLRrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^TXFCLRrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmClearTxFifo(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_TXFCLR_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^RXFCLRrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^RXFCLRrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmClearRxFifo(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_RXFCLR_POS));
	return;
}

/**
 * @brief           SSPnSSPCR2WX^SSPRSTrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnSSPCR2WX^SSPRSTrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmReset(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,SSPCR2,(1<<AG903_SSPn_SSPCR2_SSPRST_POS));
	return;
}

/**
 * @brief           SSPnSPDIFStatus0,SSPnSPDIFStatus1WX^Write
 * @param           ch [in] SSP`l
 * @param           status_0 [in] Xe[^XrbgWX^0ݒl
 * @param           status_1 [in] Xe[^XrbgWX^1ݒl
 * @return          void
 * @description     SSPnSPDIFStatus0,SSPnSPDIFStatus1WX^Write
*/
void AG903_SSPPrmSetStatusBit(uint8_t ch, uint32_t status_0, uint32_t status_1)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_WRITE_REG(ch,SPDIFStatus0,status_0);
	AG903_SSP_WRITE_REG(ch,SPDIFStatus1,status_1);
	return;
}

/**
 * @brief           SSPnSPDIFUsernWX^Write
 * @param           ch [in] SSP`l
 * @param           offset [in] WX^ItZbg
 * @param           val [in] ݒl
 * @return          void
 * @description     SSPnSPDIFUsernWX^Write
*/
void AG903_SSPPrmSetUserBit(uint8_t ch, uint8_t offset, uint32_t val)
{
	uint32_t* reg;
	
	ASSERT(AG903_SSP_CH_NUM > ch);
	
	reg = (uint32_t*)(&AG903_SSPn(ch)->SPDIFUser0);
	(*(reg+offset)) = val;
	return;
}

/**
 * @brief           SSPnIntrCRWX^TFTHIEN,TFURIENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^TFTHIEN,TFURIENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableTxInt(uint8_t ch)
{
	uint32_t	val;

	ASSERT(AG903_SSP_CH_NUM > ch);
	val =
		1<<AG903_SSPn_IntrCR_TFTHIEN_POS |
		1<<AG903_SSPn_IntrCR_TFURIEN_POS;
	AG903_SSP_SET_REG(ch,IntrCR,val);
	return;
}

/**
 * @brief           SSPnIntrCRWX^TFTHIEN,TFURIENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^TFTHIEN,TFURIENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisbleTxInt(uint8_t ch)
{
	uint32_t	val;

	ASSERT(AG903_SSP_CH_NUM > ch);
	val =
		1<<AG903_SSPn_IntrCR_TFTHIEN_POS |
		1<<AG903_SSPn_IntrCR_TFURIEN_POS;
	AG903_SSP_CLR_REG(ch,IntrCR,val);
	return;
}

/**
 * @brief           SSPnIntrCRWX^RFTHIEN,RFORIENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^RFTHIEN,RFORIENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableRxInt(uint8_t ch)
{
	uint32_t	val;

	ASSERT(AG903_SSP_CH_NUM > ch);
	val =
		1<<AG903_SSPn_IntrCR_RFTHIEN_POS |
		1<<AG903_SSPn_IntrCR_RFORIEN_POS;
	AG903_SSP_SET_REG(ch,IntrCR,val);
	return;
}

/**
 * @brief           SSPnIntrCRWX^RFTHIEN,RFORIENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^RFTHIEN,RFORIENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisbleRxInt(uint8_t ch)
{
	uint32_t	val;

	ASSERT(AG903_SSP_CH_NUM > ch);
	val =
		1<<AG903_SSPn_IntrCR_RFTHIEN_POS |
		1<<AG903_SSPn_IntrCR_RFORIEN_POS;
	AG903_SSP_CLR_REG(ch,IntrCR,val);
	return;
}

/**
 * @brief           SSPnIntrCRWX^TFDMAENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^TFDMAENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableTxDmareq(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,IntrCR,(1<<AG903_SSPn_IntrCR_TFDMAEN_POS));
	return;
}

/**
 * @brief           SSPnIntrCRWX^TFDMAENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^TFDMAENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisableTxDmareq(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_CLR_REG(ch,IntrCR,(1<<AG903_SSPn_IntrCR_TFDMAEN_POS));
	return;
}

/**
 * @brief           SSPnIntrCRWX^RFDMAENrbgSet
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^RFDMAENrbgSet
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmEnableRxDmareq(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_SET_REG(ch,IntrCR,(1<<AG903_SSPn_IntrCR_RFDMAEN_POS));
	return;
}

/**
 * @brief           SSPnIntrCRWX^RFDMAENrbgClear
 * @param           ch [in] SSP`l
 * @return          void
 * @description     SSPnIntrCRWX^RFDMAENrbgClear
 * @note            WX^[hfBt@CCg܂B
*/
void AG903_SSPPrmDisableRxDmareq(uint8_t ch)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_CLR_REG(ch,IntrCR,(1<<AG903_SSPn_IntrCR_RFDMAEN_POS));
	return;
}

/**
 * @brief           SSPnTxRxDRWX^Write
 * @param           ch [in] SSP`l
 * @param           val [in] f[^
 * @return          void
 * @description     SSPnTxRxDRWX^Write
*/
void AG903_SSPPrmSetData(uint8_t ch, uint32_t val)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	AG903_SSP_WRITE_REG(ch,TxRxDR,val);
	return;
}

/**
 * @brief           SSPnTxRxDRWX^Read
 * @param           ch [in] SSP`l
 * @param           val [out] f[^
 * @return          void
 * @description     SSPnTxRxDRWX^Read
*/
void AG903_SSPPrmGetData(uint8_t ch, uint32_t* val)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	(*val) = AG903_SSP_READ_REG(ch,TxRxDR);
	return;
}

/**
 * @brief           SSPnSSPStatusWX^Read
 * @param           ch [in] SSP`l
 * @param           status [out] Xe[^X
 * @return          void
 * @description     SSPnSSPStatusWX^Read
*/
void AG903_SSPPrmGetStatus(uint8_t ch, AG903_SSPPrmStatus* status)
{
	uint32_t	val;

	ASSERT(AG903_SSP_CH_NUM > ch);
	val = AG903_SSP_READ_REG(ch,SSPStatus);
	
	status->txfifo_num = (uint8_t)((val & AG903_SSPn_SSPStatus_TFVE_MSK) >> AG903_SSPn_SSPStatus_TFVE_POS);
	status->rxfifo_num = (uint8_t)((val & AG903_SSPn_SSPStatus_RFVE_MSK) >> AG903_SSPn_SSPStatus_RFVE_POS);
	if(AG903_SSPn_SSPStatus_BUSY_MSK & val) {
		status->busy = true;
	}
	else {
		status->busy = false;
	}
	if(AG903_SSPn_SSPStatus_TFNF_MSK & val) {
		status->txfifo_notfull = true;
	}
	else {
		status->txfifo_notfull = false;
	}
	if(AG903_SSPn_SSPStatus_RFF_MSK & val) {
		status->rxfifo_full = true;
	}
	else {
		status->rxfifo_full = false;
	}
	
	return;
}

/**
 * @brief           SSPnIntrCRWX^Write
 * @param           ch [in] SSP`l
 * @param           param [in] p[^
 * @return          void
 * @description     SSPnIntrCRWX^Write
*/
void AG903_SSPPrmSetIntControl(uint8_t ch, AG903_SSPPrmIntCtrl* param)
{
	uint32_t intr_cr;

	ASSERT(AG903_SSP_CH_NUM > ch);

	intr_cr = 0;
	intr_cr |= AG903_SSP_PACK_FLD(param->tfthod,  IntrCR, TFTHOD);
	intr_cr |= AG903_SSP_PACK_FLD(param->rfthod,  IntrCR, RFTHOD);
	intr_cr |= AG903_SSP_PACK_FLD(param->tfdmaen, IntrCR, TFDMAEN);
	intr_cr |= AG903_SSP_PACK_FLD(param->rfdmaen, IntrCR, RFDMAEN);
	intr_cr |= AG903_SSP_PACK_FLD(param->tfthien, IntrCR, TFTHIEN);
	intr_cr |= AG903_SSP_PACK_FLD(param->rfthien, IntrCR, RFTHIEN);
	intr_cr |= AG903_SSP_PACK_FLD(param->tfurien, IntrCR, TFURIEN);
	intr_cr |= AG903_SSP_PACK_FLD(param->rforien, IntrCR, RFORIEN);
	AG903_SSP_WRITE_REG(ch,IntrCR,intr_cr);
	return;
}

/**
 * @brief           SSPnIntrCRWX^Read
 * @param           ch [in] SSP`l
 * @param           param [out] p[^
 * @return          void
 * @description     SSPnIntrCRWX^Read
*/
void AG903_SSPPrmGetIntControl(uint8_t ch, AG903_SSPPrmIntCtrl* param)
{
	uint32_t intr_cr;

	ASSERT(AG903_SSP_CH_NUM > ch);

	intr_cr = AG903_SSP_READ_REG(ch,IntrCR);
	param->tfthod  = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, TFTHOD);
	param->rfthod  = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, RFTHOD);	
	param->tfdmaen = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, TFDMAEN);
	param->rfdmaen = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, RFDMAEN);
	param->tfthien = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, TFTHIEN);
	param->rfthien = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, RFTHIEN);
	param->tfurien = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, TFURIEN);
	param->rforien = AG903_SSP_UNPACK_FLD(intr_cr, IntrCR, RFORIEN);
	return;
}

/**
 * @brief           SSPnIntrStatusWX^Read
 * @param           ch [in] SSP`l
 * @param           status [out] Xe[^X
 * @return          void
 * @description     SSPnIntrStatusWX^Read
*/
void AG903_SSPPrmGetIntStatus(uint8_t ch, uint32_t* status)
{
	ASSERT(AG903_SSP_CH_NUM > ch);
	(*status) = AG903_SSP_READ_REG(ch,IntrStatus);
	return;
}

