/**
 * @brief           USBH CDC Log Header
 * @author          AXELL CORPORATION
 * @description     USBH CDC Log Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_CDC_LOG_H__
#define __USB_CDC_LOG_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "uhs_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* Ol̒` */
typedef enum {
	USBCDC_LOG_SUCCESS,							/*  */
	USBCDC_LOG_BASE = 0x200,					/* G[R[h̊l */
	USBCDC_LOG_HALT_PIPE,						/* PipeHALTĂ */
	USBCDC_LOG_ALREADY_INIT,					/* hCoɏ */
	USBCDC_LOG_NOT_INIT,						/* hCo */
	USBCDC_LOG_NO_CDC,							/* R~jP[VfoCXڑ */
	USBCDC_LOG_NOT_USE,							/* R~jP[VfoCX */
	USBCDC_LOG_NO_SUPPORT,						/* Ή̃R~jP[VfoCXڑĂ */
	USBCDC_LOG_ALREADY_REGIST,					/* CallBack o^Ɏ{ς */
	USBCDC_LOG_ALREADY_OPEN,					/* Open Ɏ{ς */
	USBCDC_LOG_ALREADY_CLOSE,					/* Close Ɏ{ς */
	USBCDC_LOG_NOT_OPEN,						/* Open { */
	USBCDC_LOG_ALREADY_START_BULKIN,			/* Bulk IN vɔsς */
	USBCDC_LOG_ALREADY_STOP_BULKIN,				/* Bulk IN vɒ~ς */
	USBCDC_LOG_BUFF_FULL_BULKIN,				/* Bulk IN obt@t */
    USBCDC_LOG_FAILED_CBI_INIT,					/* Control Bulk Interrupt w̏Ɏs */
    USBCDC_LOG_FAILED_CBI_EXIT,					/* Control Bulk Interrupt w̏IɎs */
    
    USBCDC_LOG_FAILED_CRE_CDCD,					/* CommunicationDeviceClassDriver̍쐬Ɏs */
    USBCDC_LOG_FAILED_DEL_CDCD,					/* CommunicationDeviceClassDriver̍폜Ɏs */
    USBCDC_LOG_FAILED_BULK,						/* oN]Ɏs */
    USBCDC_LOG_FAILED_CTRL,						/* Rg[]Ɏs */
    USBCDC_LOG_FAILED_INTERRUPT,				/* C^[vg]Ɏs */
    USBCDC_LOG_FAILED_STDREQ,					/* WNGXgɎs */
    USBCDC_LOG_FAILED_CLSREQ,					/* NXNGXgɎs */
	USBCDC_LOG_FAILED_CRE_CDD,					/* CdcDevice̍쐬Ɏs */
	USBCDC_LOG_FAILED_ADD_CDD,					/* CdcDevice̒ǉɎs */
    USBCDC_LOG_FAILED_REMOVE_CDD,				/* CdcDevice̊JɎs */
	USBCDC_LOG_FAILED_CRE_CPIPE,				/* ControlPIPE̍쐬Ɏs */
	USBCDC_LOG_FAILED_OPEN_CPIPE,				/* ControlPIPEOpenɎs */
	USBCDC_LOG_FAILED_CRE_BPIPE,				/* BulkPIPE̍쐬Ɏs */
	USBCDC_LOG_FAILED_OPEN_BPIPE,				/* BulkPIPEOpenɎs */
	USBCDC_LOG_FAILED_CRE_IPIPE,				/* InterruptPIPE̍쐬Ɏs */
	USBCDC_LOG_FAILED_OPEN_IPIPE,				/* InterruptPIPEOpenɎs */
    
    USBCDC_LOG_INTERNAL_FAILED_CORE,			/* RAG[񍐂ꂽ */
    USBCDC_LOG_INTERNAL_FAILED_CDC,				/* hCoG[ */
    USBCDC_LOG_SYS_SYSTEM_ERROR,				/* VXeG[ */
    USBCDC_LOG_SYS_OUT_OF_RESOURCE,				/* VXe\[X(Z}tHAtOA)̃ANZXŃG[ */
    USBCDC_LOG_SYS_PARAM_ERROR,					/* p[^wɌ肪 */
	USBCDC_LOG_ALREADY_START_INTIN,				/* Interrupt IN vɔsς */
	USBCDC_LOG_ALREADY_STOP_INTIN				/* Interrupt IN vɒ~ς */
} USB_CDC_LOG;

/* xR[h */
typedef enum {
	USBCDC_WARNCODE_BASE = 0x0400,
	USBCDC_WARNING_OVERCONN
} USB_CDC_WARNING;

/* Milestone l̒` */
typedef enum {
	USBCDC_CHECKPOINT_BASE = 0x1000,
	USBCDC_CHKPOINTS_API_INITIALIZE,			/* Usbh_Cdc_Init APIR[ꂽ */
	USBCDC_CHKPOINTS_API_INITIALIZE_FINISH,		/* Usbh_Cdc_Init APIR[AI */
	USBCDC_CHKPOINTS_API_FINALIZE,				/* Usbh_Cdc_Exit APIR[ꂽ */
	USBCDC_CHKPOINTS_API_FINALIZE_FINISH,		/* Usbh_Cdc_Exit APIR[AI */
	USBCDC_CHKPOINTS_API_REGIST,				/* Usbh_Cdc_RegistCallBack APIR[ꂽ */
	USBCDC_CHKPOINTS_API_REGIST_FINISH,			/* Usbh_Cdc_RegistCallBack APIR[AI */
	USBCDC_CHKPOINTS_API_OPEN,					/* Usbh_Cdc_Open APIR[ꂽ */
	USBCDC_CHKPOINTS_API_OPEN_FINISH,			/* Usbh_Cdc_Open APIR[AI */
	USBCDC_CHKPOINTS_API_CLOSE,					/* Usbh_Cdc_Close APIR[ꂽ */
	USBCDC_CHKPOINTS_API_CLOSE_FINISH,			/* Usbh_Cdc_Close APIR[AI */
	USBCDC_CHKPOINTS_EVNT_ATTACH_DEVICE,		/* USB Host CoreR~jP[VfoCX̐ڑʒmM */
	USBCDC_CHKPOINTS_EVNT_DETACH_DEVICE			/* USB Host CoreR~jP[VfoCX̐ؒfʒmM */
} USB_CDC_MILESTONE;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
void Usbh_Cdc_Log_ReportError(const char *pFunctionName, uhs_ubit32_t nLine, uhs_ubit16_t nError, uhs_ubit8_t *pMesg, uhs_ubit16_t u16Length);
void Usbh_Cdc_Log_ReportWarning(const char *pFunctionName, uhs_ubit32_t nLine, uhs_ubit16_t nWarning, uhs_ubit8_t *pMesg, uhs_ubit16_t u16Length);
void Usbh_Cdc_Log_ReportMilestone(uhs_ubit16_t u16CheckPointNum);
void Usbh_Cdc_Log_ReportDummy(uhs_ubit16_t nError);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_CDC_LOG_H__ */
