/**
 * @brief           USBH CDC Macro Header
 * @author          AXELL CORPORATION
 * @description     USBH CDC Macro Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_CDC_MACRO_H__
#define __USB_CDC_MACRO_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
/* z̗vfvZ */
#define numof(array) (sizeof(array)/sizeof((array)[0]))
/* ől/ŏlԂ܂ */
#define MAX(a,b) ( ((a) > (b)) ? (a):(b) )
#define MIN(a,b) ( ((a) < (b)) ? (a):(b) )


#define UNPACK16_LITTLE_ENDIAN_MSB( val )     \
    ( ((val) & 0xff00) >> 8 )
#define UNPACK16_LITTLE_ENDIAN_LSB( val )     \
    ( ((val) & 0x00ff) >> 0 )
#define UNPACK32_LITTLE_ENDIAN_MSB( val )     \
    ( ((val) & 0xff000000) >> 24 )
#define UNPACK32_LITTLE_ENDIAN_MSBM( val )     \
    ( ((val) & 0x00ff0000) >> 16 )
#define UNPACK32_LITTLE_ENDIAN_LSBM( val )     \
    ( ((val) & 0x0000ff00) >> 8 )
#define UNPACK32_LITTLE_ENDIAN_LSB( val )     \
    ( ((val) & 0x000000ff) >> 0 )
#define PACK16_LITTLE_ENDIAN( msb, lsb )                            \
    ( (((uhs_ubit16_t)(msb)) << 8) | (((uhs_ubit16_t)(lsb)) << 0))
#define PACK32_LITTLE_ENDIAN( msb, msbm, lsbm, lsb )      \
    ( (((uhs_ubit32_t)(msb))  << 24) |                    \
      (((uhs_ubit32_t)(msbm)) << 16) |                    \
      (((uhs_ubit32_t)(lsbm)) <<  8) |                    \
      (((uhs_ubit32_t)(lsb))  <<  0) )

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_CDC_MACRO_H__ */
