/** 
 * @brief           Human Interface Devices Class Driver API Headerij
 * @author          AXELL CORPORATION
 * @description     Human Interface Devices Class Driver񋟃wb_ij
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USB_HID_INTERNAL_API_H__
#define __USB_HID_INTERNAL_API_H__
/* DOM-IGNORE-END */

#include "usb_hid_coreinclude.h"
#include "usb_hid_log.h"

extern uhs_status_t Usbh_Hid_Init(app_callback_info* stCallback);
extern uhs_status_t Usbh_Hid_Exit(void* stCallback);
extern uhs_status_t Usbh_Hid_ReregisterCallback(app_callback_info* stCallback);

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define IAPI_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (uhs_ubit8_t*)"1", 0 )
#define IAPI_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportError( g_filename, __LINE__, (err), (mesg), (len) )
#define IAPI_HID_REPORT_MILESTONE(num) Usbh_Hid_Log_ReportMilestone((num))
#else
#define IAPI_HID_REPORT_SUMMARY(err) Usbh_Hid_Log_ReportDummy(err)
#define IAPI_HID_REPORT_DETAIL(err, mesg, len) Usbh_Hid_Log_ReportDummy(err)
#define IAPI_HID_REPORT_MILESTONE(num) Usbh_Hid_Log_ReportMilestone((num))
#endif

#endif // __USB_HID_INTERNAL_API_H__
