/** 
 * @brief           USBH HID log Header
 * @author          AXELL CORPORATION
 * @description	    USBH HID log Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_HID_LOG_H__
#define __USB_HID_LOG_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "uhs_type.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* Ol̒` */
typedef enum {
	USBHID_LOG_SUCCESS,							/*  */
	USBHID_LOG_BASE = 0x200,					/* G[R[h̊l */
	USBHID_LOG_HALT_PIPE,						/* PipeHALTĂ */
	USBHID_LOG_ALREADY_INIT,					/* hCoɏ */
	USBHID_LOG_NOT_INIT,						/* hCo */
	USBHID_LOG_NO_HID,							/* HIDfoCXڑ */
	USBHID_LOG_NOT_USE,							/* HIDfoCX */
	USBHID_LOG_NO_SUPPORT,						/* ΉHIDfoCXڑĂ */
	USBHID_LOG_ALREADY_REGIST,					/* CallBack o^Ɏ{ς */
    USBHID_LOG_FAILED_BOOT_INIT,				/* Boot Protocol w̏Ɏs */
    USBHID_LOG_FAILED_BOOT_EXIT,				/* Boot Protocol w̏IɎs */
    USBHID_LOG_FAILED_CRE_HIDD,					/* HIDClassDriver̍쐬Ɏs */
    USBHID_LOG_FAILED_DEL_HIDD,					/* HIDClassDriver̍폜Ɏs */
    USBHID_LOG_FAILED_CTRL,						/* Rg[]Ɏs */
    USBHID_LOG_FAILED_INTERRUPT,				/* C^[vg]Ɏs */
    USBHID_LOG_FAILED_STDREQ,					/* WNGXgɎs */
    USBHID_LOG_FAILED_CLSREQ,					/* NXNGXgɎs */
	
	USBHID_LOG_FAILED_CRE_HDD,					/* HidDevice̍쐬Ɏs */
	USBHID_LOG_FAILED_ADD_HDD,					/* HidDevice̒ǉɎs */
    USBHID_LOG_FAILED_REMOVE_HDD,				/* HidDevice̊JɎs */
	USBHID_LOG_FAILED_CRE_CPIPE,				/* ControlPIPE̍쐬Ɏs */
	USBHID_LOG_FAILED_OPEN_CPIPE,				/* ControlPIPEOpenɎs */
	USBHID_LOG_FAILED_CRE_IPIPE,				/* InterruptPIPE̍쐬Ɏs */
	USBHID_LOG_FAILED_OPEN_IPIPE,				/* InterruptPIPEOpenɎs */
    USBHID_LOG_INTERNAL_FAILED_CORE,			/* RAG[񍐂ꂽ */
    USBHID_LOG_INTERNAL_FAILED_HID,				/* hCoG[ */
    USBHID_LOG_SYS_SYSTEM_ERROR,				/* VXeG[ */
    USBHID_LOG_SYS_OUT_OF_RESOURCE,				/* VXe\[X(Z}tHAtOA)̃ANZXŃG[ */
    USBHID_LOG_SYS_PARAM_ERROR,					/* p[^wɌ肪 */
	USBHID_LOG_ALREADY_START_INTIN,				/* Interrupt IN vɔsς */
	USBHID_LOG_ALREADY_STOP_INTIN				/* Interrupt IN vɒ~ς */
} USB_HID_LOG;

/* xR[h */
typedef enum {
	USBHID_WARNCODE_BASE = 0x0400,
	USBHID_WARNING_OVERCONN
} USB_HID_WARNING;

/* Milestone l̒` */
typedef enum {
	USBHID_CHECKPOINT_BASE = 0x1000,
	USBHID_CHKPOINTS_API_INITIALIZE,			/* Usbh_Hid_Init APIR[ꂽ */
	USBHID_CHKPOINTS_API_INITIALIZE_FINISH,		/* Usbh_Hid_Init APIR[AI */
	USBHID_CHKPOINTS_API_FINALIZE,				/* Usbh_Hid_Exit APIR[ꂽ */
	USBHID_CHKPOINTS_API_FINALIZE_FINISH,		/* Usbh_Hid_Exit APIR[AI */
	USBHID_CHKPOINTS_API_REGIST,				/* Usbh_Hid_RegistCallBack APIR[ꂽ */
	USBHID_CHKPOINTS_API_REGIST_FINISH,			/* Usbh_Hid_RegistCallBack APIR[AI */
	USBHID_CHKPOINTS_EVNT_ATTACH_DEVICE,		/* USB Host CoreHIDfoCX̐ڑʒmM */
	USBHID_CHKPOINTS_EVNT_DETACH_DEVICE			/* USB Host CoreHIDfoCX̐ؒfʒmM */
} USB_HID_MILESTONE;

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
void Usbh_Hid_Log_ReportError(const char *pFunctionName, uhs_ubit32_t nLine, uhs_ubit16_t nError, uhs_ubit8_t *pMesg, uhs_ubit16_t u16Length);
void Usbh_Hid_Log_ReportWarning(const char *pFunctionName, uhs_ubit32_t nLine, uhs_ubit16_t nWarning, uhs_ubit8_t *pMesg, uhs_ubit16_t u16Length);
void Usbh_Hid_Log_ReportMilestone(uhs_ubit16_t u16CheckPointNum);
void Usbh_Hid_Log_ReportDummy(uhs_ubit16_t nError);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_HID_LOG_H__ */
