/** 
 * @brief           USBH MSC BOT StorDevice Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC BOT StorDevice Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#ifndef __USB_MSC_BOT_STORDEVICE_H__
#define __USB_MSC_BOT_STORDEVICE_H__

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_msc_coreinclude.h"
#include "usb_msc_bot.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern STOR_DEVICE* Usbh_Stor_CreateStorDevice(STOR_CLASS_DRIVER *pParent, struct usbd_usb_deviceinfo* pUsbDev);
extern uhs_boolean_t Usbh_Stor_DeleteStorDevice(STOR_DEVICE *pThis);
extern uhs_boolean_t Usbh_Stor_StorDevice_AddUnit(STOR_DEVICE *pStorDevice, STOR_UNIT *pStorUnit);
extern uhs_boolean_t Usbh_Stor_StorDevice_RemoveUnit(STOR_DEVICE *pStorDevice, STOR_UNIT *pStorUnit);
extern uhs_boolean_t Usbh_Stor_StorDevice_RemoveAllUnit(STOR_DEVICE *pStorDevice);
extern USB_BOT_STATUS Usbh_Stor_StorDevice_Transport(STOR_DEVICE *pStorDevice, STOR_BUFF *pCbw, STOR_CB_DATA_BUFF *pData, STOR_BUFF *pCsw);
extern USB_BOT_STATUS Usbh_Stor_StorDevice_ResetRecovery(STOR_DEVICE *pStorDevice);
extern USB_BOT_STATUS Usbh_Stor_StorDevice_MassStorageReset(STOR_DEVICE *pStorDevice);
extern USB_BOT_STATUS Usbh_Stor_StorDevice_GetMaxLUN( STOR_DEVICE *pStorDevice, uhs_ubit8_t *pMaxLUN );

extern STOR_PIPE* Usbh_Stor_CreateStorPipe(struct usbd_usb_deviceinfo *pParentDev, uhs_ubit8_t u8EpNum, uhs_ubit8_t u8EpDir, uhs_ubit8_t u8EpType );
extern uhs_boolean_t Usbh_Stor_DeleteStorPipe(STOR_PIPE *pPipe);
extern uhs_boolean_t Usbh_Stor_OpenStorPipe(STOR_PIPE *pPipe);
extern uhs_boolean_t Usbh_Stor_CloseStorPipe(STOR_PIPE *pPipe);
extern USB_BOT_STATUS Usbh_Stor_StorPipe_ClearHalt(STOR_PIPE *pPipe);
extern USB_BOT_STATUS Usbh_Stor_IssueSyncCtrlMsg(STOR_PIPE *pPipe, uhs_ubit8_t u8RequestType, uhs_ubit8_t u8Request, uhs_ubit8_t u8Value0, uhs_ubit8_t u8Value1, uhs_ubit8_t u8Index0, uhs_ubit8_t u8Index1, void *pDataBuf, uhs_ubit16_t u16Length );
extern USB_BOT_STATUS Usbh_Stor_IssueSyncBulkMsg(STOR_PIPE *pPipe, void *pDataBuf, uhs_ubit32_t u32Length, uhs_ubit32_t u32Timeout );


/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_BOT_STORDEVICE_H__ */
