/** 
 * @brief           USBH CFG DEBUG Header
 * @author          AXELL CORPORATION
 * @description     USBH CFG DEBUG Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */


/*
    fobO
*/

#ifndef __DEBUG_H__
#define __DEBUG_H__

// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"depend_cfg.h"
#include	"uhs_type.h"

extern	ER puts_com(ID DevID, VB *schr, UINT *scnt, TMO tmout);
#define	USBH_DBG_COMID			(1)
#define DEBUG_PUTS(ID,schr,scnt,tmout)	puts_com(ID,schr,scnt,tmout)



#if USBH_CFG_DEBUG == YES
	// *************************//
	//	For Debug Enable		//
	// *************************//

    void udi_debug_print( const char *format, ...);
    void udi_assert( udi_boolean_t expr);

    #define uhs_debug_print( __debuglevel, __msg)\
        if( USBH_DEBUG_LEVEL >= __debuglevel)    \
        {                                   \
            udi_debug_print __msg;          \
            udi_debug_print( "\r\n");       \
        }
#else
	// *************************//
	//	For Debug Disable		//
	// *************************//

    #define uhs_debug_print( __debuglevel, __msg)
    #define uhs_assert( __expr)
    #define udi_debug_print
    #define udi_assert
#endif

#endif /* __DEBUG_H__ */

