/** 
 * @brief           HCD EHCI Header
 * @author          AXELL CORPORATION
 * @description     hcd_ehci.cpwb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */


#ifndef __HCD_EHCI_H__
    #define __HCD_EHCI_H__


// *************************************************************************************************
//	include
// *************************************************************************************************
#include "usbc_main.h"
#include "hcd_com.h"
#include "hcd_ehci_rh.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
//#define EHCI_64BIT_UPPERADDR    	(0)
#define EHCI_NORMAL_DOWN_WAIT			(500)									//	500ms
#define EHCI_ASYNCSCHED_DOWN_WAIT		(500)									//	500ms
#define EHCI_ASYNCDOORBELL_WAIT			(2000)									//	2000loop

#define EHCI_PFL_ALIGN					(4096)									// Periodic Frame List 4KByteEɔzuKv
#define EHCI_QH_ALIGN					(32)									// QH́A32ByteEɔzu
#define EHCI_QTD_ALIGN					(32)									// qTD́A32ByteEɔzu

#define USB_PORT_NUM					(1)										// [gnũ|[g
#define	EHCI_OREG_OFFSET				(0x10)									//	OREG擪WX^AhXoffsetiHCAPWX^TOPx[X)

#define	EHCI_QH_DUMMY					1

#define Hcd_EHCI_usbdev2ehci(usbdev)    (struct hcd_ehci *)usbdev->hcd_info->hcd        // __Mc__   usbdev\̂ehci\̂擾
#define Hcd_EHCI_ucb2ehci(ucb)          (struct hcd_ehci *)ucb->usbdev->hcd_info->hcd   // __Mc__   ucb\̂ehci\̂擾
#define Hcd_EHCI_ucb2usbdev(ucb)        (struct hcd_ehci *)ucb->usbdev                  // __Mc__   ucb\̂usbdev\̂擾

#define	EHCI_DTQ_PTN_EXITTHREAD			((uhs_ubit32_t)0)						//	EHCI Xbh̏I
#define	EHCI_DTQ_PTN_DETECTOVERCURR		((uhs_ubit32_t)1)						//	OVERCURRENŤ݂oM

#define		EHCI_QH_LS_PERIODIC_MAX		2										//	LS Periodic StartIndex Tbl

// *************************************************************************************************
//	structure
// *************************************************************************************************
//------------------------------------------------------------------------------
// ڑfoCXEHCIŗLݒi[\
//		DEVڑɐB
//			PIPE OPENɂāAqh[][]malloc
//			PIPE CLOSEɂāAqh[][]free
//------------------------------------------------------------------------------
struct ehci_dev{                // __st__

    struct ehci_QH		*qh[2][USB_MAX_ENDPOINT/2];
																				//	ΏDEVEPQH|C^ï掩͓̂Imہj
    uhs_ubit8_t			dt[2][USB_MAX_ENDPOINT/2];
																				//	ΏDEVEṔw B31:DT xHH
};

struct ehci_QH;
struct ehci_qTD;

//------------------------------------------------------------------------------
//	EHCIhCo
//
//			EHCI̊݃nhŁA{̃|C^MessageőMB
//------------------------------------------------------------------------------
struct hcd_ehci {               // __st__

    struct hcd_ehci_cap_regs	*creg_base;										// HC Capability Registers ̃x[XAhXi[
    struct hcd_ehci_op_regs 	*oreg_base;										// HC Operational Registers ̃x[XAhXi[
    
    uhs_boolean_t				ps_enable;										// Periodic Schedule ̃Cl[u
    uhs_ubit32_t				ps_sizemsk;
    uhs_ubit16_t				ps_size;
    void						*pfl_base;										// Periodic Frame List ̃x[XAhX(4KBEĔzũAhX)
    void						*pfl_alloc;										// Periodic Frame List ̃mێ̃AhX

    struct ehci_QH  			*qh;											// Asynchronous Schedule  QH ւ̃|C^
																				//	LȁAASYNC QH`F[BɃ`F[OB
																				//	܂ASASYNC QH̏́A{|C^NULLɏB

    struct ehci_qTD				*shortpkt_qtd;									// V[gpPbg qTD
    
    struct hcd_driver_info 		*register_info;									// o^\̊i[p
    uhs_list_node_t				ps_qh_list;										// Periodic Schedule ɃNꂽ QH ̃Xg
    uhs_ubit32_t				ps_qh_num;										// Periodic Schedule ɃNꂽ QH ̐
    
    struct root_hub				root_hub;										// [gnȕi[
    uhs_ubit32_t				intr_status;									// 荞݃Xe[^Xi[
    uhs_boolean_t				resetcmp[ USB_HW_PORT_NUM ];					// Reset Xe[^X

    kernel_context_t			sem;

};



//------------------------------------------------------------------------------
//	CapabilityWX^`
//------------------------------------------------------------------------------
struct hcd_ehci_cap_regs {              // __st__

    uhs_ubit32_t    HCCAP;														//	0x00 : HC Capability Register
    																			//			31-16	:	HCIVERSION
    																			//			15-9	:	reserved
    																			//			7-0		:	CAPLENGTH

	#define		HCCAP_REVISION_MSK		(0xFF000000)
	#define		HCCAP_REVISION_SFT		(24)
	#define		HCCAP_CAPLEN_MSK		(0x000000FF)
	#define		HCCAP_CAPLEN_SFT		(0)

    uhs_ubit32_t    HCSPARAMS;													// 0x04	:	Structural Parameters
    uhs_ubit32_t    HCCPARAMS;													// 0x08	:	Capability Parameters
//    uhs_ubit32_t    HCSPPORTROUTE0;											// Companion Port Route Description
//    uhs_ubit32_t    HCSPPORTROUTE1;											// Companion Port Route Description
};


//------------------------------------------------------------------------------
//	OperatiionalWX^`
//------------------------------------------------------------------------------
struct hcd_ehci_op_regs {              // __st__

    uhs_ubit32_t    USBCMD;														// 0x10	:	USB Command Register
    uhs_ubit32_t    USBSTS;														// 0x14	:	USB Status Register
    uhs_ubit32_t    USBINTR;													// 0x18	:	USB Interrupt Enable Register
    uhs_ubit32_t    FRINDEX;													// 0x1C	:	Frame Index Register
//    uhs_ubit32_t    CTRLDSSEGMENT;											// Control Data Structure Segment Register
    uhs_ubit32_t    dummy1[1];													// 0x20	:	Reserved
    uhs_ubit32_t    PERIODICLISTBASE;											// 0x24	:	Periodic Frame List Base Address Register
    uhs_ubit32_t    ASYNCLISTADDR;												// 0x28	:	Current Asynchronous List Address Register
    uhs_ubit32_t    dummy2[1];													// 0x2C	:	Reserved
//    uhs_ubit32_t    CONFIGFLAG;												// Configure Flag Register
    uhs_ubit32_t    PORTSC[ USB_HW_PORT_NUM ];									// 0x30	:	Port Status and Control Register
    uhs_ubit32_t    dummy3[3];													// 0x34	:	Reserved
																				// 0x38	:	Reserved
																				// 0x3C	:	Reserved
	uhs_ubit32_t	HCMISC;														// 0x40 :	HC Miscellaneous Register
	uhs_ubit32_t	FS_EOF;														// 0x44 :	HC Full-Speed (FS) EOF1 Timing Point Register 
	uhs_ubit32_t	HS_EOF;														// 0x48 :	HC High-Speed (HS) EOF1 Timing Point Register

    uhs_ubit32_t    dummy4[13];													// 0x4C-0x7C :	Reserved

	uhs_ubit32_t	OTG_CSR;													// 0x80 :	OTG Control Status Register 
	uhs_ubit32_t	OTG_ISR;													// 0x84 :	OTG Interrupt Status Register
	uhs_ubit32_t	OTG_IER;													// 0x88 :	OTG Interrupt Enable Register

    uhs_ubit32_t    dummy5[13];													// 0x8C-0xBC :	Reserved

	uhs_ubit32_t	GLB_ISR;													// 0xC0 :	Global HC/OTG/DEV Interrupt Status Register
	uhs_ubit32_t	GLB_INT;													// 0xC4 :	Global Mask of HC/OTG/DEV Interrupt Register 
};


//	for HCMISC register
#define		EHCI_HCMISC_HPHY_SUSPEND_MSK		(0x00000040)					//	---- ---- ---- ---- ---- ---- -x-- ----
#define		EHCI_HCMISC_HPHY_SUSPEND_ENA		(0x00000040)					//	---- ---- ---- ---- ---- ---- -1-- ----
#define		EHCI_HCMISC_HPHY_SUSPEND_DIS		(0x00000000)					//	---- ---- ---- ---- ---- ---- -0-- ----

#define		EHCI_HCMISC_EOF2_TIME_MSK			(0x00000030)					//	---- ---- ---- ---- ---- ---- --xx ----
#define		EHCI_HCMISC_EOF2_TIME_00			(0x00000000)					//	---- ---- ---- ---- ---- ---- --00 ----
#define		EHCI_HCMISC_EOF2_TIME_01			(0x00000010)					//	---- ---- ---- ---- ---- ---- --01 ----
#define		EHCI_HCMISC_EOF2_TIME_10			(0x00000020)					//	---- ---- ---- ---- ---- ---- --10 ----
#define		EHCI_HCMISC_EOF2_TIME_11			(0x00000030)					//	---- ---- ---- ---- ---- ---- --11 ----

#define		EHCI_HCMISC_EOF1_TIME_MSK			(0x0000000C)					//	---- ---- ---- ---- ---- ---- ---- xx--
#define		EHCI_HCMISC_EOF1_TIME_00			(0x00000000)					//	---- ---- ---- ---- ---- ---- ---- 00--
#define		EHCI_HCMISC_EOF1_TIME_01			(0x00000004)					//	---- ---- ---- ---- ---- ---- ---- 01--
#define		EHCI_HCMISC_EOF1_TIME_10			(0x00000008)					//	---- ---- ---- ---- ---- ---- ---- 10--
#define		EHCI_HCMISC_EOF1_TIME_11			(0x0000000C)					//	---- ---- ---- ---- ---- ---- ---- 11--

#define		EHCI_HCMISC_ASYNCSLEEP_MSK			(0x00000003)					//	---- ---- ---- ---- ---- ---- ---- --xx
#define		EHCI_HCMISC_ASYNCSLEEP_5US			(0x00000000)					//	---- ---- ---- ---- ---- ---- ---- --00
#define		EHCI_HCMISC_ASYNCSLEEP_10US			(0x00000001)					//	---- ---- ---- ---- ---- ---- ---- --01
#define		EHCI_HCMISC_ASYNCSLEEP_15US			(0x00000002)					//	---- ---- ---- ---- ---- ---- ---- --10
#define		EHCI_HCMISC_ASYNCSLEEP_20US			(0x00000003)					//	---- ---- ---- ---- ---- ---- ---- --11


//	for FS_EOF register
#define		EHCI_FSEOF_EOF1_125US_MSK			(0x00007000)					//	---- ---- ---- ---- -xxx ---- ---- ----
#define		EHCI_FSEOF_EOF1_125US_111			(0x00007000)					//	---- ---- ---- ---- -111 ---- ---- ----
#define		EHCI_FSEOF_EOF1_MSK					(0x00000FFF)					//	---- ---- ---- ---- ---- xxxx xxxx xxxx

//	for OTG_CSR register
#define		EHCI_OTG_CSR_SPD_TYPE_MSK			(0x00C00000)					//	---- ---- xx-- ---- ---- ---- ---- ----
#define		EHCI_OTG_CSR_SPD_TYPE_HS			(0x00800000)					//	---- ---- 10-- ---- ---- ---- ---- ----
#define		EHCI_OTG_CSR_SPD_TYPE_FS			(0x00000000)					//	---- ---- 00-- ---- ---- ---- ---- ----
#define		EHCI_OTG_CSR_SPD_TYPE_LS			(0x00400000)					//	---- ---- 01-- ---- ---- ---- ---- ----

#define		EHCI_OTG_CSR_A_BUS_DROP_MSK			(0x00000020)					//	---- ---- ---- ---- ---- ---- --x- ----
#define		EHCI_OTG_CSR_A_BUS_DROP_ENA			(0x00000020)					//	---- ---- ---- ---- ---- ---- --1- ----
#define		EHCI_OTG_CSR_A_BUS_DROP_DIS			(0x00000000)					//	---- ---- ---- ---- ---- ---- --0- ----

#define		EHCI_OTG_CSR_A_BUS_REQ_MSK			(0x00000010)					//	---- ---- ---- ---- ---- ---- ---x ----
#define		EHCI_OTG_CSR_A_BUS_REQ_ENA			(0x00000010)					//	---- ---- ---- ---- ---- ---- ---1 ----
#define		EHCI_OTG_CSR_A_BUS_REQ_DIS			(0x00000000)					//	---- ---- ---- ---- ---- ---- ---0 ----


//	for GLB_INT register
#define		EHCI_GLB_INT_INT_POLARITY_MSK		(0x00000008)					//	---- ---- ---- ---- ---- ---- ---- x---
#define		EHCI_GLB_INT_INT_POLARITY_LOW		(0x00000000)					//	---- ---- ---- ---- ---- ---- ---- 0---
#define		EHCI_GLB_INT_INT_POLARITY_HI		(0x00000008)					//	---- ---- ---- ---- ---- ---- ---- 1---

#define		EHCI_GLB_INT_MHC_INT_MSK			(0x00000004)					//	---- ---- ---- ---- ---- ---- ---- -x--
#define		EHCI_GLB_INT_MHC_INT_ENA			(0x00000000)					//	---- ---- ---- ---- ---- ---- ---- -0--
#define		EHCI_GLB_INT_MHC_INT_DIS			(0x00000004)					//	---- ---- ---- ---- ---- ---- ---- -1--

#define		EHCI_GLB_INT_MOTG_INT_MSK			(0x00000002)					//	---- ---- ---- ---- ---- ---- ---- --x-
#define		EHCI_GLB_INT_MOTG_INT_ENA			(0x00000000)					//	---- ---- ---- ---- ---- ---- ---- --0-
#define		EHCI_GLB_INT_MOTG_INT_DIS			(0x00000002)					//	---- ---- ---- ---- ---- ---- ---- --1-

#define		EHCI_GLB_INT_MDEV_INT_MSK			(0x00000001)					//	---- ---- ---- ---- ---- ---- ---- ---x
#define		EHCI_GLB_INT_MDEV_INT_ENA			(0x00000000)					//	---- ---- ---- ---- ---- ---- ---- ---0
#define		EHCI_GLB_INT_MDEV_INT_DIS			(0x00000001)					//	---- ---- ---- ---- ---- ---- ---- ---1




//------------------------------------------------------------------------------
//	qTD `
//------------------------------------------------------------------------------
// link pointer ̃rbg`
#define EHCI_LINK_LINKPOINTER_MSK           (0xFFFFFFE0)
#define EHCI_LINK_TYPE_MSK                  (0x03 << 1)
    #define EHCI_LINK_TYPE_ISO                  (0x00 << 1)
    #define EHCI_LINK_TYPE_QH                   (0x01 << 1)
    #define EHCI_LINK_TYPE_SiTD                 (0x10 << 1)
    #define EHCI_LINK_TYPE_FSTN                 (0x11 << 1)
#define EHCI_LINK_T_MSK                     (0x01 << 0)
    #define EHCI_LINK_T_TERMINATED              (0x01 << 0)
    #define EHCI_LINK_T_NOTTERMINATED           (0x00 << 0)

#define EHCI_QTD_MAXNUM     (4)													//	1̃NGXgŐqTD̍ő吔(4k*5)*4=80Kbyteő

struct ehci_qTD {               // __st__
	//--------------------------------------------------
	// EHCI hCo, EHCIRg[ʕ()
	//--------------------------------------------------
    uhs_ubit32_t    next_qtd_pointer;               // ======== DWORD0 ========
    uhs_ubit32_t    alt_next_qtd_pointer;           // ======== DWORD1 ========

#ifdef	USBH_BITFIELD_LSB														//	LSB l߂
                                                    // ======== DWORD2 ========
    uhs_ubit8_t     status;                         //   bit[7:0]
        #define         EHCI_QTD_STAT_PING_MSK      (0x01 << 0)
            #define         EHCI_QTD_STAT_PING_OUT      (0x00 << 0)
            #define         EHCI_QTD_STAT_PING_PING     (0x01 << 0)
        #define         EHCI_QTD_STAT_ERR_MSK       (0x01 << 0)
        #define         EHCI_QTD_STAT_SPLITX_MSK    (0x01 << 1)
            #define         EHCI_QTD_STAT_SPLITX_START  (0x00 << 1)
            #define         EHCI_QTD_STAT_SPLITX_COMP   (0x01 << 1)
        #define         EHCI_QTD_STAT_MISMFRM_MSK   (0x01 << 2)
        #define         EHCI_QTD_STAT_XACTERR_MSK   (0x01 << 3)
        #define         EHCI_QTD_STAT_BABBLE_MSK    (0x01 << 4)
        #define         EHCI_QTD_STAT_DTBUFFERR_MSK (0x01 << 5)
        #define         EHCI_QTD_STAT_HALTED_MSK    (0x01 << 6)
            #define         EHCI_QTD_STAT_HALTED        (0x01 << 6)
            #define         EHCI_QTD_STAT_NOT_HALTED    (0x00 << 6)
        #define         EHCI_QTD_STAT_ACTIVE_MSK    (0x01 << 7)
            #define         EHCI_QTD_STAT_ACTIVE        (0x01 << 7)
            #define         EHCI_QTD_STAT_NON_ACTIVE    (0x00 << 7)

    uhs_ubit8_t     pid_code:2;                     //   bit[9:8]
        #define         EHCI_QTD_PID_OUT        (0x00)
        #define         EHCI_QTD_PID_IN         (0x01)
        #define         EHCI_QTD_PID_SETUP      (0x02)
    uhs_ubit8_t     error_counter:2;                //   bit[11:10]
    uhs_ubit8_t     current_page:3;                 //   bit[14:12]
    uhs_ubit8_t     int_on_comp:1;                  //   bit[15]
        #define         EHCI_QTD_INT_ON_COMP    (0x01)
        #define         EHCI_QTD_NOINT_ON_COMP  (0x00)
    uhs_ubit16_t    totalbyte:15;                   //   bit[30:16]
    uhs_ubit16_t    dt:1;                           //   bit[31]
        #define         EHCI_QH_DT0             (0x00)
        #define         EHCI_QH_DT1             (0x01)

#endif	//	USBH_BITFIELD_LSB

#ifdef	USBH_BITFIELD_MSB														//	MSB l߂
                                                    // ======== DWORD2 ========
    uhs_ubit16_t    dt:1;                           //   bit[31]
        #define         EHCI_QH_DT0             (0x00)
        #define         EHCI_QH_DT1             (0x01)
    uhs_ubit16_t    totalbyte:15;                   //   bit[30:16]
    uhs_ubit8_t     int_on_comp:1;                  //   bit[15]
        #define         EHCI_QTD_INT_ON_COMP    (0x01)
        #define         EHCI_QTD_NOINT_ON_COMP  (0x00)
    uhs_ubit8_t     current_page:3;                 //   bit[14:12]
    uhs_ubit8_t     error_counter:2;                //   bit[11:10]
    uhs_ubit8_t     pid_code:2;                     //   bit[9:8]
        #define         EHCI_QTD_PID_OUT        (0x00)
        #define         EHCI_QTD_PID_IN         (0x01)
        #define         EHCI_QTD_PID_SETUP      (0x02)
    uhs_ubit8_t     status;                         //   bit[7:0]
        #define         EHCI_QTD_STAT_PING_MSK      (0x01 << 0)
            #define         EHCI_QTD_STAT_PING_OUT      (0x00 << 0)
            #define         EHCI_QTD_STAT_PING_PING     (0x01 << 0)
        #define         EHCI_QTD_STAT_ERR_MSK       (0x01 << 0)
        #define         EHCI_QTD_STAT_SPLITX_MSK    (0x01 << 1)
            #define         EHCI_QTD_STAT_SPLITX_START  (0x00 << 1)
            #define         EHCI_QTD_STAT_SPLITX_COMP   (0x01 << 1)
        #define         EHCI_QTD_STAT_MISMFRM_MSK   (0x01 << 2)
        #define         EHCI_QTD_STAT_XACTERR_MSK   (0x01 << 3)
        #define         EHCI_QTD_STAT_BABBLE_MSK    (0x01 << 4)
        #define         EHCI_QTD_STAT_DTBUFFERR_MSK (0x01 << 5)
        #define         EHCI_QTD_STAT_HALTED_MSK    (0x01 << 6)
            #define         EHCI_QTD_STAT_HALTED        (0x01 << 6)
            #define         EHCI_QTD_STAT_NOT_HALTED    (0x00 << 6)
        #define         EHCI_QTD_STAT_ACTIVE_MSK    (0x01 << 7)
            #define         EHCI_QTD_STAT_ACTIVE        (0x01 << 7)
            #define         EHCI_QTD_STAT_NON_ACTIVE    (0x00 << 7)
#endif	//	USBH_BITFIELD_MSB

    uhs_ubit32_t    buf_pointer_page[5];            // ======== DWORD3-7 ========
        #define         EHCI_QTD_PAGENUM        (5)
        #define         EHCI_QTD_BUFPTR_MSK     (0xFFFFF000)
        #define         EHCI_QTD_COFFSET_MSK    (0x00000FFF)
        #define         EHCI_PAGE_SIZE          (0x1000) // 4KB

	//--------------------------------------------------
	// EHCI hCoŗL()
	//--------------------------------------------------
    struct usb_control_block *ucb;
    struct ehci_QH  *qh;                    // {qTDNĂQH̃AhXi[
    uhs_ubit8_t     flags;
        #define         EHCI_QTD_COMP_FLG       (1 << 0)
        #define         EHCI_QTD_NON_COMP_FLG   (0 << 0)
    void *qtd_alloc;
    void *virt_nextqtd;
    void *virt_altnextqtd;
};





#define EHCI_STATUS_ERROR( status ) \
    ( status & ( EHCI_QTD_STAT_HALTED_MSK | EHCI_QTD_STAT_DTBUFFERR_MSK | \
                 EHCI_QTD_STAT_BABBLE_MSK | EHCI_QTD_STAT_XACTERR_MSK |  \
                 EHCI_QTD_STAT_MISMFRM_MSK ))


//------------------------------------------------------------------------------
//	QHǗ \
//------------------------------------------------------------------------------
struct ehci_QH {                // __st__
	//--------------------------------------------------
	// EHCI hCo, EHCIRg[ʕ()
	//--------------------------------------------------
    uhs_ubit32_t    qh_horizontal_link_pointer;									// ======== DWORD0 ========


#ifdef	USBH_BITFIELD_LSB														//	LSB l߂
																				// ======== DWORD1 ========
    uhs_ubit8_t     device_address:7;											//   bit[6:0]
    uhs_ubit8_t     inactive:1;													//   bit[7]
    uhs_ubit8_t     ep_number:4;												//   bit[11:8]
    uhs_ubit8_t     ep_speed:2;													//   bit[13:12]
        #define         EHCI_QH_EPS_FS          (0x00)
        #define         EHCI_QH_EPS_LS          (0x01)
        #define         EHCI_QH_EPS_HS          (0x02)
    uhs_ubit8_t     dt_control:1;												//   bit[14]
        #define         EHCI_QH_DT_IGNORE       (0x00)
        #define         EHCI_QH_DT_ENABLE       (0x01)
    uhs_ubit8_t     H:1;														//   bit[15]
    uhs_ubit16_t    max_packet_length:11;										//   bit[26:16]
    uhs_ubit16_t    control_ep_flg:1;											//   bit[27]
    uhs_ubit16_t    nak_count_reload:4;											//   bit[31:28]
        #define         EHCI_QH_MAX_RELOAD_VALUE    (0x0F)

																				// ======== DWORD2 ========
    uhs_ubit32_t    int_sched_mask:8;											//   bit[7:0]
    uhs_ubit32_t    split_cmp_mask:8;											//   bit[15:8]
    uhs_ubit32_t    hub_addr:7;													//   bit[22:16]
    uhs_ubit32_t    port_number:7;												//   bit[29:23]
    uhs_ubit32_t    mult:2;														//   bit[31:30]
        #define         EHCI_QH_MULT_ONE        (0x01)
        #define         EHCI_QH_MULT_TWO        (0x02)
        #define         EHCI_QH_MULT_THREE      (0x03)

    uhs_ubit32_t    current_qtd_link_pointer;									// ======== DWORD3 ========
        #define         EHCI_QH_CQTD_MASK   (0xFFFFFFE0)

	//---------------------
	// transfer overlay
    uhs_ubit32_t    next_qtd_pointer;											// ======== DWORD4 ========
    uhs_ubit32_t    alt_next_qtd_pointer;										// ======== DWORD5 ========
																				// ======== DWORD6 ========
    uhs_ubit8_t     status;														//   bit[7:0]
    uhs_ubit8_t     pid_code:2;													//   bit[9:8]
    uhs_ubit8_t     error_counter:2;											//   bit[11:10]
    uhs_ubit8_t     current_page:3;												//   bit[14:12]
    uhs_ubit8_t     int_on_comp:1;												//   bit[15]
    uhs_ubit16_t    totalbyte:15;												//   bit[30:16]
    uhs_ubit16_t    dt:1;														//   bit[31]

#endif	//	USBH_BITFIELD_LSB														//	LSB l߂


#ifdef	USBH_BITFIELD_MSB														//	MSB l߂
																				// ======== DWORD1 ========
    uhs_ubit16_t    nak_count_reload:4;											//   bit[31:28]
        #define         EHCI_QH_MAX_RELOAD_VALUE    (0x0F)
    uhs_ubit16_t    control_ep_flg:1;											//   bit[27]
    uhs_ubit16_t    max_packet_length:11;										//   bit[26:16]
    uhs_ubit8_t     H:1;														//   bit[15]
    uhs_ubit8_t     dt_control:1;												//   bit[14]
        #define         EHCI_QH_DT_IGNORE       (0x00)
        #define         EHCI_QH_DT_ENABLE       (0x01)
    uhs_ubit8_t     ep_speed:2;													//   bit[13:12]
        #define         EHCI_QH_EPS_FS          (0x00)
        #define         EHCI_QH_EPS_LS          (0x01)
        #define         EHCI_QH_EPS_HS          (0x02)
    uhs_ubit8_t     ep_number:4;												//   bit[11:8]
    uhs_ubit8_t     inactive:1;													//   bit[7]
    uhs_ubit8_t     device_address:7;											//   bit[6:0]

																				// ======== DWORD2 ========
    uhs_ubit32_t    mult:2;														//   bit[31:30]
        #define         EHCI_QH_MULT_ONE        (0x01)
        #define         EHCI_QH_MULT_TWO        (0x02)
        #define         EHCI_QH_MULT_THREE      (0x03)
    uhs_ubit32_t    port_number:7;												//   bit[29:23]
    uhs_ubit32_t    hub_addr:7;													//   bit[22:16]
    uhs_ubit32_t    split_cmp_mask:8;											//   bit[15:8]
    uhs_ubit32_t    int_sched_mask:8;											//   bit[7:0]

    uhs_ubit32_t    current_qtd_link_pointer;									// ======== DWORD3 ========
        #define         EHCI_QH_CQTD_MASK   (0xFFFFFFE0)

	//---------------------
	// transfer overlay
    uhs_ubit32_t    next_qtd_pointer;											// ======== DWORD4 ========
    uhs_ubit32_t    alt_next_qtd_pointer;										// ======== DWORD5 ========
																				// ======== DWORD6 ========
    uhs_ubit16_t    dt:1;														//   bit[31]
    uhs_ubit16_t    totalbyte:15;												//   bit[30:16]
    uhs_ubit8_t     int_on_comp:1;												//   bit[15]
    uhs_ubit8_t     current_page:3;												//   bit[14:12]
    uhs_ubit8_t     error_counter:2;											//   bit[11:10]
    uhs_ubit8_t     pid_code:2;													//   bit[9:8]
    uhs_ubit8_t     status;														//   bit[7:0]
#endif	//	USBH_BITFIELD_MSB

    uhs_ubit32_t    buf_pointer_page[5];										// DWORD7-11

	//--------------------------------------------------
	// EHCI hCoŗL()
	//--------------------------------------------------
    uhs_ubit8_t    qh_status;													// QH ̃Xe[^XL
        #define         QH_UNLINK           0
        #define         QH_LINKED           1
        #define         QH_WAIT_UNLINK      2
        #define         QH_WAIT_UNLINK_ERR  3
    uhs_ubit8_t			trans_type;												// ]^Cv(Control,Bulk,Interrupt,Isochronous)
    uhs_ubit16_t		interval;												// interval(struct usb_control_block ̃o interval ɑΉ)
    void				*qh_alloc;
    void				*virt_qh_horizontal;
    struct ehci_qTD		*linked_qtd;											//	QHɃNĂqTD`F[
    uhs_ubit8_t			ls_periodic_ena;										// LS Periodc index Enable Flg
    uhs_ubit8_t			ls_periodic_index;										// LS Periodc index
    uhs_ubit8_t			dummy[2];
};


//------------------------------------------------------------------------------
// PCI Configuration Registers
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// Host Controller Capability Registers
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// HCSPARAMS - Structual Parameters
//   Address:        Base+(04h)
//   Default Value:  Implementation Dependent
//   Attribute:      RO
//   Size            32bits
//
//------------------------------------------------------------------------------
// N_PORTS
#define     EHCI_REG_N_PORTS_MSK        (0x0F << 0)
// Port Power Control (PPC)														AG903 ɂ́A݂ȂB
#define     EHCI_REG_PPC_MSK            (0x01 << 4)
    #define     EHCI_REG_PPC_ENABLE         (0x01 << 4)
    #define     EHCI_REG_PPC_DISABLE        (0x00 << 4)
// Bit[6:5] are reserved.
// Port Routing Rules															AG903 ɂ́A݂ȂB
#define     EHCI_REG_PORTRTRULES_MSK    (0x01 << 7)
    #define     EHCI_REG_PORTRTRULES0       (0x00 << 7)
    #define     EHCI_REG_PORTRTRULES1       (0x01 << 7)
// Number of Ports per Companion Controller (N_PCC)								AG903 ɂ́A݂ȂB
#define     EHCI_REG_N_PCC_MSK          (0x0F << 8)
// Number of Conmapnion Controller (N_CC)										AG903 ɂ́A݂ȂB
#define     EHCI_REG_N_CC_MSK           (0x0F << 12)
// Port Indicators (P_INDICATOR)												AG903 ɂ́A݂ȂB
#define     EHCI_REG_P_INDICATOR_MSK    (0x01 << 16)
// Bit[19:17] are reserved.
// Debug Port Number															AG903 ɂ́A݂ȂB
#define     EHCI_REG_DBG_PORTNUM_MSK    (0x0F << 20)
// Bit[31:24] are reserved.


//------------------------------------------------------------------------------
// HCCPARAMS - Capability Parameters
//   Address:        Operational Base+(08h)
//   Default Value:  Implementation Dependent
//   Attribute:      RO
//   Size            32bits
//
//------------------------------------------------------------------------------
// 64-bit Addressing Capability													AG903 ɂ́A݂ȂB
#define EHCI_REG_64BIT_ADDR_MSK         (0x01 << 0)
    #define EHCI_REG_64BIT_ADDR_32BIT       (0x00 << 0)
    #define EHCI_REG_64BIT_ADDR_64BIT       (0x01 << 0)
// Programmable Frame List Flag
#define EHCI_REG_PRGMABLE_FL_MSK        (0x01 << 1)
    #define EHCI_REG_PRGMABLE_FL_NO         (0x00 << 1)
    #define EHCI_REG_PRGMABLE_FL_YES        (0x01 << 1)
// Asynchronous Schedule Park Capability
#define EHCI_REG_AS_PARK_MSK            (0x01 << 2)
    #define EHCI_REG_AS_PARK_NSPT           (0x00 << 2)
    #define EHCI_REG_AS_PARK_SPT            (0x01 << 2)
// Bit3 is reserved
// Isochronous Scheduling Threshold												AG903 ɂ́A݂ȂB
#define EHCI_REG_ISOSCHED_THRSLD_MSK    (0x0F << 4)
// EHCI Extended Capabilities Pointer (EECP)									AG903 ɂ́A݂ȂB
#define EHCI_REG_EHCIEXCAP_MSK          (0xFF << 8)
// Bit[31:16] are reserved.







//------------------------------------------------------------------------------
// Host Controller Operational Registers
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// USBCMD - USB Command Register
//   Address:        Operational Base+(00h)
//   Default Value:  00080000h
//   Size            32bits
//
//------------------------------------------------------------------------------
// Run/Stop(RS) - R/W
#define     EHCI_REG_RS_MSK             (0x01 << 0)
    #define     EHCI_REG_RS_STOP            (0x00 << 0)
    #define     EHCI_REG_RS_RUN             (0x01 << 0)
// Host Controller Reset(HCRESET) - R/W
#define     EHCI_REG_HCRESET_MSK        (0x01 << 1)
    #define     EHCI_REG_HCRESET_RESET      (0x01 << 1)
    #define     EHCI_REG_HCRESET_RCMP       (0x00 << 1)							// Reset  HC Zbg
// Frame List Size - R/W or RO
#define     EHCI_REG_FRLSTSZ_MSK        (0x03 << 2)
    #define     EHCI_REG_FRLSTSZ_1024       (0x00 << 2)
        #define     EHCI_FRLSTSZ_1024       (1024)
    #define     EHCI_REG_FRLSTSZ_512        (0x01 << 2)
        #define     EHCI_FRLSTSZ_512        (512)
    #define     EHCI_REG_FRLSTSZ_256        (0x10 << 2)
        #define     EHCI_FRLSTSZ_256        (256)
    #define     EHCI_REG_FRLSTSZ_RSVD       (0x11 << 2)
// Periodic Schedule Enable - R/W
#define     EHCI_REG_PSEN_MSK           (0x01 << 4)
    #define     EHCI_REG_PSEN_DISABLE       (0x00 << 4)
    #define     EHCI_REG_PSEN_ENABLE        (0x01 << 4)
// Asynchronous Schedule Enable - R/W
#define     EHCI_REG_ASEN_MSK           (0x01 << 5)
    #define     EHCI_REG_ASEN_DISABLE       (0x00 << 5)
    #define     EHCI_REG_ASEN_ENABLE        (0x01 << 5)
// Interrupt on Async Advance Doorbell - R/W
#define     EHCI_REG_INTDBELL_MSK       (0x01 << 6)
    #define     EHCI_REG_INTDBELL_RING      (0x01 << 6)
// Light Host Controller Reset (OPTIONAL) - R/W									AG903 ɂ́A݂ȂB
#define     EHCI_REG_LHCRST_MSK         (0x01 << 7)
    #define     EHCI_REG_LHCRST_RESET       (0x01 << 7)
    #define     EHCI_REG_LHCRST_RCMP        (0x00 << 7)							// Reset  HC Zbg
// Asynchronous Schedule Park Mode Count (OPTIONAL) - RO or R/W
#define     EHCI_REG_ASPARKCNT_MSK      (0x03 << 8)
    #define     EHCI_REG_ASPARKCNT_1        (0x01 << 8)
    #define     EHCI_REG_ASPARKCNT_2        (0x02 << 8)
    #define     EHCI_REG_ASPARKCNT_3        (0x03 << 8)
// Asynchronous Schedule Park Mode Enable (OPTIONAL) - RO or R/W
#define     EHCI_REG_ASPARKEN_MSK       (0x01 << 11)
    #define     EHCI_REG_ASPARKEN_ENABLE    (0x01 << 11)
    #define     EHCI_REG_ASPARKEN_DISABLE   (0x00 << 11)
// Interrupt Threshold Control - R/W
#define     EHCI_REG_INTTHCTL_MSK       (0xFF << 16)
#define         EHCI_REG_INTTHCTL_RSVD      (0x00 << 16)
#define         EHCI_REG_INTTHCTL_1mf       (0x01 << 16)
#define         EHCI_REG_INTTHCTL_2mf       (0x02 << 16)
#define         EHCI_REG_INTTHCTL_4mf       (0x04 << 16)
#define         EHCI_REG_INTTHCTL_8mf       (0x08 << 16)						// ftHgB傤 1msB
#define         EHCI_REG_INTTHCTL_16mf      (0x10 << 16)
#define         EHCI_REG_INTTHCTL_32mf      (0x20 << 16)
#define         EHCI_REG_INTTHCTL_64mf      (0x40 << 16)


//------------------------------------------------------------------------------
// USBSTS - USB Status Register
//   Address:        Operational Base+(04h)
//   Default Value:  00001000h
//   Size            32bits
//
//------------------------------------------------------------------------------
// USB Interrupt (USBINT) - R/WC
#define     EHCI_REG_USBINT_MSK         (0x01 << 0)
    #define     EHCI_REG_USBINT_ASTD        (0x01 << 0)
    #define     EHCI_REG_USBINT_NASTD       (0x00 << 0)
    #define     EHCI_REG_USBINT_CLR         (0x01 << 0)
// USB Error Interrupt (USBERRINT) - R/WC
#define     EHCI_REG_USBERRINT_MSK      (0x01 << 1)
    #define     EHCI_REG_USBERRINT_ASTD     (0x01 << 1)
    #define     EHCI_REG_USBERRINT_NASTD    (0x00 << 1)
    #define     EHCI_REG_USBERRINT_CLR      (0x01 << 1)
// Port Change Detect - R/WC
#define     EHCI_REG_PORTCDTCT_MSK      (0x01 << 2)
    #define     EHCI_REG_PORTCDTCT_ASTD     (0x01 << 2)
    #define     EHCI_REG_PORTCDTCT_NASTD    (0x00 << 2)
    #define     EHCI_REG_PORTCDTCT_CLR      (0x01 << 2)
// Flame List Rollover - R/WC
#define     EHCI_REG_FRLSTROVR_MSK      (0x01 << 3)
    #define     EHCI_REG_FRLSTROVR_ASTD     (0x01 << 3)
    #define     EHCI_REG_FRLSTROVR_NASTD    (0x00 << 3)
    #define     EHCI_REG_FRLSTROVR_CLR      (0x01 << 3)
// Host System Error - R/WC
#define     EHCI_REG_HSERR_MSK          (0x01 << 4)
    #define     EHCI_REG_HSERR_ASTD         (0x01 << 4)
    #define     EHCI_REG_HSERR_NASTD        (0x00 << 4)
    #define     EHCI_REG_HSERR_CLR          (0x01 << 4)
// Interrupt on Async Advance - R/WC
#define     EHCI_REG_INTONAA_MSK        (0x01 << 5)
    #define     EHCI_REG_INTONAA_ASTD       (0x01 << 5)
    #define     EHCI_REG_INTONAA_NASTD      (0x00 << 5)
    #define     EHCI_REG_INTONAA_CLR        (0x01 << 5)
// HCHalted - RO
#define     EHCI_REG_HCHALTED_MSK       (0x01 << 12)
    #define     EHCI_REG_HCHALTED_HALTED    (0x01 << 12)
    #define     EHCI_REG_HCHALTED_NONHALTED (0x00 << 12)
// Reclamation - RO
#define     EHCI_REG_RECLAM_MSK         (0x01 << 13)
    #define     EHCI_REG_RECLAM_DTCT        (0x01 << 13)
    #define     EHCI_REG_RECLAM_NDTCT       (0x00 << 13)
// Periodic Schedule Status - RO
#define     EHCI_REG_PSSTAT_MSK         (0x01 << 14)
    #define     EHCI_REG_PSSTAT_ENABLE      (0x01 << 14)
    #define     EHCI_REG_PSSTAT_DISABLE     (0x00 << 14)
// Asynchronous Schedule Status - RO
#define     EHCI_REG_ASSTAT_MSK         (0x01 << 15)
    #define     EHCI_REG_ASSTAT_ENABLE      (0x01 << 15)
    #define     EHCI_REG_ASSTAT_DISABLE     (0x00 << 15)


//------------------------------------------------------------------------------
// USBINTR - USB Interrupt Enable Register
//   Address:        Operational Base+(08h)
//   Default Value:  00000000h
//   Size            32bits
//
//------------------------------------------------------------------------------
// USB Interrupt Enable
#define     EHCI_REG_INTEN_MSK          (0x01 << 0)
    #define     EHCI_REG_INTEN_ENABLE       (0x01 << 0)
    #define     EHCI_REG_INTEN_DISABLE      (0x00 << 0)
// USB Error Interrupt Enable
#define     EHCI_REG_ERRINTEN_MSK       (0x01 << 1)
    #define     EHCI_REG_ERRINTEN_ENABLE    (0x01 << 1)
    #define     EHCI_REG_ERRINTEN_DISABLE   (0x00 << 1)
// Port Change Interrupt Enable
#define     EHCI_REG_PORTCINTEN_MSK     (0x01 << 2)
    #define     EHCI_REG_PORTCINTEN_ENABLE  (0x01 << 2)
    #define     EHCI_REG_PORTCINTEN_DISABLE (0x00 << 2)
// Frame List Rollover Enable
#define     EHCI_REG_FRLSTROVEREN_MSK   (0x01 << 3)
    #define     EHCI_REG_FRLSTROVEREN_ENABLE    (0x01 << 3)
    #define     EHCI_REG_FRLSTROVEREN_DISABLE   (0x00 << 3)
// Host System Error Enable
#define     EHCI_REG_HSERREN_MSK        (0x01 << 4)
    #define     EHCI_REG_HSERREN_ENABLE     (0x01 << 4)
    #define     EHCI_REG_HSERREN_DISABLE    (0x00 << 4)
// Bit[31:6] are reserved.


//------------------------------------------------------------------------------
// FRINDEX - Frame Index Register
//   Address:        Operational Base+(0Ch)
//   Default Value:  00000000h
//   Size            32bits
//
//------------------------------------------------------------------------------
// Frame Index
#define     EHCI_REG_FRINDEX_MSK        (0x3FFF << 0)


//------------------------------------------------------------------------------
// CTRLDSSEGMENT - Control Data Structure Segment Register						AG903 ɂ́A݂ȂB
//   Address:        Operational Base+(10h)
//   Default Value:  00000000h
//   Size            32bits
//
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// PERIODICLISTBASE - Periodic Frame List Base Address Register
//   Address:        Operational Base+(14h)
//   Default Value:  Undefined
//   Size            32bits
//
//------------------------------------------------------------------------------
// Bit[11:0] are reserved.
// Base Address (Low)
#define     EHCI_REG_PLBASEADDR_MSK     (0xFFFFF << 12)


//------------------------------------------------------------------------------
// ASYNCLISTADDR - Current Asynchronous List Address Register
//   Address:        Operational Base+(18h)
//   Default Value:  Undefined
//   Size            32bits
//
//------------------------------------------------------------------------------
// Link Pointer Low (LPL)
#define     EHCI_REG_LPL_MSK            (0x7FFFFFF << 5)


//------------------------------------------------------------------------------
// CONFIGFLAG - Configure Flag Register
//   Address:        Operational Base+(40h)
//   Default Value:  Undefined
//   Size            32bits
//
//------------------------------------------------------------------------------
// Bit[31:1] are reserved.
// Configure Flag(CF) - R/W														AG903 ɂ́A݂ȂB
#define     EHCI_REG_CFGFLG_MSK         (0x01 << 0)
    #define     EHCI_REG_CFGFLG_CLASSIC         (0x00 << 0)
    #define     EHCI_REG_CFGFLG_MINE            (0x01 << 0)



//------------------------------------------------------------------------------
// PORTSC - Port Status and Control Register
//   Address:        Operational Base+(44h + (4*(PortNUmber-1)))
//   Default Value:  Undefined
//   Size            32bits
//
//------------------------------------------------------------------------------
// Current Connect Status - RO
#define     EHCI_REG_CCNTSTAT_MSK       (0x01 << 0)
    #define     EHCI_REG_CCNTSTAT_CNT       (0x01 << 0)
    #define     EHCI_REG_CCNTSTAT_NCNT      (0x00 << 0)
// Connect Status Change - R/WC
#define     EHCI_REG_CNTSTATC_MSK       (0x01 << 1)
    #define     EHCI_REG_CNTSTATC_CHG       (0x01 << 1)
    #define     EHCI_REG_CNTSTATC_NCHG      (0x00 << 1)
    #define     EHCI_REG_CNTSTATC_CLR       (0x01 << 1)
// Port Enabled/Disabled - R/W
#define     EHCI_REG_PORTEN_MSK         (0x01 << 2)
    #define     EHCI_REG_PORTEN_ENABLE      (0x01 << 2)
    #define     EHCI_REG_PORTEN_DISABLE     (0x00 << 2)
// Port Enable/Disable Change - R/WC
#define     EHCI_REG_PORTENC_MSK        (0x01 << 3)
    #define     EHCI_REG_PORTENC_CHG        (0x01 << 3)
    #define     EHCI_REG_PORTENC_NCHG       (0x00 << 3)
    #define     EHCI_REG_PORTENC_CLR        (0x01 << 3)
// Over-current Active - RO														AG903 ɂ́A݂ȂB
#define     EHCI_REG_OCRNTACT_MSK       (0x01 << 4)
    #define     EHCI_REG_OCRNTACT_OVER      (0x01 << 4)
    #define     EHCI_REG_OCRNTACT_NOVER     (0x00 << 4)
// Over-current Change - R/WC													AG903 ɂ́A݂ȂB
#define     EHCI_REG_OCRNTACTC_MSK      (0x01 << 5)
    #define     EHCI_REG_OCRNTACTC_CHG      (0x01 << 5)
    #define     EHCI_REG_OCRNTACTC_NCHG     (0x00 << 5)
    #define     EHCI_REG_OCRNTACTC_CLR      (0x01 << 5)
// Force Port Resume - R/W
#define     EHCI_REG_PORTRESM_MSK       (0x01 << 6)
    #define     EHCI_REG_PORTRESM_DTCD      (0x01 << 6)
    #define     EHCI_REG_PORTRESM_NDTCD     (0x00 << 6)
// Suspend - R/W
#define     EHCI_REG_SUSPEND_MSK        (0x01 << 7)
    #define     EHCI_REG_SUSPEND_SUSPEND    (0x01 << 7)
    #define     EHCI_REG_SUSPEND_NOTSUSPEND (0x00 << 7)
// Port Reset - R/W
#define     EHCI_REG_PORTRST_MSK        (0x01 << 8)
    #define     EHCI_REG_PORTRST_INRST      (0x01 << 8)
    #define     EHCI_REG_PORTRST_NOTINRST   (0x00 << 8)
// Bit[9] is reserved.
// Line Status - RO
#define     EHCI_REG_LINESTAT_MSK       (0x03 << 10)
    #define     EHCI_REG_LINESTAT_SE0       (0x00 << 10)
    #define     EHCI_REG_LINESTAT_J         (0x02 << 10)
    #define     EHCI_REG_LINESTAT_K         (0x01 << 10)
// Port Power (PP) - R/W or RO													AG903 ɂ́A݂ȂB
#define     EHCI_REG_PORTPWR_MSK        (0x01 << 12)
    #define     EHCI_REG_PORTPWR_ON         (0x01 << 12)
    #define     EHCI_REG_PORTPWR_OFF        (0x00 << 12)
// Port Owner - R/W																AG903 ɂ́A݂ȂB
#define     EHCI_REG_PORTOWN_MSK        (0x01 << 13)
    #define     EHCI_REG_PORTOWN_COMP       (0x01 << 13)
    #define     EHCI_REG_PORTOWN_SELF       (0x00 << 13)
// Port Indicator Control														AG903 ɂ́A݂ȂB
#define     EHCI_REG_PORTINDC_SHFT      (14)
#define     EHCI_REG_PORTINDC_MSK       (0x03 << 14)
    #define     EHCI_REG_PORTINDC_OFF       (0x00 << 14)
    #define     EHCI_REG_PORTINDC_AMB       (0x01 << 14)
    #define     EHCI_REG_PORTINDC_GRN       (0x02 << 14)
// Port Test Control - R/W
#define     EHCI_REG_PORTTSTC_SHFT      (16)
#define     EHCI_REG_PORTTSTC_MSK       (0x0F << 16)
    #define     EHCI_REG_PORTTSTC_DIS       (0x00 << 16)
    #define     EHCI_REG_PORTTSTC_J         (0x01 << 16)
    #define     EHCI_REG_PORTTSTC_K         (0x02 << 16)
    #define     EHCI_REG_PORTTSTC_SE0       (0x03 << 16)
    #define     EHCI_REG_PORTTSTC_PKT       (0x04 << 16)
    #define     EHCI_REG_PORTTSTC_FEN       (0x05 << 16)
// Wake on Connect Enable (WKCNNT_E) - R/W
#define     EHCI_REG_WKCNNTEN_MSK       (0x01 << 20)
    #define     EHCI_REG_WKCNNTEN_ENABLE    (0x01 << 20)
    #define     EHCI_REG_WKCNNTEN_DISABLE   (0x00 << 20)
// Wake on Disconnect Enable (WKDSCNNT_E) - R/W									AG903 ɂ́A݂ȂB
#define     EHCI_REG_WKDCNNTEN_MSK      (0x01 << 21)
    #define     EHCI_REG_WKDCNNTEN_ENABLE   (0x01 << 21)
    #define     EHCI_REG_WKDCNNTEN_DISABLE  (0x00 << 21)
// Wake on Over-current Enable (WKOC_E) - R/W									AG903 ɂ́A݂ȂB
#define     EHCI_REG_WKOCEN_MSK         (0x01 << 22)
    #define     EHCI_REG_WKOCEN_ENABLE      (0x01 << 22)
    #define     EHCI_REG_WKOCEN_DISABLE     (0x00 << 22)
// Bit[31:23] are reserved.


#endif		//	__HCD_EHCI_H__

