/** 
 * @brief           Open USBDI Header
 * @author          AXELL CORPORATION
 * @description     OpenUSBDIWwb_B
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */




#ifndef __OPEN_USBDI_H__
#define __OPEN_USBDI_H__
/* DOM-IGNORE-END */

#define OPEN_USBDI_VERSION          0x0+100

#if OPEN_USBDI_VERSION == 0x0+100

// *************************************************************************************************
//	define
// *************************************************************************************************
#define USB_DESC_TYPE_DEVICE                    0x01
#define USB_DESC_TYPE_CONFIG                    0x02
#define USB_DESC_TYPE_STRING                    0x03
#define USB_DESC_TYPE_INTFC                     0x04
#define USB_DESC_TYPE_EDPT                      0x05


/*
 * Unless otherwise specified, the following abbreviations will be used:
 *
 *  ldd     - logical-device driver
 *  cb      - Control Block
 *  _call   - Callback Function
 *  n_      - Number of ...
 *  _t      - Type
 *  ops     - UDI channel operation vectors
 *  xfer    - transfer
 *  edpt    - endpoint
 *  intfc   - interface
 *  desc    - descriptor
 *  config  - configuration
 */

/*
 * The following structs and defines are based on the USB
 * core spec, rev 1.1
 */


typedef struct _usb_device_request_t{       // __st__
    udi_ubit8_t bmRequestType;          /* Characteristics of request */
#define USB_DEVICE_REEQUEST_TYPE_DIR_MASK           (0x01 << 7)
#define USB_DEVICE_REEQUEST_TYPE_TYPE_MASK          (0x03 << 5)
#define USB_DEVICE_REEQUEST_TYPE_RECIP_MASK         (0x0f << 0)

#define USB_DEVICE_REQUEST_TYPE_DEVICE_RECIPIENT    0x00
#define USB_DEVICE_REQUEST_TYPE_INTERFACE_RECIPIENT 0x01
#define USB_DEVICE_REQUEST_TYPE_ENDPOINT_RECIPIENT  0x02
#define USB_DEVICE_REQUEST_TYPE_OTHER_RECIPIENT     0x03
#define USB_DEVICE_REQUEST_TYPE_STANDARD_TYPE       0x00
#define USB_DEVICE_REQUEST_TYPE_CLASS_TYPE          0x20
#define USB_DEVICE_REQUEST_TYPE_VENDOR_TYPE         0x40
#define USB_DEVICE_REQUEST_TYPE_HOST_TO_DEVICE      0x00
#define USB_DEVICE_REQUEST_TYPE_DEVICE_TO_HOST      0x80
    udi_ubit8_t bRequest;               /* Specific request */
#define USB_DEVICE_REQUEST_GET_STATUS               0
#define USB_DEVICE_REQUEST_CLEAR_FEATURE            1
#define USB_DEVICE_REQUEST_GET_STATE                2       /* Reserved for future use?*/
#define USB_DEVICE_REQUEST_SET_FEATURE              3
#define USB_DEVICE_REQUEST_SET_ADDRESS              5
#define USB_DEVICE_REQUEST_GET_DESCRIPTOR           6
#define USB_DEVICE_REQUEST_SET_DESCRIPTOR           7
#define USB_DEVICE_REQUEST_GET_CONFIGURATION        8
#define USB_DEVICE_REQUEST_SET_CONFIGURATION        9
#define USB_DEVICE_REQUEST_GET_INTERFACE            10
#define USB_DEVICE_REQUEST_SET_INTERFACE            11
#define USB_DEVICE_REQUEST_SYNCH_FRAME              12
    udi_ubit8_t wValue0;
    udi_ubit8_t wValue1;                /* Word-sized field that varies
                                         * according to request
                                         */
#define USB_DEVICE_REQUEST_DEVICE_REMOTE_WAKEUP     1
#define USB_DEVICE_REQUEST_ENDPOINT_HALT            0
#define USB_DEVICE_REQUEST_TEST_MODE                2
    udi_ubit8_t wIndex0;
    udi_ubit8_t wIndex1;                /* Word sized field that varies according to
                                         * request; typically used to pass an index
                                         * or offset
                                         */
    udi_ubit8_t wLength0;
    udi_ubit8_t wLength1;               /* Number of bytes to transfer if there is a
                                         * data phase
                                         */
} usb_device_request_t;

/*
 * Descriptor Types
 */
#define USB_DESCRIPTOR_TYPE_DEVICE                  0x01
#define USB_DESCRIPTOR_TYPE_CONFIGURATION           0x02
#define USB_DESCRIPTOR_TYPE_STRING                  0x03
#define USB_DESCRIPTOR_TYPE_INTERFACE               0x04
#define USB_DESCRIPTOR_TYPE_ENDPOINT                0x05
/** ǉ`BOpen USBDI1.0 ɂ͂Ȃ */
#define USB_DESCRIPTOR_TYPE_DEVICE_QUALIFIER        0x06
/** ǉ`BOpen USBDI1.0 ɂ͂Ȃ */
#define USB_DESCRIPTOR_TYPE_OTHER_SPEED_CONFIGURATION 0x07

/** foCXEfBXNv^p\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usb_device_descriptor {
    udi_ubit8_t bLength;                /** Numeric expression specifying the size of
                                         this descriptor */
    udi_ubit8_t bDescriptorType;        /** Device descriptor type (assigned by USB) */
    udi_ubit8_t bcdUSB0;                /** binary-coded decimal specification # */
    udi_ubit8_t bcdUSB1;                /** binary-coded decimal specification # */

    udi_ubit8_t bDeviceClass;           /** Class code (assigned by USB). Note that
                                         the HID class is defined in the Interface
                                         descriptor */
    udi_ubit8_t bDeviceSubClass;        /** Subclass code (assigned by USB). These
                                         codes are qualified by the value of the
                                         DeviceClass field. */
    udi_ubit8_t bDeviceProtocol;        /** Protocol code. These codes are qualified
                                         by the value of the DeviceSubClass field. */
    udi_ubit8_t bMaxPacketSize;         /** Maximum packet size for endpoint zero (only
                                         8, 16, 32, or 4 are valid). */
    udi_ubit8_t idVendor0;              /** Vendor ID (assigned by USB) */
    udi_ubit8_t idVendor1;              /** Vendor ID (assigned by USB) */

    udi_ubit8_t idProduct0;             /** Product ID (assigned by manufacturer) */
    udi_ubit8_t idProduct1;             /** Product ID (assigned by manufacturer) */

    udi_ubit8_t bcdDevice0;             /** Device release number */
    udi_ubit8_t bcdDevice1;             /** Device release number */

    udi_ubit8_t iManufacturer;          /** Index of String desc describing manufacture */
    udi_ubit8_t iProduct;               /** Index of string desc describing product */
    udi_ubit8_t iSerialNumber;          /** Index of String desc describing serial # */
    udi_ubit8_t bNumConfigurations;     /** Number of possible configurations */
};


// ǉ`BOpenUSBDI 1.0 ɂ͖{fBXNv^̒`͂ȂB
struct usb_device_qualifier_descriptor {    // __st__
    udi_ubit8_t bLength;
    udi_ubit8_t bDescriptorType;
    udi_ubit8_t bcdUSB0;
    udi_ubit8_t bcdUSB1;
    udi_ubit8_t bDeviceClass;
    udi_ubit8_t bDeviceSubClass;
    udi_ubit8_t bDeviceProtocol;
    udi_ubit8_t bMaxPacketSize;
    udi_ubit8_t bNumConfigurations;
    udi_ubit8_t bReserved;
};

/** RtBO[VEfBXNv^p\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usb_configuration_descriptor {
    udi_ubit8_t bLength;                /** Size of this descriptor in bytes */
    udi_ubit8_t bDescriptorType;        /** Configuration (assigned by USB) */
    udi_ubit8_t wTotalLength0;          /** Total length of data returned for this
                                         configuration. Includes the combined
                                         length of all returned descriptors
                                         (configuration, interface, endpoint, and
                                         HID) returned for this configuration. This
                                         value includes the HID descriptor but none
                                         of the other HID class descriptors (report
                                         or designator). */
    udi_ubit8_t wTotalLength1;          /** Total length of data returned for this
                                         configuration. Includes the combined
                                         length of all returned descriptors
                                         (configuration, interface, endpoint, and
                                         HID) returned for this configuration. This
                                         value includes the HID descriptor but none
                                         of the other HID class descriptors (report
                                         or designator). */
    udi_ubit8_t bNumInterfaces;         /** Number of interfaces supported by this
                                         configuration. */
    udi_ubit8_t bConfigurationValue;    /** Value to use as an argument to Set
                                         Configuration to select this configuration */
    udi_ubit8_t iConfiguration;         /** Index of string descriptor describing this
                                         configuration. */
    udi_ubit8_t bmAttributes;           /** Configuration characteristics */
#define USB_CONFIG_BUS_POWERED                  0x80
#define USB_CONFIG_SELF_POWERED                 0x40
#define USB_CONFIG_REMOTE_WAKEUP                0x20
    udi_ubit8_t MaxPower;               /** Maximum power consumption of USB device
                                         from bus in this specific configuration
                                         when the device is fully operational.
                                         Expressed in 2mA units -- for example,
                                         50 = 100mA. */
};


// ǉ`BOpenUSBDI 1.0 ɂ͖{fBXNv^̒`͂ȂB
struct usb_other_speed_configuration_descriptor {   // __st__
    udi_ubit8_t bLength;
    udi_ubit8_t bDescriptorType;
    udi_ubit8_t wTotalLength0;
    udi_ubit8_t wTotalLength1;
    udi_ubit8_t bNumInterfaces;
    udi_ubit8_t bConfigurationValue;
    udi_ubit8_t iConfiguration;
    udi_ubit8_t bmAttributes;
    udi_ubit8_t MaxPower;
};

/** C^tF[XEfBXNv^p\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usb_interface_descriptor {
    udi_ubit8_t bLength;                /** Size of this descriptor in bytes */
    udi_ubit8_t bDescriptorType;        /** Interface descriptor type */
    udi_ubit8_t bInterfaceNumber;       /** Number of interface. Zero-based value
                                         identifying the index in the array of
                                         concurrent interfaces supported by this
                                         configuration */
    udi_ubit8_t bAlternateSetting;      /** Value used to select alternate setting
                                         for the interface identified in the prior
                                         field. */
    udi_ubit8_t bNumEndpoints;          /** Number of endpoints used by this interface
                                         (excluding endpoint zero). If this value
                                         is zero, this interface only uses endpoint
                                         zero. */
    udi_ubit8_t bInterfaceClass;        /** Class code */
    udi_ubit8_t bInterfaceSubClass;     /** Subclass code */
#define USB_INTERFACE_SUBCLASS_NO_SUBCLASS      0x00
#define USB_INTERFACE_SUBCLASS_BOOT_INTERFACE   0x01
    udi_ubit8_t bInterfaceProtocol;     /** Protocol code */
#define USB_INTERFACE_PROTOCOL_NONE             0x00
    udi_ubit8_t iInterface;             /** Index of string descriptor describing this
                                         interface */
};

/** Gh|CgEfBXNv^p\<p>
    ^C~O F foCXڑ<p>
    폜^C~O F foCXؒf */
struct usb_endpoint_descriptor {
    udi_ubit8_t bLength;                /** Size of this descriptor in bytes */
    udi_ubit8_t bDescriptorType;        /** Endpoint descriptor type (assigned by USB)*/
    udi_ubit8_t bEndpointAddress;       /** The address of the endpoint on the USB
                                         device described by this descriptor. The
                                         address is encoded as follows:
                                         Bit 0..3 The endpoint number
                                         Bit 4..6 Reserved, reset to zero
                                         Bit 7 Direction, ignored for Control
                                         endpoints: 0 - OUT endpoint,
                                         1 - IN endpoint */
#define USB_ENDPOINT_DIR_MASK                   (1 << 7)
#define USB_ENDPOINT_DIR_OUT                    (0 << 7)
#define USB_ENDPOINT_DIR_IN                     (1 << 7)
#define USB_ENDPOINT_NUM_MASK                   (0x0f)
    udi_ubit8_t bmAttributes;           /** This field describes the endpoint's
                                         attributes when it is configured using the
                                         Configuration Value.
                                         Bit 0..1 Transfer type:
                                         00 Control
                                         01 Isochronous
                                         10 Bulk
                                         11 Interrupt
                                         All other bits are reserved */
#define USB_ENDPOINT_CONTROL                    0
#define USB_ENDPOINT_ISOCHRONOUS                1
#define USB_ENDPOINT_BULK                       2
#define USB_ENDPOINT_INTERRUPT                  3
#define USB_ENDPOINT_ATTRIBUTE_MASK             3
#define USB_ENDPOINT_ANYTHING                   0xff
    udi_ubit8_t bMaxPacketSize_lo;      /** Maximum packet size this endpoint is
                                         capable of sending or receiving when this
                                         configuration is selected. For interrupt
                                         endpoints, this value is used to reserve
                                         the bus time in the schedule, required for
                                         the per frame data payloads. Smaller data
                                         payloads may be sent, but will terminate
                                         the transfer and thus require intervention
                                         to restart. */
    udi_ubit8_t bMaxPacketSize_hi;      /** Maximum packet size this endpoint is
                                         capable of sending or receiving when this
                                         configuration is selected. For interrupt
                                         endpoints, this value is used to reserve
                                         the bus time in the schedule, required for
                                         the per frame data payloads. Smaller data
                                         payloads may be sent, but will terminate
                                         the transfer and thus require intervention
                                         to restart. */
    udi_ubit8_t bInterval;              /** Interval for polling endpoint for data
                                         transfers. Expressed in milliseconds. */
};

struct usb_string_descriptor {
    udi_ubit8_t Length;                 /* Length of descriptor in bytes */
    udi_ubit8_t DescriptorType;         /* Descriptor Type */
    udi_ubit8_t String[1];
};

/*
* USBDI Status Return Values
*/
#define USBDI_STAT_NOT_ENOUGH_BANDWIDTH         (UDI_STAT_META_SPECIFIC|1)
#define USBDI_STAT_STALL                        (UDI_STAT_META_SPECIFIC|2)

// Base Class Code definition
                                                    // Descriptor(Device, Interface or Both)
#define USBDI_BASECLASS_DEVICE          (0x00U)     // Device
#define USBDI_BASECLASS_AUDIO           (0x01U)     // Interface
#define USBDI_BASECLASS_CDC             (0x02U)     // Both
#define USBDI_BASECLASS_HID             (0x03U)     // Interface
#define USBDI_BASECLASS_PHYSICAL        (0x05U)     // Interface
#define USBDI_BASECLASS_IMAGE           (0x06U)     // Interface
#define USBDI_BASECLASS_PRINTER         (0x07U)     // Interface
#define USBDI_BASECLASS_MASSSTOR        (0x08U)     // Interface
#define USBDI_BASECLASS_HUB             (0x09U)     // Device
#define USBDI_BASECLASS_CDCDATA         (0x0aU)     // Interface
#define USBDI_BASECLASS_SCARD           (0x0bU)     // Interface
#define USBDI_BASECLASS_CSECURITY       (0x0dU)     // Interface
#define USBDI_BASECLASS_VIDEO           (0x0eU)     // Interface
#define USBDI_BASECLASS_DIAGDEV         (0xdcU)     // Both
#define USBDI_BASECLASS_WCTLR           (0xe0U)     // Interface
#define USBDI_BASECLASS_MISC            (0xefU)     // Both
#define USBDI_BASECLASS_APPSPEC         (0xfeU)     // Interface
#define USBDI_BASECLASS_VNDRSPEC        (0xffU)     // Both


// Sub Class Code & Protocol definition
#define USBDI_SUBCLASS_NULL             (0x00U)
#define USBDI_PROTOCOL_NULL             (0x00U)

// Hub
#define USBDI_SUBCLASS_HUB              (0x00U)
#define USBDI_PROTOCOL_HUB_FS           (0x00U)
#define USBDI_PROTOCOL_HUB_HS_STT       (0x01U)
#define USBDI_PROTOCOL_HUB_HS_MTT       (0x02U)


#endif /* OPEN_USBDI_VERSION */


#endif /* __OPEN_USBDI_H__ */
