/** 
 * @brief           USB HOST errormon Header
 * @author          AXELL CORPORATION
 * @description     USB HOST Xe[^Xj^wb_B
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */



#ifndef __USBH_ERRORMON_H__
#define __USBH_ERRORMON_H__
/* DOM-IGNORE-END */

// *************************************************************************************************
//	include
// *************************************************************************************************
#include "uhs_configtop.h"
#include "usbh_api.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
#define CORE_EXTDATA_MAXLENGTH 						(256)
#define HCD_EXTDATA_MAXLENGTH 						(256)
#define HUB_EXTDATA_MAXLENGTH 						(256)



#ifdef		USBH_STACK_DEBUG_BUILD

	//	for Debug_Build

	//	STATUSj^p	iCOREj
	#define CORE_REPORT_ERROR( msgdata )						Usb_Core_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_ERROR, (msgdata) )
	#define CORE_REPORT_MILESTONE( msgdata )					Usb_Core_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_MILESTONE, (msgdata) )
	#define CORE_REPORT_WARNING( msgdata )						Usb_Core_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_WARNING, (msgdata) )

	//	STATUSj^p	iHCD,EHCIj
	#define HCD_REPORT_ERROR( msgdata )							Hcd_EHCI_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_ERROR, (msgdata) )
	#define HCD_REPORT_MILESTONE( msgdata )						Hcd_EHCI_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_MILESTONE, (msgdata) )
	#define HCD_REPORT_WARNING( msgdata )						Hcd_EHCI_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_WARNING, (msgdata) )

	//	STATUSj^p	iHUBj
	#define HUB_REPORT_ERROR( msgdata, port_num  )				Usb_Hub_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_ERROR, (msgdata), (port_num) , 0 )
	#define HUB_REPORT_MILESTONE( msgdata, port_num , hub_adr )	Usb_Hub_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_MILESTONE, (msgdata), (port_num) , (hub_adr) )
	#define HUB_REPORT_WARNING( msgdata, port_num )				Usb_Hub_ReportStatus( __FILENAME__, __LINENUM__, USB_MSGMON_MSGLVL_WARNING, (msgdata), (port_num) , 0 )

#else

	//	for Release_Build	(MILESTONEɂẮAʂŔ\̈גʒmB܂HUBڑNGj

	//	STATUSj^p	iCOREj
	#define CORE_REPORT_ERROR( msgdata )
	#define CORE_REPORT_MILESTONE( msgdata )					Usb_Core_ReportStatus( "----" , 0 , USB_MSGMON_MSGLVL_MILESTONE, (msgdata) )
	#define CORE_REPORT_WARNING( msgdata )	

	//	STATUSj^p	iHCD,EHCIj
	#define HCD_REPORT_ERROR( msgdata )
	#define HCD_REPORT_MILESTONE( msgdata )						Hcd_EHCI_ReportStatus( "----" , 0 , USB_MSGMON_MSGLVL_MILESTONE, (msgdata) )
	#define HCD_REPORT_WARNING( msgdata )

	//	STATUSj^p	iHUBj
	#define HUB_REPORT_ERROR( msgdata, port_num )
	#define HUB_REPORT_MILESTONE( msgdata,port_num,hub_adr )	Usb_Hub_ReportStatus( "----", 0 , USB_MSGMON_MSGLVL_MILESTONE, msgdata, (port_num) , (hub_adr) )
	#define HUB_REPORT_WARNING( msgdata, port_num )	

#endif	//	USBH_STACK_DEBUG_BUILD

// *************************************************************************************************
//	extern
// *************************************************************************************************
extern uhs_status_t Usbh_StatusMon_Init( usb_logtype logtype );
extern uhs_status_t Usbh_StatusMon_Exit( void );
extern void Usbh_RegistGetStatusCallback( usb_common_callback_t stsmon_callback );
extern void         Usbh_StatusMon_Task( void* context );
extern uhs_status_t Usbh_StatusMon_ReportStatus( usb_msgformat stsmsg );
extern uhs_status_t Usbh_StatusMon_Callback( usb_msgformat * stsmsg );
extern void         Usbh_StatusMon_ConvertSimpleMsg( usb_msgformat * stsmsg, usb_simple_msgformat * simplemsg );
extern int           Usbh_StatusMon_getDecimalString( uhs_ubit32_t num, char* str );


#endif // __USBH_ERRORMON_H__


