/** 
 * @brief           HUB Class Driver Header
 * @author          AXELL CORPORATION
 * @description     HUB Class Driver֘Awb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
#ifndef __USBC_HUB_H__
#define __USBC_HUB_H__
/* DOM-IGNORE-END */

// *************************************************************************************************
//	include
// *************************************************************************************************


// *************************************************************************************************
//	define
// *************************************************************************************************
/** hCoFW[o[W */
#define HUB_MAJOR_VERSION				(0x01)
/** hCoF}Ci[o[W */
#define HUB_MINOR_VERSION				(0x00)


/** OVERCURRENTCALLBACKĂяo<p>
		OVERCURRENTCONNECTXe[^Xω̏ꍇ1ɐݒ肷B<p>
	0 = OVERCURRENToŁAf^b`̌ĂяoȂB(CONNXe[^Xŏ)<p>
	1 = OVERCURRENToŁAf^b`̌ĂяoB */
#define	HUB_OVRCUR_CALLBACK				(1)

/** nu̍ő|[g<p>
	{hCoł7ȉɑΉB*/
#define HUB_MAX_PORT_NUM				(7)

//----------------------------------------------------------------------------
// nutB[`[ZN^[Y
//----------------------------------------------------------------------------

// nuMp
/** [Jp[ */
#define C_HUB_LOCAL_POWER				(0)
/** I[o[Jg */
#define C_HUB_OVER_CURRENT				(1)

// |[gMp
/** foCX݂邩 */
#define PORT_CONNECTION					(0)
/** |[g삷邩 */
#define PORT_ENABLE						(1)
/** |[gSuspendԂł邩 */
#define PORT_SUSPEND					(2)
/** ߓd݂Ȃ */
#define PORT_OVER_CURRENT				(3)
/** nu|[gփZbgMoĂ邩 */
#define PORT_RESET						(4)
/** |[gdԂł邩 */
#define PORT_POWER						(8)
/** ڑꂽfoCXLow Speed */
#define PORT_LOW_SPEED					(9)
/** ڑXe[^Xω */
#define C_PORT_CONNECTION				(16)
/** |[gG[݂邩 */
#define C_PORT_ENABLE					(17)
/** W[M */
#define C_PORT_SUSPEND					(18)
/** ߓdω */
#define C_PORT_OVERCURRENT				(19)
/** Zbg */
#define C_PORT_RESET					(20)
/** |[g|[geXg[h */
#define PORT_TEST						(21)
/** |[gCWP[^̕\F\tgEFARg[ */
#define PORT_INDICATOR					(22)

/* nu^XN֘A */
#define HUB_TASK_STKSZ                  USB_CL_HUB_TASK_STKSZ
#define HUB_TASK_PRI                    USB_CL_HUB_TASK_PRI

/* nũNXID */
#define USB_HUB_CLASSID     			(9)

/* nuSinfleTT/MultiTT */
#define	USB_HUB_DEVPROTO_SINGLE			(1)
#define	USB_HUB_DEVPROTO_MULTI			(2)

/* nuNXNGXgR[h */
#define HUB_GET_STATUS_REQ          	USB_DEVICE_REQUEST_GET_STATUS
#define HUB_CLEAR_FEATURE_REQ       	USB_DEVICE_REQUEST_CLEAR_FEATURE
#define HUB_SET_FEATURE_REQ         	USB_DEVICE_REQUEST_SET_FEATURE
#define HUB_GET_DESCRIPTOR_REQ      	(6)
#define HUB_SET_DESCRIPTOR_REQ      	(7)

/* GET HUB DESCRIPTOR */
#define GET_HUB_DESCRIPTOR_REQTYPE      (0xA0)
#define GET_HUB_DESCRIPTOR_REQ          USB_DEVICE_REQUEST_GET_DESCRIPTOR
#define GET_HUB_DESCRIPTOR_VALUE        (HUB_DESCRIPTOR_TYPE << 8)
#define GET_HUB_DESCRIPTOR_INDEX        (0)


/* CLEAR HUB FEATURE / CLEAR PORT FEATURE */
#define CLEAR_HUB_FEATURE   			(0x20)
#define CLEAR_PORT_FEATURE  			(0x23)

/* SET HUB FEATURE / SET PORT FEATURE */
#define SET_HUB_FEATURE     			(0x20)
#define SET_PORT_FEATURE    			(0x23)

/* GET HUB STATUS / GET PORT STATUS */
#define GET_HUB_STATUS      			(0xA0)
#define GET_PORT_STATUS     			(0xA3)

//	CLEAR_TT_BUFFER
#define		CLEAR_TT_BUFFER_BMREQ		(0x23)									//	bmRequest
#define		CLEAR_TT_BUFFER_BREQ		(8)										//	bRequest

//	RESET_TT
#define		RESET_TT_BMREQ				(0x23)									//	bmRequest
#define		RESET_TT_BREQ				(9)										//	bRequest

//	GET_TT_STATE
#define		GET_TT_STATE_BMREQ			(0xA3)									//	bmRequest
#define		GET_TT_STATE_BREQ			(10)									//	bRequest

//	STOP_TT
#define		STOP_TT_BMREQ				(0x23)									//	bmRequest
#define		STOP_TT_BREQ				(11)									//	bRequest

//	CLR_TT_BUFFER wValuetB[hp
/** X--- ---- ---- ----      */
#define		USB_HUB_WVALUE_DIR_MSK		(0x8000)
/**	---X X--- ---- ----     EP */
#define		USB_HUB_WVALUE_EPKIND_MSK	(0x1800)
/** ---- -XXX XXXX ----		foCXAhX */
#define		USB_HUB_WVALUE_DEVADDR_MSK	(0x07F0)
/** ---- ---- ---- XXXX		EPԍ */
#define		USB_HUB_WVALUE_EPNUM_MSK	(0x000F)


/* Status Change Bitmapf[^fR[hp */
#define HUB_CHANGE_DETECT   			(0x01)
#define PORT_CHANGE_OFFSET  			(0x02)

/* ]֌W */
#define INTERRUPT_BUF_SIZE 				(1)
#define GET_STATUS_LENGTH 				(4)
#define DESC_LENGTH 					(8)

/* ^CAEg֌W */
/** PORT RESETs̃Zbg҂(ʏ10ms`20ms) */
#define USB_PORT_RESET_WAIT         	(20)
/** foCXڑFۂ̃`^O */
#define USB_DEVICE_CONNECT_WAIT     	(100)
/** oXZbg𔭍sĂA_EXg[ɑ΂郊Zbg̊܂ł̃EGCg */
#define BUS_RESET_TIMEOUT           	(10)
#define USB_HUB_ENDTASK_TIMEOUT     	(20000)
/** RetryBivClosej*/
#define USB_HUB_RETRY_CNT           	(1)
/** RetryLB */
#define USB_HUB_GETDESC_RETRY_CNT     	(3)

/* common */
#define ON  							(1)
#define OFF 							(0)
#define BYTE_MSB 						(0x80)
#define BYTE_LSB 						(0x01)

//------------------------------------------------------------------------------
//	HUB̍őڑ䐔(ROOT_HUB܂2i)
//	̑䐔ȏHUBڑNGƂB
//------------------------------------------------------------------------------
#define	HUB_CONN_MAXCNT					(USBH_MAX_CLS_ROOTHUB_NUM + USBH_MAX_CLS_HUB_NUM)

/** HUBXbhIv */
#define	USB_HUB_MSGKIND_EXITTHREAD		((void *)0)
/** HUB OverCurrentʒm */
#define	USB_HUB_MSGKIND_DETECTOVERCURR	((void *)1)

//------------------------------------------------------------------------------
//	Message ID (Notify / Request)
//------------------------------------------------------------------------------
/** vFHUB_ThreadIʒm */
#define		USBH_HUB_MESID_NOTIFY_THREAD_EXIT				(USBH_MSGID_KIND_HUB_THREAD | 0x00000000)
/** vFInterrupt_inʒm */
#define		USBH_HUB_MESID_NOTIFY_INTERRUPT_IN				(USBH_MSGID_KIND_HUB_THREAD | 0x00000001)
/** SUSPENDv */
#define		USBH_HUB_MESID_REQ_SUSPEND						(USBH_MSGID_KIND_HUB_THREAD | 0x00000002)
/** RESUMEv */
#define		USBH_HUB_MESID_REQ_RESUME						(USBH_MSGID_KIND_HUB_THREAD | 0x00000003)
/** ATT/DETv */
#define		USBH_HUB_MESID_REQ_RE_ATTDET					(USBH_MSGID_KIND_HUB_THREAD | 0x00000004)
/** |[gSUSPENDv */
#define		USBH_HUB_MESID_REQ_PORT_SUSPEND					(USBH_MSGID_KIND_HUB_THREAD | 0x00000005)
/** |[gRESMEv */
#define		USBH_HUB_MESID_REQ_PORT_RESUME					(USBH_MSGID_KIND_HUB_THREAD | 0x00000006)
/** ATT/DET֎~v */
#define		USBH_HUB_MESID_REQ_DIS_ATTDET					(USBH_MSGID_KIND_HUB_THREAD | 0x00000007)

//------------------------------------------------------------------------------
//	Message ID (Response)
//------------------------------------------------------------------------------
/** SUSPEND */
#define		USBH_HUB_MESID_ANS_SUSPEND						(USBH_MSGID_KIND_RESPONSE | USBH_HUB_MESID_REQ_SUSPEND)
/** RESUME */
#define		USBH_HUB_MESID_ANS_RESUME						(USBH_MSGID_KIND_RESPONSE | USBH_HUB_MESID_REQ_RESUME)
/** ATT/DET */
#define		USBH_HUB_MESID_ANS_RE_ATTDET					(USBH_MSGID_KIND_RESPONSE | USBH_HUB_MESID_REQ_RE_ATTDET)
/** |[gSUSPEND */
#define		USBH_HUB_MESID_ANS_PORT_SUSPEND					(USBH_MSGID_KIND_RESPONSE | USBH_HUB_MESID_REQ_PORT_SUSPEND)
/** |[gRESME */
#define		USBH_HUB_MESID_ANS_PORT_RESUME					(USBH_MSGID_KIND_RESPONSE | USBH_HUB_MESID_REQ_PORT_RESUME)
/** ATT/DET֎~v */
#define		USBH_HUB_MESID_ANS_DIS_ATTDET					(USBH_MSGID_KIND_RESPONSE | USBH_HUB_MESID_REQ_DIS_ATTDET)

//------------------------------------------------------------------------------
//	GET_PORT_STATUS̃gCfBC	(ms)
//------------------------------------------------------------------------------
#define		USBH_HUB_RTEY_DLY_GET_PORT_STATUS				(100)

//------------------------------------------------------------------------------
//	GET_PORT_STATUS̃gCJE^	(Counts)
//------------------------------------------------------------------------------
#define		USBH_HUB_CHKMAX_LOOP_GET_PORT_STATUS			(10)

// *************************************************************************************************
//	enum
// *************************************************************************************************
/* HUBNXhCoXe[^X */
typedef enum _USB_HUB_STATUS {
    USB_HUB_NON_INIT,															// 
    USB_HUB_IDLE,																// ACh
    USB_HUB_RUN,																// 쒆
    USB_HUB_EXIT,																// I
    USB_HUB_ERROR																// G[
}USB_HUB_STATUS;


// *************************************************************************************************
//	structure
// *************************************************************************************************
//------------------------------------------------------------------------------
//	HUBXe[^X\
//------------------------------------------------------------------------------
struct usbh_hub_status{     // __st__
    uhs_ubit16_t    hub_status;
        #define HS_HUB_STATUS_LOCAL_POWER   ((uhs_ubit16_t)1 << 0)
        #define HS_HUB_STATUS_OVER_CURRENT  ((uhs_ubit16_t)1 << 1)

    uhs_ubit16_t    hub_change_status;
        #define HS_C_HUB_LOCAL_POWER        ((uhs_ubit16_t)1 << 0)
        #define HS_C_HUB_OVER_CURRENT       ((uhs_ubit16_t)1 << 1)
};


//------------------------------------------------------------------------------
//	|[gXe[^X\
//------------------------------------------------------------------------------
struct usbh_port_status{        // __st__
    uhs_ubit16_t    port_status;
        /** foCX݂邩 */
        #define PS_PORT_CONNECTION          ((uhs_ubit16_t)1 << 0)
        /** |[g삷邩 */
        #define PS_PORT_ENABLE              ((uhs_ubit16_t)1 << 1)
        /** |[gSuspendԂł邩 */
        #define PS_PORT_SUSPEND             ((uhs_ubit16_t)1 << 2)
        /** ߓd݂Ȃ */
        #define PS_PORT_OVER_CURRENT        ((uhs_ubit16_t)1 << 3)
        /** nu|[gփZbgMoĂ邩 */
        #define PS_PORT_RESET               ((uhs_ubit16_t)1 << 4)
        /** |[gdԂł邩 */
        #define PS_PORT_POWER               ((uhs_ubit16_t)1 << 8)
        /** ڑꂽfoCXLow Speed */
        #define PS_PORT_LOW_SPEED           ((uhs_ubit16_t)1 << 9)
        /** ڑꂽfoCXHigh Speed */
        #define PS_PORT_HIGH_SPEED          ((uhs_ubit16_t)1 << 10)
        /** |[g|[geXg[h */
        #define PS_PORT_TEST                ((uhs_ubit16_t)1 << 11)
        /** |[gCWP[^̕\F\tgEFARg[ */
        #define PS_PORT_INDICATOR           ((uhs_ubit16_t)1 << 12)

    uhs_ubit16_t    port_change_status;
        /** ڑXe[^Xω */
        #define PS_C_PORT_CONNECTION        ((uhs_ubit16_t)1 << 0)
        /** |[gG[݂邩 */
        #define PS_C_PORT_ENABLE            ((uhs_ubit16_t)1 << 1)
        /** W[M */
        #define PS_C_PORT_SUSPEND           ((uhs_ubit16_t)1 << 2)
        /** ߓdω */
        #define PS_C_PORT_OVERCURRENT       ((uhs_ubit16_t)1 << 3)
        /** Zbg */
        #define PS_C_PORT_RESET             ((uhs_ubit16_t)1 << 4)
};


//------------------------------------------------------------------------------
//	HUBfBXNv^\
//------------------------------------------------------------------------------
struct hub_descriptor{      // __st__
    uhs_ubit8_t     bDescLength;
    uhs_ubit8_t     bDescriptorType;
        #define HUB_DESCRIPTOR_TYPE     (0x29)
    uhs_ubit8_t     bNbrPorts;
    uhs_ubit16_t    wHubCharacteristics;
        #define HUB_POWERSWITCH_MASK    (0x03 << 0)
            #define GANGED_POWER_SWITCH         (0x00 << 0)
            #define INDIVIDUAL_POWER_SWITCH     (0x01 << 0)
        
        #define HUB_COMPDEVICE_MASK     (1 << 2)
            #define NOT_COMPOUND_DEVICE         (0x00 << 2)
            #define COMPOUND_DEVICE             (0x01 << 2)
        
        #define HUB_OVERCURRENT_MASK    (0x03 << 3)
            #define GLOBAL_OVERCURRENT_PROTECTION       (0x00 << 3)
            #define INDIVIDUAL_OVERCURRENT_PROTECTION   (0x01 << 3)
            #define NOT_OVERCURRENT_PROTECTION          (0x10 << 3)
    
        #define HUB_TTTHINKTIME_MASK    (0x03 << 5)
            #define TTTHINKTIME_8FS          (0x00 << 5)
            #define TTTHINKTIME_16FS         (0x01 << 5)
            #define TTTHINKTIME_24FS         (0x10 << 5)
            #define TTTHINKTIME_32FS         (0x11 << 5)
    
        #define HUB_INDICATORSUPPORT_MASK    (0x01 << 7)
            #define INDICATORSUPPORT_OFF       (0x00 << 7)
            #define INDICATORSUPPORT_ON        (0x01 << 7)
    
    uhs_ubit8_t     bPwrOn2PwrGood;
    uhs_ubit8_t     bHubContrCurrent;
    uhs_ubit8_t     DeviceRemovable;
    uhs_ubit8_t     PortPwrCtlMask;
};


/**	ڑꂽHUBɊւۑׂ̍\́B<p>
    擾HUBfXNv^WJ܂B<p>
    ^C~O F HUBڑ<p>
    폜^C~O F HUBؒf */
struct usb_hub_info{

    struct usbd_usb_deviceinfo *usbdev;		/** nugUSBfoCX\ */

    struct hub_descriptor    *hub_desc;		/** nufBXNv^i[pobt@|C^ */

	//	HUB DESCRIPTOR̓WJ
    uhs_ubit8_t     port_num;				/** nuĂ_EXg[|[g */
    uhs_ubit16_t    PwrOnWait;				/**	PORT_POWEȒ҂(ms)	l2ms\Ams\ɕϊ */
    uhs_ubit8_t     current;				/**	HUB Controller̕Kvȓd(mA) */
    uhs_ubit8_t     power_switch;			/**	wHubCharacteristicsFp[SW (00=GANG/01=INDIVIDUAL_PORT/1X=Reserved) */
    uhs_ubit8_t     compound_device;		/**	wHubCharacteristicsFRpEhfoCXǂ */
    uhs_ubit8_t     current_protect;		/**	wHubCharacteristicsFI[oJgی샂[h(00=Global/01=IndividualPort/1X=NO OverCurrent) */
    uhs_ubit8_t     tt_thinktime;			/**	wHubCharacteristicsFTT Think Time */
    uhs_ubit8_t     indicator_support;		/**	wHubCharacteristicsF|[gCWP[^(LED)̃T|[gL */
    uhs_ubit8_t     dev_removal;			/**	Device Removable (B1-B7e|[gɑΉ) */

	//	INTERRUPT_IN p
    uhs_ubit8_t     intr_epnum;				/** C^vgpGh|Cgԍ */
    uhs_ubit8_t     intr_interval;			/** C^vgpC^[o */
    uhs_ubit8_t     hub_intr_buf_size;		/** C^vg]Mf[^obt@TCY */
    void            *hub_intr_buf;			/** C^vg]Mf[^obt@|C^ */

	//	HUB̂̃ANZXpUCB̈
    struct usb_control_block* control_ucb;	/** NXNGXgp Rg[ubN|C^ */
    struct usb_control_block* intr_ucb;		/** NXNGXgp C^vgubN|C^ */

    kernel_context_t    hub_info_sem;		/** nufoCX\̃bNp */
};


//------------------------------------------------------------------------------
//	HUBXbh̊Ǘ
//------------------------------------------------------------------------------
struct usb_hub_driver {     // __st__
    kernel_context_t    mbx_osc;												//	HUBXbhpMailBox
    kernel_context_t    evt_osc;												//	HUBXbhpEventFlagiIpj
    kernel_context_t    thread_info;											//	HUBXbhp^XN
};

//------------------------------------------------------------------------------
//	Message Format : HUB_ThreadIʒm
//------------------------------------------------------------------------------
typedef	struct	{

	UHS_MSG_COMMON		msg_common;												//	ʗ̈

}	UHS_MSG_HUB_NOTIFY_EXIT_FMT;

//------------------------------------------------------------------------------
//	Message Format : Interrupt_inʒm
//------------------------------------------------------------------------------
typedef	struct	{

	UHS_MSG_COMMON			msg_common;											//	ʗ̈
	struct usb_hub_info		*hub_info;											//	HUB̃|C^

}	UHS_MSG_HUB_NOTIFY_INTR_IN_FMT;

//------------------------------------------------------------------------------
//	Message Format : SUSPENDv
//	Message Format : RESUMEv
//	Message Format : ATT/DETv
//	Message Format : ATT/DET֎~v
//------------------------------------------------------------------------------
typedef	struct	{

	UHS_MSG_COMMON		msg_common;												//	ʗ̈
	void				*mbox_context;											//	pMboxReLXg|C^

}	UHS_MSG_HUB_REQ_SUSPEND_FMT , UHS_MSG_HUB_REQ_RESUME_FMT , UHS_MSG_HUB_REQ_RE_ATTDET_FMT, UHS_MSG_HUB_REQ_DIS_ATTDET_FMT;

//------------------------------------------------------------------------------
//	Message Format : HUB_PORT_SUSPENDv
//	Message Format : HUB_PORT_RESUMEv
//------------------------------------------------------------------------------
typedef	struct	{

	UHS_MSG_COMMON		msg_common;												//	ʗ̈
	void				*mbox_context;											//	pMboxReLXg|C^
	struct usb_hub_info	*hub_info;												//	HUB̃|C^
	uhs_ubit32_t		hub_port;												//	Ώۃ|[gԍ(1~)

}	UHS_MSG_HUB_REQ_PORT_SUSPEND , UHS_MSG_HUB_REQ_PORT_RESUME;

//------------------------------------------------------------------------------
//	Message Format : SUSPEND
//	Message Format : RESUME
//	Message Format : ATT/DET
//	Message Format : HUB_PORT_SUSPEND
//	Message Format : HUB_PORT_RESUME
//------------------------------------------------------------------------------
typedef	struct	{

	UHS_MSG_COMMON		msg_common;												//	ʗ̈
	uhs_status_t		result;													//	

}	UHS_MSG_HUB_ANS_SUSPEND_FMT ,UHS_MSG_HUB_ANS_RESUME_FMT ,UHS_MSG_HUB_ANS_RE_ATTDET_FMT ,UHS_MSG_HUB_ANS_PORT_SUSPEND ,UHS_MSG_HUB_ANS_PORT_RESUME;

//------------------------------------------------------------------------------
//	Port Attach/Detachr	(`rL)
//------------------------------------------------------------------------------
#define		USBH_HUB_EXCLUSIVE


// *************************************************************************************************
//	extern
// *************************************************************************************************
extern uhs_status_t Usb_HubApi_Init( void );
extern void Usb_HubApi_Exit( void );
extern uhs_status_t Usb_HubApi_PortDevDetach( struct usbd_usb_deviceinfo* usbdev );
extern uhs_status_t Usb_HubApi_ClearFeature( struct usb_hub_info* hub_info, uhs_ubit8_t feature, uhs_ubit16_t port_num );
extern uhs_status_t Usb_HubApi_SetFeature( struct usb_hub_info* hub_info, uhs_ubit8_t feature, uhs_ubit16_t port_num );
extern uhs_status_t Usb_HubApi_GetStatus( struct usb_hub_info* hub_info, void* buf, uhs_ubit16_t port_num );
extern	uhs_status_t Usb_HubApi_ClearTTBuffer( struct usb_hub_info* hub_info, uhs_ubit16_t tt_port, struct	usbd_usb_spliterrinfo *split_err_info);
extern	uhs_status_t Usb_HubApi_RESET_TT( struct usb_hub_info* hub_info, uhs_ubit16_t tt_port );
extern	uhs_status_t Usb_Hub_SendPortReset( struct usb_hub_info* hub_info, uhs_ubit8_t port_num );
extern	void Usb_Hub_ReportStatus( const char*  pFileName, uhs_ubit32_t nLine, usb_msglevel level, uhs_ubit16_t msgdata, uhs_ubit8_t  port_num , uhs_ubit8_t hub_adr );
extern	uhs_status_t	Usb_Hub_AddHubInfo_List( struct usb_hub_info* hub_info );
extern	uhs_status_t	Usb_Hub_DelHubInfo_List( struct usb_hub_info* hub_info );
extern	uhs_status_t	Usb_Hub_ChkHubInfo_List( struct usb_hub_info* hub_info , uhs_ubit8_t *chk_result );
extern	uhs_status_t	Usb_Hub_SendMsg_exit( void );
extern	uhs_status_t	Usb_Hub_SendMsg_intr_in( struct usb_hub_info *hub_info );
extern	uhs_status_t	Usb_Hub_SendMsg_with_mbx( void *resp_mbox_context , uhs_ubit32_t mess_id );
extern	uhs_status_t	Usb_Hub_SendMsg_with_hubinfo_mbx( void *resp_mbox_context , uhs_ubit32_t mess_id , struct usb_hub_info *hub_info , uhs_ubit32_t hub_port );
extern	uhs_status_t	Usb_Hub_SendMsg_result( void *mbox_context , uhs_ubit32_t mess_id , uhs_status_t result );
extern	uhs_ubit32_t	Usb_Hub_get_suspend_flg( void );

#endif /* __USBC_HUB_H__ */
