/**
 * @brief        DisplayManager sample header
 * @file         dsp_sample.h
 * @author       AXELL
 * @history      17_06_30 \
 * @description  none
 * @note         ̃t@C tab=4AsR[h=CRLF ŋLqĂ܂.
 */

/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __DSP_SAMPLE_H__
#define __DSP_SAMPLE_H__

#include "main.h"
#include "com.h"

#include "sys/spcprm.h"
#include "sys/sscprm.h"


/*---------------------- o ----------------------*/
#define DSP_Printf(FMT, ...)		sys_print(0, FMT,##__VA_ARGS__)
#define DSP_ErrPrintf(FMT, ...)		sys_print(1, FMT,##__VA_ARGS__)

/*-------------------- 萔` --------------------*/
/* \o̓|[g */
#define DSP_SAMPLE_OUT_CMOS			0
#define DSP_SAMPLE_OUT_LVDS			1

/* PLL`l */
#define DSP_SAMPLE_PLLCH_1			1
#define DSP_SAMPLE_PLLCH_2			2

/* LVDSo̓p^[ */
#define DSP_SAMPLE_LVDS_SINGLE		0
#define DSP_SAMPLE_LVDS_DUAL		1

/* F␳e[uݒ */
#define DSP_SAMPLE_LUT_NORMAL		0
#define DSP_SAMPLE_LUT_REVERSE		1
#define DSP_SAMPLE_LUT_OFF			255

/* fBUOݒ */
#define DSP_SAMPLE_DITH_DISABLE		0
#define DSP_SAMPLE_DITH_SXGA		1


/*-------------------- f[^\` --------------------*/
typedef struct _DSP_SAMPLE_PARAM{
	AG903_DSPMgrHandle		*handle[AG903_DSP_CH_NUM];		/* DisplayManagernh */
	uint32_t				fb_addr;						/* t[obt@擪AhX */
	uint32_t				fb_size;						/* t[obt@TCY */
	uint32_t				fb_addr2;						/* t[obt@擪AhX */
	uint32_t				fb_size2;						/* t[obt@TCY */
	uint32_t				attr_addr;						/* EBhEAgr[g擪AhX */
	AG903_DSPMgrCtrlParam	param_ctrl;						/* DisplayManagerݒp\ */
	AG903_DSPMgrCMOSParam	param_cmos;						/* DisplayManagerݒp\ */
	AG903_DSPMgrLVDSParam	param_lvds;						/* DisplayManagerݒp\ */
	AG903_DSPMgrBPwrModeParam	param_bpwr;					/* DisplayManagerݒp\ */
	AG903_DSPMgrWindowParam	param_win;						/* DisplayManagerݒp\ */
	AG903_DSPMgrIntParam	param_int;						/* DisplayManagerݒp\ */
	bool					lut_changed[AG903_DSP_CH_NUM];	/* F␳e[uύXς݃tO */
	bool					dith_enabled[AG903_DSP_CH_NUM];	/* fBUOݒLtO */
	uint32_t				lvds_format;					/* LVDSo̓tH[}bg */
	uint32_t				bpwr_brightness;				/* obNCg̖邳[%] */
}DSP_SAMPLE_PARAM;


#endif/* __DSP_SAMPLE_H__ */
