/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
*/
#include "gfx_sample.h"

static VGubyte rect_cmd[] = {
    VG_MOVE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_LINE_TO_ABS, VG_CLOSE_PATH
};

static VGuint rect_coord[] = {
    0, 0,  200, 0, 200, 200, 0, 200,
};

/* VU[g */
static VGint ScissorRects[] = {
    80, 80, 80, 80,
    200, 50, 200, 50,
    10, 110, 30, 30,
    50, 150, 300, 80,
    -50, 300, 90, 200,
    150, 250, 300, 300,
    500, 10, 100, 450

};

/* IuWFNg */
static VGPath path;
static VGPaint paint;

static void TestInit(int width, int height)
{
    VGfloat ClearColor[4]  = {1.0F, 1.0F, 1.0F, 1.0F};

    /* `T[tFX̃NAJ[w */
    vgSetfv(VG_CLEAR_COLOR, 4, ClearColor);

    /* `T[tFXŜNA */
    vgClear(0, 0, width, height);

    /* VGPathIuWFNg̐ */
    path = vgCreatePath(VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_S_32, 1.0F, 0.0F, 0, 0, VG_PATH_CAPABILITY_ALL);

    /* VGPathIuWFNgɌ`f[^o^ */
    vgAppendPathData(path, sizeof(rect_cmd), rect_cmd, rect_coord);

    /* VGPaintIuWFNg̐ */
    paint = vgCreatePaint();

    /* J[yCgɐݒ */
    vgSetParameteri(paint, VG_PAINT_TYPE, VG_PAINT_TYPE_COLOR);

    /* yCgFILL`ɐݒ */
    vgSetPaint(paint, VG_FILL_PATH);

    /* ݂̃}gNXPATH_USER_TO_SURFACEɐݒ */
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_PATH_USER_TO_SURFACE);

    /* s񏉊 */
    vgLoadIdentity();
}

static void DrawWithScissor(void)
{
    vgScale(3.2F, 2.4F);

    /* VU[g̎w */
    vgSetiv(VG_SCISSOR_RECTS,
            sizeof(ScissorRects)/sizeof(ScissorRects[0]),
            ScissorRects);

    /* VU[̖ */
    vgSeti(VG_SCISSORING, VG_FALSE);

    /* `F̐ݒiԁj */
    vgSetColor(paint, 0xFF0000FF);

    /* ` */
    vgDrawPath(path, VG_FILL_PATH);

    /* VU[̗L */
    vgSeti(VG_SCISSORING, VG_TRUE);

    /* `F̐ݒi΁j */
    vgSetColor(paint, 0x00FF00FF);

    /* ` */
    vgDrawPath(path, VG_FILL_PATH);
}

static void TestTerm(void)
{
    /* FILL` */
    vgSetPaint(VG_INVALID_HANDLE, VG_FILL_PATH);

    /* VU[̖ */
    vgSeti(VG_SCISSORING, VG_FALSE);

    /* IuWFNgj */
    vgDestroyPath(path);
    vgDestroyPaint(paint);
}

void ScissorMain(void)
{
    /*  */
    TestInit(GFX_WIDTH, GFX_HEIGHT);

    /* pX`揈 */
    DrawWithScissor();

    /* obt@Xbv */
    GfxSwapBuffer();

    /* I */
    TestTerm();
}
