/**
 * @brief       WDT Controler
 * @author      AXELL CORPORATION
 * @description WDT Controler
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "AG903_intno.h"
#include "wdt/wdtctl.h"
#include "wdt/wdtprm.h"
#include "int/intmgr.h"

typedef struct _AG903_WDTCtlInthdrStat {
	int32_t	hdrid;		/* nhID */
	void*	func;		/* ݃nh̋NԒn */
}AG903_WDTCtlInthdrStat;

static AG903_WDTCtlInthdrStat	WdtInthdrStat = {0, NULL};

/**
 * @brief           WDT
 * @param           param [in] WDTݒp[^
 * @return          
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     WDT̏܂BWDT쒆łꍇ͒~ď܂B<p>
 *                  ݃nh̓o^͍폜܂B
 *                  Xe[^X̓NA܂B
 * @note            gp𒆎~Ƃ͕KvɉAvAG903_INTMgrDisableIntɂWDT̊荞݂𖳌ɂĉB
*/
int32_t AG903_WDTCtlInit(AG903_WDTCtlParam* param)
{
	_Bool rst  = false;
	_Bool intr = false;
	_Bool ext  = false;
	
	if(NULL == param) {
		return -AG903_EINVAL;
	}

	AG903_WDTPrmDisableCount();		/* WDT~ */
	AG903_WDTPrmClearStatus();
	AG903_WDTPrmSetIntrlen(param->intrlen);
	AG903_WDTPrmSetCount(param->count);
	AG903_WDTPrmRestartCount();
	if(AG903_WDT_SYSRESET_ENABLE & param->enable) {
		rst = true;
	}
	if(AG903_WDT_SYSINTR_ENABLE & param->enable) {
		intr = true;
	}
	if(AG903_WDT_EXTSIGNAL_ENABLE & param->enable) {
		ext = true;
	}
	AG903_WDTPrmSetControl(rst, intr, ext);

	return AG903_ENONE;
}

/**
 * @brief           ݃nh̓o^
 * @param           func [in] ݃nh̋NԒn
 * @param           param [in] p[^
 * @return          荞݃nh̓o^
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   ɓo^ς.
 * @retval          -AG903_EFAULT  s (nho^oȂ).
 * @description     荞݃nho^܂B<p>
 *                  param ̓R[obN֐ɈƂēn܂B
*/
int32_t	AG903_WDTCtlSetIntHandler(void* func, void* param)
{
	AG903_INTMgrHdrPrm inthdr;
	int32_t	 hdrid;

	if(NULL == func) {
		return -AG903_EINVAL;
	}
	if(NULL != WdtInthdrStat.func) {
		return -AG903_EPERM;	/* ɓo^ς */
	}
	inthdr.atr   = AG903_INT_HLNG;
	inthdr.intno = AG903_IRQ25_WDT;
	inthdr.func  = func;
	inthdr.exinf = param;
	hdrid = AG903_INTMgrSetHandler(&inthdr);
	if(0 >= hdrid) {
		return -AG903_EFAULT;
	}
	AG903_INTMgrEnableInt(AG903_IRQ25_WDT);
	WdtInthdrStat.hdrid = hdrid;
	WdtInthdrStat.func  = func;
	
	return AG903_ENONE;
}

/**
 * @brief           ݃nh̍폜
 * @param           none
 * @return          荞݃nh̍폜
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EFAULT  s (nh폜oȂ).
 * @description     荞݃nh폜܂B
*/
int32_t	AG903_WDTCtlDeleteIntHandler(void)
{
	int32_t	 retval = AG903_ENONE;
	
	if(NULL != WdtInthdrStat.func) {
		retval = AG903_INTMgrDeleteHandler(WdtInthdrStat.hdrid);
		if(AG903_ENONE != retval) {
			return -AG903_EFAULT;
		}
		WdtInthdrStat.hdrid = 0;
		WdtInthdrStat.func  = NULL;
	}

	return retval;
}

/**
 * @brief           WDT Enable
 * @param           none
 * @return          void
 * @retval          none
 * @description     WDTEnable܂B
*/
void AG903_WDTCtlEnable(void)
{
	AG903_WDTPrmEnableCount();
}

/**
 * @brief           WDT Disable
 * @param           none
 * @return          void
 * @retval          none
 * @description     WDTDisable܂B
*/
void AG903_WDTCtlDisable(void)
{
	AG903_WDTPrmDisableCount();
}

/**
 * @brief           WDT Restart
 * @param           none
 * @return          void
 * @retval          none
 * @description     WDTRestart܂B
*/
void AG903_WDTCtlRestart(void)
{
	AG903_WDTPrmRestartCount();
}

/**
 * @brief           Xe[^X擾
 * @param           status [out] Xe[^X
 * @return          Xe[^X擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     Xe[^X̎擾܂B<p>
 *                  status "0"ԖBA"1"ԓBłB
*/
int32_t AG903_WDTCtlGetStatus(uint32_t* status)
{
	if(NULL == status) {
		return -AG903_EINVAL;
	}
	
	AG903_WDTPrmGetStatus(status);
	
	return AG903_ENONE;
}

/**
 * @brief           Xe[^XNA
 * @param           none
 * @return          Xe[^XNA
 * @retval          AG903_ENONE    I
 * @description     Xe[^XNA܂B
*/
int32_t AG903_WDTCtlClearStatus(void)
{
	AG903_WDTPrmClearStatus();
	
	return AG903_ENONE;
}

/**
 * @brief           JE^l擾
 * @param           count [out] JE^l
 * @return          JE^l擾
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     JE^l擾܂B
*/
int32_t AG903_WDTCtlGetCount(uint32_t* count)
{
	if(NULL == count) {
		return -AG903_EINVAL;
	}
	
	AG903_WDTPrmGetCount(count);
	
	return AG903_ENONE;
}

