/**
 * @brief           SSC Register Definition
 * @author          AXELL CORPORATION
 * @description     SSC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_SSC_REGMAP_H_
#define _AG903_SSC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** SSC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  REVISION;
    };

    union {
        __I  uint32_t  READTEST;
    };

    union {
        __IO uint32_t  WRITETEST;
    };

    union {
        __IO uint32_t  MODE_STATUS;

        struct {
            __I  uint32_t  BOOTMODE                       :  4;
            __I  uint32_t  BOOTTEST                       :  4;
            __IO uint32_t  WDTCA5                         :  1;
            __IO uint32_t  WDTGPP                         :  1;
            __IO uint32_t  WDTPIN                         :  1;
            __IO uint32_t  INITPIN                        :  1;
        } MODE_STATUS_bits;
    };

    union {
        __I  uint32_t  IRQ_STATUS_LOWER;
    };

    union {
        __I  uint32_t  IRQ_STATUS_UPPER;
    };

    __I  uint32_t  RESERVED1[2];

    union {
        __I  uint32_t  IRQ_BUS_STATUS;

        struct {
            __I  uint32_t  IRQBUSSTATUS                   :  8;
        } IRQ_BUS_STATUS_bits;
    };

    union {
        __IO uint32_t  IRQ_BUS_ENABLE;

        struct {
            __IO uint32_t  IRQBUSENABLE                   :  8;
        } IRQ_BUS_ENABLE_bits;
    };

    __I  uint32_t  RESERVED2[2];

    union {
        __I  uint32_t  INT_STATUS_LOWER;
    };

    union {
        __I  uint32_t  INT_STATUS_MIDDLE;
    };

    union {
        __I  uint32_t  INT_STATUS_UPPER;
    };

    __I  uint32_t  RESERVED3[1];

    union {
        __IO uint32_t  INT0_ENABLE_LOWER;
    };

    union {
        __IO uint32_t  INT0_ENABLE_MIDDLE;
    };

    union {
        __IO uint32_t  INT0_ENABLE_UPPER;
    };

    __I  uint32_t  RESERVED4[1];

    union {
        __IO uint32_t  INT1_ENABLE_LOWER;
    };

    union {
        __IO uint32_t  INT1_ENABLE_MIDDLE;
    };

    union {
        __IO uint32_t  INT1_ENABLE_UPPER;
    };

    __I  uint32_t  RESERVED5[1];

    union {
        __IO uint32_t  INT2_ENABLE_LOWER;
    };

    union {
        __IO uint32_t  INT2_ENABLE_MIDDLE;
    };

    union {
        __IO uint32_t  INT2_ENABLE_UPPER;
    };

    __I  uint32_t  RESERVED6[1];

    union {
        __IO uint32_t  INT3_ENABLE_LOWER;
    };

    union {
        __IO uint32_t  INT3_ENABLE_MIDDLE;
    };

    union {
        __IO uint32_t  INT3_ENABLE_UPPER;
    };

    __I  uint32_t  RESERVED7[1];

    union {
        __IO uint32_t  CLKDUTY_GFX;

        struct {
            __IO uint32_t  DUTY                           :  8;
            __IO uint32_t  VSON                           :  1;
        } CLKDUTY_GFX_bits;
    };

    union {
        __IO uint32_t  CLKDUTY_GVD;

        struct {
            __IO uint32_t  DUTY                           :  8;
        } CLKDUTY_GVD_bits;
    };

    __I  uint32_t  RESERVED8[10];

    union {
        __IO uint32_t  WDTOUT_INTMODE;

        struct {
            __IO uint32_t  LEVEL                          :  1;
        } WDTOUT_INTMODE_bits;
    };

    union {
        __O  uint32_t  WDTOUT_INTCLEAR;

        struct {
            __O  uint32_t  CLEAR                          :  1;
        } WDTOUT_INTCLEAR_bits;
    };

    union {
        __IO uint32_t  WDTOUT_SETUP;

        struct {
            __IO uint32_t  OUT                            :  1;
            __IO uint32_t  OD                             :  1;
            __IO uint32_t  WDT                            :  1;
            __IO uint32_t  INIT                           :  1;
        } WDTOUT_SETUP_bits;
    };

    __I  uint32_t  RESERVED9[1];

    union {
        __IO uint32_t  PIN_FUNC0;

        struct {
            __IO uint32_t  FUNC0                          :  2;
            __IO uint32_t  FUNC1                          :  2;
            __IO uint32_t  FUNC2                          :  2;
            __IO uint32_t  FUNC3                          :  2;
            __IO uint32_t  FUNC4                          :  2;
            __IO uint32_t  FUNC5                          :  2;
            __IO uint32_t  FUNC6                          :  2;
            __IO uint32_t  FUNC7                          :  2;
            __IO uint32_t  FUNC8                          :  2;
            __IO uint32_t  FUNC9                          :  2;
            __IO uint32_t  FUNC10                         :  2;
            __IO uint32_t  FUNC11                         :  2;
            __IO uint32_t  FUNC12                         :  2;
            __IO uint32_t  FUNC13                         :  2;
            __IO uint32_t  FUNC14                         :  2;
            __IO uint32_t  FUNC15                         :  2;
        } PIN_FUNC0_bits;
    };

    union {
        __IO uint32_t  PIN_FUNC1;

        struct {
            __IO uint32_t  FUNC16                         :  2;
            __IO uint32_t  FUNC17                         :  2;
            __IO uint32_t  FUNC18                         :  2;
            __IO uint32_t  FUNC19                         :  2;
            __IO uint32_t  FUNC20                         :  2;
            __IO uint32_t  FUNC21                         :  2;
            __IO uint32_t  FUNC22                         :  2;
            __IO uint32_t  FUNC23                         :  2;
            __IO uint32_t  FUNC24                         :  2;
            __IO uint32_t  FUNC25                         :  2;
            __IO uint32_t  FUNC26                         :  2;
            __IO uint32_t  FUNC27                         :  2;
            __IO uint32_t  FUNC28                         :  2;
            __IO uint32_t  FUNC29                         :  2;
            __IO uint32_t  FUNC30                         :  2;
            __IO uint32_t  FUNC31                         :  2;
        } PIN_FUNC1_bits;
    };

    union {
        __IO uint32_t  PIN_SETUP_INDEX;

        struct {
            __IO uint32_t  INDEX                          :  8;
        } PIN_SETUP_INDEX_bits;
    };

    union {
        __IO uint32_t  PIN_SETUP_DATA;

        struct {
            __IO uint32_t  SETUP                          :  8;
        } PIN_SETUP_DATA_bits;
    };

    union {
        __IO uint32_t  PIN_GPIO_ENABLE[4];
    };

    union {
        __IO uint32_t  PIN_GPIO_PIN_PU[4];
    };

    union {
        __IO uint32_t  PIN_GPIO_PIN_PD[4];
    };

    union {
        __IO uint32_t  CA5_RUN_SETUP;

        struct {
            __IO uint32_t  GCLK                           :  1;
            __IO uint32_t  RESET                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  VINITHI                        :  1;
        } CA5_RUN_SETUP_bits;
    };

    union {
        __O  uint32_t  CA5_RUN_CTRL;

        struct {
                 uint32_t                                 : 16;
            __O  uint32_t  CLREV                          :  1;
        } CA5_RUN_CTRL_bits;
    };

    union {
        __IO uint32_t  CA5_RUN_STATUS;

        struct {
            __I  uint32_t  GCLK                           :  1;
            __I  uint32_t  RESET                          :  1;
                 uint32_t                                 :  6;
            __I  uint32_t  WFE                            :  1;
                 uint32_t                                 :  3;
            __I  uint32_t  WFI                            :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  EVENTO                         :  1;
        } CA5_RUN_STATUS_bits;
    };

    union {
        __IO uint32_t  CA5_ACP_SETUP;

        struct {
                 uint32_t                                 : 29;
            __IO uint32_t  ACPADDR                        :  3;
        } CA5_ACP_SETUP_bits;
    };

    union {
        __IO uint32_t  DMA_SELECT0;

        struct {
            __IO uint32_t  DMASELECT0                     :  8;
            __IO uint32_t  DMASELECT1                     :  8;
            __IO uint32_t  DMASELECT2                     :  8;
            __IO uint32_t  DMASELECT3                     :  8;
        } DMA_SELECT0_bits;
    };

    union {
        __IO uint32_t  DMA_SELECT1;

        struct {
            __IO uint32_t  DMASELECT4                     :  8;
            __IO uint32_t  DMASELECT5                     :  8;
            __IO uint32_t  DMASELECT6                     :  8;
            __IO uint32_t  DMASELECT7                     :  8;
        } DMA_SELECT1_bits;
    };

    union {
        __IO uint32_t  DMA_SELECT2;

        struct {
            __IO uint32_t  DMASELECT8                     :  8;
            __IO uint32_t  DMASELECT9                     :  8;
            __IO uint32_t  DMASELECT10                    :  8;
            __IO uint32_t  DMASELECT11                    :  8;
        } DMA_SELECT2_bits;
    };

    union {
        __IO uint32_t  DMA_SELECT3;

        struct {
            __IO uint32_t  DMASELECT12                    :  8;
            __IO uint32_t  DMASELECT13                    :  8;
            __IO uint32_t  DMASELECT14                    :  8;
            __IO uint32_t  DMASELECT15                    :  8;
        } DMA_SELECT3_bits;
    };

    union {
        __IO uint32_t  DMA_SELECT_PBD;

        struct {
            __IO uint32_t  DMASELECT                      :  8;
        } DMA_SELECT_PBD_bits;
    };

    union {
        __IO uint32_t  DSP_SETUP;

        struct {
            __IO uint32_t  VSYNC0_DIR                     :  1;
            __IO uint32_t  FIELD0_DIR                     :  1;
            __IO uint32_t  DOT0_DIR                       :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  VSYNC1_DIR                     :  1;
            __IO uint32_t  FIELD1_DIR                     :  1;
            __IO uint32_t  DOT1_DIR                       :  1;
        } DSP_SETUP_bits;
    };

    __I  uint32_t  RESERVED10[2];

    union {
        __IO uint32_t  TICK0_SETUP;

        struct {
            __IO uint32_t  DIVNUM                         : 24;
            __IO uint32_t  CLKSEL                         :  4;
        } TICK0_SETUP_bits;
    };

    union {
        __IO uint32_t  TICK1_SETUP;

        struct {
            __IO uint32_t  DIVNUM                         : 24;
            __IO uint32_t  CLKSEL                         :  4;
        } TICK1_SETUP_bits;
    };

    union {
        __IO uint32_t  TIM_SETUP;

        struct {
            __IO uint32_t  TIM_DIR                        :  4;
        } TIM_SETUP_bits;
    };

    union {
        __IO uint32_t  SSP_SETUP;

        struct {
            __IO uint32_t  SSP0_DIR                       :  1;
            __IO uint32_t  SSP0_MODE                      :  1;
            __IO uint32_t  SSP0_MCLK_DIR                  :  1;
            __IO uint32_t  SSP0_MCLK_DIV                  :  5;
            __IO uint32_t  SSP1_DIR                       :  1;
            __IO uint32_t  SSP1_MODE                      :  1;
            __IO uint32_t  SSP1_MCLK_DIR                  :  1;
            __IO uint32_t  SSP1_MCLK_DIV                  :  5;
            __IO uint32_t  SSP2_DIR                       :  1;
            __IO uint32_t  SSP2_MODE                      :  1;
            __IO uint32_t  SSP2_MCLK_DIR                  :  1;
            __IO uint32_t  SSP2_MCLK_DIV                  :  5;
            __IO uint32_t  SSP3_DIR                       :  1;
            __IO uint32_t  SSP3_MODE                      :  1;
            __IO uint32_t  SSP3_MCLK_DIR                  :  1;
            __IO uint32_t  SSP3_MCLK_DIV                  :  5;
        } SSP_SETUP_bits;
    };

    union {
        __IO uint32_t  PBD_ADDRCHECK_START;

        struct {
                 uint32_t                                 :  2;
            __IO uint32_t  START_ADDR                     : 30;
        } PBD_ADDRCHECK_START_bits;
    };

    union {
        __IO uint32_t  PBD_ADDRCHECK_END;

        struct {
                 uint32_t                                 :  2;
            __IO uint32_t  END_ADDR                       : 30;
        } PBD_ADDRCHECK_END_bits;
    };

    union {
        __IO uint32_t  PBD_ADDRCHECK_ENABLE;

        struct {
            __IO uint32_t  ENABLE                         :  1;
        } PBD_ADDRCHECK_ENABLE_bits;
    };

    union {
        __I  uint32_t  PBD_ADDRCHECK_STATUS;

        struct {
            __I  uint32_t  STATUS                         :  1;
        } PBD_ADDRCHECK_STATUS_bits;
    };

    union {
        __I  uint32_t  BMU_STATUS;

        struct {
            __I  uint32_t  SNKRDY                         :  4;
            __I  uint32_t  SNKREQ                         :  4;
            __I  uint32_t  SRCRDY                         : 11;
                 uint32_t                                 :  1;
            __I  uint32_t  SRCREQ                         : 11;
        } BMU_STATUS_bits;
    };

    union {
        __O  uint32_t  BMU_CONTROL;

        struct {
            __O  uint32_t  CLR_SNK                        :  4;
            __O  uint32_t  SET_SNK                        :  4;
            __O  uint32_t  CLR_SRC                        : 11;
                 uint32_t                                 :  1;
            __O  uint32_t  SET_SRC                        : 11;
        } BMU_CONTROL_bits;
    };

    union {
        __I  uint32_t  BMU_TRIG_STATUS;

        struct {
            __I  uint32_t  SNKRDY                         :  4;
            __I  uint32_t  SNKREQ                         :  4;
            __I  uint32_t  SRCRDY                         : 11;
                 uint32_t                                 :  1;
            __I  uint32_t  SRCREQ                         : 11;
        } BMU_TRIG_STATUS_bits;
    };

    union {
        __O  uint32_t  BMU_TRIG_CLEAR;

        struct {
            __O  uint32_t  SNKRDY                         :  4;
            __O  uint32_t  SNKREQ                         :  4;
            __O  uint32_t  SRCRDY                         : 11;
                 uint32_t                                 :  1;
            __O  uint32_t  SRCREQ                         : 11;
        } BMU_TRIG_CLEAR_bits;
    };

    __I  uint32_t  RESERVED11[26];

    union {
        __IO uint32_t  PORT_WAIT;

        struct {
            __IO uint32_t  CYCLE                          : 16;
        } PORT_WAIT_bits;
    };

    union {
        __IO uint32_t  PBH_MODE;

        struct {
                 uint32_t                                 :  1;
            __IO uint32_t  WAIT                           :  1;
        } PBH_MODE_bits;
    };

    union {
        __IO uint32_t  TDM0_SETUP;

        struct {
            __IO uint32_t  ST_RX                          :  1;
            __IO uint32_t  ST_TX                          :  1;
            __IO uint32_t  SCLK_N                         :  3;
            __IO uint32_t  TDM_N                          :  2;
            __IO uint32_t  DIR_TX                         :  1;
            __IO uint32_t  FS_RXERR                       :  1;
            __IO uint32_t  FS_DIST                        :  1;
            __IO uint32_t  FS_TXPW                        :  1;
            __IO uint32_t  FS_POL                         :  1;
            __IO uint32_t  SCLK_POL                       :  1;
            __IO uint32_t  TDM_EN                         :  1;
        } TDM0_SETUP_bits;
    };

    union {
        __IO uint32_t  TDM1_SETUP;

        struct {
            __IO uint32_t  ST_RX                          :  1;
            __IO uint32_t  ST_TX                          :  1;
            __IO uint32_t  SCLK_N                         :  3;
            __IO uint32_t  TDM_N                          :  2;
            __IO uint32_t  DIR_TX                         :  1;
            __IO uint32_t  FS_RXERR                       :  1;
            __IO uint32_t  FS_DIST                        :  1;
            __IO uint32_t  FS_TXPW                        :  1;
            __IO uint32_t  FS_POL                         :  1;
            __IO uint32_t  SCLK_POL                       :  1;
            __IO uint32_t  TDM_EN                         :  1;
        } TDM1_SETUP_bits;
    };

    union {
        __IO uint32_t  TDM2_SETUP;

        struct {
            __IO uint32_t  ST_RX                          :  1;
            __IO uint32_t  ST_TX                          :  1;
            __IO uint32_t  SCLK_N                         :  3;
            __IO uint32_t  TDM_N                          :  2;
            __IO uint32_t  DIR_TX                         :  1;
            __IO uint32_t  FS_RXERR                       :  1;
            __IO uint32_t  FS_DIST                        :  1;
            __IO uint32_t  FS_TXPW                        :  1;
            __IO uint32_t  FS_POL                         :  1;
            __IO uint32_t  SCLK_POL                       :  1;
            __IO uint32_t  TDM_EN                         :  1;
        } TDM2_SETUP_bits;
    };

    union {
        __IO uint32_t  TDM3_SETUP;

        struct {
            __IO uint32_t  ST_RX                          :  1;
            __IO uint32_t  ST_TX                          :  1;
            __IO uint32_t  SCLK_N                         :  3;
            __IO uint32_t  TDM_N                          :  2;
            __IO uint32_t  DIR_TX                         :  1;
            __IO uint32_t  FS_RXERR                       :  1;
            __IO uint32_t  FS_DIST                        :  1;
            __IO uint32_t  FS_TXPW                        :  1;
            __IO uint32_t  FS_POL                         :  1;
            __IO uint32_t  SCLK_POL                       :  1;
            __IO uint32_t  TDM_EN                         :  1;
        } TDM3_SETUP_bits;
    };

    union {
        __IO uint32_t  USB_POWER_SETUP;

        struct {
            __IO uint32_t  PWR_PROT_EN                    :  1;
            __IO uint32_t  PWR_INT_EN                     :  1;
            __IO uint32_t  PWR_MODE                       :  1;
        } USB_POWER_SETUP_bits;
    };

    union {
        __I  uint32_t  USB_POWER_STATUS;

        struct {
            __I  uint32_t  PWR_PROT_STATE                 :  1;
            __I  uint32_t  PWR_PROT_PIN                   :  1;
            __I  uint32_t  VBUS_PIN                       :  1;
        } USB_POWER_STATUS_bits;
    };

    union {
        __O  uint32_t  USB_POWER_CLEAR;

        struct {
            __O  uint32_t  PWR_PROT_CLR                   :  1;
        } USB_POWER_CLEAR_bits;
    };

    __I  uint32_t  RESERVED12[1];

    union {
        __IO uint32_t  SD_POWER_SETUP;

        struct {
            __IO uint32_t  PWR_PROT_EN                    :  1;
            __IO uint32_t  PWR_INT_EN                     :  1;
        } SD_POWER_SETUP_bits;
    };

    union {
        __I  uint32_t  SD_POWER_STATUS;

        struct {
            __I  uint32_t  PWR_PROT_STATE                 :  1;
            __I  uint32_t  PWR_PROT_PIN                   :  1;
        } SD_POWER_STATUS_bits;
    };

    union {
        __O  uint32_t  SD_POWER_CLEAR;

        struct {
            __O  uint32_t  PWR_PROT_CLR                   :  1;
        } SD_POWER_CLEAR_bits;
    };

    __I  uint32_t  RESERVED13[1];

    union {
        __IO uint32_t  VIDEOADC_SETUP;

        struct {
            __IO uint32_t  GHO                            :  4;
            __IO uint32_t  CLHO                           :  4;
            __IO uint32_t  CTHO                           :  4;
            __IO uint32_t  DATEN                          :  4;
            __IO uint32_t  ACQEN                          :  4;
            __IO uint32_t  ACQCLR                         :  4;
        } VIDEOADC_SETUP_bits;
    };

    __I  uint32_t  RESERVED14[1];

    union {
        __IO uint32_t  CVBSDEC_ADDR;

        struct {
            __IO uint32_t  ADDR                           : 12;
                 uint32_t                                 :  4;
            __IO uint32_t  CH                             :  2;
        } CVBSDEC_ADDR_bits;
    };

    union {
        __IO uint32_t  CVBSDEC_DATA;

        struct {
            __IO uint32_t  DATA                           : 16;
        } CVBSDEC_DATA_bits;
    };

    union {
        __I  uint32_t  VIDEOADC_MAXMIN[4];

        struct {
            __I  uint32_t  MIN                            : 10;
                 uint32_t                                 :  6;
            __I  uint32_t  MAX                            : 10;
        } VIDEOADC_MAXMIN_bits[4];
    };

    __I  uint32_t  RESERVED15[8];

    union {
        __I  uint32_t  SGI_STATUS;
    };

    union {
        __O  uint32_t  SGI_SET;
    };

    union {
        __O  uint32_t  SGI_CLEAR;
    };

    __I  uint32_t  RESERVED16[1];

    union {
        __IO uint32_t  CA5_JUMPADDR;
    };

    __I  uint32_t  RESERVED17[3];

    union {
        __IO uint32_t  COUNT64_LOWER;
    };

    union {
        __IO uint32_t  COUNT64_UPPER;
    };

/* DOM-IGNORE-END */
}AG903_SSC_Type;

#define AG903_SSC                                ((volatile AG903_SSC_Type *) AG903_SSC_BASE)                            /** SSC Base Address */


#define AG903_SSC_REVISION_REVISION_POS                    0                                                             /** SSCREVISION REVISION-bit position */
#define AG903_SSC_REVISION_REVISION_MSK                    (0xffffffffUL << AG903_SSC_REVISION_REVISION_POS)             /** SSCREVISION REVISION-bit mask */

#define AG903_SSC_READTEST_READTEST_POS                    0                                                             /** SSCREADTEST READTEST-bit position */
#define AG903_SSC_READTEST_READTEST_MSK                    (0xffffffffUL << AG903_SSC_READTEST_READTEST_POS)             /** SSCREADTEST READTEST-bit mask */

#define AG903_SSC_WRITETEST_WRITETEST_POS                  0                                                             /** SSCWRITETEST WRITETEST-bit position */
#define AG903_SSC_WRITETEST_WRITETEST_MSK                  (0xffffffffUL << AG903_SSC_WRITETEST_WRITETEST_POS)           /** SSCWRITETEST WRITETEST-bit mask */

#define AG903_SSC_MODE_STATUS_BOOTMODE_POS                 0                                                             /** SSCMODE_STATUS BOOTMODE-bit position */
#define AG903_SSC_MODE_STATUS_BOOTMODE_MSK                 (0xfUL << AG903_SSC_MODE_STATUS_BOOTMODE_POS)                 /** SSCMODE_STATUS BOOTMODE-bit mask */
#define AG903_SSC_MODE_STATUS_BOOTTEST_POS                 4                                                             /** SSCMODE_STATUS BOOTTEST-bit position */
#define AG903_SSC_MODE_STATUS_BOOTTEST_MSK                 (0xfUL << AG903_SSC_MODE_STATUS_BOOTTEST_POS)                 /** SSCMODE_STATUS BOOTTEST-bit mask */
#define AG903_SSC_MODE_STATUS_WDTCA5_POS                   8                                                             /** SSCMODE_STATUS WDTCA5-bit position */
#define AG903_SSC_MODE_STATUS_WDTCA5_MSK                   (0x1UL << AG903_SSC_MODE_STATUS_WDTCA5_POS)                   /** SSCMODE_STATUS WDTCA5-bit mask */
#define AG903_SSC_MODE_STATUS_WDTGPP_POS                   9                                                             /** SSCMODE_STATUS WDTGPP-bit position */
#define AG903_SSC_MODE_STATUS_WDTGPP_MSK                   (0x1UL << AG903_SSC_MODE_STATUS_WDTGPP_POS)                   /** SSCMODE_STATUS WDTGPP-bit mask */
#define AG903_SSC_MODE_STATUS_WDTPIN_POS                   10                                                            /** SSCMODE_STATUS WDTPIN-bit position */
#define AG903_SSC_MODE_STATUS_WDTPIN_MSK                   (0x1UL << AG903_SSC_MODE_STATUS_WDTPIN_POS)                   /** SSCMODE_STATUS WDTPIN-bit mask */
#define AG903_SSC_MODE_STATUS_INITPIN_POS                  11                                                            /** SSCMODE_STATUS INITPIN-bit position */
#define AG903_SSC_MODE_STATUS_INITPIN_MSK                  (0x1UL << AG903_SSC_MODE_STATUS_INITPIN_POS)                  /** SSCMODE_STATUS INITPIN-bit mask */

#define AG903_SSC_IRQ_STATUS_LOWER_IRQSTATUS_POS           0                                                             /** SSCIRQ_STATUS_LOWER IRQSTATUS-bit position */
#define AG903_SSC_IRQ_STATUS_LOWER_IRQSTATUS_MSK           (0xffffffffUL << AG903_SSC_IRQ_STATUS_LOWER_IRQSTATUS_POS)    /** SSCIRQ_STATUS_LOWER IRQSTATUS-bit mask */

#define AG903_SSC_IRQ_STATUS_UPPER_IRQSTATUS_POS           0                                                             /** SSCIRQ_STATUS_UPPER IRQSTATUS-bit position */
#define AG903_SSC_IRQ_STATUS_UPPER_IRQSTATUS_MSK           (0xffffffffUL << AG903_SSC_IRQ_STATUS_UPPER_IRQSTATUS_POS)    /** SSCIRQ_STATUS_UPPER IRQSTATUS-bit mask */

#define AG903_SSC_IRQ_BUS_STATUS_IRQBUSSTATUS_POS          0                                                             /** SSCIRQ_BUS_STATUS IRQBUSSTATUS-bit position */
#define AG903_SSC_IRQ_BUS_STATUS_IRQBUSSTATUS_MSK          (0xffUL << AG903_SSC_IRQ_BUS_STATUS_IRQBUSSTATUS_POS)         /** SSCIRQ_BUS_STATUS IRQBUSSTATUS-bit mask */

#define AG903_SSC_IRQ_BUS_ENABLE_IRQBUSENABLE_POS          0                                                             /** SSCIRQ_BUS_ENABLE IRQBUSENABLE-bit position */
#define AG903_SSC_IRQ_BUS_ENABLE_IRQBUSENABLE_MSK          (0xffUL << AG903_SSC_IRQ_BUS_ENABLE_IRQBUSENABLE_POS)         /** SSCIRQ_BUS_ENABLE IRQBUSENABLE-bit mask */

#define AG903_SSC_INT_STATUS_LOWER_INTSTATUS_POS           0                                                             /** SSCINT_STATUS_LOWER INTSTATUS-bit position */
#define AG903_SSC_INT_STATUS_LOWER_INTSTATUS_MSK           (0xffffffffUL << AG903_SSC_INT_STATUS_LOWER_INTSTATUS_POS)    /** SSCINT_STATUS_LOWER INTSTATUS-bit mask */

#define AG903_SSC_INT_STATUS_MIDDLE_INTSTATUS_POS          0                                                             /** SSCINT_STATUS_MIDDLE INTSTATUS-bit position */
#define AG903_SSC_INT_STATUS_MIDDLE_INTSTATUS_MSK          (0xffffffffUL << AG903_SSC_INT_STATUS_MIDDLE_INTSTATUS_POS)   /** SSCINT_STATUS_MIDDLE INTSTATUS-bit mask */

#define AG903_SSC_INT_STATUS_UPPER_INTSTATUS_POS           0                                                             /** SSCINT_STATUS_UPPER INTSTATUS-bit position */
#define AG903_SSC_INT_STATUS_UPPER_INTSTATUS_MSK           (0xffffffffUL << AG903_SSC_INT_STATUS_UPPER_INTSTATUS_POS)    /** SSCINT_STATUS_UPPER INTSTATUS-bit mask */

#define AG903_SSC_INT0_ENABLE_LOWER_INTENABLE_POS          0                                                             /** SSCINT0_ENABLE_LOWER INTENABLE-bit position */
#define AG903_SSC_INT0_ENABLE_LOWER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT0_ENABLE_LOWER_INTENABLE_POS)   /** SSCINT0_ENABLE_LOWER INTENABLE-bit mask */

#define AG903_SSC_INT0_ENABLE_MIDDLE_INTENABLE_POS         0                                                             /** SSCINT0_ENABLE_MIDDLE INTENABLE-bit position */
#define AG903_SSC_INT0_ENABLE_MIDDLE_INTENABLE_MSK         (0xffffffffUL << AG903_SSC_INT0_ENABLE_MIDDLE_INTENABLE_POS)  /** SSCINT0_ENABLE_MIDDLE INTENABLE-bit mask */

#define AG903_SSC_INT0_ENABLE_UPPER_INTENABLE_POS          0                                                             /** SSCINT0_ENABLE_UPPER INTENABLE-bit position */
#define AG903_SSC_INT0_ENABLE_UPPER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT0_ENABLE_UPPER_INTENABLE_POS)   /** SSCINT0_ENABLE_UPPER INTENABLE-bit mask */

#define AG903_SSC_INT1_ENABLE_LOWER_INTENABLE_POS          0                                                             /** SSCINT1_ENABLE_LOWER INTENABLE-bit position */
#define AG903_SSC_INT1_ENABLE_LOWER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT1_ENABLE_LOWER_INTENABLE_POS)   /** SSCINT1_ENABLE_LOWER INTENABLE-bit mask */

#define AG903_SSC_INT1_ENABLE_MIDDLE_INTENABLE_POS         0                                                             /** SSCINT1_ENABLE_MIDDLE INTENABLE-bit position */
#define AG903_SSC_INT1_ENABLE_MIDDLE_INTENABLE_MSK         (0xffffffffUL << AG903_SSC_INT1_ENABLE_MIDDLE_INTENABLE_POS)  /** SSCINT1_ENABLE_MIDDLE INTENABLE-bit mask */

#define AG903_SSC_INT1_ENABLE_UPPER_INTENABLE_POS          0                                                             /** SSCINT1_ENABLE_UPPER INTENABLE-bit position */
#define AG903_SSC_INT1_ENABLE_UPPER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT1_ENABLE_UPPER_INTENABLE_POS)   /** SSCINT1_ENABLE_UPPER INTENABLE-bit mask */

#define AG903_SSC_INT2_ENABLE_LOWER_INTENABLE_POS          0                                                             /** SSCINT2_ENABLE_LOWER INTENABLE-bit position */
#define AG903_SSC_INT2_ENABLE_LOWER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT2_ENABLE_LOWER_INTENABLE_POS)   /** SSCINT2_ENABLE_LOWER INTENABLE-bit mask */

#define AG903_SSC_INT2_ENABLE_MIDDLE_INTENABLE_POS         0                                                             /** SSCINT2_ENABLE_MIDDLE INTENABLE-bit position */
#define AG903_SSC_INT2_ENABLE_MIDDLE_INTENABLE_MSK         (0xffffffffUL << AG903_SSC_INT2_ENABLE_MIDDLE_INTENABLE_POS)  /** SSCINT2_ENABLE_MIDDLE INTENABLE-bit mask */

#define AG903_SSC_INT2_ENABLE_UPPER_INTENABLE_POS          0                                                             /** SSCINT2_ENABLE_UPPER INTENABLE-bit position */
#define AG903_SSC_INT2_ENABLE_UPPER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT2_ENABLE_UPPER_INTENABLE_POS)   /** SSCINT2_ENABLE_UPPER INTENABLE-bit mask */

#define AG903_SSC_INT3_ENABLE_LOWER_INTENABLE_POS          0                                                             /** SSCINT3_ENABLE_LOWER INTENABLE-bit position */
#define AG903_SSC_INT3_ENABLE_LOWER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT3_ENABLE_LOWER_INTENABLE_POS)   /** SSCINT3_ENABLE_LOWER INTENABLE-bit mask */

#define AG903_SSC_INT3_ENABLE_MIDDLE_INTENABLE_POS         0                                                             /** SSCINT3_ENABLE_MIDDLE INTENABLE-bit position */
#define AG903_SSC_INT3_ENABLE_MIDDLE_INTENABLE_MSK         (0xffffffffUL << AG903_SSC_INT3_ENABLE_MIDDLE_INTENABLE_POS)  /** SSCINT3_ENABLE_MIDDLE INTENABLE-bit mask */

#define AG903_SSC_INT3_ENABLE_UPPER_INTENABLE_POS          0                                                             /** SSCINT3_ENABLE_UPPER INTENABLE-bit position */
#define AG903_SSC_INT3_ENABLE_UPPER_INTENABLE_MSK          (0xffffffffUL << AG903_SSC_INT3_ENABLE_UPPER_INTENABLE_POS)   /** SSCINT3_ENABLE_UPPER INTENABLE-bit mask */

#define AG903_SSC_CLKDUTY_GFX_DUTY_POS                     0                                                             /** SSCCLKDUTY_GFX DUTY-bit position */
#define AG903_SSC_CLKDUTY_GFX_DUTY_MSK                     (0xffUL << AG903_SSC_CLKDUTY_GFX_DUTY_POS)                    /** SSCCLKDUTY_GFX DUTY-bit mask */
#define AG903_SSC_CLKDUTY_GFX_VSON_POS                     8                                                             /** SSCCLKDUTY_GFX VSON-bit position */
#define AG903_SSC_CLKDUTY_GFX_VSON_MSK                     (0x1UL << AG903_SSC_CLKDUTY_GFX_VSON_POS)                     /** SSCCLKDUTY_GFX VSON-bit mask */

#define AG903_SSC_CLKDUTY_GVD_DUTY_POS                     0                                                             /** SSCCLKDUTY_GVD DUTY-bit position */
#define AG903_SSC_CLKDUTY_GVD_DUTY_MSK                     (0xffUL << AG903_SSC_CLKDUTY_GVD_DUTY_POS)                    /** SSCCLKDUTY_GVD DUTY-bit mask */

#define AG903_SSC_WDTOUT_INTMODE_LEVEL_POS                 0                                                             /** SSCWDTOUT_INTMODE LEVEL-bit position */
#define AG903_SSC_WDTOUT_INTMODE_LEVEL_MSK                 (0x1UL << AG903_SSC_WDTOUT_INTMODE_LEVEL_POS)                 /** SSCWDTOUT_INTMODE LEVEL-bit mask */

#define AG903_SSC_WDTOUT_INTCLEAR_CLEAR_POS                0                                                             /** SSCWDTOUT_INTCLEAR CLEAR-bit position */
#define AG903_SSC_WDTOUT_INTCLEAR_CLEAR_MSK                (0x1UL << AG903_SSC_WDTOUT_INTCLEAR_CLEAR_POS)                /** SSCWDTOUT_INTCLEAR CLEAR-bit mask */

#define AG903_SSC_WDTOUT_SETUP_OUT_POS                     0                                                             /** SSCWDTOUT_SETUP OUT-bit position */
#define AG903_SSC_WDTOUT_SETUP_OUT_MSK                     (0x1UL << AG903_SSC_WDTOUT_SETUP_OUT_POS)                     /** SSCWDTOUT_SETUP OUT-bit mask */
#define AG903_SSC_WDTOUT_SETUP_OD_POS                      1                                                             /** SSCWDTOUT_SETUP OD-bit position */
#define AG903_SSC_WDTOUT_SETUP_OD_MSK                      (0x1UL << AG903_SSC_WDTOUT_SETUP_OD_POS)                      /** SSCWDTOUT_SETUP OD-bit mask */
#define AG903_SSC_WDTOUT_SETUP_WDT_POS                     2                                                             /** SSCWDTOUT_SETUP WDT-bit position */
#define AG903_SSC_WDTOUT_SETUP_WDT_MSK                     (0x1UL << AG903_SSC_WDTOUT_SETUP_WDT_POS)                     /** SSCWDTOUT_SETUP WDT-bit mask */
#define AG903_SSC_WDTOUT_SETUP_INIT_POS                    3                                                             /** SSCWDTOUT_SETUP INIT-bit position */
#define AG903_SSC_WDTOUT_SETUP_INIT_MSK                    (0x1UL << AG903_SSC_WDTOUT_SETUP_INIT_POS)                    /** SSCWDTOUT_SETUP INIT-bit mask */

#define AG903_SSC_PIN_FUNC0_FUNC0_POS                      0                                                             /** SSCPIN_FUNC0 FUNC0-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC0_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC0_POS)                      /** SSCPIN_FUNC0 FUNC0-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC1_POS                      2                                                             /** SSCPIN_FUNC0 FUNC1-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC1_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC1_POS)                      /** SSCPIN_FUNC0 FUNC1-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC2_POS                      4                                                             /** SSCPIN_FUNC0 FUNC2-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC2_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC2_POS)                      /** SSCPIN_FUNC0 FUNC2-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC3_POS                      6                                                             /** SSCPIN_FUNC0 FUNC3-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC3_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC3_POS)                      /** SSCPIN_FUNC0 FUNC3-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC4_POS                      8                                                             /** SSCPIN_FUNC0 FUNC4-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC4_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC4_POS)                      /** SSCPIN_FUNC0 FUNC4-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC5_POS                      10                                                            /** SSCPIN_FUNC0 FUNC5-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC5_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC5_POS)                      /** SSCPIN_FUNC0 FUNC5-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC6_POS                      12                                                            /** SSCPIN_FUNC0 FUNC6-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC6_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC6_POS)                      /** SSCPIN_FUNC0 FUNC6-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC7_POS                      14                                                            /** SSCPIN_FUNC0 FUNC7-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC7_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC7_POS)                      /** SSCPIN_FUNC0 FUNC7-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC8_POS                      16                                                            /** SSCPIN_FUNC0 FUNC8-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC8_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC8_POS)                      /** SSCPIN_FUNC0 FUNC8-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC9_POS                      18                                                            /** SSCPIN_FUNC0 FUNC9-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC9_MSK                      (0x3UL << AG903_SSC_PIN_FUNC0_FUNC9_POS)                      /** SSCPIN_FUNC0 FUNC9-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC10_POS                     20                                                            /** SSCPIN_FUNC0 FUNC10-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC10_MSK                     (0x3UL << AG903_SSC_PIN_FUNC0_FUNC10_POS)                     /** SSCPIN_FUNC0 FUNC10-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC11_POS                     22                                                            /** SSCPIN_FUNC0 FUNC11-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC11_MSK                     (0x3UL << AG903_SSC_PIN_FUNC0_FUNC11_POS)                     /** SSCPIN_FUNC0 FUNC11-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC12_POS                     24                                                            /** SSCPIN_FUNC0 FUNC12-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC12_MSK                     (0x3UL << AG903_SSC_PIN_FUNC0_FUNC12_POS)                     /** SSCPIN_FUNC0 FUNC12-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC13_POS                     26                                                            /** SSCPIN_FUNC0 FUNC13-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC13_MSK                     (0x3UL << AG903_SSC_PIN_FUNC0_FUNC13_POS)                     /** SSCPIN_FUNC0 FUNC13-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC14_POS                     28                                                            /** SSCPIN_FUNC0 FUNC14-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC14_MSK                     (0x3UL << AG903_SSC_PIN_FUNC0_FUNC14_POS)                     /** SSCPIN_FUNC0 FUNC14-bit mask */
#define AG903_SSC_PIN_FUNC0_FUNC15_POS                     30                                                            /** SSCPIN_FUNC0 FUNC15-bit position */
#define AG903_SSC_PIN_FUNC0_FUNC15_MSK                     (0x3UL << AG903_SSC_PIN_FUNC0_FUNC15_POS)                     /** SSCPIN_FUNC0 FUNC15-bit mask */

#define AG903_SSC_PIN_FUNC1_FUNC16_POS                     0                                                             /** SSCPIN_FUNC1 FUNC16-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC16_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC16_POS)                     /** SSCPIN_FUNC1 FUNC16-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC17_POS                     2                                                             /** SSCPIN_FUNC1 FUNC17-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC17_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC17_POS)                     /** SSCPIN_FUNC1 FUNC17-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC18_POS                     4                                                             /** SSCPIN_FUNC1 FUNC18-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC18_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC18_POS)                     /** SSCPIN_FUNC1 FUNC18-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC19_POS                     6                                                             /** SSCPIN_FUNC1 FUNC19-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC19_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC19_POS)                     /** SSCPIN_FUNC1 FUNC19-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC20_POS                     8                                                             /** SSCPIN_FUNC1 FUNC20-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC20_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC20_POS)                     /** SSCPIN_FUNC1 FUNC20-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC21_POS                     10                                                            /** SSCPIN_FUNC1 FUNC21-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC21_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC21_POS)                     /** SSCPIN_FUNC1 FUNC21-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC22_POS                     12                                                            /** SSCPIN_FUNC1 FUNC22-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC22_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC22_POS)                     /** SSCPIN_FUNC1 FUNC22-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC23_POS                     14                                                            /** SSCPIN_FUNC1 FUNC23-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC23_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC23_POS)                     /** SSCPIN_FUNC1 FUNC23-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC24_POS                     16                                                            /** SSCPIN_FUNC1 FUNC24-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC24_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC24_POS)                     /** SSCPIN_FUNC1 FUNC24-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC25_POS                     18                                                            /** SSCPIN_FUNC1 FUNC25-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC25_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC25_POS)                     /** SSCPIN_FUNC1 FUNC25-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC26_POS                     20                                                            /** SSCPIN_FUNC1 FUNC26-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC26_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC26_POS)                     /** SSCPIN_FUNC1 FUNC26-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC27_POS                     22                                                            /** SSCPIN_FUNC1 FUNC27-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC27_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC27_POS)                     /** SSCPIN_FUNC1 FUNC27-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC28_POS                     24                                                            /** SSCPIN_FUNC1 FUNC28-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC28_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC28_POS)                     /** SSCPIN_FUNC1 FUNC28-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC29_POS                     26                                                            /** SSCPIN_FUNC1 FUNC29-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC29_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC29_POS)                     /** SSCPIN_FUNC1 FUNC29-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC30_POS                     28                                                            /** SSCPIN_FUNC1 FUNC30-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC30_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC30_POS)                     /** SSCPIN_FUNC1 FUNC30-bit mask */
#define AG903_SSC_PIN_FUNC1_FUNC31_POS                     30                                                            /** SSCPIN_FUNC1 FUNC31-bit position */
#define AG903_SSC_PIN_FUNC1_FUNC31_MSK                     (0x3UL << AG903_SSC_PIN_FUNC1_FUNC31_POS)                     /** SSCPIN_FUNC1 FUNC31-bit mask */

#define AG903_SSC_PIN_SETUP_INDEX_INDEX_POS                0                                                             /** SSCPIN_SETUP_INDEX INDEX-bit position */
#define AG903_SSC_PIN_SETUP_INDEX_INDEX_MSK                (0xffUL << AG903_SSC_PIN_SETUP_INDEX_INDEX_POS)               /** SSCPIN_SETUP_INDEX INDEX-bit mask */

#define AG903_SSC_PIN_SETUP_DATA_SETUP_POS                 0                                                             /** SSCPIN_SETUP_DATA SETUP-bit position */
#define AG903_SSC_PIN_SETUP_DATA_SETUP_MSK                 (0xffUL << AG903_SSC_PIN_SETUP_DATA_SETUP_POS)                /** SSCPIN_SETUP_DATA SETUP-bit mask */

#define AG903_SSC_PIN_GPIO_ENABLE_GPIOENABLE_POS           0                                                             /** SSCPIN_GPIO_ENABLE GPIOENABLE-bit position */
#define AG903_SSC_PIN_GPIO_ENABLE_GPIOENABLE_MSK           (0xffffffffUL << AG903_SSC_PIN_GPIO_ENABLE_GPIOENABLE_POS)    /** SSCPIN_GPIO_ENABLE GPIOENABLE-bit mask */

#define AG903_SSC_PIN_GPIO_PIN_PU_GPIOPINPU_POS            0                                                             /** SSCPIN_GPIO_PIN_PU GPIOPINPU-bit position */
#define AG903_SSC_PIN_GPIO_PIN_PU_GPIOPINPU_MSK            (0xffffffffUL << AG903_SSC_PIN_GPIO_PIN_PU_GPIOPINPU_POS)     /** SSCPIN_GPIO_PIN_PU GPIOPINPU-bit mask */

#define AG903_SSC_PIN_GPIO_PIN_PD_GPIOPINPD_POS            0                                                             /** SSCPIN_GPIO_PIN_PD GPIOPINPD-bit position */
#define AG903_SSC_PIN_GPIO_PIN_PD_GPIOPINPD_MSK            (0xffffffffUL << AG903_SSC_PIN_GPIO_PIN_PD_GPIOPINPD_POS)     /** SSCPIN_GPIO_PIN_PD GPIOPINPD-bit mask */

#define AG903_SSC_CA5_RUN_SETUP_GCLK_POS                   0                                                             /** SSCCA5_RUN_SETUP GCLK-bit position */
#define AG903_SSC_CA5_RUN_SETUP_GCLK_MSK                   (0x1UL << AG903_SSC_CA5_RUN_SETUP_GCLK_POS)                   /** SSCCA5_RUN_SETUP GCLK-bit mask */
#define AG903_SSC_CA5_RUN_SETUP_RESET_POS                  1                                                             /** SSCCA5_RUN_SETUP RESET-bit position */
#define AG903_SSC_CA5_RUN_SETUP_RESET_MSK                  (0x1UL << AG903_SSC_CA5_RUN_SETUP_RESET_POS)                  /** SSCCA5_RUN_SETUP RESET-bit mask */
#define AG903_SSC_CA5_RUN_SETUP_VINITHI_POS                4                                                             /** SSCCA5_RUN_SETUP VINITHI-bit position */
#define AG903_SSC_CA5_RUN_SETUP_VINITHI_MSK                (0x1UL << AG903_SSC_CA5_RUN_SETUP_VINITHI_POS)                /** SSCCA5_RUN_SETUP VINITHI-bit mask */

#define AG903_SSC_CA5_RUN_CTRL_CLREV_POS                   16                                                            /** SSCCA5_RUN_CTRL CLREV-bit position */
#define AG903_SSC_CA5_RUN_CTRL_CLREV_MSK                   (0x1UL << AG903_SSC_CA5_RUN_CTRL_CLREV_POS)                   /** SSCCA5_RUN_CTRL CLREV-bit mask */

#define AG903_SSC_CA5_RUN_STATUS_GCLK_POS                  0                                                             /** SSCCA5_RUN_STATUS GCLK-bit position */
#define AG903_SSC_CA5_RUN_STATUS_GCLK_MSK                  (0x1UL << AG903_SSC_CA5_RUN_STATUS_GCLK_POS)                  /** SSCCA5_RUN_STATUS GCLK-bit mask */
#define AG903_SSC_CA5_RUN_STATUS_RESET_POS                 1                                                             /** SSCCA5_RUN_STATUS RESET-bit position */
#define AG903_SSC_CA5_RUN_STATUS_RESET_MSK                 (0x1UL << AG903_SSC_CA5_RUN_STATUS_RESET_POS)                 /** SSCCA5_RUN_STATUS RESET-bit mask */
#define AG903_SSC_CA5_RUN_STATUS_WFE_POS                   8                                                             /** SSCCA5_RUN_STATUS WFE-bit position */
#define AG903_SSC_CA5_RUN_STATUS_WFE_MSK                   (0x1UL << AG903_SSC_CA5_RUN_STATUS_WFE_POS)                   /** SSCCA5_RUN_STATUS WFE-bit mask */
#define AG903_SSC_CA5_RUN_STATUS_WFI_POS                   12                                                            /** SSCCA5_RUN_STATUS WFI-bit position */
#define AG903_SSC_CA5_RUN_STATUS_WFI_MSK                   (0x1UL << AG903_SSC_CA5_RUN_STATUS_WFI_POS)                   /** SSCCA5_RUN_STATUS WFI-bit mask */
#define AG903_SSC_CA5_RUN_STATUS_EVENTO_POS                16                                                            /** SSCCA5_RUN_STATUS EVENTO-bit position */
#define AG903_SSC_CA5_RUN_STATUS_EVENTO_MSK                (0x1UL << AG903_SSC_CA5_RUN_STATUS_EVENTO_POS)                /** SSCCA5_RUN_STATUS EVENTO-bit mask */

#define AG903_SSC_CA5_ACP_SETUP_ACPADDR_POS                29                                                            /** SSCCA5_ACP_SETUP ACPADDR-bit position */
#define AG903_SSC_CA5_ACP_SETUP_ACPADDR_MSK                (0x7UL << AG903_SSC_CA5_ACP_SETUP_ACPADDR_POS)                /** SSCCA5_ACP_SETUP ACPADDR-bit mask */

#define AG903_SSC_DMA_SELECT0_DMASELECT0_POS               0                                                             /** SSCDMA_SELECT0 DMASELECT0-bit position */
#define AG903_SSC_DMA_SELECT0_DMASELECT0_MSK               (0xffUL << AG903_SSC_DMA_SELECT0_DMASELECT0_POS)              /** SSCDMA_SELECT0 DMASELECT0-bit mask */
#define AG903_SSC_DMA_SELECT0_DMASELECT1_POS               8                                                             /** SSCDMA_SELECT0 DMASELECT1-bit position */
#define AG903_SSC_DMA_SELECT0_DMASELECT1_MSK               (0xffUL << AG903_SSC_DMA_SELECT0_DMASELECT1_POS)              /** SSCDMA_SELECT0 DMASELECT1-bit mask */
#define AG903_SSC_DMA_SELECT0_DMASELECT2_POS               16                                                            /** SSCDMA_SELECT0 DMASELECT2-bit position */
#define AG903_SSC_DMA_SELECT0_DMASELECT2_MSK               (0xffUL << AG903_SSC_DMA_SELECT0_DMASELECT2_POS)              /** SSCDMA_SELECT0 DMASELECT2-bit mask */
#define AG903_SSC_DMA_SELECT0_DMASELECT3_POS               24                                                            /** SSCDMA_SELECT0 DMASELECT3-bit position */
#define AG903_SSC_DMA_SELECT0_DMASELECT3_MSK               (0xffUL << AG903_SSC_DMA_SELECT0_DMASELECT3_POS)              /** SSCDMA_SELECT0 DMASELECT3-bit mask */

#define AG903_SSC_DMA_SELECT1_DMASELECT4_POS               0                                                             /** SSCDMA_SELECT1 DMASELECT4-bit position */
#define AG903_SSC_DMA_SELECT1_DMASELECT4_MSK               (0xffUL << AG903_SSC_DMA_SELECT1_DMASELECT4_POS)              /** SSCDMA_SELECT1 DMASELECT4-bit mask */
#define AG903_SSC_DMA_SELECT1_DMASELECT5_POS               8                                                             /** SSCDMA_SELECT1 DMASELECT5-bit position */
#define AG903_SSC_DMA_SELECT1_DMASELECT5_MSK               (0xffUL << AG903_SSC_DMA_SELECT1_DMASELECT5_POS)              /** SSCDMA_SELECT1 DMASELECT5-bit mask */
#define AG903_SSC_DMA_SELECT1_DMASELECT6_POS               16                                                            /** SSCDMA_SELECT1 DMASELECT6-bit position */
#define AG903_SSC_DMA_SELECT1_DMASELECT6_MSK               (0xffUL << AG903_SSC_DMA_SELECT1_DMASELECT6_POS)              /** SSCDMA_SELECT1 DMASELECT6-bit mask */
#define AG903_SSC_DMA_SELECT1_DMASELECT7_POS               24                                                            /** SSCDMA_SELECT1 DMASELECT7-bit position */
#define AG903_SSC_DMA_SELECT1_DMASELECT7_MSK               (0xffUL << AG903_SSC_DMA_SELECT1_DMASELECT7_POS)              /** SSCDMA_SELECT1 DMASELECT7-bit mask */

#define AG903_SSC_DMA_SELECT2_DMASELECT8_POS               0                                                             /** SSCDMA_SELECT2 DMASELECT8-bit position */
#define AG903_SSC_DMA_SELECT2_DMASELECT8_MSK               (0xffUL << AG903_SSC_DMA_SELECT2_DMASELECT8_POS)              /** SSCDMA_SELECT2 DMASELECT8-bit mask */
#define AG903_SSC_DMA_SELECT2_DMASELECT9_POS               8                                                             /** SSCDMA_SELECT2 DMASELECT9-bit position */
#define AG903_SSC_DMA_SELECT2_DMASELECT9_MSK               (0xffUL << AG903_SSC_DMA_SELECT2_DMASELECT9_POS)              /** SSCDMA_SELECT2 DMASELECT9-bit mask */
#define AG903_SSC_DMA_SELECT2_DMASELECT10_POS              16                                                            /** SSCDMA_SELECT2 DMASELECT10-bit position */
#define AG903_SSC_DMA_SELECT2_DMASELECT10_MSK              (0xffUL << AG903_SSC_DMA_SELECT2_DMASELECT10_POS)             /** SSCDMA_SELECT2 DMASELECT10-bit mask */
#define AG903_SSC_DMA_SELECT2_DMASELECT11_POS              24                                                            /** SSCDMA_SELECT2 DMASELECT11-bit position */
#define AG903_SSC_DMA_SELECT2_DMASELECT11_MSK              (0xffUL << AG903_SSC_DMA_SELECT2_DMASELECT11_POS)             /** SSCDMA_SELECT2 DMASELECT11-bit mask */

#define AG903_SSC_DMA_SELECT3_DMASELECT12_POS              0                                                             /** SSCDMA_SELECT3 DMASELECT12-bit position */
#define AG903_SSC_DMA_SELECT3_DMASELECT12_MSK              (0xffUL << AG903_SSC_DMA_SELECT3_DMASELECT12_POS)             /** SSCDMA_SELECT3 DMASELECT12-bit mask */
#define AG903_SSC_DMA_SELECT3_DMASELECT13_POS              8                                                             /** SSCDMA_SELECT3 DMASELECT13-bit position */
#define AG903_SSC_DMA_SELECT3_DMASELECT13_MSK              (0xffUL << AG903_SSC_DMA_SELECT3_DMASELECT13_POS)             /** SSCDMA_SELECT3 DMASELECT13-bit mask */
#define AG903_SSC_DMA_SELECT3_DMASELECT14_POS              16                                                            /** SSCDMA_SELECT3 DMASELECT14-bit position */
#define AG903_SSC_DMA_SELECT3_DMASELECT14_MSK              (0xffUL << AG903_SSC_DMA_SELECT3_DMASELECT14_POS)             /** SSCDMA_SELECT3 DMASELECT14-bit mask */
#define AG903_SSC_DMA_SELECT3_DMASELECT15_POS              24                                                            /** SSCDMA_SELECT3 DMASELECT15-bit position */
#define AG903_SSC_DMA_SELECT3_DMASELECT15_MSK              (0xffUL << AG903_SSC_DMA_SELECT3_DMASELECT15_POS)             /** SSCDMA_SELECT3 DMASELECT15-bit mask */

#define AG903_SSC_DMA_SELECT_PBD_DMASELECT_POS             0                                                             /** SSCDMA_SELECT_PBD DMASELECT-bit position */
#define AG903_SSC_DMA_SELECT_PBD_DMASELECT_MSK             (0xffUL << AG903_SSC_DMA_SELECT_PBD_DMASELECT_POS)            /** SSCDMA_SELECT_PBD DMASELECT-bit mask */

#define AG903_SSC_DSP_SETUP_VSYNC0_DIR_POS                 0                                                             /** SSCDSP_SETUP VSYNC0_DIR-bit position */
#define AG903_SSC_DSP_SETUP_VSYNC0_DIR_MSK                 (0x1UL << AG903_SSC_DSP_SETUP_VSYNC0_DIR_POS)                 /** SSCDSP_SETUP VSYNC0_DIR-bit mask */
#define AG903_SSC_DSP_SETUP_FIELD0_DIR_POS                 1                                                             /** SSCDSP_SETUP FIELD0_DIR-bit position */
#define AG903_SSC_DSP_SETUP_FIELD0_DIR_MSK                 (0x1UL << AG903_SSC_DSP_SETUP_FIELD0_DIR_POS)                 /** SSCDSP_SETUP FIELD0_DIR-bit mask */
#define AG903_SSC_DSP_SETUP_DOT0_DIR_POS                   2                                                             /** SSCDSP_SETUP DOT0_DIR-bit position */
#define AG903_SSC_DSP_SETUP_DOT0_DIR_MSK                   (0x1UL << AG903_SSC_DSP_SETUP_DOT0_DIR_POS)                   /** SSCDSP_SETUP DOT0_DIR-bit mask */
#define AG903_SSC_DSP_SETUP_VSYNC1_DIR_POS                 4                                                             /** SSCDSP_SETUP VSYNC1_DIR-bit position */
#define AG903_SSC_DSP_SETUP_VSYNC1_DIR_MSK                 (0x1UL << AG903_SSC_DSP_SETUP_VSYNC1_DIR_POS)                 /** SSCDSP_SETUP VSYNC1_DIR-bit mask */
#define AG903_SSC_DSP_SETUP_FIELD1_DIR_POS                 5                                                             /** SSCDSP_SETUP FIELD1_DIR-bit position */
#define AG903_SSC_DSP_SETUP_FIELD1_DIR_MSK                 (0x1UL << AG903_SSC_DSP_SETUP_FIELD1_DIR_POS)                 /** SSCDSP_SETUP FIELD1_DIR-bit mask */
#define AG903_SSC_DSP_SETUP_DOT1_DIR_POS                   6                                                             /** SSCDSP_SETUP DOT1_DIR-bit position */
#define AG903_SSC_DSP_SETUP_DOT1_DIR_MSK                   (0x1UL << AG903_SSC_DSP_SETUP_DOT1_DIR_POS)                   /** SSCDSP_SETUP DOT1_DIR-bit mask */

#define AG903_SSC_TICK0_SETUP_DIVNUM_POS                   0                                                             /** SSCTICK0_SETUP DIVNUM-bit position */
#define AG903_SSC_TICK0_SETUP_DIVNUM_MSK                   (0xffffffUL << AG903_SSC_TICK0_SETUP_DIVNUM_POS)              /** SSCTICK0_SETUP DIVNUM-bit mask */
#define AG903_SSC_TICK0_SETUP_CLKSEL_POS                   24                                                            /** SSCTICK0_SETUP CLKSEL-bit position */
#define AG903_SSC_TICK0_SETUP_CLKSEL_MSK                   (0xfUL << AG903_SSC_TICK0_SETUP_CLKSEL_POS)                   /** SSCTICK0_SETUP CLKSEL-bit mask */

#define AG903_SSC_TICK1_SETUP_DIVNUM_POS                   0                                                             /** SSCTICK1_SETUP DIVNUM-bit position */
#define AG903_SSC_TICK1_SETUP_DIVNUM_MSK                   (0xffffffUL << AG903_SSC_TICK1_SETUP_DIVNUM_POS)              /** SSCTICK1_SETUP DIVNUM-bit mask */
#define AG903_SSC_TICK1_SETUP_CLKSEL_POS                   24                                                            /** SSCTICK1_SETUP CLKSEL-bit position */
#define AG903_SSC_TICK1_SETUP_CLKSEL_MSK                   (0xfUL << AG903_SSC_TICK1_SETUP_CLKSEL_POS)                   /** SSCTICK1_SETUP CLKSEL-bit mask */

#define AG903_SSC_TIM_SETUP_TIM_DIR_POS                    0                                                             /** SSCTIM_SETUP TIM_DIR-bit position */
#define AG903_SSC_TIM_SETUP_TIM_DIR_MSK                    (0xfUL << AG903_SSC_TIM_SETUP_TIM_DIR_POS)                    /** SSCTIM_SETUP TIM_DIR-bit mask */

#define AG903_SSC_SSP_SETUP_SSP0_DIR_POS                   0                                                             /** SSCSSP_SETUP SSP0_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP0_DIR_MSK                   (0x1UL << AG903_SSC_SSP_SETUP_SSP0_DIR_POS)                   /** SSCSSP_SETUP SSP0_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP0_MODE_POS                  1                                                             /** SSCSSP_SETUP SSP0_MODE-bit position */
#define AG903_SSC_SSP_SETUP_SSP0_MODE_MSK                  (0x1UL << AG903_SSC_SSP_SETUP_SSP0_MODE_POS)                  /** SSCSSP_SETUP SSP0_MODE-bit mask */
#define AG903_SSC_SSP_SETUP_SSP0_MCLK_DIR_POS              2                                                             /** SSCSSP_SETUP SSP0_MCLK_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP0_MCLK_DIR_MSK              (0x1UL << AG903_SSC_SSP_SETUP_SSP0_MCLK_DIR_POS)              /** SSCSSP_SETUP SSP0_MCLK_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP0_MCLK_DIV_POS              3                                                             /** SSCSSP_SETUP SSP0_MCLK_DIV-bit position */
#define AG903_SSC_SSP_SETUP_SSP0_MCLK_DIV_MSK              (0x1fUL << AG903_SSC_SSP_SETUP_SSP0_MCLK_DIV_POS)             /** SSCSSP_SETUP SSP0_MCLK_DIV-bit mask */
#define AG903_SSC_SSP_SETUP_SSP1_DIR_POS                   8                                                             /** SSCSSP_SETUP SSP1_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP1_DIR_MSK                   (0x1UL << AG903_SSC_SSP_SETUP_SSP1_DIR_POS)                   /** SSCSSP_SETUP SSP1_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP1_MODE_POS                  9                                                             /** SSCSSP_SETUP SSP1_MODE-bit position */
#define AG903_SSC_SSP_SETUP_SSP1_MODE_MSK                  (0x1UL << AG903_SSC_SSP_SETUP_SSP1_MODE_POS)                  /** SSCSSP_SETUP SSP1_MODE-bit mask */
#define AG903_SSC_SSP_SETUP_SSP1_MCLK_DIR_POS              10                                                            /** SSCSSP_SETUP SSP1_MCLK_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP1_MCLK_DIR_MSK              (0x1UL << AG903_SSC_SSP_SETUP_SSP1_MCLK_DIR_POS)              /** SSCSSP_SETUP SSP1_MCLK_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP1_MCLK_DIV_POS              11                                                            /** SSCSSP_SETUP SSP1_MCLK_DIV-bit position */
#define AG903_SSC_SSP_SETUP_SSP1_MCLK_DIV_MSK              (0x1fUL << AG903_SSC_SSP_SETUP_SSP1_MCLK_DIV_POS)             /** SSCSSP_SETUP SSP1_MCLK_DIV-bit mask */
#define AG903_SSC_SSP_SETUP_SSP2_DIR_POS                   16                                                            /** SSCSSP_SETUP SSP2_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP2_DIR_MSK                   (0x1UL << AG903_SSC_SSP_SETUP_SSP2_DIR_POS)                   /** SSCSSP_SETUP SSP2_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP2_MODE_POS                  17                                                            /** SSCSSP_SETUP SSP2_MODE-bit position */
#define AG903_SSC_SSP_SETUP_SSP2_MODE_MSK                  (0x1UL << AG903_SSC_SSP_SETUP_SSP2_MODE_POS)                  /** SSCSSP_SETUP SSP2_MODE-bit mask */
#define AG903_SSC_SSP_SETUP_SSP2_MCLK_DIR_POS              18                                                            /** SSCSSP_SETUP SSP2_MCLK_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP2_MCLK_DIR_MSK              (0x1UL << AG903_SSC_SSP_SETUP_SSP2_MCLK_DIR_POS)              /** SSCSSP_SETUP SSP2_MCLK_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP2_MCLK_DIV_POS              19                                                            /** SSCSSP_SETUP SSP2_MCLK_DIV-bit position */
#define AG903_SSC_SSP_SETUP_SSP2_MCLK_DIV_MSK              (0x1fUL << AG903_SSC_SSP_SETUP_SSP2_MCLK_DIV_POS)             /** SSCSSP_SETUP SSP2_MCLK_DIV-bit mask */
#define AG903_SSC_SSP_SETUP_SSP3_DIR_POS                   24                                                            /** SSCSSP_SETUP SSP3_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP3_DIR_MSK                   (0x1UL << AG903_SSC_SSP_SETUP_SSP3_DIR_POS)                   /** SSCSSP_SETUP SSP3_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP3_MODE_POS                  25                                                            /** SSCSSP_SETUP SSP3_MODE-bit position */
#define AG903_SSC_SSP_SETUP_SSP3_MODE_MSK                  (0x1UL << AG903_SSC_SSP_SETUP_SSP3_MODE_POS)                  /** SSCSSP_SETUP SSP3_MODE-bit mask */
#define AG903_SSC_SSP_SETUP_SSP3_MCLK_DIR_POS              26                                                            /** SSCSSP_SETUP SSP3_MCLK_DIR-bit position */
#define AG903_SSC_SSP_SETUP_SSP3_MCLK_DIR_MSK              (0x1UL << AG903_SSC_SSP_SETUP_SSP3_MCLK_DIR_POS)              /** SSCSSP_SETUP SSP3_MCLK_DIR-bit mask */
#define AG903_SSC_SSP_SETUP_SSP3_MCLK_DIV_POS              27                                                            /** SSCSSP_SETUP SSP3_MCLK_DIV-bit position */
#define AG903_SSC_SSP_SETUP_SSP3_MCLK_DIV_MSK              (0x1fUL << AG903_SSC_SSP_SETUP_SSP3_MCLK_DIV_POS)             /** SSCSSP_SETUP SSP3_MCLK_DIV-bit mask */

#define AG903_SSC_PBD_ADDRCHECK_START_START_ADDR_POS       2                                                             /** SSCPBD_ADDRCHECK_START START_ADDR-bit position */
#define AG903_SSC_PBD_ADDRCHECK_START_START_ADDR_MSK       (0x3fffffffUL << AG903_SSC_PBD_ADDRCHECK_START_START_ADDR_POS) /** SSCPBD_ADDRCHECK_START START_ADDR-bit mask */

#define AG903_SSC_PBD_ADDRCHECK_END_END_ADDR_POS           2                                                             /** SSCPBD_ADDRCHECK_END END_ADDR-bit position */
#define AG903_SSC_PBD_ADDRCHECK_END_END_ADDR_MSK           (0x3fffffffUL << AG903_SSC_PBD_ADDRCHECK_END_END_ADDR_POS)    /** SSCPBD_ADDRCHECK_END END_ADDR-bit mask */

#define AG903_SSC_PBD_ADDRCHECK_ENABLE_ENABLE_POS          0                                                             /** SSCPBD_ADDRCHECK_ENABLE ENABLE-bit position */
#define AG903_SSC_PBD_ADDRCHECK_ENABLE_ENABLE_MSK          (0x1UL << AG903_SSC_PBD_ADDRCHECK_ENABLE_ENABLE_POS)          /** SSCPBD_ADDRCHECK_ENABLE ENABLE-bit mask */

#define AG903_SSC_PBD_ADDRCHECK_STATUS_STATUS_POS          0                                                             /** SSCPBD_ADDRCHECK_STATUS STATUS-bit position */
#define AG903_SSC_PBD_ADDRCHECK_STATUS_STATUS_MSK          (0x1UL << AG903_SSC_PBD_ADDRCHECK_STATUS_STATUS_POS)          /** SSCPBD_ADDRCHECK_STATUS STATUS-bit mask */

#define AG903_SSC_BMU_STATUS_SNKRDY_POS                    0                                                             /** SSCBMU_STATUS SNKRDY-bit position */
#define AG903_SSC_BMU_STATUS_SNKRDY_MSK                    (0xfUL << AG903_SSC_BMU_STATUS_SNKRDY_POS)                    /** SSCBMU_STATUS SNKRDY-bit mask */
#define AG903_SSC_BMU_STATUS_SNKREQ_POS                    4                                                             /** SSCBMU_STATUS SNKREQ-bit position */
#define AG903_SSC_BMU_STATUS_SNKREQ_MSK                    (0xfUL << AG903_SSC_BMU_STATUS_SNKREQ_POS)                    /** SSCBMU_STATUS SNKREQ-bit mask */
#define AG903_SSC_BMU_STATUS_SRCRDY_POS                    8                                                             /** SSCBMU_STATUS SRCRDY-bit position */
#define AG903_SSC_BMU_STATUS_SRCRDY_MSK                    (0x7ffUL << AG903_SSC_BMU_STATUS_SRCRDY_POS)                  /** SSCBMU_STATUS SRCRDY-bit mask */
#define AG903_SSC_BMU_STATUS_SRCREQ_POS                    20                                                            /** SSCBMU_STATUS SRCREQ-bit position */
#define AG903_SSC_BMU_STATUS_SRCREQ_MSK                    (0x7ffUL << AG903_SSC_BMU_STATUS_SRCREQ_POS)                  /** SSCBMU_STATUS SRCREQ-bit mask */

#define AG903_SSC_BMU_CONTROL_CLR_SNK_POS                  0                                                             /** SSCBMU_CONTROL CLR_SNK-bit position */
#define AG903_SSC_BMU_CONTROL_CLR_SNK_MSK                  (0xfUL << AG903_SSC_BMU_CONTROL_CLR_SNK_POS)                  /** SSCBMU_CONTROL CLR_SNK-bit mask */
#define AG903_SSC_BMU_CONTROL_SET_SNK_POS                  4                                                             /** SSCBMU_CONTROL SET_SNK-bit position */
#define AG903_SSC_BMU_CONTROL_SET_SNK_MSK                  (0xfUL << AG903_SSC_BMU_CONTROL_SET_SNK_POS)                  /** SSCBMU_CONTROL SET_SNK-bit mask */
#define AG903_SSC_BMU_CONTROL_CLR_SRC_POS                  8                                                             /** SSCBMU_CONTROL CLR_SRC-bit position */
#define AG903_SSC_BMU_CONTROL_CLR_SRC_MSK                  (0x7ffUL << AG903_SSC_BMU_CONTROL_CLR_SRC_POS)                /** SSCBMU_CONTROL CLR_SRC-bit mask */
#define AG903_SSC_BMU_CONTROL_SET_SRC_POS                  20                                                            /** SSCBMU_CONTROL SET_SRC-bit position */
#define AG903_SSC_BMU_CONTROL_SET_SRC_MSK                  (0x7ffUL << AG903_SSC_BMU_CONTROL_SET_SRC_POS)                /** SSCBMU_CONTROL SET_SRC-bit mask */

#define AG903_SSC_BMU_TRIG_STATUS_SNKRDY_POS               0                                                             /** SSCBMU_TRIG_STATUS SNKRDY-bit position */
#define AG903_SSC_BMU_TRIG_STATUS_SNKRDY_MSK               (0xfUL << AG903_SSC_BMU_TRIG_STATUS_SNKRDY_POS)               /** SSCBMU_TRIG_STATUS SNKRDY-bit mask */
#define AG903_SSC_BMU_TRIG_STATUS_SNKREQ_POS               4                                                             /** SSCBMU_TRIG_STATUS SNKREQ-bit position */
#define AG903_SSC_BMU_TRIG_STATUS_SNKREQ_MSK               (0xfUL << AG903_SSC_BMU_TRIG_STATUS_SNKREQ_POS)               /** SSCBMU_TRIG_STATUS SNKREQ-bit mask */
#define AG903_SSC_BMU_TRIG_STATUS_SRCRDY_POS               8                                                             /** SSCBMU_TRIG_STATUS SRCRDY-bit position */
#define AG903_SSC_BMU_TRIG_STATUS_SRCRDY_MSK               (0x7ffUL << AG903_SSC_BMU_TRIG_STATUS_SRCRDY_POS)             /** SSCBMU_TRIG_STATUS SRCRDY-bit mask */
#define AG903_SSC_BMU_TRIG_STATUS_SRCREQ_POS               20                                                            /** SSCBMU_TRIG_STATUS SRCREQ-bit position */
#define AG903_SSC_BMU_TRIG_STATUS_SRCREQ_MSK               (0x7ffUL << AG903_SSC_BMU_TRIG_STATUS_SRCREQ_POS)             /** SSCBMU_TRIG_STATUS SRCREQ-bit mask */

#define AG903_SSC_BMU_TRIG_CLEAR_SNKRDY_POS                0                                                             /** SSCBMU_TRIG_CLEAR SNKRDY-bit position */
#define AG903_SSC_BMU_TRIG_CLEAR_SNKRDY_MSK                (0xfUL << AG903_SSC_BMU_TRIG_CLEAR_SNKRDY_POS)                /** SSCBMU_TRIG_CLEAR SNKRDY-bit mask */
#define AG903_SSC_BMU_TRIG_CLEAR_SNKREQ_POS                4                                                             /** SSCBMU_TRIG_CLEAR SNKREQ-bit position */
#define AG903_SSC_BMU_TRIG_CLEAR_SNKREQ_MSK                (0xfUL << AG903_SSC_BMU_TRIG_CLEAR_SNKREQ_POS)                /** SSCBMU_TRIG_CLEAR SNKREQ-bit mask */
#define AG903_SSC_BMU_TRIG_CLEAR_SRCRDY_POS                8                                                             /** SSCBMU_TRIG_CLEAR SRCRDY-bit position */
#define AG903_SSC_BMU_TRIG_CLEAR_SRCRDY_MSK                (0x7ffUL << AG903_SSC_BMU_TRIG_CLEAR_SRCRDY_POS)              /** SSCBMU_TRIG_CLEAR SRCRDY-bit mask */
#define AG903_SSC_BMU_TRIG_CLEAR_SRCREQ_POS                20                                                            /** SSCBMU_TRIG_CLEAR SRCREQ-bit position */
#define AG903_SSC_BMU_TRIG_CLEAR_SRCREQ_MSK                (0x7ffUL << AG903_SSC_BMU_TRIG_CLEAR_SRCREQ_POS)              /** SSCBMU_TRIG_CLEAR SRCREQ-bit mask */

#define AG903_SSC_PORT_WAIT_CYCLE_POS                      0                                                             /** SSCPORT_WAIT CYCLE-bit position */
#define AG903_SSC_PORT_WAIT_CYCLE_MSK                      (0xffffUL << AG903_SSC_PORT_WAIT_CYCLE_POS)                   /** SSCPORT_WAIT CYCLE-bit mask */

#define AG903_SSC_PBH_MODE_WAIT_POS                        1                                                             /** SSCPBH_MODE WAIT-bit position */
#define AG903_SSC_PBH_MODE_WAIT_MSK                        (0x1UL << AG903_SSC_PBH_MODE_WAIT_POS)                        /** SSCPBH_MODE WAIT-bit mask */

#define AG903_SSC_TDM0_SETUP_ST_RX_POS                     0                                                             /** SSCTDM0_SETUP ST_RX-bit position */
#define AG903_SSC_TDM0_SETUP_ST_RX_MSK                     (0x1UL << AG903_SSC_TDM0_SETUP_ST_RX_POS)                     /** SSCTDM0_SETUP ST_RX-bit mask */
#define AG903_SSC_TDM0_SETUP_ST_TX_POS                     1                                                             /** SSCTDM0_SETUP ST_TX-bit position */
#define AG903_SSC_TDM0_SETUP_ST_TX_MSK                     (0x1UL << AG903_SSC_TDM0_SETUP_ST_TX_POS)                     /** SSCTDM0_SETUP ST_TX-bit mask */
#define AG903_SSC_TDM0_SETUP_SCLK_N_POS                    2                                                             /** SSCTDM0_SETUP SCLK_N-bit position */
#define AG903_SSC_TDM0_SETUP_SCLK_N_MSK                    (0x7UL << AG903_SSC_TDM0_SETUP_SCLK_N_POS)                    /** SSCTDM0_SETUP SCLK_N-bit mask */
#define AG903_SSC_TDM0_SETUP_TDM_N_POS                     5                                                             /** SSCTDM0_SETUP TDM_N-bit position */
#define AG903_SSC_TDM0_SETUP_TDM_N_MSK                     (0x3UL << AG903_SSC_TDM0_SETUP_TDM_N_POS)                     /** SSCTDM0_SETUP TDM_N-bit mask */
#define AG903_SSC_TDM0_SETUP_DIR_TX_POS                    7                                                             /** SSCTDM0_SETUP DIR_TX-bit position */
#define AG903_SSC_TDM0_SETUP_DIR_TX_MSK                    (0x1UL << AG903_SSC_TDM0_SETUP_DIR_TX_POS)                    /** SSCTDM0_SETUP DIR_TX-bit mask */
#define AG903_SSC_TDM0_SETUP_FS_RXERR_POS                  8                                                             /** SSCTDM0_SETUP FS_RXERR-bit position */
#define AG903_SSC_TDM0_SETUP_FS_RXERR_MSK                  (0x1UL << AG903_SSC_TDM0_SETUP_FS_RXERR_POS)                  /** SSCTDM0_SETUP FS_RXERR-bit mask */
#define AG903_SSC_TDM0_SETUP_FS_DIST_POS                   9                                                             /** SSCTDM0_SETUP FS_DIST-bit position */
#define AG903_SSC_TDM0_SETUP_FS_DIST_MSK                   (0x1UL << AG903_SSC_TDM0_SETUP_FS_DIST_POS)                   /** SSCTDM0_SETUP FS_DIST-bit mask */
#define AG903_SSC_TDM0_SETUP_FS_TXPW_POS                   10                                                            /** SSCTDM0_SETUP FS_TXPW-bit position */
#define AG903_SSC_TDM0_SETUP_FS_TXPW_MSK                   (0x1UL << AG903_SSC_TDM0_SETUP_FS_TXPW_POS)                   /** SSCTDM0_SETUP FS_TXPW-bit mask */
#define AG903_SSC_TDM0_SETUP_FS_POL_POS                    11                                                            /** SSCTDM0_SETUP FS_POL-bit position */
#define AG903_SSC_TDM0_SETUP_FS_POL_MSK                    (0x1UL << AG903_SSC_TDM0_SETUP_FS_POL_POS)                    /** SSCTDM0_SETUP FS_POL-bit mask */
#define AG903_SSC_TDM0_SETUP_SCLK_POL_POS                  12                                                            /** SSCTDM0_SETUP SCLK_POL-bit position */
#define AG903_SSC_TDM0_SETUP_SCLK_POL_MSK                  (0x1UL << AG903_SSC_TDM0_SETUP_SCLK_POL_POS)                  /** SSCTDM0_SETUP SCLK_POL-bit mask */
#define AG903_SSC_TDM0_SETUP_TDM_EN_POS                    13                                                            /** SSCTDM0_SETUP TDM_EN-bit position */
#define AG903_SSC_TDM0_SETUP_TDM_EN_MSK                    (0x1UL << AG903_SSC_TDM0_SETUP_TDM_EN_POS)                    /** SSCTDM0_SETUP TDM_EN-bit mask */

#define AG903_SSC_TDM1_SETUP_ST_RX_POS                     0                                                             /** SSCTDM1_SETUP ST_RX-bit position */
#define AG903_SSC_TDM1_SETUP_ST_RX_MSK                     (0x1UL << AG903_SSC_TDM1_SETUP_ST_RX_POS)                     /** SSCTDM1_SETUP ST_RX-bit mask */
#define AG903_SSC_TDM1_SETUP_ST_TX_POS                     1                                                             /** SSCTDM1_SETUP ST_TX-bit position */
#define AG903_SSC_TDM1_SETUP_ST_TX_MSK                     (0x1UL << AG903_SSC_TDM1_SETUP_ST_TX_POS)                     /** SSCTDM1_SETUP ST_TX-bit mask */
#define AG903_SSC_TDM1_SETUP_SCLK_N_POS                    2                                                             /** SSCTDM1_SETUP SCLK_N-bit position */
#define AG903_SSC_TDM1_SETUP_SCLK_N_MSK                    (0x7UL << AG903_SSC_TDM1_SETUP_SCLK_N_POS)                    /** SSCTDM1_SETUP SCLK_N-bit mask */
#define AG903_SSC_TDM1_SETUP_TDM_N_POS                     5                                                             /** SSCTDM1_SETUP TDM_N-bit position */
#define AG903_SSC_TDM1_SETUP_TDM_N_MSK                     (0x3UL << AG903_SSC_TDM1_SETUP_TDM_N_POS)                     /** SSCTDM1_SETUP TDM_N-bit mask */
#define AG903_SSC_TDM1_SETUP_DIR_TX_POS                    7                                                             /** SSCTDM1_SETUP DIR_TX-bit position */
#define AG903_SSC_TDM1_SETUP_DIR_TX_MSK                    (0x1UL << AG903_SSC_TDM1_SETUP_DIR_TX_POS)                    /** SSCTDM1_SETUP DIR_TX-bit mask */
#define AG903_SSC_TDM1_SETUP_FS_RXERR_POS                  8                                                             /** SSCTDM1_SETUP FS_RXERR-bit position */
#define AG903_SSC_TDM1_SETUP_FS_RXERR_MSK                  (0x1UL << AG903_SSC_TDM1_SETUP_FS_RXERR_POS)                  /** SSCTDM1_SETUP FS_RXERR-bit mask */
#define AG903_SSC_TDM1_SETUP_FS_DIST_POS                   9                                                             /** SSCTDM1_SETUP FS_DIST-bit position */
#define AG903_SSC_TDM1_SETUP_FS_DIST_MSK                   (0x1UL << AG903_SSC_TDM1_SETUP_FS_DIST_POS)                   /** SSCTDM1_SETUP FS_DIST-bit mask */
#define AG903_SSC_TDM1_SETUP_FS_TXPW_POS                   10                                                            /** SSCTDM1_SETUP FS_TXPW-bit position */
#define AG903_SSC_TDM1_SETUP_FS_TXPW_MSK                   (0x1UL << AG903_SSC_TDM1_SETUP_FS_TXPW_POS)                   /** SSCTDM1_SETUP FS_TXPW-bit mask */
#define AG903_SSC_TDM1_SETUP_FS_POL_POS                    11                                                            /** SSCTDM1_SETUP FS_POL-bit position */
#define AG903_SSC_TDM1_SETUP_FS_POL_MSK                    (0x1UL << AG903_SSC_TDM1_SETUP_FS_POL_POS)                    /** SSCTDM1_SETUP FS_POL-bit mask */
#define AG903_SSC_TDM1_SETUP_SCLK_POL_POS                  12                                                            /** SSCTDM1_SETUP SCLK_POL-bit position */
#define AG903_SSC_TDM1_SETUP_SCLK_POL_MSK                  (0x1UL << AG903_SSC_TDM1_SETUP_SCLK_POL_POS)                  /** SSCTDM1_SETUP SCLK_POL-bit mask */
#define AG903_SSC_TDM1_SETUP_TDM_EN_POS                    13                                                            /** SSCTDM1_SETUP TDM_EN-bit position */
#define AG903_SSC_TDM1_SETUP_TDM_EN_MSK                    (0x1UL << AG903_SSC_TDM1_SETUP_TDM_EN_POS)                    /** SSCTDM1_SETUP TDM_EN-bit mask */

#define AG903_SSC_TDM2_SETUP_ST_RX_POS                     0                                                             /** SSCTDM2_SETUP ST_RX-bit position */
#define AG903_SSC_TDM2_SETUP_ST_RX_MSK                     (0x1UL << AG903_SSC_TDM2_SETUP_ST_RX_POS)                     /** SSCTDM2_SETUP ST_RX-bit mask */
#define AG903_SSC_TDM2_SETUP_ST_TX_POS                     1                                                             /** SSCTDM2_SETUP ST_TX-bit position */
#define AG903_SSC_TDM2_SETUP_ST_TX_MSK                     (0x1UL << AG903_SSC_TDM2_SETUP_ST_TX_POS)                     /** SSCTDM2_SETUP ST_TX-bit mask */
#define AG903_SSC_TDM2_SETUP_SCLK_N_POS                    2                                                             /** SSCTDM2_SETUP SCLK_N-bit position */
#define AG903_SSC_TDM2_SETUP_SCLK_N_MSK                    (0x7UL << AG903_SSC_TDM2_SETUP_SCLK_N_POS)                    /** SSCTDM2_SETUP SCLK_N-bit mask */
#define AG903_SSC_TDM2_SETUP_TDM_N_POS                     5                                                             /** SSCTDM2_SETUP TDM_N-bit position */
#define AG903_SSC_TDM2_SETUP_TDM_N_MSK                     (0x3UL << AG903_SSC_TDM2_SETUP_TDM_N_POS)                     /** SSCTDM2_SETUP TDM_N-bit mask */
#define AG903_SSC_TDM2_SETUP_DIR_TX_POS                    7                                                             /** SSCTDM2_SETUP DIR_TX-bit position */
#define AG903_SSC_TDM2_SETUP_DIR_TX_MSK                    (0x1UL << AG903_SSC_TDM2_SETUP_DIR_TX_POS)                    /** SSCTDM2_SETUP DIR_TX-bit mask */
#define AG903_SSC_TDM2_SETUP_FS_RXERR_POS                  8                                                             /** SSCTDM2_SETUP FS_RXERR-bit position */
#define AG903_SSC_TDM2_SETUP_FS_RXERR_MSK                  (0x1UL << AG903_SSC_TDM2_SETUP_FS_RXERR_POS)                  /** SSCTDM2_SETUP FS_RXERR-bit mask */
#define AG903_SSC_TDM2_SETUP_FS_DIST_POS                   9                                                             /** SSCTDM2_SETUP FS_DIST-bit position */
#define AG903_SSC_TDM2_SETUP_FS_DIST_MSK                   (0x1UL << AG903_SSC_TDM2_SETUP_FS_DIST_POS)                   /** SSCTDM2_SETUP FS_DIST-bit mask */
#define AG903_SSC_TDM2_SETUP_FS_TXPW_POS                   10                                                            /** SSCTDM2_SETUP FS_TXPW-bit position */
#define AG903_SSC_TDM2_SETUP_FS_TXPW_MSK                   (0x1UL << AG903_SSC_TDM2_SETUP_FS_TXPW_POS)                   /** SSCTDM2_SETUP FS_TXPW-bit mask */
#define AG903_SSC_TDM2_SETUP_FS_POL_POS                    11                                                            /** SSCTDM2_SETUP FS_POL-bit position */
#define AG903_SSC_TDM2_SETUP_FS_POL_MSK                    (0x1UL << AG903_SSC_TDM2_SETUP_FS_POL_POS)                    /** SSCTDM2_SETUP FS_POL-bit mask */
#define AG903_SSC_TDM2_SETUP_SCLK_POL_POS                  12                                                            /** SSCTDM2_SETUP SCLK_POL-bit position */
#define AG903_SSC_TDM2_SETUP_SCLK_POL_MSK                  (0x1UL << AG903_SSC_TDM2_SETUP_SCLK_POL_POS)                  /** SSCTDM2_SETUP SCLK_POL-bit mask */
#define AG903_SSC_TDM2_SETUP_TDM_EN_POS                    13                                                            /** SSCTDM2_SETUP TDM_EN-bit position */
#define AG903_SSC_TDM2_SETUP_TDM_EN_MSK                    (0x1UL << AG903_SSC_TDM2_SETUP_TDM_EN_POS)                    /** SSCTDM2_SETUP TDM_EN-bit mask */

#define AG903_SSC_TDM3_SETUP_ST_RX_POS                     0                                                             /** SSCTDM3_SETUP ST_RX-bit position */
#define AG903_SSC_TDM3_SETUP_ST_RX_MSK                     (0x1UL << AG903_SSC_TDM3_SETUP_ST_RX_POS)                     /** SSCTDM3_SETUP ST_RX-bit mask */
#define AG903_SSC_TDM3_SETUP_ST_TX_POS                     1                                                             /** SSCTDM3_SETUP ST_TX-bit position */
#define AG903_SSC_TDM3_SETUP_ST_TX_MSK                     (0x1UL << AG903_SSC_TDM3_SETUP_ST_TX_POS)                     /** SSCTDM3_SETUP ST_TX-bit mask */
#define AG903_SSC_TDM3_SETUP_SCLK_N_POS                    2                                                             /** SSCTDM3_SETUP SCLK_N-bit position */
#define AG903_SSC_TDM3_SETUP_SCLK_N_MSK                    (0x7UL << AG903_SSC_TDM3_SETUP_SCLK_N_POS)                    /** SSCTDM3_SETUP SCLK_N-bit mask */
#define AG903_SSC_TDM3_SETUP_TDM_N_POS                     5                                                             /** SSCTDM3_SETUP TDM_N-bit position */
#define AG903_SSC_TDM3_SETUP_TDM_N_MSK                     (0x3UL << AG903_SSC_TDM3_SETUP_TDM_N_POS)                     /** SSCTDM3_SETUP TDM_N-bit mask */
#define AG903_SSC_TDM3_SETUP_DIR_TX_POS                    7                                                             /** SSCTDM3_SETUP DIR_TX-bit position */
#define AG903_SSC_TDM3_SETUP_DIR_TX_MSK                    (0x1UL << AG903_SSC_TDM3_SETUP_DIR_TX_POS)                    /** SSCTDM3_SETUP DIR_TX-bit mask */
#define AG903_SSC_TDM3_SETUP_FS_RXERR_POS                  8                                                             /** SSCTDM3_SETUP FS_RXERR-bit position */
#define AG903_SSC_TDM3_SETUP_FS_RXERR_MSK                  (0x1UL << AG903_SSC_TDM3_SETUP_FS_RXERR_POS)                  /** SSCTDM3_SETUP FS_RXERR-bit mask */
#define AG903_SSC_TDM3_SETUP_FS_DIST_POS                   9                                                             /** SSCTDM3_SETUP FS_DIST-bit position */
#define AG903_SSC_TDM3_SETUP_FS_DIST_MSK                   (0x1UL << AG903_SSC_TDM3_SETUP_FS_DIST_POS)                   /** SSCTDM3_SETUP FS_DIST-bit mask */
#define AG903_SSC_TDM3_SETUP_FS_TXPW_POS                   10                                                            /** SSCTDM3_SETUP FS_TXPW-bit position */
#define AG903_SSC_TDM3_SETUP_FS_TXPW_MSK                   (0x1UL << AG903_SSC_TDM3_SETUP_FS_TXPW_POS)                   /** SSCTDM3_SETUP FS_TXPW-bit mask */
#define AG903_SSC_TDM3_SETUP_FS_POL_POS                    11                                                            /** SSCTDM3_SETUP FS_POL-bit position */
#define AG903_SSC_TDM3_SETUP_FS_POL_MSK                    (0x1UL << AG903_SSC_TDM3_SETUP_FS_POL_POS)                    /** SSCTDM3_SETUP FS_POL-bit mask */
#define AG903_SSC_TDM3_SETUP_SCLK_POL_POS                  12                                                            /** SSCTDM3_SETUP SCLK_POL-bit position */
#define AG903_SSC_TDM3_SETUP_SCLK_POL_MSK                  (0x1UL << AG903_SSC_TDM3_SETUP_SCLK_POL_POS)                  /** SSCTDM3_SETUP SCLK_POL-bit mask */
#define AG903_SSC_TDM3_SETUP_TDM_EN_POS                    13                                                            /** SSCTDM3_SETUP TDM_EN-bit position */
#define AG903_SSC_TDM3_SETUP_TDM_EN_MSK                    (0x1UL << AG903_SSC_TDM3_SETUP_TDM_EN_POS)                    /** SSCTDM3_SETUP TDM_EN-bit mask */

#define AG903_SSC_USB_POWER_SETUP_PWR_PROT_EN_POS          0                                                             /** SSCUSB_POWER_SETUP PWR_PROT_EN-bit position */
#define AG903_SSC_USB_POWER_SETUP_PWR_PROT_EN_MSK          (0x1UL << AG903_SSC_USB_POWER_SETUP_PWR_PROT_EN_POS)          /** SSCUSB_POWER_SETUP PWR_PROT_EN-bit mask */
#define AG903_SSC_USB_POWER_SETUP_PWR_INT_EN_POS           1                                                             /** SSCUSB_POWER_SETUP PWR_INT_EN-bit position */
#define AG903_SSC_USB_POWER_SETUP_PWR_INT_EN_MSK           (0x1UL << AG903_SSC_USB_POWER_SETUP_PWR_INT_EN_POS)           /** SSCUSB_POWER_SETUP PWR_INT_EN-bit mask */
#define AG903_SSC_USB_POWER_SETUP_PWR_MODE_POS             2                                                             /** SSCUSB_POWER_SETUP PWR_MODE-bit position */
#define AG903_SSC_USB_POWER_SETUP_PWR_MODE_MSK             (0x1UL << AG903_SSC_USB_POWER_SETUP_PWR_MODE_POS)             /** SSCUSB_POWER_SETUP PWR_MODE-bit mask */

#define AG903_SSC_USB_POWER_STATUS_PWR_PROT_STATE_POS      0                                                             /** SSCUSB_POWER_STATUS PWR_PROT_STATE-bit position */
#define AG903_SSC_USB_POWER_STATUS_PWR_PROT_STATE_MSK      (0x1UL << AG903_SSC_USB_POWER_STATUS_PWR_PROT_STATE_POS)      /** SSCUSB_POWER_STATUS PWR_PROT_STATE-bit mask */
#define AG903_SSC_USB_POWER_STATUS_PWR_PROT_PIN_POS        1                                                             /** SSCUSB_POWER_STATUS PWR_PROT_PIN-bit position */
#define AG903_SSC_USB_POWER_STATUS_PWR_PROT_PIN_MSK        (0x1UL << AG903_SSC_USB_POWER_STATUS_PWR_PROT_PIN_POS)        /** SSCUSB_POWER_STATUS PWR_PROT_PIN-bit mask */
#define AG903_SSC_USB_POWER_STATUS_VBUS_PIN_POS            2                                                             /** SSCUSB_POWER_STATUS VBUS_PIN-bit position */
#define AG903_SSC_USB_POWER_STATUS_VBUS_PIN_MSK            (0x1UL << AG903_SSC_USB_POWER_STATUS_VBUS_PIN_POS)            /** SSCUSB_POWER_STATUS VBUS_PIN-bit mask */

#define AG903_SSC_USB_POWER_CLEAR_PWR_PROT_CLR_POS         0                                                             /** SSCUSB_POWER_CLEAR PWR_PROT_CLR-bit position */
#define AG903_SSC_USB_POWER_CLEAR_PWR_PROT_CLR_MSK         (0x1UL << AG903_SSC_USB_POWER_CLEAR_PWR_PROT_CLR_POS)         /** SSCUSB_POWER_CLEAR PWR_PROT_CLR-bit mask */

#define AG903_SSC_SD_POWER_SETUP_PWR_PROT_EN_POS           0                                                             /** SSCSD_POWER_SETUP PWR_PROT_EN-bit position */
#define AG903_SSC_SD_POWER_SETUP_PWR_PROT_EN_MSK           (0x1UL << AG903_SSC_SD_POWER_SETUP_PWR_PROT_EN_POS)           /** SSCSD_POWER_SETUP PWR_PROT_EN-bit mask */
#define AG903_SSC_SD_POWER_SETUP_PWR_INT_EN_POS            1                                                             /** SSCSD_POWER_SETUP PWR_INT_EN-bit position */
#define AG903_SSC_SD_POWER_SETUP_PWR_INT_EN_MSK            (0x1UL << AG903_SSC_SD_POWER_SETUP_PWR_INT_EN_POS)            /** SSCSD_POWER_SETUP PWR_INT_EN-bit mask */

#define AG903_SSC_SD_POWER_STATUS_PWR_PROT_STATE_POS       0                                                             /** SSCSD_POWER_STATUS PWR_PROT_STATE-bit position */
#define AG903_SSC_SD_POWER_STATUS_PWR_PROT_STATE_MSK       (0x1UL << AG903_SSC_SD_POWER_STATUS_PWR_PROT_STATE_POS)       /** SSCSD_POWER_STATUS PWR_PROT_STATE-bit mask */
#define AG903_SSC_SD_POWER_STATUS_PWR_PROT_PIN_POS         1                                                             /** SSCSD_POWER_STATUS PWR_PROT_PIN-bit position */
#define AG903_SSC_SD_POWER_STATUS_PWR_PROT_PIN_MSK         (0x1UL << AG903_SSC_SD_POWER_STATUS_PWR_PROT_PIN_POS)         /** SSCSD_POWER_STATUS PWR_PROT_PIN-bit mask */

#define AG903_SSC_SD_POWER_CLEAR_PWR_PROT_CLR_POS          0                                                             /** SSCSD_POWER_CLEAR PWR_PROT_CLR-bit position */
#define AG903_SSC_SD_POWER_CLEAR_PWR_PROT_CLR_MSK          (0x1UL << AG903_SSC_SD_POWER_CLEAR_PWR_PROT_CLR_POS)          /** SSCSD_POWER_CLEAR PWR_PROT_CLR-bit mask */

#define AG903_SSC_VIDEOADC_SETUP_GHO_POS                   0                                                             /** SSCVIDEOADC_SETUP GHO-bit position */
#define AG903_SSC_VIDEOADC_SETUP_GHO_MSK                   (0xfUL << AG903_SSC_VIDEOADC_SETUP_GHO_POS)                   /** SSCVIDEOADC_SETUP GHO-bit mask */
#define AG903_SSC_VIDEOADC_SETUP_CLHO_POS                  4                                                             /** SSCVIDEOADC_SETUP CLHO-bit position */
#define AG903_SSC_VIDEOADC_SETUP_CLHO_MSK                  (0xfUL << AG903_SSC_VIDEOADC_SETUP_CLHO_POS)                  /** SSCVIDEOADC_SETUP CLHO-bit mask */
#define AG903_SSC_VIDEOADC_SETUP_CTHO_POS                  8                                                             /** SSCVIDEOADC_SETUP CTHO-bit position */
#define AG903_SSC_VIDEOADC_SETUP_CTHO_MSK                  (0xfUL << AG903_SSC_VIDEOADC_SETUP_CTHO_POS)                  /** SSCVIDEOADC_SETUP CTHO-bit mask */
#define AG903_SSC_VIDEOADC_SETUP_DATEN_POS                 12                                                            /** SSCVIDEOADC_SETUP DATEN-bit position */
#define AG903_SSC_VIDEOADC_SETUP_DATEN_MSK                 (0xfUL << AG903_SSC_VIDEOADC_SETUP_DATEN_POS)                 /** SSCVIDEOADC_SETUP DATEN-bit mask */
#define AG903_SSC_VIDEOADC_SETUP_ACQEN_POS                 16                                                            /** SSCVIDEOADC_SETUP ACQEN-bit position */
#define AG903_SSC_VIDEOADC_SETUP_ACQEN_MSK                 (0xfUL << AG903_SSC_VIDEOADC_SETUP_ACQEN_POS)                 /** SSCVIDEOADC_SETUP ACQEN-bit mask */
#define AG903_SSC_VIDEOADC_SETUP_ACQCLR_POS                20                                                            /** SSCVIDEOADC_SETUP ACQCLR-bit position */
#define AG903_SSC_VIDEOADC_SETUP_ACQCLR_MSK                (0xfUL << AG903_SSC_VIDEOADC_SETUP_ACQCLR_POS)                /** SSCVIDEOADC_SETUP ACQCLR-bit mask */

#define AG903_SSC_CVBSDEC_ADDR_ADDR_POS                    0                                                             /** SSCCVBSDEC_ADDR ADDR-bit position */
#define AG903_SSC_CVBSDEC_ADDR_ADDR_MSK                    (0xfffUL << AG903_SSC_CVBSDEC_ADDR_ADDR_POS)                  /** SSCCVBSDEC_ADDR ADDR-bit mask */
#define AG903_SSC_CVBSDEC_ADDR_CH_POS                      16                                                            /** SSCCVBSDEC_ADDR CH-bit position */
#define AG903_SSC_CVBSDEC_ADDR_CH_MSK                      (0x3UL << AG903_SSC_CVBSDEC_ADDR_CH_POS)                      /** SSCCVBSDEC_ADDR CH-bit mask */

#define AG903_SSC_CVBSDEC_DATA_DATA_POS                    0                                                             /** SSCCVBSDEC_DATA DATA-bit position */
#define AG903_SSC_CVBSDEC_DATA_DATA_MSK                    (0xffffUL << AG903_SSC_CVBSDEC_DATA_DATA_POS)                 /** SSCCVBSDEC_DATA DATA-bit mask */

#define AG903_SSC_VIDEOADC_MAXMIN_MIN_POS                  0                                                             /** SSCVIDEOADC_MAXMIN MIN-bit position */
#define AG903_SSC_VIDEOADC_MAXMIN_MIN_MSK                  (0x3ffUL << AG903_SSC_VIDEOADC_MAXMIN_MIN_POS)                /** SSCVIDEOADC_MAXMIN MIN-bit mask */
#define AG903_SSC_VIDEOADC_MAXMIN_MAX_POS                  16                                                            /** SSCVIDEOADC_MAXMIN MAX-bit position */
#define AG903_SSC_VIDEOADC_MAXMIN_MAX_MSK                  (0x3ffUL << AG903_SSC_VIDEOADC_MAXMIN_MAX_POS)                /** SSCVIDEOADC_MAXMIN MAX-bit mask */

#define AG903_SSC_SGI_STATUS_SGI_STATUS_POS                0                                                             /** SSCSGI_STATUS SGI_STATUS-bit position */
#define AG903_SSC_SGI_STATUS_SGI_STATUS_MSK                (0xffffffffUL << AG903_SSC_SGI_STATUS_SGI_STATUS_POS)         /** SSCSGI_STATUS SGI_STATUS-bit mask */

#define AG903_SSC_SGI_SET_SGI_SET_POS                      0                                                             /** SSCSGI_SET SGI_SET-bit position */
#define AG903_SSC_SGI_SET_SGI_SET_MSK                      (0xffffffffUL << AG903_SSC_SGI_SET_SGI_SET_POS)               /** SSCSGI_SET SGI_SET-bit mask */

#define AG903_SSC_SGI_CLEAR_SGI_CLEAR_POS                  0                                                             /** SSCSGI_CLEAR SGI_CLEAR-bit position */
#define AG903_SSC_SGI_CLEAR_SGI_CLEAR_MSK                  (0xffffffffUL << AG903_SSC_SGI_CLEAR_SGI_CLEAR_POS)           /** SSCSGI_CLEAR SGI_CLEAR-bit mask */

#define AG903_SSC_CA5_JUMPADDR_JUMPADDR_POS                0                                                             /** SSCCA5_JUMPADDR JUMPADDR-bit position */
#define AG903_SSC_CA5_JUMPADDR_JUMPADDR_MSK                (0xffffffffUL << AG903_SSC_CA5_JUMPADDR_JUMPADDR_POS)         /** SSCCA5_JUMPADDR JUMPADDR-bit mask */

#define AG903_SSC_COUNT64_LOWER_COUNT64_LOWER_POS          0                                                             /** SSCCOUNT64_LOWER COUNT64_LOWER-bit position */
#define AG903_SSC_COUNT64_LOWER_COUNT64_LOWER_MSK          (0xffffffffUL << AG903_SSC_COUNT64_LOWER_COUNT64_LOWER_POS)   /** SSCCOUNT64_LOWER COUNT64_LOWER-bit mask */

#define AG903_SSC_COUNT64_UPPER_COUNT64_UPPER_POS          0                                                             /** SSCCOUNT64_UPPER COUNT64_UPPER-bit position */
#define AG903_SSC_COUNT64_UPPER_COUNT64_UPPER_MSK          (0xffffffffUL << AG903_SSC_COUNT64_UPPER_COUNT64_UPPER_POS)   /** SSCCOUNT64_UPPER COUNT64_UPPER-bit mask */

#endif /* _AG903_SSC_REGMAP_H_ */

