/**
 * @brief           USB Register Definition
 * @author          AXELL CORPORATION
 * @description     USB Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_USB_REGMAP_H_
#define _AG903_USB_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** USB Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  HCCAP;

        struct {
            __I  uint32_t  CAPLENGTH                      :  8;
                 uint32_t                                 :  8;
            __I  uint32_t  HCIVERSION                     : 16;
        } HCCAP_bits;
    };

    union {
        __I  uint32_t  HCSPARAMS;

        struct {
            __I  uint32_t  N_PORTS                        :  4;
        } HCSPARAMS_bits;
    };

    union {
        __I  uint32_t  HCCPARAMS;

        struct {
                 uint32_t                                 :  1;
            __I  uint32_t  PROG_FR_LIST_FLAG              :  1;
            __I  uint32_t  ASYN_SCH_PARK_CAP              :  1;
        } HCCPARAMS_bits;
    };

    __I  uint32_t  RESERVED1[1];

    union {
        __IO uint32_t  USBCMD;

        struct {
            __IO uint32_t  RS                             :  1;
            __IO uint32_t  HC_RESET                       :  1;
            __IO uint32_t  FRL_SIZE                       :  2;
            __IO uint32_t  PSCH_EN                        :  1;
            __IO uint32_t  ASCH_EN                        :  1;
            __IO uint32_t  INT_OAAD                       :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  ASYN_PK_CNT                    :  2;
                 uint32_t                                 :  1;
            __IO uint32_t  ASYN_PK_EN                     :  1;
                 uint32_t                                 :  4;
            __IO uint32_t  INT_THRC                       :  8;
        } USBCMD_bits;
    };

    union {
        __IO uint32_t  USBSTS;

        struct {
            __IO uint32_t  USB_INT                        :  1;
            __IO uint32_t  USBERR_INT                     :  1;
            __IO uint32_t  PO_CHG_DET                     :  1;
            __IO uint32_t  FRL_ROL                        :  1;
            __IO uint32_t  H_SYSERR                       :  1;
            __IO uint32_t  INT_OAA                        :  1;
                 uint32_t                                 :  6;
            __I  uint32_t  HCHalted                       :  1;
            __I  uint32_t  Reclamation                    :  1;
            __I  uint32_t  PSCH_STS                       :  1;
            __I  uint32_t  ASCH_STS                       :  1;
        } USBSTS_bits;
    };

    union {
        __IO uint32_t  USBINTR;

        struct {
            __IO uint32_t  USB_INT_EN                     :  1;
            __IO uint32_t  USBERR_INT_EN                  :  1;
            __IO uint32_t  PO_CHG_INT_EN                  :  1;
            __IO uint32_t  FRL_ROL_EN                     :  1;
            __IO uint32_t  H_SYSERR_EN                    :  1;
            __IO uint32_t  INT_OAA_EN                     :  1;
        } USBINTR_bits;
    };

    union {
        __IO uint32_t  FRINDEX;

        struct {
            __IO uint32_t  FRINDEX                        : 14;
        } FRINDEX_bits;
    };

    __I  uint32_t  RESERVED2[1];

    union {
        __IO uint32_t  PERIODICLISTBASE;

        struct {
                 uint32_t                                 : 12;
            __IO uint32_t  PERI_BASADR                    : 20;
        } PERIODICLISTBASE_bits;
    };

    union {
        __IO uint32_t  ASYNCLISTADDR;

        struct {
                 uint32_t                                 :  5;
            __IO uint32_t  Async_ladr                     : 27;
        } ASYNCLISTADDR_bits;
    };

    __I  uint32_t  RESERVED3[1];

    union {
        __IO uint32_t  PORTSC;

        struct {
            __I  uint32_t  CONN_STS                       :  1;
            __IO uint32_t  CONN_CHG                       :  1;
            __IO uint32_t  PO_EN                          :  1;
            __IO uint32_t  PO_EN_CHG                      :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  F_PO_RESM                      :  1;
            __IO uint32_t  PO_SUSP                        :  1;
            __IO uint32_t  PO_RESET                       :  1;
                 uint32_t                                 :  1;
            __I  uint32_t  LINE_STS                       :  2;
                 uint32_t                                 :  4;
            __IO uint32_t  PORT_TEST                      :  4;
            __IO uint32_t  HC_TST_PKDONE                  :  1;
        } PORTSC_bits;
    };

    __I  uint32_t  RESERVED4[3];

    union {
        __IO uint32_t  HCMISC;

        struct {
            __IO uint32_t  ASYN_SCH_SLPT                  :  2;
            __IO uint32_t  EOF1_Time                      :  2;
            __IO uint32_t  EOF2_Time                      :  2;
            __IO uint32_t  HostPhy_Suspend                :  1;
        } HCMISC_bits;
    };

    union {
        __IO uint32_t  FS_EOF;

        struct {
            __IO uint32_t  FS_EOF1_Time                   : 12;
            __IO uint32_t  FS_EOF1_Time_125us             :  3;
        } FS_EOF_bits;
    };

    union {
        __IO uint32_t  HS_EOF;

        struct {
            __IO uint32_t  HS_EOF1_Time                   : 12;
        } HS_EOF_bits;
    };

    __I  uint32_t  RESERVED5[13];

    union {
        __IO uint32_t  OTG_CSR;

        struct {
            __IO uint32_t  B_BUS_REQ                      :  1;
            __IO uint32_t  B_HNP_EN                       :  1;
            __IO uint32_t  B_DSCHRG_VBUS                  :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  A_BUS_REQ                      :  1;
            __IO uint32_t  A_BUS_DROP                     :  1;
            __IO uint32_t  A_SET_B_HNP_EN                 :  1;
            __IO uint32_t  A_SRP_DET_EN                   :  1;
            __IO uint32_t  A_SRP_RESP_TYP                 :  1;
            __IO uint32_t  ID_FLT_SEL                     :  1;
            __IO uint32_t  VBUS_FLT_SEL                   :  1;
            __IO uint32_t  HDISCON_FLT_SEL                :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  IDPULUP                        :  1;
                 uint32_t                                 :  2;
            __I  uint32_t  B_SESS_END                     :  1;
            __I  uint32_t  B_SESS_VLD                     :  1;
            __I  uint32_t  A_SESS_VLD                     :  1;
            __I  uint32_t  VBUS_VLD                       :  1;
            __I  uint32_t  CROLE                          :  1;
            __I  uint32_t  ID                             :  1;
            __I  uint32_t  SPD_TYP                        :  2;
        } OTG_CSR_bits;
    };

    union {
        __IO uint32_t  OTG_ISR;

        struct {
            __IO uint32_t  B_SRP_DN                       :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  A_SRP_DET                      :  1;
            __IO uint32_t  A_VBUS_ERR                     :  1;
            __IO uint32_t  B_SESS_END                     :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  RLCHG                          :  1;
            __IO uint32_t  IDCHG                          :  1;
            __IO uint32_t  OVC                            :  1;
            __IO uint32_t  A_WAIT_CON                     :  1;
            __IO uint32_t  APLGRMV                        :  1;
        } OTG_ISR_bits;
    };

    union {
        __IO uint32_t  OTG_IER;

        struct {
            __IO uint32_t  B_SRP_DN_EN                    :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  A_SRP_DET_EN                   :  1;
            __IO uint32_t  A_VBUS_ERR_EN                  :  1;
            __IO uint32_t  B_SESS_END_EN                  :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  RLCHG_EN                       :  1;
            __IO uint32_t  IDCHG_EN                       :  1;
            __IO uint32_t  OVC_EN                         :  1;
            __IO uint32_t  A_WAIT_CON_EN                  :  1;
            __IO uint32_t  APLGRMV_EN                     :  1;
        } OTG_IER_bits;
    };

    __I  uint32_t  RESERVED6[13];

    union {
        __I  uint32_t  GLB_ISR;

        struct {
            __I  uint32_t  DEV_INT                        :  1;
            __I  uint32_t  OTG_INT                        :  1;
            __I  uint32_t  HC_INT                         :  1;
        } GLB_ISR_bits;
    };

    union {
        __IO uint32_t  GLB_INT;

        struct {
            __IO uint32_t  MDEV_INT                       :  1;
            __IO uint32_t  MOTG_INT                       :  1;
            __IO uint32_t  MHC_INT                        :  1;
            __IO uint32_t  INT_POLARITY                   :  1;
        } GLB_INT_bits;
    };

    __I  uint32_t  RESERVED7[6];

    union {
        __I  uint32_t  REVISION;
    };

    union {
        __I  uint32_t  FEATURE;

        struct {
            __I  uint32_t  DMABUFSIZE                     :  5;
            __I  uint32_t  FIFO_NUM                       :  4;
            __I  uint32_t  EP_NUM                         :  5;
            __I  uint32_t  DEV_ONLY                       :  1;
            __I  uint32_t  HOST_ONLY                      :  1;
            __I  uint32_t  BULK_ONLY                      :  1;
            __I  uint32_t  HS_DIS                         :  1;
        } FEATURE_bits;
    };

    __I  uint32_t  RESERVED8[6];

    union {
        __IO uint32_t  DEV_CTL;

        struct {
            __IO uint32_t  CAP_RMWAKUP                    :  1;
            __IO uint32_t  HALF_SPEED                     :  1;
            __IO uint32_t  GLINT_EN                       :  1;
            __IO uint32_t  GOSUSP                         :  1;
            __IO uint32_t  SFRST                          :  1;
            __IO uint32_t  CHIP_EN                        :  1;
            __I  uint32_t  HS_EN                          :  1;
            __IO uint32_t  SYSBUS_WIDTH                   :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  FORCE_FS                       :  1;
            __IO uint32_t  IDLE_DEGLITCH                  :  2;
            __IO uint32_t  LPM_BESL_MAX                   :  4;
            __IO uint32_t  LPM_BESL_MIN                   :  4;
            __IO uint32_t  LPM_BESL                       :  4;
                 uint32_t                                 :  1;
            __IO uint32_t  LPM_EN                         :  1;
            __IO uint32_t  LPM_ACCEPT                     :  1;
        } DEV_CTL_bits;
    };

    union {
        __IO uint32_t  DEV_ADR;

        struct {
            __IO uint32_t  DEVADR                         :  7;
            __IO uint32_t  AFT_CONF                       :  1;
        } DEV_ADR_bits;
    };

    union {
        __IO uint32_t  DEV_TST;

        struct {
            __IO uint32_t  TST_CLRFF                      :  1;
            __IO uint32_t  TST_LPCX                       :  1;
            __IO uint32_t  TST_CLREA                      :  1;
            __IO uint32_t  TST_DISCRC                     :  1;
            __IO uint32_t  TST_DISTOG                     :  1;
            __IO uint32_t  TST_MOD                        :  1;
            __IO uint32_t  DISGENSOF                      :  1;
            __IO uint32_t  TST_MOD_TYP                    :  1;
        } DEV_TST_bits;
    };

    union {
        __I  uint32_t  DEV_SFN;

        struct {
            __I  uint32_t  SOFN                           : 11;
            __I  uint32_t  USOFN                          :  3;
        } DEV_SFN_bits;
    };

    union {
        __IO uint32_t  DEV_SMT;

        struct {
            __IO uint32_t  SOFMT                          : 16;
        } DEV_SMT_bits;
    };

    union {
        __IO uint32_t  PHY_TST;

        struct {
            __IO uint32_t  UNPLUG                         :  1;
            __IO uint32_t  TST_JSTA                       :  1;
            __IO uint32_t  TST_KSTA                       :  1;
            __IO uint32_t  TST_SE0NAK                     :  1;
            __IO uint32_t  TST_PKT                        :  1;
        } PHY_TST_bits;
    };

    union {
        __IO uint32_t  DEV_VCTL;

        struct {
            __IO uint32_t  VCTL                           :  5;
            __IO uint32_t  VCTLOAD_N                      :  1;
        } DEV_VCTL_bits;
    };

    union {
        __I  uint32_t  DEV_CXCFG;

        struct {
            __I  uint32_t  VSTA                           :  8;
        } DEV_CXCFG_bits;
    };

    union {
        __IO uint32_t  DEV_CXCFE;

        struct {
            __IO uint32_t  CX_DONE                        :  1;
            __IO uint32_t  TST_PKDONE                     :  1;
            __IO uint32_t  CX_STL                         :  1;
            __IO uint32_t  CX_CLR                         :  1;
            __I  uint32_t  CX_FUL                         :  1;
            __I  uint32_t  CX_EMP                         :  1;
                 uint32_t                                 :  2;
            __I  uint32_t  F_EMP                          :  4;
                 uint32_t                                 : 12;
            __I  uint32_t  CX_FNT                         :  7;
        } DEV_CXCFE_bits;
    };

    union {
        __IO uint32_t  DEV_ICR;

        struct {
            __IO uint32_t  IDLE_CNT                       :  3;
        } DEV_ICR_bits;
    };

    __I  uint32_t  RESERVED9[2];

    union {
        __IO uint32_t  DEV_MIGR;

        struct {
            __IO uint32_t  MINT_G0                        :  1;
            __IO uint32_t  MINT_G1                        :  1;
            __IO uint32_t  MINT_G2                        :  1;
            __IO uint32_t  MINT_G3                        :  1;
        } DEV_MIGR_bits;
    };

    union {
        __IO uint32_t  DEV_MISG0;

        struct {
            __IO uint32_t  MCX_SETUP_INT                  :  1;
            __IO uint32_t  MCX_IN_INT                     :  1;
            __IO uint32_t  MCX_OUT_INT                    :  1;
            __IO uint32_t  MCX_COMEND                     :  1;
            __IO uint32_t  MCX_COMFAIL_INT                :  1;
            __IO uint32_t  MCX_COMABORT_INT               :  1;
        } DEV_MISG0_bits;
    };

    union {
        __IO uint32_t  DEV_MISG1;

        struct {
            __IO uint32_t  MF0_OUT_INT                    :  1;
            __IO uint32_t  MF0_SPK_INT                    :  1;
            __IO uint32_t  MF1_OUT_INT                    :  1;
            __IO uint32_t  MF1_SPK_INT                    :  1;
            __IO uint32_t  MF2_OUT_INT                    :  1;
            __IO uint32_t  MF2_SPK_INT                    :  1;
            __IO uint32_t  MF3_OUT_INT                    :  1;
            __IO uint32_t  MF3_SPK_INT                    :  1;
                 uint32_t                                 :  8;
            __IO uint32_t  MF0_IN_INT                     :  1;
            __IO uint32_t  MF1_IN_INT                     :  1;
            __IO uint32_t  MF2_IN_INT                     :  1;
            __IO uint32_t  MF3_IN_INT                     :  1;
        } DEV_MISG1_bits;
    };

    union {
        __IO uint32_t  DEV_MISG2;

        struct {
            __IO uint32_t  MUSBRST_INT                    :  1;
            __IO uint32_t  MSUSP_INT                      :  1;
            __IO uint32_t  MRESM_INT                      :  1;
            __IO uint32_t  MSEQ_ERR_INT                   :  1;
            __IO uint32_t  MSEQ_ABORT_INT                 :  1;
            __IO uint32_t  MTX0BYTE_INT                   :  1;
            __IO uint32_t  MRX0BYTE_INT                   :  1;
            __IO uint32_t  MDMA_CMPLT                     :  1;
            __IO uint32_t  MDMA_ERROR                     :  1;
            __IO uint32_t  MDev_Idle                      :  1;
            __IO uint32_t  MDev_Wakeup_byVBUS             :  1;
        } DEV_MISG2_bits;
    };

    union {
        __I  uint32_t  DEV_IGR;

        struct {
            __I  uint32_t  INT_G0                         :  1;
            __I  uint32_t  INT_G1                         :  1;
            __I  uint32_t  INT_G2                         :  1;
            __I  uint32_t  INT_G3                         :  1;
        } DEV_IGR_bits;
    };

    union {
        __IO uint32_t  DEV_ISG0;

        struct {
            __I  uint32_t  CX_SETUP_INT                   :  1;
            __I  uint32_t  CX_IN_INT                      :  1;
            __I  uint32_t  CX_OUT_INT                     :  1;
            __I  uint32_t  CX_COMEND_INT                  :  1;
            __I  uint32_t  CX_COMFAIL_INT                 :  1;
            __IO uint32_t  CX_COMABT_INT                  :  1;
        } DEV_ISG0_bits;
    };

    union {
        __I  uint32_t  DEV_ISG1;

        struct {
            __I  uint32_t  F0_OUT_INT                     :  1;
            __I  uint32_t  F0_SPK_INT                     :  1;
            __I  uint32_t  F1_OUT_INT                     :  1;
            __I  uint32_t  F1_SPK_INT                     :  1;
            __I  uint32_t  F2_OUT_INT                     :  1;
            __I  uint32_t  F2_SPK_INT                     :  1;
            __I  uint32_t  F3_OUT_INT                     :  1;
            __I  uint32_t  F3_SPK_INT                     :  1;
                 uint32_t                                 :  8;
            __I  uint32_t  F0_IN_INT                      :  1;
            __I  uint32_t  F1_IN_INT                      :  1;
            __I  uint32_t  F2_IN_INT                      :  1;
            __I  uint32_t  F3_IN_INT                      :  1;
        } DEV_ISG1_bits;
    };

    union {
        __IO uint32_t  DEV_ISG2;

        struct {
            __IO uint32_t  USBRST_INT                     :  1;
            __IO uint32_t  SUSP_INT                       :  1;
            __IO uint32_t  RESM_INT                       :  1;
            __IO uint32_t  ISO_SEQ_ERR_INT                :  1;
            __IO uint32_t  ISO_SEQ_ABORT_INT              :  1;
            __IO uint32_t  TX0BYTE_INT                    :  1;
            __IO uint32_t  RX0BYTE_INT                    :  1;
            __IO uint32_t  DMA_CMPLT                      :  1;
            __IO uint32_t  DMA_ERROR                      :  1;
            __I  uint32_t  Dev_Idle                       :  1;
            __I  uint32_t  Dev_Wakeup_byVBUS              :  1;
        } DEV_ISG2_bits;
    };

    union {
        __IO uint32_t  DEV_RXZ;

        struct {
            __IO uint32_t  RX0BYTE_EP1                    :  1;
            __IO uint32_t  RX0BYTE_EP2                    :  1;
            __IO uint32_t  RX0BYTE_EP3                    :  1;
            __IO uint32_t  RX0BYTE_EP4                    :  1;
            __IO uint32_t  RX0BYTE_EP5                    :  1;
            __IO uint32_t  RX0BYTE_EP6                    :  1;
            __IO uint32_t  RX0BYTE_EP7                    :  1;
            __IO uint32_t  RX0BYTE_EP8                    :  1;
        } DEV_RXZ_bits;
    };

    union {
        __IO uint32_t  DEV_TXZ;

        struct {
            __IO uint32_t  TX0BYTE_EP1                    :  1;
            __IO uint32_t  TX0BYTE_EP2                    :  1;
            __IO uint32_t  TX0BYTE_EP3                    :  1;
            __IO uint32_t  TX0BYTE_EP4                    :  1;
            __IO uint32_t  TX0BYTE_EP5                    :  1;
            __IO uint32_t  TX0BYTE_EP6                    :  1;
            __IO uint32_t  TX0BYTE_EP7                    :  1;
            __IO uint32_t  TX0BYTE_EP8                    :  1;
        } DEV_TXZ_bits;
    };

    union {
        __IO uint32_t  DEV_ISE;

        struct {
            __IO uint32_t  ISO_ABT_ERR_EP1                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP2                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP3                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP4                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP5                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP6                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP7                :  1;
            __IO uint32_t  ISO_ABT_ERR_EP8                :  1;
                 uint32_t                                 :  8;
            __IO uint32_t  ISO_SEQ_ERR_EP1                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP2                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP3                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP4                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP5                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP6                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP7                :  1;
            __IO uint32_t  ISO_SEQ_ERR_EP8                :  1;
        } DEV_ISE_bits;
    };

    __I  uint32_t  RESERVED10[1];

    union {
        __IO uint32_t  DEV_INMPS[8];

        struct {
            __IO uint32_t  MAXPS_IEPn                     : 11;
            __IO uint32_t  STL_IEPn                       :  1;
            __IO uint32_t  RSTG_IEPn                      :  1;
            __IO uint32_t  TX_NUM_HBW_IEPn                :  2;
            __IO uint32_t  TX0BYTE_IEPn                   :  1;
        } DEV_INMPS_bits[8];
    };

    union {
        __IO uint32_t  DEV_OUTMPS[8];

        struct {
            __IO uint32_t  MAXPS_OEPn                     : 11;
            __IO uint32_t  STL_OEPn                       :  1;
            __IO uint32_t  RSTG_OEPn                      :  1;
        } DEV_OUTMPS_bits[8];
    };

    union {
        __IO uint32_t  DEV_EPMAP0;

        struct {
            __IO uint32_t  FNO_IEP1                       :  4;
            __IO uint32_t  FNO_OEP1                       :  4;
            __IO uint32_t  FNO_IEP2                       :  4;
            __IO uint32_t  FNO_OEP2                       :  4;
            __IO uint32_t  FNO_IEP3                       :  4;
            __IO uint32_t  FNO_OEP3                       :  4;
            __IO uint32_t  FNO_IEP4                       :  4;
            __IO uint32_t  FNO_OEP4                       :  4;
        } DEV_EPMAP0_bits;
    };

    union {
        __IO uint32_t  DEV_EPMAP1;

        struct {
            __IO uint32_t  FNO_IEP5                       :  4;
            __IO uint32_t  FNO_OEP5                       :  4;
            __IO uint32_t  FNO_IEP6                       :  4;
            __IO uint32_t  FNO_OEP6                       :  4;
            __IO uint32_t  FNO_IEP7                       :  4;
            __IO uint32_t  FNO_OEP7                       :  4;
            __IO uint32_t  FNO_IEP8                       :  4;
            __IO uint32_t  FNO_OEP8                       :  4;
        } DEV_EPMAP1_bits;
    };

    union {
        __IO uint32_t  DEV_FMAP;

        struct {
            __IO uint32_t  EPNO_FIFO0                     :  4;
            __IO uint32_t  Dir_FIFO0                      :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  EPNO_FIFO1                     :  4;
            __IO uint32_t  Dir_FIFO1                      :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  EPNO_FIFO2                     :  4;
            __IO uint32_t  Dir_FIFO2                      :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  EPNO_FIFO3                     :  4;
            __IO uint32_t  Dir_FIFO3                      :  2;
        } DEV_FMAP_bits;
    };

    union {
        __IO uint32_t  DEV_FCFG;

        struct {
            __IO uint32_t  BLK_TYP_F0                     :  2;
            __IO uint32_t  BLKNO_F0                       :  2;
            __IO uint32_t  BLKSZ_F0                       :  1;
            __IO uint32_t  EN_F0                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  BLK_TYP_F1                     :  2;
            __IO uint32_t  BLKNO_F1                       :  2;
            __IO uint32_t  BLKSZ_F1                       :  1;
            __IO uint32_t  EN_F1                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  BLK_TYP_F2                     :  2;
            __IO uint32_t  BLKNO_F2                       :  2;
            __IO uint32_t  BLKSZ_F2                       :  1;
            __IO uint32_t  EN_F2                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  BLK_TYP_F3                     :  2;
            __IO uint32_t  BLKNO_F3                       :  2;
            __IO uint32_t  BLKSZ_F3                       :  1;
            __IO uint32_t  EN_F3                          :  1;
        } DEV_FCFG_bits;
    };

    union {
        __IO uint32_t  DEV_FIBC[4];

        struct {
            __I  uint32_t  BC_Fn                          : 11;
                 uint32_t                                 :  1;
            __IO uint32_t  FFRST                          :  1;
        } DEV_FIBC_bits[4];
    };

    union {
        __IO uint32_t  DMA_TFN;

        struct {
            __IO uint32_t  ACC_F0                         :  1;
            __IO uint32_t  ACC_F1                         :  1;
            __IO uint32_t  ACC_F2                         :  1;
            __IO uint32_t  ACC_F3                         :  1;
            __IO uint32_t  ACC_CXF                        :  1;
        } DMA_TFN_bits;
    };

    union {
        __IO uint32_t  DMA_CPS0;

        struct {
            __IO uint32_t  AWCACHE                        :  4;
            __IO uint32_t  AWPROT                         :  3;
            __IO uint32_t  AWLOCK                         :  2;
            __IO uint32_t  ARCACHE                        :  4;
            __IO uint32_t  ARPORT                         :  3;
            __IO uint32_t  ARLOCK                         :  2;
            __IO uint32_t  BUF_LD_EN                      :  1;
            __IO uint32_t  DST_WD                         :  1;
        } DMA_CPS0_bits;
    };

    union {
        __IO uint32_t  DMA_CPS1;

        struct {
            __IO uint32_t  DMA_START                      :  1;
            __IO uint32_t  DMA_TYPE                       :  1;
            __IO uint32_t  DMA_IO                         :  1;
            __IO uint32_t  DMA_ABORT                      :  1;
            __IO uint32_t  CLRFIFO_DMAABORT               :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  DMA_LEN                        : 17;
            __IO uint32_t  R_HPROT                        :  4;
            __IO uint32_t  UNDEF_LEN_BURST                :  1;
            __IO uint32_t  L1_WAKEUP                      :  1;
            __IO uint32_t  DevPhy_Suspend                 :  1;
        } DMA_CPS1_bits;
    };

    union {
        __IO uint32_t  DMA_CPS2;
    };

    union {
        __I  uint32_t  DMA_CPS3;
    };

    __I  uint32_t  RESERVED11[75];

    union {
        __IO uint32_t  VDMA_CXFPS1;

        struct {
            __IO uint32_t  VDMA_START_CXF                 :  1;
            __IO uint32_t  VDMA_TYPE_CXF                  :  1;
            __IO uint32_t  VDMA_IO_CXF                    :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  VDMA_LEN_CXF                   : 17;
        } VDMA_CXFPS1_bits;
    };

    union {
        __IO uint32_t  VDMA_CXFPS2;
    };

    union {
        __IO uint32_t  VDMA_F0PS1;

        struct {
            __IO uint32_t  VDMA_START_F0                  :  1;
            __IO uint32_t  VDMA_TYPE_F0                   :  1;
            __IO uint32_t  VDMA_IO_F0                     :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  VDMA_LEN_F0                    : 17;
        } VDMA_F0PS1_bits;
    };

    union {
        __IO uint32_t  VDMA_F0PS2;
    };

    union {
        __IO uint32_t  VDMA_F1PS1;

        struct {
            __IO uint32_t  VDMA_START_F1                  :  1;
            __IO uint32_t  VDMA_TYPE_F1                   :  1;
            __IO uint32_t  VDMA_IO_F1                     :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  VDMA_LEN_F1                    : 17;
        } VDMA_F1PS1_bits;
    };

    union {
        __IO uint32_t  VDMA_F1PS2;
    };

    union {
        __IO uint32_t  VDMA_F2PS1;

        struct {
            __IO uint32_t  VDMA_START_F2                  :  1;
            __IO uint32_t  VDMA_TYPE_F2                   :  1;
            __IO uint32_t  VDMA_IO_F2                     :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  VDMA_LEN_F2                    : 17;
        } VDMA_F2PS1_bits;
    };

    union {
        __IO uint32_t  VDMA_F2PS2;
    };

    union {
        __IO uint32_t  VDMA_F3PS1;

        struct {
            __IO uint32_t  VDMA_START_F3                  :  1;
            __IO uint32_t  VDMA_TYPE_F3                   :  1;
            __IO uint32_t  VDMA_IO_F3                     :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  VDMA_LEN_F3                    : 17;
        } VDMA_F3PS1_bits;
    };

    union {
        __IO uint32_t  VDMA_F3PS2;
    };

    union {
        __IO uint32_t  DEV_ISG3;

        struct {
            __IO uint32_t  VDMA_CMPLT_CXF                 :  1;
            __IO uint32_t  VDMA_CMPLT_F0                  :  1;
            __IO uint32_t  VDMA_CMPLT_F1                  :  1;
            __IO uint32_t  VDMA_CMPLT_F2                  :  1;
            __IO uint32_t  VDMA_CMPLT_F3                  :  1;
                 uint32_t                                 : 11;
            __IO uint32_t  VDMA_ERROR_CXF                 :  1;
            __IO uint32_t  VDMA_ERROR_F0                  :  1;
            __IO uint32_t  VDMA_ERROR_F1                  :  1;
            __IO uint32_t  VDMA_ERROR_F2                  :  1;
            __IO uint32_t  VDMA_ERROR_F3                  :  1;
        } DEV_ISG3_bits;
    };

    union {
        __IO uint32_t  DEV_MISG3;

        struct {
            __IO uint32_t  MVDMA_CMPLT_CXF                :  1;
            __IO uint32_t  MVDMA_CMPLT_F0                 :  1;
            __IO uint32_t  MVDMA_CMPLT_F1                 :  1;
            __IO uint32_t  MVDMA_CMPLT_F2                 :  1;
            __IO uint32_t  MVDMA_CMPLT_F3                 :  1;
                 uint32_t                                 : 11;
            __IO uint32_t  MVDMA_ERROR_CXF                :  1;
            __IO uint32_t  MVDMA_ERROR_F0                 :  1;
            __IO uint32_t  MVDMA_ERROR_F1                 :  1;
            __IO uint32_t  MVDMA_ERROR_F2                 :  1;
            __IO uint32_t  MVDMA_ERROR_F3                 :  1;
        } DEV_MISG3_bits;
    };

    union {
        __IO uint32_t  VDMA_CTRL;

        struct {
            __IO uint32_t  VDMA_EN                        :  1;
        } VDMA_CTRL_bits;
    };

    union {
        __IO uint32_t  LPM_CAP;

        struct {
            __IO uint32_t  LPM_WAKEUP_EN                  :  1;
        } LPM_CAP_bits;
    };

    union {
        __IO uint32_t  DEV_ISG4;

        struct {
            __IO uint32_t  L1_INT                         :  1;
        } DEV_ISG4_bits;
    };

    union {
        __IO uint32_t  DEV_MISG4;

        struct {
            __IO uint32_t  ML1_INT                        :  1;
        } DEV_MISG4_bits;
    };

/* DOM-IGNORE-END */
}AG903_USB_Type;

#define AG903_USB                                ((volatile AG903_USB_Type *) AG903_USB_BASE)                            /** USB Base Address */


#define AG903_USB_HCCAP_CAPLENGTH_POS                      0                                                             /** USBHCCAP CAPLENGTH-bit position */
#define AG903_USB_HCCAP_CAPLENGTH_MSK                      (0xffUL << AG903_USB_HCCAP_CAPLENGTH_POS)                     /** USBHCCAP CAPLENGTH-bit mask */
#define AG903_USB_HCCAP_HCIVERSION_POS                     16                                                            /** USBHCCAP HCIVERSION-bit position */
#define AG903_USB_HCCAP_HCIVERSION_MSK                     (0xffffUL << AG903_USB_HCCAP_HCIVERSION_POS)                  /** USBHCCAP HCIVERSION-bit mask */

#define AG903_USB_HCSPARAMS_N_PORTS_POS                    0                                                             /** USBHCSPARAMS N_PORTS-bit position */
#define AG903_USB_HCSPARAMS_N_PORTS_MSK                    (0xfUL << AG903_USB_HCSPARAMS_N_PORTS_POS)                    /** USBHCSPARAMS N_PORTS-bit mask */

#define AG903_USB_HCCPARAMS_PROG_FR_LIST_FLAG_POS          1                                                             /** USBHCCPARAMS PROG_FR_LIST_FLAG-bit position */
#define AG903_USB_HCCPARAMS_PROG_FR_LIST_FLAG_MSK          (0x1UL << AG903_USB_HCCPARAMS_PROG_FR_LIST_FLAG_POS)          /** USBHCCPARAMS PROG_FR_LIST_FLAG-bit mask */
#define AG903_USB_HCCPARAMS_ASYN_SCH_PARK_CAP_POS          2                                                             /** USBHCCPARAMS ASYN_SCH_PARK_CAP-bit position */
#define AG903_USB_HCCPARAMS_ASYN_SCH_PARK_CAP_MSK          (0x1UL << AG903_USB_HCCPARAMS_ASYN_SCH_PARK_CAP_POS)          /** USBHCCPARAMS ASYN_SCH_PARK_CAP-bit mask */

#define AG903_USB_USBCMD_RS_POS                            0                                                             /** USBUSBCMD RS-bit position */
#define AG903_USB_USBCMD_RS_MSK                            (0x1UL << AG903_USB_USBCMD_RS_POS)                            /** USBUSBCMD RS-bit mask */
#define AG903_USB_USBCMD_HC_RESET_POS                      1                                                             /** USBUSBCMD HC_RESET-bit position */
#define AG903_USB_USBCMD_HC_RESET_MSK                      (0x1UL << AG903_USB_USBCMD_HC_RESET_POS)                      /** USBUSBCMD HC_RESET-bit mask */
#define AG903_USB_USBCMD_FRL_SIZE_POS                      2                                                             /** USBUSBCMD FRL_SIZE-bit position */
#define AG903_USB_USBCMD_FRL_SIZE_MSK                      (0x3UL << AG903_USB_USBCMD_FRL_SIZE_POS)                      /** USBUSBCMD FRL_SIZE-bit mask */
#define AG903_USB_USBCMD_PSCH_EN_POS                       4                                                             /** USBUSBCMD PSCH_EN-bit position */
#define AG903_USB_USBCMD_PSCH_EN_MSK                       (0x1UL << AG903_USB_USBCMD_PSCH_EN_POS)                       /** USBUSBCMD PSCH_EN-bit mask */
#define AG903_USB_USBCMD_ASCH_EN_POS                       5                                                             /** USBUSBCMD ASCH_EN-bit position */
#define AG903_USB_USBCMD_ASCH_EN_MSK                       (0x1UL << AG903_USB_USBCMD_ASCH_EN_POS)                       /** USBUSBCMD ASCH_EN-bit mask */
#define AG903_USB_USBCMD_INT_OAAD_POS                      6                                                             /** USBUSBCMD INT_OAAD-bit position */
#define AG903_USB_USBCMD_INT_OAAD_MSK                      (0x1UL << AG903_USB_USBCMD_INT_OAAD_POS)                      /** USBUSBCMD INT_OAAD-bit mask */
#define AG903_USB_USBCMD_ASYN_PK_CNT_POS                   8                                                             /** USBUSBCMD ASYN_PK_CNT-bit position */
#define AG903_USB_USBCMD_ASYN_PK_CNT_MSK                   (0x3UL << AG903_USB_USBCMD_ASYN_PK_CNT_POS)                   /** USBUSBCMD ASYN_PK_CNT-bit mask */
#define AG903_USB_USBCMD_ASYN_PK_EN_POS                    11                                                            /** USBUSBCMD ASYN_PK_EN-bit position */
#define AG903_USB_USBCMD_ASYN_PK_EN_MSK                    (0x1UL << AG903_USB_USBCMD_ASYN_PK_EN_POS)                    /** USBUSBCMD ASYN_PK_EN-bit mask */
#define AG903_USB_USBCMD_INT_THRC_POS                      16                                                            /** USBUSBCMD INT_THRC-bit position */
#define AG903_USB_USBCMD_INT_THRC_MSK                      (0xffUL << AG903_USB_USBCMD_INT_THRC_POS)                     /** USBUSBCMD INT_THRC-bit mask */

#define AG903_USB_USBSTS_USB_INT_POS                       0                                                             /** USBUSBSTS USB_INT-bit position */
#define AG903_USB_USBSTS_USB_INT_MSK                       (0x1UL << AG903_USB_USBSTS_USB_INT_POS)                       /** USBUSBSTS USB_INT-bit mask */
#define AG903_USB_USBSTS_USBERR_INT_POS                    1                                                             /** USBUSBSTS USBERR_INT-bit position */
#define AG903_USB_USBSTS_USBERR_INT_MSK                    (0x1UL << AG903_USB_USBSTS_USBERR_INT_POS)                    /** USBUSBSTS USBERR_INT-bit mask */
#define AG903_USB_USBSTS_PO_CHG_DET_POS                    2                                                             /** USBUSBSTS PO_CHG_DET-bit position */
#define AG903_USB_USBSTS_PO_CHG_DET_MSK                    (0x1UL << AG903_USB_USBSTS_PO_CHG_DET_POS)                    /** USBUSBSTS PO_CHG_DET-bit mask */
#define AG903_USB_USBSTS_FRL_ROL_POS                       3                                                             /** USBUSBSTS FRL_ROL-bit position */
#define AG903_USB_USBSTS_FRL_ROL_MSK                       (0x1UL << AG903_USB_USBSTS_FRL_ROL_POS)                       /** USBUSBSTS FRL_ROL-bit mask */
#define AG903_USB_USBSTS_H_SYSERR_POS                      4                                                             /** USBUSBSTS H_SYSERR-bit position */
#define AG903_USB_USBSTS_H_SYSERR_MSK                      (0x1UL << AG903_USB_USBSTS_H_SYSERR_POS)                      /** USBUSBSTS H_SYSERR-bit mask */
#define AG903_USB_USBSTS_INT_OAA_POS                       5                                                             /** USBUSBSTS INT_OAA-bit position */
#define AG903_USB_USBSTS_INT_OAA_MSK                       (0x1UL << AG903_USB_USBSTS_INT_OAA_POS)                       /** USBUSBSTS INT_OAA-bit mask */
#define AG903_USB_USBSTS_HCHalted_POS                      12                                                            /** USBUSBSTS HCHalted-bit position */
#define AG903_USB_USBSTS_HCHalted_MSK                      (0x1UL << AG903_USB_USBSTS_HCHalted_POS)                      /** USBUSBSTS HCHalted-bit mask */
#define AG903_USB_USBSTS_Reclamation_POS                   13                                                            /** USBUSBSTS Reclamation-bit position */
#define AG903_USB_USBSTS_Reclamation_MSK                   (0x1UL << AG903_USB_USBSTS_Reclamation_POS)                   /** USBUSBSTS Reclamation-bit mask */
#define AG903_USB_USBSTS_PSCH_STS_POS                      14                                                            /** USBUSBSTS PSCH_STS-bit position */
#define AG903_USB_USBSTS_PSCH_STS_MSK                      (0x1UL << AG903_USB_USBSTS_PSCH_STS_POS)                      /** USBUSBSTS PSCH_STS-bit mask */
#define AG903_USB_USBSTS_ASCH_STS_POS                      15                                                            /** USBUSBSTS ASCH_STS-bit position */
#define AG903_USB_USBSTS_ASCH_STS_MSK                      (0x1UL << AG903_USB_USBSTS_ASCH_STS_POS)                      /** USBUSBSTS ASCH_STS-bit mask */

#define AG903_USB_USBINTR_USB_INT_EN_POS                   0                                                             /** USBUSBINTR USB_INT_EN-bit position */
#define AG903_USB_USBINTR_USB_INT_EN_MSK                   (0x1UL << AG903_USB_USBINTR_USB_INT_EN_POS)                   /** USBUSBINTR USB_INT_EN-bit mask */
#define AG903_USB_USBINTR_USBERR_INT_EN_POS                1                                                             /** USBUSBINTR USBERR_INT_EN-bit position */
#define AG903_USB_USBINTR_USBERR_INT_EN_MSK                (0x1UL << AG903_USB_USBINTR_USBERR_INT_EN_POS)                /** USBUSBINTR USBERR_INT_EN-bit mask */
#define AG903_USB_USBINTR_PO_CHG_INT_EN_POS                2                                                             /** USBUSBINTR PO_CHG_INT_EN-bit position */
#define AG903_USB_USBINTR_PO_CHG_INT_EN_MSK                (0x1UL << AG903_USB_USBINTR_PO_CHG_INT_EN_POS)                /** USBUSBINTR PO_CHG_INT_EN-bit mask */
#define AG903_USB_USBINTR_FRL_ROL_EN_POS                   3                                                             /** USBUSBINTR FRL_ROL_EN-bit position */
#define AG903_USB_USBINTR_FRL_ROL_EN_MSK                   (0x1UL << AG903_USB_USBINTR_FRL_ROL_EN_POS)                   /** USBUSBINTR FRL_ROL_EN-bit mask */
#define AG903_USB_USBINTR_H_SYSERR_EN_POS                  4                                                             /** USBUSBINTR H_SYSERR_EN-bit position */
#define AG903_USB_USBINTR_H_SYSERR_EN_MSK                  (0x1UL << AG903_USB_USBINTR_H_SYSERR_EN_POS)                  /** USBUSBINTR H_SYSERR_EN-bit mask */
#define AG903_USB_USBINTR_INT_OAA_EN_POS                   5                                                             /** USBUSBINTR INT_OAA_EN-bit position */
#define AG903_USB_USBINTR_INT_OAA_EN_MSK                   (0x1UL << AG903_USB_USBINTR_INT_OAA_EN_POS)                   /** USBUSBINTR INT_OAA_EN-bit mask */

#define AG903_USB_FRINDEX_FRINDEX_POS                      0                                                             /** USBFRINDEX FRINDEX-bit position */
#define AG903_USB_FRINDEX_FRINDEX_MSK                      (0x3fffUL << AG903_USB_FRINDEX_FRINDEX_POS)                   /** USBFRINDEX FRINDEX-bit mask */

#define AG903_USB_PERIODICLISTBASE_PERI_BASADR_POS         12                                                            /** USBPERIODICLISTBASE PERI_BASADR-bit position */
#define AG903_USB_PERIODICLISTBASE_PERI_BASADR_MSK         (0xfffffUL << AG903_USB_PERIODICLISTBASE_PERI_BASADR_POS)     /** USBPERIODICLISTBASE PERI_BASADR-bit mask */

#define AG903_USB_ASYNCLISTADDR_Async_ladr_POS             5                                                             /** USBASYNCLISTADDR Async_ladr-bit position */
#define AG903_USB_ASYNCLISTADDR_Async_ladr_MSK             (0x7ffffffUL << AG903_USB_ASYNCLISTADDR_Async_ladr_POS)       /** USBASYNCLISTADDR Async_ladr-bit mask */

#define AG903_USB_PORTSC_CONN_STS_POS                      0                                                             /** USBPORTSC CONN_STS-bit position */
#define AG903_USB_PORTSC_CONN_STS_MSK                      (0x1UL << AG903_USB_PORTSC_CONN_STS_POS)                      /** USBPORTSC CONN_STS-bit mask */
#define AG903_USB_PORTSC_CONN_CHG_POS                      1                                                             /** USBPORTSC CONN_CHG-bit position */
#define AG903_USB_PORTSC_CONN_CHG_MSK                      (0x1UL << AG903_USB_PORTSC_CONN_CHG_POS)                      /** USBPORTSC CONN_CHG-bit mask */
#define AG903_USB_PORTSC_PO_EN_POS                         2                                                             /** USBPORTSC PO_EN-bit position */
#define AG903_USB_PORTSC_PO_EN_MSK                         (0x1UL << AG903_USB_PORTSC_PO_EN_POS)                         /** USBPORTSC PO_EN-bit mask */
#define AG903_USB_PORTSC_PO_EN_CHG_POS                     3                                                             /** USBPORTSC PO_EN_CHG-bit position */
#define AG903_USB_PORTSC_PO_EN_CHG_MSK                     (0x1UL << AG903_USB_PORTSC_PO_EN_CHG_POS)                     /** USBPORTSC PO_EN_CHG-bit mask */
#define AG903_USB_PORTSC_F_PO_RESM_POS                     6                                                             /** USBPORTSC F_PO_RESM-bit position */
#define AG903_USB_PORTSC_F_PO_RESM_MSK                     (0x1UL << AG903_USB_PORTSC_F_PO_RESM_POS)                     /** USBPORTSC F_PO_RESM-bit mask */
#define AG903_USB_PORTSC_PO_SUSP_POS                       7                                                             /** USBPORTSC PO_SUSP-bit position */
#define AG903_USB_PORTSC_PO_SUSP_MSK                       (0x1UL << AG903_USB_PORTSC_PO_SUSP_POS)                       /** USBPORTSC PO_SUSP-bit mask */
#define AG903_USB_PORTSC_PO_RESET_POS                      8                                                             /** USBPORTSC PO_RESET-bit position */
#define AG903_USB_PORTSC_PO_RESET_MSK                      (0x1UL << AG903_USB_PORTSC_PO_RESET_POS)                      /** USBPORTSC PO_RESET-bit mask */
#define AG903_USB_PORTSC_LINE_STS_POS                      10                                                            /** USBPORTSC LINE_STS-bit position */
#define AG903_USB_PORTSC_LINE_STS_MSK                      (0x3UL << AG903_USB_PORTSC_LINE_STS_POS)                      /** USBPORTSC LINE_STS-bit mask */
#define AG903_USB_PORTSC_PORT_TEST_POS                     16                                                            /** USBPORTSC PORT_TEST-bit position */
#define AG903_USB_PORTSC_PORT_TEST_MSK                     (0xfUL << AG903_USB_PORTSC_PORT_TEST_POS)                     /** USBPORTSC PORT_TEST-bit mask */
#define AG903_USB_PORTSC_HC_TST_PKDONE_POS                 20                                                            /** USBPORTSC HC_TST_PKDONE-bit position */
#define AG903_USB_PORTSC_HC_TST_PKDONE_MSK                 (0x1UL << AG903_USB_PORTSC_HC_TST_PKDONE_POS)                 /** USBPORTSC HC_TST_PKDONE-bit mask */

#define AG903_USB_HCMISC_ASYN_SCH_SLPT_POS                 0                                                             /** USBHCMISC ASYN_SCH_SLPT-bit position */
#define AG903_USB_HCMISC_ASYN_SCH_SLPT_MSK                 (0x3UL << AG903_USB_HCMISC_ASYN_SCH_SLPT_POS)                 /** USBHCMISC ASYN_SCH_SLPT-bit mask */
#define AG903_USB_HCMISC_EOF1_Time_POS                     2                                                             /** USBHCMISC EOF1_Time-bit position */
#define AG903_USB_HCMISC_EOF1_Time_MSK                     (0x3UL << AG903_USB_HCMISC_EOF1_Time_POS)                     /** USBHCMISC EOF1_Time-bit mask */
#define AG903_USB_HCMISC_EOF2_Time_POS                     4                                                             /** USBHCMISC EOF2_Time-bit position */
#define AG903_USB_HCMISC_EOF2_Time_MSK                     (0x3UL << AG903_USB_HCMISC_EOF2_Time_POS)                     /** USBHCMISC EOF2_Time-bit mask */
#define AG903_USB_HCMISC_HostPhy_Suspend_POS               6                                                             /** USBHCMISC HostPhy_Suspend-bit position */
#define AG903_USB_HCMISC_HostPhy_Suspend_MSK               (0x1UL << AG903_USB_HCMISC_HostPhy_Suspend_POS)               /** USBHCMISC HostPhy_Suspend-bit mask */

#define AG903_USB_FS_EOF_FS_EOF1_Time_POS                  0                                                             /** USBFS_EOF FS_EOF1_Time-bit position */
#define AG903_USB_FS_EOF_FS_EOF1_Time_MSK                  (0xfffUL << AG903_USB_FS_EOF_FS_EOF1_Time_POS)                /** USBFS_EOF FS_EOF1_Time-bit mask */
#define AG903_USB_FS_EOF_FS_EOF1_Time_125us_POS            12                                                            /** USBFS_EOF FS_EOF1_Time_125us-bit position */
#define AG903_USB_FS_EOF_FS_EOF1_Time_125us_MSK            (0x7UL << AG903_USB_FS_EOF_FS_EOF1_Time_125us_POS)            /** USBFS_EOF FS_EOF1_Time_125us-bit mask */

#define AG903_USB_HS_EOF_HS_EOF1_Time_POS                  0                                                             /** USBHS_EOF HS_EOF1_Time-bit position */
#define AG903_USB_HS_EOF_HS_EOF1_Time_MSK                  (0xfffUL << AG903_USB_HS_EOF_HS_EOF1_Time_POS)                /** USBHS_EOF HS_EOF1_Time-bit mask */

#define AG903_USB_OTG_CSR_B_BUS_REQ_POS                    0                                                             /** USBOTG_CSR B_BUS_REQ-bit position */
#define AG903_USB_OTG_CSR_B_BUS_REQ_MSK                    (0x1UL << AG903_USB_OTG_CSR_B_BUS_REQ_POS)                    /** USBOTG_CSR B_BUS_REQ-bit mask */
#define AG903_USB_OTG_CSR_B_HNP_EN_POS                     1                                                             /** USBOTG_CSR B_HNP_EN-bit position */
#define AG903_USB_OTG_CSR_B_HNP_EN_MSK                     (0x1UL << AG903_USB_OTG_CSR_B_HNP_EN_POS)                     /** USBOTG_CSR B_HNP_EN-bit mask */
#define AG903_USB_OTG_CSR_B_DSCHRG_VBUS_POS                2                                                             /** USBOTG_CSR B_DSCHRG_VBUS-bit position */
#define AG903_USB_OTG_CSR_B_DSCHRG_VBUS_MSK                (0x1UL << AG903_USB_OTG_CSR_B_DSCHRG_VBUS_POS)                /** USBOTG_CSR B_DSCHRG_VBUS-bit mask */
#define AG903_USB_OTG_CSR_A_BUS_REQ_POS                    4                                                             /** USBOTG_CSR A_BUS_REQ-bit position */
#define AG903_USB_OTG_CSR_A_BUS_REQ_MSK                    (0x1UL << AG903_USB_OTG_CSR_A_BUS_REQ_POS)                    /** USBOTG_CSR A_BUS_REQ-bit mask */
#define AG903_USB_OTG_CSR_A_BUS_DROP_POS                   5                                                             /** USBOTG_CSR A_BUS_DROP-bit position */
#define AG903_USB_OTG_CSR_A_BUS_DROP_MSK                   (0x1UL << AG903_USB_OTG_CSR_A_BUS_DROP_POS)                   /** USBOTG_CSR A_BUS_DROP-bit mask */
#define AG903_USB_OTG_CSR_A_SET_B_HNP_EN_POS               6                                                             /** USBOTG_CSR A_SET_B_HNP_EN-bit position */
#define AG903_USB_OTG_CSR_A_SET_B_HNP_EN_MSK               (0x1UL << AG903_USB_OTG_CSR_A_SET_B_HNP_EN_POS)               /** USBOTG_CSR A_SET_B_HNP_EN-bit mask */
#define AG903_USB_OTG_CSR_A_SRP_DET_EN_POS                 7                                                             /** USBOTG_CSR A_SRP_DET_EN-bit position */
#define AG903_USB_OTG_CSR_A_SRP_DET_EN_MSK                 (0x1UL << AG903_USB_OTG_CSR_A_SRP_DET_EN_POS)                 /** USBOTG_CSR A_SRP_DET_EN-bit mask */
#define AG903_USB_OTG_CSR_A_SRP_RESP_TYP_POS               8                                                             /** USBOTG_CSR A_SRP_RESP_TYP-bit position */
#define AG903_USB_OTG_CSR_A_SRP_RESP_TYP_MSK               (0x1UL << AG903_USB_OTG_CSR_A_SRP_RESP_TYP_POS)               /** USBOTG_CSR A_SRP_RESP_TYP-bit mask */
#define AG903_USB_OTG_CSR_ID_FLT_SEL_POS                   9                                                             /** USBOTG_CSR ID_FLT_SEL-bit position */
#define AG903_USB_OTG_CSR_ID_FLT_SEL_MSK                   (0x1UL << AG903_USB_OTG_CSR_ID_FLT_SEL_POS)                   /** USBOTG_CSR ID_FLT_SEL-bit mask */
#define AG903_USB_OTG_CSR_VBUS_FLT_SEL_POS                 10                                                            /** USBOTG_CSR VBUS_FLT_SEL-bit position */
#define AG903_USB_OTG_CSR_VBUS_FLT_SEL_MSK                 (0x1UL << AG903_USB_OTG_CSR_VBUS_FLT_SEL_POS)                 /** USBOTG_CSR VBUS_FLT_SEL-bit mask */
#define AG903_USB_OTG_CSR_HDISCON_FLT_SEL_POS              11                                                            /** USBOTG_CSR HDISCON_FLT_SEL-bit position */
#define AG903_USB_OTG_CSR_HDISCON_FLT_SEL_MSK              (0x1UL << AG903_USB_OTG_CSR_HDISCON_FLT_SEL_POS)              /** USBOTG_CSR HDISCON_FLT_SEL-bit mask */
#define AG903_USB_OTG_CSR_IDPULUP_POS                      13                                                            /** USBOTG_CSR IDPULUP-bit position */
#define AG903_USB_OTG_CSR_IDPULUP_MSK                      (0x1UL << AG903_USB_OTG_CSR_IDPULUP_POS)                      /** USBOTG_CSR IDPULUP-bit mask */
#define AG903_USB_OTG_CSR_B_SESS_END_POS                   16                                                            /** USBOTG_CSR B_SESS_END-bit position */
#define AG903_USB_OTG_CSR_B_SESS_END_MSK                   (0x1UL << AG903_USB_OTG_CSR_B_SESS_END_POS)                   /** USBOTG_CSR B_SESS_END-bit mask */
#define AG903_USB_OTG_CSR_B_SESS_VLD_POS                   17                                                            /** USBOTG_CSR B_SESS_VLD-bit position */
#define AG903_USB_OTG_CSR_B_SESS_VLD_MSK                   (0x1UL << AG903_USB_OTG_CSR_B_SESS_VLD_POS)                   /** USBOTG_CSR B_SESS_VLD-bit mask */
#define AG903_USB_OTG_CSR_A_SESS_VLD_POS                   18                                                            /** USBOTG_CSR A_SESS_VLD-bit position */
#define AG903_USB_OTG_CSR_A_SESS_VLD_MSK                   (0x1UL << AG903_USB_OTG_CSR_A_SESS_VLD_POS)                   /** USBOTG_CSR A_SESS_VLD-bit mask */
#define AG903_USB_OTG_CSR_VBUS_VLD_POS                     19                                                            /** USBOTG_CSR VBUS_VLD-bit position */
#define AG903_USB_OTG_CSR_VBUS_VLD_MSK                     (0x1UL << AG903_USB_OTG_CSR_VBUS_VLD_POS)                     /** USBOTG_CSR VBUS_VLD-bit mask */
#define AG903_USB_OTG_CSR_CROLE_POS                        20                                                            /** USBOTG_CSR CROLE-bit position */
#define AG903_USB_OTG_CSR_CROLE_MSK                        (0x1UL << AG903_USB_OTG_CSR_CROLE_POS)                        /** USBOTG_CSR CROLE-bit mask */
#define AG903_USB_OTG_CSR_ID_POS                           21                                                            /** USBOTG_CSR ID-bit position */
#define AG903_USB_OTG_CSR_ID_MSK                           (0x1UL << AG903_USB_OTG_CSR_ID_POS)                           /** USBOTG_CSR ID-bit mask */
#define AG903_USB_OTG_CSR_SPD_TYP_POS                      22                                                            /** USBOTG_CSR SPD_TYP-bit position */
#define AG903_USB_OTG_CSR_SPD_TYP_MSK                      (0x3UL << AG903_USB_OTG_CSR_SPD_TYP_POS)                      /** USBOTG_CSR SPD_TYP-bit mask */

#define AG903_USB_OTG_ISR_B_SRP_DN_POS                     0                                                             /** USBOTG_ISR B_SRP_DN-bit position */
#define AG903_USB_OTG_ISR_B_SRP_DN_MSK                     (0x1UL << AG903_USB_OTG_ISR_B_SRP_DN_POS)                     /** USBOTG_ISR B_SRP_DN-bit mask */
#define AG903_USB_OTG_ISR_A_SRP_DET_POS                    4                                                             /** USBOTG_ISR A_SRP_DET-bit position */
#define AG903_USB_OTG_ISR_A_SRP_DET_MSK                    (0x1UL << AG903_USB_OTG_ISR_A_SRP_DET_POS)                    /** USBOTG_ISR A_SRP_DET-bit mask */
#define AG903_USB_OTG_ISR_A_VBUS_ERR_POS                   5                                                             /** USBOTG_ISR A_VBUS_ERR-bit position */
#define AG903_USB_OTG_ISR_A_VBUS_ERR_MSK                   (0x1UL << AG903_USB_OTG_ISR_A_VBUS_ERR_POS)                   /** USBOTG_ISR A_VBUS_ERR-bit mask */
#define AG903_USB_OTG_ISR_B_SESS_END_POS                   6                                                             /** USBOTG_ISR B_SESS_END-bit position */
#define AG903_USB_OTG_ISR_B_SESS_END_MSK                   (0x1UL << AG903_USB_OTG_ISR_B_SESS_END_POS)                   /** USBOTG_ISR B_SESS_END-bit mask */
#define AG903_USB_OTG_ISR_RLCHG_POS                        8                                                             /** USBOTG_ISR RLCHG-bit position */
#define AG903_USB_OTG_ISR_RLCHG_MSK                        (0x1UL << AG903_USB_OTG_ISR_RLCHG_POS)                        /** USBOTG_ISR RLCHG-bit mask */
#define AG903_USB_OTG_ISR_IDCHG_POS                        9                                                             /** USBOTG_ISR IDCHG-bit position */
#define AG903_USB_OTG_ISR_IDCHG_MSK                        (0x1UL << AG903_USB_OTG_ISR_IDCHG_POS)                        /** USBOTG_ISR IDCHG-bit mask */
#define AG903_USB_OTG_ISR_OVC_POS                          10                                                            /** USBOTG_ISR OVC-bit position */
#define AG903_USB_OTG_ISR_OVC_MSK                          (0x1UL << AG903_USB_OTG_ISR_OVC_POS)                          /** USBOTG_ISR OVC-bit mask */
#define AG903_USB_OTG_ISR_A_WAIT_CON_POS                   11                                                            /** USBOTG_ISR A_WAIT_CON-bit position */
#define AG903_USB_OTG_ISR_A_WAIT_CON_MSK                   (0x1UL << AG903_USB_OTG_ISR_A_WAIT_CON_POS)                   /** USBOTG_ISR A_WAIT_CON-bit mask */
#define AG903_USB_OTG_ISR_APLGRMV_POS                      12                                                            /** USBOTG_ISR APLGRMV-bit position */
#define AG903_USB_OTG_ISR_APLGRMV_MSK                      (0x1UL << AG903_USB_OTG_ISR_APLGRMV_POS)                      /** USBOTG_ISR APLGRMV-bit mask */

#define AG903_USB_OTG_IER_B_SRP_DN_EN_POS                  0                                                             /** USBOTG_IER B_SRP_DN_EN-bit position */
#define AG903_USB_OTG_IER_B_SRP_DN_EN_MSK                  (0x1UL << AG903_USB_OTG_IER_B_SRP_DN_EN_POS)                  /** USBOTG_IER B_SRP_DN_EN-bit mask */
#define AG903_USB_OTG_IER_A_SRP_DET_EN_POS                 4                                                             /** USBOTG_IER A_SRP_DET_EN-bit position */
#define AG903_USB_OTG_IER_A_SRP_DET_EN_MSK                 (0x1UL << AG903_USB_OTG_IER_A_SRP_DET_EN_POS)                 /** USBOTG_IER A_SRP_DET_EN-bit mask */
#define AG903_USB_OTG_IER_A_VBUS_ERR_EN_POS                5                                                             /** USBOTG_IER A_VBUS_ERR_EN-bit position */
#define AG903_USB_OTG_IER_A_VBUS_ERR_EN_MSK                (0x1UL << AG903_USB_OTG_IER_A_VBUS_ERR_EN_POS)                /** USBOTG_IER A_VBUS_ERR_EN-bit mask */
#define AG903_USB_OTG_IER_B_SESS_END_EN_POS                6                                                             /** USBOTG_IER B_SESS_END_EN-bit position */
#define AG903_USB_OTG_IER_B_SESS_END_EN_MSK                (0x1UL << AG903_USB_OTG_IER_B_SESS_END_EN_POS)                /** USBOTG_IER B_SESS_END_EN-bit mask */
#define AG903_USB_OTG_IER_RLCHG_EN_POS                     8                                                             /** USBOTG_IER RLCHG_EN-bit position */
#define AG903_USB_OTG_IER_RLCHG_EN_MSK                     (0x1UL << AG903_USB_OTG_IER_RLCHG_EN_POS)                     /** USBOTG_IER RLCHG_EN-bit mask */
#define AG903_USB_OTG_IER_IDCHG_EN_POS                     9                                                             /** USBOTG_IER IDCHG_EN-bit position */
#define AG903_USB_OTG_IER_IDCHG_EN_MSK                     (0x1UL << AG903_USB_OTG_IER_IDCHG_EN_POS)                     /** USBOTG_IER IDCHG_EN-bit mask */
#define AG903_USB_OTG_IER_OVC_EN_POS                       10                                                            /** USBOTG_IER OVC_EN-bit position */
#define AG903_USB_OTG_IER_OVC_EN_MSK                       (0x1UL << AG903_USB_OTG_IER_OVC_EN_POS)                       /** USBOTG_IER OVC_EN-bit mask */
#define AG903_USB_OTG_IER_A_WAIT_CON_EN_POS                11                                                            /** USBOTG_IER A_WAIT_CON_EN-bit position */
#define AG903_USB_OTG_IER_A_WAIT_CON_EN_MSK                (0x1UL << AG903_USB_OTG_IER_A_WAIT_CON_EN_POS)                /** USBOTG_IER A_WAIT_CON_EN-bit mask */
#define AG903_USB_OTG_IER_APLGRMV_EN_POS                   12                                                            /** USBOTG_IER APLGRMV_EN-bit position */
#define AG903_USB_OTG_IER_APLGRMV_EN_MSK                   (0x1UL << AG903_USB_OTG_IER_APLGRMV_EN_POS)                   /** USBOTG_IER APLGRMV_EN-bit mask */

#define AG903_USB_GLB_ISR_DEV_INT_POS                      0                                                             /** USBGLB_ISR DEV_INT-bit position */
#define AG903_USB_GLB_ISR_DEV_INT_MSK                      (0x1UL << AG903_USB_GLB_ISR_DEV_INT_POS)                      /** USBGLB_ISR DEV_INT-bit mask */
#define AG903_USB_GLB_ISR_OTG_INT_POS                      1                                                             /** USBGLB_ISR OTG_INT-bit position */
#define AG903_USB_GLB_ISR_OTG_INT_MSK                      (0x1UL << AG903_USB_GLB_ISR_OTG_INT_POS)                      /** USBGLB_ISR OTG_INT-bit mask */
#define AG903_USB_GLB_ISR_HC_INT_POS                       2                                                             /** USBGLB_ISR HC_INT-bit position */
#define AG903_USB_GLB_ISR_HC_INT_MSK                       (0x1UL << AG903_USB_GLB_ISR_HC_INT_POS)                       /** USBGLB_ISR HC_INT-bit mask */

#define AG903_USB_GLB_INT_MDEV_INT_POS                     0                                                             /** USBGLB_INT MDEV_INT-bit position */
#define AG903_USB_GLB_INT_MDEV_INT_MSK                     (0x1UL << AG903_USB_GLB_INT_MDEV_INT_POS)                     /** USBGLB_INT MDEV_INT-bit mask */
#define AG903_USB_GLB_INT_MOTG_INT_POS                     1                                                             /** USBGLB_INT MOTG_INT-bit position */
#define AG903_USB_GLB_INT_MOTG_INT_MSK                     (0x1UL << AG903_USB_GLB_INT_MOTG_INT_POS)                     /** USBGLB_INT MOTG_INT-bit mask */
#define AG903_USB_GLB_INT_MHC_INT_POS                      2                                                             /** USBGLB_INT MHC_INT-bit position */
#define AG903_USB_GLB_INT_MHC_INT_MSK                      (0x1UL << AG903_USB_GLB_INT_MHC_INT_POS)                      /** USBGLB_INT MHC_INT-bit mask */
#define AG903_USB_GLB_INT_INT_POLARITY_POS                 3                                                             /** USBGLB_INT INT_POLARITY-bit position */
#define AG903_USB_GLB_INT_INT_POLARITY_MSK                 (0x1UL << AG903_USB_GLB_INT_INT_POLARITY_POS)                 /** USBGLB_INT INT_POLARITY-bit mask */

#define AG903_USB_REVISION_REVISION_POS                    0                                                             /** USBREVISION REVISION-bit position */
#define AG903_USB_REVISION_REVISION_MSK                    (0xffffffffUL << AG903_USB_REVISION_REVISION_POS)             /** USBREVISION REVISION-bit mask */

#define AG903_USB_FEATURE_DMABUFSIZE_POS                   0                                                             /** USBFEATURE DMABUFSIZE-bit position */
#define AG903_USB_FEATURE_DMABUFSIZE_MSK                   (0x1fUL << AG903_USB_FEATURE_DMABUFSIZE_POS)                  /** USBFEATURE DMABUFSIZE-bit mask */
#define AG903_USB_FEATURE_FIFO_NUM_POS                     5                                                             /** USBFEATURE FIFO_NUM-bit position */
#define AG903_USB_FEATURE_FIFO_NUM_MSK                     (0xfUL << AG903_USB_FEATURE_FIFO_NUM_POS)                     /** USBFEATURE FIFO_NUM-bit mask */
#define AG903_USB_FEATURE_EP_NUM_POS                       9                                                             /** USBFEATURE EP_NUM-bit position */
#define AG903_USB_FEATURE_EP_NUM_MSK                       (0x1fUL << AG903_USB_FEATURE_EP_NUM_POS)                      /** USBFEATURE EP_NUM-bit mask */
#define AG903_USB_FEATURE_DEV_ONLY_POS                     14                                                            /** USBFEATURE DEV_ONLY-bit position */
#define AG903_USB_FEATURE_DEV_ONLY_MSK                     (0x1UL << AG903_USB_FEATURE_DEV_ONLY_POS)                     /** USBFEATURE DEV_ONLY-bit mask */
#define AG903_USB_FEATURE_HOST_ONLY_POS                    15                                                            /** USBFEATURE HOST_ONLY-bit position */
#define AG903_USB_FEATURE_HOST_ONLY_MSK                    (0x1UL << AG903_USB_FEATURE_HOST_ONLY_POS)                    /** USBFEATURE HOST_ONLY-bit mask */
#define AG903_USB_FEATURE_BULK_ONLY_POS                    16                                                            /** USBFEATURE BULK_ONLY-bit position */
#define AG903_USB_FEATURE_BULK_ONLY_MSK                    (0x1UL << AG903_USB_FEATURE_BULK_ONLY_POS)                    /** USBFEATURE BULK_ONLY-bit mask */
#define AG903_USB_FEATURE_HS_DIS_POS                       17                                                            /** USBFEATURE HS_DIS-bit position */
#define AG903_USB_FEATURE_HS_DIS_MSK                       (0x1UL << AG903_USB_FEATURE_HS_DIS_POS)                       /** USBFEATURE HS_DIS-bit mask */

#define AG903_USB_DEV_CTL_CAP_RMWAKUP_POS                  0                                                             /** USBDEV_CTL CAP_RMWAKUP-bit position */
#define AG903_USB_DEV_CTL_CAP_RMWAKUP_MSK                  (0x1UL << AG903_USB_DEV_CTL_CAP_RMWAKUP_POS)                  /** USBDEV_CTL CAP_RMWAKUP-bit mask */
#define AG903_USB_DEV_CTL_HALF_SPEED_POS                   1                                                             /** USBDEV_CTL HALF_SPEED-bit position */
#define AG903_USB_DEV_CTL_HALF_SPEED_MSK                   (0x1UL << AG903_USB_DEV_CTL_HALF_SPEED_POS)                   /** USBDEV_CTL HALF_SPEED-bit mask */
#define AG903_USB_DEV_CTL_GLINT_EN_POS                     2                                                             /** USBDEV_CTL GLINT_EN-bit position */
#define AG903_USB_DEV_CTL_GLINT_EN_MSK                     (0x1UL << AG903_USB_DEV_CTL_GLINT_EN_POS)                     /** USBDEV_CTL GLINT_EN-bit mask */
#define AG903_USB_DEV_CTL_GOSUSP_POS                       3                                                             /** USBDEV_CTL GOSUSP-bit position */
#define AG903_USB_DEV_CTL_GOSUSP_MSK                       (0x1UL << AG903_USB_DEV_CTL_GOSUSP_POS)                       /** USBDEV_CTL GOSUSP-bit mask */
#define AG903_USB_DEV_CTL_SFRST_POS                        4                                                             /** USBDEV_CTL SFRST-bit position */
#define AG903_USB_DEV_CTL_SFRST_MSK                        (0x1UL << AG903_USB_DEV_CTL_SFRST_POS)                        /** USBDEV_CTL SFRST-bit mask */
#define AG903_USB_DEV_CTL_CHIP_EN_POS                      5                                                             /** USBDEV_CTL CHIP_EN-bit position */
#define AG903_USB_DEV_CTL_CHIP_EN_MSK                      (0x1UL << AG903_USB_DEV_CTL_CHIP_EN_POS)                      /** USBDEV_CTL CHIP_EN-bit mask */
#define AG903_USB_DEV_CTL_HS_EN_POS                        6                                                             /** USBDEV_CTL HS_EN-bit position */
#define AG903_USB_DEV_CTL_HS_EN_MSK                        (0x1UL << AG903_USB_DEV_CTL_HS_EN_POS)                        /** USBDEV_CTL HS_EN-bit mask */
#define AG903_USB_DEV_CTL_SYSBUS_WIDTH_POS                 7                                                             /** USBDEV_CTL SYSBUS_WIDTH-bit position */
#define AG903_USB_DEV_CTL_SYSBUS_WIDTH_MSK                 (0x1UL << AG903_USB_DEV_CTL_SYSBUS_WIDTH_POS)                 /** USBDEV_CTL SYSBUS_WIDTH-bit mask */
#define AG903_USB_DEV_CTL_FORCE_FS_POS                     9                                                             /** USBDEV_CTL FORCE_FS-bit position */
#define AG903_USB_DEV_CTL_FORCE_FS_MSK                     (0x1UL << AG903_USB_DEV_CTL_FORCE_FS_POS)                     /** USBDEV_CTL FORCE_FS-bit mask */
#define AG903_USB_DEV_CTL_IDLE_DEGLITCH_POS                10                                                            /** USBDEV_CTL IDLE_DEGLITCH-bit position */
#define AG903_USB_DEV_CTL_IDLE_DEGLITCH_MSK                (0x3UL << AG903_USB_DEV_CTL_IDLE_DEGLITCH_POS)                /** USBDEV_CTL IDLE_DEGLITCH-bit mask */
#define AG903_USB_DEV_CTL_LPM_BESL_MAX_POS                 12                                                            /** USBDEV_CTL LPM_BESL_MAX-bit position */
#define AG903_USB_DEV_CTL_LPM_BESL_MAX_MSK                 (0xfUL << AG903_USB_DEV_CTL_LPM_BESL_MAX_POS)                 /** USBDEV_CTL LPM_BESL_MAX-bit mask */
#define AG903_USB_DEV_CTL_LPM_BESL_MIN_POS                 16                                                            /** USBDEV_CTL LPM_BESL_MIN-bit position */
#define AG903_USB_DEV_CTL_LPM_BESL_MIN_MSK                 (0xfUL << AG903_USB_DEV_CTL_LPM_BESL_MIN_POS)                 /** USBDEV_CTL LPM_BESL_MIN-bit mask */
#define AG903_USB_DEV_CTL_LPM_BESL_POS                     20                                                            /** USBDEV_CTL LPM_BESL-bit position */
#define AG903_USB_DEV_CTL_LPM_BESL_MSK                     (0xfUL << AG903_USB_DEV_CTL_LPM_BESL_POS)                     /** USBDEV_CTL LPM_BESL-bit mask */
#define AG903_USB_DEV_CTL_LPM_EN_POS                       25                                                            /** USBDEV_CTL LPM_EN-bit position */
#define AG903_USB_DEV_CTL_LPM_EN_MSK                       (0x1UL << AG903_USB_DEV_CTL_LPM_EN_POS)                       /** USBDEV_CTL LPM_EN-bit mask */
#define AG903_USB_DEV_CTL_LPM_ACCEPT_POS                   26                                                            /** USBDEV_CTL LPM_ACCEPT-bit position */
#define AG903_USB_DEV_CTL_LPM_ACCEPT_MSK                   (0x1UL << AG903_USB_DEV_CTL_LPM_ACCEPT_POS)                   /** USBDEV_CTL LPM_ACCEPT-bit mask */

#define AG903_USB_DEV_ADR_DEVADR_POS                       0                                                             /** USBDEV_ADR DEVADR-bit position */
#define AG903_USB_DEV_ADR_DEVADR_MSK                       (0x7fUL << AG903_USB_DEV_ADR_DEVADR_POS)                      /** USBDEV_ADR DEVADR-bit mask */
#define AG903_USB_DEV_ADR_AFT_CONF_POS                     7                                                             /** USBDEV_ADR AFT_CONF-bit position */
#define AG903_USB_DEV_ADR_AFT_CONF_MSK                     (0x1UL << AG903_USB_DEV_ADR_AFT_CONF_POS)                     /** USBDEV_ADR AFT_CONF-bit mask */

#define AG903_USB_DEV_TST_TST_CLRFF_POS                    0                                                             /** USBDEV_TST TST_CLRFF-bit position */
#define AG903_USB_DEV_TST_TST_CLRFF_MSK                    (0x1UL << AG903_USB_DEV_TST_TST_CLRFF_POS)                    /** USBDEV_TST TST_CLRFF-bit mask */
#define AG903_USB_DEV_TST_TST_LPCX_POS                     1                                                             /** USBDEV_TST TST_LPCX-bit position */
#define AG903_USB_DEV_TST_TST_LPCX_MSK                     (0x1UL << AG903_USB_DEV_TST_TST_LPCX_POS)                     /** USBDEV_TST TST_LPCX-bit mask */
#define AG903_USB_DEV_TST_TST_CLREA_POS                    2                                                             /** USBDEV_TST TST_CLREA-bit position */
#define AG903_USB_DEV_TST_TST_CLREA_MSK                    (0x1UL << AG903_USB_DEV_TST_TST_CLREA_POS)                    /** USBDEV_TST TST_CLREA-bit mask */
#define AG903_USB_DEV_TST_TST_DISCRC_POS                   3                                                             /** USBDEV_TST TST_DISCRC-bit position */
#define AG903_USB_DEV_TST_TST_DISCRC_MSK                   (0x1UL << AG903_USB_DEV_TST_TST_DISCRC_POS)                   /** USBDEV_TST TST_DISCRC-bit mask */
#define AG903_USB_DEV_TST_TST_DISTOG_POS                   4                                                             /** USBDEV_TST TST_DISTOG-bit position */
#define AG903_USB_DEV_TST_TST_DISTOG_MSK                   (0x1UL << AG903_USB_DEV_TST_TST_DISTOG_POS)                   /** USBDEV_TST TST_DISTOG-bit mask */
#define AG903_USB_DEV_TST_TST_MOD_POS                      5                                                             /** USBDEV_TST TST_MOD-bit position */
#define AG903_USB_DEV_TST_TST_MOD_MSK                      (0x1UL << AG903_USB_DEV_TST_TST_MOD_POS)                      /** USBDEV_TST TST_MOD-bit mask */
#define AG903_USB_DEV_TST_DISGENSOF_POS                    6                                                             /** USBDEV_TST DISGENSOF-bit position */
#define AG903_USB_DEV_TST_DISGENSOF_MSK                    (0x1UL << AG903_USB_DEV_TST_DISGENSOF_POS)                    /** USBDEV_TST DISGENSOF-bit mask */
#define AG903_USB_DEV_TST_TST_MOD_TYP_POS                  7                                                             /** USBDEV_TST TST_MOD_TYP-bit position */
#define AG903_USB_DEV_TST_TST_MOD_TYP_MSK                  (0x1UL << AG903_USB_DEV_TST_TST_MOD_TYP_POS)                  /** USBDEV_TST TST_MOD_TYP-bit mask */

#define AG903_USB_DEV_SFN_SOFN_POS                         0                                                             /** USBDEV_SFN SOFN-bit position */
#define AG903_USB_DEV_SFN_SOFN_MSK                         (0x7ffUL << AG903_USB_DEV_SFN_SOFN_POS)                       /** USBDEV_SFN SOFN-bit mask */
#define AG903_USB_DEV_SFN_USOFN_POS                        11                                                            /** USBDEV_SFN USOFN-bit position */
#define AG903_USB_DEV_SFN_USOFN_MSK                        (0x7UL << AG903_USB_DEV_SFN_USOFN_POS)                        /** USBDEV_SFN USOFN-bit mask */

#define AG903_USB_DEV_SMT_SOFMT_POS                        0                                                             /** USBDEV_SMT SOFMT-bit position */
#define AG903_USB_DEV_SMT_SOFMT_MSK                        (0xffffUL << AG903_USB_DEV_SMT_SOFMT_POS)                     /** USBDEV_SMT SOFMT-bit mask */

#define AG903_USB_PHY_TST_UNPLUG_POS                       0                                                             /** USBPHY_TST UNPLUG-bit position */
#define AG903_USB_PHY_TST_UNPLUG_MSK                       (0x1UL << AG903_USB_PHY_TST_UNPLUG_POS)                       /** USBPHY_TST UNPLUG-bit mask */
#define AG903_USB_PHY_TST_TST_JSTA_POS                     1                                                             /** USBPHY_TST TST_JSTA-bit position */
#define AG903_USB_PHY_TST_TST_JSTA_MSK                     (0x1UL << AG903_USB_PHY_TST_TST_JSTA_POS)                     /** USBPHY_TST TST_JSTA-bit mask */
#define AG903_USB_PHY_TST_TST_KSTA_POS                     2                                                             /** USBPHY_TST TST_KSTA-bit position */
#define AG903_USB_PHY_TST_TST_KSTA_MSK                     (0x1UL << AG903_USB_PHY_TST_TST_KSTA_POS)                     /** USBPHY_TST TST_KSTA-bit mask */
#define AG903_USB_PHY_TST_TST_SE0NAK_POS                   3                                                             /** USBPHY_TST TST_SE0NAK-bit position */
#define AG903_USB_PHY_TST_TST_SE0NAK_MSK                   (0x1UL << AG903_USB_PHY_TST_TST_SE0NAK_POS)                   /** USBPHY_TST TST_SE0NAK-bit mask */
#define AG903_USB_PHY_TST_TST_PKT_POS                      4                                                             /** USBPHY_TST TST_PKT-bit position */
#define AG903_USB_PHY_TST_TST_PKT_MSK                      (0x1UL << AG903_USB_PHY_TST_TST_PKT_POS)                      /** USBPHY_TST TST_PKT-bit mask */

#define AG903_USB_DEV_VCTL_VCTL_POS                        0                                                             /** USBDEV_VCTL VCTL-bit position */
#define AG903_USB_DEV_VCTL_VCTL_MSK                        (0x1fUL << AG903_USB_DEV_VCTL_VCTL_POS)                       /** USBDEV_VCTL VCTL-bit mask */
#define AG903_USB_DEV_VCTL_VCTLOAD_N_POS                   5                                                             /** USBDEV_VCTL VCTLOAD_N-bit position */
#define AG903_USB_DEV_VCTL_VCTLOAD_N_MSK                   (0x1UL << AG903_USB_DEV_VCTL_VCTLOAD_N_POS)                   /** USBDEV_VCTL VCTLOAD_N-bit mask */

#define AG903_USB_DEV_CXCFG_VSTA_POS                       0                                                             /** USBDEV_CXCFG VSTA-bit position */
#define AG903_USB_DEV_CXCFG_VSTA_MSK                       (0xffUL << AG903_USB_DEV_CXCFG_VSTA_POS)                      /** USBDEV_CXCFG VSTA-bit mask */

#define AG903_USB_DEV_CXCFE_CX_DONE_POS                    0                                                             /** USBDEV_CXCFE CX_DONE-bit position */
#define AG903_USB_DEV_CXCFE_CX_DONE_MSK                    (0x1UL << AG903_USB_DEV_CXCFE_CX_DONE_POS)                    /** USBDEV_CXCFE CX_DONE-bit mask */
#define AG903_USB_DEV_CXCFE_TST_PKDONE_POS                 1                                                             /** USBDEV_CXCFE TST_PKDONE-bit position */
#define AG903_USB_DEV_CXCFE_TST_PKDONE_MSK                 (0x1UL << AG903_USB_DEV_CXCFE_TST_PKDONE_POS)                 /** USBDEV_CXCFE TST_PKDONE-bit mask */
#define AG903_USB_DEV_CXCFE_CX_STL_POS                     2                                                             /** USBDEV_CXCFE CX_STL-bit position */
#define AG903_USB_DEV_CXCFE_CX_STL_MSK                     (0x1UL << AG903_USB_DEV_CXCFE_CX_STL_POS)                     /** USBDEV_CXCFE CX_STL-bit mask */
#define AG903_USB_DEV_CXCFE_CX_CLR_POS                     3                                                             /** USBDEV_CXCFE CX_CLR-bit position */
#define AG903_USB_DEV_CXCFE_CX_CLR_MSK                     (0x1UL << AG903_USB_DEV_CXCFE_CX_CLR_POS)                     /** USBDEV_CXCFE CX_CLR-bit mask */
#define AG903_USB_DEV_CXCFE_CX_FUL_POS                     4                                                             /** USBDEV_CXCFE CX_FUL-bit position */
#define AG903_USB_DEV_CXCFE_CX_FUL_MSK                     (0x1UL << AG903_USB_DEV_CXCFE_CX_FUL_POS)                     /** USBDEV_CXCFE CX_FUL-bit mask */
#define AG903_USB_DEV_CXCFE_CX_EMP_POS                     5                                                             /** USBDEV_CXCFE CX_EMP-bit position */
#define AG903_USB_DEV_CXCFE_CX_EMP_MSK                     (0x1UL << AG903_USB_DEV_CXCFE_CX_EMP_POS)                     /** USBDEV_CXCFE CX_EMP-bit mask */
#define AG903_USB_DEV_CXCFE_F_EMP_POS                      8                                                             /** USBDEV_CXCFE F_EMP-bit position */
#define AG903_USB_DEV_CXCFE_F_EMP_MSK                      (0xfUL << AG903_USB_DEV_CXCFE_F_EMP_POS)                      /** USBDEV_CXCFE F_EMP-bit mask */
#define AG903_USB_DEV_CXCFE_CX_FNT_POS                     24                                                            /** USBDEV_CXCFE CX_FNT-bit position */
#define AG903_USB_DEV_CXCFE_CX_FNT_MSK                     (0x7fUL << AG903_USB_DEV_CXCFE_CX_FNT_POS)                    /** USBDEV_CXCFE CX_FNT-bit mask */

#define AG903_USB_DEV_ICR_IDLE_CNT_POS                     0                                                             /** USBDEV_ICR IDLE_CNT-bit position */
#define AG903_USB_DEV_ICR_IDLE_CNT_MSK                     (0x7UL << AG903_USB_DEV_ICR_IDLE_CNT_POS)                     /** USBDEV_ICR IDLE_CNT-bit mask */

#define AG903_USB_DEV_MIGR_MINT_G0_POS                     0                                                             /** USBDEV_MIGR MINT_G0-bit position */
#define AG903_USB_DEV_MIGR_MINT_G0_MSK                     (0x1UL << AG903_USB_DEV_MIGR_MINT_G0_POS)                     /** USBDEV_MIGR MINT_G0-bit mask */
#define AG903_USB_DEV_MIGR_MINT_G1_POS                     1                                                             /** USBDEV_MIGR MINT_G1-bit position */
#define AG903_USB_DEV_MIGR_MINT_G1_MSK                     (0x1UL << AG903_USB_DEV_MIGR_MINT_G1_POS)                     /** USBDEV_MIGR MINT_G1-bit mask */
#define AG903_USB_DEV_MIGR_MINT_G2_POS                     2                                                             /** USBDEV_MIGR MINT_G2-bit position */
#define AG903_USB_DEV_MIGR_MINT_G2_MSK                     (0x1UL << AG903_USB_DEV_MIGR_MINT_G2_POS)                     /** USBDEV_MIGR MINT_G2-bit mask */
#define AG903_USB_DEV_MIGR_MINT_G3_POS                     3                                                             /** USBDEV_MIGR MINT_G3-bit position */
#define AG903_USB_DEV_MIGR_MINT_G3_MSK                     (0x1UL << AG903_USB_DEV_MIGR_MINT_G3_POS)                     /** USBDEV_MIGR MINT_G3-bit mask */

#define AG903_USB_DEV_MISG0_MCX_SETUP_INT_POS              0                                                             /** USBDEV_MISG0 MCX_SETUP_INT-bit position */
#define AG903_USB_DEV_MISG0_MCX_SETUP_INT_MSK              (0x1UL << AG903_USB_DEV_MISG0_MCX_SETUP_INT_POS)              /** USBDEV_MISG0 MCX_SETUP_INT-bit mask */
#define AG903_USB_DEV_MISG0_MCX_IN_INT_POS                 1                                                             /** USBDEV_MISG0 MCX_IN_INT-bit position */
#define AG903_USB_DEV_MISG0_MCX_IN_INT_MSK                 (0x1UL << AG903_USB_DEV_MISG0_MCX_IN_INT_POS)                 /** USBDEV_MISG0 MCX_IN_INT-bit mask */
#define AG903_USB_DEV_MISG0_MCX_OUT_INT_POS                2                                                             /** USBDEV_MISG0 MCX_OUT_INT-bit position */
#define AG903_USB_DEV_MISG0_MCX_OUT_INT_MSK                (0x1UL << AG903_USB_DEV_MISG0_MCX_OUT_INT_POS)                /** USBDEV_MISG0 MCX_OUT_INT-bit mask */
#define AG903_USB_DEV_MISG0_MCX_COMEND_POS                 3                                                             /** USBDEV_MISG0 MCX_COMEND-bit position */
#define AG903_USB_DEV_MISG0_MCX_COMEND_MSK                 (0x1UL << AG903_USB_DEV_MISG0_MCX_COMEND_POS)                 /** USBDEV_MISG0 MCX_COMEND-bit mask */
#define AG903_USB_DEV_MISG0_MCX_COMFAIL_INT_POS            4                                                             /** USBDEV_MISG0 MCX_COMFAIL_INT-bit position */
#define AG903_USB_DEV_MISG0_MCX_COMFAIL_INT_MSK            (0x1UL << AG903_USB_DEV_MISG0_MCX_COMFAIL_INT_POS)            /** USBDEV_MISG0 MCX_COMFAIL_INT-bit mask */
#define AG903_USB_DEV_MISG0_MCX_COMABORT_INT_POS           5                                                             /** USBDEV_MISG0 MCX_COMABORT_INT-bit position */
#define AG903_USB_DEV_MISG0_MCX_COMABORT_INT_MSK           (0x1UL << AG903_USB_DEV_MISG0_MCX_COMABORT_INT_POS)           /** USBDEV_MISG0 MCX_COMABORT_INT-bit mask */

#define AG903_USB_DEV_MISG1_MF0_OUT_INT_POS                0                                                             /** USBDEV_MISG1 MF0_OUT_INT-bit position */
#define AG903_USB_DEV_MISG1_MF0_OUT_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF0_OUT_INT_POS)                /** USBDEV_MISG1 MF0_OUT_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF0_SPK_INT_POS                1                                                             /** USBDEV_MISG1 MF0_SPK_INT-bit position */
#define AG903_USB_DEV_MISG1_MF0_SPK_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF0_SPK_INT_POS)                /** USBDEV_MISG1 MF0_SPK_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF1_OUT_INT_POS                2                                                             /** USBDEV_MISG1 MF1_OUT_INT-bit position */
#define AG903_USB_DEV_MISG1_MF1_OUT_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF1_OUT_INT_POS)                /** USBDEV_MISG1 MF1_OUT_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF1_SPK_INT_POS                3                                                             /** USBDEV_MISG1 MF1_SPK_INT-bit position */
#define AG903_USB_DEV_MISG1_MF1_SPK_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF1_SPK_INT_POS)                /** USBDEV_MISG1 MF1_SPK_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF2_OUT_INT_POS                4                                                             /** USBDEV_MISG1 MF2_OUT_INT-bit position */
#define AG903_USB_DEV_MISG1_MF2_OUT_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF2_OUT_INT_POS)                /** USBDEV_MISG1 MF2_OUT_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF2_SPK_INT_POS                5                                                             /** USBDEV_MISG1 MF2_SPK_INT-bit position */
#define AG903_USB_DEV_MISG1_MF2_SPK_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF2_SPK_INT_POS)                /** USBDEV_MISG1 MF2_SPK_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF3_OUT_INT_POS                6                                                             /** USBDEV_MISG1 MF3_OUT_INT-bit position */
#define AG903_USB_DEV_MISG1_MF3_OUT_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF3_OUT_INT_POS)                /** USBDEV_MISG1 MF3_OUT_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF3_SPK_INT_POS                7                                                             /** USBDEV_MISG1 MF3_SPK_INT-bit position */
#define AG903_USB_DEV_MISG1_MF3_SPK_INT_MSK                (0x1UL << AG903_USB_DEV_MISG1_MF3_SPK_INT_POS)                /** USBDEV_MISG1 MF3_SPK_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF0_IN_INT_POS                 16                                                            /** USBDEV_MISG1 MF0_IN_INT-bit position */
#define AG903_USB_DEV_MISG1_MF0_IN_INT_MSK                 (0x1UL << AG903_USB_DEV_MISG1_MF0_IN_INT_POS)                 /** USBDEV_MISG1 MF0_IN_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF1_IN_INT_POS                 17                                                            /** USBDEV_MISG1 MF1_IN_INT-bit position */
#define AG903_USB_DEV_MISG1_MF1_IN_INT_MSK                 (0x1UL << AG903_USB_DEV_MISG1_MF1_IN_INT_POS)                 /** USBDEV_MISG1 MF1_IN_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF2_IN_INT_POS                 18                                                            /** USBDEV_MISG1 MF2_IN_INT-bit position */
#define AG903_USB_DEV_MISG1_MF2_IN_INT_MSK                 (0x1UL << AG903_USB_DEV_MISG1_MF2_IN_INT_POS)                 /** USBDEV_MISG1 MF2_IN_INT-bit mask */
#define AG903_USB_DEV_MISG1_MF3_IN_INT_POS                 19                                                            /** USBDEV_MISG1 MF3_IN_INT-bit position */
#define AG903_USB_DEV_MISG1_MF3_IN_INT_MSK                 (0x1UL << AG903_USB_DEV_MISG1_MF3_IN_INT_POS)                 /** USBDEV_MISG1 MF3_IN_INT-bit mask */

#define AG903_USB_DEV_MISG2_MUSBRST_INT_POS                0                                                             /** USBDEV_MISG2 MUSBRST_INT-bit position */
#define AG903_USB_DEV_MISG2_MUSBRST_INT_MSK                (0x1UL << AG903_USB_DEV_MISG2_MUSBRST_INT_POS)                /** USBDEV_MISG2 MUSBRST_INT-bit mask */
#define AG903_USB_DEV_MISG2_MSUSP_INT_POS                  1                                                             /** USBDEV_MISG2 MSUSP_INT-bit position */
#define AG903_USB_DEV_MISG2_MSUSP_INT_MSK                  (0x1UL << AG903_USB_DEV_MISG2_MSUSP_INT_POS)                  /** USBDEV_MISG2 MSUSP_INT-bit mask */
#define AG903_USB_DEV_MISG2_MRESM_INT_POS                  2                                                             /** USBDEV_MISG2 MRESM_INT-bit position */
#define AG903_USB_DEV_MISG2_MRESM_INT_MSK                  (0x1UL << AG903_USB_DEV_MISG2_MRESM_INT_POS)                  /** USBDEV_MISG2 MRESM_INT-bit mask */
#define AG903_USB_DEV_MISG2_MSEQ_ERR_INT_POS               3                                                             /** USBDEV_MISG2 MSEQ_ERR_INT-bit position */
#define AG903_USB_DEV_MISG2_MSEQ_ERR_INT_MSK               (0x1UL << AG903_USB_DEV_MISG2_MSEQ_ERR_INT_POS)               /** USBDEV_MISG2 MSEQ_ERR_INT-bit mask */
#define AG903_USB_DEV_MISG2_MSEQ_ABORT_INT_POS             4                                                             /** USBDEV_MISG2 MSEQ_ABORT_INT-bit position */
#define AG903_USB_DEV_MISG2_MSEQ_ABORT_INT_MSK             (0x1UL << AG903_USB_DEV_MISG2_MSEQ_ABORT_INT_POS)             /** USBDEV_MISG2 MSEQ_ABORT_INT-bit mask */
#define AG903_USB_DEV_MISG2_MTX0BYTE_INT_POS               5                                                             /** USBDEV_MISG2 MTX0BYTE_INT-bit position */
#define AG903_USB_DEV_MISG2_MTX0BYTE_INT_MSK               (0x1UL << AG903_USB_DEV_MISG2_MTX0BYTE_INT_POS)               /** USBDEV_MISG2 MTX0BYTE_INT-bit mask */
#define AG903_USB_DEV_MISG2_MRX0BYTE_INT_POS               6                                                             /** USBDEV_MISG2 MRX0BYTE_INT-bit position */
#define AG903_USB_DEV_MISG2_MRX0BYTE_INT_MSK               (0x1UL << AG903_USB_DEV_MISG2_MRX0BYTE_INT_POS)               /** USBDEV_MISG2 MRX0BYTE_INT-bit mask */
#define AG903_USB_DEV_MISG2_MDMA_CMPLT_POS                 7                                                             /** USBDEV_MISG2 MDMA_CMPLT-bit position */
#define AG903_USB_DEV_MISG2_MDMA_CMPLT_MSK                 (0x1UL << AG903_USB_DEV_MISG2_MDMA_CMPLT_POS)                 /** USBDEV_MISG2 MDMA_CMPLT-bit mask */
#define AG903_USB_DEV_MISG2_MDMA_ERROR_POS                 8                                                             /** USBDEV_MISG2 MDMA_ERROR-bit position */
#define AG903_USB_DEV_MISG2_MDMA_ERROR_MSK                 (0x1UL << AG903_USB_DEV_MISG2_MDMA_ERROR_POS)                 /** USBDEV_MISG2 MDMA_ERROR-bit mask */
#define AG903_USB_DEV_MISG2_MDev_Idle_POS                  9                                                             /** USBDEV_MISG2 MDev_Idle-bit position */
#define AG903_USB_DEV_MISG2_MDev_Idle_MSK                  (0x1UL << AG903_USB_DEV_MISG2_MDev_Idle_POS)                  /** USBDEV_MISG2 MDev_Idle-bit mask */
#define AG903_USB_DEV_MISG2_MDev_Wakeup_byVBUS_POS         10                                                            /** USBDEV_MISG2 MDev_Wakeup_byVBUS-bit position */
#define AG903_USB_DEV_MISG2_MDev_Wakeup_byVBUS_MSK         (0x1UL << AG903_USB_DEV_MISG2_MDev_Wakeup_byVBUS_POS)         /** USBDEV_MISG2 MDev_Wakeup_byVBUS-bit mask */

#define AG903_USB_DEV_IGR_INT_G0_POS                       0                                                             /** USBDEV_IGR INT_G0-bit position */
#define AG903_USB_DEV_IGR_INT_G0_MSK                       (0x1UL << AG903_USB_DEV_IGR_INT_G0_POS)                       /** USBDEV_IGR INT_G0-bit mask */
#define AG903_USB_DEV_IGR_INT_G1_POS                       1                                                             /** USBDEV_IGR INT_G1-bit position */
#define AG903_USB_DEV_IGR_INT_G1_MSK                       (0x1UL << AG903_USB_DEV_IGR_INT_G1_POS)                       /** USBDEV_IGR INT_G1-bit mask */
#define AG903_USB_DEV_IGR_INT_G2_POS                       2                                                             /** USBDEV_IGR INT_G2-bit position */
#define AG903_USB_DEV_IGR_INT_G2_MSK                       (0x1UL << AG903_USB_DEV_IGR_INT_G2_POS)                       /** USBDEV_IGR INT_G2-bit mask */
#define AG903_USB_DEV_IGR_INT_G3_POS                       3                                                             /** USBDEV_IGR INT_G3-bit position */
#define AG903_USB_DEV_IGR_INT_G3_MSK                       (0x1UL << AG903_USB_DEV_IGR_INT_G3_POS)                       /** USBDEV_IGR INT_G3-bit mask */

#define AG903_USB_DEV_ISG0_CX_SETUP_INT_POS                0                                                             /** USBDEV_ISG0 CX_SETUP_INT-bit position */
#define AG903_USB_DEV_ISG0_CX_SETUP_INT_MSK                (0x1UL << AG903_USB_DEV_ISG0_CX_SETUP_INT_POS)                /** USBDEV_ISG0 CX_SETUP_INT-bit mask */
#define AG903_USB_DEV_ISG0_CX_IN_INT_POS                   1                                                             /** USBDEV_ISG0 CX_IN_INT-bit position */
#define AG903_USB_DEV_ISG0_CX_IN_INT_MSK                   (0x1UL << AG903_USB_DEV_ISG0_CX_IN_INT_POS)                   /** USBDEV_ISG0 CX_IN_INT-bit mask */
#define AG903_USB_DEV_ISG0_CX_OUT_INT_POS                  2                                                             /** USBDEV_ISG0 CX_OUT_INT-bit position */
#define AG903_USB_DEV_ISG0_CX_OUT_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG0_CX_OUT_INT_POS)                  /** USBDEV_ISG0 CX_OUT_INT-bit mask */
#define AG903_USB_DEV_ISG0_CX_COMEND_INT_POS               3                                                             /** USBDEV_ISG0 CX_COMEND_INT-bit position */
#define AG903_USB_DEV_ISG0_CX_COMEND_INT_MSK               (0x1UL << AG903_USB_DEV_ISG0_CX_COMEND_INT_POS)               /** USBDEV_ISG0 CX_COMEND_INT-bit mask */
#define AG903_USB_DEV_ISG0_CX_COMFAIL_INT_POS              4                                                             /** USBDEV_ISG0 CX_COMFAIL_INT-bit position */
#define AG903_USB_DEV_ISG0_CX_COMFAIL_INT_MSK              (0x1UL << AG903_USB_DEV_ISG0_CX_COMFAIL_INT_POS)              /** USBDEV_ISG0 CX_COMFAIL_INT-bit mask */
#define AG903_USB_DEV_ISG0_CX_COMABT_INT_POS               5                                                             /** USBDEV_ISG0 CX_COMABT_INT-bit position */
#define AG903_USB_DEV_ISG0_CX_COMABT_INT_MSK               (0x1UL << AG903_USB_DEV_ISG0_CX_COMABT_INT_POS)               /** USBDEV_ISG0 CX_COMABT_INT-bit mask */

#define AG903_USB_DEV_ISG1_F0_OUT_INT_POS                  0                                                             /** USBDEV_ISG1 F0_OUT_INT-bit position */
#define AG903_USB_DEV_ISG1_F0_OUT_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F0_OUT_INT_POS)                  /** USBDEV_ISG1 F0_OUT_INT-bit mask */
#define AG903_USB_DEV_ISG1_F0_SPK_INT_POS                  1                                                             /** USBDEV_ISG1 F0_SPK_INT-bit position */
#define AG903_USB_DEV_ISG1_F0_SPK_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F0_SPK_INT_POS)                  /** USBDEV_ISG1 F0_SPK_INT-bit mask */
#define AG903_USB_DEV_ISG1_F1_OUT_INT_POS                  2                                                             /** USBDEV_ISG1 F1_OUT_INT-bit position */
#define AG903_USB_DEV_ISG1_F1_OUT_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F1_OUT_INT_POS)                  /** USBDEV_ISG1 F1_OUT_INT-bit mask */
#define AG903_USB_DEV_ISG1_F1_SPK_INT_POS                  3                                                             /** USBDEV_ISG1 F1_SPK_INT-bit position */
#define AG903_USB_DEV_ISG1_F1_SPK_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F1_SPK_INT_POS)                  /** USBDEV_ISG1 F1_SPK_INT-bit mask */
#define AG903_USB_DEV_ISG1_F2_OUT_INT_POS                  4                                                             /** USBDEV_ISG1 F2_OUT_INT-bit position */
#define AG903_USB_DEV_ISG1_F2_OUT_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F2_OUT_INT_POS)                  /** USBDEV_ISG1 F2_OUT_INT-bit mask */
#define AG903_USB_DEV_ISG1_F2_SPK_INT_POS                  5                                                             /** USBDEV_ISG1 F2_SPK_INT-bit position */
#define AG903_USB_DEV_ISG1_F2_SPK_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F2_SPK_INT_POS)                  /** USBDEV_ISG1 F2_SPK_INT-bit mask */
#define AG903_USB_DEV_ISG1_F3_OUT_INT_POS                  6                                                             /** USBDEV_ISG1 F3_OUT_INT-bit position */
#define AG903_USB_DEV_ISG1_F3_OUT_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F3_OUT_INT_POS)                  /** USBDEV_ISG1 F3_OUT_INT-bit mask */
#define AG903_USB_DEV_ISG1_F3_SPK_INT_POS                  7                                                             /** USBDEV_ISG1 F3_SPK_INT-bit position */
#define AG903_USB_DEV_ISG1_F3_SPK_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG1_F3_SPK_INT_POS)                  /** USBDEV_ISG1 F3_SPK_INT-bit mask */
#define AG903_USB_DEV_ISG1_F0_IN_INT_POS                   16                                                            /** USBDEV_ISG1 F0_IN_INT-bit position */
#define AG903_USB_DEV_ISG1_F0_IN_INT_MSK                   (0x1UL << AG903_USB_DEV_ISG1_F0_IN_INT_POS)                   /** USBDEV_ISG1 F0_IN_INT-bit mask */
#define AG903_USB_DEV_ISG1_F1_IN_INT_POS                   17                                                            /** USBDEV_ISG1 F1_IN_INT-bit position */
#define AG903_USB_DEV_ISG1_F1_IN_INT_MSK                   (0x1UL << AG903_USB_DEV_ISG1_F1_IN_INT_POS)                   /** USBDEV_ISG1 F1_IN_INT-bit mask */
#define AG903_USB_DEV_ISG1_F2_IN_INT_POS                   18                                                            /** USBDEV_ISG1 F2_IN_INT-bit position */
#define AG903_USB_DEV_ISG1_F2_IN_INT_MSK                   (0x1UL << AG903_USB_DEV_ISG1_F2_IN_INT_POS)                   /** USBDEV_ISG1 F2_IN_INT-bit mask */
#define AG903_USB_DEV_ISG1_F3_IN_INT_POS                   19                                                            /** USBDEV_ISG1 F3_IN_INT-bit position */
#define AG903_USB_DEV_ISG1_F3_IN_INT_MSK                   (0x1UL << AG903_USB_DEV_ISG1_F3_IN_INT_POS)                   /** USBDEV_ISG1 F3_IN_INT-bit mask */

#define AG903_USB_DEV_ISG2_USBRST_INT_POS                  0                                                             /** USBDEV_ISG2 USBRST_INT-bit position */
#define AG903_USB_DEV_ISG2_USBRST_INT_MSK                  (0x1UL << AG903_USB_DEV_ISG2_USBRST_INT_POS)                  /** USBDEV_ISG2 USBRST_INT-bit mask */
#define AG903_USB_DEV_ISG2_SUSP_INT_POS                    1                                                             /** USBDEV_ISG2 SUSP_INT-bit position */
#define AG903_USB_DEV_ISG2_SUSP_INT_MSK                    (0x1UL << AG903_USB_DEV_ISG2_SUSP_INT_POS)                    /** USBDEV_ISG2 SUSP_INT-bit mask */
#define AG903_USB_DEV_ISG2_RESM_INT_POS                    2                                                             /** USBDEV_ISG2 RESM_INT-bit position */
#define AG903_USB_DEV_ISG2_RESM_INT_MSK                    (0x1UL << AG903_USB_DEV_ISG2_RESM_INT_POS)                    /** USBDEV_ISG2 RESM_INT-bit mask */
#define AG903_USB_DEV_ISG2_ISO_SEQ_ERR_INT_POS             3                                                             /** USBDEV_ISG2 ISO_SEQ_ERR_INT-bit position */
#define AG903_USB_DEV_ISG2_ISO_SEQ_ERR_INT_MSK             (0x1UL << AG903_USB_DEV_ISG2_ISO_SEQ_ERR_INT_POS)             /** USBDEV_ISG2 ISO_SEQ_ERR_INT-bit mask */
#define AG903_USB_DEV_ISG2_ISO_SEQ_ABORT_INT_POS           4                                                             /** USBDEV_ISG2 ISO_SEQ_ABORT_INT-bit position */
#define AG903_USB_DEV_ISG2_ISO_SEQ_ABORT_INT_MSK           (0x1UL << AG903_USB_DEV_ISG2_ISO_SEQ_ABORT_INT_POS)           /** USBDEV_ISG2 ISO_SEQ_ABORT_INT-bit mask */
#define AG903_USB_DEV_ISG2_TX0BYTE_INT_POS                 5                                                             /** USBDEV_ISG2 TX0BYTE_INT-bit position */
#define AG903_USB_DEV_ISG2_TX0BYTE_INT_MSK                 (0x1UL << AG903_USB_DEV_ISG2_TX0BYTE_INT_POS)                 /** USBDEV_ISG2 TX0BYTE_INT-bit mask */
#define AG903_USB_DEV_ISG2_RX0BYTE_INT_POS                 6                                                             /** USBDEV_ISG2 RX0BYTE_INT-bit position */
#define AG903_USB_DEV_ISG2_RX0BYTE_INT_MSK                 (0x1UL << AG903_USB_DEV_ISG2_RX0BYTE_INT_POS)                 /** USBDEV_ISG2 RX0BYTE_INT-bit mask */
#define AG903_USB_DEV_ISG2_DMA_CMPLT_POS                   7                                                             /** USBDEV_ISG2 DMA_CMPLT-bit position */
#define AG903_USB_DEV_ISG2_DMA_CMPLT_MSK                   (0x1UL << AG903_USB_DEV_ISG2_DMA_CMPLT_POS)                   /** USBDEV_ISG2 DMA_CMPLT-bit mask */
#define AG903_USB_DEV_ISG2_DMA_ERROR_POS                   8                                                             /** USBDEV_ISG2 DMA_ERROR-bit position */
#define AG903_USB_DEV_ISG2_DMA_ERROR_MSK                   (0x1UL << AG903_USB_DEV_ISG2_DMA_ERROR_POS)                   /** USBDEV_ISG2 DMA_ERROR-bit mask */
#define AG903_USB_DEV_ISG2_Dev_Idle_POS                    9                                                             /** USBDEV_ISG2 Dev_Idle-bit position */
#define AG903_USB_DEV_ISG2_Dev_Idle_MSK                    (0x1UL << AG903_USB_DEV_ISG2_Dev_Idle_POS)                    /** USBDEV_ISG2 Dev_Idle-bit mask */
#define AG903_USB_DEV_ISG2_Dev_Wakeup_byVBUS_POS           10                                                            /** USBDEV_ISG2 Dev_Wakeup_byVBUS-bit position */
#define AG903_USB_DEV_ISG2_Dev_Wakeup_byVBUS_MSK           (0x1UL << AG903_USB_DEV_ISG2_Dev_Wakeup_byVBUS_POS)           /** USBDEV_ISG2 Dev_Wakeup_byVBUS-bit mask */

#define AG903_USB_DEV_RXZ_RX0BYTE_EP1_POS                  0                                                             /** USBDEV_RXZ RX0BYTE_EP1-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP1_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP1_POS)                  /** USBDEV_RXZ RX0BYTE_EP1-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP2_POS                  1                                                             /** USBDEV_RXZ RX0BYTE_EP2-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP2_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP2_POS)                  /** USBDEV_RXZ RX0BYTE_EP2-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP3_POS                  2                                                             /** USBDEV_RXZ RX0BYTE_EP3-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP3_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP3_POS)                  /** USBDEV_RXZ RX0BYTE_EP3-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP4_POS                  3                                                             /** USBDEV_RXZ RX0BYTE_EP4-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP4_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP4_POS)                  /** USBDEV_RXZ RX0BYTE_EP4-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP5_POS                  4                                                             /** USBDEV_RXZ RX0BYTE_EP5-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP5_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP5_POS)                  /** USBDEV_RXZ RX0BYTE_EP5-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP6_POS                  5                                                             /** USBDEV_RXZ RX0BYTE_EP6-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP6_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP6_POS)                  /** USBDEV_RXZ RX0BYTE_EP6-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP7_POS                  6                                                             /** USBDEV_RXZ RX0BYTE_EP7-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP7_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP7_POS)                  /** USBDEV_RXZ RX0BYTE_EP7-bit mask */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP8_POS                  7                                                             /** USBDEV_RXZ RX0BYTE_EP8-bit position */
#define AG903_USB_DEV_RXZ_RX0BYTE_EP8_MSK                  (0x1UL << AG903_USB_DEV_RXZ_RX0BYTE_EP8_POS)                  /** USBDEV_RXZ RX0BYTE_EP8-bit mask */

#define AG903_USB_DEV_TXZ_TX0BYTE_EP1_POS                  0                                                             /** USBDEV_TXZ TX0BYTE_EP1-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP1_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP1_POS)                  /** USBDEV_TXZ TX0BYTE_EP1-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP2_POS                  1                                                             /** USBDEV_TXZ TX0BYTE_EP2-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP2_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP2_POS)                  /** USBDEV_TXZ TX0BYTE_EP2-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP3_POS                  2                                                             /** USBDEV_TXZ TX0BYTE_EP3-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP3_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP3_POS)                  /** USBDEV_TXZ TX0BYTE_EP3-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP4_POS                  3                                                             /** USBDEV_TXZ TX0BYTE_EP4-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP4_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP4_POS)                  /** USBDEV_TXZ TX0BYTE_EP4-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP5_POS                  4                                                             /** USBDEV_TXZ TX0BYTE_EP5-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP5_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP5_POS)                  /** USBDEV_TXZ TX0BYTE_EP5-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP6_POS                  5                                                             /** USBDEV_TXZ TX0BYTE_EP6-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP6_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP6_POS)                  /** USBDEV_TXZ TX0BYTE_EP6-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP7_POS                  6                                                             /** USBDEV_TXZ TX0BYTE_EP7-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP7_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP7_POS)                  /** USBDEV_TXZ TX0BYTE_EP7-bit mask */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP8_POS                  7                                                             /** USBDEV_TXZ TX0BYTE_EP8-bit position */
#define AG903_USB_DEV_TXZ_TX0BYTE_EP8_MSK                  (0x1UL << AG903_USB_DEV_TXZ_TX0BYTE_EP8_POS)                  /** USBDEV_TXZ TX0BYTE_EP8-bit mask */

#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP1_POS              0                                                             /** USBDEV_ISE ISO_ABT_ERR_EP1-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP1_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP1_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP1-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP2_POS              1                                                             /** USBDEV_ISE ISO_ABT_ERR_EP2-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP2_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP2_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP2-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP3_POS              2                                                             /** USBDEV_ISE ISO_ABT_ERR_EP3-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP3_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP3_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP3-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP4_POS              3                                                             /** USBDEV_ISE ISO_ABT_ERR_EP4-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP4_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP4_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP4-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP5_POS              4                                                             /** USBDEV_ISE ISO_ABT_ERR_EP5-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP5_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP5_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP5-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP6_POS              5                                                             /** USBDEV_ISE ISO_ABT_ERR_EP6-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP6_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP6_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP6-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP7_POS              6                                                             /** USBDEV_ISE ISO_ABT_ERR_EP7-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP7_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP7_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP7-bit mask */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP8_POS              7                                                             /** USBDEV_ISE ISO_ABT_ERR_EP8-bit position */
#define AG903_USB_DEV_ISE_ISO_ABT_ERR_EP8_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_ABT_ERR_EP8_POS)              /** USBDEV_ISE ISO_ABT_ERR_EP8-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP1_POS              16                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP1-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP1_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP1_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP1-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP2_POS              17                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP2-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP2_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP2_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP2-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP3_POS              18                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP3-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP3_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP3_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP3-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP4_POS              19                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP4-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP4_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP4_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP4-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP5_POS              20                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP5-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP5_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP5_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP5-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP6_POS              21                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP6-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP6_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP6_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP6-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP7_POS              22                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP7-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP7_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP7_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP7-bit mask */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP8_POS              23                                                            /** USBDEV_ISE ISO_SEQ_ERR_EP8-bit position */
#define AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP8_MSK              (0x1UL << AG903_USB_DEV_ISE_ISO_SEQ_ERR_EP8_POS)              /** USBDEV_ISE ISO_SEQ_ERR_EP8-bit mask */

#define AG903_USB_DEV_INMPS_MAXPS_IEPn_POS                 0                                                             /** USBDEV_INMPS MAXPS_IEPn-bit position */
#define AG903_USB_DEV_INMPS_MAXPS_IEPn_MSK                 (0x7ffUL << AG903_USB_DEV_INMPS_MAXPS_IEPn_POS)               /** USBDEV_INMPS MAXPS_IEPn-bit mask */
#define AG903_USB_DEV_INMPS_STL_IEPn_POS                   11                                                            /** USBDEV_INMPS STL_IEPn-bit position */
#define AG903_USB_DEV_INMPS_STL_IEPn_MSK                   (0x1UL << AG903_USB_DEV_INMPS_STL_IEPn_POS)                   /** USBDEV_INMPS STL_IEPn-bit mask */
#define AG903_USB_DEV_INMPS_RSTG_IEPn_POS                  12                                                            /** USBDEV_INMPS RSTG_IEPn-bit position */
#define AG903_USB_DEV_INMPS_RSTG_IEPn_MSK                  (0x1UL << AG903_USB_DEV_INMPS_RSTG_IEPn_POS)                  /** USBDEV_INMPS RSTG_IEPn-bit mask */
#define AG903_USB_DEV_INMPS_TX_NUM_HBW_IEPn_POS            13                                                            /** USBDEV_INMPS TX_NUM_HBW_IEPn-bit position */
#define AG903_USB_DEV_INMPS_TX_NUM_HBW_IEPn_MSK            (0x3UL << AG903_USB_DEV_INMPS_TX_NUM_HBW_IEPn_POS)            /** USBDEV_INMPS TX_NUM_HBW_IEPn-bit mask */
#define AG903_USB_DEV_INMPS_TX0BYTE_IEPn_POS               15                                                            /** USBDEV_INMPS TX0BYTE_IEPn-bit position */
#define AG903_USB_DEV_INMPS_TX0BYTE_IEPn_MSK               (0x1UL << AG903_USB_DEV_INMPS_TX0BYTE_IEPn_POS)               /** USBDEV_INMPS TX0BYTE_IEPn-bit mask */

#define AG903_USB_DEV_OUTMPS_MAXPS_OEPn_POS                0                                                             /** USBDEV_OUTMPS MAXPS_OEPn-bit position */
#define AG903_USB_DEV_OUTMPS_MAXPS_OEPn_MSK                (0x7ffUL << AG903_USB_DEV_OUTMPS_MAXPS_OEPn_POS)              /** USBDEV_OUTMPS MAXPS_OEPn-bit mask */
#define AG903_USB_DEV_OUTMPS_STL_OEPn_POS                  11                                                            /** USBDEV_OUTMPS STL_OEPn-bit position */
#define AG903_USB_DEV_OUTMPS_STL_OEPn_MSK                  (0x1UL << AG903_USB_DEV_OUTMPS_STL_OEPn_POS)                  /** USBDEV_OUTMPS STL_OEPn-bit mask */
#define AG903_USB_DEV_OUTMPS_RSTG_OEPn_POS                 12                                                            /** USBDEV_OUTMPS RSTG_OEPn-bit position */
#define AG903_USB_DEV_OUTMPS_RSTG_OEPn_MSK                 (0x1UL << AG903_USB_DEV_OUTMPS_RSTG_OEPn_POS)                 /** USBDEV_OUTMPS RSTG_OEPn-bit mask */

#define AG903_USB_DEV_EPMAP0_FNO_IEP1_POS                  0                                                             /** USBDEV_EPMAP0 FNO_IEP1-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_IEP1_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_IEP1_POS)                  /** USBDEV_EPMAP0 FNO_IEP1-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_OEP1_POS                  4                                                             /** USBDEV_EPMAP0 FNO_OEP1-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_OEP1_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_OEP1_POS)                  /** USBDEV_EPMAP0 FNO_OEP1-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_IEP2_POS                  8                                                             /** USBDEV_EPMAP0 FNO_IEP2-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_IEP2_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_IEP2_POS)                  /** USBDEV_EPMAP0 FNO_IEP2-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_OEP2_POS                  12                                                            /** USBDEV_EPMAP0 FNO_OEP2-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_OEP2_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_OEP2_POS)                  /** USBDEV_EPMAP0 FNO_OEP2-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_IEP3_POS                  16                                                            /** USBDEV_EPMAP0 FNO_IEP3-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_IEP3_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_IEP3_POS)                  /** USBDEV_EPMAP0 FNO_IEP3-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_OEP3_POS                  20                                                            /** USBDEV_EPMAP0 FNO_OEP3-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_OEP3_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_OEP3_POS)                  /** USBDEV_EPMAP0 FNO_OEP3-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_IEP4_POS                  24                                                            /** USBDEV_EPMAP0 FNO_IEP4-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_IEP4_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_IEP4_POS)                  /** USBDEV_EPMAP0 FNO_IEP4-bit mask */
#define AG903_USB_DEV_EPMAP0_FNO_OEP4_POS                  28                                                            /** USBDEV_EPMAP0 FNO_OEP4-bit position */
#define AG903_USB_DEV_EPMAP0_FNO_OEP4_MSK                  (0xfUL << AG903_USB_DEV_EPMAP0_FNO_OEP4_POS)                  /** USBDEV_EPMAP0 FNO_OEP4-bit mask */

#define AG903_USB_DEV_EPMAP1_FNO_IEP5_POS                  0                                                             /** USBDEV_EPMAP1 FNO_IEP5-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_IEP5_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_IEP5_POS)                  /** USBDEV_EPMAP1 FNO_IEP5-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_OEP5_POS                  4                                                             /** USBDEV_EPMAP1 FNO_OEP5-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_OEP5_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_OEP5_POS)                  /** USBDEV_EPMAP1 FNO_OEP5-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_IEP6_POS                  8                                                             /** USBDEV_EPMAP1 FNO_IEP6-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_IEP6_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_IEP6_POS)                  /** USBDEV_EPMAP1 FNO_IEP6-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_OEP6_POS                  12                                                            /** USBDEV_EPMAP1 FNO_OEP6-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_OEP6_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_OEP6_POS)                  /** USBDEV_EPMAP1 FNO_OEP6-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_IEP7_POS                  16                                                            /** USBDEV_EPMAP1 FNO_IEP7-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_IEP7_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_IEP7_POS)                  /** USBDEV_EPMAP1 FNO_IEP7-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_OEP7_POS                  20                                                            /** USBDEV_EPMAP1 FNO_OEP7-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_OEP7_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_OEP7_POS)                  /** USBDEV_EPMAP1 FNO_OEP7-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_IEP8_POS                  24                                                            /** USBDEV_EPMAP1 FNO_IEP8-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_IEP8_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_IEP8_POS)                  /** USBDEV_EPMAP1 FNO_IEP8-bit mask */
#define AG903_USB_DEV_EPMAP1_FNO_OEP8_POS                  28                                                            /** USBDEV_EPMAP1 FNO_OEP8-bit position */
#define AG903_USB_DEV_EPMAP1_FNO_OEP8_MSK                  (0xfUL << AG903_USB_DEV_EPMAP1_FNO_OEP8_POS)                  /** USBDEV_EPMAP1 FNO_OEP8-bit mask */

#define AG903_USB_DEV_FMAP_EPNO_FIFO0_POS                  0                                                             /** USBDEV_FMAP EPNO_FIFO0-bit position */
#define AG903_USB_DEV_FMAP_EPNO_FIFO0_MSK                  (0xfUL << AG903_USB_DEV_FMAP_EPNO_FIFO0_POS)                  /** USBDEV_FMAP EPNO_FIFO0-bit mask */
#define AG903_USB_DEV_FMAP_Dir_FIFO0_POS                   4                                                             /** USBDEV_FMAP Dir_FIFO0-bit position */
#define AG903_USB_DEV_FMAP_Dir_FIFO0_MSK                   (0x3UL << AG903_USB_DEV_FMAP_Dir_FIFO0_POS)                   /** USBDEV_FMAP Dir_FIFO0-bit mask */
#define AG903_USB_DEV_FMAP_EPNO_FIFO1_POS                  8                                                             /** USBDEV_FMAP EPNO_FIFO1-bit position */
#define AG903_USB_DEV_FMAP_EPNO_FIFO1_MSK                  (0xfUL << AG903_USB_DEV_FMAP_EPNO_FIFO1_POS)                  /** USBDEV_FMAP EPNO_FIFO1-bit mask */
#define AG903_USB_DEV_FMAP_Dir_FIFO1_POS                   12                                                            /** USBDEV_FMAP Dir_FIFO1-bit position */
#define AG903_USB_DEV_FMAP_Dir_FIFO1_MSK                   (0x3UL << AG903_USB_DEV_FMAP_Dir_FIFO1_POS)                   /** USBDEV_FMAP Dir_FIFO1-bit mask */
#define AG903_USB_DEV_FMAP_EPNO_FIFO2_POS                  16                                                            /** USBDEV_FMAP EPNO_FIFO2-bit position */
#define AG903_USB_DEV_FMAP_EPNO_FIFO2_MSK                  (0xfUL << AG903_USB_DEV_FMAP_EPNO_FIFO2_POS)                  /** USBDEV_FMAP EPNO_FIFO2-bit mask */
#define AG903_USB_DEV_FMAP_Dir_FIFO2_POS                   20                                                            /** USBDEV_FMAP Dir_FIFO2-bit position */
#define AG903_USB_DEV_FMAP_Dir_FIFO2_MSK                   (0x3UL << AG903_USB_DEV_FMAP_Dir_FIFO2_POS)                   /** USBDEV_FMAP Dir_FIFO2-bit mask */
#define AG903_USB_DEV_FMAP_EPNO_FIFO3_POS                  24                                                            /** USBDEV_FMAP EPNO_FIFO3-bit position */
#define AG903_USB_DEV_FMAP_EPNO_FIFO3_MSK                  (0xfUL << AG903_USB_DEV_FMAP_EPNO_FIFO3_POS)                  /** USBDEV_FMAP EPNO_FIFO3-bit mask */
#define AG903_USB_DEV_FMAP_Dir_FIFO3_POS                   28                                                            /** USBDEV_FMAP Dir_FIFO3-bit position */
#define AG903_USB_DEV_FMAP_Dir_FIFO3_MSK                   (0x3UL << AG903_USB_DEV_FMAP_Dir_FIFO3_POS)                   /** USBDEV_FMAP Dir_FIFO3-bit mask */

#define AG903_USB_DEV_FCFG_BLK_TYP_F0_POS                  0                                                             /** USBDEV_FCFG BLK_TYP_F0-bit position */
#define AG903_USB_DEV_FCFG_BLK_TYP_F0_MSK                  (0x3UL << AG903_USB_DEV_FCFG_BLK_TYP_F0_POS)                  /** USBDEV_FCFG BLK_TYP_F0-bit mask */
#define AG903_USB_DEV_FCFG_BLKNO_F0_POS                    2                                                             /** USBDEV_FCFG BLKNO_F0-bit position */
#define AG903_USB_DEV_FCFG_BLKNO_F0_MSK                    (0x3UL << AG903_USB_DEV_FCFG_BLKNO_F0_POS)                    /** USBDEV_FCFG BLKNO_F0-bit mask */
#define AG903_USB_DEV_FCFG_BLKSZ_F0_POS                    4                                                             /** USBDEV_FCFG BLKSZ_F0-bit position */
#define AG903_USB_DEV_FCFG_BLKSZ_F0_MSK                    (0x1UL << AG903_USB_DEV_FCFG_BLKSZ_F0_POS)                    /** USBDEV_FCFG BLKSZ_F0-bit mask */
#define AG903_USB_DEV_FCFG_EN_F0_POS                       5                                                             /** USBDEV_FCFG EN_F0-bit position */
#define AG903_USB_DEV_FCFG_EN_F0_MSK                       (0x1UL << AG903_USB_DEV_FCFG_EN_F0_POS)                       /** USBDEV_FCFG EN_F0-bit mask */
#define AG903_USB_DEV_FCFG_BLK_TYP_F1_POS                  8                                                             /** USBDEV_FCFG BLK_TYP_F1-bit position */
#define AG903_USB_DEV_FCFG_BLK_TYP_F1_MSK                  (0x3UL << AG903_USB_DEV_FCFG_BLK_TYP_F1_POS)                  /** USBDEV_FCFG BLK_TYP_F1-bit mask */
#define AG903_USB_DEV_FCFG_BLKNO_F1_POS                    10                                                            /** USBDEV_FCFG BLKNO_F1-bit position */
#define AG903_USB_DEV_FCFG_BLKNO_F1_MSK                    (0x3UL << AG903_USB_DEV_FCFG_BLKNO_F1_POS)                    /** USBDEV_FCFG BLKNO_F1-bit mask */
#define AG903_USB_DEV_FCFG_BLKSZ_F1_POS                    12                                                            /** USBDEV_FCFG BLKSZ_F1-bit position */
#define AG903_USB_DEV_FCFG_BLKSZ_F1_MSK                    (0x1UL << AG903_USB_DEV_FCFG_BLKSZ_F1_POS)                    /** USBDEV_FCFG BLKSZ_F1-bit mask */
#define AG903_USB_DEV_FCFG_EN_F1_POS                       13                                                            /** USBDEV_FCFG EN_F1-bit position */
#define AG903_USB_DEV_FCFG_EN_F1_MSK                       (0x1UL << AG903_USB_DEV_FCFG_EN_F1_POS)                       /** USBDEV_FCFG EN_F1-bit mask */
#define AG903_USB_DEV_FCFG_BLK_TYP_F2_POS                  16                                                            /** USBDEV_FCFG BLK_TYP_F2-bit position */
#define AG903_USB_DEV_FCFG_BLK_TYP_F2_MSK                  (0x3UL << AG903_USB_DEV_FCFG_BLK_TYP_F2_POS)                  /** USBDEV_FCFG BLK_TYP_F2-bit mask */
#define AG903_USB_DEV_FCFG_BLKNO_F2_POS                    18                                                            /** USBDEV_FCFG BLKNO_F2-bit position */
#define AG903_USB_DEV_FCFG_BLKNO_F2_MSK                    (0x3UL << AG903_USB_DEV_FCFG_BLKNO_F2_POS)                    /** USBDEV_FCFG BLKNO_F2-bit mask */
#define AG903_USB_DEV_FCFG_BLKSZ_F2_POS                    20                                                            /** USBDEV_FCFG BLKSZ_F2-bit position */
#define AG903_USB_DEV_FCFG_BLKSZ_F2_MSK                    (0x1UL << AG903_USB_DEV_FCFG_BLKSZ_F2_POS)                    /** USBDEV_FCFG BLKSZ_F2-bit mask */
#define AG903_USB_DEV_FCFG_EN_F2_POS                       21                                                            /** USBDEV_FCFG EN_F2-bit position */
#define AG903_USB_DEV_FCFG_EN_F2_MSK                       (0x1UL << AG903_USB_DEV_FCFG_EN_F2_POS)                       /** USBDEV_FCFG EN_F2-bit mask */
#define AG903_USB_DEV_FCFG_BLK_TYP_F3_POS                  24                                                            /** USBDEV_FCFG BLK_TYP_F3-bit position */
#define AG903_USB_DEV_FCFG_BLK_TYP_F3_MSK                  (0x3UL << AG903_USB_DEV_FCFG_BLK_TYP_F3_POS)                  /** USBDEV_FCFG BLK_TYP_F3-bit mask */
#define AG903_USB_DEV_FCFG_BLKNO_F3_POS                    26                                                            /** USBDEV_FCFG BLKNO_F3-bit position */
#define AG903_USB_DEV_FCFG_BLKNO_F3_MSK                    (0x3UL << AG903_USB_DEV_FCFG_BLKNO_F3_POS)                    /** USBDEV_FCFG BLKNO_F3-bit mask */
#define AG903_USB_DEV_FCFG_BLKSZ_F3_POS                    28                                                            /** USBDEV_FCFG BLKSZ_F3-bit position */
#define AG903_USB_DEV_FCFG_BLKSZ_F3_MSK                    (0x1UL << AG903_USB_DEV_FCFG_BLKSZ_F3_POS)                    /** USBDEV_FCFG BLKSZ_F3-bit mask */
#define AG903_USB_DEV_FCFG_EN_F3_POS                       29                                                            /** USBDEV_FCFG EN_F3-bit position */
#define AG903_USB_DEV_FCFG_EN_F3_MSK                       (0x1UL << AG903_USB_DEV_FCFG_EN_F3_POS)                       /** USBDEV_FCFG EN_F3-bit mask */

#define AG903_USB_DEV_FIBC_BC_Fn_POS                       0                                                             /** USBDEV_FIBC BC_Fn-bit position */
#define AG903_USB_DEV_FIBC_BC_Fn_MSK                       (0x7ffUL << AG903_USB_DEV_FIBC_BC_Fn_POS)                     /** USBDEV_FIBC BC_Fn-bit mask */
#define AG903_USB_DEV_FIBC_FFRST_POS                       12                                                            /** USBDEV_FIBC FFRST-bit position */
#define AG903_USB_DEV_FIBC_FFRST_MSK                       (0x1UL << AG903_USB_DEV_FIBC_FFRST_POS)                       /** USBDEV_FIBC FFRST-bit mask */

#define AG903_USB_DMA_TFN_ACC_F0_POS                       0                                                             /** USBDMA_TFN ACC_F0-bit position */
#define AG903_USB_DMA_TFN_ACC_F0_MSK                       (0x1UL << AG903_USB_DMA_TFN_ACC_F0_POS)                       /** USBDMA_TFN ACC_F0-bit mask */
#define AG903_USB_DMA_TFN_ACC_F1_POS                       1                                                             /** USBDMA_TFN ACC_F1-bit position */
#define AG903_USB_DMA_TFN_ACC_F1_MSK                       (0x1UL << AG903_USB_DMA_TFN_ACC_F1_POS)                       /** USBDMA_TFN ACC_F1-bit mask */
#define AG903_USB_DMA_TFN_ACC_F2_POS                       2                                                             /** USBDMA_TFN ACC_F2-bit position */
#define AG903_USB_DMA_TFN_ACC_F2_MSK                       (0x1UL << AG903_USB_DMA_TFN_ACC_F2_POS)                       /** USBDMA_TFN ACC_F2-bit mask */
#define AG903_USB_DMA_TFN_ACC_F3_POS                       3                                                             /** USBDMA_TFN ACC_F3-bit position */
#define AG903_USB_DMA_TFN_ACC_F3_MSK                       (0x1UL << AG903_USB_DMA_TFN_ACC_F3_POS)                       /** USBDMA_TFN ACC_F3-bit mask */
#define AG903_USB_DMA_TFN_ACC_CXF_POS                      4                                                             /** USBDMA_TFN ACC_CXF-bit position */
#define AG903_USB_DMA_TFN_ACC_CXF_MSK                      (0x1UL << AG903_USB_DMA_TFN_ACC_CXF_POS)                      /** USBDMA_TFN ACC_CXF-bit mask */

#define AG903_USB_DMA_CPS0_AWCACHE_POS                     0                                                             /** USBDMA_CPS0 AWCACHE-bit position */
#define AG903_USB_DMA_CPS0_AWCACHE_MSK                     (0xfUL << AG903_USB_DMA_CPS0_AWCACHE_POS)                     /** USBDMA_CPS0 AWCACHE-bit mask */
#define AG903_USB_DMA_CPS0_AWPROT_POS                      4                                                             /** USBDMA_CPS0 AWPROT-bit position */
#define AG903_USB_DMA_CPS0_AWPROT_MSK                      (0x7UL << AG903_USB_DMA_CPS0_AWPROT_POS)                      /** USBDMA_CPS0 AWPROT-bit mask */
#define AG903_USB_DMA_CPS0_AWLOCK_POS                      7                                                             /** USBDMA_CPS0 AWLOCK-bit position */
#define AG903_USB_DMA_CPS0_AWLOCK_MSK                      (0x3UL << AG903_USB_DMA_CPS0_AWLOCK_POS)                      /** USBDMA_CPS0 AWLOCK-bit mask */
#define AG903_USB_DMA_CPS0_ARCACHE_POS                     9                                                             /** USBDMA_CPS0 ARCACHE-bit position */
#define AG903_USB_DMA_CPS0_ARCACHE_MSK                     (0xfUL << AG903_USB_DMA_CPS0_ARCACHE_POS)                     /** USBDMA_CPS0 ARCACHE-bit mask */
#define AG903_USB_DMA_CPS0_ARPORT_POS                      13                                                            /** USBDMA_CPS0 ARPORT-bit position */
#define AG903_USB_DMA_CPS0_ARPORT_MSK                      (0x7UL << AG903_USB_DMA_CPS0_ARPORT_POS)                      /** USBDMA_CPS0 ARPORT-bit mask */
#define AG903_USB_DMA_CPS0_ARLOCK_POS                      16                                                            /** USBDMA_CPS0 ARLOCK-bit position */
#define AG903_USB_DMA_CPS0_ARLOCK_MSK                      (0x3UL << AG903_USB_DMA_CPS0_ARLOCK_POS)                      /** USBDMA_CPS0 ARLOCK-bit mask */
#define AG903_USB_DMA_CPS0_BUF_LD_EN_POS                   18                                                            /** USBDMA_CPS0 BUF_LD_EN-bit position */
#define AG903_USB_DMA_CPS0_BUF_LD_EN_MSK                   (0x1UL << AG903_USB_DMA_CPS0_BUF_LD_EN_POS)                   /** USBDMA_CPS0 BUF_LD_EN-bit mask */
#define AG903_USB_DMA_CPS0_DST_WD_POS                      19                                                            /** USBDMA_CPS0 DST_WD-bit position */
#define AG903_USB_DMA_CPS0_DST_WD_MSK                      (0x1UL << AG903_USB_DMA_CPS0_DST_WD_POS)                      /** USBDMA_CPS0 DST_WD-bit mask */

#define AG903_USB_DMA_CPS1_DMA_START_POS                   0                                                             /** USBDMA_CPS1 DMA_START-bit position */
#define AG903_USB_DMA_CPS1_DMA_START_MSK                   (0x1UL << AG903_USB_DMA_CPS1_DMA_START_POS)                   /** USBDMA_CPS1 DMA_START-bit mask */
#define AG903_USB_DMA_CPS1_DMA_TYPE_POS                    1                                                             /** USBDMA_CPS1 DMA_TYPE-bit position */
#define AG903_USB_DMA_CPS1_DMA_TYPE_MSK                    (0x1UL << AG903_USB_DMA_CPS1_DMA_TYPE_POS)                    /** USBDMA_CPS1 DMA_TYPE-bit mask */
#define AG903_USB_DMA_CPS1_DMA_IO_POS                      2                                                             /** USBDMA_CPS1 DMA_IO-bit position */
#define AG903_USB_DMA_CPS1_DMA_IO_MSK                      (0x1UL << AG903_USB_DMA_CPS1_DMA_IO_POS)                      /** USBDMA_CPS1 DMA_IO-bit mask */
#define AG903_USB_DMA_CPS1_DMA_ABORT_POS                   3                                                             /** USBDMA_CPS1 DMA_ABORT-bit position */
#define AG903_USB_DMA_CPS1_DMA_ABORT_MSK                   (0x1UL << AG903_USB_DMA_CPS1_DMA_ABORT_POS)                   /** USBDMA_CPS1 DMA_ABORT-bit mask */
#define AG903_USB_DMA_CPS1_CLRFIFO_DMAABORT_POS            4                                                             /** USBDMA_CPS1 CLRFIFO_DMAABORT-bit position */
#define AG903_USB_DMA_CPS1_CLRFIFO_DMAABORT_MSK            (0x1UL << AG903_USB_DMA_CPS1_CLRFIFO_DMAABORT_POS)            /** USBDMA_CPS1 CLRFIFO_DMAABORT-bit mask */
#define AG903_USB_DMA_CPS1_DMA_LEN_POS                     8                                                             /** USBDMA_CPS1 DMA_LEN-bit position */
#define AG903_USB_DMA_CPS1_DMA_LEN_MSK                     (0x1ffffUL << AG903_USB_DMA_CPS1_DMA_LEN_POS)                 /** USBDMA_CPS1 DMA_LEN-bit mask */
#define AG903_USB_DMA_CPS1_R_HPROT_POS                     25                                                            /** USBDMA_CPS1 R_HPROT-bit position */
#define AG903_USB_DMA_CPS1_R_HPROT_MSK                     (0xfUL << AG903_USB_DMA_CPS1_R_HPROT_POS)                     /** USBDMA_CPS1 R_HPROT-bit mask */
#define AG903_USB_DMA_CPS1_UNDEF_LEN_BURST_POS             29                                                            /** USBDMA_CPS1 UNDEF_LEN_BURST-bit position */
#define AG903_USB_DMA_CPS1_UNDEF_LEN_BURST_MSK             (0x1UL << AG903_USB_DMA_CPS1_UNDEF_LEN_BURST_POS)             /** USBDMA_CPS1 UNDEF_LEN_BURST-bit mask */
#define AG903_USB_DMA_CPS1_L1_WAKEUP_POS                   30                                                            /** USBDMA_CPS1 L1_WAKEUP-bit position */
#define AG903_USB_DMA_CPS1_L1_WAKEUP_MSK                   (0x1UL << AG903_USB_DMA_CPS1_L1_WAKEUP_POS)                   /** USBDMA_CPS1 L1_WAKEUP-bit mask */
#define AG903_USB_DMA_CPS1_DevPhy_Suspend_POS              31                                                            /** USBDMA_CPS1 DevPhy_Suspend-bit position */
#define AG903_USB_DMA_CPS1_DevPhy_Suspend_MSK              (0x1UL << AG903_USB_DMA_CPS1_DevPhy_Suspend_POS)              /** USBDMA_CPS1 DevPhy_Suspend-bit mask */

#define AG903_USB_DMA_CPS2_DMA_MADDR_POS                   0                                                             /** USBDMA_CPS2 DMA_MADDR-bit position */
#define AG903_USB_DMA_CPS2_DMA_MADDR_MSK                   (0xffffffffUL << AG903_USB_DMA_CPS2_DMA_MADDR_POS)            /** USBDMA_CPS2 DMA_MADDR-bit mask */

#define AG903_USB_DMA_CPS3_SETUP_CMD_RPORT_POS             0                                                             /** USBDMA_CPS3 SETUP_CMD_RPORT-bit position */
#define AG903_USB_DMA_CPS3_SETUP_CMD_RPORT_MSK             (0xffffffffUL << AG903_USB_DMA_CPS3_SETUP_CMD_RPORT_POS)      /** USBDMA_CPS3 SETUP_CMD_RPORT-bit mask */

#define AG903_USB_VDMA_CXFPS1_VDMA_START_CXF_POS           0                                                             /** USBVDMA_CXFPS1 VDMA_START_CXF-bit position */
#define AG903_USB_VDMA_CXFPS1_VDMA_START_CXF_MSK           (0x1UL << AG903_USB_VDMA_CXFPS1_VDMA_START_CXF_POS)           /** USBVDMA_CXFPS1 VDMA_START_CXF-bit mask */
#define AG903_USB_VDMA_CXFPS1_VDMA_TYPE_CXF_POS            1                                                             /** USBVDMA_CXFPS1 VDMA_TYPE_CXF-bit position */
#define AG903_USB_VDMA_CXFPS1_VDMA_TYPE_CXF_MSK            (0x1UL << AG903_USB_VDMA_CXFPS1_VDMA_TYPE_CXF_POS)            /** USBVDMA_CXFPS1 VDMA_TYPE_CXF-bit mask */
#define AG903_USB_VDMA_CXFPS1_VDMA_IO_CXF_POS              2                                                             /** USBVDMA_CXFPS1 VDMA_IO_CXF-bit position */
#define AG903_USB_VDMA_CXFPS1_VDMA_IO_CXF_MSK              (0x1UL << AG903_USB_VDMA_CXFPS1_VDMA_IO_CXF_POS)              /** USBVDMA_CXFPS1 VDMA_IO_CXF-bit mask */
#define AG903_USB_VDMA_CXFPS1_VDMA_LEN_CXF_POS             8                                                             /** USBVDMA_CXFPS1 VDMA_LEN_CXF-bit position */
#define AG903_USB_VDMA_CXFPS1_VDMA_LEN_CXF_MSK             (0x1ffffUL << AG903_USB_VDMA_CXFPS1_VDMA_LEN_CXF_POS)         /** USBVDMA_CXFPS1 VDMA_LEN_CXF-bit mask */

#define AG903_USB_VDMA_CXFPS2_VDMA_MADDR_CXF_POS           0                                                             /** USBVDMA_CXFPS2 VDMA_MADDR_CXF-bit position */
#define AG903_USB_VDMA_CXFPS2_VDMA_MADDR_CXF_MSK           (0xffffffffUL << AG903_USB_VDMA_CXFPS2_VDMA_MADDR_CXF_POS)    /** USBVDMA_CXFPS2 VDMA_MADDR_CXF-bit mask */

#define AG903_USB_VDMA_F0PS1_VDMA_START_F0_POS             0                                                             /** USBVDMA_F0PS1 VDMA_START_F0-bit position */
#define AG903_USB_VDMA_F0PS1_VDMA_START_F0_MSK             (0x1UL << AG903_USB_VDMA_F0PS1_VDMA_START_F0_POS)             /** USBVDMA_F0PS1 VDMA_START_F0-bit mask */
#define AG903_USB_VDMA_F0PS1_VDMA_TYPE_F0_POS              1                                                             /** USBVDMA_F0PS1 VDMA_TYPE_F0-bit position */
#define AG903_USB_VDMA_F0PS1_VDMA_TYPE_F0_MSK              (0x1UL << AG903_USB_VDMA_F0PS1_VDMA_TYPE_F0_POS)              /** USBVDMA_F0PS1 VDMA_TYPE_F0-bit mask */
#define AG903_USB_VDMA_F0PS1_VDMA_IO_F0_POS                2                                                             /** USBVDMA_F0PS1 VDMA_IO_F0-bit position */
#define AG903_USB_VDMA_F0PS1_VDMA_IO_F0_MSK                (0x1UL << AG903_USB_VDMA_F0PS1_VDMA_IO_F0_POS)                /** USBVDMA_F0PS1 VDMA_IO_F0-bit mask */
#define AG903_USB_VDMA_F0PS1_VDMA_LEN_F0_POS               8                                                             /** USBVDMA_F0PS1 VDMA_LEN_F0-bit position */
#define AG903_USB_VDMA_F0PS1_VDMA_LEN_F0_MSK               (0x1ffffUL << AG903_USB_VDMA_F0PS1_VDMA_LEN_F0_POS)           /** USBVDMA_F0PS1 VDMA_LEN_F0-bit mask */

#define AG903_USB_VDMA_F0PS2_VDMA_MADDR_F0_POS             0                                                             /** USBVDMA_F0PS2 VDMA_MADDR_F0-bit position */
#define AG903_USB_VDMA_F0PS2_VDMA_MADDR_F0_MSK             (0xffffffffUL << AG903_USB_VDMA_F0PS2_VDMA_MADDR_F0_POS)      /** USBVDMA_F0PS2 VDMA_MADDR_F0-bit mask */

#define AG903_USB_VDMA_F1PS1_VDMA_START_F1_POS             0                                                             /** USBVDMA_F1PS1 VDMA_START_F1-bit position */
#define AG903_USB_VDMA_F1PS1_VDMA_START_F1_MSK             (0x1UL << AG903_USB_VDMA_F1PS1_VDMA_START_F1_POS)             /** USBVDMA_F1PS1 VDMA_START_F1-bit mask */
#define AG903_USB_VDMA_F1PS1_VDMA_TYPE_F1_POS              1                                                             /** USBVDMA_F1PS1 VDMA_TYPE_F1-bit position */
#define AG903_USB_VDMA_F1PS1_VDMA_TYPE_F1_MSK              (0x1UL << AG903_USB_VDMA_F1PS1_VDMA_TYPE_F1_POS)              /** USBVDMA_F1PS1 VDMA_TYPE_F1-bit mask */
#define AG903_USB_VDMA_F1PS1_VDMA_IO_F1_POS                2                                                             /** USBVDMA_F1PS1 VDMA_IO_F1-bit position */
#define AG903_USB_VDMA_F1PS1_VDMA_IO_F1_MSK                (0x1UL << AG903_USB_VDMA_F1PS1_VDMA_IO_F1_POS)                /** USBVDMA_F1PS1 VDMA_IO_F1-bit mask */
#define AG903_USB_VDMA_F1PS1_VDMA_LEN_F1_POS               8                                                             /** USBVDMA_F1PS1 VDMA_LEN_F1-bit position */
#define AG903_USB_VDMA_F1PS1_VDMA_LEN_F1_MSK               (0x1ffffUL << AG903_USB_VDMA_F1PS1_VDMA_LEN_F1_POS)           /** USBVDMA_F1PS1 VDMA_LEN_F1-bit mask */

#define AG903_USB_VDMA_F1PS2_VDMA_MADDR_F1_POS             0                                                             /** USBVDMA_F1PS2 VDMA_MADDR_F1-bit position */
#define AG903_USB_VDMA_F1PS2_VDMA_MADDR_F1_MSK             (0xffffffffUL << AG903_USB_VDMA_F1PS2_VDMA_MADDR_F1_POS)      /** USBVDMA_F1PS2 VDMA_MADDR_F1-bit mask */

#define AG903_USB_VDMA_F2PS1_VDMA_START_F2_POS             0                                                             /** USBVDMA_F2PS1 VDMA_START_F2-bit position */
#define AG903_USB_VDMA_F2PS1_VDMA_START_F2_MSK             (0x1UL << AG903_USB_VDMA_F2PS1_VDMA_START_F2_POS)             /** USBVDMA_F2PS1 VDMA_START_F2-bit mask */
#define AG903_USB_VDMA_F2PS1_VDMA_TYPE_F2_POS              1                                                             /** USBVDMA_F2PS1 VDMA_TYPE_F2-bit position */
#define AG903_USB_VDMA_F2PS1_VDMA_TYPE_F2_MSK              (0x1UL << AG903_USB_VDMA_F2PS1_VDMA_TYPE_F2_POS)              /** USBVDMA_F2PS1 VDMA_TYPE_F2-bit mask */
#define AG903_USB_VDMA_F2PS1_VDMA_IO_F2_POS                2                                                             /** USBVDMA_F2PS1 VDMA_IO_F2-bit position */
#define AG903_USB_VDMA_F2PS1_VDMA_IO_F2_MSK                (0x1UL << AG903_USB_VDMA_F2PS1_VDMA_IO_F2_POS)                /** USBVDMA_F2PS1 VDMA_IO_F2-bit mask */
#define AG903_USB_VDMA_F2PS1_VDMA_LEN_F2_POS               8                                                             /** USBVDMA_F2PS1 VDMA_LEN_F2-bit position */
#define AG903_USB_VDMA_F2PS1_VDMA_LEN_F2_MSK               (0x1ffffUL << AG903_USB_VDMA_F2PS1_VDMA_LEN_F2_POS)           /** USBVDMA_F2PS1 VDMA_LEN_F2-bit mask */

#define AG903_USB_VDMA_F2PS2_VDMA_MADDR_F2_POS             0                                                             /** USBVDMA_F2PS2 VDMA_MADDR_F2-bit position */
#define AG903_USB_VDMA_F2PS2_VDMA_MADDR_F2_MSK             (0xffffffffUL << AG903_USB_VDMA_F2PS2_VDMA_MADDR_F2_POS)      /** USBVDMA_F2PS2 VDMA_MADDR_F2-bit mask */

#define AG903_USB_VDMA_F3PS1_VDMA_START_F3_POS             0                                                             /** USBVDMA_F3PS1 VDMA_START_F3-bit position */
#define AG903_USB_VDMA_F3PS1_VDMA_START_F3_MSK             (0x1UL << AG903_USB_VDMA_F3PS1_VDMA_START_F3_POS)             /** USBVDMA_F3PS1 VDMA_START_F3-bit mask */
#define AG903_USB_VDMA_F3PS1_VDMA_TYPE_F3_POS              1                                                             /** USBVDMA_F3PS1 VDMA_TYPE_F3-bit position */
#define AG903_USB_VDMA_F3PS1_VDMA_TYPE_F3_MSK              (0x1UL << AG903_USB_VDMA_F3PS1_VDMA_TYPE_F3_POS)              /** USBVDMA_F3PS1 VDMA_TYPE_F3-bit mask */
#define AG903_USB_VDMA_F3PS1_VDMA_IO_F3_POS                2                                                             /** USBVDMA_F3PS1 VDMA_IO_F3-bit position */
#define AG903_USB_VDMA_F3PS1_VDMA_IO_F3_MSK                (0x1UL << AG903_USB_VDMA_F3PS1_VDMA_IO_F3_POS)                /** USBVDMA_F3PS1 VDMA_IO_F3-bit mask */
#define AG903_USB_VDMA_F3PS1_VDMA_LEN_F3_POS               8                                                             /** USBVDMA_F3PS1 VDMA_LEN_F3-bit position */
#define AG903_USB_VDMA_F3PS1_VDMA_LEN_F3_MSK               (0x1ffffUL << AG903_USB_VDMA_F3PS1_VDMA_LEN_F3_POS)           /** USBVDMA_F3PS1 VDMA_LEN_F3-bit mask */

#define AG903_USB_VDMA_F3PS2_VDMA_MADDR_F3_POS             0                                                             /** USBVDMA_F3PS2 VDMA_MADDR_F3-bit position */
#define AG903_USB_VDMA_F3PS2_VDMA_MADDR_F3_MSK             (0xffffffffUL << AG903_USB_VDMA_F3PS2_VDMA_MADDR_F3_POS)      /** USBVDMA_F3PS2 VDMA_MADDR_F3-bit mask */

#define AG903_USB_DEV_ISG3_VDMA_CMPLT_CXF_POS              0                                                             /** USBDEV_ISG3 VDMA_CMPLT_CXF-bit position */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_CXF_MSK              (0x1UL << AG903_USB_DEV_ISG3_VDMA_CMPLT_CXF_POS)              /** USBDEV_ISG3 VDMA_CMPLT_CXF-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F0_POS               1                                                             /** USBDEV_ISG3 VDMA_CMPLT_F0-bit position */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F0_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_CMPLT_F0_POS)               /** USBDEV_ISG3 VDMA_CMPLT_F0-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F1_POS               2                                                             /** USBDEV_ISG3 VDMA_CMPLT_F1-bit position */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F1_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_CMPLT_F1_POS)               /** USBDEV_ISG3 VDMA_CMPLT_F1-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F2_POS               3                                                             /** USBDEV_ISG3 VDMA_CMPLT_F2-bit position */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F2_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_CMPLT_F2_POS)               /** USBDEV_ISG3 VDMA_CMPLT_F2-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F3_POS               4                                                             /** USBDEV_ISG3 VDMA_CMPLT_F3-bit position */
#define AG903_USB_DEV_ISG3_VDMA_CMPLT_F3_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_CMPLT_F3_POS)               /** USBDEV_ISG3 VDMA_CMPLT_F3-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_CXF_POS              16                                                            /** USBDEV_ISG3 VDMA_ERROR_CXF-bit position */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_CXF_MSK              (0x1UL << AG903_USB_DEV_ISG3_VDMA_ERROR_CXF_POS)              /** USBDEV_ISG3 VDMA_ERROR_CXF-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F0_POS               17                                                            /** USBDEV_ISG3 VDMA_ERROR_F0-bit position */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F0_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_ERROR_F0_POS)               /** USBDEV_ISG3 VDMA_ERROR_F0-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F1_POS               18                                                            /** USBDEV_ISG3 VDMA_ERROR_F1-bit position */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F1_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_ERROR_F1_POS)               /** USBDEV_ISG3 VDMA_ERROR_F1-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F2_POS               19                                                            /** USBDEV_ISG3 VDMA_ERROR_F2-bit position */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F2_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_ERROR_F2_POS)               /** USBDEV_ISG3 VDMA_ERROR_F2-bit mask */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F3_POS               20                                                            /** USBDEV_ISG3 VDMA_ERROR_F3-bit position */
#define AG903_USB_DEV_ISG3_VDMA_ERROR_F3_MSK               (0x1UL << AG903_USB_DEV_ISG3_VDMA_ERROR_F3_POS)               /** USBDEV_ISG3 VDMA_ERROR_F3-bit mask */

#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_CXF_POS            0                                                             /** USBDEV_MISG3 MVDMA_CMPLT_CXF-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_CXF_MSK            (0x1UL << AG903_USB_DEV_MISG3_MVDMA_CMPLT_CXF_POS)            /** USBDEV_MISG3 MVDMA_CMPLT_CXF-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F0_POS             1                                                             /** USBDEV_MISG3 MVDMA_CMPLT_F0-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F0_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_CMPLT_F0_POS)             /** USBDEV_MISG3 MVDMA_CMPLT_F0-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F1_POS             2                                                             /** USBDEV_MISG3 MVDMA_CMPLT_F1-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F1_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_CMPLT_F1_POS)             /** USBDEV_MISG3 MVDMA_CMPLT_F1-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F2_POS             3                                                             /** USBDEV_MISG3 MVDMA_CMPLT_F2-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F2_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_CMPLT_F2_POS)             /** USBDEV_MISG3 MVDMA_CMPLT_F2-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F3_POS             4                                                             /** USBDEV_MISG3 MVDMA_CMPLT_F3-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_CMPLT_F3_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_CMPLT_F3_POS)             /** USBDEV_MISG3 MVDMA_CMPLT_F3-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_CXF_POS            16                                                            /** USBDEV_MISG3 MVDMA_ERROR_CXF-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_CXF_MSK            (0x1UL << AG903_USB_DEV_MISG3_MVDMA_ERROR_CXF_POS)            /** USBDEV_MISG3 MVDMA_ERROR_CXF-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F0_POS             17                                                            /** USBDEV_MISG3 MVDMA_ERROR_F0-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F0_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_ERROR_F0_POS)             /** USBDEV_MISG3 MVDMA_ERROR_F0-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F1_POS             18                                                            /** USBDEV_MISG3 MVDMA_ERROR_F1-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F1_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_ERROR_F1_POS)             /** USBDEV_MISG3 MVDMA_ERROR_F1-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F2_POS             19                                                            /** USBDEV_MISG3 MVDMA_ERROR_F2-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F2_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_ERROR_F2_POS)             /** USBDEV_MISG3 MVDMA_ERROR_F2-bit mask */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F3_POS             20                                                            /** USBDEV_MISG3 MVDMA_ERROR_F3-bit position */
#define AG903_USB_DEV_MISG3_MVDMA_ERROR_F3_MSK             (0x1UL << AG903_USB_DEV_MISG3_MVDMA_ERROR_F3_POS)             /** USBDEV_MISG3 MVDMA_ERROR_F3-bit mask */

#define AG903_USB_VDMA_CTRL_VDMA_EN_POS                    0                                                             /** USBVDMA_CTRL VDMA_EN-bit position */
#define AG903_USB_VDMA_CTRL_VDMA_EN_MSK                    (0x1UL << AG903_USB_VDMA_CTRL_VDMA_EN_POS)                    /** USBVDMA_CTRL VDMA_EN-bit mask */

#define AG903_USB_LPM_CAP_LPM_WAKEUP_EN_POS                0                                                             /** USBLPM_CAP LPM_WAKEUP_EN-bit position */
#define AG903_USB_LPM_CAP_LPM_WAKEUP_EN_MSK                (0x1UL << AG903_USB_LPM_CAP_LPM_WAKEUP_EN_POS)                /** USBLPM_CAP LPM_WAKEUP_EN-bit mask */

#define AG903_USB_DEV_ISG4_L1_INT_POS                      0                                                             /** USBDEV_ISG4 L1_INT-bit position */
#define AG903_USB_DEV_ISG4_L1_INT_MSK                      (0x1UL << AG903_USB_DEV_ISG4_L1_INT_POS)                      /** USBDEV_ISG4 L1_INT-bit mask */

#define AG903_USB_DEV_MISG4_ML1_INT_POS                    0                                                             /** USBDEV_MISG4 ML1_INT-bit position */
#define AG903_USB_DEV_MISG4_ML1_INT_MSK                    (0x1UL << AG903_USB_DEV_MISG4_ML1_INT_POS)                    /** USBDEV_MISG4 ML1_INT-bit mask */

#endif /* _AG903_USB_REGMAP_H_ */

