/**
 * @brief           USBH CDC type Header
 * @author          AXELL CORPORATION
 * @description     USBH CDC type Header
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */


#ifndef __USB_CDC_TYPE_H__
#define __USB_CDC_TYPE_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "usb_cdc_coreinclude.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
/** CDCfoCXڑ\Ȑ */
#define CDC_SUPPORT_DEVICE_NUM	USBH_MAX_CLS_CDC_NUM

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/
/* ========================================================================= */
/* R~jP[VfoCX̏ */
/* ========================================================================= */
typedef enum {
    CDC_DEVICE_STAT_CONNECTING,						/* foCXڑ */
    CDC_DEVICE_STAT_REGIST,							/* foCXo^ */
    CDC_DEVICE_STAT_NO_SUPPORT,						/* gps(Ή)foCX */
    CDC_DEVICE_STAT_CLOSE,							/* N[Y */
    CDC_DEVICE_STAT_OPEN							/* I[v */
} CDC_DEVICE_STAT;

/* ========================================================================= */
/* ֐̖߂l */
/* ========================================================================= */
typedef enum {
	CDC_FUNC_STATUS_SUCCESS,						/*  */
	CDC_FUNC_STATUS_BASE = 0x200,					/* G[R[h̊l */
	CDC_FUNC_STATUS_HALT_PIPE						/* PipeHALTĂ */,
	CDC_FUNC_STATUS_NOT_INIT,						/* hCo */
	CDC_FUNC_STATUS_NO_DEVICE,						/* foCXڑ */
	CDC_FUNC_STATUS_NOT_USE,						/* foCX */
    CDC_FUNC_STATUS_FAILED_CBI_INIT,				/* Control Bulk Interrupt w̏Ɏs */
    CDC_FUNC_STATUS_FAILED_CBI_EXIT,				/* Control Bulk Interrupt w̏IɎs */
    CDC_FUNC_STATUS_FAILED_CRE_CDCD,				/* CommunicationDeviceClassDriver̍쐬Ɏs */
    CDC_FUNC_STATUS_FAILED_DEL_CDCD,				/* CommunicationDeviceClassDriver̍폜Ɏs */
    CDC_FUNC_STATUS_FAILED_BULK,					/* oN]Ɏs */
    CDC_FUNC_STATUS_FAILED_CTRL,					/* Rg[]Ɏs */
    CDC_FUNC_STATUS_FAILED_INTERRUPT,				/* C^[vg]Ɏs */
    CDC_FUNC_STATUS_FAILED_STDREQ,					/* WNGXgɎs */
    CDC_FUNC_STATUS_FAILED_CLSREQ,					/* NXNGXgɎs */
	CDC_FUNC_STATUS_FAILED_CRE_CDD,					/* CommunicationDevice̍쐬Ɏs */
	CDC_FUNC_STATUS_FAILED_ADD_CDD,					/* CommunicationDevice̒ǉɎs */
    CDC_FUNC_STATUS_FAILED_REMOVE_CDD,				/* CommunicationDevice̊JɎs */
	CDC_FUNC_STATUS_FAILED_CRE_CPIPE,				/* ControlPIPE̍쐬Ɏs */
	CDC_FUNC_STATUS_FAILED_OPEN_CPIPE,				/* ControlPIPEOpenɎs */
	CDC_FUNC_STATUS_FAILED_CRE_BPIPE,				/* BulkPIPE̍쐬Ɏs */
	CDC_FUNC_STATUS_FAILED_OPEN_BPIPE,				/* BulkPIPEOpenɎs */
	CDC_FUNC_STATUS_FAILED_CRE_IPIPE,				/* InterruptPIPE̍쐬Ɏs */
	CDC_FUNC_STATUS_FAILED_OPEN_IPIPE,				/* InterruptPIPEOpenɎs */
    CDC_FUNC_STATUS_INTERNAL_FAILED_CORE,			/* RAG[񍐂ꂽ */
    CDC_FUNC_STATUS_INTERNAL_FAILED_CDC,			/* hCoG[ */
    CDC_FUNC_STATUS_SYS_SYSTEM_ERROR,				/* VXeG[ */
    CDC_FUNC_STATUS_SYS_OUT_OF_RESOURCE,			/* VXe\[X(Z}tHAtOA)̃ANZXŃG[ */
    CDC_FUNC_STATUS_SYS_PARAM_ERROR					/* p[^wɌ肪 */
} CDC_FUNC_STATUS;

/* ========================================================================= */
/* R[obNʒm */
/* ========================================================================= */
typedef enum {
    CDC_NOTIFY_TYPE_INTERRUPT_IN,					/* C^vg IN ]R[obNʒm */
    CDC_NOTIFY_TYPE_BULK_IN							/* oN IN ]R[obNʒm */
} CDC_NOTIFY_TYPE;

/* ========================================================================= */
/* R~jP[VNXLʒmR[h */
/* ========================================================================= */
typedef enum {
    CDC_NOTIFY_CODE_NETWORK_CONNECTION = 0x00,
    CDC_NOTIFY_CODE_RESPONSE_AVAILABLE,
    CDC_NOTIFY_CODE_AUX_JACK_HOOK_STATE = 0x08,
    CDC_NOTIFY_CODE_RING_DETECT,
    CDC_NOTIFY_CODE_SERIAL_STATE = 0x20,
    CDC_NOTIFY_CODE_CALL_STATE_CHANGE = 0x28,
    CDC_NOTIFY_CODE_LINE_STATE_CHANGE,
    CDC_NOTIFY_CODE_CONNECTION_SPEED_CHANGE
} CDC_NOTIFY_CODE;

/** Mf[^ւ̃|C^ */
typedef struct CdcBuffInfo* PCDC_BUFF_INFO;
/** [UAvP[Vwւ̒ʒmւ̃|C^ */
typedef struct CdcNotifyInfo* PCDC_NOTIFY_INFO;
/** R~jP[VfoCXNXhCoւ̃|C^ */
typedef struct CdcDriver* PCDC_DRIVER;
/** R~jP[VfoCXւ̃|C^ */
typedef struct CdcDevice* PCDC_DEVICE;
/** R~jP[VfoCXpCvւ̃|C^ */
typedef struct CdcPipe* PCDC_PIPE;
/** R~jP[VfoCX Bulk IN pMobt@ւ̃|C^ */
typedef struct CdcBulkInBuff* PCDC_BULKIN_BUFF;
/** R~jP[VfoCX Interrupt IN pMobt@ւ̃|C^ */
typedef struct CdcIntInBuff* PCDC_INTIN_BUFF;

/** [UAvP[Vw ʒm Callback ֐^`<p>
    uhs_status_t^ŕԋpRetValɂ́Aʂi[܂B */
typedef void (*cdc_callback_t)( PCDC_NOTIFY_INFO pNotifyInfo, uhs_status_t RetVal );

/** M̃f[^i[obt@<p>
    ^C~O F f[^MO<p>
    폜^C~O F f[^M */
typedef struct CdcBuffInfo {
    uhs_ubit32_t		u32ActualLength;				/** ]σf[^TCY(MFMσTCYAMFfoCXԂꂽf[^̃TCY) */
    uhs_ubit32_t		u32RequestLength;				/** NGXgf[^̃OX */
    uhs_ubit8_t*		pu8Buff;						/** obt@̃|C^(LbV̈) */
} CDC_BUFF_INFO;

/** [UAvP[Vwւ̒ʒmێf[^<p>
    CallbackNotifyType ɂĊeo̗L^ς܂B<p>
    yCallbackNotifyType = CDC_NOTIFY_TYPE_INTERRUPT_INz<p>
      EpContext F L<p>
      EClassNotifyCode F L<p>
      Eu16wValue F L (i[ꂽf[^̏ڍׂɂẮuUniversal Serial Bus Communications Class Subclass Specification for PSTN DevicesvQƁB)<p>
      Eu32RemainBuffSize F <p>
      Eu32Length F L<p>
      Epu8Buff F L (Mf[^̏ڍׂɂẮuUniversal Serial Bus Communications Class Subclass Specification for PSTN DevicesvQƁB)<p>
        Mf[^݂ꍇ́AR[obNʒm֐ŕKMf[^ĉB<p>
    yCallbackNotifyType = CDC_NOTIFY_TYPE_BULK_INz<p>
      EpContext F L<p>
      EClassNotifyCode F <p>
      Eu16wValue F <p>
      Eu32RemainBuffSize F L (TCY̓oCgPʁBBcTCY 1KB ̏ꍇ́AMobt@tԂƂāu0vi[)<p>
      Eu32Length F L<p>
      Epu8Buff F <p>
    ^C~O F [UAvP[Vւ̒ʒmO<p>
    폜^C~O F [UAvP[Vւ̒ʒm */
typedef struct CdcNotifyInfo {
    void*				pContext;						/** foCXʎq */
    CDC_NOTIFY_TYPE		CallbackNotifyType;				/** R[obNʒm */
    CDC_NOTIFY_CODE		ClassNotifyCode;				/** R~jP[VNXLʒmR[h */
    uhs_ubit16_t		u16wValue;						/** R~jP[VNXʒml */
    uhs_ubit16_t		dummy;							/** s (ĉ) */
    uhs_ubit32_t		u32RemainBuffSize;				/** Mobt@cTCY */
    uhs_ubit32_t		u32Length;						/** f[^̃OX */
    uhs_ubit8_t*		pu8Buff;						/** obt@̃|C^ */
} CDC_NOTIFY_INFO;

/* ========================================================================= */
/* R~jP[VfoCXNXhCo ^̒` */
/* ========================================================================= */
typedef struct CdcDriver {
    /* -- vpeB\o[ ----------------------------------------- */
    usb_common_callback_t			pUserAttachCallback;									/* [UAvP[Vw Attach Callback ֐ */
    usb_common_callback_t			pUserDetachCallback;									/* [UAvP[Vw Detach Callback ֐ */
    struct class_driver_reginfo*	pDrvRegInfo;											/* Core o^pe[ũobt@ */
    PCDC_DEVICE						pCdcDeviceHead;											/* {hCoǗfoCX̃Xg */
    kernel_context_t				oApiDetAccessLockObj[CDC_SUPPORT_DEVICE_NUM];			/* API֐DetachpbNIuWFNg̎ */
    kernel_context_t*				pApiDetAccessLock[CDC_SUPPORT_DEVICE_NUM];				/* API֐DetachpANZXbNւ̃|C^ */
    kernel_context_t				oClsReqDetAccessLockObj[CDC_SUPPORT_DEVICE_NUM];		/* Class Request API֐DetachpbNIuWFNg̎ */
    kernel_context_t*				pClsReqDetAccessLock[CDC_SUPPORT_DEVICE_NUM];			/* Class Request API֐DetachpANZXbNւ̃|C^ */
    kernel_context_t				oBulkINDoneDetAccessLockObj[CDC_SUPPORT_DEVICE_NUM];	/* Bulk IN ]R[obNDetachpbNIuWFNg̎ */
    kernel_context_t*				pBulkINDoneDetBuffAccessLock[CDC_SUPPORT_DEVICE_NUM];	/* Bulk IN ]R[obNDetachpANZXbNւ̃|C^ */
    kernel_context_t				oIntINDoneDetAccessLockObj[CDC_SUPPORT_DEVICE_NUM];		/* Int IN ]R[obNDetachpbNIuWFNg̎ */
    kernel_context_t*				pIntINDoneDetBuffAccessLock[CDC_SUPPORT_DEVICE_NUM];	/* Int IN ]R[obNDetachpANZXbNւ̃|C^ */
	PCDC_DEVICE						pDeviceID[CDC_SUPPORT_DEVICE_NUM];						/* ֐Ɛؒf̃Z}tHp foCXID */
} CDC_DRIVER;

/* ========================================================================= */
/* R~jP[VfoCX ^̒` */
/* ========================================================================= */
typedef struct CdcDevice {
    /* -- vpeB\o[ ----------------------------------------- */
    struct usbd_usb_deviceinfo*	pUsbCore_Dev;				/* USB Core ێfoCX */
    PCDC_PIPE					pCtrlPipe_I;				/* {foCX Default Ctrl In Pipe */
    PCDC_PIPE					pCtrlPipe_O;				/* {foCX Default Ctrl Out Pipe */
    PCDC_PIPE					pIntInPipe;					/* {foCX Interrupt In Pipe */
    PCDC_PIPE					pBulkInPipe;				/* {foCX Bulk In Pipe */
    PCDC_PIPE					pBulkOutPipe;				/* {foCX Bulk Out Pipe */
    PCDC_INTIN_BUFF				pIntInBuff;					/* Interrupt IN ]pMobt@ */
    PCDC_BULKIN_BUFF			pBulkInBuff;				/* Bulk IN ]pMobt@ */
    CDC_DEVICE_STAT				nDeviceStat;				/* foCX̏ */
    cdc_callback_t				pUserNotifyCallback;		/* [UAvP[Vw ʒm Callback ֐ */
    /* -- ̂߂̃o[ --------------------------------------------- */
    kernel_context_t			oCommExecuteLockObj;		/* R~jP[VNXpbNIuWFNg̎(Control]IN/OUTɎgp) */
    kernel_context_t*			pCommExecuteLock;			/* R~jP[VNXpsbNւ̃|C^ */
    kernel_context_t			oIntInExecuteLockObj;		/* C^vg]pbNIuWFNg̎(Interrupt]INɎgp) */
    kernel_context_t*			pIntInExecuteLock;			/* C^vg]psbNւ̃|C^ */
    kernel_context_t			oDataInExecuteLockObj;		/* f[^NXpbNIuWFNg̎(Bulk]INɎgp) */
    kernel_context_t*			pDataInExecuteLock;			/* f[^NXpsbNւ̃|C^ */
    kernel_context_t			oDataOutExecuteLockObj;		/* f[^NXpbNIuWFNg̎(Bulk]OUTɎgp) */
    kernel_context_t*			pDataOutExecuteLock;		/* f[^NXpsbNւ̃|C^ */
    kernel_context_t			oRegistExecuteLockObj;		/* R[obNo^pbNIuWFNg̎(Usbh_Cdc_RegistCallBack API Ɏgp) */
    kernel_context_t*			pRegistExecuteLock;			/* R[obNo^psbNւ̃|C^ */
    kernel_context_t			oBulkINBuffAccessLockObj;	/* Bulk IN ]Mobt@pbNIuWFNg̎(Bulk IN ]Mobt@Ɏgp) */
    kernel_context_t*			pBulkINBuffAccessLock;		/* Bulk IN ]Mobt@pANZXbNւ̃|C^ */
    /* -- \\o[ ----------------------------------------------- */
    PCDC_DEVICE					pNext;						/* ̃R~jP[VfoCX */
    PCDC_DRIVER					pParent;					/* {R~jP[VfoCXǗehCo */
    uhs_boolean_t				(*Delete)(PCDC_DEVICE);		/* foCX̍폜֐ */
} CDC_DEVICE;

/* ========================================================================= */
/* R~jP[VfoCXpCv ^̒` */
/* ========================================================================= */
typedef struct CdcPipe {
    /* -- vpeB\o[ ----------------------------------------- */
    uhs_ubit32_t				u32PipeInfo;			/* { Pipe  Core \LbV */
    struct usb_control_block*	pUcb;					/* { Pipe gp UCB  */
    struct usb_control_block*	pClearFeatureUcb;		/* { Pipe gp ClearFeaturep UCB  */
    uhs_boolean_t				bIsOpen;				/* I[v */
    uhs_ubit32_t				u32MaxPacketSize;		/* { Pipe  MAX PACKET SIZE */
    uhs_ubit8_t					u8Interval;				/* { Pipe  Interval */
	uhs_ubit8_t					dummy1;
	uhs_ubit16_t				dummy2;
    uhs_sbit32_t				s32Cnt_Transfering;		/* ]JE^ */
    kernel_context_t*			oReq_Done;				/* ]CxgpIuWFNg(Ctrl, BulkOutɎgp)ւ̃|C^ */
    /* -- \\o[ ----------------------------------------------- */
    struct usbd_usb_deviceinfo*	pParentDev;				/* { Pipe efoCX */
} CDC_PIPE;

/* ========================================================================= */
/* R~jP[VfoCX Bulk IN pMobt@ ^̒` */
/* ========================================================================= */
typedef struct CdcBulkInBuff {
    uhs_ubit8_t*				pu8StartBuff;			/* Mobt@̐擪|C^ */
    uhs_ubit8_t*				pu8EndBuff;				/* Mobt@̏I|C^ */
    uhs_ubit8_t*				pu8ReadPos;				/* Mobt@̃[h|C^ */
    uhs_ubit8_t*				pu8WritePos;			/* Mobt@̃Cg|C^ */
    uhs_ubit8_t*				pu8TempBuff;			/* e|Bobt@̐擪|C^ */
    uhs_ubit8_t					u8TotalBuffSize;		/* Mobt@TCY(1KB P) */
    uhs_ubit32_t				u32RemainBuffSize;		/* Mobt@cTCY(1BYTE P) */
    uhs_boolean_t				isBulkINFlag;			/* Bulk IN ]ԃtO */
    uhs_boolean_t				isBulkINUserFlag;		/* [Uw Bulk IN ]ԃtO */
} CDC_BULKIN_BUFF;

/* ========================================================================= */
/* R~jP[VfoCX Interrupt IN pMobt@ ^̒` */
/* ========================================================================= */
typedef struct CdcIntInBuff {
    uhs_ubit8_t*				pu8StartBuff;			/* Mobt@̐擪|C^ */
    uhs_ubit8_t					u8WritePos;				/* Mobt@̃Cgʒu */
    uhs_ubit8_t*				pu8TempBuff;			/* e|Bobt@̐擪|C^ */
    uhs_ubit8_t					u8ReceiveSize;			/* MTCY */
    uhs_boolean_t				isIntINUserFlag;		/* [Uw Interrupt IN ]ԃtO */
} CDC_INTIN_BUFF;

#endif  /* __USB_CDC_TYPE_H__ */

