/**
 * @brief       PGP Manager (Init Handles)
 * @author      AXELL CORPORATION
 * @description PGP Manager Layer.
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include <string.h>
#include "pgpmgr_common.h"

/**
 * @brief   pCvCnh̃f[^\܂B<p>{֐AG903_PgpMgrGetPipelineHandle֐Ăяo܂B
 * @param   handle [in,out] pCvCnhB
 * @return  none
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
void PgpMgrInitPipelineHandle(AG903_PgpMgrPipelineHandle *handle)
{
    /* l0Afalse͂܂Ƃ߂ď܂ */
    memset(handle, 0, sizeof(AG903_PgpMgrPipelineHandle));

    handle->pipeline_no = -1;
    handle->is_dirty = true;
    handle->input_intr_field = AG903_PGP_MGR_INTR_CTRL_FIELD_ODD_EVEN;
    handle->input_intr_fcnt = 16;
    handle->output_intr_field = AG903_PGP_MGR_INTR_CTRL_FIELD_ODD_EVEN;
    handle->output_intr_fcnt = 16;
    handle->input_trig_field = AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD_EVEN;
    handle->input_trig_fcnt = 16;
    handle->output_trig_field = AG903_PGP_MGR_TRIG_CTRL_FIELD_ODD_EVEN;
    handle->output_trig_fcnt = 16;
    handle->input_mode = AG903_PGP_MGR_INPUT_MD_VSYNC;
    handle->input_timer_clk = AG903_PGP_MGR_INPUT_TIME_CLK0;
    handle->input_port = AG903_PGP_MGR_INPUT_PORT_VRAM_0;
    handle->input_format = AG903_PGP_MGR_INPUT_FMT_RGB888;
    handle->frame_out_enable = true;
    handle->ifc_order = AG903_PGP_MGR_IFCODR_FRAME_TO_OTHER;
    handle->input_vsize = 480;
    handle->input_hsize = 640;
    handle->input_scan = AG903_PGP_MGR_SCAN_PROGRESSIVE;
    handle->input_vpos = 35;
    handle->input_hpos = 144;
    handle->output_limit = AG903_PGP_MGR_LIMIT_0_255;
    handle->output_bmu = AG903_PGP_MGR_OUTPUT_BMU_NONE;
    handle->output_scan = AG903_PGP_MGR_SCAN_PROGRESSIVE;
    handle->output_dim = AG903_PGP_MGR_ADDR_DIMENTION_1;
    handle->output_md = AG903_PGP_MGR_OUTPUT_FRAME_SAVE_ODD;
    handle->output_format = AG903_PGP_MGR_OUTPUT_FMT_RGB888_TO_RGB888_32BIT;
    handle->output_red_enable = true;
    handle->output_green_enable = true;
    handle->output_blue_enable = true;
    handle->output_vram_stride = 4096;
    handle->ipc_limit = AG903_PGP_MGR_LIMIT_0_255;
    handle->csc1_limit = AG903_PGP_MGR_LIMIT_0_255;
    handle->scale_limit = AG903_PGP_MGR_LIMIT_0_255;
    handle->scale_mtd = AG903_PGP_MGR_FILTER_NEAREST;
    handle->scale_v_nmr = 1;
    handle->scale_v_dnm = 1;
    handle->scale_h_nmr = 1;
    handle->scale_h_dnm = 1;
    handle->spf_border_sel = AG903_PGP_MGR_SPF_BORDER_COLOR;
    handle->hsv_hls_sel = AG903_PGP_MGR_CONVERT_HSV;
    handle->hgm_exc = AG903_PGP_MGR_HGM_EXC_NONE;
    handle->hgm_vsize = 480;
    handle->hgm_hsize = 640;
    handle->thr_limit = AG903_PGP_MGR_LIMIT_NONE;
    handle->thr_out_sel = AG903_PGP_MGR_THR_OUT_SEL_RGB;
    handle->thr_clut8_sel = AG903_PGP_MGR_THR_CLUT8_OUT_B;
    handle->thr_hsv_hls_sel = AG903_PGP_MGR_CONVERT_HSV;
    handle->thr_csc2_limit = AG903_PGP_MGR_LIMIT_0_255;
    handle->thr_thr8_prm_type[0] = handle->thr_thr8_prm_type[1] = handle->thr_thr8_prm_type[2] = AG903_PGP_MGR_THR_8BIT_TYPE_THR_BIN;
    handle->lbl_valid = 16;
    handle->lbl_connect = AG903_PGP_MGR_LBL_CNCT_8;
    handle->lbl_maxid = 0xFF;
    handle->lbl_vsize = 480;
    handle->lbl_hsize = 640;
    handle->ifc_scan = AG903_PGP_MGR_SCAN_PROGRESSIVE;
    handle->ifc_limit = AG903_PGP_MGR_LIMIT_0_255;
    handle->ifc_slave_src = AG903_PGP_MGR_IFC_SLAVE_VRAM_UI;
    handle->ifc_operation = AG903_PGP_MGR_IFC_OP_AND;
    handle->ifc_slave_gain = 1;
    handle->ifc_master_gain = 1;
}


/**
 * @brief   VRAM̓nh̃f[^\܂B<p>{֐AG903_PgpMgrGetVRAMInputHandle֐Ăяo܂B
 * @param   handle [in,out] VRAM̓nhB
 * @return  none
 * @note    {֐̓[U[ڎgp邱Ƃ͂܂B
*/
void PgpMgrInitVRAMInputHandle(AG903_PgpMgrVRAMInputHandle *handle)
{
    /* l0Afalse͂܂Ƃ߂ď܂ */
    memset(handle, 0, sizeof(AG903_PgpMgrVRAMInputHandle));

    handle->port_no = -1;
    handle->is_dirty = true;
    handle->bmu = AG903_PGP_MGR_VI_BMU_NONE;
    handle->scan = AG903_PGP_MGR_SCAN_PROGRESSIVE;
    handle->dim = AG903_PGP_MGR_ADDR_DIMENTION_1;
    handle->md = AG903_PGP_MGR_VI_FRAME_READ_ODD;
    handle->format = AG903_PGP_MGR_VI_FMT_RGB888_32;
    handle->div = 1;
    handle->valid = 16;
    handle->stride = 4096;
    handle->h_pulse_width = 96;
    handle->h_front_porch = 16;
    handle->h_back_porch = 48;
    handle->h_frame_size = 640;
    handle->v_pulse_width = 2;
    handle->v_front_porch = 10;
    handle->v_back_porch = 33;
    handle->v_frame_size = 480;
}


