/**
 * @brief           WDT Controller Header
 * @author          AXELL CORPORATION
 * @description     WDT Controller񋟃wb_B<p>WDT ControllergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
#ifndef __WDTCTL_H__
#define __WDTCTL_H__
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"

#ifdef __cplusplus
extern "C" {
#endif

/** WDTݒp[^<p>
    enable ͉Ew肵܂B AG903_WDT_SYSRESET_ENABLE , AG903_WDT_SYSINTR_ENABLE , AG903_WDT_EXTSIGNAL_ENABLE */
typedef struct _AG903_WDTCtlParam{
	uint32_t	count;		/** JEgl */
	uint8_t		intrlen;	/** wd_rstAT[g [clk] */
	uint8_t		enable;		/** Enable Bit */
	uint8_t		rsv[2];		/** \ */
} AG903_WDTCtlParam;

#define AG903_WDT_SYSRESET_ENABLE		(1<<0)	/** system reset enable bit */
#define AG903_WDT_SYSINTR_ENABLE		(1<<1)	/** system interrupt enable bit */
#define AG903_WDT_EXTSIGNAL_ENABLE		(1<<2)	/** external signal enable bit */


int32_t AG903_WDTCtlInit(AG903_WDTCtlParam* param);
int32_t	AG903_WDTCtlSetIntHandler(void* func, void* param);
int32_t	AG903_WDTCtlDeleteIntHandler(void);
void AG903_WDTCtlEnable(void);
void AG903_WDTCtlDisable(void);
void AG903_WDTCtlRestart(void);
int32_t AG903_WDTCtlGetStatus(uint32_t* status);
int32_t AG903_WDTCtlClearStatus(void);
int32_t AG903_WDTCtlGetCount(uint32_t* count);

#ifdef __cplusplus
}
#endif

#endif/* __WDTCTL_H__ */
