/**
 * @brief           zEChEVXewb_
 * @author          AXELL CORPORATION
 * @description     OpenVG/EGL̂߂̉zEChEVXe̒`
 * @note            none
 * @history         2017_02_22  
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#ifndef VXVLIB_H
#define VXVLIB_H

#define VXLIB(func)    func

typedef void                    VXDisplay;
typedef void*                   VXWindow;
typedef void*                   VXPixmap;
typedef int                     VXint;
typedef unsigned int            VXuint;

#define VXAPI                   extern

/* Query Attribute */
#define VX_WIDTH    0x00000001
#define VX_HEIGHT   0x00000002
#define VX_ADDR     0x00000004
#define VX_SWIDTH   0x00000008
#define VX_SHEIGHT  0x00000010
#define VX_DEPTH    0x00000020
#define VX_PIXEL_FORMAT		0x00000080
#define VX_PALETTE_FORMAT	0x00000100
#define VX_PALETTE_ADDRESS	0x00000200
#define VX_VALID    0x10000000

/* Error Code */
#define VX_NO_ERROR         0x00000000
#define VX_BAD_ALLOC        0x00000001
#define VX_BAD_DISPLAY      0x00000002
#define VX_BAD_WINDOW       0x00000003
#define VX_BAD_PIXMAP       0x00000004
#define VX_BAD_ATTRIBUTE    0x00000005
#define VX_INVALID_VALUE    0x00000006

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

VXAPI VXDisplay* VXLIB(VXOpenDisplay)(char   *id);
VXAPI void       VXLIB(VXCloseDisplay)(VXDisplay *dpy);
VXAPI VXWindow   VXLIB(VXCreateWindow)(VXDisplay *dpy, VXint x, VXint y, VXint width, VXint height, VXint depth);
VXAPI void       VXLIB(VXDestroyWindow)(VXDisplay *dpy, VXWindow win);
VXAPI VXPixmap   VXLIB(VXCreatePixmap)(VXDisplay *dpy, VXWindow win, VXint width, VXint height, VXint depth);
VXAPI void       VXLIB(VXFreePixmap)(VXDisplay *dpy, VXPixmap pixmap);
VXAPI void       VXLIB(VXQueryDisplay)(VXDisplay *dpy, VXuint attribute, VXuint *value);
VXAPI void       VXLIB(VXQueryWindow)(VXDisplay *dpy, void *target, VXuint attribute, VXuint *value);
VXAPI void       VXLIB(VXSetWindowAttrib)(VXDisplay *dpy, VXWindow win, VXuint attribute, VXuint value);
VXAPI VXuint     VXLIB(VXGetError)(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* VXLIB_H */

