/**
 * @brief           AG903 IRQ Number Definition
 * @author          AXELL CORPORATION
 * @description     AG903 荞ݔԍ`
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
 */
/* DOM-IGNORE-BEGIN */
/*
*  This program was created by AXELL CORPORATION.
*  Copyright (C) 2017 AXELL CORPORATION. all rights reserved.
*/

#ifndef _AG903_INTNO_H_
#define _AG903_INTNO_H_
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

#define	AG903_IRQ0_TIM0			 0	/* IRQ0  TIMER0 */
#define	AG903_IRQ1_TIM1			 1	/* IRQ1  TIMER1 */
#define	AG903_IRQ2_TIM2			 2	/* IRQ2  TIMER2 */
#define	AG903_IRQ3_TIM3			 3	/* IRQ3  TIMER3 */
#define	AG903_IRQ4_TIM4			 4	/* IRQ4  TIMER4 */
#define	AG903_IRQ5_TIM5			 5	/* IRQ5  TIMER5 */
#define	AG903_IRQ6_TIM6			 6	/* IRQ6  TIMER6 */
#define	AG903_IRQ7_TIM7			 7	/* IRQ7  TIMER7 */
#define	AG903_IRQ8_UART0		 8	/* IRQ8  UART0 */
#define	AG903_IRQ9_UART1		 9	/* IRQ9  UART1 */
#define	AG903_IRQ10_UART2		10	/* IRQ10 UART2 */
#define	AG903_IRQ11_UART3		11	/* IRQ11 UART3 */
#define	AG903_IRQ12_SSP0		12	/* IRQ12 SSP0 */
#define	AG903_IRQ13_SSP1		13	/* IRQ13 SSP1 */
#define	AG903_IRQ14_SSP2		14	/* IRQ14 SSP2 */
#define	AG903_IRQ15_SSP3		15	/* IRQ15 SSP3 */
#define	AG903_IRQ16_DSP0		16	/* IRQ16 \0 */
#define	AG903_IRQ17_DSP1		17	/* IRQ17 \1 */
#define	AG903_IRQ18_GFX			18	/* IRQ18 ` */
#define	AG903_IRQ19_DTA			19	/* IRQ19 tLt] */
#define	AG903_IRQ20_GVD0		20	/* IRQ20 H.264fR[_ 荞ݗv0 */
#define	AG903_IRQ21_GVD1		21	/* IRQ21 H.264fR[_ 荞ݗv1 */
#define	AG903_IRQ22_GVD2		22	/* IRQ22 H.264fR[_ 荞ݗv2 */
#define	AG903_IRQ23_JPG			23	/* IRQ23 JPEGR[fbN */
#define	AG903_IRQ24_HDA			24	/* IRQ24 HDI[fBI */
#define	AG903_IRQ25_WDT			25	/* IRQ25 EHb`hbO^C} */
#define	AG903_IRQ26_DMAC		26	/* IRQ26 DMARg[ */
#define	AG903_IRQ27_SPC			27	/* IRQ27 VXevC} */
#define	AG903_IRQ28_SSC0		28	/* IRQ28 VXeZJ_ 荞ݗv0 */
#define	AG903_IRQ29_SSC1		29	/* IRQ29 VXeZJ_ 荞ݗv1 */
#define	AG903_IRQ30_SSC2		30	/* IRQ30 VXeZJ_ 荞ݗv2 */
#define	AG903_IRQ31_SSC3		31	/* IRQ31 VXeZJ_ 荞ݗv3 */
#define	AG903_IRQ32_PGP0		32	/* IRQ32 摜O 荞ݗv0 */
#define	AG903_IRQ33_PGP1		33	/* IRQ33 摜O 荞ݗv1 */
#define	AG903_IRQ34_PGP2		34	/* IRQ34 摜O 荞ݗv2 */
#define	AG903_IRQ35_PGP3		35	/* IRQ35 摜O 荞ݗv3 */
#define	AG903_IRQ36_PGP4		36	/* IRQ36 摜O 荞ݗv4 */
#define	AG903_IRQ37_PGP5		37	/* IRQ37 摜O 荞ݗv5 */
#define	AG903_IRQ38_PGP6		38	/* IRQ38 摜O 荞ݗv6 */
#define	AG903_IRQ39_PGP7		39	/* IRQ39 摜O 荞ݗv7 */
#define	AG903_IRQ40_GPIO0		40	/* IRQ40 GPIO0 */
#define	AG903_IRQ41_GPIO1		41	/* IRQ41 GPIO1 */
#define	AG903_IRQ42_GPIO2		42	/* IRQ42 GPIO2 */
#define	AG903_IRQ43_GPIO3		43	/* IRQ43 GPIO3 */
#define	AG903_IRQ44_IIC0		44	/* IRQ44 IIC0 */
#define	AG903_IRQ45_IIC1		45	/* IRQ45 IIC1 */
#define	AG903_IRQ46_CFC			46	/* IRQ46 CFRg[ */
#define	AG903_IRQ47_ATA			47	/* IRQ47 ATARg[ */
#define	AG903_IRQ48_SPI			48	/* IRQ48 SPI-ROMRg[ */
#define	AG903_IRQ49_ETH			49	/* IRQ49 C[Tlbg */
#define AG903_IRQ50_USB			50	/* IRQ50 USB */
#define AG903_IRQ51_SDC			51	/* IRQ51 SDRg[ */
#define AG903_IRQ52_PBH0		52	/* IRQ52 pI/F(zXg[h) 荞ݗv0 */
#define AG903_IRQ53_PBH1		53	/* IRQ53 pI/F(zXg[h) 荞ݗv1 */
#define AG903_IRQ54_PBH2		54	/* IRQ54 pI/F(zXg[h) 荞ݗv2 */
#define AG903_IRQ55_PBH3		55	/* IRQ55 pI/F(zXg[h) 荞ݗv3 */
#define AG903_IRQ56_PBD			56	/* IRQ56 pI/F(foCX[h) */
/* IRQ57 RESERVED \ */
#define AG903_IRQ58_DMACERR		58	/* IRQ58 DMARg[ G[ */
#define AG903_IRQ59_DMACTC		59	/* IRQ59 DMARg[ ^[~iJEg */
#define AG903_IRQ60_CA5PMU		60	/* IRQ60 Cortex-A5 CPU PMU */
#define AG903_IRQ61_L2C			61	/* IRQ61 L2LbV */
#define AG903_IRQ62_DDR			62	/* IRQ62 DRAM*/
#define AG903_IRQ63_IXB			63	/* IRQ63 oX荞*/

#ifdef __cplusplus
}
#endif
#endif /* _AG903_INTNO_H */
