/**
 * @brief           EBI Register Definition
 * @author          AXELL CORPORATION
 * @description     EBI Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_EBI_REGMAP_H_
#define _AG903_EBI_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** EBI Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __I  uint32_t  Version;
    };

    __I  uint32_t  RESERVED1[11];

    union {
        __IO uint32_t  Control;

        struct {
            __IO uint32_t  mgsel                          :  8;
            __IO uint32_t  gtc_en                         :  8;
                 uint32_t                                 :  8;
            __IO uint32_t  arb_mode                       :  1;
            __IO uint32_t  intturn_en                     :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  m0phs_en                       :  1;
        } Control_bits;
    };

    __I  uint32_t  RESERVED2[3];

    union {
        __IO uint32_t  Grant_Unit;

        struct {
            __IO uint32_t  gwnuit                         :  8;
        } Grant_Unit_bits;
    };

    union {
        __IO uint32_t  Grant_Size1;

        struct {
            __IO uint32_t  m0gw                           :  8;
            __IO uint32_t  m1gw                           :  8;
            __IO uint32_t  m2gw                           :  8;
            __IO uint32_t  m3gw                           :  8;
        } Grant_Size1_bits;
    };

    union {
        __IO uint32_t  Grant_Size2;

        struct {
            __IO uint32_t  m4gw                           :  8;
            __IO uint32_t  m5gw                           :  8;
            __IO uint32_t  m6gw                           :  8;
            __IO uint32_t  m7gw                           :  8;
        } Grant_Size2_bits;
    };

    union {
        __IO uint32_t  Sync_Mode;

        struct {
            __IO uint32_t  Sync_Req                       :  8;
        } Sync_Mode_bits;
    };

/* DOM-IGNORE-END */
}AG903_EBI_Type;

#define AG903_EBI                                ((volatile AG903_EBI_Type *) AG903_EBI_BASE)                            /** EBI Base Address */


#define AG903_EBI_Version_Version_number_POS               0                                                             /** EBIVersion Version_number-bit position */
#define AG903_EBI_Version_Version_number_MSK               (0xffffffffUL << AG903_EBI_Version_Version_number_POS)        /** EBIVersion Version_number-bit mask */

#define AG903_EBI_Control_mgsel_POS                        0                                                             /** EBIControl mgsel-bit position */
#define AG903_EBI_Control_mgsel_MSK                        (0xffUL << AG903_EBI_Control_mgsel_POS)                       /** EBIControl mgsel-bit mask */
#define AG903_EBI_Control_gtc_en_POS                       8                                                             /** EBIControl gtc_en-bit position */
#define AG903_EBI_Control_gtc_en_MSK                       (0xffUL << AG903_EBI_Control_gtc_en_POS)                      /** EBIControl gtc_en-bit mask */
#define AG903_EBI_Control_arb_mode_POS                     24                                                            /** EBIControl arb_mode-bit position */
#define AG903_EBI_Control_arb_mode_MSK                     (0x1UL << AG903_EBI_Control_arb_mode_POS)                     /** EBIControl arb_mode-bit mask */
#define AG903_EBI_Control_intturn_en_POS                   25                                                            /** EBIControl intturn_en-bit position */
#define AG903_EBI_Control_intturn_en_MSK                   (0x1UL << AG903_EBI_Control_intturn_en_POS)                   /** EBIControl intturn_en-bit mask */
#define AG903_EBI_Control_m0phs_en_POS                     28                                                            /** EBIControl m0phs_en-bit position */
#define AG903_EBI_Control_m0phs_en_MSK                     (0x1UL << AG903_EBI_Control_m0phs_en_POS)                     /** EBIControl m0phs_en-bit mask */

#define AG903_EBI_Grant_Unit_gwnuit_POS                    0                                                             /** EBIGrant_Unit gwnuit-bit position */
#define AG903_EBI_Grant_Unit_gwnuit_MSK                    (0xffUL << AG903_EBI_Grant_Unit_gwnuit_POS)                   /** EBIGrant_Unit gwnuit-bit mask */

#define AG903_EBI_Grant_Size1_m0gw_POS                     0                                                             /** EBIGrant_Size1 m0gw-bit position */
#define AG903_EBI_Grant_Size1_m0gw_MSK                     (0xffUL << AG903_EBI_Grant_Size1_m0gw_POS)                    /** EBIGrant_Size1 m0gw-bit mask */
#define AG903_EBI_Grant_Size1_m1gw_POS                     8                                                             /** EBIGrant_Size1 m1gw-bit position */
#define AG903_EBI_Grant_Size1_m1gw_MSK                     (0xffUL << AG903_EBI_Grant_Size1_m1gw_POS)                    /** EBIGrant_Size1 m1gw-bit mask */
#define AG903_EBI_Grant_Size1_m2gw_POS                     16                                                            /** EBIGrant_Size1 m2gw-bit position */
#define AG903_EBI_Grant_Size1_m2gw_MSK                     (0xffUL << AG903_EBI_Grant_Size1_m2gw_POS)                    /** EBIGrant_Size1 m2gw-bit mask */
#define AG903_EBI_Grant_Size1_m3gw_POS                     24                                                            /** EBIGrant_Size1 m3gw-bit position */
#define AG903_EBI_Grant_Size1_m3gw_MSK                     (0xffUL << AG903_EBI_Grant_Size1_m3gw_POS)                    /** EBIGrant_Size1 m3gw-bit mask */

#define AG903_EBI_Grant_Size2_m4gw_POS                     0                                                             /** EBIGrant_Size2 m4gw-bit position */
#define AG903_EBI_Grant_Size2_m4gw_MSK                     (0xffUL << AG903_EBI_Grant_Size2_m4gw_POS)                    /** EBIGrant_Size2 m4gw-bit mask */
#define AG903_EBI_Grant_Size2_m5gw_POS                     8                                                             /** EBIGrant_Size2 m5gw-bit position */
#define AG903_EBI_Grant_Size2_m5gw_MSK                     (0xffUL << AG903_EBI_Grant_Size2_m5gw_POS)                    /** EBIGrant_Size2 m5gw-bit mask */
#define AG903_EBI_Grant_Size2_m6gw_POS                     16                                                            /** EBIGrant_Size2 m6gw-bit position */
#define AG903_EBI_Grant_Size2_m6gw_MSK                     (0xffUL << AG903_EBI_Grant_Size2_m6gw_POS)                    /** EBIGrant_Size2 m6gw-bit mask */
#define AG903_EBI_Grant_Size2_m7gw_POS                     24                                                            /** EBIGrant_Size2 m7gw-bit position */
#define AG903_EBI_Grant_Size2_m7gw_MSK                     (0xffUL << AG903_EBI_Grant_Size2_m7gw_POS)                    /** EBIGrant_Size2 m7gw-bit mask */

#define AG903_EBI_Sync_Mode_Sync_Req_POS                   0                                                             /** EBISync_Mode Sync_Req-bit position */
#define AG903_EBI_Sync_Mode_Sync_Req_MSK                   (0xffUL << AG903_EBI_Sync_Mode_Sync_Req_POS)                  /** EBISync_Mode Sync_Req-bit mask */

#endif /* _AG903_EBI_REGMAP_H_ */

