/**
 * @brief           GVD API parameter Header
 * @author          AXELL CORPORATION
 * @description     GVD API֘Af[^^`
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */

#ifndef GVD_API_PARAMS_H
#define GVD_API_PARAMS_H
/* DOM-IGNORE-END */

#include <stdint.h>
#include <stddef.h>

#include "gvd_error.h"

#ifndef GVD_MAX_ENUM
/** eunmsentinell (INT_MAX) */
#define GVD_MAX_ENUM 0x7FFFFFFF
#endif


typedef int32_t (* gvdCbFunc)(void *, void *, gvdError);	/** R[obN֐^ */

/** Xg[擪̃f[^܂ */
#define GVD_BUFFLAG_START (1 << 0)

/** Xg[̃f[^܂ */
#define GVD_BUFFLAG_END   (1 << 1)

/** ̓obt@
 *  <p>̓obt@͔LbV̈ɔzuKv܂. */
typedef struct {
	void		*buffer;			/** ̓obt@̃AhX<p>4oCgEɔzuĂ. */
	int32_t		size_buffer;		/** ̓obt@̃TCY */
	int32_t		offset_data;		/** buffer̓f[^擪܂ł̃ItZbg */
	int32_t		size_data;			/** ̓f[^̃TCY */
	int32_t		seekid;				/** V[NID<p>0ƂĂ. */
	uint32_t	timestamp;			/** ^CX^v[ms]<p>0ƂĂ. */
	uint32_t	flags;				/** f[^擪EtO */
} gvdInBufInfo;

/** o̓obt@
 * <p>o̓obt@͔LbV̈ɔzuKv܂. */
typedef struct {
	void		*buffer;			/** o̓obt@̃AhX<p>2048oCgEɔzuĂ. */
	int32_t		size_buffer;		/** o̓obt@̃TCY */
	int32_t		width;				/** t[̕<p>64pxPʂɐ؂グĂ. */
	int32_t		height;				/** t[̍<p>32pxPʂɐ؂グĂ. */
} gvdOutBufInfo;

/** t[ */
typedef struct {
	void		*buffer;			/** obt@̃AhX */
	int32_t		size_filled;		/** obt@ɏ܂ꂽf[^̃TCY */
	int32_t		size_buffer;		/** obt@̃TCY */
	int32_t		timestamp;			/** ^CX^v[ms] */
	int32_t		seekid;				/** V[NID */
	uint32_t	frame_count;		/** t[ԍ */
	uint32_t	flags;				/** JnEIt[tO */
} gvdFrameInfo;

/** ԋpobt@ */
typedef struct {
	void		*buffer;			/** obt@̃AhX */
	int32_t		size;				/** obt@̃TCY */
} gvdDiscardBufInfo;

/** t[TCY */
typedef struct {
	int32_t		width;				/** t[̕ */
	int32_t		height;				/** t[̍ */
	int32_t		buf_count;			/** fR[_obt@̍ŒKvȖ */
	size_t		buf_size;			/** fR[_obt@̒PʃTCY */
} gvdFrameSize;

typedef uint64_t gvdStreamPosition;	/** Xg[ʒu */

/** fR[hG[ */
typedef struct {
	gvdError			error;			/** G[R[h */
	gvdStreamPosition	pos;			/** Xg[ʒu */
	int32_t				seekid;			/** V[NID */
	uint32_t			frame_count;	/** t[ԍ */
} gvdDecError;

/** ^CX^v */
typedef struct {
	uint32_t	timestamp_ms;		/** ^CX^v[ms] */
	uint32_t	frame_id;			/** t[ԍ */
	uint32_t	index;				/** ʒuindex */
} gvdTimeStamp;

/** V[Nʏ */
typedef enum {
	GVD_SEEK_BUFINDEX_ABSOLUTE,			/** ʒuobt@indexΒlw */
	GVD_SEEK_BUFINDEX_RELATIVE,			/** ʒuobt@indexΒlw */
	GVD_SEEK_IMMEDIATE,					/** SeekʒuIMMEDIATEw */
	GVD_SEEK_FORCE_SIZE = GVD_MAX_ENUM	/** sentinel */
} gvdSeekType;

/** V[Nݒ */
typedef struct {
	gvdSeekType	type;				/** Seek */
	int32_t		index_offset;		/** ʒuIndex̃ItZbg */
	uint32_t	immediate_frame;	/** IMMEDIATẼt[ID */
	uint32_t	immediate_byte;		/** IMMEDIATESeekoCg */
} gvdSeekParam;

/** ʒu擾ʏ */
typedef enum {
	GVD_SEEKPOS_SUCCESS,					/** ʒu̎擾ɐ */
	GVD_SEEKPOS_ERROR,						/** ʒu̎擾Ɏs */
	GVD_SEEKPOS_FORCE_SIZE = GVD_MAX_ENUM	/** sentinel */
} gvdSeekPosResult;

/** V[Nʒu */
typedef struct {
	uint32_t			index;		/** ʒuobt@index */
	uint32_t			frame_id;	/** t[ID */
	uint32_t			stream_pos;	/** Xg[ʒu */
	gvdSeekPosResult	result;		/** ʒu擾 */
} gvdSeekPosInfo;

/**
 * @brief           GVDݒ
 * @description     Streamer1ReadTCY͉ŋ߂܂.<p>
 *                  size = (stream_buf_size / (stream_buf_num * stream_num))
 */
typedef struct {
	gvdCbFunc	func_notify_fatalerror;		/** FatalErrorpR[obN֐ */
	void		*param_notify_fatalerror;	/** FatalErrorpR[obN֐ɗ^p[^ */
	uint32_t	vramaddr_mask;				/** VRAM̃AhX}XN */
	uint32_t	bmuaddr_mask;				/** BMŨAhX}XN */
	uint32_t	stream_buf_size;			/** Streamobt@TCY[TCY] */
	uint32_t	stream_buf_num;				/** Streamobt@[1Stream̃obt@] */
	uint32_t	stream_num;					/** Stream */
} gvdInitializeParam;

/** ʒuobt@ */
typedef struct {
	uint32_t	frame_id;			/** t[ԍ */
	uint32_t	stream_pos;			/** Xg[ʒu */
} gvdPositionBuffer;

#endif /* GVD_API_PARAMS_H */
