/**
 * @brief       VRAM Manager
 * @author      AXELL CORPORATION
 * @description VRAM Manager Layer
 * @note        none
 * @history     2017_02_22  
 * @history     2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017-2019 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_errno.h"
#include "vram/vrammgr.h"



/**
 * @brief           VRAM}l[WǗVRAM̈̏
 * @param           vramtop [in] VRAM̈JnAhX
 * @param           vramsize [in] VRAM̈TCY
 * @return          VRAM̈揉
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @description     VRAM}l[WǗVRAM̈̃AhXϊe[u܂B
 * @note
 * - VRAM}l[Wɂ郁v[̐͂ŏ̈ł̂݉\ł
 * - ̊֐MMUƃAhXϊe[uꂽA
VRAM}l[W̑̊֐sOɈxsĉ
iAG903_OSWprInitMemory Ăяo܂jB
 * - VRAM̈̊JnAhXƃTCY1MBPʂŎw肵ĉB <p>
 * - VRAM̈̈ꕔ͊Ǘ̂߂Ɏgp܂B
*/
int32_t AG903_VRAMMgrInit(uintptr_t vramtop, uint32_t vramsize)
{
	int32_t retval;
	retval = AG903_OSWprInitMemory(vramtop, vramsize);
	return retval;
}

/**
 * @brief           ϒv[
 * @param           mplprm [in] v[
 * @return          ϒv[
 * @retval          v[IDԍ  I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @retval          -AG903_EFAULT  s(s)
 * @retval          -AG903_ENOID   ID
 * @retval          -AG903_ESYS    VXeG[(zOG[)
 * @description     ϒv[𐶐܂B
 *                  iAG903_OSWprCreMplAuto Ăяo܂Bj
*/
int32_t AG903_VRAMMgrCreateMpl(AG903_VRAMMgrMplPrm* mplprm)
{
	int32_t retval;
	retval = AG903_OSWprCreMplAuto((AG903_OSWCMpl*)mplprm);
	return retval;
}

/**
 * @brief           ϒv[(IDw)
 * @param           mplid [in] v[ID
 * @param           mplprm [in] v[
 * @return          ϒv[(IDw)
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @retval          -AG903_EFAULT  s(s)
 * @retval          -AG903_EEXIST  ɐς
 * @retval          -AG903_ESYS    VXeG[(zOG[)
 * @description     ϒv[IDwŐ܂B
 *                  iAG903_OSWprCreMpl Ăяo܂Bj
*/
int32_t AG903_VRAMMgrCreateMplFixedId(int32_t mplid, AG903_VRAMMgrMplPrm* mplprm)
{
	int32_t retval;
	retval = AG903_OSWprCreMpl(mplid, (AG903_OSWCMpl*)mplprm);
	return retval;
}

/**
 * @brief           ϒv[폜
 * @param           mplid [in] v[IDԍ
 * @return          ϒv[폜
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     ϒv[폜܂B
 *                  iAG903_OSWprDelMpl Ăяo܂Bj
*/
int32_t AG903_VRAMMgrDeleteMpl(int32_t mplid)
{
	int32_t retval;
	retval = AG903_OSWprDelMpl(mplid);
	return retval;
}

/**
 * @brief           ϒl
 * @param           mplid [in] v[IDԍ
 * @param           blksz [in] ubNTCY(oCg)
 * @return          ϒl
 * @retval          lubNւ̃|C^ NULL:ls
 * @description     ϒl܂B
 *                  iAG903_OSWprGetMpl Ăяo܂Bj
*/
void* AG903_VRAMMgrMalloc(int32_t mplid, uint32_t blksz)
{
	int32_t result;
	void*	p_blk;
	
	result = AG903_OSWprGetMpl(mplid, blksz, &p_blk);
	if(AG903_ENONE != result) {
		p_blk = NULL;
	}

	return p_blk;
}

/**
 * @brief           ϒl (Align)
 * @param           mplid [in] v[IDԍ
 * @param           align [in] ACTCY(oCg)
 * @param           blksz [in] ubNTCY(oCg)
 * @return          ϒl (Align)
 * @retval          lubNւ̃|C^ NULL:ls
 * @description     ϒ(Alignw)l܂B
 *                  iAG903_OSWprGetMplAlign Ăяo܂Bj
*/
void* AG903_VRAMMgrMallocAlign(int32_t mplid, uint32_t align, uint32_t blksz)
{
	int32_t result;
	void*	p_blk;
	
	result = AG903_OSWprGetMplAlign(mplid, align, blksz, &p_blk);
	if(AG903_ENONE != result) {
		p_blk = NULL;
	}

	return p_blk;
}

/**
 * @brief           ϒԋp
 * @param           mplid [in] v[ID
 * @param           blk [in] ubNւ̃|C^
 * @return          ϒԋp
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     ϒԋp܂B
 *                  iAG903_OSWprRelMpl Ăяo܂Bj
 */
int32_t AG903_VRAMMgrFree(int32_t mplid, void* blk)
{
	int32_t retval;
	retval = AG903_OSWprRelMpl(mplid, blk);
	return retval;
}

/**
 * @brief           ϒv[̏ԎQ
 * @param           mplid [in] v[ID
 * @param           mplsta [out] ԏԋpAhX
 * @return          ϒv[̏ԎQƌ
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     ϒv[̏ԂQƂ܂B
 *                  iAG903_OSWprRefMpl Ăяo܂Bj
*/
int32_t AG903_VRAMMgrMrefer(int32_t mplid, AG903_VRAMMgrMplStat* mplsta)
{
	int32_t retval;
	retval = AG903_OSWprRefMpl(mplid, (AG903_OSWRMpl*)mplsta);
	return retval;
}

/**
 * @brief           Œ蒷v[
 * @param           mpfprm [in] v[
 * @return          Œ蒷v[
 * @retval          v[IDԍ
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @retval          -AG903_EFAULT  s(s)
 * @retval          -AG903_ENOID  ID
 * @retval          -AG903_ESYS    VXeG[(zOG[)
 * @description     Œ蒷v[𐶐܂B
 *                  iAG903_OSWprCreMpfAuto Ăяo܂Bj
*/
int32_t AG903_VRAMMgrCreateMpf(AG903_VRAMMgrMpfPrm* mpfprm)
{
	int32_t retval;
	retval = AG903_OSWprCreMpfAuto((AG903_OSWCMpf*)mpfprm);
	return retval;
}


/**
 * @brief           Œ蒷v[(IDw)
 * @param           mplid [in] v[ID
 * @param           mpfprm [in] v[
 * @return          Œ蒷v[(IDw)
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @retval          -AG903_EFAULT  s(s)
 * @retval          -AG903_EEXIST  ɐς
 * @retval          -AG903_ESYS    VXeG[(zOG[)
 * @description     Œ蒷v[IDwŐ܂B
 *                  iAG903_OSWprCreMpf Ăяo܂Bj
*/
int32_t AG903_VRAMMgrCreateMpfFixedId(int32_t mplid, AG903_VRAMMgrMpfPrm* mpfprm)
{
	int32_t retval;
	retval = AG903_OSWprCreMpf(mplid, (AG903_OSWCMpf*)mpfprm);
	return retval;
}

/**
 * @brief           Œ蒷v[폜
 * @param           mplid [in] v[IDԍ
 * @return          Œ蒷v[폜
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     Œ蒷v[폜܂B
 *                  iAG903_OSWprDelMpf Ăяo܂Bj
*/
int32_t AG903_VRAMMgrDeleteMpf(int32_t mplid)
{
	int32_t retval;
	retval = AG903_OSWprDelMpf(mplid);
	return retval;
}

/**
 * @brief           Œ蒷li|[Oj
 * @param           mplid [in] v[ID
 * @return          Œ蒷li|[Oj
 * @retval          ubNւ̃|C^ NULL:ls
 * @description     Œ蒷li|[Oj܂B
 *                  iAG903_OSWprGetMpf Ăяo܂Bj
*/
void* AG903_VRAMMgrFmalloc(int32_t mplid)
{
	int32_t result;
	void*	p_blk;
	
	result = AG903_OSWprGetMpf(mplid, &p_blk);
	if(AG903_ENONE != result) {
		p_blk = NULL;
	}

	return p_blk;
}

/**
 * @brief           Œ蒷ԋp
 * @param           mplid [in] v[ID
 * @param           blk [in] ubNւ̃|C^
 * @return          Œ蒷ԋp
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     Œ蒷ԋp܂B
 *                  iAG903_OSWprRelMpf Ăяo܂Bj
*/
int32_t AG903_VRAMMgrFmfree(int32_t mplid, void* blk)
{
	int32_t retval;
	retval = AG903_OSWprRelMpf(mplid, blk);
	return retval;
}

/**
 * @brief           Œ蒷v[̏ԎQ
 * @param           mplid [in] v[ID
 * @param           mplsta [out] ԏԋpAhX
 * @return          Œ蒷v[̏ԎQƌ
 * @retval          AG903_ENONE    I
 * @retval          -AG903_EINVAL  ُ
 * @retval          -AG903_EPERM   sgp(荞݂CALLȂ)
 * @description     Œ蒷v[̏ԂQƂ܂B
 *                  iAG903_OSWprRefMpf Ăяo܂Bj
*/
int32_t AG903_VRAMMgrFmrefer(int32_t mplid, AG903_VRAMMgrMpfStat* mplsta)
{
	int32_t retval;
	retval = AG903_OSWprRefMpf(mplid, (AG903_OSWRMpf*)mplsta);
	return retval;
}

