/**
 * @brief           CFC Register Definition
 * @author          AXELL CORPORATION
 * @description     CFC Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_CFC_REGMAP_H_
#define _AG903_CFC_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** CFC Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  Host_Status;

        struct {
            __I  uint32_t  IREQ                           :  1;
            __I  uint32_t  CD                             :  1;
            __I  uint32_t  VS1                            :  1;
            __I  uint32_t  VS2                            :  1;
            __I  uint32_t  STSCHG                         :  1;
            __I  uint32_t  SPKR                           :  1;
                 uint32_t                                 :  2;
            __I  uint32_t  buffer_active                  :  1;
            __I  uint32_t  buffer_data_ready              :  1;
            __I  uint32_t  cfc_int_data_cmp_r             :  1;
                 uint32_t                                 :  1;
            __I  uint32_t  buffer_size                    :  4;
            __IO uint32_t  cfc_int_cd_r                   :  1;
            __IO uint32_t  cfc_io_int_r                   :  1;
        } Host_Status_bits;
    };

    union {
        __IO uint32_t  Host_Control;

        struct {
            __IO uint32_t  Power_Control                  :  4;
            __IO uint32_t  Float_Control                  :  1;
            __IO uint32_t  Reset                          :  1;
            __IO uint32_t  Mode_8bit                      :  1;
                 uint32_t                                 :  1;
            __IO uint32_t  Mode_DMA                       :  1;
            __IO uint32_t  card_detect_int_mask           :  1;
            __IO uint32_t  cfc_int_data_cmp_mask          :  1;
            __IO uint32_t  cfc_io_int_mask                :  1;
        } Host_Control_bits;
    };

    union {
        __IO uint32_t  Access_Timing;

        struct {
            __IO uint32_t  BSA                            :  4;
            __IO uint32_t  BSM                            :  4;
            __IO uint32_t  BSIO                           :  4;
            __IO uint32_t  BSMOW                          :  2;
            __IO uint32_t  BSIORW                         :  2;
        } Access_Timing_bits;
    };

    union {
        __IO uint32_t  Active_Buffer_Controller;

        struct {
            __IO uint32_t  ADR                            : 11;
                 uint32_t                                 :  1;
            __IO uint32_t  TYPE                           :  2;
            __IO uint32_t  INCADR                         :  1;
            __IO uint32_t  RW                             :  1;
            __IO uint32_t  SIZE                           :  4;
        } Active_Buffer_Controller_bits;
    };

    union {
        __IO uint32_t  Active_Buffer_Data;
    };

    union {
        __IO uint32_t  Multi_Sector;

        struct {
            __IO uint32_t  Enable                         :  1;
            __IO uint32_t  Timeup                         :  7;
        } Multi_Sector_bits;
    };

    union {
        __IO uint32_t  Mode2_Enable;

        struct {
            __IO uint32_t  Enable                         :  1;
        } Mode2_Enable_bits;
    };

    union {
        __IO uint32_t  Mode2_Counter;

        struct {
            __IO uint32_t  Cnt                            : 17;
        } Mode2_Counter_bits;
    };

    __I  uint32_t  RESERVED1[4];

    union {
        __I  uint32_t  REVISION;
    };

    union {
        __I  uint32_t  FEATURE;

        struct {
            __I  uint32_t  BUFSIZE                        :  4;
            __I  uint32_t  SBI                            :  1;
        } FEATURE_bits;
    };

/* DOM-IGNORE-END */
}AG903_CFC_Type;

#define AG903_CFC                                ((volatile AG903_CFC_Type *) AG903_CFC_BASE)                            /** CFC Base Address */


#define AG903_CFC_Host_Status_IREQ_POS                     0                                                             /** CFCHost_Status IREQ-bit position */
#define AG903_CFC_Host_Status_IREQ_MSK                     (0x1UL << AG903_CFC_Host_Status_IREQ_POS)                     /** CFCHost_Status IREQ-bit mask */
#define AG903_CFC_Host_Status_CD_POS                       1                                                             /** CFCHost_Status CD-bit position */
#define AG903_CFC_Host_Status_CD_MSK                       (0x1UL << AG903_CFC_Host_Status_CD_POS)                       /** CFCHost_Status CD-bit mask */
#define AG903_CFC_Host_Status_VS1_POS                      2                                                             /** CFCHost_Status VS1-bit position */
#define AG903_CFC_Host_Status_VS1_MSK                      (0x1UL << AG903_CFC_Host_Status_VS1_POS)                      /** CFCHost_Status VS1-bit mask */
#define AG903_CFC_Host_Status_VS2_POS                      3                                                             /** CFCHost_Status VS2-bit position */
#define AG903_CFC_Host_Status_VS2_MSK                      (0x1UL << AG903_CFC_Host_Status_VS2_POS)                      /** CFCHost_Status VS2-bit mask */
#define AG903_CFC_Host_Status_STSCHG_POS                   4                                                             /** CFCHost_Status STSCHG-bit position */
#define AG903_CFC_Host_Status_STSCHG_MSK                   (0x1UL << AG903_CFC_Host_Status_STSCHG_POS)                   /** CFCHost_Status STSCHG-bit mask */
#define AG903_CFC_Host_Status_SPKR_POS                     5                                                             /** CFCHost_Status SPKR-bit position */
#define AG903_CFC_Host_Status_SPKR_MSK                     (0x1UL << AG903_CFC_Host_Status_SPKR_POS)                     /** CFCHost_Status SPKR-bit mask */
#define AG903_CFC_Host_Status_buffer_active_POS            8                                                             /** CFCHost_Status buffer_active-bit position */
#define AG903_CFC_Host_Status_buffer_active_MSK            (0x1UL << AG903_CFC_Host_Status_buffer_active_POS)            /** CFCHost_Status buffer_active-bit mask */
#define AG903_CFC_Host_Status_buffer_data_ready_POS        9                                                             /** CFCHost_Status buffer_data_ready-bit position */
#define AG903_CFC_Host_Status_buffer_data_ready_MSK        (0x1UL << AG903_CFC_Host_Status_buffer_data_ready_POS)        /** CFCHost_Status buffer_data_ready-bit mask */
#define AG903_CFC_Host_Status_cfc_int_data_cmp_r_POS       10                                                            /** CFCHost_Status cfc_int_data_cmp_r-bit position */
#define AG903_CFC_Host_Status_cfc_int_data_cmp_r_MSK       (0x1UL << AG903_CFC_Host_Status_cfc_int_data_cmp_r_POS)       /** CFCHost_Status cfc_int_data_cmp_r-bit mask */
#define AG903_CFC_Host_Status_buffer_size_POS              12                                                            /** CFCHost_Status buffer_size-bit position */
#define AG903_CFC_Host_Status_buffer_size_MSK              (0xfUL << AG903_CFC_Host_Status_buffer_size_POS)              /** CFCHost_Status buffer_size-bit mask */
#define AG903_CFC_Host_Status_cfc_int_cd_r_POS             16                                                            /** CFCHost_Status cfc_int_cd_r-bit position */
#define AG903_CFC_Host_Status_cfc_int_cd_r_MSK             (0x1UL << AG903_CFC_Host_Status_cfc_int_cd_r_POS)             /** CFCHost_Status cfc_int_cd_r-bit mask */
#define AG903_CFC_Host_Status_cfc_io_int_r_POS             17                                                            /** CFCHost_Status cfc_io_int_r-bit position */
#define AG903_CFC_Host_Status_cfc_io_int_r_MSK             (0x1UL << AG903_CFC_Host_Status_cfc_io_int_r_POS)             /** CFCHost_Status cfc_io_int_r-bit mask */

#define AG903_CFC_Host_Control_Power_Control_POS           0                                                             /** CFCHost_Control Power_Control-bit position */
#define AG903_CFC_Host_Control_Power_Control_MSK           (0xfUL << AG903_CFC_Host_Control_Power_Control_POS)           /** CFCHost_Control Power_Control-bit mask */
#define AG903_CFC_Host_Control_Float_Control_POS           4                                                             /** CFCHost_Control Float_Control-bit position */
#define AG903_CFC_Host_Control_Float_Control_MSK           (0x1UL << AG903_CFC_Host_Control_Float_Control_POS)           /** CFCHost_Control Float_Control-bit mask */
#define AG903_CFC_Host_Control_Reset_POS                   5                                                             /** CFCHost_Control Reset-bit position */
#define AG903_CFC_Host_Control_Reset_MSK                   (0x1UL << AG903_CFC_Host_Control_Reset_POS)                   /** CFCHost_Control Reset-bit mask */
#define AG903_CFC_Host_Control_Mode_8bit_POS               6                                                             /** CFCHost_Control Mode_8bit-bit position */
#define AG903_CFC_Host_Control_Mode_8bit_MSK               (0x1UL << AG903_CFC_Host_Control_Mode_8bit_POS)               /** CFCHost_Control Mode_8bit-bit mask */
#define AG903_CFC_Host_Control_Mode_DMA_POS                8                                                             /** CFCHost_Control Mode_DMA-bit position */
#define AG903_CFC_Host_Control_Mode_DMA_MSK                (0x1UL << AG903_CFC_Host_Control_Mode_DMA_POS)                /** CFCHost_Control Mode_DMA-bit mask */
#define AG903_CFC_Host_Control_card_detect_int_mask_POS    9                                                             /** CFCHost_Control card_detect_int_mask-bit position */
#define AG903_CFC_Host_Control_card_detect_int_mask_MSK    (0x1UL << AG903_CFC_Host_Control_card_detect_int_mask_POS)    /** CFCHost_Control card_detect_int_mask-bit mask */
#define AG903_CFC_Host_Control_cfc_int_data_cmp_mask_POS   10                                                            /** CFCHost_Control cfc_int_data_cmp_mask-bit position */
#define AG903_CFC_Host_Control_cfc_int_data_cmp_mask_MSK   (0x1UL << AG903_CFC_Host_Control_cfc_int_data_cmp_mask_POS)   /** CFCHost_Control cfc_int_data_cmp_mask-bit mask */
#define AG903_CFC_Host_Control_cfc_io_int_mask_POS         11                                                            /** CFCHost_Control cfc_io_int_mask-bit position */
#define AG903_CFC_Host_Control_cfc_io_int_mask_MSK         (0x1UL << AG903_CFC_Host_Control_cfc_io_int_mask_POS)         /** CFCHost_Control cfc_io_int_mask-bit mask */

#define AG903_CFC_Access_Timing_BSA_POS                    0                                                             /** CFCAccess_Timing BSA-bit position */
#define AG903_CFC_Access_Timing_BSA_MSK                    (0xfUL << AG903_CFC_Access_Timing_BSA_POS)                    /** CFCAccess_Timing BSA-bit mask */
#define AG903_CFC_Access_Timing_BSM_POS                    4                                                             /** CFCAccess_Timing BSM-bit position */
#define AG903_CFC_Access_Timing_BSM_MSK                    (0xfUL << AG903_CFC_Access_Timing_BSM_POS)                    /** CFCAccess_Timing BSM-bit mask */
#define AG903_CFC_Access_Timing_BSIO_POS                   8                                                             /** CFCAccess_Timing BSIO-bit position */
#define AG903_CFC_Access_Timing_BSIO_MSK                   (0xfUL << AG903_CFC_Access_Timing_BSIO_POS)                   /** CFCAccess_Timing BSIO-bit mask */
#define AG903_CFC_Access_Timing_BSMOW_POS                  12                                                            /** CFCAccess_Timing BSMOW-bit position */
#define AG903_CFC_Access_Timing_BSMOW_MSK                  (0x3UL << AG903_CFC_Access_Timing_BSMOW_POS)                  /** CFCAccess_Timing BSMOW-bit mask */
#define AG903_CFC_Access_Timing_BSIORW_POS                 14                                                            /** CFCAccess_Timing BSIORW-bit position */
#define AG903_CFC_Access_Timing_BSIORW_MSK                 (0x3UL << AG903_CFC_Access_Timing_BSIORW_POS)                 /** CFCAccess_Timing BSIORW-bit mask */

#define AG903_CFC_Active_Buffer_Controller_ADR_POS         0                                                             /** CFCActive_Buffer_Controller ADR-bit position */
#define AG903_CFC_Active_Buffer_Controller_ADR_MSK         (0x7ffUL << AG903_CFC_Active_Buffer_Controller_ADR_POS)       /** CFCActive_Buffer_Controller ADR-bit mask */
#define AG903_CFC_Active_Buffer_Controller_TYPE_POS        12                                                            /** CFCActive_Buffer_Controller TYPE-bit position */
#define AG903_CFC_Active_Buffer_Controller_TYPE_MSK        (0x3UL << AG903_CFC_Active_Buffer_Controller_TYPE_POS)        /** CFCActive_Buffer_Controller TYPE-bit mask */
#define AG903_CFC_Active_Buffer_Controller_INCADR_POS      14                                                            /** CFCActive_Buffer_Controller INCADR-bit position */
#define AG903_CFC_Active_Buffer_Controller_INCADR_MSK      (0x1UL << AG903_CFC_Active_Buffer_Controller_INCADR_POS)      /** CFCActive_Buffer_Controller INCADR-bit mask */
#define AG903_CFC_Active_Buffer_Controller_RW_POS          15                                                            /** CFCActive_Buffer_Controller RW-bit position */
#define AG903_CFC_Active_Buffer_Controller_RW_MSK          (0x1UL << AG903_CFC_Active_Buffer_Controller_RW_POS)          /** CFCActive_Buffer_Controller RW-bit mask */
#define AG903_CFC_Active_Buffer_Controller_SIZE_POS        16                                                            /** CFCActive_Buffer_Controller SIZE-bit position */
#define AG903_CFC_Active_Buffer_Controller_SIZE_MSK        (0xfUL << AG903_CFC_Active_Buffer_Controller_SIZE_POS)        /** CFCActive_Buffer_Controller SIZE-bit mask */

#define AG903_CFC_Active_Buffer_Data_Data_POS              0                                                             /** CFCActive_Buffer_Data Data-bit position */
#define AG903_CFC_Active_Buffer_Data_Data_MSK              (0xffffffffUL << AG903_CFC_Active_Buffer_Data_Data_POS)       /** CFCActive_Buffer_Data Data-bit mask */

#define AG903_CFC_Multi_Sector_Enable_POS                  0                                                             /** CFCMulti_Sector Enable-bit position */
#define AG903_CFC_Multi_Sector_Enable_MSK                  (0x1UL << AG903_CFC_Multi_Sector_Enable_POS)                  /** CFCMulti_Sector Enable-bit mask */
#define AG903_CFC_Multi_Sector_Timeup_POS                  1                                                             /** CFCMulti_Sector Timeup-bit position */
#define AG903_CFC_Multi_Sector_Timeup_MSK                  (0x7fUL << AG903_CFC_Multi_Sector_Timeup_POS)                 /** CFCMulti_Sector Timeup-bit mask */

#define AG903_CFC_Mode2_Enable_Enable_POS                  0                                                             /** CFCMode2_Enable Enable-bit position */
#define AG903_CFC_Mode2_Enable_Enable_MSK                  (0x1UL << AG903_CFC_Mode2_Enable_Enable_POS)                  /** CFCMode2_Enable Enable-bit mask */

#define AG903_CFC_Mode2_Counter_Cnt_POS                    0                                                             /** CFCMode2_Counter Cnt-bit position */
#define AG903_CFC_Mode2_Counter_Cnt_MSK                    (0x1ffffUL << AG903_CFC_Mode2_Counter_Cnt_POS)                /** CFCMode2_Counter Cnt-bit mask */

#define AG903_CFC_REVISION_REVISION_POS                    0                                                             /** CFCREVISION REVISION-bit position */
#define AG903_CFC_REVISION_REVISION_MSK                    (0xffffffffUL << AG903_CFC_REVISION_REVISION_POS)             /** CFCREVISION REVISION-bit mask */

#define AG903_CFC_FEATURE_BUFSIZE_POS                      0                                                             /** CFCFEATURE BUFSIZE-bit position */
#define AG903_CFC_FEATURE_BUFSIZE_MSK                      (0xfUL << AG903_CFC_FEATURE_BUFSIZE_POS)                      /** CFCFEATURE BUFSIZE-bit mask */
#define AG903_CFC_FEATURE_SBI_POS                          4                                                             /** CFCFEATURE SBI-bit position */
#define AG903_CFC_FEATURE_SBI_MSK                          (0x1UL << AG903_CFC_FEATURE_SBI_POS)                          /** CFCFEATURE SBI-bit mask */

#endif /* _AG903_CFC_REGMAP_H_ */

