/**
 * @brief           EQS Register Definition
 * @author          AXELL CORPORATION
 * @description     EQS Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_EQS_REGMAP_H_
#define _AG903_EQS_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** EQS Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  MOD;

        struct {
            __IO uint32_t  CM                             :  1;
        } MOD_bits;
    };

    union {
        __IO uint32_t  DIVIDE;

        struct {
            __IO uint32_t  DIV                            : 16;
        } DIVIDE_bits;
    };

    union {
        __IO uint32_t  WAITCYCLE;

        struct {
            __IO uint32_t  COUNT                          : 16;
        } WAITCYCLE_bits;
    };

    __I  uint32_t  RESERVED1[5];

    union {
        __IO uint32_t  RDFMT0;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } RDFMT0_bits;
    };

    union {
        __IO uint32_t  WRFMT0;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
            __IO uint32_t  DW                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } WRFMT0_bits;
    };

    union {
        __IO uint32_t  RDFMT1;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } RDFMT1_bits;
    };

    union {
        __IO uint32_t  WRFMT1;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
            __IO uint32_t  DW                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } WRFMT1_bits;
    };

    union {
        __IO uint32_t  RDFMT2;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } RDFMT2_bits;
    };

    union {
        __IO uint32_t  WRFMT2;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
            __IO uint32_t  DW                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } WRFMT2_bits;
    };

    union {
        __IO uint32_t  RDFMT3;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } RDFMT3_bits;
    };

    union {
        __IO uint32_t  WRFMT3;

        struct {
            __IO uint32_t  CMD                            :  8;
            __IO uint32_t  WW                             :  2;
            __IO uint32_t  DW                             :  1;
                 uint32_t                                 :  5;
            __IO uint32_t  AW                             :  2;
                 uint32_t                                 :  6;
            __IO uint32_t  FC                             :  1;
        } WRFMT3_bits;
    };

/* DOM-IGNORE-END */
}AG903_EQS_Type;

#define AG903_EQS                                ((volatile AG903_EQS_Type *) AG903_EQS_BASE)                            /** EQS Base Address */


#define AG903_EQS_MOD_CM_POS                               0                                                             /** EQSMOD CM-bit position */
#define AG903_EQS_MOD_CM_MSK                               (0x1UL << AG903_EQS_MOD_CM_POS)                               /** EQSMOD CM-bit mask */

#define AG903_EQS_DIVIDE_DIV_POS                           0                                                             /** EQSDIVIDE DIV-bit position */
#define AG903_EQS_DIVIDE_DIV_MSK                           (0xffffUL << AG903_EQS_DIVIDE_DIV_POS)                        /** EQSDIVIDE DIV-bit mask */

#define AG903_EQS_WAITCYCLE_COUNT_POS                      0                                                             /** EQSWAITCYCLE COUNT-bit position */
#define AG903_EQS_WAITCYCLE_COUNT_MSK                      (0xffffUL << AG903_EQS_WAITCYCLE_COUNT_POS)                   /** EQSWAITCYCLE COUNT-bit mask */

#define AG903_EQS_RDFMT0_CMD_POS                           0                                                             /** EQSRDFMT0 CMD-bit position */
#define AG903_EQS_RDFMT0_CMD_MSK                           (0xffUL << AG903_EQS_RDFMT0_CMD_POS)                          /** EQSRDFMT0 CMD-bit mask */
#define AG903_EQS_RDFMT0_WW_POS                            8                                                             /** EQSRDFMT0 WW-bit position */
#define AG903_EQS_RDFMT0_WW_MSK                            (0x3UL << AG903_EQS_RDFMT0_WW_POS)                            /** EQSRDFMT0 WW-bit mask */
#define AG903_EQS_RDFMT0_AW_POS                            16                                                            /** EQSRDFMT0 AW-bit position */
#define AG903_EQS_RDFMT0_AW_MSK                            (0x3UL << AG903_EQS_RDFMT0_AW_POS)                            /** EQSRDFMT0 AW-bit mask */
#define AG903_EQS_RDFMT0_FC_POS                            24                                                            /** EQSRDFMT0 FC-bit position */
#define AG903_EQS_RDFMT0_FC_MSK                            (0x1UL << AG903_EQS_RDFMT0_FC_POS)                            /** EQSRDFMT0 FC-bit mask */

#define AG903_EQS_WRFMT0_CMD_POS                           0                                                             /** EQSWRFMT0 CMD-bit position */
#define AG903_EQS_WRFMT0_CMD_MSK                           (0xffUL << AG903_EQS_WRFMT0_CMD_POS)                          /** EQSWRFMT0 CMD-bit mask */
#define AG903_EQS_WRFMT0_WW_POS                            8                                                             /** EQSWRFMT0 WW-bit position */
#define AG903_EQS_WRFMT0_WW_MSK                            (0x3UL << AG903_EQS_WRFMT0_WW_POS)                            /** EQSWRFMT0 WW-bit mask */
#define AG903_EQS_WRFMT0_DW_POS                            10                                                            /** EQSWRFMT0 DW-bit position */
#define AG903_EQS_WRFMT0_DW_MSK                            (0x1UL << AG903_EQS_WRFMT0_DW_POS)                            /** EQSWRFMT0 DW-bit mask */
#define AG903_EQS_WRFMT0_AW_POS                            16                                                            /** EQSWRFMT0 AW-bit position */
#define AG903_EQS_WRFMT0_AW_MSK                            (0x3UL << AG903_EQS_WRFMT0_AW_POS)                            /** EQSWRFMT0 AW-bit mask */
#define AG903_EQS_WRFMT0_FC_POS                            24                                                            /** EQSWRFMT0 FC-bit position */
#define AG903_EQS_WRFMT0_FC_MSK                            (0x1UL << AG903_EQS_WRFMT0_FC_POS)                            /** EQSWRFMT0 FC-bit mask */

#define AG903_EQS_RDFMT1_CMD_POS                           0                                                             /** EQSRDFMT1 CMD-bit position */
#define AG903_EQS_RDFMT1_CMD_MSK                           (0xffUL << AG903_EQS_RDFMT1_CMD_POS)                          /** EQSRDFMT1 CMD-bit mask */
#define AG903_EQS_RDFMT1_WW_POS                            8                                                             /** EQSRDFMT1 WW-bit position */
#define AG903_EQS_RDFMT1_WW_MSK                            (0x3UL << AG903_EQS_RDFMT1_WW_POS)                            /** EQSRDFMT1 WW-bit mask */
#define AG903_EQS_RDFMT1_AW_POS                            16                                                            /** EQSRDFMT1 AW-bit position */
#define AG903_EQS_RDFMT1_AW_MSK                            (0x3UL << AG903_EQS_RDFMT1_AW_POS)                            /** EQSRDFMT1 AW-bit mask */
#define AG903_EQS_RDFMT1_FC_POS                            24                                                            /** EQSRDFMT1 FC-bit position */
#define AG903_EQS_RDFMT1_FC_MSK                            (0x1UL << AG903_EQS_RDFMT1_FC_POS)                            /** EQSRDFMT1 FC-bit mask */

#define AG903_EQS_WRFMT1_CMD_POS                           0                                                             /** EQSWRFMT1 CMD-bit position */
#define AG903_EQS_WRFMT1_CMD_MSK                           (0xffUL << AG903_EQS_WRFMT1_CMD_POS)                          /** EQSWRFMT1 CMD-bit mask */
#define AG903_EQS_WRFMT1_WW_POS                            8                                                             /** EQSWRFMT1 WW-bit position */
#define AG903_EQS_WRFMT1_WW_MSK                            (0x3UL << AG903_EQS_WRFMT1_WW_POS)                            /** EQSWRFMT1 WW-bit mask */
#define AG903_EQS_WRFMT1_DW_POS                            10                                                            /** EQSWRFMT1 DW-bit position */
#define AG903_EQS_WRFMT1_DW_MSK                            (0x1UL << AG903_EQS_WRFMT1_DW_POS)                            /** EQSWRFMT1 DW-bit mask */
#define AG903_EQS_WRFMT1_AW_POS                            16                                                            /** EQSWRFMT1 AW-bit position */
#define AG903_EQS_WRFMT1_AW_MSK                            (0x3UL << AG903_EQS_WRFMT1_AW_POS)                            /** EQSWRFMT1 AW-bit mask */
#define AG903_EQS_WRFMT1_FC_POS                            24                                                            /** EQSWRFMT1 FC-bit position */
#define AG903_EQS_WRFMT1_FC_MSK                            (0x1UL << AG903_EQS_WRFMT1_FC_POS)                            /** EQSWRFMT1 FC-bit mask */

#define AG903_EQS_RDFMT2_CMD_POS                           0                                                             /** EQSRDFMT2 CMD-bit position */
#define AG903_EQS_RDFMT2_CMD_MSK                           (0xffUL << AG903_EQS_RDFMT2_CMD_POS)                          /** EQSRDFMT2 CMD-bit mask */
#define AG903_EQS_RDFMT2_WW_POS                            8                                                             /** EQSRDFMT2 WW-bit position */
#define AG903_EQS_RDFMT2_WW_MSK                            (0x3UL << AG903_EQS_RDFMT2_WW_POS)                            /** EQSRDFMT2 WW-bit mask */
#define AG903_EQS_RDFMT2_AW_POS                            16                                                            /** EQSRDFMT2 AW-bit position */
#define AG903_EQS_RDFMT2_AW_MSK                            (0x3UL << AG903_EQS_RDFMT2_AW_POS)                            /** EQSRDFMT2 AW-bit mask */
#define AG903_EQS_RDFMT2_FC_POS                            24                                                            /** EQSRDFMT2 FC-bit position */
#define AG903_EQS_RDFMT2_FC_MSK                            (0x1UL << AG903_EQS_RDFMT2_FC_POS)                            /** EQSRDFMT2 FC-bit mask */

#define AG903_EQS_WRFMT2_CMD_POS                           0                                                             /** EQSWRFMT2 CMD-bit position */
#define AG903_EQS_WRFMT2_CMD_MSK                           (0xffUL << AG903_EQS_WRFMT2_CMD_POS)                          /** EQSWRFMT2 CMD-bit mask */
#define AG903_EQS_WRFMT2_WW_POS                            8                                                             /** EQSWRFMT2 WW-bit position */
#define AG903_EQS_WRFMT2_WW_MSK                            (0x3UL << AG903_EQS_WRFMT2_WW_POS)                            /** EQSWRFMT2 WW-bit mask */
#define AG903_EQS_WRFMT2_DW_POS                            10                                                            /** EQSWRFMT2 DW-bit position */
#define AG903_EQS_WRFMT2_DW_MSK                            (0x1UL << AG903_EQS_WRFMT2_DW_POS)                            /** EQSWRFMT2 DW-bit mask */
#define AG903_EQS_WRFMT2_AW_POS                            16                                                            /** EQSWRFMT2 AW-bit position */
#define AG903_EQS_WRFMT2_AW_MSK                            (0x3UL << AG903_EQS_WRFMT2_AW_POS)                            /** EQSWRFMT2 AW-bit mask */
#define AG903_EQS_WRFMT2_FC_POS                            24                                                            /** EQSWRFMT2 FC-bit position */
#define AG903_EQS_WRFMT2_FC_MSK                            (0x1UL << AG903_EQS_WRFMT2_FC_POS)                            /** EQSWRFMT2 FC-bit mask */

#define AG903_EQS_RDFMT3_CMD_POS                           0                                                             /** EQSRDFMT3 CMD-bit position */
#define AG903_EQS_RDFMT3_CMD_MSK                           (0xffUL << AG903_EQS_RDFMT3_CMD_POS)                          /** EQSRDFMT3 CMD-bit mask */
#define AG903_EQS_RDFMT3_WW_POS                            8                                                             /** EQSRDFMT3 WW-bit position */
#define AG903_EQS_RDFMT3_WW_MSK                            (0x3UL << AG903_EQS_RDFMT3_WW_POS)                            /** EQSRDFMT3 WW-bit mask */
#define AG903_EQS_RDFMT3_AW_POS                            16                                                            /** EQSRDFMT3 AW-bit position */
#define AG903_EQS_RDFMT3_AW_MSK                            (0x3UL << AG903_EQS_RDFMT3_AW_POS)                            /** EQSRDFMT3 AW-bit mask */
#define AG903_EQS_RDFMT3_FC_POS                            24                                                            /** EQSRDFMT3 FC-bit position */
#define AG903_EQS_RDFMT3_FC_MSK                            (0x1UL << AG903_EQS_RDFMT3_FC_POS)                            /** EQSRDFMT3 FC-bit mask */

#define AG903_EQS_WRFMT3_CMD_POS                           0                                                             /** EQSWRFMT3 CMD-bit position */
#define AG903_EQS_WRFMT3_CMD_MSK                           (0xffUL << AG903_EQS_WRFMT3_CMD_POS)                          /** EQSWRFMT3 CMD-bit mask */
#define AG903_EQS_WRFMT3_WW_POS                            8                                                             /** EQSWRFMT3 WW-bit position */
#define AG903_EQS_WRFMT3_WW_MSK                            (0x3UL << AG903_EQS_WRFMT3_WW_POS)                            /** EQSWRFMT3 WW-bit mask */
#define AG903_EQS_WRFMT3_DW_POS                            10                                                            /** EQSWRFMT3 DW-bit position */
#define AG903_EQS_WRFMT3_DW_MSK                            (0x1UL << AG903_EQS_WRFMT3_DW_POS)                            /** EQSWRFMT3 DW-bit mask */
#define AG903_EQS_WRFMT3_AW_POS                            16                                                            /** EQSWRFMT3 AW-bit position */
#define AG903_EQS_WRFMT3_AW_MSK                            (0x3UL << AG903_EQS_WRFMT3_AW_POS)                            /** EQSWRFMT3 AW-bit mask */
#define AG903_EQS_WRFMT3_FC_POS                            24                                                            /** EQSWRFMT3 FC-bit position */
#define AG903_EQS_WRFMT3_FC_MSK                            (0x1UL << AG903_EQS_WRFMT3_FC_POS)                            /** EQSWRFMT3 FC-bit mask */

#endif /* _AG903_EQS_REGMAP_H_ */

