/** 
 * @brief           USBH MSC BOT Header
 * @author          AXELL CORPORATION
 * @description     USBH MSC BOT Header
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __USB_MSC_BOT_H__
#define __USB_MSC_BOT_H__
/* DOM-IGNORE-END */

/*****************************************************************************/
/*     include files                                                         */
/*****************************************************************************/
#include "uhs_configtop.h"

#include "usb_msc_coreinclude.h"
#include "usb_msc_log.h"

/*****************************************************************************/
/*     define value                                                          */
/*****************************************************************************/
#ifdef USBH_STACK_DEBUG_BUILD
#define BOT_REPORT_SUMMARY(err) Usbh_Stor_Log_ReportError( g_filename, __LINE__, (uhs_ubit16_t)(err), (uhs_ubit8_t*)"1", 0 )
#define BOT_REPORT_WARNING_SUMMARY(warning) Usbh_Stor_Log_ReportWarning( g_filename, __LINE__, (uhs_ubit16_t)(warning), (uhs_ubit8_t*)"2", 0 )
#define BOT_REPORT_DETAIL(err, mesg, len) Usbh_Stor_Log_ReportError( g_filename, __LINE__, (uhs_ubit16_t)(err), (mesg), (len) )
#define BOT_REPORT_MILESTONE(num) Usbh_Stor_Log_ReportMilestone((num))
#else
#define BOT_REPORT_SUMMARY(err) Usbh_Stor_Log_ReportDummy(err)
#define BOT_REPORT_WARNING_SUMMARY(warning) Usbh_Stor_Log_ReportDummy(warning)
#define BOT_REPORT_DETAIL(err, mesg, len) Usbh_Stor_Log_ReportDummy(err)
#define BOT_REPORT_MILESTONE(num) Usbh_Stor_Log_ReportMilestone((num))
#endif

/*****************************************************************************/
/*     enum data                                                             */
/*****************************************************************************/

/*****************************************************************************/
/*     typedef                                                               */
/*****************************************************************************/

/*****************************************************************************/
/*     extern function                                                       */
/*****************************************************************************/
extern USB_BOT_STATUS Usbh_Stor_Bot_Initialize(STOR_CLASS_DRIVER *pStorClassDriver);
extern USB_BOT_STATUS Usbh_Stor_Bot_Finalize(STOR_CLASS_DRIVER *pStorClassDriver);
extern STOR_CLASS_DRIVER* Usbh_Stor_CreateStorClassDriver( usb_common_callback_t pUserAttachCallback, usb_common_callback_t pUserDetachCallback, int (*pApiLayerAttachCallback)(STOR_UNIT *pStorUnit), int (*pApiLayerDetachCallback)(STOR_UNIT *pStorUnit), uhs_boolean_t (*pCmdLayerAttachCallback)(STOR_UNIT *pStorUnit), uhs_boolean_t (*pCmdLayerDetachCallback)(STOR_UNIT *pStorUnit) );
extern uhs_boolean_t Usbh_Stor_DeleteStorClassDriver(STOR_CLASS_DRIVER *pThis);

/*****************************************************************************/
/*     extern variable                                                       */
/*****************************************************************************/

/*****************************************************************************/
/*     define macro                                                          */
/*****************************************************************************/

/*****************************************************************************/
/*     const value                                                           */
/*****************************************************************************/

/*****************************************************************************/
/*     global variable                                                       */
/*****************************************************************************/


#endif /* __USB_MSC_BOT_H__ */
