/**
 * @brief           DDR Register Definition
 * @author          AXELL CORPORATION
 * @description     DDR Register Definition
 * @note            none
 * @history         2017_10_20 Auto-generated.
 */
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _AG903_DDR_REGMAP_H_
#define _AG903_DDR_REGMAP_H_
/* DOM-IGNORE-END */

#include "AG903_regmap.h"

#ifndef __I
/** Read only */
#define __I  volatile const
#endif
#ifndef __O
/** Write only */
#define __O  volatile
#endif
#ifndef __IO
/** Read/Write */
#define __IO volatile
#endif

/** DDR Type */
typedef struct {
/* DOM-IGNORE-BEGIN */
    union {
        __IO uint32_t  MCCR;

        struct {
            __IO uint32_t  GDS                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  AMTSEL                         :  2;
                 uint32_t                                 :  2;
            __IO uint32_t  MW                             :  2;
            __IO uint32_t  ARCI                           :  3;
            __IO uint32_t  PRCC                           :  3;
            __IO uint32_t  DDR                            :  2;
            __IO uint32_t  FE                             :  1;
            __IO uint32_t  LPDDR                          :  1;
            __IO uint32_t  DREO                           :  1;
            __IO uint32_t  CCL                            :  2;
            __IO uint32_t  WCYC                           :  4;
            __IO uint32_t  DBER                           :  1;
            __IO uint32_t  MREF                           :  1;
        } MCCR_bits;
    };

    union {
        __IO uint32_t  MCSR;

        struct {
            __IO uint32_t  INIC                           :  1;
            __IO uint32_t  MRSC                           :  1;
            __IO uint32_t  MCSR                           :  1;
            __IO uint32_t  ESRC                           :  1;
            __IO uint32_t  REGM                           :  2;
            __IO uint32_t  ZQCS                           :  1;
            __IO uint32_t  ZQCL                           :  1;
            __I  uint32_t  INIOK                          :  1;
            __I  uint32_t  INIS                           :  1;
            __I  uint32_t  SREF                           :  1;
            __I  uint32_t  APDS                           :  1;
            __I  uint32_t  ZQCSS                          :  1;
            __I  uint32_t  ZQCLS                          :  1;
            __I  uint32_t  MCQE                           :  1;
            __I  uint32_t  BCQE                           :  1;
            __I  uint32_t  RLF                            :  1;
            __I  uint32_t  WLF                            :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  WSTA                           :  1;
                 uint32_t                                 :  6;
            __IO uint32_t  SRST                           :  1;
        } MCSR_bits;
    };

    union {
        __IO uint32_t  MRSVR0;

        struct {
            __IO uint32_t  MR                             : 14;
                 uint32_t                                 :  2;
            __IO uint32_t  EXTMR                          : 14;
        } MRSVR0_bits;
    };

    union {
        __IO uint32_t  MRSVR1;

        struct {
            __IO uint32_t  EMR2                           : 14;
                 uint32_t                                 :  2;
            __IO uint32_t  EMR3                           : 14;
        } MRSVR1_bits;
    };

    union {
        __IO uint32_t  EXRANKR;

        struct {
            __IO uint32_t  RNK0_SIZE                      :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RNK0_TYPE                      :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RNK1_SIZE                      :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RNK1_TYPE                      :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RNK1_EN                        :  1;
                 uint32_t                                 :  7;
            __IO uint32_t  RNK0_BASE                      :  8;
        } EXRANKR_bits;
    };

    union {
        __IO uint32_t  TMPR0;

        struct {
            __IO uint32_t  TRAS                           :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  TRC                            :  6;
                 uint32_t                                 :  2;
            __IO uint32_t  TFAW                           :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  TRFC                           :  8;
        } TMPR0_bits;
    };

    union {
        __IO uint32_t  TMPR1;

        struct {
            __IO uint32_t  TRCD                           :  4;
            __IO uint32_t  TRRD                           :  4;
            __IO uint32_t  TRP                            :  4;
            __IO uint32_t  TMRD                           :  4;
            __IO uint32_t  TMOD                           :  4;
            __IO uint32_t  TWR                            :  4;
            __IO uint32_t  TRTP                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  TWTR                           :  3;
        } TMPR1_bits;
    };

    union {
        __IO uint32_t  TMPR2;

        struct {
            __IO uint32_t  TREFI                          :  8;
            __IO uint32_t  TXSR                           :  8;
                 uint32_t                                 :  8;
            __IO uint32_t  TRTW                           :  2;
            __IO uint32_t  TRTR                           :  2;
            __IO uint32_t  TWTW                           :  2;
            __IO uint32_t  TWTR                           :  2;
        } TMPR2_bits;
    };

    union {
        __IO uint32_t  PHYCR0;

        struct {
            __IO uint32_t  ODTMD                          :  3;
            __IO uint32_t  DQSB                           :  1;
            __IO uint32_t  ODTDM                          :  1;
            __IO uint32_t  DQSLF                          :  1;
            __IO uint32_t  IO18V                          :  1;
            __IO uint32_t  ACPD                           :  1;
            __IO uint32_t  ODTE                           :  1;
            __IO uint32_t  CMDE                           :  1;
            __IO uint32_t  CLKE                           :  1;
            __IO uint32_t  DQRE                           :  1;
            __IO uint32_t  CPHS                           :  1;
            __IO uint32_t  PCU                            :  1;
            __IO uint32_t  SBIAS                          :  1;
            __IO uint32_t  ADPD                           :  1;
            __I  uint32_t  FLDC                           :  1;
                 uint32_t                                 :  7;
            __I  uint32_t  FLD0                           :  1;
            __I  uint32_t  FLD1                           :  1;
            __I  uint32_t  FLD2                           :  1;
            __I  uint32_t  FLD3                           :  1;
            __I  uint32_t  FLD4                           :  1;
            __I  uint32_t  FLD5                           :  1;
            __I  uint32_t  FLD6                           :  1;
            __I  uint32_t  FLD7                           :  1;
        } PHYCR0_bits;
    };

    union {
        __IO uint32_t  PHYRDTR;

        struct {
            __IO uint32_t  DLLSEL0                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL1                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL2                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL3                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL4                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL5                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL6                        :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  DLLSEL7                        :  3;
        } PHYRDTR_bits;
    };

    union {
        __IO uint32_t  COMPBLKCR;

        struct {
            __IO uint32_t  COMP_SEL                       :  1;
            __IO uint32_t  DIP                            :  6;
            __IO uint32_t  DIN                            :  6;
            __I  uint32_t  DOP                            :  6;
            __I  uint32_t  DON                            :  6;
        } COMPBLKCR_bits;
    };

    union {
        __IO uint32_t  APDCR;

        struct {
            __IO uint32_t  PDNT                           : 12;
            __IO uint32_t  PDNE                           :  1;
                 uint32_t                                 :  3;
            __IO uint32_t  SREFT                          : 12;
            __IO uint32_t  SREFE                          :  1;
        } APDCR_bits;
    };

    union {
        __IO uint32_t  CHARBRA;

        struct {
            __IO uint32_t  HP                             :  8;
            __IO uint32_t  BOA                            :  8;
                 uint32_t                                 :  8;
            __IO uint32_t  GGCNT                          :  5;
                 uint32_t                                 :  1;
            __IO uint32_t  IRWG                           :  1;
            __IO uint32_t  RWG                            :  1;
        } CHARBRA_bits;
    };

    union {
        __IO uint32_t  CHGNTRA;

        struct {
            __IO uint32_t  ARB_CNT0                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  ARB_CNT1                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  ARB_CNT2                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  ARB_CNT3                       :  5;
        } CHGNTRA_bits;
    };

    union {
        __IO uint32_t  CHGNTRB;

        struct {
            __IO uint32_t  ARB_CNT4                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  ARB_CNT5                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  ARB_CNT6                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  ARB_CNT7                       :  5;
        } CHGNTRB_bits;
    };

    union {
        __IO uint32_t  PHYWRTMR;

        struct {
            __IO uint32_t  TWLAT                          :  4;
            __IO uint32_t  TWDEN                          :  2;
                 uint32_t                                 : 10;
            __IO uint32_t  TRDEN                          :  4;
            __IO uint32_t  TRDLAT                         :  4;
        } PHYWRTMR_bits;
    };

    union {
        __IO uint32_t  FLUSHCR;

        struct {
            __IO uint32_t  CMDFE                          :  8;
            __IO uint32_t  FINTE                          :  8;
            __IO uint32_t  DINTE                          :  1;
        } FLUSHCR_bits;
    };

    union {
        __IO uint32_t  FLUSHSR;

        struct {
            __IO uint32_t  FLUSH_DONE                     :  8;
            __IO uint32_t  DBGHIT                         :  1;
        } FLUSHSR_bits;
    };

    union {
        __IO uint32_t  SPLITCR;

        struct {
            __IO uint32_t  SD0                            :  1;
            __IO uint32_t  SD1                            :  1;
            __IO uint32_t  SD2                            :  1;
            __IO uint32_t  SD3                            :  1;
            __IO uint32_t  SD4                            :  1;
            __IO uint32_t  SD5                            :  1;
            __IO uint32_t  SD6                            :  1;
            __IO uint32_t  SD7                            :  1;
            __IO uint32_t  HP0                            :  2;
            __IO uint32_t  HP1                            :  2;
            __IO uint32_t  HP2                            :  2;
            __IO uint32_t  HP3                            :  2;
            __IO uint32_t  HP4                            :  2;
            __IO uint32_t  HP5                            :  2;
            __IO uint32_t  HP6                            :  2;
            __IO uint32_t  HP7                            :  2;
        } SPLITCR_bits;
    };

    union {
        __IO uint32_t  UPDCR;

        struct {
            __IO uint32_t  TDLLUP                         :  8;
            __IO uint32_t  TWLVUP                         :  8;
            __IO uint32_t  ZQUD                           :  2;
        } UPDCR_bits;
    };

    union {
        __I  uint32_t  REVR;

        struct {
            __I  uint32_t  REL_VER                        :  8;
            __I  uint32_t  MINOR_VER                      :  8;
            __I  uint32_t  MAJOR_VER                      :  8;
        } REVR_bits;
    };

    union {
        __I  uint32_t  FEATR1;

        struct {
            __I  uint32_t  CHCNT                          :  3;
            __I  uint32_t  AMON                           :  3;
            __I  uint32_t  MAXMW                          :  2;
            __I  uint32_t  BT0                            :  1;
            __I  uint32_t  BT1                            :  1;
            __I  uint32_t  BT2                            :  1;
            __I  uint32_t  BT3                            :  1;
            __I  uint32_t  BT4                            :  1;
            __I  uint32_t  BT5                            :  1;
            __I  uint32_t  BT6                            :  1;
            __I  uint32_t  BT7                            :  1;
            __I  uint32_t  DW0                            :  1;
            __I  uint32_t  DW1                            :  1;
            __I  uint32_t  DW2                            :  1;
            __I  uint32_t  DW3                            :  1;
            __I  uint32_t  DW4                            :  1;
            __I  uint32_t  DW5                            :  1;
            __I  uint32_t  DW6                            :  1;
            __I  uint32_t  DW7                            :  1;
            __I  uint32_t  BNKNM                          :  1;
            __I  uint32_t  BNKSW                          :  1;
        } FEATR1_bits;
    };

    union {
        __I  uint32_t  FEATR2;

        struct {
            __I  uint32_t  CM0                            :  2;
            __I  uint32_t  SP0                            :  1;
            __I  uint32_t  CB0                            :  1;
            __I  uint32_t  CM1                            :  2;
            __I  uint32_t  SP1                            :  1;
            __I  uint32_t  CB1                            :  1;
            __I  uint32_t  CM2                            :  2;
            __I  uint32_t  SP2                            :  1;
            __I  uint32_t  CB2                            :  1;
            __I  uint32_t  CM3                            :  2;
            __I  uint32_t  SP3                            :  1;
            __I  uint32_t  CB3                            :  1;
            __I  uint32_t  CM4                            :  2;
            __I  uint32_t  SP4                            :  1;
            __I  uint32_t  CB4                            :  1;
            __I  uint32_t  CM5                            :  2;
            __I  uint32_t  SP5                            :  1;
            __I  uint32_t  CB5                            :  1;
            __I  uint32_t  CM6                            :  2;
            __I  uint32_t  SP6                            :  1;
            __I  uint32_t  CB6                            :  1;
            __I  uint32_t  CM7                            :  2;
            __I  uint32_t  SP7                            :  1;
            __I  uint32_t  CB7                            :  1;
        } FEATR2_bits;
    };

    union {
        __IO uint32_t  UDEFR;
    };

    union {
        __IO uint32_t  WLEVELCR;

        struct {
            __IO uint32_t  TWL                            :  8;
                 uint32_t                                 :  8;
            __IO uint32_t  WHD0                           :  1;
            __IO uint32_t  WHD1                           :  1;
            __IO uint32_t  WHD2                           :  1;
            __IO uint32_t  WHD3                           :  1;
            __IO uint32_t  WHD4                           :  1;
            __IO uint32_t  WHD5                           :  1;
            __IO uint32_t  WHD6                           :  1;
            __IO uint32_t  WHD7                           :  1;
            __I  uint32_t  WLP0                           :  1;
            __I  uint32_t  WLP1                           :  1;
            __I  uint32_t  WLP2                           :  1;
            __I  uint32_t  WLP3                           :  1;
            __I  uint32_t  WLP4                           :  1;
            __I  uint32_t  WLP5                           :  1;
            __I  uint32_t  WLP6                           :  1;
            __I  uint32_t  WLP7                           :  1;
        } WLEVELCR_bits;
    };

    union {
        __IO uint32_t  WLEVELBHR;

        struct {
            __IO uint32_t  DELAY4                         :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  DELAY5                         :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  DELAY6                         :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  DELAY7                         :  7;
        } WLEVELBHR_bits;
    };

    union {
        __IO uint32_t  WLEVELBLR;

        struct {
            __IO uint32_t  DELAY0                         :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  DELAY1                         :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  DELAY2                         :  7;
                 uint32_t                                 :  1;
            __IO uint32_t  DELAY3                         :  7;
        } WLEVELBLR_bits;
    };

    union {
        __IO uint32_t  PHYMISCR1;

        struct {
            __IO uint32_t  RDQS0                          :  1;
            __IO uint32_t  WDQS0                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS1                          :  1;
            __IO uint32_t  WDQS1                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS2                          :  1;
            __IO uint32_t  WDQS2                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS3                          :  1;
            __IO uint32_t  WDQS3                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS4                          :  1;
            __IO uint32_t  WDQS4                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS5                          :  1;
            __IO uint32_t  WDQS5                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS6                          :  1;
            __IO uint32_t  WDQS6                          :  1;
                 uint32_t                                 :  2;
            __IO uint32_t  RDQS7                          :  1;
            __IO uint32_t  WDQS7                          :  1;
        } PHYMISCR1_bits;
    };

    union {
        __IO uint32_t  RLEVELCR;

        struct {
            __IO uint32_t  RHD0                           :  1;
            __IO uint32_t  RHD1                           :  1;
            __IO uint32_t  RHD2                           :  1;
            __IO uint32_t  RHD3                           :  1;
            __IO uint32_t  RHD4                           :  1;
            __IO uint32_t  RHD5                           :  1;
            __IO uint32_t  RHD6                           :  1;
            __IO uint32_t  RHD7                           :  1;
                 uint32_t                                 : 16;
            __I  uint32_t  RLP0                           :  1;
            __I  uint32_t  RLP1                           :  1;
            __I  uint32_t  RLP2                           :  1;
            __I  uint32_t  RLP3                           :  1;
            __I  uint32_t  RLP4                           :  1;
            __I  uint32_t  RLP5                           :  1;
            __I  uint32_t  RLP6                           :  1;
            __I  uint32_t  RLP7                           :  1;
        } RLEVELCR_bits;
    };

    union {
        __IO uint32_t  MSDLYCR;

        struct {
            __IO uint32_t  MSDLY0                         :  4;
            __IO uint32_t  MSDLY1                         :  4;
            __IO uint32_t  MSDLY2                         :  4;
            __IO uint32_t  MSDLY3                         :  4;
            __IO uint32_t  MSDLY4                         :  4;
            __IO uint32_t  MSDLY5                         :  4;
            __IO uint32_t  MSDLY6                         :  4;
            __IO uint32_t  MSDLY7                         :  4;
        } MSDLYCR_bits;
    };

    union {
        __IO uint32_t  WRDLLCR;

        struct {
            __IO uint32_t  WRDLL0                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL1                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL2                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL3                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL4                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL5                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL6                         :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  WRDLL7                         :  3;
        } WRDLLCR_bits;
    };

    union {
        __IO uint32_t  TRAFMR;
    };

    union {
        __I  uint32_t  CMDCNTR0;
    };

    union {
        __I  uint32_t  CMDCNTR1;
    };

    union {
        __I  uint32_t  CMDCNTR2;
    };

    union {
        __I  uint32_t  CMDCNTR3;
    };

    union {
        __I  uint32_t  CMDCNTR4;
    };

    union {
        __I  uint32_t  CMDCNTR5;
    };

    union {
        __I  uint32_t  CMDCNTR6;
    };

    union {
        __I  uint32_t  CMDCNTR7;
    };

    union {
        __IO uint32_t  AHBRPRER1;

        struct {
            __IO uint32_t  PFV0                           :  4;
                 uint32_t                                 :  3;
            __IO uint32_t  LPF0                           :  1;
            __IO uint32_t  PFV1                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF1                           :  1;
            __IO uint32_t  PFV2                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF2                           :  1;
            __IO uint32_t  PFV3                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF3                           :  1;
        } AHBRPRER1_bits;
    };

    union {
        __IO uint32_t  AHBRPRER2;

        struct {
            __IO uint32_t  PFV4                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF4                           :  1;
            __IO uint32_t  PFV5                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF5                           :  1;
            __IO uint32_t  PFV6                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF6                           :  1;
            __IO uint32_t  PFV7                           :  5;
                 uint32_t                                 :  2;
            __IO uint32_t  LPF7                           :  1;
        } AHBRPRER2_bits;
    };

    union {
        __IO uint32_t  INITWCR1;

        struct {
            __IO uint32_t  WC200US                        : 20;
        } INITWCR1_bits;
    };

    union {
        __IO uint32_t  INITWCR2;

        struct {
            __IO uint32_t  WC500US                        : 20;
        } INITWCR2_bits;
    };

    union {
        __IO uint32_t  QOSCR;

        struct {
            __IO uint32_t  EN                             :  1;
            __IO uint32_t  PERI                           :  2;
            __IO uint32_t  IDRW                           :  1;
        } QOSCR_bits;
    };

    union {
        __IO uint32_t  QOSCNTRA;

        struct {
            __IO uint32_t  CMDCNT0                        :  8;
            __IO uint32_t  CMDCNT1                        :  8;
            __IO uint32_t  CMDCNT2                        :  8;
            __IO uint32_t  CMDCNT3                        :  8;
        } QOSCNTRA_bits;
    };

    union {
        __IO uint32_t  QOSCNTRB;

        struct {
            __IO uint32_t  CMDCNT4                        :  8;
            __IO uint32_t  CMDCNT5                        :  8;
            __IO uint32_t  CMDCNT6                        :  8;
            __IO uint32_t  CMDCNT7                        :  8;
        } QOSCNTRB_bits;
    };

    union {
        __IO uint32_t  QOSCNTRC;

        struct {
            __IO uint32_t  WCMDCNT0                       :  8;
            __IO uint32_t  WCMDCNT1                       :  8;
            __IO uint32_t  WCMDCNT2                       :  8;
            __IO uint32_t  WCMDCNT3                       :  8;
        } QOSCNTRC_bits;
    };

    union {
        __IO uint32_t  QOSCNTRD;

        struct {
            __IO uint32_t  WCMDCNT4                       :  8;
            __IO uint32_t  WCMDCNT5                       :  8;
            __IO uint32_t  WCMDCNT6                       :  8;
            __IO uint32_t  WCMDCNT7                       :  8;
        } QOSCNTRD_bits;
    };

    union {
        __IO uint32_t  CHARBRB;

        struct {
            __IO uint32_t  WHIPRI                         :  8;
            __IO uint32_t  WBSTORTARB                     :  8;
                 uint32_t                                 :  8;
            __IO uint32_t  WGGRTCNT                       :  5;
        } CHARBRB_bits;
    };

    union {
        __IO uint32_t  CHGNTRC;

        struct {
            __IO uint32_t  WARBCNT0                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  WARBCNT1                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  WARBCNT2                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  WARBCNT3                       :  5;
        } CHGNTRC_bits;
    };

    union {
        __IO uint32_t  CHGNTRD;

        struct {
            __IO uint32_t  WARBCNT4                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  WARBCNT5                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  WARBCNT6                       :  5;
                 uint32_t                                 :  3;
            __IO uint32_t  WARBCNT7                       :  5;
        } CHGNTRD_bits;
    };

    union {
        __IO uint32_t  DBGADR;
    };

    union {
        __IO uint32_t  DBGADMR;
    };

    union {
        __IO uint32_t  DBGWDR;
    };

    union {
        __IO uint32_t  DBGWDMR;
    };

    union {
        __IO uint32_t  DBGMSTR;

        struct {
            __IO uint32_t  ID                             : 16;
            __IO uint32_t  CH                             :  3;
            __IO uint32_t  EX                             :  1;
        } DBGMSTR_bits;
    };

    union {
        __IO uint32_t  DBGACCR;

        struct {
            __IO uint32_t  RWS                            :  1;
            __IO uint32_t  LSW                            :  1;
        } DBGACCR_bits;
    };

    union {
        __IO uint32_t  DBGPCR;

        struct {
            __IO uint32_t  ADR                            :  1;
            __IO uint32_t  WD                             :  1;
            __IO uint32_t  ID                             :  1;
            __IO uint32_t  CH                             :  1;
            __IO uint32_t  RW                             :  1;
        } DBGPCR_bits;
    };

    union {
        __IO uint32_t  DBGENR;

        struct {
            __IO uint32_t  EN                             :  1;
        } DBGENR_bits;
    };

    union {
        __I  uint32_t  DBGADSR;
    };

    union {
        __I  uint32_t  DBGWDSR;
    };

    union {
        __I  uint32_t  DBGMSTSR;

        struct {
            __I  uint32_t  IDSTATUS                       : 16;
            __I  uint32_t  CHSTATUS                       :  3;
        } DBGMSTSR_bits;
    };

    union {
        __I  uint32_t  DBGACCSR;

        struct {
            __I  uint32_t  ST                             :  1;
        } DBGACCSR_bits;
    };

    __I  uint32_t  RESERVED1[12];

    union {
        __IO uint32_t  PHYRDTFR;

        struct {
            __IO uint32_t  RD0                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD1                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD2                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD3                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD4                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD5                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD6                            :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RD7                            :  3;
        } PHYRDTFR_bits;
    };

    union {
        __IO uint32_t  PHYMISCR2;

        struct {
            __IO uint32_t  RDCA                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RDDT                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  VREF                           :  3;
                 uint32_t                                 :  1;
            __IO uint32_t  RLEEN                          :  1;
            __IO uint32_t  RLGEN                          :  1;
            __IO uint32_t  IO15V                          :  1;
        } PHYMISCR2_bits;
    };

/* DOM-IGNORE-END */
}AG903_DDR_Type;

#define AG903_DDR                                ((volatile AG903_DDR_Type *) AG903_DDR_BASE)                            /** DDR Base Address */


#define AG903_DDR_MCCR_GDS_POS                             0                                                             /** DDRMCCR GDS-bit position */
#define AG903_DDR_MCCR_GDS_MSK                             (0x7UL << AG903_DDR_MCCR_GDS_POS)                             /** DDRMCCR GDS-bit mask */
#define AG903_DDR_MCCR_AMTSEL_POS                          4                                                             /** DDRMCCR AMTSEL-bit position */
#define AG903_DDR_MCCR_AMTSEL_MSK                          (0x3UL << AG903_DDR_MCCR_AMTSEL_POS)                          /** DDRMCCR AMTSEL-bit mask */
#define AG903_DDR_MCCR_MW_POS                              8                                                             /** DDRMCCR MW-bit position */
#define AG903_DDR_MCCR_MW_MSK                              (0x3UL << AG903_DDR_MCCR_MW_POS)                              /** DDRMCCR MW-bit mask */
#define AG903_DDR_MCCR_ARCI_POS                            10                                                            /** DDRMCCR ARCI-bit position */
#define AG903_DDR_MCCR_ARCI_MSK                            (0x7UL << AG903_DDR_MCCR_ARCI_POS)                            /** DDRMCCR ARCI-bit mask */
#define AG903_DDR_MCCR_PRCC_POS                            13                                                            /** DDRMCCR PRCC-bit position */
#define AG903_DDR_MCCR_PRCC_MSK                            (0x7UL << AG903_DDR_MCCR_PRCC_POS)                            /** DDRMCCR PRCC-bit mask */
#define AG903_DDR_MCCR_DDR_POS                             16                                                            /** DDRMCCR DDR-bit position */
#define AG903_DDR_MCCR_DDR_MSK                             (0x3UL << AG903_DDR_MCCR_DDR_POS)                             /** DDRMCCR DDR-bit mask */
#define AG903_DDR_MCCR_FE_POS                              18                                                            /** DDRMCCR FE-bit position */
#define AG903_DDR_MCCR_FE_MSK                              (0x1UL << AG903_DDR_MCCR_FE_POS)                              /** DDRMCCR FE-bit mask */
#define AG903_DDR_MCCR_LPDDR_POS                           19                                                            /** DDRMCCR LPDDR-bit position */
#define AG903_DDR_MCCR_LPDDR_MSK                           (0x1UL << AG903_DDR_MCCR_LPDDR_POS)                           /** DDRMCCR LPDDR-bit mask */
#define AG903_DDR_MCCR_DREO_POS                            20                                                            /** DDRMCCR DREO-bit position */
#define AG903_DDR_MCCR_DREO_MSK                            (0x1UL << AG903_DDR_MCCR_DREO_POS)                            /** DDRMCCR DREO-bit mask */
#define AG903_DDR_MCCR_CCL_POS                             21                                                            /** DDRMCCR CCL-bit position */
#define AG903_DDR_MCCR_CCL_MSK                             (0x3UL << AG903_DDR_MCCR_CCL_POS)                             /** DDRMCCR CCL-bit mask */
#define AG903_DDR_MCCR_WCYC_POS                            23                                                            /** DDRMCCR WCYC-bit position */
#define AG903_DDR_MCCR_WCYC_MSK                            (0xfUL << AG903_DDR_MCCR_WCYC_POS)                            /** DDRMCCR WCYC-bit mask */
#define AG903_DDR_MCCR_DBER_POS                            27                                                            /** DDRMCCR DBER-bit position */
#define AG903_DDR_MCCR_DBER_MSK                            (0x1UL << AG903_DDR_MCCR_DBER_POS)                            /** DDRMCCR DBER-bit mask */
#define AG903_DDR_MCCR_MREF_POS                            28                                                            /** DDRMCCR MREF-bit position */
#define AG903_DDR_MCCR_MREF_MSK                            (0x1UL << AG903_DDR_MCCR_MREF_POS)                            /** DDRMCCR MREF-bit mask */

#define AG903_DDR_MCSR_INIC_POS                            0                                                             /** DDRMCSR INIC-bit position */
#define AG903_DDR_MCSR_INIC_MSK                            (0x1UL << AG903_DDR_MCSR_INIC_POS)                            /** DDRMCSR INIC-bit mask */
#define AG903_DDR_MCSR_MRSC_POS                            1                                                             /** DDRMCSR MRSC-bit position */
#define AG903_DDR_MCSR_MRSC_MSK                            (0x1UL << AG903_DDR_MCSR_MRSC_POS)                            /** DDRMCSR MRSC-bit mask */
#define AG903_DDR_MCSR_MCSR_POS                            2                                                             /** DDRMCSR MCSR-bit position */
#define AG903_DDR_MCSR_MCSR_MSK                            (0x1UL << AG903_DDR_MCSR_MCSR_POS)                            /** DDRMCSR MCSR-bit mask */
#define AG903_DDR_MCSR_ESRC_POS                            3                                                             /** DDRMCSR ESRC-bit position */
#define AG903_DDR_MCSR_ESRC_MSK                            (0x1UL << AG903_DDR_MCSR_ESRC_POS)                            /** DDRMCSR ESRC-bit mask */
#define AG903_DDR_MCSR_REGM_POS                            4                                                             /** DDRMCSR REGM-bit position */
#define AG903_DDR_MCSR_REGM_MSK                            (0x3UL << AG903_DDR_MCSR_REGM_POS)                            /** DDRMCSR REGM-bit mask */
#define AG903_DDR_MCSR_ZQCS_POS                            6                                                             /** DDRMCSR ZQCS-bit position */
#define AG903_DDR_MCSR_ZQCS_MSK                            (0x1UL << AG903_DDR_MCSR_ZQCS_POS)                            /** DDRMCSR ZQCS-bit mask */
#define AG903_DDR_MCSR_ZQCL_POS                            7                                                             /** DDRMCSR ZQCL-bit position */
#define AG903_DDR_MCSR_ZQCL_MSK                            (0x1UL << AG903_DDR_MCSR_ZQCL_POS)                            /** DDRMCSR ZQCL-bit mask */
#define AG903_DDR_MCSR_INIOK_POS                           8                                                             /** DDRMCSR INIOK-bit position */
#define AG903_DDR_MCSR_INIOK_MSK                           (0x1UL << AG903_DDR_MCSR_INIOK_POS)                           /** DDRMCSR INIOK-bit mask */
#define AG903_DDR_MCSR_INIS_POS                            9                                                             /** DDRMCSR INIS-bit position */
#define AG903_DDR_MCSR_INIS_MSK                            (0x1UL << AG903_DDR_MCSR_INIS_POS)                            /** DDRMCSR INIS-bit mask */
#define AG903_DDR_MCSR_SREF_POS                            10                                                            /** DDRMCSR SREF-bit position */
#define AG903_DDR_MCSR_SREF_MSK                            (0x1UL << AG903_DDR_MCSR_SREF_POS)                            /** DDRMCSR SREF-bit mask */
#define AG903_DDR_MCSR_APDS_POS                            11                                                            /** DDRMCSR APDS-bit position */
#define AG903_DDR_MCSR_APDS_MSK                            (0x1UL << AG903_DDR_MCSR_APDS_POS)                            /** DDRMCSR APDS-bit mask */
#define AG903_DDR_MCSR_ZQCSS_POS                           12                                                            /** DDRMCSR ZQCSS-bit position */
#define AG903_DDR_MCSR_ZQCSS_MSK                           (0x1UL << AG903_DDR_MCSR_ZQCSS_POS)                           /** DDRMCSR ZQCSS-bit mask */
#define AG903_DDR_MCSR_ZQCLS_POS                           13                                                            /** DDRMCSR ZQCLS-bit position */
#define AG903_DDR_MCSR_ZQCLS_MSK                           (0x1UL << AG903_DDR_MCSR_ZQCLS_POS)                           /** DDRMCSR ZQCLS-bit mask */
#define AG903_DDR_MCSR_MCQE_POS                            14                                                            /** DDRMCSR MCQE-bit position */
#define AG903_DDR_MCSR_MCQE_MSK                            (0x1UL << AG903_DDR_MCSR_MCQE_POS)                            /** DDRMCSR MCQE-bit mask */
#define AG903_DDR_MCSR_BCQE_POS                            15                                                            /** DDRMCSR BCQE-bit position */
#define AG903_DDR_MCSR_BCQE_MSK                            (0x1UL << AG903_DDR_MCSR_BCQE_POS)                            /** DDRMCSR BCQE-bit mask */
#define AG903_DDR_MCSR_RLF_POS                             16                                                            /** DDRMCSR RLF-bit position */
#define AG903_DDR_MCSR_RLF_MSK                             (0x1UL << AG903_DDR_MCSR_RLF_POS)                             /** DDRMCSR RLF-bit mask */
#define AG903_DDR_MCSR_WLF_POS                             17                                                            /** DDRMCSR WLF-bit position */
#define AG903_DDR_MCSR_WLF_MSK                             (0x1UL << AG903_DDR_MCSR_WLF_POS)                             /** DDRMCSR WLF-bit mask */
#define AG903_DDR_MCSR_WSTA_POS                            24                                                            /** DDRMCSR WSTA-bit position */
#define AG903_DDR_MCSR_WSTA_MSK                            (0x1UL << AG903_DDR_MCSR_WSTA_POS)                            /** DDRMCSR WSTA-bit mask */
#define AG903_DDR_MCSR_SRST_POS                            31                                                            /** DDRMCSR SRST-bit position */
#define AG903_DDR_MCSR_SRST_MSK                            (0x1UL << AG903_DDR_MCSR_SRST_POS)                            /** DDRMCSR SRST-bit mask */

#define AG903_DDR_MRSVR0_MR_POS                            0                                                             /** DDRMRSVR0 MR-bit position */
#define AG903_DDR_MRSVR0_MR_MSK                            (0x3fffUL << AG903_DDR_MRSVR0_MR_POS)                         /** DDRMRSVR0 MR-bit mask */
#define AG903_DDR_MRSVR0_EXTMR_POS                         16                                                            /** DDRMRSVR0 EXTMR-bit position */
#define AG903_DDR_MRSVR0_EXTMR_MSK                         (0x3fffUL << AG903_DDR_MRSVR0_EXTMR_POS)                      /** DDRMRSVR0 EXTMR-bit mask */

#define AG903_DDR_MRSVR1_EMR2_POS                          0                                                             /** DDRMRSVR1 EMR2-bit position */
#define AG903_DDR_MRSVR1_EMR2_MSK                          (0x3fffUL << AG903_DDR_MRSVR1_EMR2_POS)                       /** DDRMRSVR1 EMR2-bit mask */
#define AG903_DDR_MRSVR1_EMR3_POS                          16                                                            /** DDRMRSVR1 EMR3-bit position */
#define AG903_DDR_MRSVR1_EMR3_MSK                          (0x3fffUL << AG903_DDR_MRSVR1_EMR3_POS)                       /** DDRMRSVR1 EMR3-bit mask */

#define AG903_DDR_EXRANKR_RNK0_SIZE_POS                    0                                                             /** DDREXRANKR RNK0_SIZE-bit position */
#define AG903_DDR_EXRANKR_RNK0_SIZE_MSK                    (0x7UL << AG903_DDR_EXRANKR_RNK0_SIZE_POS)                    /** DDREXRANKR RNK0_SIZE-bit mask */
#define AG903_DDR_EXRANKR_RNK0_TYPE_POS                    4                                                             /** DDREXRANKR RNK0_TYPE-bit position */
#define AG903_DDR_EXRANKR_RNK0_TYPE_MSK                    (0x7UL << AG903_DDR_EXRANKR_RNK0_TYPE_POS)                    /** DDREXRANKR RNK0_TYPE-bit mask */
#define AG903_DDR_EXRANKR_RNK1_SIZE_POS                    8                                                             /** DDREXRANKR RNK1_SIZE-bit position */
#define AG903_DDR_EXRANKR_RNK1_SIZE_MSK                    (0x7UL << AG903_DDR_EXRANKR_RNK1_SIZE_POS)                    /** DDREXRANKR RNK1_SIZE-bit mask */
#define AG903_DDR_EXRANKR_RNK1_TYPE_POS                    12                                                            /** DDREXRANKR RNK1_TYPE-bit position */
#define AG903_DDR_EXRANKR_RNK1_TYPE_MSK                    (0x7UL << AG903_DDR_EXRANKR_RNK1_TYPE_POS)                    /** DDREXRANKR RNK1_TYPE-bit mask */
#define AG903_DDR_EXRANKR_RNK1_EN_POS                      16                                                            /** DDREXRANKR RNK1_EN-bit position */
#define AG903_DDR_EXRANKR_RNK1_EN_MSK                      (0x1UL << AG903_DDR_EXRANKR_RNK1_EN_POS)                      /** DDREXRANKR RNK1_EN-bit mask */
#define AG903_DDR_EXRANKR_RNK0_BASE_POS                    24                                                            /** DDREXRANKR RNK0_BASE-bit position */
#define AG903_DDR_EXRANKR_RNK0_BASE_MSK                    (0xffUL << AG903_DDR_EXRANKR_RNK0_BASE_POS)                   /** DDREXRANKR RNK0_BASE-bit mask */

#define AG903_DDR_TMPR0_TRAS_POS                           0                                                             /** DDRTMPR0 TRAS-bit position */
#define AG903_DDR_TMPR0_TRAS_MSK                           (0x1fUL << AG903_DDR_TMPR0_TRAS_POS)                          /** DDRTMPR0 TRAS-bit mask */
#define AG903_DDR_TMPR0_TRC_POS                            8                                                             /** DDRTMPR0 TRC-bit position */
#define AG903_DDR_TMPR0_TRC_MSK                            (0x3fUL << AG903_DDR_TMPR0_TRC_POS)                           /** DDRTMPR0 TRC-bit mask */
#define AG903_DDR_TMPR0_TFAW_POS                           16                                                            /** DDRTMPR0 TFAW-bit position */
#define AG903_DDR_TMPR0_TFAW_MSK                           (0x1fUL << AG903_DDR_TMPR0_TFAW_POS)                          /** DDRTMPR0 TFAW-bit mask */
#define AG903_DDR_TMPR0_TRFC_POS                           24                                                            /** DDRTMPR0 TRFC-bit position */
#define AG903_DDR_TMPR0_TRFC_MSK                           (0xffUL << AG903_DDR_TMPR0_TRFC_POS)                          /** DDRTMPR0 TRFC-bit mask */

#define AG903_DDR_TMPR1_TRCD_POS                           0                                                             /** DDRTMPR1 TRCD-bit position */
#define AG903_DDR_TMPR1_TRCD_MSK                           (0xfUL << AG903_DDR_TMPR1_TRCD_POS)                           /** DDRTMPR1 TRCD-bit mask */
#define AG903_DDR_TMPR1_TRRD_POS                           4                                                             /** DDRTMPR1 TRRD-bit position */
#define AG903_DDR_TMPR1_TRRD_MSK                           (0xfUL << AG903_DDR_TMPR1_TRRD_POS)                           /** DDRTMPR1 TRRD-bit mask */
#define AG903_DDR_TMPR1_TRP_POS                            8                                                             /** DDRTMPR1 TRP-bit position */
#define AG903_DDR_TMPR1_TRP_MSK                            (0xfUL << AG903_DDR_TMPR1_TRP_POS)                            /** DDRTMPR1 TRP-bit mask */
#define AG903_DDR_TMPR1_TMRD_POS                           12                                                            /** DDRTMPR1 TMRD-bit position */
#define AG903_DDR_TMPR1_TMRD_MSK                           (0xfUL << AG903_DDR_TMPR1_TMRD_POS)                           /** DDRTMPR1 TMRD-bit mask */
#define AG903_DDR_TMPR1_TMOD_POS                           16                                                            /** DDRTMPR1 TMOD-bit position */
#define AG903_DDR_TMPR1_TMOD_MSK                           (0xfUL << AG903_DDR_TMPR1_TMOD_POS)                           /** DDRTMPR1 TMOD-bit mask */
#define AG903_DDR_TMPR1_TWR_POS                            20                                                            /** DDRTMPR1 TWR-bit position */
#define AG903_DDR_TMPR1_TWR_MSK                            (0xfUL << AG903_DDR_TMPR1_TWR_POS)                            /** DDRTMPR1 TWR-bit mask */
#define AG903_DDR_TMPR1_TRTP_POS                           24                                                            /** DDRTMPR1 TRTP-bit position */
#define AG903_DDR_TMPR1_TRTP_MSK                           (0x7UL << AG903_DDR_TMPR1_TRTP_POS)                           /** DDRTMPR1 TRTP-bit mask */
#define AG903_DDR_TMPR1_TWTR_POS                           28                                                            /** DDRTMPR1 TWTR-bit position */
#define AG903_DDR_TMPR1_TWTR_MSK                           (0x7UL << AG903_DDR_TMPR1_TWTR_POS)                           /** DDRTMPR1 TWTR-bit mask */

#define AG903_DDR_TMPR2_TREFI_POS                          0                                                             /** DDRTMPR2 TREFI-bit position */
#define AG903_DDR_TMPR2_TREFI_MSK                          (0xffUL << AG903_DDR_TMPR2_TREFI_POS)                         /** DDRTMPR2 TREFI-bit mask */
#define AG903_DDR_TMPR2_TXSR_POS                           8                                                             /** DDRTMPR2 TXSR-bit position */
#define AG903_DDR_TMPR2_TXSR_MSK                           (0xffUL << AG903_DDR_TMPR2_TXSR_POS)                          /** DDRTMPR2 TXSR-bit mask */
#define AG903_DDR_TMPR2_TRTW_POS                           24                                                            /** DDRTMPR2 TRTW-bit position */
#define AG903_DDR_TMPR2_TRTW_MSK                           (0x3UL << AG903_DDR_TMPR2_TRTW_POS)                           /** DDRTMPR2 TRTW-bit mask */
#define AG903_DDR_TMPR2_TRTR_POS                           26                                                            /** DDRTMPR2 TRTR-bit position */
#define AG903_DDR_TMPR2_TRTR_MSK                           (0x3UL << AG903_DDR_TMPR2_TRTR_POS)                           /** DDRTMPR2 TRTR-bit mask */
#define AG903_DDR_TMPR2_TWTW_POS                           28                                                            /** DDRTMPR2 TWTW-bit position */
#define AG903_DDR_TMPR2_TWTW_MSK                           (0x3UL << AG903_DDR_TMPR2_TWTW_POS)                           /** DDRTMPR2 TWTW-bit mask */
#define AG903_DDR_TMPR2_TWTR_POS                           30                                                            /** DDRTMPR2 TWTR-bit position */
#define AG903_DDR_TMPR2_TWTR_MSK                           (0x3UL << AG903_DDR_TMPR2_TWTR_POS)                           /** DDRTMPR2 TWTR-bit mask */

#define AG903_DDR_PHYCR0_ODTMD_POS                         0                                                             /** DDRPHYCR0 ODTMD-bit position */
#define AG903_DDR_PHYCR0_ODTMD_MSK                         (0x7UL << AG903_DDR_PHYCR0_ODTMD_POS)                         /** DDRPHYCR0 ODTMD-bit mask */
#define AG903_DDR_PHYCR0_DQSB_POS                          3                                                             /** DDRPHYCR0 DQSB-bit position */
#define AG903_DDR_PHYCR0_DQSB_MSK                          (0x1UL << AG903_DDR_PHYCR0_DQSB_POS)                          /** DDRPHYCR0 DQSB-bit mask */
#define AG903_DDR_PHYCR0_ODTDM_POS                         4                                                             /** DDRPHYCR0 ODTDM-bit position */
#define AG903_DDR_PHYCR0_ODTDM_MSK                         (0x1UL << AG903_DDR_PHYCR0_ODTDM_POS)                         /** DDRPHYCR0 ODTDM-bit mask */
#define AG903_DDR_PHYCR0_DQSLF_POS                         5                                                             /** DDRPHYCR0 DQSLF-bit position */
#define AG903_DDR_PHYCR0_DQSLF_MSK                         (0x1UL << AG903_DDR_PHYCR0_DQSLF_POS)                         /** DDRPHYCR0 DQSLF-bit mask */
#define AG903_DDR_PHYCR0_IO18V_POS                         6                                                             /** DDRPHYCR0 IO18V-bit position */
#define AG903_DDR_PHYCR0_IO18V_MSK                         (0x1UL << AG903_DDR_PHYCR0_IO18V_POS)                         /** DDRPHYCR0 IO18V-bit mask */
#define AG903_DDR_PHYCR0_ACPD_POS                          7                                                             /** DDRPHYCR0 ACPD-bit position */
#define AG903_DDR_PHYCR0_ACPD_MSK                          (0x1UL << AG903_DDR_PHYCR0_ACPD_POS)                          /** DDRPHYCR0 ACPD-bit mask */
#define AG903_DDR_PHYCR0_ODTE_POS                          8                                                             /** DDRPHYCR0 ODTE-bit position */
#define AG903_DDR_PHYCR0_ODTE_MSK                          (0x1UL << AG903_DDR_PHYCR0_ODTE_POS)                          /** DDRPHYCR0 ODTE-bit mask */
#define AG903_DDR_PHYCR0_CMDE_POS                          9                                                             /** DDRPHYCR0 CMDE-bit position */
#define AG903_DDR_PHYCR0_CMDE_MSK                          (0x1UL << AG903_DDR_PHYCR0_CMDE_POS)                          /** DDRPHYCR0 CMDE-bit mask */
#define AG903_DDR_PHYCR0_CLKE_POS                          10                                                            /** DDRPHYCR0 CLKE-bit position */
#define AG903_DDR_PHYCR0_CLKE_MSK                          (0x1UL << AG903_DDR_PHYCR0_CLKE_POS)                          /** DDRPHYCR0 CLKE-bit mask */
#define AG903_DDR_PHYCR0_DQRE_POS                          11                                                            /** DDRPHYCR0 DQRE-bit position */
#define AG903_DDR_PHYCR0_DQRE_MSK                          (0x1UL << AG903_DDR_PHYCR0_DQRE_POS)                          /** DDRPHYCR0 DQRE-bit mask */
#define AG903_DDR_PHYCR0_CPHS_POS                          12                                                            /** DDRPHYCR0 CPHS-bit position */
#define AG903_DDR_PHYCR0_CPHS_MSK                          (0x1UL << AG903_DDR_PHYCR0_CPHS_POS)                          /** DDRPHYCR0 CPHS-bit mask */
#define AG903_DDR_PHYCR0_PCU_POS                           13                                                            /** DDRPHYCR0 PCU-bit position */
#define AG903_DDR_PHYCR0_PCU_MSK                           (0x1UL << AG903_DDR_PHYCR0_PCU_POS)                           /** DDRPHYCR0 PCU-bit mask */
#define AG903_DDR_PHYCR0_SBIAS_POS                         14                                                            /** DDRPHYCR0 SBIAS-bit position */
#define AG903_DDR_PHYCR0_SBIAS_MSK                         (0x1UL << AG903_DDR_PHYCR0_SBIAS_POS)                         /** DDRPHYCR0 SBIAS-bit mask */
#define AG903_DDR_PHYCR0_ADPD_POS                          15                                                            /** DDRPHYCR0 ADPD-bit position */
#define AG903_DDR_PHYCR0_ADPD_MSK                          (0x1UL << AG903_DDR_PHYCR0_ADPD_POS)                          /** DDRPHYCR0 ADPD-bit mask */
#define AG903_DDR_PHYCR0_FLDC_POS                          16                                                            /** DDRPHYCR0 FLDC-bit position */
#define AG903_DDR_PHYCR0_FLDC_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLDC_POS)                          /** DDRPHYCR0 FLDC-bit mask */
#define AG903_DDR_PHYCR0_FLD0_POS                          24                                                            /** DDRPHYCR0 FLD0-bit position */
#define AG903_DDR_PHYCR0_FLD0_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD0_POS)                          /** DDRPHYCR0 FLD0-bit mask */
#define AG903_DDR_PHYCR0_FLD1_POS                          25                                                            /** DDRPHYCR0 FLD1-bit position */
#define AG903_DDR_PHYCR0_FLD1_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD1_POS)                          /** DDRPHYCR0 FLD1-bit mask */
#define AG903_DDR_PHYCR0_FLD2_POS                          26                                                            /** DDRPHYCR0 FLD2-bit position */
#define AG903_DDR_PHYCR0_FLD2_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD2_POS)                          /** DDRPHYCR0 FLD2-bit mask */
#define AG903_DDR_PHYCR0_FLD3_POS                          27                                                            /** DDRPHYCR0 FLD3-bit position */
#define AG903_DDR_PHYCR0_FLD3_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD3_POS)                          /** DDRPHYCR0 FLD3-bit mask */
#define AG903_DDR_PHYCR0_FLD4_POS                          28                                                            /** DDRPHYCR0 FLD4-bit position */
#define AG903_DDR_PHYCR0_FLD4_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD4_POS)                          /** DDRPHYCR0 FLD4-bit mask */
#define AG903_DDR_PHYCR0_FLD5_POS                          29                                                            /** DDRPHYCR0 FLD5-bit position */
#define AG903_DDR_PHYCR0_FLD5_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD5_POS)                          /** DDRPHYCR0 FLD5-bit mask */
#define AG903_DDR_PHYCR0_FLD6_POS                          30                                                            /** DDRPHYCR0 FLD6-bit position */
#define AG903_DDR_PHYCR0_FLD6_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD6_POS)                          /** DDRPHYCR0 FLD6-bit mask */
#define AG903_DDR_PHYCR0_FLD7_POS                          31                                                            /** DDRPHYCR0 FLD7-bit position */
#define AG903_DDR_PHYCR0_FLD7_MSK                          (0x1UL << AG903_DDR_PHYCR0_FLD7_POS)                          /** DDRPHYCR0 FLD7-bit mask */

#define AG903_DDR_PHYRDTR_DLLSEL0_POS                      0                                                             /** DDRPHYRDTR DLLSEL0-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL0_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL0_POS)                      /** DDRPHYRDTR DLLSEL0-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL1_POS                      4                                                             /** DDRPHYRDTR DLLSEL1-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL1_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL1_POS)                      /** DDRPHYRDTR DLLSEL1-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL2_POS                      8                                                             /** DDRPHYRDTR DLLSEL2-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL2_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL2_POS)                      /** DDRPHYRDTR DLLSEL2-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL3_POS                      12                                                            /** DDRPHYRDTR DLLSEL3-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL3_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL3_POS)                      /** DDRPHYRDTR DLLSEL3-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL4_POS                      16                                                            /** DDRPHYRDTR DLLSEL4-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL4_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL4_POS)                      /** DDRPHYRDTR DLLSEL4-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL5_POS                      20                                                            /** DDRPHYRDTR DLLSEL5-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL5_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL5_POS)                      /** DDRPHYRDTR DLLSEL5-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL6_POS                      24                                                            /** DDRPHYRDTR DLLSEL6-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL6_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL6_POS)                      /** DDRPHYRDTR DLLSEL6-bit mask */
#define AG903_DDR_PHYRDTR_DLLSEL7_POS                      28                                                            /** DDRPHYRDTR DLLSEL7-bit position */
#define AG903_DDR_PHYRDTR_DLLSEL7_MSK                      (0x7UL << AG903_DDR_PHYRDTR_DLLSEL7_POS)                      /** DDRPHYRDTR DLLSEL7-bit mask */

#define AG903_DDR_COMPBLKCR_COMP_SEL_POS                   0                                                             /** DDRCOMPBLKCR COMP_SEL-bit position */
#define AG903_DDR_COMPBLKCR_COMP_SEL_MSK                   (0x1UL << AG903_DDR_COMPBLKCR_COMP_SEL_POS)                   /** DDRCOMPBLKCR COMP_SEL-bit mask */
#define AG903_DDR_COMPBLKCR_DIP_POS                        1                                                             /** DDRCOMPBLKCR DIP-bit position */
#define AG903_DDR_COMPBLKCR_DIP_MSK                        (0x3fUL << AG903_DDR_COMPBLKCR_DIP_POS)                       /** DDRCOMPBLKCR DIP-bit mask */
#define AG903_DDR_COMPBLKCR_DIN_POS                        7                                                             /** DDRCOMPBLKCR DIN-bit position */
#define AG903_DDR_COMPBLKCR_DIN_MSK                        (0x3fUL << AG903_DDR_COMPBLKCR_DIN_POS)                       /** DDRCOMPBLKCR DIN-bit mask */
#define AG903_DDR_COMPBLKCR_DOP_POS                        13                                                            /** DDRCOMPBLKCR DOP-bit position */
#define AG903_DDR_COMPBLKCR_DOP_MSK                        (0x3fUL << AG903_DDR_COMPBLKCR_DOP_POS)                       /** DDRCOMPBLKCR DOP-bit mask */
#define AG903_DDR_COMPBLKCR_DON_POS                        19                                                            /** DDRCOMPBLKCR DON-bit position */
#define AG903_DDR_COMPBLKCR_DON_MSK                        (0x3fUL << AG903_DDR_COMPBLKCR_DON_POS)                       /** DDRCOMPBLKCR DON-bit mask */

#define AG903_DDR_APDCR_PDNT_POS                           0                                                             /** DDRAPDCR PDNT-bit position */
#define AG903_DDR_APDCR_PDNT_MSK                           (0xfffUL << AG903_DDR_APDCR_PDNT_POS)                         /** DDRAPDCR PDNT-bit mask */
#define AG903_DDR_APDCR_PDNE_POS                           12                                                            /** DDRAPDCR PDNE-bit position */
#define AG903_DDR_APDCR_PDNE_MSK                           (0x1UL << AG903_DDR_APDCR_PDNE_POS)                           /** DDRAPDCR PDNE-bit mask */
#define AG903_DDR_APDCR_SREFT_POS                          16                                                            /** DDRAPDCR SREFT-bit position */
#define AG903_DDR_APDCR_SREFT_MSK                          (0xfffUL << AG903_DDR_APDCR_SREFT_POS)                        /** DDRAPDCR SREFT-bit mask */
#define AG903_DDR_APDCR_SREFE_POS                          28                                                            /** DDRAPDCR SREFE-bit position */
#define AG903_DDR_APDCR_SREFE_MSK                          (0x1UL << AG903_DDR_APDCR_SREFE_POS)                          /** DDRAPDCR SREFE-bit mask */

#define AG903_DDR_CHARBRA_HP_POS                           0                                                             /** DDRCHARBRA HP-bit position */
#define AG903_DDR_CHARBRA_HP_MSK                           (0xffUL << AG903_DDR_CHARBRA_HP_POS)                          /** DDRCHARBRA HP-bit mask */
#define AG903_DDR_CHARBRA_BOA_POS                          8                                                             /** DDRCHARBRA BOA-bit position */
#define AG903_DDR_CHARBRA_BOA_MSK                          (0xffUL << AG903_DDR_CHARBRA_BOA_POS)                         /** DDRCHARBRA BOA-bit mask */
#define AG903_DDR_CHARBRA_GGCNT_POS                        24                                                            /** DDRCHARBRA GGCNT-bit position */
#define AG903_DDR_CHARBRA_GGCNT_MSK                        (0x1fUL << AG903_DDR_CHARBRA_GGCNT_POS)                       /** DDRCHARBRA GGCNT-bit mask */
#define AG903_DDR_CHARBRA_IRWG_POS                         30                                                            /** DDRCHARBRA IRWG-bit position */
#define AG903_DDR_CHARBRA_IRWG_MSK                         (0x1UL << AG903_DDR_CHARBRA_IRWG_POS)                         /** DDRCHARBRA IRWG-bit mask */
#define AG903_DDR_CHARBRA_RWG_POS                          31                                                            /** DDRCHARBRA RWG-bit position */
#define AG903_DDR_CHARBRA_RWG_MSK                          (0x1UL << AG903_DDR_CHARBRA_RWG_POS)                          /** DDRCHARBRA RWG-bit mask */

#define AG903_DDR_CHGNTRA_ARB_CNT0_POS                     0                                                             /** DDRCHGNTRA ARB_CNT0-bit position */
#define AG903_DDR_CHGNTRA_ARB_CNT0_MSK                     (0x1fUL << AG903_DDR_CHGNTRA_ARB_CNT0_POS)                    /** DDRCHGNTRA ARB_CNT0-bit mask */
#define AG903_DDR_CHGNTRA_ARB_CNT1_POS                     8                                                             /** DDRCHGNTRA ARB_CNT1-bit position */
#define AG903_DDR_CHGNTRA_ARB_CNT1_MSK                     (0x1fUL << AG903_DDR_CHGNTRA_ARB_CNT1_POS)                    /** DDRCHGNTRA ARB_CNT1-bit mask */
#define AG903_DDR_CHGNTRA_ARB_CNT2_POS                     16                                                            /** DDRCHGNTRA ARB_CNT2-bit position */
#define AG903_DDR_CHGNTRA_ARB_CNT2_MSK                     (0x1fUL << AG903_DDR_CHGNTRA_ARB_CNT2_POS)                    /** DDRCHGNTRA ARB_CNT2-bit mask */
#define AG903_DDR_CHGNTRA_ARB_CNT3_POS                     24                                                            /** DDRCHGNTRA ARB_CNT3-bit position */
#define AG903_DDR_CHGNTRA_ARB_CNT3_MSK                     (0x1fUL << AG903_DDR_CHGNTRA_ARB_CNT3_POS)                    /** DDRCHGNTRA ARB_CNT3-bit mask */

#define AG903_DDR_CHGNTRB_ARB_CNT4_POS                     0                                                             /** DDRCHGNTRB ARB_CNT4-bit position */
#define AG903_DDR_CHGNTRB_ARB_CNT4_MSK                     (0x1fUL << AG903_DDR_CHGNTRB_ARB_CNT4_POS)                    /** DDRCHGNTRB ARB_CNT4-bit mask */
#define AG903_DDR_CHGNTRB_ARB_CNT5_POS                     8                                                             /** DDRCHGNTRB ARB_CNT5-bit position */
#define AG903_DDR_CHGNTRB_ARB_CNT5_MSK                     (0x1fUL << AG903_DDR_CHGNTRB_ARB_CNT5_POS)                    /** DDRCHGNTRB ARB_CNT5-bit mask */
#define AG903_DDR_CHGNTRB_ARB_CNT6_POS                     16                                                            /** DDRCHGNTRB ARB_CNT6-bit position */
#define AG903_DDR_CHGNTRB_ARB_CNT6_MSK                     (0x1fUL << AG903_DDR_CHGNTRB_ARB_CNT6_POS)                    /** DDRCHGNTRB ARB_CNT6-bit mask */
#define AG903_DDR_CHGNTRB_ARB_CNT7_POS                     24                                                            /** DDRCHGNTRB ARB_CNT7-bit position */
#define AG903_DDR_CHGNTRB_ARB_CNT7_MSK                     (0x1fUL << AG903_DDR_CHGNTRB_ARB_CNT7_POS)                    /** DDRCHGNTRB ARB_CNT7-bit mask */

#define AG903_DDR_PHYWRTMR_TWLAT_POS                       0                                                             /** DDRPHYWRTMR TWLAT-bit position */
#define AG903_DDR_PHYWRTMR_TWLAT_MSK                       (0xfUL << AG903_DDR_PHYWRTMR_TWLAT_POS)                       /** DDRPHYWRTMR TWLAT-bit mask */
#define AG903_DDR_PHYWRTMR_TWDEN_POS                       4                                                             /** DDRPHYWRTMR TWDEN-bit position */
#define AG903_DDR_PHYWRTMR_TWDEN_MSK                       (0x3UL << AG903_DDR_PHYWRTMR_TWDEN_POS)                       /** DDRPHYWRTMR TWDEN-bit mask */
#define AG903_DDR_PHYWRTMR_TRDEN_POS                       16                                                            /** DDRPHYWRTMR TRDEN-bit position */
#define AG903_DDR_PHYWRTMR_TRDEN_MSK                       (0xfUL << AG903_DDR_PHYWRTMR_TRDEN_POS)                       /** DDRPHYWRTMR TRDEN-bit mask */
#define AG903_DDR_PHYWRTMR_TRDLAT_POS                      20                                                            /** DDRPHYWRTMR TRDLAT-bit position */
#define AG903_DDR_PHYWRTMR_TRDLAT_MSK                      (0xfUL << AG903_DDR_PHYWRTMR_TRDLAT_POS)                      /** DDRPHYWRTMR TRDLAT-bit mask */

#define AG903_DDR_FLUSHCR_CMDFE_POS                        0                                                             /** DDRFLUSHCR CMDFE-bit position */
#define AG903_DDR_FLUSHCR_CMDFE_MSK                        (0xffUL << AG903_DDR_FLUSHCR_CMDFE_POS)                       /** DDRFLUSHCR CMDFE-bit mask */
#define AG903_DDR_FLUSHCR_FINTE_POS                        8                                                             /** DDRFLUSHCR FINTE-bit position */
#define AG903_DDR_FLUSHCR_FINTE_MSK                        (0xffUL << AG903_DDR_FLUSHCR_FINTE_POS)                       /** DDRFLUSHCR FINTE-bit mask */
#define AG903_DDR_FLUSHCR_DINTE_POS                        16                                                            /** DDRFLUSHCR DINTE-bit position */
#define AG903_DDR_FLUSHCR_DINTE_MSK                        (0x1UL << AG903_DDR_FLUSHCR_DINTE_POS)                        /** DDRFLUSHCR DINTE-bit mask */

#define AG903_DDR_FLUSHSR_FLUSH_DONE_POS                   0                                                             /** DDRFLUSHSR FLUSH_DONE-bit position */
#define AG903_DDR_FLUSHSR_FLUSH_DONE_MSK                   (0xffUL << AG903_DDR_FLUSHSR_FLUSH_DONE_POS)                  /** DDRFLUSHSR FLUSH_DONE-bit mask */
#define AG903_DDR_FLUSHSR_DBGHIT_POS                       8                                                             /** DDRFLUSHSR DBGHIT-bit position */
#define AG903_DDR_FLUSHSR_DBGHIT_MSK                       (0x1UL << AG903_DDR_FLUSHSR_DBGHIT_POS)                       /** DDRFLUSHSR DBGHIT-bit mask */

#define AG903_DDR_SPLITCR_SD0_POS                          0                                                             /** DDRSPLITCR SD0-bit position */
#define AG903_DDR_SPLITCR_SD0_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD0_POS)                          /** DDRSPLITCR SD0-bit mask */
#define AG903_DDR_SPLITCR_SD1_POS                          1                                                             /** DDRSPLITCR SD1-bit position */
#define AG903_DDR_SPLITCR_SD1_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD1_POS)                          /** DDRSPLITCR SD1-bit mask */
#define AG903_DDR_SPLITCR_SD2_POS                          2                                                             /** DDRSPLITCR SD2-bit position */
#define AG903_DDR_SPLITCR_SD2_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD2_POS)                          /** DDRSPLITCR SD2-bit mask */
#define AG903_DDR_SPLITCR_SD3_POS                          3                                                             /** DDRSPLITCR SD3-bit position */
#define AG903_DDR_SPLITCR_SD3_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD3_POS)                          /** DDRSPLITCR SD3-bit mask */
#define AG903_DDR_SPLITCR_SD4_POS                          4                                                             /** DDRSPLITCR SD4-bit position */
#define AG903_DDR_SPLITCR_SD4_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD4_POS)                          /** DDRSPLITCR SD4-bit mask */
#define AG903_DDR_SPLITCR_SD5_POS                          5                                                             /** DDRSPLITCR SD5-bit position */
#define AG903_DDR_SPLITCR_SD5_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD5_POS)                          /** DDRSPLITCR SD5-bit mask */
#define AG903_DDR_SPLITCR_SD6_POS                          6                                                             /** DDRSPLITCR SD6-bit position */
#define AG903_DDR_SPLITCR_SD6_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD6_POS)                          /** DDRSPLITCR SD6-bit mask */
#define AG903_DDR_SPLITCR_SD7_POS                          7                                                             /** DDRSPLITCR SD7-bit position */
#define AG903_DDR_SPLITCR_SD7_MSK                          (0x1UL << AG903_DDR_SPLITCR_SD7_POS)                          /** DDRSPLITCR SD7-bit mask */
#define AG903_DDR_SPLITCR_HP0_POS                          8                                                             /** DDRSPLITCR HP0-bit position */
#define AG903_DDR_SPLITCR_HP0_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP0_POS)                          /** DDRSPLITCR HP0-bit mask */
#define AG903_DDR_SPLITCR_HP1_POS                          10                                                            /** DDRSPLITCR HP1-bit position */
#define AG903_DDR_SPLITCR_HP1_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP1_POS)                          /** DDRSPLITCR HP1-bit mask */
#define AG903_DDR_SPLITCR_HP2_POS                          12                                                            /** DDRSPLITCR HP2-bit position */
#define AG903_DDR_SPLITCR_HP2_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP2_POS)                          /** DDRSPLITCR HP2-bit mask */
#define AG903_DDR_SPLITCR_HP3_POS                          14                                                            /** DDRSPLITCR HP3-bit position */
#define AG903_DDR_SPLITCR_HP3_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP3_POS)                          /** DDRSPLITCR HP3-bit mask */
#define AG903_DDR_SPLITCR_HP4_POS                          16                                                            /** DDRSPLITCR HP4-bit position */
#define AG903_DDR_SPLITCR_HP4_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP4_POS)                          /** DDRSPLITCR HP4-bit mask */
#define AG903_DDR_SPLITCR_HP5_POS                          18                                                            /** DDRSPLITCR HP5-bit position */
#define AG903_DDR_SPLITCR_HP5_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP5_POS)                          /** DDRSPLITCR HP5-bit mask */
#define AG903_DDR_SPLITCR_HP6_POS                          20                                                            /** DDRSPLITCR HP6-bit position */
#define AG903_DDR_SPLITCR_HP6_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP6_POS)                          /** DDRSPLITCR HP6-bit mask */
#define AG903_DDR_SPLITCR_HP7_POS                          22                                                            /** DDRSPLITCR HP7-bit position */
#define AG903_DDR_SPLITCR_HP7_MSK                          (0x3UL << AG903_DDR_SPLITCR_HP7_POS)                          /** DDRSPLITCR HP7-bit mask */

#define AG903_DDR_UPDCR_TDLLUP_POS                         0                                                             /** DDRUPDCR TDLLUP-bit position */
#define AG903_DDR_UPDCR_TDLLUP_MSK                         (0xffUL << AG903_DDR_UPDCR_TDLLUP_POS)                        /** DDRUPDCR TDLLUP-bit mask */
#define AG903_DDR_UPDCR_TWLVUP_POS                         8                                                             /** DDRUPDCR TWLVUP-bit position */
#define AG903_DDR_UPDCR_TWLVUP_MSK                         (0xffUL << AG903_DDR_UPDCR_TWLVUP_POS)                        /** DDRUPDCR TWLVUP-bit mask */
#define AG903_DDR_UPDCR_ZQUD_POS                           16                                                            /** DDRUPDCR ZQUD-bit position */
#define AG903_DDR_UPDCR_ZQUD_MSK                           (0x3UL << AG903_DDR_UPDCR_ZQUD_POS)                           /** DDRUPDCR ZQUD-bit mask */

#define AG903_DDR_REVR_REL_VER_POS                         0                                                             /** DDRREVR REL_VER-bit position */
#define AG903_DDR_REVR_REL_VER_MSK                         (0xffUL << AG903_DDR_REVR_REL_VER_POS)                        /** DDRREVR REL_VER-bit mask */
#define AG903_DDR_REVR_MINOR_VER_POS                       8                                                             /** DDRREVR MINOR_VER-bit position */
#define AG903_DDR_REVR_MINOR_VER_MSK                       (0xffUL << AG903_DDR_REVR_MINOR_VER_POS)                      /** DDRREVR MINOR_VER-bit mask */
#define AG903_DDR_REVR_MAJOR_VER_POS                       16                                                            /** DDRREVR MAJOR_VER-bit position */
#define AG903_DDR_REVR_MAJOR_VER_MSK                       (0xffUL << AG903_DDR_REVR_MAJOR_VER_POS)                      /** DDRREVR MAJOR_VER-bit mask */

#define AG903_DDR_FEATR1_CHCNT_POS                         0                                                             /** DDRFEATR1 CHCNT-bit position */
#define AG903_DDR_FEATR1_CHCNT_MSK                         (0x7UL << AG903_DDR_FEATR1_CHCNT_POS)                         /** DDRFEATR1 CHCNT-bit mask */
#define AG903_DDR_FEATR1_AMON_POS                          3                                                             /** DDRFEATR1 AMON-bit position */
#define AG903_DDR_FEATR1_AMON_MSK                          (0x7UL << AG903_DDR_FEATR1_AMON_POS)                          /** DDRFEATR1 AMON-bit mask */
#define AG903_DDR_FEATR1_MAXMW_POS                         6                                                             /** DDRFEATR1 MAXMW-bit position */
#define AG903_DDR_FEATR1_MAXMW_MSK                         (0x3UL << AG903_DDR_FEATR1_MAXMW_POS)                         /** DDRFEATR1 MAXMW-bit mask */
#define AG903_DDR_FEATR1_BT0_POS                           8                                                             /** DDRFEATR1 BT0-bit position */
#define AG903_DDR_FEATR1_BT0_MSK                           (0x1UL << AG903_DDR_FEATR1_BT0_POS)                           /** DDRFEATR1 BT0-bit mask */
#define AG903_DDR_FEATR1_BT1_POS                           9                                                             /** DDRFEATR1 BT1-bit position */
#define AG903_DDR_FEATR1_BT1_MSK                           (0x1UL << AG903_DDR_FEATR1_BT1_POS)                           /** DDRFEATR1 BT1-bit mask */
#define AG903_DDR_FEATR1_BT2_POS                           10                                                            /** DDRFEATR1 BT2-bit position */
#define AG903_DDR_FEATR1_BT2_MSK                           (0x1UL << AG903_DDR_FEATR1_BT2_POS)                           /** DDRFEATR1 BT2-bit mask */
#define AG903_DDR_FEATR1_BT3_POS                           11                                                            /** DDRFEATR1 BT3-bit position */
#define AG903_DDR_FEATR1_BT3_MSK                           (0x1UL << AG903_DDR_FEATR1_BT3_POS)                           /** DDRFEATR1 BT3-bit mask */
#define AG903_DDR_FEATR1_BT4_POS                           12                                                            /** DDRFEATR1 BT4-bit position */
#define AG903_DDR_FEATR1_BT4_MSK                           (0x1UL << AG903_DDR_FEATR1_BT4_POS)                           /** DDRFEATR1 BT4-bit mask */
#define AG903_DDR_FEATR1_BT5_POS                           13                                                            /** DDRFEATR1 BT5-bit position */
#define AG903_DDR_FEATR1_BT5_MSK                           (0x1UL << AG903_DDR_FEATR1_BT5_POS)                           /** DDRFEATR1 BT5-bit mask */
#define AG903_DDR_FEATR1_BT6_POS                           14                                                            /** DDRFEATR1 BT6-bit position */
#define AG903_DDR_FEATR1_BT6_MSK                           (0x1UL << AG903_DDR_FEATR1_BT6_POS)                           /** DDRFEATR1 BT6-bit mask */
#define AG903_DDR_FEATR1_BT7_POS                           15                                                            /** DDRFEATR1 BT7-bit position */
#define AG903_DDR_FEATR1_BT7_MSK                           (0x1UL << AG903_DDR_FEATR1_BT7_POS)                           /** DDRFEATR1 BT7-bit mask */
#define AG903_DDR_FEATR1_DW0_POS                           16                                                            /** DDRFEATR1 DW0-bit position */
#define AG903_DDR_FEATR1_DW0_MSK                           (0x1UL << AG903_DDR_FEATR1_DW0_POS)                           /** DDRFEATR1 DW0-bit mask */
#define AG903_DDR_FEATR1_DW1_POS                           17                                                            /** DDRFEATR1 DW1-bit position */
#define AG903_DDR_FEATR1_DW1_MSK                           (0x1UL << AG903_DDR_FEATR1_DW1_POS)                           /** DDRFEATR1 DW1-bit mask */
#define AG903_DDR_FEATR1_DW2_POS                           18                                                            /** DDRFEATR1 DW2-bit position */
#define AG903_DDR_FEATR1_DW2_MSK                           (0x1UL << AG903_DDR_FEATR1_DW2_POS)                           /** DDRFEATR1 DW2-bit mask */
#define AG903_DDR_FEATR1_DW3_POS                           19                                                            /** DDRFEATR1 DW3-bit position */
#define AG903_DDR_FEATR1_DW3_MSK                           (0x1UL << AG903_DDR_FEATR1_DW3_POS)                           /** DDRFEATR1 DW3-bit mask */
#define AG903_DDR_FEATR1_DW4_POS                           20                                                            /** DDRFEATR1 DW4-bit position */
#define AG903_DDR_FEATR1_DW4_MSK                           (0x1UL << AG903_DDR_FEATR1_DW4_POS)                           /** DDRFEATR1 DW4-bit mask */
#define AG903_DDR_FEATR1_DW5_POS                           21                                                            /** DDRFEATR1 DW5-bit position */
#define AG903_DDR_FEATR1_DW5_MSK                           (0x1UL << AG903_DDR_FEATR1_DW5_POS)                           /** DDRFEATR1 DW5-bit mask */
#define AG903_DDR_FEATR1_DW6_POS                           22                                                            /** DDRFEATR1 DW6-bit position */
#define AG903_DDR_FEATR1_DW6_MSK                           (0x1UL << AG903_DDR_FEATR1_DW6_POS)                           /** DDRFEATR1 DW6-bit mask */
#define AG903_DDR_FEATR1_DW7_POS                           23                                                            /** DDRFEATR1 DW7-bit position */
#define AG903_DDR_FEATR1_DW7_MSK                           (0x1UL << AG903_DDR_FEATR1_DW7_POS)                           /** DDRFEATR1 DW7-bit mask */
#define AG903_DDR_FEATR1_BNKNM_POS                         24                                                            /** DDRFEATR1 BNKNM-bit position */
#define AG903_DDR_FEATR1_BNKNM_MSK                         (0x1UL << AG903_DDR_FEATR1_BNKNM_POS)                         /** DDRFEATR1 BNKNM-bit mask */
#define AG903_DDR_FEATR1_BNKSW_POS                         25                                                            /** DDRFEATR1 BNKSW-bit position */
#define AG903_DDR_FEATR1_BNKSW_MSK                         (0x1UL << AG903_DDR_FEATR1_BNKSW_POS)                         /** DDRFEATR1 BNKSW-bit mask */

#define AG903_DDR_FEATR2_CM0_POS                           0                                                             /** DDRFEATR2 CM0-bit position */
#define AG903_DDR_FEATR2_CM0_MSK                           (0x3UL << AG903_DDR_FEATR2_CM0_POS)                           /** DDRFEATR2 CM0-bit mask */
#define AG903_DDR_FEATR2_SP0_POS                           2                                                             /** DDRFEATR2 SP0-bit position */
#define AG903_DDR_FEATR2_SP0_MSK                           (0x1UL << AG903_DDR_FEATR2_SP0_POS)                           /** DDRFEATR2 SP0-bit mask */
#define AG903_DDR_FEATR2_CB0_POS                           3                                                             /** DDRFEATR2 CB0-bit position */
#define AG903_DDR_FEATR2_CB0_MSK                           (0x1UL << AG903_DDR_FEATR2_CB0_POS)                           /** DDRFEATR2 CB0-bit mask */
#define AG903_DDR_FEATR2_CM1_POS                           4                                                             /** DDRFEATR2 CM1-bit position */
#define AG903_DDR_FEATR2_CM1_MSK                           (0x3UL << AG903_DDR_FEATR2_CM1_POS)                           /** DDRFEATR2 CM1-bit mask */
#define AG903_DDR_FEATR2_SP1_POS                           6                                                             /** DDRFEATR2 SP1-bit position */
#define AG903_DDR_FEATR2_SP1_MSK                           (0x1UL << AG903_DDR_FEATR2_SP1_POS)                           /** DDRFEATR2 SP1-bit mask */
#define AG903_DDR_FEATR2_CB1_POS                           7                                                             /** DDRFEATR2 CB1-bit position */
#define AG903_DDR_FEATR2_CB1_MSK                           (0x1UL << AG903_DDR_FEATR2_CB1_POS)                           /** DDRFEATR2 CB1-bit mask */
#define AG903_DDR_FEATR2_CM2_POS                           8                                                             /** DDRFEATR2 CM2-bit position */
#define AG903_DDR_FEATR2_CM2_MSK                           (0x3UL << AG903_DDR_FEATR2_CM2_POS)                           /** DDRFEATR2 CM2-bit mask */
#define AG903_DDR_FEATR2_SP2_POS                           10                                                            /** DDRFEATR2 SP2-bit position */
#define AG903_DDR_FEATR2_SP2_MSK                           (0x1UL << AG903_DDR_FEATR2_SP2_POS)                           /** DDRFEATR2 SP2-bit mask */
#define AG903_DDR_FEATR2_CB2_POS                           11                                                            /** DDRFEATR2 CB2-bit position */
#define AG903_DDR_FEATR2_CB2_MSK                           (0x1UL << AG903_DDR_FEATR2_CB2_POS)                           /** DDRFEATR2 CB2-bit mask */
#define AG903_DDR_FEATR2_CM3_POS                           12                                                            /** DDRFEATR2 CM3-bit position */
#define AG903_DDR_FEATR2_CM3_MSK                           (0x3UL << AG903_DDR_FEATR2_CM3_POS)                           /** DDRFEATR2 CM3-bit mask */
#define AG903_DDR_FEATR2_SP3_POS                           14                                                            /** DDRFEATR2 SP3-bit position */
#define AG903_DDR_FEATR2_SP3_MSK                           (0x1UL << AG903_DDR_FEATR2_SP3_POS)                           /** DDRFEATR2 SP3-bit mask */
#define AG903_DDR_FEATR2_CB3_POS                           15                                                            /** DDRFEATR2 CB3-bit position */
#define AG903_DDR_FEATR2_CB3_MSK                           (0x1UL << AG903_DDR_FEATR2_CB3_POS)                           /** DDRFEATR2 CB3-bit mask */
#define AG903_DDR_FEATR2_CM4_POS                           16                                                            /** DDRFEATR2 CM4-bit position */
#define AG903_DDR_FEATR2_CM4_MSK                           (0x3UL << AG903_DDR_FEATR2_CM4_POS)                           /** DDRFEATR2 CM4-bit mask */
#define AG903_DDR_FEATR2_SP4_POS                           18                                                            /** DDRFEATR2 SP4-bit position */
#define AG903_DDR_FEATR2_SP4_MSK                           (0x1UL << AG903_DDR_FEATR2_SP4_POS)                           /** DDRFEATR2 SP4-bit mask */
#define AG903_DDR_FEATR2_CB4_POS                           19                                                            /** DDRFEATR2 CB4-bit position */
#define AG903_DDR_FEATR2_CB4_MSK                           (0x1UL << AG903_DDR_FEATR2_CB4_POS)                           /** DDRFEATR2 CB4-bit mask */
#define AG903_DDR_FEATR2_CM5_POS                           20                                                            /** DDRFEATR2 CM5-bit position */
#define AG903_DDR_FEATR2_CM5_MSK                           (0x3UL << AG903_DDR_FEATR2_CM5_POS)                           /** DDRFEATR2 CM5-bit mask */
#define AG903_DDR_FEATR2_SP5_POS                           22                                                            /** DDRFEATR2 SP5-bit position */
#define AG903_DDR_FEATR2_SP5_MSK                           (0x1UL << AG903_DDR_FEATR2_SP5_POS)                           /** DDRFEATR2 SP5-bit mask */
#define AG903_DDR_FEATR2_CB5_POS                           23                                                            /** DDRFEATR2 CB5-bit position */
#define AG903_DDR_FEATR2_CB5_MSK                           (0x1UL << AG903_DDR_FEATR2_CB5_POS)                           /** DDRFEATR2 CB5-bit mask */
#define AG903_DDR_FEATR2_CM6_POS                           24                                                            /** DDRFEATR2 CM6-bit position */
#define AG903_DDR_FEATR2_CM6_MSK                           (0x3UL << AG903_DDR_FEATR2_CM6_POS)                           /** DDRFEATR2 CM6-bit mask */
#define AG903_DDR_FEATR2_SP6_POS                           26                                                            /** DDRFEATR2 SP6-bit position */
#define AG903_DDR_FEATR2_SP6_MSK                           (0x1UL << AG903_DDR_FEATR2_SP6_POS)                           /** DDRFEATR2 SP6-bit mask */
#define AG903_DDR_FEATR2_CB6_POS                           27                                                            /** DDRFEATR2 CB6-bit position */
#define AG903_DDR_FEATR2_CB6_MSK                           (0x1UL << AG903_DDR_FEATR2_CB6_POS)                           /** DDRFEATR2 CB6-bit mask */
#define AG903_DDR_FEATR2_CM7_POS                           28                                                            /** DDRFEATR2 CM7-bit position */
#define AG903_DDR_FEATR2_CM7_MSK                           (0x3UL << AG903_DDR_FEATR2_CM7_POS)                           /** DDRFEATR2 CM7-bit mask */
#define AG903_DDR_FEATR2_SP7_POS                           30                                                            /** DDRFEATR2 SP7-bit position */
#define AG903_DDR_FEATR2_SP7_MSK                           (0x1UL << AG903_DDR_FEATR2_SP7_POS)                           /** DDRFEATR2 SP7-bit mask */
#define AG903_DDR_FEATR2_CB7_POS                           31                                                            /** DDRFEATR2 CB7-bit position */
#define AG903_DDR_FEATR2_CB7_MSK                           (0x1UL << AG903_DDR_FEATR2_CB7_POS)                           /** DDRFEATR2 CB7-bit mask */

#define AG903_DDR_UDEFR_VALUE_POS                          0                                                             /** DDRUDEFR VALUE-bit position */
#define AG903_DDR_UDEFR_VALUE_MSK                          (0xffffffffUL << AG903_DDR_UDEFR_VALUE_POS)                   /** DDRUDEFR VALUE-bit mask */

#define AG903_DDR_WLEVELCR_TWL_POS                         0                                                             /** DDRWLEVELCR TWL-bit position */
#define AG903_DDR_WLEVELCR_TWL_MSK                         (0xffUL << AG903_DDR_WLEVELCR_TWL_POS)                        /** DDRWLEVELCR TWL-bit mask */
#define AG903_DDR_WLEVELCR_WHD0_POS                        16                                                            /** DDRWLEVELCR WHD0-bit position */
#define AG903_DDR_WLEVELCR_WHD0_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD0_POS)                        /** DDRWLEVELCR WHD0-bit mask */
#define AG903_DDR_WLEVELCR_WHD1_POS                        17                                                            /** DDRWLEVELCR WHD1-bit position */
#define AG903_DDR_WLEVELCR_WHD1_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD1_POS)                        /** DDRWLEVELCR WHD1-bit mask */
#define AG903_DDR_WLEVELCR_WHD2_POS                        18                                                            /** DDRWLEVELCR WHD2-bit position */
#define AG903_DDR_WLEVELCR_WHD2_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD2_POS)                        /** DDRWLEVELCR WHD2-bit mask */
#define AG903_DDR_WLEVELCR_WHD3_POS                        19                                                            /** DDRWLEVELCR WHD3-bit position */
#define AG903_DDR_WLEVELCR_WHD3_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD3_POS)                        /** DDRWLEVELCR WHD3-bit mask */
#define AG903_DDR_WLEVELCR_WHD4_POS                        20                                                            /** DDRWLEVELCR WHD4-bit position */
#define AG903_DDR_WLEVELCR_WHD4_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD4_POS)                        /** DDRWLEVELCR WHD4-bit mask */
#define AG903_DDR_WLEVELCR_WHD5_POS                        21                                                            /** DDRWLEVELCR WHD5-bit position */
#define AG903_DDR_WLEVELCR_WHD5_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD5_POS)                        /** DDRWLEVELCR WHD5-bit mask */
#define AG903_DDR_WLEVELCR_WHD6_POS                        22                                                            /** DDRWLEVELCR WHD6-bit position */
#define AG903_DDR_WLEVELCR_WHD6_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD6_POS)                        /** DDRWLEVELCR WHD6-bit mask */
#define AG903_DDR_WLEVELCR_WHD7_POS                        23                                                            /** DDRWLEVELCR WHD7-bit position */
#define AG903_DDR_WLEVELCR_WHD7_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WHD7_POS)                        /** DDRWLEVELCR WHD7-bit mask */
#define AG903_DDR_WLEVELCR_WLP0_POS                        24                                                            /** DDRWLEVELCR WLP0-bit position */
#define AG903_DDR_WLEVELCR_WLP0_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP0_POS)                        /** DDRWLEVELCR WLP0-bit mask */
#define AG903_DDR_WLEVELCR_WLP1_POS                        25                                                            /** DDRWLEVELCR WLP1-bit position */
#define AG903_DDR_WLEVELCR_WLP1_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP1_POS)                        /** DDRWLEVELCR WLP1-bit mask */
#define AG903_DDR_WLEVELCR_WLP2_POS                        26                                                            /** DDRWLEVELCR WLP2-bit position */
#define AG903_DDR_WLEVELCR_WLP2_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP2_POS)                        /** DDRWLEVELCR WLP2-bit mask */
#define AG903_DDR_WLEVELCR_WLP3_POS                        27                                                            /** DDRWLEVELCR WLP3-bit position */
#define AG903_DDR_WLEVELCR_WLP3_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP3_POS)                        /** DDRWLEVELCR WLP3-bit mask */
#define AG903_DDR_WLEVELCR_WLP4_POS                        28                                                            /** DDRWLEVELCR WLP4-bit position */
#define AG903_DDR_WLEVELCR_WLP4_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP4_POS)                        /** DDRWLEVELCR WLP4-bit mask */
#define AG903_DDR_WLEVELCR_WLP5_POS                        29                                                            /** DDRWLEVELCR WLP5-bit position */
#define AG903_DDR_WLEVELCR_WLP5_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP5_POS)                        /** DDRWLEVELCR WLP5-bit mask */
#define AG903_DDR_WLEVELCR_WLP6_POS                        30                                                            /** DDRWLEVELCR WLP6-bit position */
#define AG903_DDR_WLEVELCR_WLP6_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP6_POS)                        /** DDRWLEVELCR WLP6-bit mask */
#define AG903_DDR_WLEVELCR_WLP7_POS                        31                                                            /** DDRWLEVELCR WLP7-bit position */
#define AG903_DDR_WLEVELCR_WLP7_MSK                        (0x1UL << AG903_DDR_WLEVELCR_WLP7_POS)                        /** DDRWLEVELCR WLP7-bit mask */

#define AG903_DDR_WLEVELBHR_DELAY4_POS                     0                                                             /** DDRWLEVELBHR DELAY4-bit position */
#define AG903_DDR_WLEVELBHR_DELAY4_MSK                     (0x7fUL << AG903_DDR_WLEVELBHR_DELAY4_POS)                    /** DDRWLEVELBHR DELAY4-bit mask */
#define AG903_DDR_WLEVELBHR_DELAY5_POS                     8                                                             /** DDRWLEVELBHR DELAY5-bit position */
#define AG903_DDR_WLEVELBHR_DELAY5_MSK                     (0x7fUL << AG903_DDR_WLEVELBHR_DELAY5_POS)                    /** DDRWLEVELBHR DELAY5-bit mask */
#define AG903_DDR_WLEVELBHR_DELAY6_POS                     16                                                            /** DDRWLEVELBHR DELAY6-bit position */
#define AG903_DDR_WLEVELBHR_DELAY6_MSK                     (0x7fUL << AG903_DDR_WLEVELBHR_DELAY6_POS)                    /** DDRWLEVELBHR DELAY6-bit mask */
#define AG903_DDR_WLEVELBHR_DELAY7_POS                     24                                                            /** DDRWLEVELBHR DELAY7-bit position */
#define AG903_DDR_WLEVELBHR_DELAY7_MSK                     (0x7fUL << AG903_DDR_WLEVELBHR_DELAY7_POS)                    /** DDRWLEVELBHR DELAY7-bit mask */

#define AG903_DDR_WLEVELBLR_DELAY0_POS                     0                                                             /** DDRWLEVELBLR DELAY0-bit position */
#define AG903_DDR_WLEVELBLR_DELAY0_MSK                     (0x7fUL << AG903_DDR_WLEVELBLR_DELAY0_POS)                    /** DDRWLEVELBLR DELAY0-bit mask */
#define AG903_DDR_WLEVELBLR_DELAY1_POS                     8                                                             /** DDRWLEVELBLR DELAY1-bit position */
#define AG903_DDR_WLEVELBLR_DELAY1_MSK                     (0x7fUL << AG903_DDR_WLEVELBLR_DELAY1_POS)                    /** DDRWLEVELBLR DELAY1-bit mask */
#define AG903_DDR_WLEVELBLR_DELAY2_POS                     16                                                            /** DDRWLEVELBLR DELAY2-bit position */
#define AG903_DDR_WLEVELBLR_DELAY2_MSK                     (0x7fUL << AG903_DDR_WLEVELBLR_DELAY2_POS)                    /** DDRWLEVELBLR DELAY2-bit mask */
#define AG903_DDR_WLEVELBLR_DELAY3_POS                     24                                                            /** DDRWLEVELBLR DELAY3-bit position */
#define AG903_DDR_WLEVELBLR_DELAY3_MSK                     (0x7fUL << AG903_DDR_WLEVELBLR_DELAY3_POS)                    /** DDRWLEVELBLR DELAY3-bit mask */

#define AG903_DDR_PHYMISCR1_RDQS0_POS                      0                                                             /** DDRPHYMISCR1 RDQS0-bit position */
#define AG903_DDR_PHYMISCR1_RDQS0_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS0_POS)                      /** DDRPHYMISCR1 RDQS0-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS0_POS                      1                                                             /** DDRPHYMISCR1 WDQS0-bit position */
#define AG903_DDR_PHYMISCR1_WDQS0_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS0_POS)                      /** DDRPHYMISCR1 WDQS0-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS1_POS                      4                                                             /** DDRPHYMISCR1 RDQS1-bit position */
#define AG903_DDR_PHYMISCR1_RDQS1_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS1_POS)                      /** DDRPHYMISCR1 RDQS1-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS1_POS                      5                                                             /** DDRPHYMISCR1 WDQS1-bit position */
#define AG903_DDR_PHYMISCR1_WDQS1_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS1_POS)                      /** DDRPHYMISCR1 WDQS1-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS2_POS                      8                                                             /** DDRPHYMISCR1 RDQS2-bit position */
#define AG903_DDR_PHYMISCR1_RDQS2_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS2_POS)                      /** DDRPHYMISCR1 RDQS2-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS2_POS                      9                                                             /** DDRPHYMISCR1 WDQS2-bit position */
#define AG903_DDR_PHYMISCR1_WDQS2_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS2_POS)                      /** DDRPHYMISCR1 WDQS2-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS3_POS                      12                                                            /** DDRPHYMISCR1 RDQS3-bit position */
#define AG903_DDR_PHYMISCR1_RDQS3_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS3_POS)                      /** DDRPHYMISCR1 RDQS3-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS3_POS                      13                                                            /** DDRPHYMISCR1 WDQS3-bit position */
#define AG903_DDR_PHYMISCR1_WDQS3_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS3_POS)                      /** DDRPHYMISCR1 WDQS3-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS4_POS                      16                                                            /** DDRPHYMISCR1 RDQS4-bit position */
#define AG903_DDR_PHYMISCR1_RDQS4_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS4_POS)                      /** DDRPHYMISCR1 RDQS4-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS4_POS                      17                                                            /** DDRPHYMISCR1 WDQS4-bit position */
#define AG903_DDR_PHYMISCR1_WDQS4_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS4_POS)                      /** DDRPHYMISCR1 WDQS4-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS5_POS                      20                                                            /** DDRPHYMISCR1 RDQS5-bit position */
#define AG903_DDR_PHYMISCR1_RDQS5_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS5_POS)                      /** DDRPHYMISCR1 RDQS5-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS5_POS                      21                                                            /** DDRPHYMISCR1 WDQS5-bit position */
#define AG903_DDR_PHYMISCR1_WDQS5_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS5_POS)                      /** DDRPHYMISCR1 WDQS5-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS6_POS                      24                                                            /** DDRPHYMISCR1 RDQS6-bit position */
#define AG903_DDR_PHYMISCR1_RDQS6_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS6_POS)                      /** DDRPHYMISCR1 RDQS6-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS6_POS                      25                                                            /** DDRPHYMISCR1 WDQS6-bit position */
#define AG903_DDR_PHYMISCR1_WDQS6_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS6_POS)                      /** DDRPHYMISCR1 WDQS6-bit mask */
#define AG903_DDR_PHYMISCR1_RDQS7_POS                      28                                                            /** DDRPHYMISCR1 RDQS7-bit position */
#define AG903_DDR_PHYMISCR1_RDQS7_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_RDQS7_POS)                      /** DDRPHYMISCR1 RDQS7-bit mask */
#define AG903_DDR_PHYMISCR1_WDQS7_POS                      29                                                            /** DDRPHYMISCR1 WDQS7-bit position */
#define AG903_DDR_PHYMISCR1_WDQS7_MSK                      (0x1UL << AG903_DDR_PHYMISCR1_WDQS7_POS)                      /** DDRPHYMISCR1 WDQS7-bit mask */

#define AG903_DDR_RLEVELCR_RHD0_POS                        0                                                             /** DDRRLEVELCR RHD0-bit position */
#define AG903_DDR_RLEVELCR_RHD0_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD0_POS)                        /** DDRRLEVELCR RHD0-bit mask */
#define AG903_DDR_RLEVELCR_RHD1_POS                        1                                                             /** DDRRLEVELCR RHD1-bit position */
#define AG903_DDR_RLEVELCR_RHD1_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD1_POS)                        /** DDRRLEVELCR RHD1-bit mask */
#define AG903_DDR_RLEVELCR_RHD2_POS                        2                                                             /** DDRRLEVELCR RHD2-bit position */
#define AG903_DDR_RLEVELCR_RHD2_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD2_POS)                        /** DDRRLEVELCR RHD2-bit mask */
#define AG903_DDR_RLEVELCR_RHD3_POS                        3                                                             /** DDRRLEVELCR RHD3-bit position */
#define AG903_DDR_RLEVELCR_RHD3_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD3_POS)                        /** DDRRLEVELCR RHD3-bit mask */
#define AG903_DDR_RLEVELCR_RHD4_POS                        4                                                             /** DDRRLEVELCR RHD4-bit position */
#define AG903_DDR_RLEVELCR_RHD4_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD4_POS)                        /** DDRRLEVELCR RHD4-bit mask */
#define AG903_DDR_RLEVELCR_RHD5_POS                        5                                                             /** DDRRLEVELCR RHD5-bit position */
#define AG903_DDR_RLEVELCR_RHD5_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD5_POS)                        /** DDRRLEVELCR RHD5-bit mask */
#define AG903_DDR_RLEVELCR_RHD6_POS                        6                                                             /** DDRRLEVELCR RHD6-bit position */
#define AG903_DDR_RLEVELCR_RHD6_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD6_POS)                        /** DDRRLEVELCR RHD6-bit mask */
#define AG903_DDR_RLEVELCR_RHD7_POS                        7                                                             /** DDRRLEVELCR RHD7-bit position */
#define AG903_DDR_RLEVELCR_RHD7_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RHD7_POS)                        /** DDRRLEVELCR RHD7-bit mask */
#define AG903_DDR_RLEVELCR_RLP0_POS                        24                                                            /** DDRRLEVELCR RLP0-bit position */
#define AG903_DDR_RLEVELCR_RLP0_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP0_POS)                        /** DDRRLEVELCR RLP0-bit mask */
#define AG903_DDR_RLEVELCR_RLP1_POS                        25                                                            /** DDRRLEVELCR RLP1-bit position */
#define AG903_DDR_RLEVELCR_RLP1_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP1_POS)                        /** DDRRLEVELCR RLP1-bit mask */
#define AG903_DDR_RLEVELCR_RLP2_POS                        26                                                            /** DDRRLEVELCR RLP2-bit position */
#define AG903_DDR_RLEVELCR_RLP2_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP2_POS)                        /** DDRRLEVELCR RLP2-bit mask */
#define AG903_DDR_RLEVELCR_RLP3_POS                        27                                                            /** DDRRLEVELCR RLP3-bit position */
#define AG903_DDR_RLEVELCR_RLP3_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP3_POS)                        /** DDRRLEVELCR RLP3-bit mask */
#define AG903_DDR_RLEVELCR_RLP4_POS                        28                                                            /** DDRRLEVELCR RLP4-bit position */
#define AG903_DDR_RLEVELCR_RLP4_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP4_POS)                        /** DDRRLEVELCR RLP4-bit mask */
#define AG903_DDR_RLEVELCR_RLP5_POS                        29                                                            /** DDRRLEVELCR RLP5-bit position */
#define AG903_DDR_RLEVELCR_RLP5_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP5_POS)                        /** DDRRLEVELCR RLP5-bit mask */
#define AG903_DDR_RLEVELCR_RLP6_POS                        30                                                            /** DDRRLEVELCR RLP6-bit position */
#define AG903_DDR_RLEVELCR_RLP6_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP6_POS)                        /** DDRRLEVELCR RLP6-bit mask */
#define AG903_DDR_RLEVELCR_RLP7_POS                        31                                                            /** DDRRLEVELCR RLP7-bit position */
#define AG903_DDR_RLEVELCR_RLP7_MSK                        (0x1UL << AG903_DDR_RLEVELCR_RLP7_POS)                        /** DDRRLEVELCR RLP7-bit mask */

#define AG903_DDR_MSDLYCR_MSDLY0_POS                       0                                                             /** DDRMSDLYCR MSDLY0-bit position */
#define AG903_DDR_MSDLYCR_MSDLY0_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY0_POS)                       /** DDRMSDLYCR MSDLY0-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY1_POS                       4                                                             /** DDRMSDLYCR MSDLY1-bit position */
#define AG903_DDR_MSDLYCR_MSDLY1_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY1_POS)                       /** DDRMSDLYCR MSDLY1-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY2_POS                       8                                                             /** DDRMSDLYCR MSDLY2-bit position */
#define AG903_DDR_MSDLYCR_MSDLY2_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY2_POS)                       /** DDRMSDLYCR MSDLY2-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY3_POS                       12                                                            /** DDRMSDLYCR MSDLY3-bit position */
#define AG903_DDR_MSDLYCR_MSDLY3_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY3_POS)                       /** DDRMSDLYCR MSDLY3-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY4_POS                       16                                                            /** DDRMSDLYCR MSDLY4-bit position */
#define AG903_DDR_MSDLYCR_MSDLY4_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY4_POS)                       /** DDRMSDLYCR MSDLY4-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY5_POS                       20                                                            /** DDRMSDLYCR MSDLY5-bit position */
#define AG903_DDR_MSDLYCR_MSDLY5_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY5_POS)                       /** DDRMSDLYCR MSDLY5-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY6_POS                       24                                                            /** DDRMSDLYCR MSDLY6-bit position */
#define AG903_DDR_MSDLYCR_MSDLY6_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY6_POS)                       /** DDRMSDLYCR MSDLY6-bit mask */
#define AG903_DDR_MSDLYCR_MSDLY7_POS                       28                                                            /** DDRMSDLYCR MSDLY7-bit position */
#define AG903_DDR_MSDLYCR_MSDLY7_MSK                       (0xfUL << AG903_DDR_MSDLYCR_MSDLY7_POS)                       /** DDRMSDLYCR MSDLY7-bit mask */

#define AG903_DDR_WRDLLCR_WRDLL0_POS                       0                                                             /** DDRWRDLLCR WRDLL0-bit position */
#define AG903_DDR_WRDLLCR_WRDLL0_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL0_POS)                       /** DDRWRDLLCR WRDLL0-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL1_POS                       4                                                             /** DDRWRDLLCR WRDLL1-bit position */
#define AG903_DDR_WRDLLCR_WRDLL1_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL1_POS)                       /** DDRWRDLLCR WRDLL1-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL2_POS                       8                                                             /** DDRWRDLLCR WRDLL2-bit position */
#define AG903_DDR_WRDLLCR_WRDLL2_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL2_POS)                       /** DDRWRDLLCR WRDLL2-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL3_POS                       12                                                            /** DDRWRDLLCR WRDLL3-bit position */
#define AG903_DDR_WRDLLCR_WRDLL3_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL3_POS)                       /** DDRWRDLLCR WRDLL3-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL4_POS                       16                                                            /** DDRWRDLLCR WRDLL4-bit position */
#define AG903_DDR_WRDLLCR_WRDLL4_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL4_POS)                       /** DDRWRDLLCR WRDLL4-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL5_POS                       20                                                            /** DDRWRDLLCR WRDLL5-bit position */
#define AG903_DDR_WRDLLCR_WRDLL5_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL5_POS)                       /** DDRWRDLLCR WRDLL5-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL6_POS                       24                                                            /** DDRWRDLLCR WRDLL6-bit position */
#define AG903_DDR_WRDLLCR_WRDLL6_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL6_POS)                       /** DDRWRDLLCR WRDLL6-bit mask */
#define AG903_DDR_WRDLLCR_WRDLL7_POS                       28                                                            /** DDRWRDLLCR WRDLL7-bit position */
#define AG903_DDR_WRDLLCR_WRDLL7_MSK                       (0x7UL << AG903_DDR_WRDLLCR_WRDLL7_POS)                       /** DDRWRDLLCR WRDLL7-bit mask */

#define AG903_DDR_TRAFMR_TMCLKCYCLE_POS                    0                                                             /** DDRTRAFMR TMCLKCYCLE-bit position */
#define AG903_DDR_TRAFMR_TMCLKCYCLE_MSK                    (0xffffffffUL << AG903_DDR_TRAFMR_TMCLKCYCLE_POS)             /** DDRTRAFMR TMCLKCYCLE-bit mask */

#define AG903_DDR_CMDCNTR0_CMDCNT0_POS                     0                                                             /** DDRCMDCNTR0 CMDCNT0-bit position */
#define AG903_DDR_CMDCNTR0_CMDCNT0_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR0_CMDCNT0_POS)              /** DDRCMDCNTR0 CMDCNT0-bit mask */

#define AG903_DDR_CMDCNTR1_CMDCNT1_POS                     0                                                             /** DDRCMDCNTR1 CMDCNT1-bit position */
#define AG903_DDR_CMDCNTR1_CMDCNT1_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR1_CMDCNT1_POS)              /** DDRCMDCNTR1 CMDCNT1-bit mask */

#define AG903_DDR_CMDCNTR2_CMDCNT2_POS                     0                                                             /** DDRCMDCNTR2 CMDCNT2-bit position */
#define AG903_DDR_CMDCNTR2_CMDCNT2_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR2_CMDCNT2_POS)              /** DDRCMDCNTR2 CMDCNT2-bit mask */

#define AG903_DDR_CMDCNTR3_CMDCNT3_POS                     0                                                             /** DDRCMDCNTR3 CMDCNT3-bit position */
#define AG903_DDR_CMDCNTR3_CMDCNT3_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR3_CMDCNT3_POS)              /** DDRCMDCNTR3 CMDCNT3-bit mask */

#define AG903_DDR_CMDCNTR4_CMDCNT4_POS                     0                                                             /** DDRCMDCNTR4 CMDCNT4-bit position */
#define AG903_DDR_CMDCNTR4_CMDCNT4_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR4_CMDCNT4_POS)              /** DDRCMDCNTR4 CMDCNT4-bit mask */

#define AG903_DDR_CMDCNTR5_CMDCNT5_POS                     0                                                             /** DDRCMDCNTR5 CMDCNT5-bit position */
#define AG903_DDR_CMDCNTR5_CMDCNT5_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR5_CMDCNT5_POS)              /** DDRCMDCNTR5 CMDCNT5-bit mask */

#define AG903_DDR_CMDCNTR6_CMDCNT6_POS                     0                                                             /** DDRCMDCNTR6 CMDCNT6-bit position */
#define AG903_DDR_CMDCNTR6_CMDCNT6_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR6_CMDCNT6_POS)              /** DDRCMDCNTR6 CMDCNT6-bit mask */

#define AG903_DDR_CMDCNTR7_CMDCNT7_POS                     0                                                             /** DDRCMDCNTR7 CMDCNT7-bit position */
#define AG903_DDR_CMDCNTR7_CMDCNT7_MSK                     (0xffffffffUL << AG903_DDR_CMDCNTR7_CMDCNT7_POS)              /** DDRCMDCNTR7 CMDCNT7-bit mask */

#define AG903_DDR_AHBRPRER1_PFV0_POS                       0                                                             /** DDRAHBRPRER1 PFV0-bit position */
#define AG903_DDR_AHBRPRER1_PFV0_MSK                       (0xfUL << AG903_DDR_AHBRPRER1_PFV0_POS)                       /** DDRAHBRPRER1 PFV0-bit mask */
#define AG903_DDR_AHBRPRER1_LPF0_POS                       7                                                             /** DDRAHBRPRER1 LPF0-bit position */
#define AG903_DDR_AHBRPRER1_LPF0_MSK                       (0x1UL << AG903_DDR_AHBRPRER1_LPF0_POS)                       /** DDRAHBRPRER1 LPF0-bit mask */
#define AG903_DDR_AHBRPRER1_PFV1_POS                       8                                                             /** DDRAHBRPRER1 PFV1-bit position */
#define AG903_DDR_AHBRPRER1_PFV1_MSK                       (0x1fUL << AG903_DDR_AHBRPRER1_PFV1_POS)                      /** DDRAHBRPRER1 PFV1-bit mask */
#define AG903_DDR_AHBRPRER1_LPF1_POS                       15                                                            /** DDRAHBRPRER1 LPF1-bit position */
#define AG903_DDR_AHBRPRER1_LPF1_MSK                       (0x1UL << AG903_DDR_AHBRPRER1_LPF1_POS)                       /** DDRAHBRPRER1 LPF1-bit mask */
#define AG903_DDR_AHBRPRER1_PFV2_POS                       16                                                            /** DDRAHBRPRER1 PFV2-bit position */
#define AG903_DDR_AHBRPRER1_PFV2_MSK                       (0x1fUL << AG903_DDR_AHBRPRER1_PFV2_POS)                      /** DDRAHBRPRER1 PFV2-bit mask */
#define AG903_DDR_AHBRPRER1_LPF2_POS                       23                                                            /** DDRAHBRPRER1 LPF2-bit position */
#define AG903_DDR_AHBRPRER1_LPF2_MSK                       (0x1UL << AG903_DDR_AHBRPRER1_LPF2_POS)                       /** DDRAHBRPRER1 LPF2-bit mask */
#define AG903_DDR_AHBRPRER1_PFV3_POS                       24                                                            /** DDRAHBRPRER1 PFV3-bit position */
#define AG903_DDR_AHBRPRER1_PFV3_MSK                       (0x1fUL << AG903_DDR_AHBRPRER1_PFV3_POS)                      /** DDRAHBRPRER1 PFV3-bit mask */
#define AG903_DDR_AHBRPRER1_LPF3_POS                       31                                                            /** DDRAHBRPRER1 LPF3-bit position */
#define AG903_DDR_AHBRPRER1_LPF3_MSK                       (0x1UL << AG903_DDR_AHBRPRER1_LPF3_POS)                       /** DDRAHBRPRER1 LPF3-bit mask */

#define AG903_DDR_AHBRPRER2_PFV4_POS                       0                                                             /** DDRAHBRPRER2 PFV4-bit position */
#define AG903_DDR_AHBRPRER2_PFV4_MSK                       (0x1fUL << AG903_DDR_AHBRPRER2_PFV4_POS)                      /** DDRAHBRPRER2 PFV4-bit mask */
#define AG903_DDR_AHBRPRER2_LPF4_POS                       7                                                             /** DDRAHBRPRER2 LPF4-bit position */
#define AG903_DDR_AHBRPRER2_LPF4_MSK                       (0x1UL << AG903_DDR_AHBRPRER2_LPF4_POS)                       /** DDRAHBRPRER2 LPF4-bit mask */
#define AG903_DDR_AHBRPRER2_PFV5_POS                       8                                                             /** DDRAHBRPRER2 PFV5-bit position */
#define AG903_DDR_AHBRPRER2_PFV5_MSK                       (0x1fUL << AG903_DDR_AHBRPRER2_PFV5_POS)                      /** DDRAHBRPRER2 PFV5-bit mask */
#define AG903_DDR_AHBRPRER2_LPF5_POS                       15                                                            /** DDRAHBRPRER2 LPF5-bit position */
#define AG903_DDR_AHBRPRER2_LPF5_MSK                       (0x1UL << AG903_DDR_AHBRPRER2_LPF5_POS)                       /** DDRAHBRPRER2 LPF5-bit mask */
#define AG903_DDR_AHBRPRER2_PFV6_POS                       16                                                            /** DDRAHBRPRER2 PFV6-bit position */
#define AG903_DDR_AHBRPRER2_PFV6_MSK                       (0x1fUL << AG903_DDR_AHBRPRER2_PFV6_POS)                      /** DDRAHBRPRER2 PFV6-bit mask */
#define AG903_DDR_AHBRPRER2_LPF6_POS                       23                                                            /** DDRAHBRPRER2 LPF6-bit position */
#define AG903_DDR_AHBRPRER2_LPF6_MSK                       (0x1UL << AG903_DDR_AHBRPRER2_LPF6_POS)                       /** DDRAHBRPRER2 LPF6-bit mask */
#define AG903_DDR_AHBRPRER2_PFV7_POS                       24                                                            /** DDRAHBRPRER2 PFV7-bit position */
#define AG903_DDR_AHBRPRER2_PFV7_MSK                       (0x1fUL << AG903_DDR_AHBRPRER2_PFV7_POS)                      /** DDRAHBRPRER2 PFV7-bit mask */
#define AG903_DDR_AHBRPRER2_LPF7_POS                       31                                                            /** DDRAHBRPRER2 LPF7-bit position */
#define AG903_DDR_AHBRPRER2_LPF7_MSK                       (0x1UL << AG903_DDR_AHBRPRER2_LPF7_POS)                       /** DDRAHBRPRER2 LPF7-bit mask */

#define AG903_DDR_INITWCR1_WC200US_POS                     0                                                             /** DDRINITWCR1 WC200US-bit position */
#define AG903_DDR_INITWCR1_WC200US_MSK                     (0xfffffUL << AG903_DDR_INITWCR1_WC200US_POS)                 /** DDRINITWCR1 WC200US-bit mask */

#define AG903_DDR_INITWCR2_WC500US_POS                     0                                                             /** DDRINITWCR2 WC500US-bit position */
#define AG903_DDR_INITWCR2_WC500US_MSK                     (0xfffffUL << AG903_DDR_INITWCR2_WC500US_POS)                 /** DDRINITWCR2 WC500US-bit mask */

#define AG903_DDR_QOSCR_EN_POS                             0                                                             /** DDRQOSCR EN-bit position */
#define AG903_DDR_QOSCR_EN_MSK                             (0x1UL << AG903_DDR_QOSCR_EN_POS)                             /** DDRQOSCR EN-bit mask */
#define AG903_DDR_QOSCR_PERI_POS                           1                                                             /** DDRQOSCR PERI-bit position */
#define AG903_DDR_QOSCR_PERI_MSK                           (0x3UL << AG903_DDR_QOSCR_PERI_POS)                           /** DDRQOSCR PERI-bit mask */
#define AG903_DDR_QOSCR_IDRW_POS                           3                                                             /** DDRQOSCR IDRW-bit position */
#define AG903_DDR_QOSCR_IDRW_MSK                           (0x1UL << AG903_DDR_QOSCR_IDRW_POS)                           /** DDRQOSCR IDRW-bit mask */

#define AG903_DDR_QOSCNTRA_CMDCNT0_POS                     0                                                             /** DDRQOSCNTRA CMDCNT0-bit position */
#define AG903_DDR_QOSCNTRA_CMDCNT0_MSK                     (0xffUL << AG903_DDR_QOSCNTRA_CMDCNT0_POS)                    /** DDRQOSCNTRA CMDCNT0-bit mask */
#define AG903_DDR_QOSCNTRA_CMDCNT1_POS                     8                                                             /** DDRQOSCNTRA CMDCNT1-bit position */
#define AG903_DDR_QOSCNTRA_CMDCNT1_MSK                     (0xffUL << AG903_DDR_QOSCNTRA_CMDCNT1_POS)                    /** DDRQOSCNTRA CMDCNT1-bit mask */
#define AG903_DDR_QOSCNTRA_CMDCNT2_POS                     16                                                            /** DDRQOSCNTRA CMDCNT2-bit position */
#define AG903_DDR_QOSCNTRA_CMDCNT2_MSK                     (0xffUL << AG903_DDR_QOSCNTRA_CMDCNT2_POS)                    /** DDRQOSCNTRA CMDCNT2-bit mask */
#define AG903_DDR_QOSCNTRA_CMDCNT3_POS                     24                                                            /** DDRQOSCNTRA CMDCNT3-bit position */
#define AG903_DDR_QOSCNTRA_CMDCNT3_MSK                     (0xffUL << AG903_DDR_QOSCNTRA_CMDCNT3_POS)                    /** DDRQOSCNTRA CMDCNT3-bit mask */

#define AG903_DDR_QOSCNTRB_CMDCNT4_POS                     0                                                             /** DDRQOSCNTRB CMDCNT4-bit position */
#define AG903_DDR_QOSCNTRB_CMDCNT4_MSK                     (0xffUL << AG903_DDR_QOSCNTRB_CMDCNT4_POS)                    /** DDRQOSCNTRB CMDCNT4-bit mask */
#define AG903_DDR_QOSCNTRB_CMDCNT5_POS                     8                                                             /** DDRQOSCNTRB CMDCNT5-bit position */
#define AG903_DDR_QOSCNTRB_CMDCNT5_MSK                     (0xffUL << AG903_DDR_QOSCNTRB_CMDCNT5_POS)                    /** DDRQOSCNTRB CMDCNT5-bit mask */
#define AG903_DDR_QOSCNTRB_CMDCNT6_POS                     16                                                            /** DDRQOSCNTRB CMDCNT6-bit position */
#define AG903_DDR_QOSCNTRB_CMDCNT6_MSK                     (0xffUL << AG903_DDR_QOSCNTRB_CMDCNT6_POS)                    /** DDRQOSCNTRB CMDCNT6-bit mask */
#define AG903_DDR_QOSCNTRB_CMDCNT7_POS                     24                                                            /** DDRQOSCNTRB CMDCNT7-bit position */
#define AG903_DDR_QOSCNTRB_CMDCNT7_MSK                     (0xffUL << AG903_DDR_QOSCNTRB_CMDCNT7_POS)                    /** DDRQOSCNTRB CMDCNT7-bit mask */

#define AG903_DDR_QOSCNTRC_WCMDCNT0_POS                    0                                                             /** DDRQOSCNTRC WCMDCNT0-bit position */
#define AG903_DDR_QOSCNTRC_WCMDCNT0_MSK                    (0xffUL << AG903_DDR_QOSCNTRC_WCMDCNT0_POS)                   /** DDRQOSCNTRC WCMDCNT0-bit mask */
#define AG903_DDR_QOSCNTRC_WCMDCNT1_POS                    8                                                             /** DDRQOSCNTRC WCMDCNT1-bit position */
#define AG903_DDR_QOSCNTRC_WCMDCNT1_MSK                    (0xffUL << AG903_DDR_QOSCNTRC_WCMDCNT1_POS)                   /** DDRQOSCNTRC WCMDCNT1-bit mask */
#define AG903_DDR_QOSCNTRC_WCMDCNT2_POS                    16                                                            /** DDRQOSCNTRC WCMDCNT2-bit position */
#define AG903_DDR_QOSCNTRC_WCMDCNT2_MSK                    (0xffUL << AG903_DDR_QOSCNTRC_WCMDCNT2_POS)                   /** DDRQOSCNTRC WCMDCNT2-bit mask */
#define AG903_DDR_QOSCNTRC_WCMDCNT3_POS                    24                                                            /** DDRQOSCNTRC WCMDCNT3-bit position */
#define AG903_DDR_QOSCNTRC_WCMDCNT3_MSK                    (0xffUL << AG903_DDR_QOSCNTRC_WCMDCNT3_POS)                   /** DDRQOSCNTRC WCMDCNT3-bit mask */

#define AG903_DDR_QOSCNTRD_WCMDCNT4_POS                    0                                                             /** DDRQOSCNTRD WCMDCNT4-bit position */
#define AG903_DDR_QOSCNTRD_WCMDCNT4_MSK                    (0xffUL << AG903_DDR_QOSCNTRD_WCMDCNT4_POS)                   /** DDRQOSCNTRD WCMDCNT4-bit mask */
#define AG903_DDR_QOSCNTRD_WCMDCNT5_POS                    8                                                             /** DDRQOSCNTRD WCMDCNT5-bit position */
#define AG903_DDR_QOSCNTRD_WCMDCNT5_MSK                    (0xffUL << AG903_DDR_QOSCNTRD_WCMDCNT5_POS)                   /** DDRQOSCNTRD WCMDCNT5-bit mask */
#define AG903_DDR_QOSCNTRD_WCMDCNT6_POS                    16                                                            /** DDRQOSCNTRD WCMDCNT6-bit position */
#define AG903_DDR_QOSCNTRD_WCMDCNT6_MSK                    (0xffUL << AG903_DDR_QOSCNTRD_WCMDCNT6_POS)                   /** DDRQOSCNTRD WCMDCNT6-bit mask */
#define AG903_DDR_QOSCNTRD_WCMDCNT7_POS                    24                                                            /** DDRQOSCNTRD WCMDCNT7-bit position */
#define AG903_DDR_QOSCNTRD_WCMDCNT7_MSK                    (0xffUL << AG903_DDR_QOSCNTRD_WCMDCNT7_POS)                   /** DDRQOSCNTRD WCMDCNT7-bit mask */

#define AG903_DDR_CHARBRB_WHIPRI_POS                       0                                                             /** DDRCHARBRB WHIPRI-bit position */
#define AG903_DDR_CHARBRB_WHIPRI_MSK                       (0xffUL << AG903_DDR_CHARBRB_WHIPRI_POS)                      /** DDRCHARBRB WHIPRI-bit mask */
#define AG903_DDR_CHARBRB_WBSTORTARB_POS                   8                                                             /** DDRCHARBRB WBSTORTARB-bit position */
#define AG903_DDR_CHARBRB_WBSTORTARB_MSK                   (0xffUL << AG903_DDR_CHARBRB_WBSTORTARB_POS)                  /** DDRCHARBRB WBSTORTARB-bit mask */
#define AG903_DDR_CHARBRB_WGGRTCNT_POS                     24                                                            /** DDRCHARBRB WGGRTCNT-bit position */
#define AG903_DDR_CHARBRB_WGGRTCNT_MSK                     (0x1fUL << AG903_DDR_CHARBRB_WGGRTCNT_POS)                    /** DDRCHARBRB WGGRTCNT-bit mask */

#define AG903_DDR_CHGNTRC_WARBCNT0_POS                     0                                                             /** DDRCHGNTRC WARBCNT0-bit position */
#define AG903_DDR_CHGNTRC_WARBCNT0_MSK                     (0x1fUL << AG903_DDR_CHGNTRC_WARBCNT0_POS)                    /** DDRCHGNTRC WARBCNT0-bit mask */
#define AG903_DDR_CHGNTRC_WARBCNT1_POS                     8                                                             /** DDRCHGNTRC WARBCNT1-bit position */
#define AG903_DDR_CHGNTRC_WARBCNT1_MSK                     (0x1fUL << AG903_DDR_CHGNTRC_WARBCNT1_POS)                    /** DDRCHGNTRC WARBCNT1-bit mask */
#define AG903_DDR_CHGNTRC_WARBCNT2_POS                     16                                                            /** DDRCHGNTRC WARBCNT2-bit position */
#define AG903_DDR_CHGNTRC_WARBCNT2_MSK                     (0x1fUL << AG903_DDR_CHGNTRC_WARBCNT2_POS)                    /** DDRCHGNTRC WARBCNT2-bit mask */
#define AG903_DDR_CHGNTRC_WARBCNT3_POS                     24                                                            /** DDRCHGNTRC WARBCNT3-bit position */
#define AG903_DDR_CHGNTRC_WARBCNT3_MSK                     (0x1fUL << AG903_DDR_CHGNTRC_WARBCNT3_POS)                    /** DDRCHGNTRC WARBCNT3-bit mask */

#define AG903_DDR_CHGNTRD_WARBCNT4_POS                     0                                                             /** DDRCHGNTRD WARBCNT4-bit position */
#define AG903_DDR_CHGNTRD_WARBCNT4_MSK                     (0x1fUL << AG903_DDR_CHGNTRD_WARBCNT4_POS)                    /** DDRCHGNTRD WARBCNT4-bit mask */
#define AG903_DDR_CHGNTRD_WARBCNT5_POS                     8                                                             /** DDRCHGNTRD WARBCNT5-bit position */
#define AG903_DDR_CHGNTRD_WARBCNT5_MSK                     (0x1fUL << AG903_DDR_CHGNTRD_WARBCNT5_POS)                    /** DDRCHGNTRD WARBCNT5-bit mask */
#define AG903_DDR_CHGNTRD_WARBCNT6_POS                     16                                                            /** DDRCHGNTRD WARBCNT6-bit position */
#define AG903_DDR_CHGNTRD_WARBCNT6_MSK                     (0x1fUL << AG903_DDR_CHGNTRD_WARBCNT6_POS)                    /** DDRCHGNTRD WARBCNT6-bit mask */
#define AG903_DDR_CHGNTRD_WARBCNT7_POS                     24                                                            /** DDRCHGNTRD WARBCNT7-bit position */
#define AG903_DDR_CHGNTRD_WARBCNT7_MSK                     (0x1fUL << AG903_DDR_CHGNTRD_WARBCNT7_POS)                    /** DDRCHGNTRD WARBCNT7-bit mask */

#define AG903_DDR_DBGADR_BASEADDR_POS                      0                                                             /** DDRDBGADR BASEADDR-bit position */
#define AG903_DDR_DBGADR_BASEADDR_MSK                      (0xffffffffUL << AG903_DDR_DBGADR_BASEADDR_POS)               /** DDRDBGADR BASEADDR-bit mask */

#define AG903_DDR_DBGADMR_ADDRMASK_POS                     0                                                             /** DDRDBGADMR ADDRMASK-bit position */
#define AG903_DDR_DBGADMR_ADDRMASK_MSK                     (0xffffffffUL << AG903_DDR_DBGADMR_ADDRMASK_POS)              /** DDRDBGADMR ADDRMASK-bit mask */

#define AG903_DDR_DBGWDR_WRITEDATA_POS                     0                                                             /** DDRDBGWDR WRITEDATA-bit position */
#define AG903_DDR_DBGWDR_WRITEDATA_MSK                     (0xffffffffUL << AG903_DDR_DBGWDR_WRITEDATA_POS)              /** DDRDBGWDR WRITEDATA-bit mask */

#define AG903_DDR_DBGWDMR_DATAMASK_POS                     0                                                             /** DDRDBGWDMR DATAMASK-bit position */
#define AG903_DDR_DBGWDMR_DATAMASK_MSK                     (0xffffffffUL << AG903_DDR_DBGWDMR_DATAMASK_POS)              /** DDRDBGWDMR DATAMASK-bit mask */

#define AG903_DDR_DBGMSTR_ID_POS                           0                                                             /** DDRDBGMSTR ID-bit position */
#define AG903_DDR_DBGMSTR_ID_MSK                           (0xffffUL << AG903_DDR_DBGMSTR_ID_POS)                        /** DDRDBGMSTR ID-bit mask */
#define AG903_DDR_DBGMSTR_CH_POS                           16                                                            /** DDRDBGMSTR CH-bit position */
#define AG903_DDR_DBGMSTR_CH_MSK                           (0x7UL << AG903_DDR_DBGMSTR_CH_POS)                           /** DDRDBGMSTR CH-bit mask */
#define AG903_DDR_DBGMSTR_EX_POS                           19                                                            /** DDRDBGMSTR EX-bit position */
#define AG903_DDR_DBGMSTR_EX_MSK                           (0x1UL << AG903_DDR_DBGMSTR_EX_POS)                           /** DDRDBGMSTR EX-bit mask */

#define AG903_DDR_DBGACCR_RWS_POS                          0                                                             /** DDRDBGACCR RWS-bit position */
#define AG903_DDR_DBGACCR_RWS_MSK                          (0x1UL << AG903_DDR_DBGACCR_RWS_POS)                          /** DDRDBGACCR RWS-bit mask */
#define AG903_DDR_DBGACCR_LSW_POS                          1                                                             /** DDRDBGACCR LSW-bit position */
#define AG903_DDR_DBGACCR_LSW_MSK                          (0x1UL << AG903_DDR_DBGACCR_LSW_POS)                          /** DDRDBGACCR LSW-bit mask */

#define AG903_DDR_DBGPCR_ADR_POS                           0                                                             /** DDRDBGPCR ADR-bit position */
#define AG903_DDR_DBGPCR_ADR_MSK                           (0x1UL << AG903_DDR_DBGPCR_ADR_POS)                           /** DDRDBGPCR ADR-bit mask */
#define AG903_DDR_DBGPCR_WD_POS                            1                                                             /** DDRDBGPCR WD-bit position */
#define AG903_DDR_DBGPCR_WD_MSK                            (0x1UL << AG903_DDR_DBGPCR_WD_POS)                            /** DDRDBGPCR WD-bit mask */
#define AG903_DDR_DBGPCR_ID_POS                            2                                                             /** DDRDBGPCR ID-bit position */
#define AG903_DDR_DBGPCR_ID_MSK                            (0x1UL << AG903_DDR_DBGPCR_ID_POS)                            /** DDRDBGPCR ID-bit mask */
#define AG903_DDR_DBGPCR_CH_POS                            3                                                             /** DDRDBGPCR CH-bit position */
#define AG903_DDR_DBGPCR_CH_MSK                            (0x1UL << AG903_DDR_DBGPCR_CH_POS)                            /** DDRDBGPCR CH-bit mask */
#define AG903_DDR_DBGPCR_RW_POS                            4                                                             /** DDRDBGPCR RW-bit position */
#define AG903_DDR_DBGPCR_RW_MSK                            (0x1UL << AG903_DDR_DBGPCR_RW_POS)                            /** DDRDBGPCR RW-bit mask */

#define AG903_DDR_DBGENR_EN_POS                            0                                                             /** DDRDBGENR EN-bit position */
#define AG903_DDR_DBGENR_EN_MSK                            (0x1UL << AG903_DDR_DBGENR_EN_POS)                            /** DDRDBGENR EN-bit mask */

#define AG903_DDR_DBGADSR_ADDRSTATUS_POS                   0                                                             /** DDRDBGADSR ADDRSTATUS-bit position */
#define AG903_DDR_DBGADSR_ADDRSTATUS_MSK                   (0xffffffffUL << AG903_DDR_DBGADSR_ADDRSTATUS_POS)            /** DDRDBGADSR ADDRSTATUS-bit mask */

#define AG903_DDR_DBGWDSR_DATASTATUS_POS                   0                                                             /** DDRDBGWDSR DATASTATUS-bit position */
#define AG903_DDR_DBGWDSR_DATASTATUS_MSK                   (0xffffffffUL << AG903_DDR_DBGWDSR_DATASTATUS_POS)            /** DDRDBGWDSR DATASTATUS-bit mask */

#define AG903_DDR_DBGMSTSR_IDSTATUS_POS                    0                                                             /** DDRDBGMSTSR IDSTATUS-bit position */
#define AG903_DDR_DBGMSTSR_IDSTATUS_MSK                    (0xffffUL << AG903_DDR_DBGMSTSR_IDSTATUS_POS)                 /** DDRDBGMSTSR IDSTATUS-bit mask */
#define AG903_DDR_DBGMSTSR_CHSTATUS_POS                    16                                                            /** DDRDBGMSTSR CHSTATUS-bit position */
#define AG903_DDR_DBGMSTSR_CHSTATUS_MSK                    (0x7UL << AG903_DDR_DBGMSTSR_CHSTATUS_POS)                    /** DDRDBGMSTSR CHSTATUS-bit mask */

#define AG903_DDR_DBGACCSR_ST_POS                          0                                                             /** DDRDBGACCSR ST-bit position */
#define AG903_DDR_DBGACCSR_ST_MSK                          (0x1UL << AG903_DDR_DBGACCSR_ST_POS)                          /** DDRDBGACCSR ST-bit mask */

#define AG903_DDR_PHYRDTFR_RD0_POS                         0                                                             /** DDRPHYRDTFR RD0-bit position */
#define AG903_DDR_PHYRDTFR_RD0_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD0_POS)                         /** DDRPHYRDTFR RD0-bit mask */
#define AG903_DDR_PHYRDTFR_RD1_POS                         4                                                             /** DDRPHYRDTFR RD1-bit position */
#define AG903_DDR_PHYRDTFR_RD1_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD1_POS)                         /** DDRPHYRDTFR RD1-bit mask */
#define AG903_DDR_PHYRDTFR_RD2_POS                         8                                                             /** DDRPHYRDTFR RD2-bit position */
#define AG903_DDR_PHYRDTFR_RD2_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD2_POS)                         /** DDRPHYRDTFR RD2-bit mask */
#define AG903_DDR_PHYRDTFR_RD3_POS                         12                                                            /** DDRPHYRDTFR RD3-bit position */
#define AG903_DDR_PHYRDTFR_RD3_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD3_POS)                         /** DDRPHYRDTFR RD3-bit mask */
#define AG903_DDR_PHYRDTFR_RD4_POS                         16                                                            /** DDRPHYRDTFR RD4-bit position */
#define AG903_DDR_PHYRDTFR_RD4_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD4_POS)                         /** DDRPHYRDTFR RD4-bit mask */
#define AG903_DDR_PHYRDTFR_RD5_POS                         20                                                            /** DDRPHYRDTFR RD5-bit position */
#define AG903_DDR_PHYRDTFR_RD5_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD5_POS)                         /** DDRPHYRDTFR RD5-bit mask */
#define AG903_DDR_PHYRDTFR_RD6_POS                         24                                                            /** DDRPHYRDTFR RD6-bit position */
#define AG903_DDR_PHYRDTFR_RD6_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD6_POS)                         /** DDRPHYRDTFR RD6-bit mask */
#define AG903_DDR_PHYRDTFR_RD7_POS                         28                                                            /** DDRPHYRDTFR RD7-bit position */
#define AG903_DDR_PHYRDTFR_RD7_MSK                         (0x7UL << AG903_DDR_PHYRDTFR_RD7_POS)                         /** DDRPHYRDTFR RD7-bit mask */

#define AG903_DDR_PHYMISCR2_RDCA_POS                       0                                                             /** DDRPHYMISCR2 RDCA-bit position */
#define AG903_DDR_PHYMISCR2_RDCA_MSK                       (0x7UL << AG903_DDR_PHYMISCR2_RDCA_POS)                       /** DDRPHYMISCR2 RDCA-bit mask */
#define AG903_DDR_PHYMISCR2_RDDT_POS                       4                                                             /** DDRPHYMISCR2 RDDT-bit position */
#define AG903_DDR_PHYMISCR2_RDDT_MSK                       (0x7UL << AG903_DDR_PHYMISCR2_RDDT_POS)                       /** DDRPHYMISCR2 RDDT-bit mask */
#define AG903_DDR_PHYMISCR2_VREF_POS                       8                                                             /** DDRPHYMISCR2 VREF-bit position */
#define AG903_DDR_PHYMISCR2_VREF_MSK                       (0x7UL << AG903_DDR_PHYMISCR2_VREF_POS)                       /** DDRPHYMISCR2 VREF-bit mask */
#define AG903_DDR_PHYMISCR2_RLEEN_POS                      12                                                            /** DDRPHYMISCR2 RLEEN-bit position */
#define AG903_DDR_PHYMISCR2_RLEEN_MSK                      (0x1UL << AG903_DDR_PHYMISCR2_RLEEN_POS)                      /** DDRPHYMISCR2 RLEEN-bit mask */
#define AG903_DDR_PHYMISCR2_RLGEN_POS                      13                                                            /** DDRPHYMISCR2 RLGEN-bit position */
#define AG903_DDR_PHYMISCR2_RLGEN_MSK                      (0x1UL << AG903_DDR_PHYMISCR2_RLGEN_POS)                      /** DDRPHYMISCR2 RLGEN-bit mask */
#define AG903_DDR_PHYMISCR2_IO15V_POS                      14                                                            /** DDRPHYMISCR2 IO15V-bit position */
#define AG903_DDR_PHYMISCR2_IO15V_MSK                      (0x1UL << AG903_DDR_PHYMISCR2_IO15V_POS)                      /** DDRPHYMISCR2 IO15V-bit mask */

#endif /* _AG903_DDR_REGMAP_H_ */

