/** 
 * @brief           USBC Api Header
 * @author          AXELL CORPORATION
 * @description     usbc_api.cpwb_
 * @note            none
 * @history         2017_02_22	
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */



#ifndef __USBC_API_H__
#define __USBC_API_H__
/* DOM-IGNORE-END */

// *************************************************************************************************
//	include
// *************************************************************************************************
#include	"usbc_main.h"


// *************************************************************************************************
//	define
// *************************************************************************************************
//------------------------------------------------------------------------------
// Default Gh|Cgԍ
//------------------------------------------------------------------------------
/** ftHgpCvEPԍ */
#define		USB_DEFAULT_EP_NUM				(0x00)

//------------------------------------------------------------------------------
// pPbgID
//------------------------------------------------------------------------------
/** Data-OUT pPbgID */
#define		USB_PACKETID_OUT				(0x01)
/** Data-IN pPbgID */
#define		USB_PACKETID_IN					(0x09)
// SOF pPbgID */
#define		USB_PACKETID_SOF				(0x0A)
/** SETUP pPbgID */
#define		USB_PACKETID_SETUP				(0x0D)

//------------------------------------------------------------------------------
// ]^Cv
//------------------------------------------------------------------------------
/** Endpoint̃^Cṽ}XN */
#define		USB_TRANS_TYPEMASK				(0x03)
/** Rg[] */
#define		USB_TRANS_CONTROL				(0x00)
/** AC\NiX] */
#define		USB_TRANS_ISOCHRONOUS			(0x01)
/** oN] */
#define		USB_TRANS_BULK					(0x02)
/** C^vg] */
#define		USB_TRANS_INTERRUPT				(0x03)

//------------------------------------------------------------------------------
//	CB
//------------------------------------------------------------------------------
/** USB RA */
#define		MOD_ID_USBH						(0)
/** T|[gfoCXNXhCo */
#define		MOD_ID_CLASSDRV_UNKNOWNDEV		(1)
/** Xg[W */
#define		MOD_ID_CLASSDRV_STOR			(2)
/** R~jP[VfoCX */
#define		MOD_ID_CLASSDRV_CDC				(3)
/** HIDfoCX */
#define		MOD_ID_CLASSDRV_HID				(4)
/** OS_WRAPPER */
#define		MOD_ID_OSWRAP					(100)


//------------------------------------------------------------------------------
//	CB
//------------------------------------------------------------------------------
/** foCXڑꂽ */
#define		CBID_CORE_DEVATTACH				(0)
/** foCXؒfꂽ */
#define		CBID_CORE_DEVDETACH				(1)
/** ߓdm */
#define		CBID_CORE_OVERCURRENT			(2)
/** NGXgɑ΂R[obN */
#define		CBID_CORE_REQ					(3)
/** Xe[^Xʒm */
#define		CBID_CORE_STATUS				(4)
/** Split Err Notifyʒm */
#define		CBID_CORE_SPLITERR				(5)


//------------------------------------------------------------------------------
//	foCX							CALLBACK\̓
//------------------------------------------------------------------------------
typedef enum {

    USB_CLASS_UNKNOWN,															//	T|[gfoCXNX
    USB_CLASS_CDC,																//	CDCNX
    USB_CLASS_HID,																//	HIDNX
    USB_CLASS_MASSSTOR,															//	MSC(BOT)NX
    USB_CLASS_HUB																//	HUBNX

} class_driver_type;


//------------------------------------------------------------------------------
//	Message ID - Bit Format
//
//	X											0=REQ/1=ANS
//	 --- ----									BLOCK
//            ---- ---- 						Reserved
//                       ---- ---- ---- ---- 	eBlockMessageID
//------------------------------------------------------------------------------
//	^XN
#define		USBH_MSGID_KIND_MSK								(0x7F000000)		//	
#define		USBH_MSGID_KIND_API_WRAPP						(0x01000000)		//	For API_WRAPPER
#define		USBH_MSGID_KIND_HUB_THREAD						(0x02000000)		//	For HUB_Thraed

#define		USBH_MSGID_KIND_RESPONSE						(0x80000000)

// *************************************************************************************************
//	structure
// *************************************************************************************************

struct usb_control_block;

// void (*usb_complete_t)(struct usb_control_block * ucb);
typedef int (*usb_common_callback_t)( int mod_id, int callback_id, void * context );	/** NXhCo R[obNo^p֐^ */
typedef usb_common_callback_t usb_complete_t;

//------------------------------------------------------------------------------
//	MessageMi{nj
//			mbx_buf ɁAΉ|C^͂߂B
//------------------------------------------------------------------------------
struct uhs_mbxbuf {                 // __st__
    uhs_ubit32_t    os_area;													// OSgpGA
    void *          mbx_buf;													// ]f[^obt@
};

//------------------------------------------------------------------------------
//	Cxg{֐`
//------------------------------------------------------------------------------
typedef	struct	{

	uhs_ubit32_t		mess_id;
	void				(*func)(void *msg_ptr);

}	UHS_EVNT_FUNC_TBL;

//------------------------------------------------------------------------------
//	MessageBlock
//------------------------------------------------------------------------------
typedef	struct	{

    uhs_ubit32_t    os_area;													//	OSgpGA
	uhs_ubit32_t	mess_id;													//	Message ID
	uhs_ubit32_t	mem_pool;													//	pmem poolAhX

}	UHS_MSG_COMMON;

/**	{\̂USBNGXg̔spCvɎgp܂B<p>
    NXhCo͖{\̂̂߂ɃmۂAeoK؂ɐݒA{\̂gpUSB HostAPIĂяo܂B<p>
    ^C~O F <p>
    폜^C~O F R[obN֐ĂяoAPȈꍇAR[obN֐Ăяo܂ō폜֎~ */
struct usb_control_block {
    struct usbd_usb_deviceinfo* usbdev;											/** foCX
																					SplitǗ܂ށB(HUBNXŊi[B) */

    uhs_ubit32_t         pipe;													/**	PIPE<p>
                                                                                    Pipe͎USBRg[ubÑoƂăpCvUSBNGXg̔sɎgp܂B<p>
                                                                                    Pipeɂ́Aȉ̏񂪊܂܂܂B<p>
                                                                                    MAXpPbgTCYAEPʁApPbgIDAEPԍAUSBAhX */
        #define USB_PIPE_ADDR_SHIFT 0
            /**	 bit0 ` 6    USBAhX */
            #define USB_PIPE_ADDR_MASK  (0x7fU << USB_PIPE_ADDR_SHIFT)
        #define USB_PIPE_EPNUM_SHIFT 8
            /**	    8 ` 11   Gh|Cgԍ */
            #define USB_PIPE_EPNUM_MASK (0x0fU << USB_PIPE_EPNUM_SHIFT)
        #define USB_PIPE_PID_SHIFT 12
            /**	   12 ` 15   pPbgID */
            #define USB_PIPE_PID_MASK   (0x0fU << USB_PIPE_PID_SHIFT)
        #define USB_PIPE_EPTYPE_SHIFT 16
            /**	   16 ` 17   Gh|Cg^Cv */
            #define USB_PIPE_EPTYPE_MASK (0x03U << USB_PIPE_EPTYPE_SHIFT)
        #define USB_PIPE_MAXPKT_SHIFT 20
            /**	   20 ` 30   }bNXpPbgTCY */
            #define USB_PIPE_MAXPKT_MASK (0x3ffU << USB_PIPE_MAXPKT_SHIFT)

    uhs_ubit8_t         open_cnt;												/** pCṽI[vJE^ */
    usb_device_request_t *setup_data;											/** SETUPpPbgi[(Rg[]̂) */
    void                 *data_buf;												/** f[^i[obt@(LbV̈) */
    uhs_ubit32_t         data_len;												/** ]f[^TCYi[ */
    uhs_ubit32_t         act_len;												/** ]ς݃f[^TCYi[ */

    usb_common_callback_t complete_func;										/** CALLBACK֐|C^ */

    uhs_ubit32_t         time_out;												/** ^CAEgԊi[ */
    uhs_status_t         status;												/** ]Xe[^Xi[<p>
                                                                                    APIgpɉ̃G[i[܂B<p>
                                                                                    Usbh_Api_ControlMsg<p>
                                                                                    Usbh_Api_BulkMsg<p>
                                                                                    Usbh_Api_SyncControlMsg<p>
                                                                                    Usbh_Api_SyncBulkMsg<p>
                                                                                    Usbh_Api_IntMsg<p>
                                                                                    Usbh_Api_CancelPipe<p>
                                                                                    Usbh_Api_GetDescriptor<p>
                                                                                    Usbh_Api_ClearFeature<p>
                                                                                    Usbh_Api_SetFeature<p>
                                                                                    Usbh_Api_GetStatus<p>
                                                                                    Usbh_Api_GetInterface<p>
                                                                                    Usbh_Api_GetConfiguration<p>
                                                                                    EUSB_NO_ERROR F I<p>
                                                                                    EUSB_DATABUF_ERROR F Overrun/underrunG[<p>
                                                                                    EUSB_BABBLE_DETECTED F BubbleoG[<p>
                                                                                    EUSB_TX_ERROR F ]G[oiBadPID,CRC,Timeoutj<p>
                                                                                    EUSB_MISSED_MICROFRAME F FS/LS Missed microt[<p>
                                                                                    EUSB_INTXFER_UNKNOWNSIZE F ]TCYBiInterrupt̓]LZj<p>
                                                                                    EUSB_STOP_TRANS F ]~<p>
                                                                                    EUSB_HALT F AnyError,STALL(LG[ɈȂP[X)<p>
                                                                                    EUSB_TIMEOUT F ^CAEg */
    uhs_ubit8_t          interval;												/** ]̃C^[o */
        #define USB_INTERVAL_1us        (1)										/** 1 us */
        #define USB_INTERVAL_2us        (2)										/** 2 us */
        #define USB_INTERVAL_4us        (4)										/** 4 us */
        #define USB_INTERVAL_1ms        (8)										/** 1 ms */
        #define USB_INTERVAL_2ms        (16)									/** 2 ms */
        #define USB_INTERVAL_4ms        (32)									/** 4 ms */
        #define USB_INTERVAL_8ms        (64)									/** 8 ms */
        #define USB_INTERVAL_16ms       (128)									/** 16ms */
        #define USB_INTERVAL_32ms       (256)									/** 32ms */

	//	API_WRAPPB
	//^^^^^^^^^^^^^^^^^
    kernel_context_t     ucb_mbx;												/** ]p[{bNXi]̑҂悤mailbox𐶐j */
    uhs_boolean_t        is_sync;												/** Trueݒi]ThreadŎQƁj */

    uhs_ubit8_t          flags;													/** tO */
        /** tO */
        #define USB_UCB_OK                  (0)

//        #define USB_UCB_XFER_ABORTED        (1)								/** ]A{[gꂽ */

        /** ]^CAEg */
        #define USB_UCB_XFER_TIMEOUT        (2)

    uhs_ubit8_t          request_flags;											/** tO */
        #define USB_UCB_NONE                (0x00U)
        #define USB_UCB_NOT_LINKED_YET      (0x01U)
        #define USB_UCB_LINKED              (0x02U)
        #define USB_UCB_UNLINKED            (0x03U)

    uhs_ubit8_t          cancel_flags;											/** tO */
        #define USB_UCB_NOT_CANCELED        (0x00U)
        #define USB_UCB_CANCELED            (0x01U)

    void                *context;												/** ReLXgf[^|C^ */
};



//------------------------------------------------------------------------------
//	NXhCoo@e[u
//------------------------------------------------------------------------------

/** NXhCoɑΉfoCXw肷邽߂̍\<p>
    NXhCo̓o^Ŏgpclass_driver_reginfo\̂̃oƂĎgp܂B<p>
    USB Host ́ANXhCoݒ肵{\̂̃oƁAfoCXڑꂽۂɎ擾fBXNv^r邱ƂŁA
    foCXɑΉhCoE[h܂B<p>
    ȂAЂƂ̃NXhCoɕ̃foCXΉÂꍇA{\̂Kvȏ̐zƂĊmۂAݒ
    ̐擪|C^class_driver_reginfo\̂̃oɊi[ĉB<p>
    rsȂȂo̐ݒulɂĂ͕słÅgl0Ŗ߂邱Ƃ𐄏܂B<p>
    ^C~O F NXhCoCjV<p>
    폜^C~O F NXhCo폜 */
struct usb_class_driver_ids {
    uhs_ubit32_t    check_ids;													/** vrIDw */
        /** foCXXs[hr */
        #define         CHECK_DEV_SPEED         (1 << 0)
        /** USBo[Wr */
        #define         CHECK_BCD_USB           (1 << 1)
        /** x_IDr */
        #define         CHECK_VENDOR_ID         (1 << 2)
        /** vgRIDr */
        #define         CHECK_PRODUCT_ID        (1 << 3)
        /** foCXNXIDr */
        #define         CHECK_DEVCLASS_ID       (1 << 4)
        /** foCXTuNXIDr */
        #define         CHECK_DEVSUBCLASS_ID    (1 << 5)
        /** foCXvgRIDr */
        #define         CHECK_DEVPROTOCOL_ID    (1 << 6)
        /** C^tF[XNXIDr */
        #define         CHECK_INTCLASS_ID       (1 << 7)
        /** C^tF[XTuNXIDr */
        #define         CHECK_INTSUBCLASS_ID    (1 << 8)
        /** C^tF[XvgRIDr */
        #define         CHECK_INTPROTOCOL_ID    (1 << 9)
    uhs_ubit16_t    dev_speed;													/** USB̓]Xs[ḧv`FbN */
    uhs_ubit16_t    bcdusb_id;													/** USBo[Ẅv`FbN */
    uhs_ubit16_t    vendor_id;													/** x_ID̈v`FbN */
    uhs_ubit16_t    product_id;													/** v_NgID̈v`FbN */
    uhs_ubit16_t    device_class_id;											/** foCXNXID̈v`FbN */
    uhs_ubit16_t    device_subclass_id;											/** foCXTuNXID̈v`FbN */
    uhs_ubit16_t    device_protocol_id;											/** foCXvgRID̈v`FbN */
    uhs_ubit16_t    interface_class_id;											/** C^[tF[XNXID̈v`FbN */
    uhs_ubit16_t    interface_subclass_id;										/** C^[tF[XTuNXID̈v`FbN */
    uhs_ubit16_t    interface_protocol_id;										/** C^[tF[XvgRID̈v`FbN */
    uhs_ubit32_t    terminated;													/** ^[~l[^ */
        /** z̍ŏIvfł͂Ȃ */
        #define NON_TERMINATE       0x00000000
        /** z̍ŏIvfA͒P̗vf */
        #define TERMINATE           0xffffffff
};

typedef int (*usb_class_reregi_callback_t)(void * stCallback);					/** NXhCo R[obNēo^p֐^ */
typedef int (*usb_class_exit_callback_t)(void * stCallback);					/** NXhCo IR[obN֐^ */

/** NXhCoUSB Hostɓo^(Usbh_Api_DriverRegister)
    o^(Usbh_Api_DriverUnRegister)邽߂̍\<p>
    ^C~O F NXhCoCjV<p>
    폜^C~O F NXhCo폜 */
struct class_driver_reginfo {

    usb_common_callback_t			attach;										/** foCXڑɃR[R[obN֐ */
    usb_common_callback_t			detach;										/** foCXؒfɃR[R[obN֐ */

	usb_class_reregi_callback_t		class_reregi_callback;						/** NXhCo R[obNēo^֐|C^ */
	usb_class_exit_callback_t		class_exit_callback;						/** NXhCo I֐|C^(Init̓Avݒ肷邽߁Aapp_callback_info^ŕێ) */
    struct usb_class_driver_ids		*id_table;									/** ΉhCoɎgpIDe[u */
    void 							*context;									/** APIbpŎgpReLXg(A^b`^f^b`œnꂽʑŎw肷Bj */
	class_driver_type				class_id;									/** NXID */
};


// ڑR[obN context
typedef struct _usb_cbcontext_dev_attach {
    struct usbd_usb_deviceinfo * usbdev;
    void* context;
} usb_cbcontext_dev_attach;

// ؒfR[obN context

typedef struct _usb_cbcontext_dev_detach {
    struct usbd_usb_deviceinfo * usbdev;
    void* context;
} usb_cbcontext_dev_detach;




// *************************************************************************************************
//	extern
// *************************************************************************************************
//------------------------------------------------------------------------------
//	USB_CORE APIꗗ
//------------------------------------------------------------------------------
extern uhs_status_t Usbc_Api_DriverRegister(struct class_driver_reginfo * driver_info);
extern void         Usbc_Api_DriverUnRegister(struct class_driver_reginfo * driver_info);
extern uhs_status_t Usbc_Api_ControlMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbc_Api_BulkMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbc_Api_IntMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbc_Api_IsoMsg(struct usb_control_block* ucb);
extern uhs_status_t Usbc_Api_StopTrans(struct usb_control_block* ucb);
extern uhs_status_t Usbc_Api_StdGetDescriptor(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit8_t type, uhs_ubit8_t index, uhs_ubit16_t wIndex, void *buf, uhs_ubit32_t size);
extern uhs_status_t Usbc_Api_StdClrFeature(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit8_t bmRequest, uhs_ubit16_t feature_select, uhs_ubit16_t wIndex);
extern uhs_status_t Usbc_Api_StdSetFeature(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit8_t bmRequest, uhs_ubit16_t feature_select, uhs_ubit16_t wIndex);
extern uhs_status_t Usbc_Api_StdGetStatus(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit8_t bmRequest, uhs_ubit16_t wIndex, void *buf);
extern uhs_status_t Usbc_Api_StdSetAddress(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit16_t address);
extern uhs_status_t Usbc_Api_StdSetDescriptor(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit8_t type, uhs_ubit8_t index, uhs_ubit16_t wIndex, void *buf, uhs_ubit32_t size);
extern uhs_status_t Usbc_Api_StdGetInterface(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit16_t wIndex, void *buf);
extern uhs_status_t Usbc_Api_StdGetConfiguration(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, void *buf);
extern uhs_status_t Usbc_Api_StdSetInterface(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit16_t intf_num, uhs_ubit16_t alt_num);
extern uhs_status_t Usbc_Api_StdSetConfig(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit16_t config_num);
extern uhs_status_t Usbc_Api_StdSynchFrame(struct usb_control_block* ucb, struct usbd_usb_deviceinfo* usbdev, uhs_ubit8_t endpoint, void *buf);
extern uhs_status_t Usbc_Api_AllocUsbDev(struct usbd_usb_deviceinfo ** usbdev);
extern uhs_status_t Usbc_Api_FreeUsbDev(struct usbd_usb_deviceinfo * usbdev);
extern uhs_status_t Usbc_Api_AllocUsbCtrlBlock(struct usb_control_block ** ucb);
extern uhs_status_t Usbc_Api_FreeUsbCtrlBlock(struct usb_control_block * ucb);
extern struct usb_endpoint_descriptor *Usbc_Api_GetEpDescriptor(struct usbd_usb_deviceinfo *usbdev, uhs_ubit8_t conf_num, uhs_ubit8_t intf_num, uhs_ubit8_t ep_type, uhs_ubit8_t ep_dir);
extern struct usb_endpoint_descriptor *Usbc_Api_GetEpDescriptorEx(struct usbd_usb_deviceinfo * usbdev, uhs_ubit8_t conf_num, uhs_ubit8_t intf_num, uhs_ubit8_t ep_type, uhs_ubit8_t ep_dir, 
    uhs_ubit8_t ep_num);
extern void Usbc_Api_FixupUsbCtrlBlock(struct usb_control_block * ucb, struct usbd_usb_deviceinfo* usbdev,  uhs_ubit32_t pipe,  usb_device_request_t *setup_data,
                    void *data_buf, uhs_ubit32_t data_len, uhs_ubit8_t interval, usb_complete_t complete_func, void     *context);
extern uhs_status_t Usbc_Api_OpenPipe(struct usb_control_block* ucb);
extern uhs_status_t Usbc_Api_ClosePipe(struct usb_control_block* ucb);
extern uhs_boolean_t Usbc_Api_PipeIsOpened(struct usb_control_block* ucb);

extern uhs_ubit32_t Usbc_Api_GetPipeMaxPktSize(uhs_ubit32_t pipe);
extern void Usbc_Api_FixupPipeInfo( uhs_ubit32_t *pipe, uhs_ubit8_t usb_addr, uhs_ubit8_t ep_num, uhs_ubit8_t packet_id, uhs_ubit8_t ep_type, uhs_ubit32_t maxpkt_size);
extern uhs_ubit32_t Usbc_Api_GetPipeAddr(uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbc_Api_GetPipeEpNum(uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbc_Api_GetPipePID(uhs_ubit32_t pipe);
extern uhs_boolean_t Usbc_Api_GetPipeDirIn(uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbc_Api_GetPipeEpType(uhs_ubit32_t pipe);
extern uhs_ubit32_t Usbc_Api_GetPipeMaxPktSize(uhs_ubit32_t pipe);
extern uhs_status_t	Usbc_Api_NotifyStartSuspend( struct usbd_usb_deviceinfo * usbdev );
extern uhs_status_t	Usbc_Api_NotifyFinishSuspend( struct usbd_usb_deviceinfo * usbdev );



//------------------------------------------------------------------------------
//  }N`
//------------------------------------------------------------------------------
/** Rg[]pUCBݒAPI */
#define Usb_Core_FixupCtrlUcb(ucb, usbdev, pipe, setup, buf, size, function, context)   \
            Usbc_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, setup, buf, size, 0x00, function, context)
/** oN]pUCBݒAPI */
#define Usb_Core_FixupBulkUcb(ucb, usbdev, pipe, buf, size, function, context)  \
            Usbc_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, NULL, buf, size, 0, function, context)
/** C^vg]pUCBݒAPI */
#define Usb_Core_FixupIntrUcb(ucb, usbdev, pipe, buf, size, interval, function, context)    \
            Usbc_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, NULL, buf, size, interval, function, context)
/** AC\]pUCBݒAPI */
#define Usb_Core_FixupIsoUcb(ucb, usbdev, pipe, buf, size, function, context)   \
            Usbc_Api_FixupUsbCtrlBlock(ucb, usbdev, pipe, NULL, buf, size, 0, function, context)





#endif
// end of __USBC_API_H__


//End of File
//  usbc_api.h

