/**
 * @brief		DMAC Primitive
 * @author		AXELL CORPORATION
 * @description	DMAC Primitive Layer.
 * @note		none
 * @history		2017_02_22  
 * @history		2017_05_09  [#1302]}X^[CSVXVɔύX
 * @history		2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */
/* DOM-IGNORE-END */

#include "AG903_common.h"
#include "dmac/dmacprm.h"
#include "register/AG903_dmacreg.h"

/** DMAC `l */
#define DMAC_UNIT_MAX  			(AG903_DMAC_UNIT_NUM)

/** DMAC ytFI/F */
#define DMAC_IF_MAX    			(AG903_DMAC_PORT_NUM)

/** DMACCxg */
#define DMAC_EVENT_MAX 			(AG903_DMAC_EVENT_NUM)


/**
 * @brief           INTWX^̓ǂݍ. 
 * @param           *stat [out] 荞ݏ
 * @return          none
 * @description     AG903_DMAC->INT 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetINT(uint32_t *stat)
{
	ASSERT(stat != NULL);

	*stat = (AG903_DMAC->INT & AG903_DMAC_INT_Intr_MSK)
			>> AG903_DMAC_INT_Intr_POS;
}

/**
 * @brief           TIMECOUNT_INTWX^̓ǂݍ. 
 * @param           *stat [out] ^[~iJEg荞ݏ
 * @return          none
 * @description     AG903_DMAC->TIMECOUNT_INT 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetTIMECOUNT_INT(uint32_t *stat)
{
	ASSERT(stat != NULL);

	*stat = (AG903_DMAC->TIMECOUNT_INT & AG903_DMAC_TIMECOUNT_INT_TCIntr_MSK)
			>> AG903_DMAC_TIMECOUNT_INT_TCIntr_POS;
}

/**
 * @brief           TIMECOUNT_INT_CLEARWX^ւ̏. 
 * @param           clear [in] ^[~iJEg荞݃NArbg
 * @return          none
 * @description     AG903_DMAC->TIMECOUNT_INT_CLEAR ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetTIMECOUNT_INT_CLEAR(uint32_t clear)
{
	AG903_DMAC->TIMECOUNT_INT_CLEAR =
		(clear << AG903_DMAC_TIMECOUNT_INT_CLEAR_TCIntrClr_POS) & AG903_DMAC_TIMECOUNT_INT_CLEAR_TCIntrClr_MSK;
}

/**
 * @brief           ERR_ABORT_INTWX^̓ǂݍ. 
 * @param           *err [out] G[荞ݏ
 * @param           *wdt [out] EHb`hbO^C}^CAEg
 * @param           *abt [out] A{[g荞ݏ
 * @return          none
 * @description     AG903_DMAC->ERR_ABORT_INT 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetERR_ABORT_INT(uint32_t *err, uint32_t *wdt, uint32_t *abt)
{
	ASSERT(err != NULL);
	ASSERT(wdt != NULL);
	ASSERT(abt != NULL);

	uint32_t reg = AG903_DMAC->ERR_ABORT_INT;
	*err = (reg & AG903_DMAC_ERR_ABORT_INT_ErrIntr_MSK) >> AG903_DMAC_ERR_ABORT_INT_ErrIntr_POS;
	*wdt = (reg & AG903_DMAC_ERR_ABORT_INT_WdtIntr_MSK) >> AG903_DMAC_ERR_ABORT_INT_WdtIntr_POS;
	*abt = (reg & AG903_DMAC_ERR_ABORT_INT_AbtIntr_MSK) >> AG903_DMAC_ERR_ABORT_INT_AbtIntr_POS;
}

/**
 * @brief           ERR_ABORT_INT_CLEARWX^ւ̏. 
 * @param           err [in] G[荞݃NArbg
 * @param           wdt [in] EHb`hbO^C}^CAEgNArbg
 * @param           abt [in] A{[g荞݃NArbg
 * @return          none
 * @description     AG903_DMAC->ERR_ABORT_INT_CLEAR ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetERR_ABORT_INT_CLEAR(uint32_t err, uint32_t wdt, uint32_t abt)
{
	uint32_t reg = 0;
	reg |= (err << AG903_DMAC_ERR_ABORT_INT_CLEAR_ErrIntrClr_POS) & AG903_DMAC_ERR_ABORT_INT_CLEAR_ErrIntrClr_MSK;
	reg |= (wdt << AG903_DMAC_ERR_ABORT_INT_CLEAR_WdtIntrClr_POS) & AG903_DMAC_ERR_ABORT_INT_CLEAR_WdtIntrClr_MSK;
	reg |= (abt << AG903_DMAC_ERR_ABORT_INT_CLEAR_AbtIntrClr_POS) & AG903_DMAC_ERR_ABORT_INT_CLEAR_AbtIntrClr_MSK;
	AG903_DMAC->ERR_ABORT_INT_CLEAR = reg;
}

/**
 * @brief           TIMECOUNT_STATUSWX^̓ǂݍ. 
 * @param           *stat [out] ^[~iJEg
 * @return          none
 * @description     AG903_DMAC->TIMECOUNT_STATUS 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetTIMECOUNT_STATUS(uint32_t *stat)
{
	ASSERT(stat != NULL);

	*stat = (AG903_DMAC->TIMECOUNT_STATUS & AG903_DMAC_TIMECOUNT_STATUS_TCStatus_MSK)
			>> AG903_DMAC_TIMECOUNT_STATUS_TCStatus_POS;
}

/**
 * @brief           ERR_ABORT_STATUSWX^̓ǂݍ. 
 * @param           *err [out] G[
 * @param           *wdt [out] EHb`hbO^C}^CAEg
 * @param           *abt [out] A{[g
 * @return          none
 * @description     AG903_DMAC->ERR_ABORT_STATUS 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetERR_ABORT_STATUS(uint32_t *err, uint32_t *wdt, uint32_t *abt)
{
	ASSERT(err != NULL);
	ASSERT(wdt != NULL);
	ASSERT(abt != NULL);

	uint32_t reg = AG903_DMAC->ERR_ABORT_STATUS;
	*err = (reg & AG903_DMAC_ERR_ABORT_STATUS_ErrStatus_MSK) >> AG903_DMAC_ERR_ABORT_STATUS_ErrStatus_POS;
	*wdt = (reg & AG903_DMAC_ERR_ABORT_STATUS_WdtStatus_MSK) >> AG903_DMAC_ERR_ABORT_STATUS_WdtStatus_POS;
	*abt = (reg & AG903_DMAC_ERR_ABORT_STATUS_AbtStatus_MSK) >> AG903_DMAC_ERR_ABORT_STATUS_AbtStatus_POS;
}

/**
 * @brief           CHANNEL_ENABLEWX^̓ǂݍ. 
 * @param           *enable [out] Cl[u
 * @return          none
 * @description     AG903_DMAC->CHANNEL_ENABLE 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetCHANNEL_ENABLE(uint32_t *enable)
{
	ASSERT(enable != NULL);

	*enable = (AG903_DMAC->CHANNEL_ENABLE & AG903_DMAC_CHANNEL_ENABLE_ChEnable_MSK)
			  >> AG903_DMAC_CHANNEL_ENABLE_ChEnable_POS;
}

/**
 * @brief           CHANNEL_ENABLEWX^ւ̏. 
 * @param           enable [in] Cl[urbg
 * @return          none
 * @description     AG903_DMAC->CHANNEL_ENABLE ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetCHANNEL_ENABLE(uint32_t enable)
{
	AG903_DMAC->CHANNEL_ENABLE =
		(enable << AG903_DMAC_CHANNEL_ENABLE_ChEnable_POS) & AG903_DMAC_CHANNEL_ENABLE_ChEnable_MSK;
}

/**
 * @brief           SYNC_PERI_IFWX^̓ǂݍ. 
 * @param           *enable [out] ytFC^[tF[Xݒ
 * @return          none
 * @description     AG903_DMAC->SYNC_PERI_IF 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetSYNC_PERI_IF(uint32_t *enable)
{
	ASSERT(enable != NULL);

	*enable = (AG903_DMAC->SYNC_PERI_IF & AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_MSK)
			  >> AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_POS;
}

/**
 * @brief           SYNC_PERI_IFWX^ւ̏. 
 * @param           enable [in] ytFC^[tF[Xݒ
 * @return          none
 * @description     AG903_DMAC->SYNC_PERI_IF ɃCg܂. 
 * @note            ̃WX^́AuFFFFhvŎgpĂB
 */
void AG903_DMACPrmSetSYNC_PERI_IF(uint32_t enable)
{
	AG903_DMAC->SYNC_PERI_IF =
		(enable << AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_POS) & AG903_DMAC_SYNC_PERI_IF_SyncDmaReq_MSK;
}

/**
 * @brief           LOCAL_DESC_MEM_BASEWX^̓ǂݍ. 
 * @param           *base [out] fBXNv^x[XAhX
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_BASE 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetLOCAL_DESC_MEM_BASE(uint32_t *base)
{
	ASSERT(base != NULL);

	*base = AG903_DMAC->LOCAL_DESC_MEM_BASE;;
}

/**
 * @brief           LOCAL_DESC_MEM_BASEWX^ւ̏. 
 * @param           base [in] fBXNv^x[XAhX
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_BASE ɃCg܂. 
 * @note            ʏ̎gpł́AuFD1hvݒ肵ĂB
 */
void AG903_DMACPrmSetLOCAL_DESC_MEM_BASE(uint32_t base)
{
	AG903_DMAC->LOCAL_DESC_MEM_BASE = base & AG903_DMAC_LOCAL_DESC_MEM_BASE_LDMBase_MSK;
}

/**
 * @brief           WATCHDOG_TIMERWX^̓ǂݍ. 
 * @param           *wdt [out] ^CAEg
 * @return          none
 * @description     AG903_DMAC->WATCHDOG_TIMER 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetWATCHDOG_TIMER(uint32_t *wdt)
{
	ASSERT(wdt != NULL);

	*wdt = (AG903_DMAC->WATCHDOG_TIMER & AG903_DMAC_WATCHDOG_TIMER_WDTimer_MSK)
		   >> AG903_DMAC_WATCHDOG_TIMER_WDTimer_POS;
}

/**
 * @brief           WATCHDOG_TIMERWX^ւ̏. 
 * @param           wdt [in] ^CAEg
 * @return          none
 * @description     AG903_DMAC->WATCHDOG_TIMER ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetWATCHDOG_TIMER(uint32_t wdt)
{
	AG903_DMAC->WATCHDOG_TIMER =
		(wdt << AG903_DMAC_WATCHDOG_TIMER_WDTimer_POS) & AG903_DMAC_WATCHDOG_TIMER_WDTimer_MSK;
}

/**
 * @brief           GLOBAL_EVENTWX^̓ǂݍ. 
 * @param           *event [out] O[oCxg
 * @return          none
 * @description     AG903_DMAC->GLOBAL_EVENT 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetGLOBAL_EVENT(uint32_t *event)
{
	ASSERT(event != NULL);

	*event = (AG903_DMAC->GLOBAL_EVENT & AG903_DMAC_GLOBAL_EVENT_GlbEvent_MSK)
			 >> AG903_DMAC_GLOBAL_EVENT_GlbEvent_POS;
}

/**
 * @brief           GLOBAL_EVENTWX^ւ̏. 
 * @param           set [in] O[oCxgZbgrbg
 * @param           clear [in] O[oCxgNArbg
 * @return          none
 * @description     AG903_DMAC->GLOBAL_EVENT ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetGLOBAL_EVENT(uint32_t set, uint32_t clear)
{
	uint32_t reg = 0;
	reg |= (set   << AG903_DMAC_GLOBAL_EVENT_GlbEventSet_POS) & AG903_DMAC_GLOBAL_EVENT_GlbEventSet_MSK;
	reg |= (clear << AG903_DMAC_GLOBAL_EVENT_GlbEventClr_POS) & AG903_DMAC_GLOBAL_EVENT_GlbEventClr_MSK;
	AG903_DMAC->GLOBAL_EVENT = reg;
}

/**
 * @brief           PSLVERR_ENABLEWX^̓ǂݍ. 
 * @param           *enable [out] G[ݒ
 * @return          none
 * @description     AG903_DMAC->PSLVERR_ENABLE 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetPSLVERR_ENABLE(uint32_t *enable)
{
	ASSERT(enable != NULL);

	*enable = (AG903_DMAC->PSLVERR_ENABLE & AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_MSK)
			  >> AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_POS;
}

/**
 * @brief           PSLVERR_ENABLEWX^ւ̏. 
 * @param           enable [in] G[ݒ
 * @return          none
 * @description     AG903_DMAC->PSLVERR_ENABLE ɃCg܂. 
 * @note            ݂ȂWX^ւ̃ANZX̃G[ݒ
 */
void AG903_DMACPrmSetPSLVERR_ENABLE(uint32_t enable)
{
	AG903_DMAC->PSLVERR_ENABLE =
		(enable << AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_POS) & AG903_DMAC_PSLVERR_ENABLE_PSlvErrEn_MSK;
}

/**
 * @brief           REVISION_NUMBERWX^̓ǂݍ. 
 * @param           *rev [out] rW
 * @return          none
 * @description     AG903_DMAC->REVISION_NUMBER 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetREVISION_NUMBER(uint32_t *rev)
{
	ASSERT(rev != NULL);

	*rev = AG903_DMAC->REVISION_NUMBER;
}

/**
 * @brief           HW_FEATUREWX^̓ǂݍ. 
 * @param           *feature [out] @\
 * @return          none
 * @description     AG903_DMAC->HW_FEATURE 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetHW_FEATURE(DMACPrmParamFEATURE *feature)
{
	ASSERT(feature != NULL);

	uint32_t reg = AG903_DMAC->HW_FEATURE;
	feature->ChNum		 = (reg & AG903_DMAC_HW_FEATURE_ChNum_MSK      ) >> AG903_DMAC_HW_FEATURE_ChNum_POS;
	feature->UnalignMode = (reg & AG903_DMAC_HW_FEATURE_UnalignMode_MSK) >> AG903_DMAC_HW_FEATURE_UnalignMode_POS;
	feature->DWidth		 = (reg & AG903_DMAC_HW_FEATURE_DWidth_MSK     ) >> AG903_DMAC_HW_FEATURE_DWidth_POS;
	feature->SLVDWidth	 = (reg & AG903_DMAC_HW_FEATURE_SLVDWidth_MSK  ) >> AG903_DMAC_HW_FEATURE_SLVDWidth_POS;
	feature->DFDepth	 = (reg & AG903_DMAC_HW_FEATURE_DFDepth_MSK    ) >> AG903_DMAC_HW_FEATURE_DFDepth_POS;
	feature->PriOn		 = (reg & AG903_DMAC_HW_FEATURE_PriOn_MSK      ) >> AG903_DMAC_HW_FEATURE_PriOn_POS;
	feature->PriNum		 = (reg & AG903_DMAC_HW_FEATURE_PriNum_MSK     ) >> AG903_DMAC_HW_FEATURE_PriNum_POS;
	feature->LdmOn		 = (reg & AG903_DMAC_HW_FEATURE_LdmOn_MSK      ) >> AG903_DMAC_HW_FEATURE_LdmOn_POS;
	feature->LdmDepth	 = (reg & AG903_DMAC_HW_FEATURE_LdmDepth_MSK   ) >> AG903_DMAC_HW_FEATURE_LdmDepth_POS;
	feature->CmdDepth	 = (reg & AG903_DMAC_HW_FEATURE_CmdDepth_MSK   ) >> AG903_DMAC_HW_FEATURE_CmdDepth_POS;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_0WX^̓ǂݍ. 
 * @param           *flag [out] fBXNv^󂫏
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_0 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_0(uint32_t *flag)
{
	ASSERT(flag != NULL);

	*flag = AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_0;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_0WX^ւ̏. 
 * @param           flag [in] fBXNv^󂫏Ԑݒ
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_0 ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_0(uint32_t flag)
{
	AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_0 = flag;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_1WX^̓ǂݍ. 
 * @param           *flag [out] fBXNv^󂫏
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_1 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_1(uint32_t *flag)
{
	ASSERT(flag != NULL);

	*flag = AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_1;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_1WX^ւ̏. 
 * @param           flag [in] fBXNv^󂫏Ԑݒ
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_1 ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_1(uint32_t flag)
{
	AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_1 = flag;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_2WX^̓ǂݍ. 
 * @param           *flag [out] fBXNv^󂫏
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_2 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_2(uint32_t *flag)
{
	ASSERT(flag != NULL);

	*flag = AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_2;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_2WX^ւ̏. 
 * @param           flag [in] fBXNv^󂫏Ԑݒ
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_2 ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_2(uint32_t flag)
{
	AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_2 = flag;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_3WX^̓ǂݍ. 
 * @param           *flag [out] fBXNv^󂫏
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_3 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetLOCAL_DESC_MEM_FREE_FLAG_SET_3(uint32_t *flag)
{
	ASSERT(flag != NULL);

	*flag = AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_3;
}

/**
 * @brief           LOCAL_DESC_MEM_FREE_FLAG_SET_3WX^ւ̏. 
 * @param           flag [in] fBXNv^󂫏Ԑݒ
 * @return          none
 * @description     AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_3 ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetLOCAL_DESC_MEM_FREE_FLAG_SET_3(uint32_t flag)
{
	AG903_DMAC->LOCAL_DESC_MEM_FREE_FLAG_SET_3 = flag;
}

/**
 * @brief           ENDIAN_CONVERSIONWX^̓ǂݍ. 
 * @param           *ec [out] GfBAϊݒ
 * @param           *lmec [out] [JfBXNv^GfBAϊݒ
 * @return          none
 * @description     AG903_DMAC->ENDIAN_CONVERSION 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetENDIAN_CONVERSION(uint32_t *ec, uint32_t *lmec)
{
	ASSERT(ec != NULL);
	ASSERT(lmec != NULL);

	uint32_t reg = AG903_DMAC->ENDIAN_CONVERSION;
	*ec   = (reg & AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_MSK)
			>> AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_POS;
	*lmec = (reg & AG903_DMAC_ENDIAN_CONVERSION_LMEC_MSK)
			>> AG903_DMAC_ENDIAN_CONVERSION_LMEC_POS;
}

/**
 * @brief           ENDIAN_CONVERSIONWX^ւ̏. 
 * @param           ec [in] GfBAϊݒ
 * @param           lmec [in] [JfBXNv^GfBAϊݒ
 * @return          none
 * @description     AG903_DMAC->ENDIAN_CONVERSION ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetENDIAN_CONVERSION(uint32_t ec, uint32_t lmec)
{
	uint32_t reg = 0;
	reg |= (ec   << AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_POS)
		   & AG903_DMAC_ENDIAN_CONVERSION_EndianConvert_MSK;
	reg |= (lmec << AG903_DMAC_ENDIAN_CONVERSION_LMEC_POS)
		   & AG903_DMAC_ENDIAN_CONVERSION_LMEC_MSK;
	AG903_DMAC->ENDIAN_CONVERSION = reg;
}

/**
 * @brief           CONSTANT_VALUE_WRITE_ONLYWX^̓ǂݍ. 
 * @param           *value [out] ݐp[h萔l
 * @return          none
 * @description     AG903_DMAC->CONSTANT_VALUE_WRITE_ONLY 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetCONSTANT_VALUE_WRITE_ONLY(uint32_t *value)
{
	ASSERT(value != NULL);

	*value = AG903_DMAC->CONSTANT_VALUE_WRITE_ONLY;
}

/**
 * @brief           CONSTANT_VALUE_WRITE_ONLYWX^ւ̏. 
 * @param           value [in] ݐp[h萔lݒ
 * @return          none
 * @description     AG903_DMAC->CONSTANT_VALUE_WRITE_ONLY ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetCONSTANT_VALUE_WRITE_ONLY(uint32_t value)
{
	AG903_DMAC->CONSTANT_VALUE_WRITE_ONLY = value;
}

/**
 * @brief           CTRL_REGWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *ctrl [out] Rg[ݒ
 * @return          none
 * @description     AG903_DMAC->CTRL_REG 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetCTRL_REG(uint8_t unit, DMACPrmParamCTRL *ctrl)
{
	ASSERT(ctrl != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = AG903_DMACn(unit)->CTRL_REG;
	ctrl->ChWEvent = (reg & AG903_DMACn_CTRL_REG_ChWEvent_MSK) >> AG903_DMACn_CTRL_REG_ChWEvent_POS;
	ctrl->WSync    = (reg & AG903_DMACn_CTRL_REG_WSync_MSK   ) >> AG903_DMACn_CTRL_REG_WSync_POS;
	ctrl->ChSEvent = (reg & AG903_DMACn_CTRL_REG_ChSEvent_MSK) >> AG903_DMACn_CTRL_REG_ChSEvent_POS;
	ctrl->SEventEn = (reg & AG903_DMACn_CTRL_REG_SEventEn_MSK) >> AG903_DMACn_CTRL_REG_SEventEn_POS;
	ctrl->WEventEn = (reg & AG903_DMACn_CTRL_REG_WEventEn_MSK) >> AG903_DMACn_CTRL_REG_WEventEn_POS;
	ctrl->DEn      = (reg & AG903_DMACn_CTRL_REG_DEn_MSK     ) >> AG903_DMACn_CTRL_REG_DEn_POS;
	ctrl->ExpEn    = (reg & AG903_DMACn_CTRL_REG_ExpEn_MSK   ) >> AG903_DMACn_CTRL_REG_ExpEn_POS;
	ctrl->ChEn     = (reg & AG903_DMACn_CTRL_REG_ChEn_MSK    ) >> AG903_DMACn_CTRL_REG_ChEn_POS;
	ctrl->WDTEn    = (reg & AG903_DMACn_CTRL_REG_WDTEn_MSK   ) >> AG903_DMACn_CTRL_REG_WDTEn_POS;
	ctrl->DstCtrl  = (reg & AG903_DMACn_CTRL_REG_DstCtrl_MSK ) >> AG903_DMACn_CTRL_REG_DstCtrl_POS;
	ctrl->SrcCtrl  = (reg & AG903_DMACn_CTRL_REG_SrcCtrl_MSK ) >> AG903_DMACn_CTRL_REG_SrcCtrl_POS;
	ctrl->DstWidth = (reg & AG903_DMACn_CTRL_REG_DstWidth_MSK) >> AG903_DMACn_CTRL_REG_DstWidth_POS;
	ctrl->SrcWidth = (reg & AG903_DMACn_CTRL_REG_SrcWidth_MSK) >> AG903_DMACn_CTRL_REG_SrcWidth_POS;
	ctrl->TCMsk    = (reg & AG903_DMACn_CTRL_REG_TCMsk_MSK   ) >> AG903_DMACn_CTRL_REG_TCMsk_POS;
	ctrl->SrcTcnt  = (reg & AG903_DMACn_CTRL_REG_SrcTcnt_MSK ) >> AG903_DMACn_CTRL_REG_SrcTcnt_POS;
}

/**
 * @brief           CTRL_REGWX^ւ̏. 
 * @param           unit [in] `l
 * @param           *ctrl [in] Rg[ݒ
 * @return          none
 * @description     AG903_DMAC->CTRL_REG ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetCTRL_REG(uint8_t unit, DMACPrmParamCTRL *ctrl)
{
	ASSERT(ctrl != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = 0;
	reg |= (ctrl->ChWEvent << AG903_DMACn_CTRL_REG_ChWEvent_POS) & AG903_DMACn_CTRL_REG_ChWEvent_MSK;
	reg |= (ctrl->WSync    << AG903_DMACn_CTRL_REG_WSync_POS   ) & AG903_DMACn_CTRL_REG_WSync_MSK;
	reg |= (ctrl->ChSEvent << AG903_DMACn_CTRL_REG_ChSEvent_POS) & AG903_DMACn_CTRL_REG_ChSEvent_MSK;
	reg |= (ctrl->SEventEn << AG903_DMACn_CTRL_REG_SEventEn_POS) & AG903_DMACn_CTRL_REG_SEventEn_MSK;
	reg |= (ctrl->WEventEn << AG903_DMACn_CTRL_REG_WEventEn_POS) & AG903_DMACn_CTRL_REG_WEventEn_MSK;
	reg |= (ctrl->DEn      << AG903_DMACn_CTRL_REG_DEn_POS     ) & AG903_DMACn_CTRL_REG_DEn_MSK;
	reg |= (ctrl->ExpEn    << AG903_DMACn_CTRL_REG_ExpEn_POS   ) & AG903_DMACn_CTRL_REG_ExpEn_MSK;
	reg |= (ctrl->ChEn     << AG903_DMACn_CTRL_REG_ChEn_POS    ) & AG903_DMACn_CTRL_REG_ChEn_MSK;
	reg |= (ctrl->WDTEn    << AG903_DMACn_CTRL_REG_WDTEn_POS   ) & AG903_DMACn_CTRL_REG_WDTEn_MSK;
	reg |= (ctrl->DstCtrl  << AG903_DMACn_CTRL_REG_DstCtrl_POS ) & AG903_DMACn_CTRL_REG_DstCtrl_MSK;
	reg |= (ctrl->SrcCtrl  << AG903_DMACn_CTRL_REG_SrcCtrl_POS ) & AG903_DMACn_CTRL_REG_SrcCtrl_MSK;
	reg |= (ctrl->DstWidth << AG903_DMACn_CTRL_REG_DstWidth_POS) & AG903_DMACn_CTRL_REG_DstWidth_MSK;
	reg |= (ctrl->SrcWidth << AG903_DMACn_CTRL_REG_SrcWidth_POS) & AG903_DMACn_CTRL_REG_SrcWidth_MSK;
	reg |= (ctrl->TCMsk    << AG903_DMACn_CTRL_REG_TCMsk_POS   ) & AG903_DMACn_CTRL_REG_TCMsk_MSK;
	reg |= (ctrl->SrcTcnt  << AG903_DMACn_CTRL_REG_SrcTcnt_POS ) & AG903_DMACn_CTRL_REG_SrcTcnt_MSK;
	AG903_DMACn(unit)->CTRL_REG = reg;
}

/**
 * @brief           CFG_REGWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *cfg [out] RtBO[Vݒ
 * @return          none
 * @description     AG903_DMAC->CFG_REG 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetCFG_REG(uint8_t unit, DMACPrmParamCFG *cfg)
{
	ASSERT(cfg != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = AG903_DMACn(unit)->CFG_REG;
	cfg->TCIntMsk    = (reg & AG903_DMACn_CFG_REG_TCIntMsk_MSK   ) >> AG903_DMACn_CFG_REG_TCIntMsk_POS;
	cfg->ErrIntMsk   = (reg & AG903_DMACn_CFG_REG_ErrIntMsk_MSK  ) >> AG903_DMACn_CFG_REG_ErrIntMsk_POS;
	cfg->AbtIntMsk   = (reg & AG903_DMACn_CFG_REG_AbtIntMsk_MSK  ) >> AG903_DMACn_CFG_REG_AbtIntMsk_POS;
	cfg->SrcRS       = (reg & AG903_DMACn_CFG_REG_SrcRS_MSK      ) >> AG903_DMACn_CFG_REG_SrcRS_POS;
	cfg->SrcHEn      = (reg & AG903_DMACn_CFG_REG_SrcHEn_MSK     ) >> AG903_DMACn_CFG_REG_SrcHEn_POS;
	cfg->DstRS       = (reg & AG903_DMACn_CFG_REG_DstRS_MSK      ) >> AG903_DMACn_CFG_REG_DstRS_POS;
	cfg->DstHEn      = (reg & AG903_DMACn_CFG_REG_DstHEn_MSK     ) >> AG903_DMACn_CFG_REG_DstHEn_POS;
	cfg->LLPCnt      = (reg & AG903_DMACn_CFG_REG_LLPCnt_MSK     ) >> AG903_DMACn_CFG_REG_LLPCnt_POS;
	cfg->ChGntWin    = (reg & AG903_DMACn_CFG_REG_ChGntWin_MSK   ) >> AG903_DMACn_CFG_REG_ChGntWin_POS;
	cfg->ChPri       = (reg & AG903_DMACn_CFG_REG_ChPri_MSK      ) >> AG903_DMACn_CFG_REG_ChPri_POS;
	cfg->WOMode      = (reg & AG903_DMACn_CFG_REG_WOMode_MSK     ) >> AG903_DMACn_CFG_REG_WOMode_POS;
	cfg->UnalignMode = (reg & AG903_DMACn_CFG_REG_UnalignMode_MSK) >> AG903_DMACn_CFG_REG_UnalignMode_POS;
}

/**
 * @brief           CFG_REGWX^ւ̏. 
 * @param           unit [in] `l
 * @param           *cfg [in] RtBO[Vݒ
 * @return          none
 * @description     AG903_DMAC->CFG_REG ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetCFG_REG(uint8_t unit, DMACPrmParamCFG *cfg)
{
	ASSERT(cfg != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = 0;
	reg |= (cfg->TCIntMsk    << AG903_DMACn_CFG_REG_TCIntMsk_POS   ) & AG903_DMACn_CFG_REG_TCIntMsk_MSK;
	reg |= (cfg->ErrIntMsk   << AG903_DMACn_CFG_REG_ErrIntMsk_POS  ) & AG903_DMACn_CFG_REG_ErrIntMsk_MSK;
	reg |= (cfg->AbtIntMsk   << AG903_DMACn_CFG_REG_AbtIntMsk_POS  ) & AG903_DMACn_CFG_REG_AbtIntMsk_MSK;
	reg |= (cfg->SrcRS       << AG903_DMACn_CFG_REG_SrcRS_POS      ) & AG903_DMACn_CFG_REG_SrcRS_MSK;
	reg |= (cfg->SrcHEn      << AG903_DMACn_CFG_REG_SrcHEn_POS     ) & AG903_DMACn_CFG_REG_SrcHEn_MSK;
	reg |= (cfg->DstRS       << AG903_DMACn_CFG_REG_DstRS_POS      ) & AG903_DMACn_CFG_REG_DstRS_MSK;
	reg |= (cfg->DstHEn      << AG903_DMACn_CFG_REG_DstHEn_POS     ) & AG903_DMACn_CFG_REG_DstHEn_MSK;
	reg |= (cfg->LLPCnt      << AG903_DMACn_CFG_REG_LLPCnt_POS     ) & AG903_DMACn_CFG_REG_LLPCnt_MSK;
	reg |= (cfg->ChGntWin    << AG903_DMACn_CFG_REG_ChGntWin_POS   ) & AG903_DMACn_CFG_REG_ChGntWin_MSK;
	reg |= (cfg->ChPri       << AG903_DMACn_CFG_REG_ChPri_POS      ) & AG903_DMACn_CFG_REG_ChPri_MSK;
	reg |= (cfg->WOMode      << AG903_DMACn_CFG_REG_WOMode_POS     ) & AG903_DMACn_CFG_REG_WOMode_MSK;
	reg |= (cfg->UnalignMode << AG903_DMACn_CFG_REG_UnalignMode_POS) & AG903_DMACn_CFG_REG_UnalignMode_MSK;
	AG903_DMACn(unit)->CFG_REG = reg;

}

/**
 * @brief           SRC_ADDRWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *addr [out] ]AhX
 * @return          none
 * @description     AG903_DMAC->SRC_ADDR 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetSRC_ADDR(uint8_t unit, uint32_t *addr)
{
	ASSERT(addr != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	*addr = AG903_DMACn(unit)->SRC_ADDR;
}

/**
 * @brief           SRC_ADDRWX^ւ̏. 
 * @param           unit [in] `l
 * @param           addr [in] ]AhX
 * @return          none
 * @description     AG903_DMAC->SRC_ADDR ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetSRC_ADDR(uint8_t unit, uint32_t addr)
{
	ASSERT(unit < DMAC_UNIT_MAX);

	AG903_DMACn(unit)->SRC_ADDR = addr & AG903_DMACn_SRC_ADDR_SrcAddr_MSK;
}

/**
 * @brief           DST_ADDRWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *addr [out] ]AhX
 * @return          none
 * @description     AG903_DMAC->DST_ADDR 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetDST_ADDR(uint8_t unit, uint32_t *addr)
{
	ASSERT(addr != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	*addr = AG903_DMACn(unit)->DST_ADDR;
}

/**
 * @brief           DST_ADDRWX^ւ̏. 
 * @param           unit [in] `l
 * @param           addr [in] ]AhX
 * @return          none
 * @description     AG903_DMAC->DST_ADDR ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetDST_ADDR(uint8_t unit, uint32_t addr)
{
	ASSERT(unit < DMAC_UNIT_MAX);

	AG903_DMACn(unit)->DST_ADDR = addr & AG903_DMACn_DST_ADDR_DstAddr_MSK;
}

/**
 * @brief           LINK_LIST_POINTERWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *addr [out] NXg|C^
 * @return          none
 * @description     AG903_DMAC->LINK_LIST_POINTER 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetLINK_LIST_POINTER(uint8_t unit, uint32_t *addr)
{
	ASSERT(addr != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	*addr = AG903_DMACn(unit)->LINK_LIST_POINTER;
}

/**
 * @brief           LINK_LIST_POINTERWX^ւ̏. 
 * @param           unit [in] `l
 * @param           addr [in] NXg|C^
 * @return          none
 * @description     AG903_DMAC->LINK_LIST_POINTER ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetLINK_LIST_POINTER(uint8_t unit, uint32_t addr)
{
	ASSERT(unit < DMAC_UNIT_MAX);

	AG903_DMACn(unit)->LINK_LIST_POINTER = addr & AG903_DMACn_LINK_LIST_POINTER_LLP_MSK;
}

/**
 * @brief           TRNS_SIZE_1DWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *cnt [out] ]JEg
 * @return          none
 * @description     AG903_DMAC->TRNS_SIZE_1D 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetTRNS_SIZE_1D(uint8_t unit, uint32_t *cnt)
{
	ASSERT(cnt != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	*cnt = (AG903_DMACn(unit)->TRNS_SIZE_1D & AG903_DMACn_TRNS_SIZE_1D_TCnt_MSK)
			>> AG903_DMACn_TRNS_SIZE_1D_TCnt_POS;
}

/**
 * @brief           TRNS_SIZE_1DWX^ւ̏. 
 * @param           unit [in] `l
 * @param           cnt [in] ]JEg
 * @return          none
 * @description     AG903_DMAC->TRNS_SIZE_1D ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetTRNS_SIZE_1D(uint8_t unit, uint32_t cnt)
{
	ASSERT(unit < DMAC_UNIT_MAX);

	AG903_DMACn(unit)->TRNS_SIZE_1D =
		(cnt << AG903_DMACn_TRNS_SIZE_1D_TCnt_POS) & AG903_DMACn_TRNS_SIZE_1D_TCnt_MSK;
}

/**
 * @brief           TRNS_SIZE_2DWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *x_cnt [out] X̓]JEg
 * @param           *y_cnt [out] Y̓]JEg
 * @return          none
 * @description     AG903_DMAC->TRNS_SIZE_2D 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetTRNS_SIZE_2D(uint8_t unit, uint32_t *x_cnt, uint32_t *y_cnt)
{
	ASSERT(x_cnt != NULL);
	ASSERT(y_cnt != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = AG903_DMACn(unit)->TRNS_SIZE_2D;
	*x_cnt = (reg & AG903_DMACn_TRNS_SIZE_2D_XTCnt_MSK) >> AG903_DMACn_TRNS_SIZE_2D_XTCnt_POS;
	*y_cnt = (reg & AG903_DMACn_TRNS_SIZE_2D_YTCnt_MSK) >> AG903_DMACn_TRNS_SIZE_2D_YTCnt_POS;
}

/**
 * @brief           TRNS_SIZE_2DWX^ւ̏. 
 * @param           unit [in] `l
 * @param           x_cnt [in] X̓]JEg
 * @param           y_cnt [in] Y̓]JEg
 * @return          none
 * @description     AG903_DMAC->TRNS_SIZE_2D ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetTRNS_SIZE_2D(uint8_t unit, uint32_t x_cnt, uint32_t y_cnt)
{
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = 0;
	reg |= (x_cnt << AG903_DMACn_TRNS_SIZE_2D_XTCnt_POS) & AG903_DMACn_TRNS_SIZE_2D_XTCnt_MSK;
	reg |= (y_cnt << AG903_DMACn_TRNS_SIZE_2D_YTCnt_POS) & AG903_DMACn_TRNS_SIZE_2D_YTCnt_MSK;
	AG903_DMACn(unit)->TRNS_SIZE_2D = reg;
}

/**
 * @brief           STRIDE_SRC_DST_ADDRWX^̓ǂݍ. 
 * @param           unit [in] `l
 * @param           *src [out] ]XgCh
 * @param           *dst [out] ]XgCh
 * @return          none
 * @description     AG903_DMAC->STRIDE_SRC_DST_ADDR 烊[h܂. 
 * @note            none
 */
void AG903_DMACPrmGetSTRIDE_SRC_DST_ADDR(uint8_t unit, uint32_t *src, uint32_t *dst)
{
	ASSERT(src != NULL);
	ASSERT(dst != NULL);
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = AG903_DMACn(unit)->STRIDE_SRC_DST_ADDR;
	*src = (reg & AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_MSK) >> AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_POS;
	*dst = (reg & AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_MSK) >> AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_POS;
}

/**
 * @brief           STRIDE_SRC_DST_ADDRWX^ւ̏. 
 * @param           unit [in] `l
 * @param           src [in] ]XgCh
 * @param           dst [in] ]XgCh
 * @return          none
 * @description     AG903_DMAC->STRIDE_SRC_DST_ADDR ɃCg܂. 
 * @note            none
 */
void AG903_DMACPrmSetSTRIDE_SRC_DST_ADDR(uint8_t unit, uint32_t src, uint32_t dst)
{
	ASSERT(unit < DMAC_UNIT_MAX);

	uint32_t reg = 0;
	reg |= (src << AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_POS) & AG903_DMACn_STRIDE_SRC_DST_ADDR_SrcStride_MSK;
	reg |= (dst << AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_POS) & AG903_DMACn_STRIDE_SRC_DST_ADDR_DstStride_MSK;
	AG903_DMACn(unit)->STRIDE_SRC_DST_ADDR = reg;
}

