/**
 * @brief           EQS Controller Header
 * @author          AXELL CORPORATION
 * @description     EQS Controller񋟃wb_B<p>EQS ControllergpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef __EQSCTL_H__
#define __EQSCTL_H__
/* DOM-IGNORE-END */

#ifdef __cplusplus
extern "C" {
#endif

/** EQSVXeNbN */
#define	AG903_EQS_SYS_CLK		(200 * 1000 * 1000)

/** ʐM[h */
enum AG903_EQS_MODE_ENUM{
	AG903_EQS_MODE_NORM = 0,	/** SPI[h	*/
	AG903_EQS_MODE_QUAD,		/** SQI[h	*/
};

/** GAw */
enum AG903_EQS_AREA_ENUM{
	AG903_EQS_AREA_0 = 0,		/** AhXItZbg 00000000h`00FFFFFFh	*/
	AG903_EQS_AREA_1,			/** AhXItZbg 01000000h`01FFFFFFh */
	AG903_EQS_AREA_2,			/** AhXItZbg 02000000h`02FFFFFFh */
	AG903_EQS_AREA_3,			/** AhXItZbg 03000000h`03FFFFFFh */
	AG903_EQS_AREA_NUM,			/** GA */
};

/** I/O */
enum AG903_EQS_DIR_ENUM{
	AG903_EQS_DIR_READ = 0,		/** READ	*/
	AG903_EQS_DIR_WRITE,		/** WRITE	*/
};

/** t[ */
enum AG903_EQS_FLOW_ENUM{
	AG903_EQS_FLOW_OFF = 0,		/** t[Ȃ	*/
	AG903_EQS_FLOW_ON,			/** t[䂠	*/
};

/** AhX */
enum AG903_EQS_WIDTH_ENUM{
	AG903_EQS_WIDTH_NONE = 0,	/** o͂Ȃ	*/
	AG903_EQS_WIDTH_8BIT,		/** 8rbg		*/
	AG903_EQS_WIDTH_16BIT,		/** 16rbg	*/
	AG903_EQS_WIDTH_24BIT,		/** 24rbg	*/
};

/** f[^ */
enum AG903_EQS_DATA_ENUM{
	AG903_EQS_DATA_NONE = 0,	/** f[^Ȃ		*/
	AG903_EQS_DATA_BUS,			/** oXɏ]	*/
};

/** EQSݒp[^ */
typedef struct _AG903_EQSCtlFormat {
	uint8_t	command;		/** R}h */
	uint8_t	wait;			/** EFCgTCN */
	uint8_t	data_len;		/** f[^ (Write) */
	uint8_t	addr_len;		/** AhX */
	uint8_t	flow;			/** t[L */
	uint8_t	reserve;		/** \ */
} AG903_EQSCtlFormat;

/*************************************************************************************
 * vg^Cv`
 ************************************************************************************/
int32_t AG903_EQSCtlInit(uint16_t div, uint16_t cnt);
int32_t AG903_EQSCtlSetMode(uint8_t mode);
int32_t AG903_EQSCtlGetAddress(uint8_t ch, uint32_t *addr);
int32_t AG903_EQSCtlSetup(uint8_t area, uint8_t dir, AG903_EQSCtlFormat *format);

#ifdef __cplusplus
}
#endif

#endif/* __OSPMGR_H__ */
