/**
 * @brief           I2C Primitive Header
 * @author          AXELL CORPORATION
 * @description     I2C Primitive񋟃wb_B<p>I2C PrimitivegpincludeĉB
 * @note            none
 * @history         2017_02_22  
 * @history         2017_10_26  Ver2.0
*/
/* DOM-IGNORE-BEGIN */
/*
 * This program was created by AXELL CORPORATION.
 * Copyright (C) 2017 AXELL CORPORATION, all rights reserved.
 */

#ifndef _I2CPRM_H_
#define _I2CPRM_H_
/* DOM-IGNORE-END */

#include <stdint.h>
#include "lib_common/AG903_common.h"
#include "register/AG903_i2creg.h"

#ifdef __cplusplus
extern "C" {
#endif

/** I2C`l */
#define AG903_I2C_CH_NUM			(2)

#define AG903_I2C_CR_STARTIEN_BIT	(1<<AG903_IICn_CR_STARTI_EN_POS)	/** IICnCR STARTI_EN-bit */
#define AG903_I2C_CR_ALIEN_BIT		(1<<AG903_IICn_CR_ALI_EN_POS)		/** IICnCR ALI_EN-bit */
#define AG903_I2C_CR_SAMIEN_BIT		(1<<AG903_IICn_CR_SAMI_EN_POS)		/** IICnCR SAMI_EN-bit */
#define AG903_I2C_CR_STOPIEN_BIT	(1<<AG903_IICn_CR_STOPI_EN_POS)		/** IICnCR STOPI_EN-bit */
#define AG903_I2C_CR_BERRIEN_BIT	(1<<AG903_IICn_CR_BERRI_EN_POS)		/** IICnCR BERRI_EN-bit */
#define AG903_I2C_CR_DRIEN_BIT		(1<<AG903_IICn_CR_DRI_EN_POS)		/** IICnCR DRI_EN-bit */
#define AG903_I2C_CR_DTIEN_BIT		(1<<AG903_IICn_CR_DTI_EN_POS)		/** IICnCR DTI_EN-bit */
#define AG903_I2C_CR_TBEN_BIT		(1<<AG903_IICn_CR_TB_EN_POS)		/** IICnCR TB_EN-bit */
#define AG903_I2C_CR_ACKNACK_BIT	(1<<AG903_IICn_CR_NACK_POS)			/** IICnCR NACK-bit */
#define AG903_I2C_CR_STOP_BIT		(1<<AG903_IICn_CR_STOP_POS)			/** IICnCR STOP-bit */
#define AG903_I2C_CR_START_BIT		(1<<AG903_IICn_CR_START_POS)		/** IICnCR START-bit */
#define AG903_I2C_CR_GCEN_BIT		(1<<AG903_IICn_CR_GC_EN_POS)		/** IICnCR GC_EN-bit */
#define AG903_I2C_CR_SCLEN_BIT		(1<<AG903_IICn_CR_SCL_EN_POS)		/** IICnCR SCL_EN-bit */
#define AG903_I2C_CR_I2CEN_BIT		(1<<AG903_IICn_CR_I2C_EN_POS)		/** IICnCR I2C_RST-bit */
#define AG903_I2C_CR_I2CRST_BIT		(1<<AG903_IICn_CR_I2C_RST_POS)		/** IICnCR I2C_EN-bit */

/* IICnCR ݐrbg */
#define AG903_I2C_CR_ALLINT_BIT		(AG903_I2C_CR_STARTIEN_BIT|AG903_I2C_CR_ALIEN_BIT|AG903_I2C_CR_SAMIEN_BIT|AG903_I2C_CR_STOPIEN_BIT|AG903_I2C_CR_BERRIEN_BIT|AG903_I2C_CR_DRIEN_BIT|AG903_I2C_CR_DTIEN_BIT)

/* IICnCR 쐧rbg */
#define AG903_I2C_CR_ALLCTRL_BIT	(AG903_I2C_CR_TBEN_BIT|AG903_I2C_CR_ACKNACK_BIT|AG903_I2C_CR_STOP_BIT|AG903_I2C_CR_START_BIT|AG903_I2C_CR_GCEN_BIT|AG903_I2C_CR_SCLEN_BIT|AG903_I2C_CR_I2CEN_BIT)

#define AG903_I2C_SR_SAL_BIT		(1<<AG903_IICn_SR_SAL_POS)		/** IICnSR SAL-bit */
#define AG903_I2C_SR_DDA_BIT		(1<<AG903_IICn_SR_DDA_POS)		/** IICnSR DDA-bit */
#define AG903_I2C_SR_ARA_BIT		(1<<AG903_IICn_SR_ARA_POS)		/** IICnSR ARA-bit */
#define AG903_I2C_SR_RESUME_BIT		(1<<AG903_IICn_SR_RESUME_POS)	/** IICnSR RESUME-bit */
#define AG903_I2C_SR_SUSPEND_BIT	(1<<AG903_IICn_SR_SUSPEND_POS)	/** IICnSR SUSPEND-bit */
#define AG903_I2C_SR_ALERT_BIT		(1<<AG903_IICn_SR_ALERT_POS)	/** IICnSR ALERT-bit */
#define AG903_I2C_SR_TOUTMAX_BIT	(1<<AG903_IICn_SR_TOUTMax_POS)	/** IICnSR TOUTMax-bit */
#define AG903_I2C_SR_TOUTMIN_BIT	(1<<AG903_IICn_SR_TOUTMin_POS)	/** IICnSR TOUTMin-bit */
#define AG903_I2C_SR_MEXT_BIT		(1<<AG903_IICn_SR_MEXT_POS)		/** IICnSR MEXT-bit */
#define AG903_I2C_SR_SEXT_BIT		(1<<AG903_IICn_SR_SEXT_POS)		/** IICnSR SEXT-bit */
#define AG903_I2C_SR_START_BIT		(1<<AG903_IICn_SR_START_POS)	/** IICnSR START-bit */
#define AG903_I2C_SR_AL_BIT			(1<<AG903_IICn_SR_AL_POS)		/** IICnSR AL-bit */
#define AG903_I2C_SR_GC_BIT			(1<<AG903_IICn_SR_GC_POS)		/** IICnSR GC-bit */
#define AG903_I2C_SR_SAM_BIT		(1<<AG903_IICn_SR_SAM_POS)		/** IICnSR SAM-bit */
#define AG903_I2C_SR_STOP_BIT		(1<<AG903_IICn_SR_STOP_POS)		/** IICnSR STOP-bit */
#define AG903_I2C_SR_BERR_BIT		(1<<AG903_IICn_SR_BERR_POS)		/** IICnSR BERR-bit */
#define AG903_I2C_SR_DR_BIT			(1<<AG903_IICn_SR_DR_POS)		/** IICnSR DR-bit */
#define AG903_I2C_SR_DT_BIT			(1<<AG903_IICn_SR_DT_POS)		/** IICnSR DT-bit */
#define AG903_I2C_SR_BB_BIT			(1<<AG903_IICn_SR_BB_POS)		/** IICnSR BB-bit */
#define AG903_I2C_SR_I2CB_BIT		(1<<AG903_IICn_SR_I2CB_POS)		/** IICnSR I2CB-bit */
#define AG903_I2C_SR_ACK_BIT		(1<<AG903_IICn_SR_ACK_POS)		/** IICnSR ACK-bit */
#define AG903_I2C_SR_RW_BIT			(1<<AG903_IICn_SR_RW_POS)		/** IICnSR RW-bit */

void AG903_I2CPrmResetController(uint8_t ch);
void AG903_I2CPrmGetResetStatus(uint8_t ch, uint8_t* status);
void AG903_I2CPrmSetControl(uint8_t ch, uint32_t setbit);
void AG903_I2CPrmClearControl(uint8_t ch, uint32_t clrbit);
void AG903_I2CPrmGetStatus(uint8_t ch, uint32_t* status);
void AG903_I2CPrmWriteData(uint8_t ch, uint8_t data);
void AG903_I2CPrmReadData(uint8_t ch, uint8_t* data);
void AG903_I2CPrmSetClockDivision(uint8_t ch, uint32_t cdr);
void AG903_I2CPrmSetGlitchSuppression(uint8_t ch, uint16_t tsr, uint8_t gsr);
void AG903_I2CPrmSetExtAddrMode(uint8_t ch);
void AG903_I2CPrmClearExtAddrMode(uint8_t ch);
void AG903_I2CPrmSetSlaveAddr(uint8_t ch, uint16_t saddr);

#ifdef __cplusplus
}
#endif
#endif /* _I2CPRM_H_ */
